// *******************************************************************
// M_HOME26.POV                                            21 Oct 2001
// Modernist_Home: new Beauty Shot: re-tuned model:
// *******************************************************************

#version 3.1;

// *******************************************************************
// Control Variables: 
//    turning some of these off = many "not 2 objs in csg" messages
// *******************************************************************

#declare ShowDetails = 0;    // 0=some,   1=full 
#declare GridOn      = 0;    // 0=hide,   1=show
#declare ShowLights  = 0;    // 0=day,    1=night
#declare ShowFloor   = 1;    // 0=hide,   1=show
#declare ShowGlass   = 0;    // 0=hide,   1=show
#declare ShowArch    = 0;    // 0=hide,   1=show
#declare DoorOpen    = 0;    // 0=closed, 1=open
#declare ShowRails   = 0;    // 0=hide,   1=show
#declare DayLight    = 1;    // 0=nite,   1=day

#include "m_home00.inc"      // declarations specific to Modernist_House

global_settings { assumed_gamma 1.0 
                  max_trace_level 10 }

// *******************************************************************
// LIGHTS! ( and Sky and Background )
// *******************************************************************

#if ( DayLight = 0 )
   background { color Black }             // nite
#else
   background { color LightBlue }         // day

   #declare LightLocate = <  80, 100, -160 >; //SE
//   #declare LightLocate = <  80, 100,  150 >; //NE
//   #declare LightLocate = < -80, 100, -150 >; //SW
//   #declare LightLocate = < -80, 100,  150 >; //NW

   #declare intensity = 1;

   #if ( ShowDetails = 0 )
      light_source { LightLocate  color White }
   #else
      light_source { LightLocate  color White }
/*
      sky_sphere { pigment { Bright_AquaBlue4  
                             scale < 65, 2, 15 >
                           }//end pigmnt
                 }//end day sky
      light_source {
         < 0, 0, 0 >                      // position (translated below)
         color rgb 1.0                    // color
         area_light < 2,0,0 > < 0,0,2 >   // light's spread
         2, 2                             // total number of lights
         adaptive 0                       // 0,1,2,3... 
         jitter                           // random softening
         translate LightLocate            // location of light
                } // end area light
*/
   #end
#end

// *******************************************************************
// CAMERA!
// *******************************************************************

#declare Beauty_Shot =
camera {
   direction < 0, 0, 7 >
   location  < -5, 6, -200 >           // SW of center
   look_at   < 0, 6, 0 > }      

#declare Camera_North =
camera {
   direction < 0, 0, 2 >
   location  < 30, 6, 200 >          // north of east rm cntr
   look_at   < 30, 6, 0 > }

#declare Camera_South =
camera {
   direction < 0, 0, 8 >
   location  < 0, 50, -180 >            // south of cntr
   look_at   < 0, 12, 0 > }

#declare Camera_East =
camera {
   direction < 0, 0, 2 >
   location  < 170, 66, 0 >             // East of center
   look_at   <   0, 16, 0 > }

#declare Camera_West =
camera {
   direction <    0, 0, 2 >
   location  < -100, 100, 0 >          // west
   look_at   <  40,  10, 0 > }

#declare Camera_SW =
camera {
   direction < 0, 0, 2 >
   location  < -70, 50, -70 >          // SW of center
   look_at   < 0, 0, 0 > }             

#declare Camera_SE =
camera {
   direction < 0, 0, 2 >
   location  < 60, 36, -180 >           // SE of center
   look_at   <  0, 16, 0 > }

#declare Camera_Above =
camera {         
   direction < 0,   0, 3 >
   location  < 0, 200, 0 >             // Above: dir 2, +200y
   look_at   < 0,   0, 0.1 > }         //  shows 150x 100z area

#declare Camera_Quarter =
camera { 
   direction < 0, 0, 5 >
   location  < 90, 70, -100 >           // SE and above 
   look_at   < 0, 0, 0 > }             

// *******************************************************************
// *******************************************************************

#declare MoveX = -12.5; 
#declare MoveY = 0;
#declare MoveZ = 0;

//camera { Beauty_Shot    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_North   translate < MoveX, MoveY, MoveZ > }
camera { Camera_South   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_East    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_West    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SW      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SE      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Above   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Quarter translate < MoveX, MoveY, MoveZ > }

// *******************************************************************
// Describe the set:
// *******************************************************************

//    DEFINE   a bathroom:
#declare Bathroom_1 =
union {
   //frames:
   union {
      object { CubeY1  
               scale < 1, 12, 1 >  translate < 7.5, 0, 0 > }
      object { CubeX1
               scale < 14, 1, 1 >  translate < 0, 6, 0 > }
      #if ( ShowDetails = 0 )
         texture { Red_Tex }
      #else
         texture { T_Wood2 scale < 2, 4, 2 > }
      #end
         }//end frames
   //door:
   object { DoorA2  translate < 6, -2.5, 0 > }

/*
   //wall: facing south:
   difference {
      box { < -7.2, -6.1, -0.25 > < 7.5, 6.2, 0.25 > }
      box { < -1.5, -3.5, -1.00 > < 1.5, 3.5, 1.00 > 
            translate < 5.5, -2.5, 0 > }
      #if ( ShowDetails = 0 )
         texture { DarkWood_Tex }
      #else
         texture { DarkWood_Tex }//change later! <<
      #end
              }//end diff. south wall

   //wall: facing east:
   box { < -0.25, -6.2, -5.0 > < 0.25, 6.2, 5.0 >
         translate < 7.5, 0, -5 >
      #if ( ShowDetails = 0 )
         texture { DarkWood_Tex }
      #else
         texture { DarkWood_Tex }//change later! <<
      #end
       }//end east wall

   //tub:
   object {
      difference {
      object {
         #declare RB_P1 = <  4,  1.5,  2 >; // right upper rear corner
         #declare RB_P2 = < -4, -1.5, -2 >; // left lower front corner
         #include "roundbox.inc"              // calls file
             }//end body of tub
      object {
         #declare RB_P1 = <  3,  2.0,  1.5 >; // right upper rear corner
         #declare RB_P2 = < -3, -1.0, -1.5 >; // left lower front corner
         #include "roundbox.inc"              // calls file
             }//end basin of tub
      #if ( ShowDetails = 0 )
         texture { Yellow_Tex }
      #else
         texture { Yellow_Tex }//change later! <<
      #end
                 }//end diff.
      translate < 3.5, -4.5, -8 >
          } // end obj tub
*/
   //sink:
   //cabinet:
   //toilet:
     } // end bathroom

// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************
// **************************************************************
//       B.  North Room:
// **************************************************************

//    DEFINE  the North Room:
#declare North_Room =
union {
   //roof:
//   object { North_Roof scale < 1, 0.8, 1>  translate y*8 }

   //chimneys:
//   object { North_Chimneys }

   //north wall:
//   object { N_North_Frame_Up  translate <   5.0, 19, 17 > } //1st floor
//   object { N_North_Frame_Dn  translate < -12.5,  7, 17 > } //ground

   //south:
//   object { N_South_Frame_East  translate <    20, 19, -17.5 > } //1st floor
//   object { N_South_Frame_West  translate < -17.5, 19, -17.5 > } //1st floor
//   object { N_South_Frame_East  translate <    20,  7, -17.5 > } //ground
   object { N_South_Frame_West  translate < -17.5,  7, -17.5 > } //ground
//   object { N_South_Frame_Center  translate < 0, 19, -7.5 > } //1st floor

   //west:
   object { N_West_Frame  translate < -25, 19, 0 > } //1st floor
   object { N_West_Frame  translate < -25,  7, 0 > } //ground floor

   //east:optional
//   object { N_East_Frame    translate < 35, 19, 0 > } //1st floor

   //bathroom:
   object { Bathroom_1  translate < -17.5, 19, -7.5 > }


   #if ( ShowDetails = 1 )
      //north wall:
      object { N_North_Panel_Up  translate <   5.0, 19, 17 > } //1st floor
      object { N_North_Panel_Dn  translate < -12.5,  7, 17 > } //ground

      //south wall:
      object { N_South_Panel       translate <   -21,  6, -17.5 > } //both  
      object { N_South_Panel_Center  translate < 0, 19, -7.5 > } //1st floor

      //east wall:
      object { Window_Dome_1      translate < 34, 12, 0 > } //1st floor
      object { Window_Dome_Frame  translate < 34, 12, 0 > } //1st floor
// NOT needed      object { N_East_Panel    translate < 35, 19, 0 > }  //1st floor   
      object { N_East_Railing  translate < 35, 15, 16 > } //1st floor

      //west wall:
      object { N_West_Panel  translate < -25, 13, 0 > } //both floors

      //doors:
      object { M_Front_Door  rotate y*180 
                             translate <   5,  6, 17.0 > }//north door
      object { M_Front_Door  translate <   0,  6, -7.5 > }//south door
      object { DoorA1_Closed rotate y*90 
                             translate < -25,  5, 12.5 > } //west

      //stairs, railings:
      object { North_Stairs  translate < -5, 7.75, 7.5 > }
      #if ( ShowRails = 1 )
         object { Railing_Section_A ( 1.5, 0.25, 3 )
                  rotate y*90  translate < -10.0, 14.5, 12 > }//west 
         object { Railing_Section_A ( 1.5, 0.25, 3 )
                  rotate y*90  translate <  0.50, 14.5, 12 > }//east
         object { Railing_Section_A ( 1.5, 0.25, 2 )
                               translate < -9.25, 14.5,  0 > }//south
      #end
   #end  // show details?

   // floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1           // ground floor    
               texture { Brown_Tex }
               scale < 61, 1, 36 >  
               translate < 5, 0.5, 0 >
             }// end north ground floor
      object { Build_Block_1        //1st floor center:front of stairs
               texture { Tan_Tex }
               scale < 10, 0.5, 9 >
               translate < -5, 13, -3 >
             }// end 1st floor center
      object { Build_Block_1        //1st floor center:rear of stairs
               texture { Tan_Tex }
               scale < 10, 0.5, 5 >
               translate < -5, 13, 15 >
             }// end 1st floor center
      object { Build_Block_1        // 1st floor  west
               texture { Tan_Tex }
               scale < 15.5, 0.5, 35 >
               translate < -17.25, 13, 0 >
             }// end 1st floor west
/*
      object { Build_Block_1        // 1st floor east
               texture { Tan_Tex }
               scale < 25, 0.5, 35 >
               translate < 22.5, 13, 0 >
             }// end 1st floor east
      object { Build_Block_1        // 1st floor  center
               texture { Tan_Tex }
               scale < 10, 0.5, 25 >
               translate < 5, 13, 5 >
             }// end 1st floor center
*/
   #end // show floor?
      } // end north room union

// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************

//    DEFINE East Wing:
#declare East_Room =
union {
   //roof:
   object { East_Roof scale < 1, 0.8, 1 >  translate y*2 }
   //walls:
   object { E_South_Frame  translate < 30, 6,  31.0 > }//n
   object { E_South_Frame  translate < 30, 6, -39.5 > }//s
   object { E_East_Frame   translate < 51, 6, -34.5 > }
   object { E_West_Frame   translate < 10, 6,  10.0 > }

   #if ( ShowDetails = 1 ) //show maximum
      //walls:
      object { E_South_Panel  translate < 30, 6,  31.0 > }//n side
      object { E_South_Panel  translate < 30, 6, -39.5 > }//s side
      object { E_East_Panel   translate < 51, 6,  -5.0 > }
      object { E_West_Panel   translate < 10, 6,  24.5 > }
      #if ( ShowRails = 1 )
         //roof railings:
         object { Railing_Section_A ( 1.5, 0.25, 22 )
                     rotate y*90  translate < 53, 14,  30 > } //east 
         object { Railing_Section_A ( 1.5, 0.25, 13 )
                                  translate < 10, 14,  30 > } //north
         object { Railing_Section_A ( 1.5, 0.25, 12 )
                                  translate < 12, 14, -40 > } //south
      #end //show railings?
   #end  //of show all details?

   //floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1              
               texture { Brown_Tex }
               scale < 44, 1, 73 >
               translate < 30, 0.5, -4 >
             }// end east floor
   #end //if showfloor
      } // end east room union

// **************************************************************
// **************************************************************
//       D.  West Room: Kitchen:
// **************************************************************

//    DEFINE West Room:
#declare West_Room =
union {
   //roof:
   object { West_Roof  translate < -43, 21.5, -20 >
                       scale < 1, 0.6, 1 > }

   //ceiling lights:
   #if ( ShowLights = 1 )
      object { Lamp_B  translate < -49, 11, -20 > }
      object { Lamp_B  translate < -35, 11, -20 > }
   #end

   //walls: frames:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_East_Frame   translate < -25.0, 6, -20 > }
   object { W_West_Frame   translate < -60.0, 6, -20 > }

   #if ( ShowDetails = 1 )
      //walls: panels:
      object { W_North_Panel  translate < -36.5, 6,  -5 > }
      object { W_South_Panel  translate < -42.5, 6, -35 > }
      object { W_East_Panel   translate < -25.0, 6, -25 > }
      object { W_West_Panel   translate < -60.0, 6, -20 > }
      //kitchen:
      object { W_Kitchen      translate < -42.5, 1, -20 > }
      //door:
      object { M_Front_Door  translate < -53.75, 6, -5 > } //nw entrance
   #end  // of show details?

   //floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1
               scale < 36, 1, 31 >        
               translate < -42.5, 0.5, -20 >
               #if ( ShowDetails = 0 )
                  texture { Brown_Tex }
               #else
                  texture { Brown_Tex }
               #end
             }// end west floor
   #end //show floor?
      } // end west room union


// *******************************************************************
// *******************************************************************
//  IV.   a Modernist/International Style House:
// *******************************************************************
// *******************************************************************


//    DEFINE the whole building and setting:
#declare Modernist_Home =
union {
   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk  translate < 0, 0, -30 > }
   object { Arched_Hall_1   translate < 0, 5, -30 > }
   object { Planter_Box_3 (56, 1, -35, 0, 0, 8, 5) }
   object { Planter_Box_2  translate < -17, 1, -24 > } //front door
//   object { box { < -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
//            pigment { VeryDarkBrown } }
//            translate < -17, 1, -24 > }// end generic dirt
      } // end union modernist house


// *******************************************************************
// *******************************************************************


// *******************************************************************
// ACTION!  Define The Scene:
// *******************************************************************

//object { Modernist_Home }
object { North_Room }
//object { East_Room }
//object { West_Room }
//object { Front_SideWalk  translate < 0, 0, -30 > }
//object { Arched_Hall_1   translate < 0, 5, -30 > }
//Planter_Box_3 (56, 1, -35, 0, 0, 8, 5)

// GROUND:
//object { Clip_Floor }

// **************************************************************
// **************************************************************

// graph paper:
#if ( GridOn = 1 )
//   object { Grid10XY translate z*10 } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center
   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "
   //centered x,y: 
   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "
   //south -50z:
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
#end 

// *******************************************************************
// *******************************************************************
//    Michael Brendan Hurley, SDE, Ltd.       Fall 2000-Winter 2001
// *******************************************************************
