// *******************************************************************
// M_HOME10.POV                                               9 Dec 00
// Modernist_Home: Eastern elevation: various detailing tests:
// *******************************************************************

#version 3.1;

// *******************************************************************
// Control Variables: 
//    turning some of these off = many "not 2 objs in csg" messages
// *******************************************************************

#declare ShowDetails = 1;    // 0=minimum, 1=full 
#declare GridOn      = 1;    // 0=hide, 1=show
#declare ShowLights  = 0;    // 0=day, 1=night
#declare ShowFloor   = 1;    // 0=hide, 1=show
#declare ShowGlass   = 1;    // 0=hide, 1=show
#declare ShowArch    = 1;    // 0=hide, 1=show
#declare DoorOpen    = 0;    // 0=closed, 1=open
#declare ShowRails   = 1;    // 0=hide, 1=show

#include "m_home00.inc"      // declarations specific to Modernist_House

global_settings { assumed_gamma 1.0 }

// *******************************************************************
// LIGHTS!
// *******************************************************************

//#declare LightLocate = < 0, 850, 0 >;
#declare LightLocate = < 140, 150, -190 >;
#declare intensity = 1;

#if ( ShowDetails = 0 )
   light_source { LightLocate  color White }
#else
//   light_source { LightLocate  color White }

   light_source {
      0*x                              // position (translated below)
      color rgb 1.0                    // color
      area_light < 2,0,0 > < 0,0,2 >   // light's spread
      2, 2                             // total number of lights
      adaptive 0                       // 0,1,2,3... 
      jitter                           // random softening
      translate LightLocate            // location of light
             } // end area light

#end

// *******************************************************************
// Define Sky                                                        
// *******************************************************************

#if ( ShowDetails = 0 )
   background { color LightBlue }      // day
#else
   sky_sphere { pigment { Bright_AquaBlue4  
                          scale < 65, 2, 15 >
                        }//end pigmnt
              } //end day sky
   background { color LightBlue }  // temp test
#end

// *******************************************************************
// CAMERA!
// *******************************************************************

#declare Beauty_Shot =
camera {
   direction < 0, 0, 7 >
   location  < -5, 6, -200 >        // SW of center
   look_at   < 0, 6, 0 > }      

#declare Camera_North =
camera {
   direction < 0, 0, 2 >
   location  < 30, 100, 200 >         // north of east rm cntr
   look_at   < 30, 10, 0 > }

#declare Camera_South =
camera {
   direction < 0, 0, 2 >
   location  < 0, 100, -150 >          // south of cntr
   look_at   < 0, 0, 0 > }

#declare Camera_East =
camera {
   direction < 0, 0, 5 >
   location  < 300, 0, 0 >         // East of center
   look_at   < 0, 0, 0 > }

#declare Camera_West =
camera {
   direction <    0, 0, 2 >
   location  < -100, 100, 0 >          // west
   look_at   <  40,  10, 0 > }

#declare Camera_SW =
camera {
   direction < 0, 0, 2 >
   location  < -75, 50, -75 >          // SW of center
   look_at   < 0, 0, 0 > }             //eye level

#declare Camera_SE =
camera {
   direction < 0, 0, 3 >
   location  < 130, 40, -125 >         // SE of center
   look_at   <  30, 5, 10 > }

#declare Camera_Above =
camera {         
   direction < 0,   0, 2 >
   location  < 0, 400, 0 >             // Above: dir 2, +200y
   look_at   < 0,   0, 0.1 > }           //  shows 150x 100z area

#declare Camera_Quarter =
camera { 
   direction < 0, 0, 4 >
   location  < 50, 20, -120 >       // SE and above 
   look_at   < -40, 5, -10 > }             // center of scene

// *******************************************************************
// *******************************************************************

#declare MoveX = -15;
#declare MoveY = 0;
#declare MoveZ = 0;
//camera { Beauty_Shot    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_North   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_South   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_East    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_West    translate < MoveX, MoveY, MoveZ > }
//camera { Camera_SW      translate < MoveX, MoveY, MoveZ > }
camera { Camera_SE      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Above   translate < MoveX, MoveY, MoveZ > }
//camera { Camera_Quarter translate < MoveX, MoveY, MoveZ > }


// *******************************************************************
// Describe the set:
// *******************************************************************

// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************
// **************************************************************
//       B.  North Room:
// **************************************************************

//    DEFINE  the North Room:
#declare North_Room =
union {
   //roof:
   object { North_Roof }// roof                            
   //chimneys:
  object { North_Chimneys }
   //north wall:
   object { N_North_Frame_Up  translate <   5.0, 16, 17 > } //1st floor
   object { N_North_Frame_Dn  translate < -12.5,  6, 17 > } //ground
   //south:
   object { N_South_Frame_East  translate <    20, 16, -17.5 > } //1st floor
   object { N_South_Frame_West  translate < -17.5, 16, -17.5 > } //1st floor
   object { N_South_Frame_East  translate <    20,  6, -17.5 > } //ground
   object { N_South_Frame_West  translate < -17.5,  6, -17.5 > } //ground
   object { N_South_Frame_Center  translate < 0, 16, -7.5 > } //1st floor
   //west:
   object { N_West_Frame  translate < -25, 16, 0 > } //1st floor
   object { N_West_Frame  translate < -25,  6, 0 > } //ground floor

   //east: select one or the other, not both:
//   object { N_East_Frame    translate < 35, 16, -12.5 > } //1st floor???
   object { N_East_Railing  translate < 35, 13,  15 > } //1st floor

#if ( ShowDetails = 1 )
   //north wall:
   object { N_North_Panel_Up  translate <   5.0, 16, 17 > } //1st floor
   object { N_North_Panel_Dn  translate < -12.5,  6, 17 > } //ground
   //south wall:
   object { N_South_Panel       translate <   -21,  6, -17.5 > } //both  
   object { N_South_Panel_Center  translate < 0, 16, -7.5 > } //1st floor
   //east wall:
   object { Window_Dome_1      translate < 34, 11, 0 > } //1st floor
   object { Window_Dome_Frame  translate < 34, 11, 0 > } //1st floor
   //west wall:
   object { N_West_Panel  translate < -25, 16, 12.5 > } //both floors
   //doors:
   object { M_Front_Door rotate y*180 translate < 5, 6, 17 > }//north door
   object { M_Front_Door  translate < 0, 6, -7.5 > }//south door
//   object { DoorA1_Closed rotate y*90  translate < -25, 5, 12.5 > } //west
#end  // show details?

   // floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1           // ground floor    
               texture { Brown_Tex }
               scale < 61, 1, 36 >  
               translate < 5, 0.5, 0 >
             }// end north ground floor
 //     #if ( ShowDetails = 1 )
         object { Build_Block_1           // 1st floor  center
                  texture { Tan_Tex }
                  scale < 20, 0.5, 25 >
                  translate < 0, 11, 5 >
                }// end 1st floor center
         object { Build_Block_1           // 1st floor  west
                  texture { Tan_Tex }
                  scale < 16, 0.5, 35 >
                  translate < -17, 11, 0 >
                }// end 1st floor west
         object { Build_Block_1           // 1st floor east
                  texture { Tan_Tex }
                  scale < 25, 0.5, 35 >
                  translate < 22.5, 11, 0 >
                }// end 1st floor east
 //     #end  // show details? loop
   #end // show floor?
      } // end north room union

// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************

//    DEFINE East Wing:
#declare East_Room =
union {
   //roof:
   object { East_Roof }
   //walls:
   object { E_South_Frame  translate < 30, 6,  31.0 > }//n
   object { E_South_Frame  translate < 30, 6, -39.5 > }//s
   object { E_East_Frame   translate < 51, 6, -34.5 > }
   object { E_West_Frame   translate < 10, 6,  10.0 > }

   #if ( ShowDetails = 1 ) //show maximum
      //walls:
      object { E_South_Panel  translate < 30, 6,  31.0 > }//n side
      object { E_South_Panel  translate < 30, 6, -39.5 > }//s side
      object { E_East_Panel   translate < 51, 6,  -5.0 > }
      object { E_West_Panel   translate < 10, 6,  24.5 > }
      #if ( ShowRails = 1 )
         //roof railings:
         object { Railing_Section_A ( 1.5, 0.25, 22 )
                     rotate y*90  translate < 53, 12.5,  30 > } //east 
         object { Railing_Section_A ( 1.5, 0.25, 11 )
                                  translate < 15, 12.5,  30 > } //north
         object { Railing_Section_A ( 1.5, 0.25, 11 )
                                  translate < 15, 12.5, -40 > } //south
      #end //show railings?
   #end  //of show all details?

   //floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1              
               texture { Brown_Tex }
               scale < 42, 1, 73 >
               translate < 30, 0.5, -4 >
             }// end east floor
   #end //if showfloor
      } // end east room union

// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE West Wing:
#declare West_Room =
union {
   //roof:
   object { West_Roof  translate < -43, 11, -22 > }
   //kitchen:
   object { W_Kitchen  translate < -42.5, 1, -20 > }
   //walls:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_East_Frame   translate < -25.0, 6, -20 > }
   object { W_West_Frame   translate < -60.0, 6, -20 > }

#if ( ShowDetails = 1 )
   //walls:
   object { W_North_Panel  translate < -36.5, 6,  -5 > }
   object { W_South_Panel  translate < -42.5, 6, -35 > }
   object { W_East_Panel   translate < -25.0, 6, -25 > }
   object { W_West_Panel   translate < -60.0, 6, -20 > }
   //door:
   object { M_Front_Door  translate < -50, 4, -5 > } //nw entrance
   //floor:
#end  // of show details?

#if ( ShowFloor = 1 )
   object { Build_Block_1
            texture { Brown_Tex }
            scale < 36, 1, 31 >        
            translate < -42.5, 0.5, -20 >
          }// end west floor
#end //show floor?
      } // end west room union

// *******************************************************************
//       F.  Our_House in the Modernist/International style:
// *******************************************************************

//    DEFINE the whole building and setting:
#declare Modernist_Home =
union {
   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk  translate < 0, 0, -30 > }

   object { Arched_Hall_1   translate < 0, 5, -30 > }

   object { Planter_Box_3 } //east side
/*
   object { Planter_Box_2  translate < -17, 1, -24 > } //front door
   object { box { < -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
            pigment { VeryDarkBrown } }
            translate < -17, 1, -24 > }// end generic dirt
*/
      } // end union modernist house

// *******************************************************************
// *******************************************************************


// *******************************************************************
// ACTION!  Define The Scene:
// *******************************************************************

object { Modernist_Home }
//object { North_Room }
//object { East_Room }
//object { West_Room }
//object { Front_SideWalk  translate < 0, 0, -30 > }
//object { Arched_Hall_1   translate < 0, 5, -30 > }
//object { Planter_Box_3 }

// GROUND:
object { Clip_Floor }

// **************************************************************
// **************************************************************

// graph paper:
#if ( GridOn = 1 )
//   object { Grid10XY } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center
   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "
   //centered x,y: 
   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "
   //south -50z:
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
#end 

// *******************************************************************
// *******************************************************************
//    Michael Brendan Hurley, SDE, Ltd.                   Fall 2000
// *******************************************************************
