// *******************************************************************
// M_HOME07.POV                                              15 Nov 00
// Modernist_Home:  interior west from the east:
// *******************************************************************

#version 3.1;

// *******************************************************************
// Control Variables: 
//     turning some of these off = many "2 objs in csg" messages
// *******************************************************************

#declare ShowDetails = 1;    // 0=minimum detail, 1=full detail 
#declare GridOn      = 1;    // 0=off, 1=on
#declare ShowLights  = 0;    // 0=day, 1=night
#declare ShowFloor   = 1;    // 0=no, 1=yes
#declare ShowGlass   = 1;    // 0=no, 1=yes
#declare ShowArch    = 1;    // 0=no, 1=yes
#declare DoorOpen    = 0;    // 0=closed, 1=open

#include "m_home00.inc"      // declarations specific to Modernist_House

global_settings { assumed_gamma 1.0 }

// *******************************************************************
// Define Ambient Lights                                             
// *******************************************************************

#declare LightLocate = < 140, 150, -190 >;
#declare intensity = 1;

#if ( ShowDetails = 0 )
   light_source { LightLocate  color White }
#else
   light_source {
      0*x                              // position (translated below)
      color rgb 1.0                    // color
      area_light < 2,0,0 > < 0,0,2 >   // light's spread
      2, 2                             // total number of lights
      adaptive 0                       // 0,1,2,3... 
      jitter                           // random softening
      translate LightLocate            // location of light
             } // end area light
#end

// *******************************************************************
// Define Sky                                                        
// *******************************************************************

#if ( ShowDetails = 0 )
   background { color LightBlue }      // day
#else
   sky_sphere { pigment { Bright_AquaBlue4  
                          scale < 65, 2, 15 >
                        }//end pigmnt
              } //end day sky
   background { color LightBlue }  // temp test
#end

// *******************************************************************
// Define Camera
// *******************************************************************

#declare Camera_SE =
camera {
   direction < 0, 0, 2 >
   location  < 55, 50, -125 >         // SE of center
   look_at   < -15, 10, 0 > }

#declare Camera_East =
camera {
   direction < 0, 0, 4 >
   location  <  100, 5, -20 >         // East of center
   look_at   < -150, 5, -20 > }

// *******************************************************************
//  Define Test Scene:
// *******************************************************************

// CAMERA:
#declare MoveX = 0;
#declare MoveY = 0;
#declare MoveZ = 0;
camera { Camera_SE      translate < MoveX, MoveY, MoveZ > }
//camera { Camera_East    translate < MoveX, MoveY, MoveZ > }

// FLOOR:
object { Clip_Floor }

// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************

// **************************************************************
//       B.  North Room:
// **************************************************************

//    DEFINE  the North Room:
#declare North_Room =
union {
   //roof:
 object { North_Roof }// roof                            
   //chimneys:
 object { North_Chimneys }
   //north wall:
   object { N_North_Frame_Up  translate <   0.0, 16, 17 > } //1st floor
   object { N_North_Frame_Dn  translate < -17.5,  6, 17 > } //ground
   //south:
   object { N_South_Frame_East  translate <    20, 16, -17.5 > } //1st floor
   object { N_South_Frame_West  translate < -17.5, 16, -17.5 > } //1st floor
   object { N_South_Frame_East  translate <    20,  6, -17.5 > } //ground
   object { N_South_Frame_West  translate < -17.5,  6, -17.5 > } //ground
   object { N_South_Frame_Center  translate < 0, 16, -7.5 > } //1st floor
   //west:
   object { N_West_Frame  translate < -25, 16, 0 > } //1st floor
   object { N_West_Frame  translate < -25,  6, 0 > } //ground floor
   //east:
   object { N_East_Frame  translate < 35, 16, -12.5 > } //1st floor

#if ( ShowDetails = 1 )
   //north wall:
   object { N_North_Panel_Up  translate <   5.0, 16, 17 > } //1st floor
   object { N_North_Panel_Dn  translate < -12.5,  6, 17 > } //ground
   //south wall:
   object { N_South_Panel       translate <   -21,  6, -17.5 > } //both  
   object { N_South_Panel_Center  translate < 0, 16, -7.5 > } //1st floor
   //east wall:
   object { N_East_Panel  translate < 35, 16,  12.5 > } //1st floor
   //west wall:
   object { N_West_Panel  translate < -25, 16, 12.5 > } //both floors
   //doors:
   object { M_Front_Door rotate y*180 translate < 5, 6, 17 > }//north door
   object { M_Front_Door  translate < 0, 6, -7.5 > }//south door
   object { DoorA1_Closed rotate y*90  translate < -25, 5, 12.5 > } //west
#end  // show details?

   // floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1           // 1st floor  center
               texture { Tan_Tex }
               scale < 20, 0.5, 25 >
               translate < 0, 11, 5 >
             }// end 1st floor center
      object { Build_Block_1           // 1st floor  west
               texture { Tan_Tex }
               scale < 16, 0.5, 35 >
               translate < -17, 11, 0 >
             }// end 1st floor west
      object { Build_Block_1           // 1st floor east
               texture { Tan_Tex }
               scale < 25, 0.5, 35 >
               translate < 22.5, 11, 0 >
             }// end 1st floor east
      object { Build_Block_1           // ground floor    
               texture { Brown_Tex }
               scale < 61, 1, 36 >  
               translate < 5, 0.5, 0 >
             }// end north ground floor
   #end // show floor?
      } // end north room union

// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************

//    DEFINE East Wing:
#declare East_Room =
union {
   //roof:
   object { East_Roof }
   //walls:
   object { E_South_Frame  translate < 28.5, 6,    31 > }//n
   object { E_South_Frame  translate < 28.5, 6, -39.5 > }//s
   object { E_East_Frame   translate < 46.0, 6, -34.5 > }
   object { E_West_Frame   translate < 10.5, 6,     6 > }

#if ( ShowDetails = 1 ) //show maximum
   //roof railings:
   object { Railing_Section_A ( 1.5, 0.25, 22 )
            rotate y*90  translate < 46, 12.5,  30 > } //east 
   object { Railing_Section_A ( 1.5, 0.25, 9 )
                         translate < 14, 12.5,  30 > } //north
   object { Railing_Section_A ( 1.5, 0.25, 9 )
                         translate < 14, 12.5, -40 > } //south
   //walls:
   object { E_South_Panel  translate < 28.5, 6,  31.0 > }//n side
   object { E_South_Panel  translate < 28.5, 6, -39.5 > }//s side
   object { E_East_Panel   translate < 46.0, 6,  -5.0 > }
#end  //of show all details?

   //floor:
#if ( ShowFloor = 1 )
   object { Build_Block_1              
            texture { Brown_Tex }
            scale < 37, 1, 73 >
            translate < 28.5, 0.5, -4 >
          }// end east floor
#end //if showfloor
      } // end east room union

// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE West Wing:
#declare West_Room =
union {
   //roof:
   object { West_Roof  translate < -43, 11, -22 > }
   //kitchen:
//   object { W_Kitchen  translate < -42.5, 1, -20 > }
   //walls:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_West_Frame   translate < -60.0, 6, -20 > }
   object { W_East_Frame   translate < -25.0, 6, -20 > }

#if ( ShowDetails = 1 )
   //walls:
   object { W_North_Panel  translate < -36.5, 6,  -5 > }
   object { W_South_Panel  translate < -42.5, 6, -35 > }
   object { W_West_Panel   translate < -60.0, 6, -20 > }
   object { W_East_Panel   translate < -25.0, 6, -25 > }
   //door:
   object { M_Front_Door  translate < -50, 4, 0 > }
   //floor:
#end  // of show details?

#if ( ShowFloor = 1 )
   object { Build_Block_1
            texture { Brown_Tex }
            scale < 36, 1, 31 >        
            translate < -42.5, 0.5, -20 >
          }// end west floor
#end //show floor?
      } // end west room union

// *******************************************************************
//       F.  Our_House in the Modernist/International style:
// *******************************************************************

//    DEFINE the whole building and setting:
#declare Modernist_Home =
union {
   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk  translate < 0, 0, -30 > }

   object { Arched_Hall_1   translate < 0, 5, -30 > }

   object { Planter_Box_2  translate < -17, 1, -24 > }
   object { box { < -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
            pigment { VeryDarkBrown } }
            translate < -17, 1, -24 > }// end generic dirt
      } // end union modernist house

// ************************************************************** 
// **************************************************************


object { Modernist_Home }


// **************************************************************
// **************************************************************

#if ( GridOn = 1 )
//   object { Grid10XY } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center
   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "
   //centered x,y: 
   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "
   //south -50z:
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "
#end 

// *******************************************************************
// *******************************************************************
//    Michael Brendan Hurley, SDE, Ltd.                   Fall 2000
// *******************************************************************
