// *******************************************************************
// M_HOME07.INC           for POV WIN 3.1g           Ver 1.0 Fall 2000
//         Definitions of assorted basic objects and effects         
//            for draft  of  Modernist_House  version 1.0
// *******************************************************************
//
// INClude File "Sub-Contractors":
//
// RoundBox.inc for POV 3.0 and above
// (c) Philip Cowley (philip.cowley@totem.co.uk) 13/07/97
//
// Leaf & Tree macro for Pov-ray 3.1 & higher
// (c) 1999 Gilles Tran (tran@inapg.inra.fr)
//
// *******************************************************************


// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

#include "brendan.inc"                 // universal scene objects
                                       // and calls to support INC's

// *******************************************************************
// *******************************************************************
// II.     DEFINE Structural Components
// *******************************************************************
// *******************************************************************
//    A.   Basic Objects
// **************************************************************

//    DEFINE  a torus for pillars
#declare Torus_1 =
torus { 0.5,       // MAJOR = radius of whole ring
        0.2        // MINOR = radius of tube
      } // end torus 1

// **************************************************************

//    DEFINE  generic scalable building block: 1x 1y 1z:
#declare Build_Block_1 =
box { <-0.5, -0.5, -0.5>  < 0.5, 0.5, 0.5 > } // end bldg block 1

// ************************************************************** 

//    DEFINE  generic scalable building block: 2x 2y 2z:
#declare Build_Block_2 =
object {
   #declare RB_P1 = <  1,  1,  1 >;    // right upper rear corner
   #declare RB_P2 = < -1, -1, -1 >;    // left lower front corner
   #declare RB_Thickness = 1;          // assumes 1 if not defined
   #declare RB_Solid = 0;              // assumes "On" if not defined
   #include "roundbox.inc"             // calls file
      } // end bldg block 2

// **************************************************************

//    DEFINE  generic scalable cylinder with spherical ends:
#macro Round_Post_Y ( Post_Size_Y , Post_Size_X )
union {
   cylinder { Post_Size_Y*y, -(Post_Size_Y)*y, Post_Size_X open }//end cyl
   sphere { < 0,  Post_Size_Y, 0 >  Post_Size_X }//end top ball
   sphere { < 0, -Post_Size_Y, 0 >  Post_Size_X }//end bottom ball
      } // end union scalable post
#end // macro for y pillar

// **************************************************************
// **************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.7, 0.7, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 2

// **************************************************************

//    DEFINE   a large THICK arch/roof/barrel dome:
#declare BigArch_1 =
object { Arch_Z1  scale < 5, 4.75, 5 > } // end big arch v.1

// **************************************************************

//    DEFINE   a large THIN arch/roof/barrel dome:
#declare BigArch_2 =
object { Arch_Z2  scale < 10, 9.5, 5 > } // end big arch v.2

// **************************************************************

//    DEFINE  Interior of frame has rounded corners: roundbox.inc cut-out
#declare ArchWay_1 =
   difference {
   union {
      object { CubeY1
               scale < 2, 10, 2 >
               translate x*-5 
             } // end left
      object { CubeY1
               scale < 2, 10, 2 >
               translate x*5 
             } // end right
      object { CubeX1
               scale < 10.75, 3.25, 2 >
               translate y*5 
             } // end top
         }//inner frame union
   object {
      #declare RB_P1 = <  4.75,  5.25,  5 >;
      #declare RB_P2 = < -4.75, -5.25, -5 >;
      #declare RB_Thickness = 2;      //Assumes 1 if not defined
      #declare RB_Solid = 0;          //Assumes "On" if not defined
      #include "roundbox.inc"
      translate < 0, -0.25, 0 >
          } //end roundbox cut-out
              } // end difference arch way 1

// **************************************************************
// **************************************************************

//    DEFINE  scalable banisters/fensing/frames:
//            base post centered at <0,0,0>
//            other posts, railings translated +x +y

#macro Railing_Section_A ( How_Tall, How_Wide, How_Many )
   //declare local variables:
   #local Post_Size_Y = How_Tall; //duh...?
   #local Post_Size_X = How_Wide; //
   #local How_Many    = How_Many; //
   //call macro:
   union {
      #local P_Count = 0;
      #while ( P_Count <= How_Many )
         object {            
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            translate < (P_Count*(How_Tall*2)), 0, 0 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { pigment { Brass} }
            #end
                }//end all posts
         object {
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            rotate z*90
            translate < (P_Count*(How_Tall*2)+How_Tall), (How_Tall), 0 >
            #if ( ShowDetails = 0 )
               texture { Blue_Tex }
            #else
               texture { pigment { Brass} }
            #end
                }//end railings
         #if ( P_Count = How_Many )
            object {           //last post:
               Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
               translate < (P_Count*(How_Tall*2))+(How_Tall*2), 0, 0 >
               #if ( ShowDetails = 0 )
                  texture { Red_Tex }
               #else
                  texture { pigment { Brass} }
               #end
                   }//end add last post
         #end
         #declare P_Count = ( P_Count + 1 );
      #end //while loop
         } // end union scalable railing
 #end // macro for railing section

// *******************************************************************
//    B.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x / 10y units
#declare Frame_A =
union {
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0,  5, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0, -5, 0 > }
      } // end Frame A

// **************************************************************

//    DEFINE  rotated frame:
#declare rotated_Frame_A =
object { Frame_A  rotate y*90 }

// **************************************************************

//   DEFINE   a frame 10x / 10y units: thicker beams:
#declare Frame_A2 =
union {
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate < -5, 0, 0 > }
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate <  5, 0, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0,  5, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0, -5, 0 > }
      } // end Frame A2

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 0.5, 2.75, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 0.5, 2.75, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y 0.5z:
#declare Frame_D =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  5, 0 > }
      } // end Frame D

// **************************************************************

//   DEFINE   thicker version of D, 5x 10y 1z:
#declare Frame_D2 =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale <  5, 1, 1 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale <  5, 1, 1 >  translate < 0,  5, 0 > }
      } // end Frame D 2

// *******************************************************************
//    C.   Frames: Single: Window:
// *******************************************************************

// *******************************************************************
//    D.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10.5x 10.5y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5.25, 5.25, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10.5x 5.5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5.25, 2.75, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10.5x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5.25, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 6x 10.5y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 3, 5.5, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5.5x 5.5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.75, 2.75, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5.5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.75, 1.25, 0.25 > } // end panel f

// *******************************************************************
//    E.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// *******************************************************************
//    F.   Front Yard & Landscaping:
// *******************************************************************

#include "l_scape.inc"                 // landscaping
 
// *******************************************************************
// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************
//       A.  Specialized Components:
// **************************************************************

//    DEFINE  front hall with arched roof: 20x 20y 40z:
#declare Arched_Hall_1 =
union {
   #declare Move_Count = 1;       // start count
   #declare From_Z = -25;         // from where? >>REQUIRES HARD CODING<<
   #declare Move_It = +10.5;      // how far? 
   #declare Max_Count = 4;        // how many?

   #while ( Move_Count <= Max_Count )

      object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < 10, 0.5, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Green_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs east
      object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < -10, 0.5, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Yellow_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs west

      #if ( ShowArch = 1 )   //display entry barrel roof

      object { Arch_Z2 
               scale < 10, 9.5, 1 >
               translate < 0, 6.5, (From_Z + Move_It-5) >
               #if ( ShowDetails = 0 )
                  texture { Red_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end arch frames

         #if ( Move_Count < Max_Count ) //skip northmost section
         object { BigArch_2 
                  translate < 0, 6.5, (From_Z + Move_It) >
                  #if ( ShowDetails = 0 )
                     texture { Magenta_Tex }
                  #else
                     texture { T_Glass1 }
                  #end // texture choices
                }//end barrel roof
         #end // if < Max Count
      #end // if Show Arch

      #declare From_Z = ( From_Z + Move_It ); 
      #declare Move_Count = Move_Count + 1;
   #end//of while loop
      } // end union arched hallway

// **************************************************************

//    DEFINE a sidewalk/driveway:
#declare Front_SideWalk =
object { UnitBox
         scale < 10, 0.5, 22 >
         translate < 0, 0.6, 0 >
         #if ( ShowDetails = 0 )
            texture { Coral_Tex }
         #else
            texture { T_Stone2  scale < 1, 1, 5 > }
         #end
       } // end sidewalk

// *******************************************************************
// *******************************************************************

//   DEFINE   basic door frame inset for 10x 10y Frame_A
#declare Frame_Door_A1 =
union {
   object { CubeY1                                        
            scale < 1.5, 8, 1.5 >  translate < -2.25, -1, 0 > }
   object { CubeY1                                       
            scale < 1.5, 8, 1.5 >  translate <  2.25, -1, 0 > }
   object { CubeX1                                        
            scale < 10, 1.5, 1.5 >  translate < 0, 3, 0 > }
   #if ( ShowDetails = 0 )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end Frame for Door  A1

// **************************************************************

//   DEFINE  a 4x 7y door: CLOSED
#declare DoorA1_Closed =
union {
   difference {
      object { UnitBox
               scale < 2, 3.8, 0.10 >
             }//end main panel
      object { UnitBox
               scale < 1.25, 0.4, 1 >
               translate y*1
             }//end cut-out bottom
      object { UnitBox
               scale < 1, 0.3, 1 >
               translate < 0.25, 2.1, 0 >
             }//end cut-out
      object { UnitBox
               scale < 0.75, 0.2, 1 >
               translate < 0.5, 3, 0 >
             }//end cut-out
               #if ( ShowDetails = 0 )
                  texture { Gray50_Tex }
               #else
                  texture { EMBWood1  scale < 2, 11, 2 > }
               #end
              }//end difference
   object { UnitBox 
            scale < 1.4, 1.65, 0.02 >
            translate < 0, 1.9, 0 > 
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               #if ( ShowGlass = 0 )
                  texture { Black_Tex }
               #else  
                  texture { T_Glass1 }
               #end
            #end
          } //end window glass
   object { sphere { <0, 0, 0>  0.25 }
            translate < -1.5, -0.5, -0.19 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { Bright_Bronze }
            #end
          }//end knob
      }//end union door 1a closed

// **************************************************************

//   DEFINE  a 4x 7y door: OPEN
#declare DoorA1_Open =
object { DoorA1_Closed
         rotate y*-45
         translate < -0.75, 0, -1.5 >
       } // end Door A1 open

// **************************************************************

//   DEFINE  set of solid wall panels scaled for Door_Front
#declare Panel_Door_A1 =
union {
   object { UnitBox
            scale < 5, 1, 0.25 >  translate < 0, 4.25, 0 >
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { T_MBH_Brick_1  scale < 4, 1, 4 > }
            #end
          }//upper brick panel
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate < -3.5, -1, 0 > 
          }//left glass
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate <  3.5, -1, 0 > 
          }//right glass
      } // end Panels New Door A1

// **************************************************************

//    DEFINE  a front door:
#declare M_Front_Door =
union {
   //frames & panels:
   object { Frame_A2
            #if ( ShowDetails = 0 )
               texture { Red_Tex }
            #else
               texture { T_Wood2  scale < 1, 5, 1 > }
            #end
          } //south front frame
   object { Panel_Door_A1 } //south front panels
   //door:
   object { Frame_Door_A1 } // door jams
   #if ( DoorOpen = 0 )
      object { DoorA1_Closed  translate y*-1.2 }
   #else
      object { DoorA1_Open  translate y*-1.2 }
   #end
      }//end door union

// **************************************************************
//       B.  North Room:
// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

// *******************************************************************
//       F.  a Modernist/International-style House:
// *******************************************************************

/*
#declare Modernist_Home =
union {
   //the building:
   object { North_Room }
   object { East_Room }
   object { West_Room }
   object { Arched_Hall_1
            translate < 0, 5, -30 >
          }// end arched hallway
   //the landscaping:
   object { Front_SideWalk
            translate z*-20 }
   object { Planter_Box_2  translate < -17.5, 1, -23.5 > }
   object { 
      box {< -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
           pigment { VeryDarkBrown } }
      translate < -17.5, 1, -22.5 >
          }// end generic dirt
      } // end union modernist house
*/

// *******************************************************************
// *******************************************************************
//    M_HOME07.INC    (c) Michael Brendan Hurley   Summer-Fall 2000
//    www.geocities.com/mbrendanh/                 mbhcgc@saber.net
// *******************************************************************
// *******************************************************************
