// *******************************************************************
// M_HOME02.POV                                               9 Nov 00
// Modernist_Home:  Quick_color frames & floors: eye-level shot:
// *******************************************************************

#version 3.1;

// *******************************************************************
// Control Variables:
// *******************************************************************

#declare ShowDetails = 0;    // 0=minimum detail, 1=full detail 
#declare GridOn      = 1;    // 0=off, 1=on
#declare Seams       = 0;    // 0=hide, 1=show "board effect" on floors
#declare ShowLights  = 0;    // 0=day, 1=night
#declare ShowFloor   = 1;    // 0=no, 1=yes
#declare ShowGlass   = 0;    // 0=no, 1=yes
#declare ShowArch    = 0;    // 0=no, 1=yes
#declare DoorOpen    = 0;    // 0=closed, 1=open

#include "m_home00.inc"      // declarations specific to Modernist_House

global_settings { assumed_gamma 1.0 }

// *******************************************************************
// Define Ambient Lights                                             
// *******************************************************************

#declare LightLocate = < 130, 150, -200 >;
#declare intensity = 1;

#if ( ShowDetails = 1 )
//   light_source { LightLocate  color White }
   light_source {
      0*x                              // position (translated below)
      color rgb 1.0                    // color
      area_light < 2,0,0 > < 0,0,2 >   // light's spread
      2, 2                             // total number of lights
      adaptive 0                       // 0,1,2,3... 
      jitter                           // random softening
      translate LightLocate            // location of light
             } // end area light
#else
   light_source { LightLocate  color White }
#end

// *******************************************************************
// Define Sky                                                        
// *******************************************************************

#if ( ShowDetails = 0 )
   background { color LightBlue }      // day
#else
   sky_sphere { pigment { Bright_AquaBlue4  
                          scale < 65, 2, 15 >
                        }//end pigmnt
              } //end day sky
   background { color LightBlue }  // temp test
#end

// *******************************************************************
// Define Camera
// *******************************************************************

#declare Beauty_Shot =
camera {
   direction < 0, 0, 3.5 >
   location  < -105, 6, -215 >        // SW of center
   look_at   < 0, 6, 0 > }      

// *******************************************************************
//  Define Test Scene:
// *******************************************************************

// CAMERA:
#declare MoveX = 0;
#declare MoveY = 0;
#declare MoveZ = 0;
camera { Beauty_Shot    translate < MoveX, MoveY, MoveZ > }

// FLOOR:
object { Clip_Floor }

// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************

// **************************************************************
//       B.  North Room:
// **************************************************************

//    DEFINE  the North Room:
#declare North_Room =
union {

   //roof:
//   object { North_Roof }// roof                            

   object { North_Chimneys }           // chimneys

   //north wall:
   object { N_North_Frame_Up  translate <     0, 16, 17 > } //1st floor
//   object { N_North_Panel_Up  translate < -12.5, 16, 17 > } //1st floor
   object { N_North_Frame_Dn  translate < -12.5,  6, 17 > } //ground

   //south wall:
   object { N_South_Frame_East  translate <    20, 16, -17.5 > } //1st floor
   object { N_South_Frame_West  translate < -17.5, 16, -17.5 > } //1st floor
   object { N_South_Frame_East  translate <    20,  6, -17.5 > } //ground
   object { N_South_Frame_West  translate < -17.5,  6, -17.5 > } //ground
//   object { N_South_Panel       translate <   -21,  6, -17.5 > } //both  
   object { N_South_Frame_Center  translate < 0, 16, -7.5 > } //1st floor
//   object { N_South_Panel_Center  translate < 0, 16, -7.5 > } //1st floor

   //west wall:
   object { N_West_Frame  translate < -25, 16, 0 > } //1st floor
//   object { N_West_Panel  translate < -25, 16, 12.5 > } //both floors
   object { N_West_Frame  translate < -25,  6, 0 > } //ground floor

   //east wall:
   object { N_East_Frame  translate < 35, 16, -12.5 > } //1st floor
//   object { N_East_Panel  translate < 35, 16,  12.5 > } //1st floor

   //doors:
//   object { M_Front_Door  translate < 0, 6, -7.5 > }
//   object { DoorA1_Closed rotate y*90  translate < -25, 5, 12.5 > } //west

   // floor:
   #if ( ShowFloor = 1 )
      object { Build_Block_1           // 1st floor  center
               texture { Tan_Tex }
               scale < 20, 0.5, 25 >
               translate < 0, 10.5, 5 >
             }// end 1st floor center
      object { Build_Block_1           // 1st floor  west
               texture { Tan_Tex }
               scale < 16, 0.5, 35 >
               translate < -17, 10.5, 0 >
             }// end 1st floor west
      object { Build_Block_1           // 1st floor east
               texture { Tan_Tex }
               scale < 25, 0.5, 35 >
               translate < 22.5, 10.5, 0 >
             }// end 1st floor east
      object { Build_Block_1           // ground floor    
               texture { Brown_Tex }
               scale < 61, 1, 36 >  
               translate < 5, 0.5, 0 >
             }// end north ground floor
   #end // show floor?
      } // end north room union

// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************

//    DEFINE East Wing:
#declare East_Room =
union {

#if ( ShowDetails = 0 ) //show minimum
   //walls:
   object { E_South_Frame  translate < 28.5, 6, 31 > }
   object { E_South_Frame  translate < 28.5, 6, -39.5 > }
   object { E_East_Frame   translate < 46, 6, -34.5 > }
   object { E_West_Frame   translate < 10.5, 6, 6 > }
#else  //show maximum
   //roof:
   object { East_Roof }
   object { Railing_Section_A ( 1.5, 0.25, 22 )
            rotate y*90  translate < 46, 12.5,  30 > } //east 
   object { Railing_Section_A ( 1.5, 0.25, 9 )
                         translate < 14, 12.5,  30 > } //north
   object { Railing_Section_A ( 1.5, 0.25, 9 )
                         translate < 14, 12.5, -40 > } //south
   //walls:
   object { E_South_Frame  translate < 28.5, 6, 31 > }
   object { E_South_Frame  translate < 28.5, 6, -39.5 > }
   object { E_East_Frame   translate < 46, 6, -34.5 > }
   object { E_West_Frame   translate < 10.5, 6, 6 > }
   object { E_South_Panel  translate < 28.5, 6,  31.0 > }
   object { E_South_Panel  translate < 28.5, 6, -39.5 > }
   object { E_East_Panel   translate <   46, 6,  -5.0 > }
#end  //of show all details?

   //floor:
#if ( ShowFloor = 1 )
   object { Build_Block_1              
            texture { Brown_Tex }
            scale < 37, 1, 73 >
            translate < 28.5, 1, -4 >
          }// end east floor
#end //if showfloor
      } // end east room union

// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE West Wing:
#declare West_Room =
union {

#if ( ShowDetails = 0 )
   //walls:
   object { W_North_Frame  translate < -42.5, 6,  -5 > }
   object { W_South_Frame  translate < -42.5, 6, -35 > }
   object { W_West_Frame   translate <   -60, 6, -20 > }
   object { W_East_Frame   translate <   -25, 6, -20 > }
#else
   //roof:
   object { West_Roof  translate < -43.5, 11, -20 > }
   //walls:
   object { W_North_Panel  translate < -36.5, 6,  -5 > }
   object { W_South_Panel  translate < -42.5, 6, -35 > }
   object { W_West_Panel   translate <   -60, 6, -20 > }
   object { W_East_Panel   translate <   -25, 6, -25 > }
   //door:
   object { M_Front_Door  translate < -50, 4, 0 > }
   //floor:
#end  // of show details?

   //kitchen:
   object { W_Kitchen  translate < -42.5, 1, -20 > }

#if ( ShowFloor = 1 )
   object { Build_Block_1
            texture { Brown_Tex }
            scale < 36, 1, 31 >        
            translate < -42.5, 1, -20 >
          }// end west floor
#end //show floor?

      } // end west room union

// *******************************************************************
//       F.  Our_House in the Modernist/International style:
// *******************************************************************

//    DEFINE the whole building and setting:
#declare Modernist_Home =
union {

   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk
            translate z*-30 }

   object { Arched_Hall_1
            translate < 0, 5, -30 >
          }// end arched hallway

   object { Planter_Box_2  translate < -17, 1, -24 > }
   object { 
      box {< -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
           pigment { VeryDarkBrown } }
      translate < -17, 1, -24 >
          }// end generic dirt

      } // end union modernist house

// ************************************************************** 
// **************************************************************


object { Modernist_Home }


// **************************************************************

//object { Man01  translate < 1, 3.5, -20 > }
//object { X_Axis }
//object { Z_Axis }

// **************************************************************

#if ( GridOn = 1 )
//   object { Grid10XY } // vert rods
//   object { Grid10XZ } // horz rods  centered
//   object { Grid10XZ  translate < -10, 0,  10 > } // nw
//   object { Grid10XZ  translate <  10, 0, -10 > } // se
//   object { Grid5XY } // vert balls
//   object { Mark01  translate < 0, 0, 0 > } // center

   //centered y,z:
   object { Mark01  translate <   0, 0, 0 > } // center
   object { Mark01  translate <  10, 0, 0 > } // 10x apart
   object { Mark01  translate < -10, 0, 0 > } //    "
   object { Mark01  translate <  20, 0, 0 > } //        
   object { Mark01  translate < -20, 0, 0 > } //    "
   object { Mark01  translate <  30, 0, 0 > } // 
   object { Mark01  translate < -30, 0, 0 > } //    "
   object { Mark01  translate <  40, 0, 0 > } // 
   object { Mark01  translate < -40, 0, 0 > } //    "
   object { Mark01  translate <  50, 0, 0 > } // 
   object { Mark01  translate < -50, 0, 0 > } //    "

   //south -50z
   object { Mark01  translate <   0, 0, -50 > } // center
   object { Mark01  translate <  10, 0, -50 > } // 10x apart
   object { Mark01  translate < -10, 0, -50 > } //    "
   object { Mark01  translate <  20, 0, -50 > } //        
   object { Mark01  translate < -20, 0, -50 > } //    "
   object { Mark01  translate <  30, 0, -50 > } // 
   object { Mark01  translate < -30, 0, -50 > } //    "
   object { Mark01  translate <  40, 0, -50 > } // 
   object { Mark01  translate < -40, 0, -50 > } //    "
   object { Mark01  translate <  50, 0, -50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "

   object { Mark01  translate < 0, 0,  10 > } // 10z apart
   object { Mark01  translate < 0, 0, -10 > } //    "
   object { Mark01  translate < 0, 0,  20 > } //        
   object { Mark01  translate < 0, 0, -20 > } //    "
   object { Mark01  translate < 0, 0,  30 > } // 
   object { Mark01  translate < 0, 0, -30 > } //    "
   object { Mark01  translate < 0, 0,  40 > } // 
   object { Mark01  translate < 0, 0, -40 > } //    "
   object { Mark01  translate < 0, 0,  50 > } // 
   object { Mark01  translate < 0, 0, -50 > } //    "

   //west -50x
   object { Mark01  translate < -50, 0,  10 > } // 10z apart
   object { Mark01  translate < -50, 0, -10 > } //    "
   object { Mark01  translate < -50, 0,  20 > } //        
   object { Mark01  translate < -50, 0, -20 > } //    "
   object { Mark01  translate < -50, 0,  30 > } // 
   object { Mark01  translate < -50, 0, -30 > } //    "
   object { Mark01  translate < -50, 0,  40 > } // 
   object { Mark01  translate < -50, 0, -40 > } //    "
   object { Mark01  translate < -50, 0,  50 > } // 
   object { Mark01  translate < -50, 0, -50 > } //    "

#end 

// *******************************************************************
//    STORAGE:
// *******************************************************************

/*

*/

// *******************************************************************
// *******************************************************************
//    Michael Brendan Hurley, SDE, Ltd.                   Fall 2000
// *******************************************************************
