// *******************************************************************
// M_HOME02.INC          for POV WIN 3.1g          Ver 1.0 Summer 2000
//         Definitions of assorted basic objects and effects         
//            for draft  of  Modernist_House  version 1.0
// *******************************************************************
//
// INClude File "Sub-Contractors":
//
// RoundBox.inc for POV 3.0 and above
// (c) Philip Cowley (philip.cowley@totem.co.uk) 13/07/97
//
// Leaf & Tree macro for Pov-ray 3.1 & higher
// (c) 1999 Gilles Tran (tran@inapg.inra.fr)
//
// *******************************************************************
//
// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

// set default values:
#ifndef ( ShowDetails )
   #declare ShowDetails = 0            // 0=minimum, 1=full
#end

#ifndef ( Seams )
   #declare Seams = 0                  // true=show 'em, false=hide 'em
#end

#ifndef ( LightsOn )
   #declare LightsOn = 0               // true=night, false=day
#end

#declare Intensity = 1.5;

#include "brendan.inc"                 // universal scene objects
                                       // and calls to all other INC's

// *******************************************************************
// *******************************************************************
// II.     DEFINE Structural Components
// *******************************************************************
//    A.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x / 10y units
#declare Frame_A =
union {
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0,  5, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0, -5, 0 > }
      } // end Frame A

// **************************************************************

//    DEFINE  rotated frame:
#declare rotated_Frame_A =
object { Frame_A  rotate y*90 }

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 0.5, 2.75, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 0.5, 2.75, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y
#declare Frame_D =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  5, 0 > }
      } // end Frame D

// *************************************************************

//   DEFINE   a 5x 5y frame
#declare Frame_E =
union {
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame E

// **************************************************************

//   DEFINE   a quarter-height 5x 2.5y frame:
#declare Frame_F =
union {
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate < -2.5, 0, 0 > }            
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate <  2.5, 0, 0 > }            
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame F

// *******************************************************************
//    B.   Frames: Single: Window:
// *******************************************************************

//    DEFINE  an inset frame for 3x 4y window: like Window_1
#declare Window_Frame_1 =
union {
   object { CubeY1                                        
            scale < 0.76, 10, 0.75 >  translate < -1.76, 0, 0 > }
   object { CubeY1                                       
            scale < 0.76, 10, 0.75 >  translate <  1.76, 0, 0 > }
   object { CubeX1                                        
            scale <   10, 0.75, 0.75 >  translate < 0,  2, 0 > }
   object { CubeX1                                        
            scale < 4.25, 0.75, 0.75 >  translate < 0, -2, 0 > }
   object { Frame_A } // end frame
   #if ( ShowDetails = 0 )
      texture { Red_Tex }
   #else
      texture { T_Wood2 }
   #end
      }//end window frame 1

// **************************************************************

//    DEFINE  an inset frame for Window Panel 2:
#declare Window_Frame_2 =
union {
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate < -3.45,      0, 0 > }
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate <  3.45,      0, 0 > }
   object { CubeX1                                        
            scale <  10, 0.5, 0.5 >  translate <     0,   3.15, 0 > }
   object { CubeX1                                        
            scale <   7, 0.5, 0.5 >  translate <     0, -1.125, 0 > }
   object { Frame_A } // end frame
   #if ( ShowDetails = 0 )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      }//end window frame 2

// **************************************************************

//    DEFINE  a round post frame for Pane_Square_1:
#declare Frame_Square_1 =
union {
   object { PostY1  scale < 0.5,    2, 0.5 >  translate < -1,  0, 0 > }
   object { PostY1  scale < 0.5,    2, 0.5 >  translate <  1,  0, 0 > }
   object { PostX1  scale < 2.25, 0.5, 0.5 >  translate <  0,  1, 0 > }
   object { PostX1  scale < 2.25, 0.5, 0.5 >  translate <  0, -1, 0 > }
      } // end frame square one

// **************************************************************

//    DEFINE  a round post frame for ... :
#declare Frame_Diamond_1 =
union {
  object { PostY1
           scale <0.5, 2.25, 0.5> rotate z*45  translate <-0.75,-0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*45  translate < 0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate <-0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate < 0.75,-0.75,0> }
      } // end diamond frame 1

// *******************************************************************
//    C.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10x 10y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5, 5, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10x 5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5, 2.5, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 5x 10y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 2.5, 5, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5x 5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.5, 2.5, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.5, 1.25, 0.25 > } // end panel f

// *******************************************************************
//    D.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   A beveled-edged square box: a window pane:
#declare Pane_Square_1 =
intersection {
   object { Cube  scale < 1, 1, 0.1 > }// 2"x2"x2/10"
   //beveled edges
   plane { y, 0                        // top front x edge
           rotate x*-45
           translate y*1
           hollow on } //end plane a
   plane { y, 0                        // top rear x edge
           rotate x*45
           translate y*1
           hollow on } //end plane b
   plane { y, 0                        // bottom front x edge
           rotate x*-135
           translate y*-1
           hollow on } //end plane c
   plane { y, 0                        // bottom rear x edge
           rotate x*135
           translate y*-1
           hollow on } //end plane d
   plane { x, 0                        // front left y edge
           rotate y*135
           translate x*-1
           hollow on } //end plane e
   plane { x, 0                        // rear left y edge
           rotate y*-135
           translate x*-1
           hollow on } //end plane f
   plane { x, 0                        // front right y edge
           rotate y*45
           translate x*1
           hollow on } //end plane g
   plane { x, 0                        // rear right y edge
           rotate y*-45
           translate x*1
           hollow on } //end plane h
             } // end square window pane

// **************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( ShowDetails )
            texture { White_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// *******************************************************************
//    E.   Frames: Compound: Wall:
// *******************************************************************

// *******************************************************************
//    F.   Frames: Compound: Windows:
// *******************************************************************

// *******************************************************************
//    G.   Panels: Compound: Wall:
// *******************************************************************

// *******************************************************************
//    H.   Panels: compound: windows:
// *******************************************************************

// *******************************************************************
// *******************************************************************
// III.    DEFINE Basic Elements
// *******************************************************************
//    A.   Simple Objects
// *******************************************************************

//    DEFINE  a torus for pillars
#declare Torus_1 =
torus { 0.5,       // MAJOR = radius of whole ring
        0.2        // MINOR = radius of tube
      } // end torus 1

// *******************************************************************
//    B.   Compound Objects
// *******************************************************************
//      1.   Lamps:
// *******************************************************************

// *******************************************************************
//      3.   Arches:
// *******************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.7, 0.7, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 2

// **************************************************************

//    DEFINE   a large THICK arch/roof/barrel dome:
#declare BigArch_1 =
object { Arch_Z1  scale < 5, 4.75, 5 > } // end big arch v.1

// **************************************************************

//    DEFINE   a large THIN arch/roof/barrel dome:
#declare BigArch_2 =
object { Arch_Z2  scale < 5, 4.75, 5 > } // end big arch v.2

// **************************************************************

//    DEFINE  Interior of frame has rounded corners: roundbox.inc cut-out
#declare ArchWay_1 =
   difference {
   union {
      object { CubeY1
               scale < 5, 10, 4 >
               translate x*-5 
             } // end left
      object { CubeY1
               scale < 5, 10, 4 >
               translate x*5 
             } // end right
      object { CubeX1
               scale < 12.5, 5.5, 4 >
               translate y*5 
             } // end top
         }//inner frame union
   object {
      #declare RB_P1 = <  4.25,  4.25,  7 >;
      #declare RB_P2 = < -4.25, -4.25, -7 >;
      #declare RB_Thickness = 2;      //Assumes 1 if not defined
      #declare RB_Solid = 0;          //Assumes "On" if not defined
      #include "roundbox.inc"
      translate < 0, -0.25, 0 >
          } //end roundbox cut-out
              } // end difference arch way 1

// *******************************************************************
//    C.   Floors                                                     
// *******************************************************************

//    DEFINE   basic floor: 2x 0.5y 2z
#declare Floor_One =
object { UnitBox  scale < 1, 0.25, 1 > }

// *******************************************************************
//    I.    DEFINE Front Yard
// *******************************************************************

#include "l_scape.inc"                 // landscaping
 
// *******************************************************************

// *******************************************************************
// IV.   DEFINE  Rooms
// *******************************************************************
//
// *******************************************************************
// V.   DEFINE Our_House: Modernist Style Version:         Summer 2000
// *******************************************************************

// *******************************************************************
// *******************************************************************
//    M_HOME02.INC         Michael Brendan Hurley       Summer 2000
//    www.geocities.com/mbrendanh/                 mbhcgc@saber.net
// *******************************************************************
