// *******************************************************************
// M_HOME00.INC                                Winter 2000-Winter 2001
//             Definitions of basic objects and effects         
//             for     Modernist_House      version 2.0
// *******************************************************************
//
// INClude File "Sub-Contractors":
//
// RoundBox.inc for POV 3.0 and above
// (c) Philip Cowley (philip.cowley@totem.co.uk) 13/07/97
// used for walls and roofs
//
// *******************************************************************

// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

#include "brendan.inc"                 // universal scene objects
                                       // and calls to support INC's

//if not defined in calling .pov file, default value=false|off|no: 
#ifndef ( ShowDetails )
   #declare ShowDetails = 0;    // 0=minimum detail, 1=full detail
#end
#ifndef ( GridOn )
   #declare GridOn      = 0;    // 0=off, 1=on
#end
#ifndef ( ShowLights )
   #declare ShowLights  = 0;    // 0=day, 1=night
#end
#ifndef ( ShowFloor )
   #declare ShowFloor   = 0;    // 0=no, 1=yes
#end
#ifndef ( ShowGlass )
   #declare ShowGlass   = 0;    // 0=no, 1=yes
#end
#ifndef ( ShowArch )
   #declare ShowArch    = 0;    // 0=no, 1=yes
#end
#ifndef ( DoorOpen )
   #declare DoorOpen    = 0;    // 0=closed, 1=open
#end
#ifndef ( ShowRails )
   #declare ShowRails   = 0;    // 0=hide, 1=show
#end
#ifndef ( DayLight )
   #declare DayLight    = 1;    // 0=no,   1=yes
#end

// *******************************************************************
// *******************************************************************
// II.     DEFINE Structural Components
// *******************************************************************
// *******************************************************************
//    A.   Basic Objects
// **************************************************************

//    DEFINE  generic scalable building block: 1x 1y 1z:
#declare Build_Block_1 =
box { <-0.5, -0.5, -0.5>  < 0.5, 0.5, 0.5 > } // end bldg block 1

// **************************************************************

//   DEFINE   A square box: clipped into triangle
#declare Pane_Tri_1 =
intersection {
   object { UnitBox  scale < 0.5, 0.5, 0.01 > }
   plane  { y, 0     rotate z*135 } //end plane
             } // end  triangle pane 1

// **************************************************************
//    Arches:
// **************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.7, 0.7, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 2

// **************************************************************

//    DEFINE   a large THIN arch/roof/barrel dome:
#declare BigArch_2 =
object { Arch_Z2  scale < 10, 9.5, 5 > } // end big arch v.2

// **************************************************************

//    DEFINE  Interior of frame has rounded corners: roundbox.inc cut-out
#declare ArchWay_1 =
   difference {
      union {
         object { CubeY1
                  scale < 4, 12, 3 >  translate x*-4.5 } // end left
         object { CubeY1
                  scale < 4, 12, 3 >  translate x*4.5  } // end right
         object { CubeX1
                  scale < 11, 4, 3 >  translate y*6 } // end top
            }//frame union
      object {
         #declare RB_P1 = <  5,  5.5,  5 >;
         #declare RB_P2 = < -5, -5.5, -5 >;
         #declare RB_Thickness = 2;   
         #declare RB_Solid = 0;
         #include "roundbox.inc"
         translate < 0, -0.25, 0 >
             } //end roundbox cut-out
              } // end difference arch way 1

// *******************************************************************
//    Stairs                                                     
// *******************************************************************

//    DEFINE   a set of stairs:
#declare North_Stairs =
union { 
   object { Pane_Tri_1 
               scale < 13, 13, 10 >
               rotate y*-90   //long edge face front
               rotate x*90   //tilt long edge toward back
               translate < 0, -1, -1 >
          }// end triangle stair support

   #declare sz = 5;
   #declare sy = 5;
   #declare Offset = 0.7;
   #declare Looper = 0;
   #while ( Looper < 20.1)
      object { CubeX1
               scale < 10, 1.6, 2 >
               translate < 0, sy, sz >
             }// end step
      #declare sy = sy - Offset;
      #declare sz = sz - Offset;
      #declare Looper = Looper + 1;
   #end
   #if (ShowDetails = 0 )
      texture { Red_Tex }
   #else
      texture { T_Stone2  scale < 15, 5, 1 > }
   #end
      } // end union stair block

// **************************************************************
//    Railing/banister:
// **************************************************************

//    DEFINE  generic scalable cylinder with spherical ends:
#macro Round_Post_Y ( Post_Size_Y , Post_Size_X )
union {
   cylinder { Post_Size_Y*y, -(Post_Size_Y)*y, Post_Size_X open }//end cyl
   sphere { < 0,  Post_Size_Y, 0 >  Post_Size_X }//end top ball
   sphere { < 0, -Post_Size_Y, 0 >  Post_Size_X }//end bottom ball
      } // end union scalable post
#end // macro for y pillar

// **************************************************************

//    DEFINE  scalable banisters/fensing/frames:
//            base post centered at <0,0,0>
//            other posts, railings translated +x +y

#macro Railing_Section_A ( How_Tall, How_Wide, How_Many )
   //declare local variables:
   #local Post_Size_Y = How_Tall; //duh...?
   #local Post_Size_X = How_Wide; //circumferance
   #local How_Many    = How_Many; //
   //call macro:
   union {
      #local P_Count = 0;
      #while ( P_Count <= How_Many )
         object {            
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            translate < (P_Count*(How_Tall*2)), 0, 0 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { Bright_Bronze }
            #end
                }//end all posts
         object {
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            rotate z*90
            translate < (P_Count*(How_Tall*2)+How_Tall), (How_Tall), 0 >
            #if ( ShowDetails = 0 )
               texture { Blue_Tex }
            #else
               texture { Bright_Bronze }
            #end
                }//end railings
         #if ( P_Count = How_Many )
            object {           //last post:
               Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
               translate < (P_Count*(How_Tall*2))+(How_Tall*2), 0, 0 >
               #if ( ShowDetails = 0 )
                  texture { Red_Tex }
               #else
                  texture { Bright_Bronze }
               #end
                   }//end add last post
         #end
         #declare P_Count = ( P_Count + 1 );
      #end //while loop
         } // end union scalable railing
 #end // macro for railing section

// *******************************************************************
//    B.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x / 12y units
#declare Frame_A =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.5, 1, 1 >  translate <  0,  6, 0 > }
   object { CubeX1
            scale < 10.5, 1, 1 >  translate <  0, -6, 0 > }
      } // end Frame A

// **************************************************************

//    DEFINE  rotated frame:
#declare rotated_Frame_A =
object { Frame_A  rotate y*90 }

// **************************************************************

//   DEFINE   a frame 10x / 10y units: thicker beams:
#declare Frame_A2 =
union {
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate < -5, 0, 0 > }
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate <  5, 0, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0,  5, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0, -5, 0 > }
      } // end Frame A2

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale <  1, 5, 1 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale <  1, 5, 1 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 1, 1 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 1, 1 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 1, 2.75, 1 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 1, 2.75, 1 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 1, 1 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 1, 1 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y 0.5z:
#declare Frame_D =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 1, 1 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5, 1, 1 >  translate < 0,  5, 0 > }
      } // end Frame D

// **************************************************************

//   DEFINE   thicker version of D, 5x 10y 1z:
#declare Frame_D2 =
union {
   object { CubeY1
            scale < 1, 12, 2 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 2 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5.5, 1, 2 >  translate < 0, -6, 0 > }
   object { CubeX1
            scale < 5.5, 1, 2 >  translate < 0,  6, 0 > }
      } // end Frame D 2

// *******************************************************************
//    C.   Frames: Single: Window:
// *******************************************************************

// *******************************************************************
//    D.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10.5x 12y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5.25, 6, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10.5x 5.5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5.25, 2.75, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10.5x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5.25, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 7x 12y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 3.5, 6, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5.5x 5.5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.75, 2.75, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5.5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.75, 1.25, 0.25 > } // end panel f

// *******************************************************************
//    E.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// *******************************************************************
//    F.   Front Yard & Landscaping:
// *******************************************************************

//    DEFINE a sidewalk/driveway:
#declare Front_SideWalk =
object { UnitBox
         scale < 10.5, 0.5, 22 >
         translate < 0, 0.5, 0 >
         #if ( ShowDetails = 0 )
            texture { Coral_Tex }
         #else
            texture { T_Stone2  scale < 1, 1, 5 > }
         #end
       } // end sidewalk

// **************************************************************

//   DEFINE   a planter box: 2x 1.2y 6z:
#declare Planter_Box_1 =
object {                            
   difference {
      object { UnitBox
               scale < 1.0, 0.6, 3.0 >
             } // end Box outside
      object { UnitBox
               scale < 0.9, 0.5, 2.9 >
               translate y*0.11
              } // end Box inside
      #if ( ShowDetails = 0 )
         texture { Gray75_Tex }
      #else
         texture { Spex
         finish { ambient 0.3
                  diffuse 0.4
                  reflection 0.2 } //end finish
                 } // end texture
      #end
              } // end difference
       } // end planter box

// **************************************************************

//   DEFINE   a planter box: 7x 2y 7z:
#declare Planter_Box_2 =
object {                            
   difference {
      object { UnitBox
               scale < 6.0, 1.0, 6.0 >
             } // end Box outside
      object { UnitBox
               scale < 5.5, 1.0, 5.5 >
               translate y*0.2
              } // end Box inside
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { Spex
         finish { ambient 0.3
                  diffuse 0.4
                  reflection 0.25 } //end finish
                 } // end texture
      #end
              } // end difference
       } // end planter box 2

// **************************************************************

//    DEFINE planter boxes, v.3, w/ fake shrubry, from BrownStones:
//    Go_X, Go_Y, Go_Z = starting locations
//    Move_X, Move_Y, Move_Z = move objs this far each iteration
//    This_Many = how many planters in the row

#macro Planter_Box_3 (Go_X, Go_Y, Go_Z, Move_X, Move_Y, Move_Z, This_Many)
#local Looper = 1; // start loop counter
union {
   #while ( Looper <= This_Many)
      object { CubeY1 scale < 4, 2, 7 > 
                      translate < Go_X, Go_Y, Go_Z > 
               #if ( ShowDetails = 0 )
                  texture { Black_Tex }
               #else
                  texture { Spex }
               #end
             }// end planter box
      union {
         object { Sphere scale 1  
                         translate < Go_X, Go_Y+3.5, Go_Z > } //top
         object { Sphere scale 1.4  
                         translate < Go_X,   Go_Y+2, Go_Z > } //bottom
         #if ( ShowDetails = 0 )
            texture { Green_Tex }
         #else
            texture { Tree_Jade }
         #end
             }// end bushes
      #local Looper = Looper + 1;
      #local Go_X = Go_X + Move_X;
      #local Go_Y = Go_Y + Move_Y;
      #local Go_Z = Go_Z + Move_Z;
   #end  //loop 1 
      }//end union planter boxes 3
#end // macro

/*

// *******************************************************************
//    G.   Floors:           Floor macros:
// *******************************************************************
//
//   DEFINE  a row of boards: each plank 4"x 2"y HowLong'z:
//           scale: 1 PoV unit = 1 US foot
//           Move_X,Y,Z = +axis offset per iteration
//           How Many = even numbers work smoother
//           How Long = length of board you want to see
//           Start Here = x of center of 1st board

#macro FloorPlanks_1
   ( Move_X, Move_Y, Move_Z, How_Many, How_Long, Start_Here )
union {
   //set variables:
   #local mySeed = seed(69);
   #local Cuts = 1;
   #local Count = 0;
   #local Move_It = false;   // don't move 1st, 3rd, 5th,...plank
   #local Half_Length = (How_Long/2);

   //run loop:
   #while ( Count < How_Many )
      //render a plank 4"x 2"y (HowLong')z:
      object {
         //create plank:
         box { < -Move_X, -Move_Y, -Half_Length > < Move_X, Move_Y, Half_Length > }
         //check to stagger planks +-z:
         #if ( Move_It = true )
            #local Move_Z = Move_Z + Half_Length;
            #local Move_It = false;
         #else  //move_it is false:
            #local Move_Z = Move_Z;
            #local Move_It = true;
         #end
         //position the plank:
         translate < (Start_Here+((Move_X*2)*Count)), Move_Y, Move_Z >
         //reset Z offset: get every other board back to center z
         #if (Move_It = false)
            #local Move_Z = Move_Z - Half_Length;
//            #local texture { Blue_Tex } //debugging marker
         #else
            #local Move_Z = Move_Z;
//            texture { Red_Tex } //debugging marker
         #end
         //texture the plank:
         texture { RosewoodB
                   scale < 1, 1, 2 >
                   translate y*Cuts
                   translate z*0.5
                   rotate x*(1.5/(Count+0.1))
                 }//end tex
             }// end plank obj
      //update variables:
      #local Cuts = Cuts + ( 0.7 + rand (mySeed) );
      #local Count = Count + 1;
   #end  // end while loop
     } // union of planks
#end // floor macro

// **************************************************************

//    DEFINE  a whole room of flooring units:
#macro Whole_Floor_1 (
   Move_X,      // half board width of a 2x4
   Move_Y,      // half board height of a 2x4
   Move_Z,      // initial z-axis offset
   How_Many,    // ((How_Many)*(Move_X*2)) = width of room
   How_Long,    // length of 1 board in feet (& POV units)
   Start_Here,  // sets left edge of 1st plank at x = 0
   Offset_Z,    // move successive sets +z, equals (How_Long/2)
   Room_Depth,  // z-axis iterations to fill depth of room
   Clip_X,      // +x width of room
   Clip_Z       // +z depth of room
                     )
union {
   //initialize variables:
   #local Not_There_Yet = 0;
   //run loop:
   #while ( Not_There_Yet <= Room_Depth )
      object { FloorPlanks_1
               ( Move_X, Move_Y, Move_Z, How_Many, How_Long, Start_Here )
               translate z*((Offset_Z)*(Not_There_Yet))
               clipped_by {     //the edges of room:
                  box { < 0, -1, 0 > < Clip_X, 1, Clip_Z > } }//end clipping
              }//end floor plank obj
      //update variables:
      #local Not_There_Yet = Not_There_Yet + 1;
   #end  //while loop
      } // end union whole floor #1
#end  // macro whole floor 1

*/

// *******************************************************************
//    H. Lamps:
// *******************************************************************

//   DEFINE  an object for a light source
#declare Flat_Light =
object {
   box { < -0.5, -0.1, -0.5 > < 0.5, 0.1, 0.5 >
         texture { White_Tex }
         finish { Luminous }
         hollow
       } // end box of glass
       } // end obj flat light

// **************************************************************

//   DEFINE  a light fixture, for stove, sink:
#declare Lamp_A =
light_source {
   < 0, 0, 0 >
   color White
   looks_like { Flat_Light }
   spotlight
   cylinder
   point_at < 0, -1, 0 >
   radius 55
   tightness 25
   falloff 58
   fade_distance 7
   fade_power 2
             } // end light source

// **************************************************************

//   DEFINE  a light fixture, for rooms:
#declare Lamp_B =
light_source {
   < 0, 0, 0 >
   color White
   looks_like { Flat_Light }
   fade_distance 9
   fade_power 2
             } // end light source  

// *******************************************************************
//    I.   Doors:
// *******************************************************************

//   DEFINE   basic door frame inset for 10x 10y Frame_A
#declare Frame_Door_A1 =
union {
   object { CubeY1                                        
            scale < 1.5, 8, 1.5 >  translate < -2.25, -1, 0 > }
   object { CubeY1                                       
            scale < 1.5, 8, 1.5 >  translate <  2.25, -1, 0 > }
   object { CubeX1                                        
            scale < 10, 1.5, 1.5 >  translate < 0, 3, 0 > }
   #if ( ShowDetails = 0 )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end Frame for Door  A1

// **************************************************************

//   DEFINE  a 4x 7y door: CLOSED
#declare DoorA1_Closed =
union {
   difference {
      object { UnitBox
               scale < 2, 3.8, 0.10 >
             }//end main panel
      object { UnitBox
               scale < 1.25, 0.4, 1 >
               translate y*1
             }//end cut-out bottom
      object { UnitBox
               scale < 1, 0.3, 1 >
               translate < 0.25, 2.1, 0 >
             }//end cut-out
      object { UnitBox
               scale < 0.75, 0.2, 1 >
               translate < 0.5, 3, 0 >
             }//end cut-out
               #if ( ShowDetails = 0 )
                  texture { Gray50_Tex }
               #else
                  texture { EMBWood1  scale < 2, 11, 2 > }
               #end
              }//end difference
   object { UnitBox 
            scale < 1.4, 1.65, 0.02 >
            translate < 0, 1.9, 0 > 
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               #if ( ShowGlass = 0 )
                  texture { Black_Tex }
               #else  
                  texture { T_Glass1 }
               #end
            #end
          } //end window glass
   object { sphere { <0, 0, 0>  0.25 }
            translate < -1.5, -0.5, -0.19 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { Bright_Bronze }
            #end
          }//end knob
      }//end union door 1a closed

// **************************************************************

//   DEFINE  a 4x 7y door: OPEN
#declare DoorA1_Open =
object { DoorA1_Closed
         rotate y*-45
         translate < -0.75, 0, -1.5 >
       } // end Door A1 open

// **************************************************************

//    DEFINE  a 4x 7y door, plain: CLOSED:
#declare DoorA2 =
box { < 1.5, 3.5, 0.1 > < -1.5, -3.5, -0.1 >
      #if ( ShowDetails = 0 )
         texture { Gray50_Tex }
      #else
         texture { EMBWood1  scale < 3, 12, 1 > }
      #end
    }//end door A2

// **************************************************************

//   DEFINE  set of solid wall panels scaled for Door_Front
#declare Panel_Door_A1 =
union {
   object { UnitBox
            scale < 5.2, 1.2, 1.0 >  translate < 0, 4, 0 >
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { T_MBH_Brick_1  scale < 0.075, 0.05, 0.05 >
                                        translate y*-0.1 }
            #end
          }//upper brick panel
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate < -3.5, -1, 0 > 
          }//left glass
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate <  3.5, -1, 0 > 
          }//right glass
      } // end Panels New Door A1

// **************************************************************

//    DEFINE  a front door:
#declare M_Front_Door =
union {
   //frames & panels:
   object { Frame_A2
            #if ( ShowDetails = 0 )
               texture { Red_Tex }
            #else
               texture { T_Wood2  scale < 1, 5, 1 > }
            #end
          } //south front frame
   object { Panel_Door_A1 } //south front panels
   //door:
   object { Frame_Door_A1 } // door jams
   #if ( DoorOpen = 0 )
      object { DoorA1_Closed  translate y*-1.2 }
   #else
      object { DoorA1_Open  translate y*-1.2 }
   #end
      }//end door union

// **************************************************************
// **************************************************************


//  >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// *******************************************************************
// *******************************************************************
//
//    NOTE THIS: All declarations above this point are of 
//               free-standing objects centered on <0,0,0>
//               that may be transformed for use in ANY scene.
//               The objects below are written and transformed
//               for THIS scene only.
//
// *******************************************************************
// *******************************************************************
//  >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
/*

Slender, blonde Nicole and fuller-figured, brunette Shawna arrived 
at my suite mid-afternoon.  They were both dressed in business women's
suits: Nicole in a light gray jacket and skirt with a cream-colored 
blouse, Shawna in a dark blue jacket and slacks with a light blue 
turtle-neck.

As per the script, they were two office girls coming home from work,
frazzled, frustrated, ant-sy.  They fixed drinks at the bar. Shawna
dropped into an easy chair across from me.

Nicole leaned against one of the bar stools, legs spread, her short
skirt riding up her trim thighs.  She bitched and moaned about her
"boss": how unfair he was, how "damned sexy" he was, how she hated him,
how much she wanted to fuck him.  She put her drink aside, hiked her
skirt higher, revealing her stocking tops, garter straps and white
lace bikini panties.  She slipped her hand under her panties and
started slowly fingering her pussy.

"God! I'd get him sooo hard...rub all over him...get that thick cock
of his hard...then sit on it...get that cock up in me and ride it!"
She rubbed harder, faster, her hand stroking under the lacy fabric,
her face a study in furious need.  "Yes!...ummm, yes!  ride it...
ride it hard and fast...like this!"

I loosened my slacks, slipped them off and pulled my hardening cock
out over my shorts.  It was stiffening up nicely; the vision of the
blonde frigging herself was doing its work. As was the sight of
Shawna who was also removing her slacks and cupping the crotch of her
dark lavender nylon briefs.

"Ummmmm, Nicole!  You're making me hot, too, you bitch!" Her fingers
traced the crease in the tight-stretched gusset of her panties.
*/

// *******************************************************************
// III.  DEFINE  Modernist_Home Cpmponents:
// *******************************************************************

// *******************************************************************
//       A.  Specialized Components:
// *******************************************************************

//    DEFINE  front hall with arched roof: 20x 20y 40z:
#declare Arched_Hall_1 =
union {
   #declare Move_Count = 1;       // start count
   #declare From_Z = -27.5;       // from where? >>REQUIRES HARD CODING<<
   #declare Move_It = +11;        // how far? 
   #declare Max_Count = 4;        // how many?

   #while ( Move_Count <= Max_Count )
      object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < 10, 1, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Green_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs east
     object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < -10, 1, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Yellow_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs west

      #if ( ShowArch = 1 )   //display entry barrel roof
         object { Arch_Z2 
                  scale < 10, 9.5, 1 >
                  translate < 0, 7.0, (From_Z + (Move_It-2-Move_Count)) >
                  #if ( ShowDetails = 0 )
                     texture { Red_Tex }
                  #else
                     texture { T_Wood2  scale < 1, 5, 1 > }
                  #end
                }// end arch frames
         //skip northmost section
         #if ( Move_Count < Max_Count )
            object { BigArch_2 
                     translate < 0, 7.0, ((From_Z+1) + Move_It) >
                     #if ( ShowDetails = 0 )
                        texture { Magenta_Tex }
                     #else
                        texture { T_Glass1 }
                     #end // texture choices
                   }//end barrel roof
         #end // if < Max Count
      #end // if Show Arch

      #declare From_Z = ( From_Z + Move_It ); 
      #declare Move_Count = Move_Count + 1;
   #end//of while loop
      } // end union arched hallway

// **************************************************************
//    Special windows:
// **************************************************************
                                             
//    DEFINE  a long quasi-cylinder window:  
#declare Window_Dome_1 =
difference {
   object {
      difference {
         object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
         object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
         clipped_by { plane { -y, 0 } }
                 } // end diff of disks
      scale < 9, 11, 18 >
      #if ( ShowDetails = 0 )
         texture { Black_Tex }
      #else
         texture { T_Glass1 }
      #end
          }//end obj z-axis quarter cyl
   plane { x, 1  hollow on }
           } // end difference cyl window

// **************************************************************

//    DEFINE  a single quarter arch:
#declare Window_Dome_Arch =
difference {
   object { Arch_Z2  scale < 9, 11, 0.25 > }//end arch
   plane { y, 0  hollow on }
   plane { x, 0  hollow on }
   #if ( ShowDetails = 0 )
      texture { Yellow_Tex }
   #else
      texture { T_Wood2  scale < 1, 5, 1 > }
   #end
      } // end difference domed arch

// **************************************************************

//    DEFINE  a set of quarter arches:
#declare Window_Dome_Frame =
union {
   object { Window_Dome_Arch  translate < 0, 0,  17.0 > }
   object { Window_Dome_Arch  translate < 0, 0,   7.5 > }
   object { Window_Dome_Arch  translate < 0, 0,  -7.5 > }
   object { Window_Dome_Arch  translate < 0, 0, -17.0 > }
      } // end dome frame

// **************************************************************

// *******************************************************************
//       B.  North Room:
// *******************************************************************

//    DEFINE  north room roof:
#declare North_Roof =
union {
   object {
      #declare RB_P1 = <  10,  1.05,  21 >; // right upper rear corner
      #declare RB_P2 = < -10, -1.05, -21 >; // left lower front corner
      #include "roundbox.inc"              // calls file
      translate < -19.5, 21, 0 > 
          } // end west section roof
   object {
      #declare RB_P1 = <  13.5,  1.05,  14.5 >;
      #declare RB_P2 = < -13.5, -1.05, -14.5 >;
      #include "roundbox.inc"
      translate < 0, 21, 6 > 
          } // end center section roof
   object {
      #declare RB_P1 = <  14.5,  1.05,  21 >;
      #declare RB_P2 = < -14.5, -1.05, -21 >;
      #include "roundbox.inc"
      translate < 24, 21, 0 > 
          } // end east section roof
   #if ( ShowDetails = 0 )
      texture { Gray_Tex }
   #else
      texture { T_Stone24  rotate y*90 }      
   #end
      } // end north roof union

// **************************************************************

//    DEFINE  north room chimneys:
#declare North_Chimneys =
union {
   union  {                            // chimney southeast
      object { Build_Block_1
               scale < 12, 28, 5 >
               translate < 22, 14.5, -17.5 >
               #if ( ShowDetails = 0 )
                  texture { FireBrick_Tex }
               #else
                  texture { T_MBH_Brick_1  scale < 0.035, 0.006, 0.030 > }
               #end
             }// end chimney
         object { Build_Block_1
                  scale < 14, 1.5, 6 >
                  translate < 22, 28.5, -17.5 >
                  texture { Gray95_Tex }
                }// end cap
         object { Build_Block_1
                  scale < 14.5, 1.75, 6.5 >
                  translate < 22, 1.5, -17.5 >
                  texture { Gray95_Tex }
                }// end footer
          }// end southeast chimney union
   union  {                            // chimney northwest
      object { Build_Block_1
               scale < 5, 28, 12 >
               translate < -25, 14.5, -1.5 >
               #if ( ShowDetails = 0 )
                  texture { FireBrick_Tex }
               #else
                  texture { T_MBH_Brick_1  scale < 0.035, 0.006, 0.030 > }
               #end
             }// end chimney
         object { Build_Block_1
                  scale < 6, 1.5, 14 >
                  translate < -25, 28.5, -1.5 >
                  texture { Gray95_Tex }
                }// end cap
         object { Build_Block_1
                  scale < 6.5, 1.75, 14.5 >
                  translate < -25, 1.5, -1.5 >
                  texture { Gray95_Tex }
                }// end footer
          }// end west chimney union
      } // end north room chimneys



//  LAST PAGE PRINTED ENDS HERE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<



// **************************************************************

//    DEFINE  north room: north wall frame: 1st floor:
#declare N_North_Frame_Up =
union {
   union {
      object { CubeY1
               scale < 1, 12, 1 >  translate < -12.5, 0, 0 > }//w
      object { CubeY1
               scale < 1, 12, 1 >  translate <  -5.0, 0, 0 > }
      object { CubeY1
               scale < 1, 12, 1 >  translate <   5.0, 0, 0 > }
      object { CubeY1
               scale < 1, 12, 1 >  translate <  12.5, 0, 0 > }//e
      object { CubeX1
               scale < 25, 1, 1 >  translate < 0,  6, 0 > }//top
      object { CubeX1
               scale < 25, 1, 1 >  translate < 0, -6, 0 > }//bot
      translate < 17.5, 0, 0 >
         }//end union east side 
   union {
      object { CubeY1
               scale < 1, 12, 1 >  translate < -12.5, 0, 0 > }//w
      object { CubeY1
               scale < 1, 12, 1 >  translate <  -5.0, 0, 0 > }
      object { CubeY1
               scale < 1, 12, 1 >  translate <   5.0, 0, 0 > }
      object { CubeY1
               scale < 1, 12, 1 >  translate <  12.5, 0, 0 > }//e
      object { CubeX1
               scale < 25, 1, 1 >  translate < 0,  6, 0 > }//top
      object { CubeX1
               scale < 25, 1, 1 >  translate < 0, -6, 0 > }//bot
      translate < -17.5, 0, 0 > 
         }//end union west side 
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end north frames up stairs

// **************************************************************

//    DEFINE  north room: north wall upper panels:
#declare N_North_Panel_Up =
union {
   object {
      difference {
      object {
         #declare RB_P1 = <  30.5,  6.5,  1.1 >; // right upper rear corner
         #declare RB_P2 = < -30.5, -6.5, -1.1 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end main panel
      object {
         #declare RB_P1 = <  4.5,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -4.5, -4.0, -2.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end center cut-out
      object {
         #declare RB_P1 = <  -8,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -27, -4.0, -2.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end left cut-out
      object {
         #declare RB_P1 = < 27,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = <  8, -4.0, -2.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end right cut-out
                 }// end difference
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Stone15 scale < 5, 1.5, 1.5 > }         
      #end
          } // end obj
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  scale < 56, 10, 0.05 > }
   #end
      } // end north panels up stairs

// **************************************************************

//    DEFINE  north room: north wall lower frame:
#declare N_North_Frame_Dn =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -12.5, 0, 0 > }//w
   object { CubeY1
            scale < 1, 12, 1 >  translate <  -5.0, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <   5.0, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <  12.5, 0, 0 > }//e
   object { CubeX1
            scale < 25, 1, 1 >  translate < 0,  6, 0 > }//top
   object { CubeX1
            scale < 25, 1, 1 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end north frames down stairs

// **************************************************************

//    DEFINE  north room: north wall lower panels:
#declare N_North_Panel_Dn =
union {
   object {
      difference {
      object {
         #declare RB_P1 = <  13,  6.5,  1.1 >; // right upper rear corner
         #declare RB_P2 = < -13, -6.5, -1.1 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  10.0,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -10.0, -4.0, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end left cut-out
                 }// end difference
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Stone15 scale < 5, 2, 1.5 > }
      #end
          } // end panel w/hole obj
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  scale < 20, 10, 0.05 > }
   #end
      } // end north wall panels, down stairs

// **************************************************************

//    DEFINE  north room: south wall, east frame:
#declare N_South_Frame_East =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -10, 0, 0 > }//w
   object { CubeY1
            scale < 1, 12, 1 >  translate <  -4, 0, 0 > }//w
   //south chimney goes here:
   object { CubeY1
            scale < 1, 12, 1 >  translate <  8, 0, 0 > }//e
   object { CubeY1
            scale < 1, 12, 1 >  translate < 15, 0, 0 > }//e
   object { CubeX1
            scale < 7, 1, 1 >  translate < -7.0,  6, 0 > }//wtop
   object { CubeX1
            scale < 7, 1, 1 >  translate < -7.0, -6, 0 > }//wbot
   object { CubeX1
            scale < 7, 1, 1 >  translate < 11.5,  6, 0 > }//etop
   object { CubeX1
            scale < 7, 1, 1 >  translate < 11.5, -6, 0 > }//ebot
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end south frame east side union

// **************************************************************

//    DEFINE  north room: south wall, west frame:
#declare N_South_Frame_West =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -7.5, 0, 0 > }//w
   object { CubeY1
            scale < 1, 12, 1 >  translate <    0, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <  7.5, 0, 0 > }//e
   object { CubeX1
            scale < 15.5, 1, 1 >  translate < 0,  6, 0 > }//top
   object { CubeX1
            scale < 15.5, 1, 1 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end south frame west side

// **************************************************************

//    DEFINE  north room: south walls:
#declare N_South_Panel=
union {
  union {
     object { Panel_D  translate < -0.25, 13, 0 > } //w
     object { Panel_D  translate < -0.25,  1, 0 > }
     #if ( ShowDetails = 0 )
        texture { Coral_Tex }
     #else
        texture { T_Stone15 scale < 1.5, 4, 2 > }
     #end
        }//end union western panels
  union {
    object { Panel_D scale < 1.1, 1, 0.05 > translate <  7.0, 13, 0 > } //e
    object { Panel_D scale < 1.1, 1, 0.05 > translate <  7.0,  1, 0 > }
//    object { Panel_D scale < 1.1, 1, 0.05 > translate < 34.0, 13, 0 > } //w
//    object { Panel_D scale < 1.1, 1, 0.05 > translate < 52.5, 13, 0 > } //e
    #if ( ShowDetails = 0 )
       texture { Black_Tex }
    #else
       texture { T_Glass3 }
    #end
        }//end union all other panels:glass
      } // end union south wall panels
 
// **************************************************************

//    DEFINE  north room: south wall, center foyer, doorway:
#declare N_South_Frame_Center =
union {
   //middle section:
   object { Arch_Z2 scale < 10, 9.5, 1 >  translate < 0, -6, 0 > }
   object { CubeY1
            scale < 1, 24, 1 >  translate < -10, -6, 0 > }//w rear
   object { CubeY1
            scale < 1, 24, 1 >  translate <  10, -6, 0 > }//e rear
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0,  6,   0 > }//rear top
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0,  6, -10 > }//front top
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0, -6,   0 > }//rear bot 
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0, -6, -10 > }//front bot 
   //east section:
   object { CubeY1
            scale < 1, 12, 1 >  translate < 10,  0, -10 > }//se
   object { CubeZ1
            scale < 1, 1, 10 >  translate < 10,  6,  -5 > }//top
   object { CubeZ1
            scale < 1, 1, 10 >  translate < 10, -6,  -5 > }//bot
   //west section:
   object { CubeY1
            scale < 1, 12, 1 >  translate < -10,  0, -10 > }//sw
   object { CubeZ1
            scale < 1, 1, 10 >  translate < -10,  6,  -5 > }//top
   object { CubeZ1
            scale < 1, 1, 10 >  translate < -10, -6,  -5 > }//bot
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end union south side center, upper frames

// **************************************************************

//    DEFINE  north room: south wall, foyer panels above and below:
#declare N_South_Panel_Center =
union {
   //roof:
   object { Pane_Square_2
            rotate x*90
            scale < 21, 0.5, 10 >
            translate < 0, 6, -5 >
          }//end overhead window
   object { Pane_Square_2
            scale < 20, 12, 0.05 >
            translate < 0, 0, 0 >
          }//end center rear window pane
   //upper:
   object { Pane_Square_2
            scale < 20, 12, 0.05 >
            translate < 0, 0, -10 >
          }//end center front window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 12, 10 >
            translate < 10, 0, -5 >
          }//end east window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 12, 10 >
            translate < -10, 0, -5 >
          }//end west window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 12, 10 >
            translate < -10, -12, -5 >
          }//end west window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 12, 10 >
            translate < 10, -12, -5 >
          }//end east window pane
   //lower:
   object { Frame_D2
            translate < -7.5, -12, 0 >
            #if ( ShowDetails = 0 )
               texture { Coral_Tex }
            #else
               texture { T_Wood2 scale < 2, 4, 2 > }
            #end
          }//end lower west frame
   object { Pane_Square_2
            scale < 5, 12, 0.05 >
            translate < -7.5, -12, 0 >
          }//west of door
   object { Frame_D2
            translate < 7.5, -12, 0 >
            #if ( ShowDetails = 0 )
               texture { Coral_Tex }
            #else
               texture { T_Wood2 scale < 2, 4, 2 > }
            #end
          }//end lower east frame
   object { Pane_Square_2
            scale < 5, 12, 0.05 >
            translate < 7.5, -12, 0 >
          }//east of door
      } // end union south center foyer panels

// **************************************************************

//    DEFINE  north room: east wall frame:
#declare N_East_Frame =
union {
   object { rotated_Frame_A  translate < 0, 0, -12.5 > }
   object { rotated_Frame_A  translate < 0, 0,  12.5 > }
   object { CubeZ1
            scale < 1, 1, 15.5 >  translate < 0,  6, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 15.5 >  translate < 0, -6, 0 > }//bot
   object { CubeY1
            scale < 2, 12, 2 >  translate < 0, -12, -17.5 > }//to ground floor
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end east frame union

// **************************************************************

//   DEFINE  a railing section:
#declare N_East_Railing =
object {
   Railing_Section_A ( 2, 0.25, 7 )
   rotate y*90
       } // end east interior railing

// **************************************************************

//    DEFINE  north room: east wall panels:
#declare N_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  6.5,  18 >;  // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -18 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"                
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  4.0,  13.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -4.0, -13.5 >; // left lower front corner
         #include "roundbox.inc"                
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 26.5 > }
   #end
      } // end east panel union

// **************************************************************

//    DEFINE  north room: west wall frame:
#declare N_West_Frame =
union {
   object { CubeY1  
            scale < 1, 12, 1 >  translate < 0, 0,  17.5 > }//n
   object { CubeY1  
            scale < 1, 12, 1 >  translate < 0, 0,  10.5 > }//
   object { CubeY1  
            scale < 1, 12, 1 >  translate < 0, 0,   4.5 > }//
   //west chimney goes here...
   object { CubeY1  
            scale < 1, 12, 1 >  translate < 0, 0,  -7.5 > }//
   object { CubeY1  
            scale < 1, 12, 1 >  translate < 0, 0, -17.5 > }//s
   object { CubeZ1
            scale < 1, 1, 35.5 >  translate < 0,  6, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 35.5 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } //end west frame union

// **************************************************************

//    DEFINE  north room: west wall panels:
#declare N_West_Panel =
union {
   object {
      #declare RB_P1 = <  1.1, 12.5,  -6 >;  // right upper rear corner
      #declare RB_P2 = < -1.1, -0.5, -18 >;  // left lower front corner
      #declare RB_Thickness = 2;      
      #declare RB_Solid = 1;          
      #include "roundbox.inc"                
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #end
          }//end upper southern panel
   object {
      #declare RB_P1 = <  1.1, 12.5, 10 >;  // right upper rear corner
      #declare RB_P2 = < -1.1, -0.5, 18 >;  // left lower front corner
      #declare RB_Thickness = 2;      
      #declare RB_Solid = 1;          
      #include "roundbox.inc"                
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #end
          }//end upper northern panel
   //above door brick panel:
   object { UnitBox
            scale < 3.6, 2.25, 0.25 >
            rotate y*90
            translate < 0, -2, 14 >
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { T_MBH_Brick_1  scale < 0.02, 0.02, 0.02 > }
            #end
          }//end above door
   //window, north of door:
   object { Pane_Square_2  rotate y*90
                           scale < 0.05, 24, 6 > 
                           translate < 0, 0, 7.5 > 
          }//end n window 
   //window, south of door:
   object { Pane_Square_2  rotate y*90
                           scale < 0.05, 7.7, 2.9 > 
                           translate < 0, -7.7, 16 > 
          }//end s window 
      } // end west panel union

// **************************************************************
//    DEFINE   a bathroom:
// **************************************************************

#declare Bathroom_1 =
union {
   //drop ceiling:
   object { Build_Block_1
            texture { White_Tex }
            scale < 15.5, 0.25, 10 >
            translate < 0, 3, -5 >
          }//end drop ceiling
   //ceiling lights:
   #if ( ShowLights = 1 )
      object { Lamp_B  translate <  3, 2.8, -3 > }
      object { Lamp_B  translate < -3, 2.8, -3 > }
      object { Lamp_B  translate <  3, 2.8, -6 > }
      object { Lamp_B  translate < -3, 2.8, -6 > }
   #end
   //frames:
   union {
      object { CubeY1  
               scale < 1, 12, 1 >  translate < 7.5, 0, 0 > }
      object { CubeX1
               scale < 14, 1, 1 >  translate < 0, 6, 0 > }
      #if ( ShowDetails = 0 )
         texture { Red_Tex }
      #else
         texture { T_Wood2 scale < 2, 4, 2 > }
      #end
         }//end frames
   //wall: facing north:
   difference {
      box { < -7.2, -6.1, -0.25 > < 7.6, 6.2, 0.25 > }
      box { < -1.5, -3.5, -1.00 > < 1.5, 3.5, 1.00 > 
            translate < 6, -2.5, 0 > }
      #if ( ShowDetails = 0 )
         texture { DarkWood_Tex }
      #else
         texture { T_Wood2  scale < 4, 8, 1 > }
      #end
              }//end diff. north wall
   //door:
   object { DoorA2  translate < 6, -2.5, 0 > }
/*
   //wall: facing east:
   box { < -0.25, -6.2, -5.0 > < 0.25, 6.2, 5.0 >
         translate < 7.5, 0, -5 >
      #if ( ShowDetails = 0 )
         texture { DarkWood_Tex }
      #else
         texture { T_Wood2  scale < 4, 8, 1 > }
      #end
       }//end east wall
*/
   //panel: top of south window:
   object { Build_Block_1
            scale < 15.5, 2.9, 10 >
            translate < 0, 4.5, -5 >
            #if ( ShowDetails = 0 )
               texture { Blue_Tex }
            #else
               texture { T_Wood2  scale < 4, 8, 1 > }
            #end
          }//end drop ceiling

   //tub:
   object {
      difference {
      object {
         #declare RB_P1 = <  4,  1.5,  2 >; // right upper rear corner
         #declare RB_P2 = < -4, -1.5, -2 >; // left lower front corner
         #include "roundbox.inc"              // calls file
             }//end body of tub
      object {
         #declare RB_P1 = <  3,  2.0,  1.5 >; // right upper rear corner
         #declare RB_P2 = < -3, -1.0, -1.5 >; // left lower front corner
         #include "roundbox.inc"              // calls file
             }//end basin of tub
      #if ( ShowDetails = 0 )
         texture { Yellow_Tex }
      #else
         texture { Yellow_Tex }//change later! <<
      #end
                 }//end diff.
      translate < 3.5, -4.5, -8 >
          } // end obj tub
   //sink:
   object {
      box { < -3, -1.75, -1.25 > < 3, 1.75, 1.25 >
      #if ( ShowDetails = 0 )
         texture { Blue_Tex }
      #else
         texture { Blue_Tex }//change later! <<
      #end }//end box
      translate < 0, -3.9, -1.5 >
       }//end sink
   //toilet:
   union {
      box { < -1, -0.3, 0.15 > < 1, 1, 1.2 > }
      cylinder { -0.2*y, -1.3*y,  1 }
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { Green_Tex }//change later! <<
      #end
      translate < -5.5, -4.4, -1.5 >
         }// end union toilet
   //shower:
   object {
      difference {
         box { < -2.5, -4.0, -2.5 > < 2.5, 4.0, 2.5 > }//end outer box
         box { < -2.4, -3.8, -2.4 > < 2.4, 3.8, 2.7 > }//end inner box
                 }//end diff.
      #if ( ShowDetails = 0 )
         texture { Orchid_Tex }
      #else
         texture { T_Glass1 }
      #end
      translate < -4.5, -2, -7.5 >
       }//end shower stall
        } // end bathroom

// **************************************************************

// *******************************************************************
//       C.  East Room:
// *******************************************************************

//    DEFINE  east room roof:
#declare East_Roof =
union {
   object {
      #declare RB_P1 = <  25.0,  1.05,  10 >;  // right upper rear corner
      #declare RB_P2 = < -23.0, -1.05, -10 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 30, 12.5, 26 > 
         }//end north section roof
   object {
      #declare RB_P1 = < 15.0,  1.05,  25.5 >;  // right upper rear corner
      #declare RB_P2 = <  2.5, -1.05, -27.5 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 40, 12.5, 6 > 
         }//end east section roof
   object {
      #declare RB_P1 = <  25.0,  1.05,  13 >;  // right upper rear corner
      #declare RB_P2 = < -21.0, -1.05, -14 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 30, 12.5, -30 > 
         } // end south section roof
   #if ( ShowDetails = 0 )
      texture { Coral_Tex }
   #else
      texture { T_Stone24 }
   #end
      } // end union east wing roof

// **************************************************************

//    DEFINE  East room, south (and north) wall frames:
#declare E_South_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -20, 0, 0 > }//w
   object { CubeY1
            scale < 1, 12, 1 >  translate < -11, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <  11, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <  20, 0, 0 > }//e
   object { CubeX1
            scale < 40.5, 1, 1 >  translate < 0,  6, 0 > }//top
   object { CubeX1
            scale < 40.5, 1, 1 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Magenta_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      }// end south frame union 

// **************************************************************

//    DEFINE East room, south panel:
#declare E_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  21,  6.5,  1.1 >;  // right upper rear corner
         #declare RB_P2 = < -21, -6.5, -1.1 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  18,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -18, -4.0, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2 scale < 39, 10, 0.05 > }//center window
   #end
         }// end front/south wall panels
 
// **************************************************************

//    DEFINE  East room, east frames:
#declare E_East_Frame =
union {
   object { rotated_Frame_A  translate < 0, 0,  0 > }
   object { rotated_Frame_A  translate < 0, 0, 10 > }
   object { rotated_Frame_A  translate < 0, 0, 20 > }
   object { rotated_Frame_A  translate < 0, 0, 40 > }
   object { rotated_Frame_A  translate < 0, 0, 50 > }
   object { rotated_Frame_A  translate < 0, 0, 60 > }
   #if ( ShowDetails = 0 )
      texture { Magenta_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      }// end east wall union 

// **************************************************************

//    DEFINE  east room: east wall panels:
#declare E_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  6.5,  15.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -15.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  4.0,  10.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -4.0, -10.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4.5 > }
      #end
      translate z*21
              }//end difference north
   difference {
      object {
         #declare RB_P1 = <  1.1,  6.5,  15.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -15.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  4.0,  11 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -4.0, -11 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4.5 > }
      #end
      translate z*-20
              }//end difference south
   object {
      object {
         #declare RB_P1 = <  1.1,  6.5,  8 >;  // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -8 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end center panel
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
          }//end middle panel
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               rotate y*90 scale < 0.05, 11, 25 > translate z*22.5 }
      object { Pane_Square_2
               rotate y*90 scale < 0.05, 11, 25 > translate z*-20 }
   #end
      } // end east window panel union

// **************************************************************

//    DEFINE  East room, west frames:
#declare E_West_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0, -20 > }//s
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0,  -5 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0, 7.5 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0,  20 > }//n
   object { CubeZ1
            scale < 1, 1, 40.5 >  translate < 0,  6, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 40.5 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Magenta_Tex }
   #else
      texture { T_Wood2  scale < 2, 2, 4 > }
   #end
      } // end west wall union 

// **************************************************************

//    DEFINE  East room, west panels:
#declare E_West_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  6.5,  7 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -6.5, -7 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  4.0,  5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -4.0, -5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 11, 11 > }
   #end
      } // end union west panel

// **************************************************************

// *******************************************************************
//       D.  West Room: 
// *******************************************************************

//    DEFINE  West room roof:
#declare West_Roof =
object {
   #declare RB_P1 = <  23,  1.05,  22 >;  // right upper rear corner
   #declare RB_P2 = < -23, -1.05, -22 >;  // left lower front corner
   #include "roundbox.inc"
   #if ( ShowDetails = 0 )
      texture { Green_Tex }
   #else
      texture { T_Stone24 }
   #end
      } // end west roof

// **************************************************************

//    DEFINE  West room: north wall frames:
#declare W_North_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < -18, 0, 0 > }//w
   object { CubeY1
            scale < 1, 12, 1 >  translate <  18, 0, 0 > }//e
   object { CubeY1
            scale < 1, 12, 1 >  translate <  1, 0, 0 > }//mid w
   object { CubeY1
            scale < 1, 12, 1 >  translate <  13, 0, 0 > }//mid e
   object { CubeX1
            scale < 36.5, 1, 1 >  translate < 0,  6, 0 > }//top
   object { CubeX1
            scale < 36.5, 1, 1 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room north frames

// **************************************************************

//    DEFINE  West room: north panel:
#declare W_North_Panel =
union {
   //solid panel w/ window hole:
   difference {
      object {
         #declare RB_P1 = <  13.0,  6.5,  1.01 >; // right upper rear corner
         #declare RB_P2 = < -12.0, -6.5, -1.01 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  11.5,  4.0,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -10.5, -2.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #end
              }//end difference
   //glass in windows:
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 22, 9, 0.05 >
               translate < 0.5, 0, 0 > 
             }//window
   #end // show windows?
      } // end west room north panels

// **************************************************************

//    DEFINE  West room: south wall frames:
#declare W_South_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate <  -17, 0, 0 > }//w
   object { CubeY1   
            scale < 1, 12, 1 >  translate <  8.5, 0, 0 > }
   object { CubeY1
            scale < 1, 12, 1 >  translate <   17, 0, 0 > }//e
   object { CubeX1
            scale < 34.5, 1, 1 >  translate < 0,  6, 0 > }//top
   object { CubeX1
            scale < 34.5, 1, 1 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room south frames

// **************************************************************

//    DEFINE  West room: south panel:
#declare W_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  18.5,  6.5,  1.01 >;  // right upper rear corner
         #declare RB_P2 = < -18.5, -6.5, -1.01 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  15, 0.65,  2.5 >; // right upper rear corner
         #declare RB_P2 = <   1, -1.5, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 20, 7.2, 0.05 >
               translate < 10, 1, 0 > 
             }//center window
   #end                  
      } // end west room south panels

// **************************************************************

//    DEFINE  West room: west wall frames:
#declare W_West_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0,  15 > }//n
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0,  -7.5 > }//middle
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0, -15 > }//s
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  6, 0 > }//top
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0, -6, 0 > }//bot
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 2, 4 > }
   #end
      } // end west room west frames

// **************************************************************

//    DEFINE  West room: west wall panels:
#declare W_West_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.01,  6.5,  16 >; // right upper rear corner
         #declare RB_P2 = < -1.01, -6.5, -16 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  -3 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -2.5, -12 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15  scale < 1.5, 2, 4 > }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 25 > }
   #end
      } // end west wall window panels

// **************************************************************

//    DEFINE  West room: east wall frames:
#declare W_East_Frame =
union {
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0, -5.25 > }//middle
   object { CubeY1
            scale < 1, 12, 1 >  translate < 0, 0, -15 > }//front
   object { CubeZ1
            scale < 1, 1, 30 >  translate < 0,  6, 0 > }//top
   #if ( ShowDetails = 0 )
      texture { Goldenrod_Tex }
   #else
      texture { T_Wood2 scale < 2, 4, 2 > }
   #end
      } // end west room east frames

// **************************************************************

//    DEFINE  West room: east wall panels:
#declare W_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.01,  6.5,   7.5 >; // right upper rear corner
         #declare RB_P2 = < -1.01, -6.5, -10.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  2.5,  6.0 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -1.5, -6.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 0 )
         texture { Goldenrod_Tex }
      #else
         texture { T_Stone15 scale < 1.5, 2, 4 >  }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 13 > }
   #end
      } // end east wall window panel

// **************************************************************
// **************************************************************
//    DEFINE  Kitchen Fixtures:
// **************************************************************

//    DEFINE  a stove:
#declare Stove_1 =
union {
   //hood:
   intersection {
      box { < 5.85, 9.00,  1.00 > < -5.85,  6.00, -1.75 > } 
      plane { y, 1
              scale < 5, 5, 0.25 >
              rotate x*45
              translate y*0.3
            }//end plane
      #if ( ShowDetails = 0 )
         texture { Green_Tex }
      #else
         texture { T_Copper_3D }
      #end 
                }// end intersected  box
   //body:
   box { < 5.85, 1.75,  1.75 > < -5.85, -1.75, -1.75 >
         #if ( ShowDetails = 0 )
            texture { FireBrick_Tex }
         #else
            texture { T_Chrome_2C }
         #end }
   //vent stack:
   box { < 1.55, 11.5, -0.85 > < -1.55,  1.00, -1.75 >
         #if ( ShowDetails = 0 )
            texture { Blue_Tex }
         #else
            texture { T_Copper_3D }
         #end }
   //back panel:
   box { < 5.85, 7.00, -1.40 > < -5.85,  1.50, -1.70 >
         #if ( ShowDetails = 0 )
            texture { Red_Tex }
         #else
            texture { T_Chrome_2C }
         #end }

#if (ShowDetails = 1 )
   //oven doors:
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -4, 0.2, 1.75 >
         texture { Black_Tex } }
   box { < 1.00, 1.00,  0.05 > < -1.00, -1.00, -0.05 > 
         translate < -1, 0.2, 1.75 >
         texture { Black_Tex } }
   //utility drawers:
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  1.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50,  0.5, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.0, 1.76 >
         texture { Black_Tex } }
   box { < 1.70, 0.2, 0.05 > < -1.50, -0.2, -0.05 > 
         translate < 2.50, -0.5, 1.76 >
         texture { Black_Tex } }
   //burners:
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.5, 0.0
          rotate x*90
          translate < 1, 1.75,  1.0 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, -0.3 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -1.5, 1.75, 1 > 
          texture { Black_Tex } }
   disc { < 0, 0, 0 >  z, 0.4, 0.0
          rotate x*90
          translate < -0.25, 1.75, 1 > 
          texture { Black_Tex } }
   //grills:
   box { < 1.4, 0.1, 1.4 > < -1.4, -0.1, -1.4 >
         translate < -4, 1.67, 0.2 >
         texture {Black_Tex} }
   box { < 1.1, 0.1, 1.4 > < -1.1, -0.1, -1.4 >
         translate <  4, 1.67, 0.2 >
         texture {Black_Tex} }
#end

   #if ( ShowLights = 1 )
      //hood lights:
      object { Lamp_A  translate <  4, 6, 0 > }
      object { Lamp_A  translate < -4, 6, 0 > }
   #end
      } // end stove

// **************************************************************
// **************************************************************

//    DEFINE  a table: 10x 0.5y 4.5z
#declare Table_1 =
union {
   //top:
   object {
      box { < 5, 0.20, 2.25 > < -5, -0.20, -2.25 > }
            #if ( ShowDetails = 0 )
               texture { Orchid_Tex }
            #else
               texture { T_Wood3 
                         scale < 3, 1, 2 >
                         rotate y*90 rotate x*8
                         finish { specular 0.3 
                                  roughness 1.0
                                  reflection 0.15 }
                       }//end tex
            #end 
          }//end table top
   //legs:
   union {                             
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate <  2.5, -1.75, -1.5 > }//right front
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate <  2.5, -1.75,  1.5 > }//right rear
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate < -2.5, -1.75, -1.5 > }//left front
      object {
         box { < 0.20, 1.75, 0.20 > < -0.20, -1.75, -0.20 > }
               translate < -2.5, -1.75,  1.5 > }//left rear
      #if ( ShowDetails = 0 )
         texture { Orchid_Tex }
      #else
         texture { T_Wood3 
                   scale < 1, 3, 2 >
                   rotate y*90 rotate x*8
                   finish { specular 0.3 
                            roughness 1.0
                            reflection 0.15 }
                 }//end tex
      #end 
         }// end union legs
   //feet:
   union {
      object { 
         box { < 2.50, 0.20, 0.20 > < -2.50, -0.20, -0.20 > }
               translate <  0.0, -3.35, 0.0 > }//center bottom foot
      object {
         box { < 2.50, 0.20, 0.20 > < -2.50, -0.20, -0.20 > }
               translate <  0.0, -0.45, 0.0 > }//center top foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate <  2.5, -3.35, 0.0 > }//right foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate < -2.5, -3.35, 0.0 > }//left foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate <  2.5, -0.45, 0.0 > }//right foot
      object { 
         box { < 0.20, 0.20, 1.70 > < -0.20, -0.20, -1.70 > }
               translate < -2.5, -0.45, 0.0 > }//left foot
      #if ( ShowDetails = 0 )
         texture { Orchid_Tex }
      #else
         texture { T_Wood3 
                   scale < 2, 1, 3 >
                   rotate y*90 rotate x*8
                   finish { specular 0.3 
                            roughness 1.0
                            reflection 0.15 }
                 }//end tex
      #end 
         }// end union feet
     } // end union table

// **************************************************************
// **************************************************************

//    DEFINE  a hanging cabinet: 18x 4y 3z:
#declare Cabinet_1 =
object {
   box { < 9.0, 2.0, 1.5 > < -9.0, -2.0, -1.0 > }
   #if ( ShowDetails = 0 )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 scale < 1, 3, 1 > }
   #end
       } // end cabinet 1

// **************************************************************
// **************************************************************

//    DEFINE  a counter: 12x 3y 3z:
#declare Counter_1 =
object {
   box { < 6.0, 1.5, 1.5 > < -6.0, -1.5, -1.5 > }
   texture { Coral_Tex }
       } // end counter 1

// **************************************************************

//    DEFINE  a counter: 3x 3.5y 12z:
#declare Counter_2 =
union {
   box { < 1.6, 1.74, 6.0 > < -1.6, -1.75, -6.0 >
         #if ( ShowDetails = 0 )
            texture { Orchid_Tex }
         #else
            texture { T_Wood2 scale < 1, 1, 5 > }
         #end }
   box { < 1.7, 1.75, 6.0 > < -1.7, 1.70, -6.0 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end }
      } // end counter 2

// **************************************************************

//    DEFINE  a cylinder counter: 5x 3.5y 4.5z:
#declare Counter_3 =
union {
   object {
      cylinder { 1.74*y, -1.75*y, 2.20 }
         #if ( ShowDetails = 0 )
            texture { Violet_Tex }
         #else
            texture { T_Wood2 scale < 1, 5, 1 > }
         #end
          }//body
   object { 
      cylinder { 1.75*y, 1.70*y, 2.30 }
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end
          }//top
      } // end union cyl counter 3

// **************************************************************

//    DEFINE  a counter: 12x 3.5y 12z:
#declare Counter_4 =
union {
   box { < 8.0, 1.74, 1.5 > < -8.0, -1.75, -1.5 >
         #if ( ShowDetails = 0 )
            texture { Yellow_Tex }
         #else
            texture { T_Wood2 scale < 1, 1, 5 > }
         #end }//body
   box { < 8.0, 1.75, 1.6 > < -8.0, 1.70, -1.6 >
         #if ( ShowDetails = 0 )
            texture { Black_Tex }
         #else
            texture { Spex }
         #end }//top
      } // end counter 4

// **************************************************************
// **************************************************************

//    DEFINE  a sink: 3x 3.5y 12z:
#declare Sink_1 =
union {
   box { < 1.6, 1.75, 6.0 > < -1.6, -1.75, -6.0 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { White_Tex }
         #end }//end box
   //over sink:
   object { Lamp_A  translate < -0.9, 8, 0 > }//end lamp
      } // end union sink

// **************************************************************
// **************************************************************

//    DEFINE a refrigerator:
#declare Frig_1 =
object {
   box { < 1.5, 3.5, 2.7 > < -1.5, -3.5, -2.7 > }
   texture { Blue_Tex }
       } // end frig

// **************************************************************
// **************************************************************

//    DEFINE  generic kitchen:
#declare W_Kitchen =
union {
   object { Table_1    translate <   3.0, 3.50,   8.5 > }
   object { Cabinet_1  translate <   7.5, 8.00, -13.0 > }//top south
   //prep area:
   object { Stove_1    translate <  -7.5, 1.75, -12.5 > }//sw corner
   object { Sink_1     translate < -15.0, 1.75,  -8.0 > }//west side
   object { Counter_2  translate <   0.0, 1.75,  -8.0 > }//center
   object { Counter_3  translate <   0.0, 1.75,  -2.5 > }//center
   object { Counter_2  translate <  15.0, 1.75,  -5.0 > }//east side
   object { Counter_4  translate <   9.0, 1.75, -12.5 > }//southeast 
   object { Frig_1     translate < -15.0, 3.50,  0.75 > }
      } // end kitchen fixtures


// *******************************************************************
// *******************************************************************
//  IV.   a Modernist/International Style House:
// *******************************************************************
// *******************************************************************

/*
#declare Modernist_Home =
union {

   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk
            translate z*-30 }

   object { Arched_Hall_1
            translate < 0, 5, -30 >
          }// end arched hallway

   object { Planter_Box_2  translate < -17, 1, -24 > }
   object { 
      box {< -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
           pigment { VeryDarkBrown } }
      translate < -17, 1, -24 >
          }// end generic dirt

      } // end union modernist house
*/

// *******************************************************************
// *******************************************************************
// M_HOME00.INC   (c) Michael Brendan Hurley   Winter 2000-Winter 2001
//    www.geocities.com/mbrendanh/                 mbhcgc@saber.net
// *******************************************************************
// *******************************************************************
