// *******************************************************************
// M_HOME00.INC                                    Ver 2.0 Winter 2000
//         Definitions of assorted basic objects and effects         
//            for draft  of  Modernist_House  version 2.0
// *******************************************************************
//
// INClude File "Sub-Contractors":
//
// RoundBox.inc for POV 3.0 and above
// (c) Philip Cowley (philip.cowley@totem.co.uk) 13/07/97
//
// Leaf & Tree macro for Pov-ray 3.1 & higher
// (c) 1999 Gilles Tran (tran@inapg.inra.fr)
//
// *******************************************************************


// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

#include "brendan.inc"                 // universal scene objects
                                       // and calls to support INC's

// *******************************************************************
// *******************************************************************
// II.     DEFINE Structural Components
// *******************************************************************
// *******************************************************************
//    A.   Basic Objects
// **************************************************************

//    DEFINE  a torus for pillars
#declare Torus_1 =
torus { 0.5,       // MAJOR = radius of whole ring
        0.2        // MINOR = radius of tube
      } // end torus 1

// **************************************************************

//    DEFINE  generic scalable building block: 1x 1y 1z:
#declare Build_Block_1 =
box { <-0.5, -0.5, -0.5>  < 0.5, 0.5, 0.5 > } // end bldg block 1

// ************************************************************** 

//    DEFINE  generic scalable building block: 2x 2y 2z:
#declare Build_Block_2 =
object {
   #declare RB_P1 = <  1,  1,  1 >;    // right upper rear corner
   #declare RB_P2 = < -1, -1, -1 >;    // left lower front corner
   #declare RB_Thickness = 1;          // assumes 1 if not defined
   #declare RB_Solid = 0;              // assumes "On" if not defined
   #include "roundbox.inc"             // calls file
      } // end bldg block 2

// **************************************************************

//    DEFINE  generic scalable cylinder with spherical ends:
#macro Round_Post_Y ( Post_Size_Y , Post_Size_X )
union {
   cylinder { Post_Size_Y*y, -(Post_Size_Y)*y, Post_Size_X open }//end cyl
   sphere { < 0,  Post_Size_Y, 0 >  Post_Size_X }//end top ball
   sphere { < 0, -Post_Size_Y, 0 >  Post_Size_X }//end bottom ball
      } // end union scalable post
#end // macro for y pillar

// **************************************************************
// **************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.7, 0.7, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 2

// **************************************************************

//    DEFINE   a large THICK arch/roof/barrel dome:
#declare BigArch_1 =
object { Arch_Z1  scale < 5, 4.75, 5 > } // end big arch v.1

// **************************************************************

//    DEFINE   a large THIN arch/roof/barrel dome:
#declare BigArch_2 =
object { Arch_Z2  scale < 10, 9.5, 5 > } // end big arch v.2

// **************************************************************

//    DEFINE  Interior of frame has rounded corners: roundbox.inc cut-out
#declare ArchWay_1 =
   difference {
   union {
      object { CubeY1
               scale < 2, 10, 2 >
               translate x*-5 
             } // end left
      object { CubeY1
               scale < 2, 10, 2 >
               translate x*5 
             } // end right
      object { CubeX1
               scale < 10.75, 3.25, 2 >
               translate y*5 
             } // end top
         }//inner frame union
   object {
      #declare RB_P1 = <  4.75,  5.25,  5 >;
      #declare RB_P2 = < -4.75, -5.25, -5 >;
      #declare RB_Thickness = 2;      //Assumes 1 if not defined
      #declare RB_Solid = 0;          //Assumes "On" if not defined
      #include "roundbox.inc"
      translate < 0, -0.25, 0 >
          } //end roundbox cut-out
              } // end difference arch way 1

// **************************************************************
// **************************************************************

//    DEFINE  scalable banisters/fensing/frames:
//            base post centered at <0,0,0>
//            other posts, railings translated +x +y

#macro Railing_Section_A ( How_Tall, How_Wide, How_Many )
   //declare local variables:
   #local Post_Size_Y = How_Tall; //duh...?
   #local Post_Size_X = How_Wide; //
   #local How_Many    = How_Many; //
   //call macro:
   union {
      #local P_Count = 0;
      #while ( P_Count <= How_Many )
         object {            
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            translate < (P_Count*(How_Tall*2)), 0, 0 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { pigment { Brass} }
            #end
                }//end all posts
         object {
            Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
            rotate z*90
            translate < (P_Count*(How_Tall*2)+How_Tall), (How_Tall), 0 >
            #if ( ShowDetails = 0 )
               texture { Blue_Tex }
            #else
               texture { pigment { Brass} }
            #end
                }//end railings
         #if ( P_Count = How_Many )
            object {           //last post:
               Round_Post_Y ( Post_Size_Y , Post_Size_X )//end macro call
               translate < (P_Count*(How_Tall*2))+(How_Tall*2), 0, 0 >
               #if ( ShowDetails = 0 )
                  texture { Red_Tex }
               #else
                  texture { pigment { Brass} }
               #end
                   }//end add last post
         #end
         #declare P_Count = ( P_Count + 1 );
      #end //while loop
         } // end union scalable railing
 #end // macro for railing section

// *******************************************************************
//    B.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x / 10y units
#declare Frame_A =
union {
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0,  5, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0, -5, 0 > }
      } // end Frame A

// **************************************************************

//    DEFINE  rotated frame:
#declare rotated_Frame_A =
object { Frame_A  rotate y*90 }

// **************************************************************

//   DEFINE   a frame 10x / 10y units: thicker beams:
#declare Frame_A2 =
union {
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate < -5, 0, 0 > }
   object { CubeY1
            scale < 1.25, 10.0, 1.25 >  translate <  5, 0, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0,  5, 0 > }
   object { CubeX1
            scale < 10.5, 1.25, 1.25 >  translate < 0, -5, 0 > }
      } // end Frame A2

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 0.5, 2.75, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 0.5, 2.75, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y 0.5z:
#declare Frame_D =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  5, 0 > }
      } // end Frame D

// **************************************************************

//   DEFINE   thicker version of D, 5x 10y 1z:
#declare Frame_D2 =
union {
   object { CubeY1
            scale < 1, 10, 1 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 1, 10, 1 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale <  5, 1, 1 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale <  5, 1, 1 >  translate < 0,  5, 0 > }
      } // end Frame D 2

// *******************************************************************
//    C.   Frames: Single: Window:
// *******************************************************************

// *******************************************************************
//    D.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10.5x 10.5y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5.25, 5.25, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10.5x 5.5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5.25, 2.75, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10.5x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5.25, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 6x 10.5y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 3, 5.5, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5.5x 5.5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.75, 2.75, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5.5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.75, 1.25, 0.25 > } // end panel f

// *******************************************************************
//    E.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( ShowDetails = 0 )
            texture { White_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// *******************************************************************
//    F.   Front Yard & Landscaping:
// *******************************************************************

#include "l_scape.inc"                 // landscaping
 
// *******************************************************************
// *******************************************************************
//
//    NOTE THIS:  All declarations above this point are of 
//                free-standing objects centered on <0,0,0> that
//                may be transformed for use in any scene.
//                The objects below are transformed for this scene only.
//
// *******************************************************************
// *******************************************************************
// III.  DEFINE  Modernist_Home:
// *******************************************************************
//       A.  Specialized Components:
// **************************************************************

//    DEFINE  front hall with arched roof: 20x 20y 40z:
#declare Arched_Hall_1 =
union {
   #declare Move_Count = 1;       // start count
   #declare From_Z = -25;         // from where? >>REQUIRES HARD CODING<<
   #declare Move_It = +10.5;      // how far? 
   #declare Max_Count = 4;        // how many?

   #while ( Move_Count <= Max_Count )
      object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < 10, 0.5, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Green_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs east
     object { ArchWay_1
               rotate < 0, 90, 0 >
               translate < -10, 0.5, (From_Z + Move_It) >
               #if ( ShowDetails = 0 )
                  texture { Yellow_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end rounded wall archs west

      #if ( ShowArch = 1 )   //display entry barrel roof

      object { Arch_Z2 
               scale < 10, 9.5, 1 >
               translate < 0, 6.5, (From_Z + Move_It-5) >
               #if ( ShowDetails = 0 )
                  texture { Red_Tex }
               #else
                  texture { T_Wood2  scale < 1, 5, 1 > }
               #end
             }// end arch frames

         #if ( Move_Count < Max_Count ) //skip northmost section
         object { BigArch_2 
                  translate < 0, 6.5, (From_Z + Move_It) >
                  #if ( ShowDetails = 0 )
                     texture { Magenta_Tex }
                  #else
                     texture { T_Glass1 }
                  #end // texture choices
                }//end barrel roof
         #end // if < Max Count
      #end // if Show Arch

      #declare From_Z = ( From_Z + Move_It ); 
      #declare Move_Count = Move_Count + 1;
   #end//of while loop
      } // end union arched hallway

// **************************************************************

//    DEFINE a sidewalk/driveway:
#declare Front_SideWalk =
object { UnitBox
         scale < 10, 0.5, 22 >
         translate < 0, 0.6, 0 >
         #if ( ShowDetails = 0 )
            texture { Coral_Tex }
         #else
            texture { T_Stone2  scale < 1, 1, 5 > }
         #end
       } // end sidewalk

// *******************************************************************
// *******************************************************************

//   DEFINE   basic door frame inset for 10x 10y Frame_A
#declare Frame_Door_A1 =
union {
   object { CubeY1                                        
            scale < 1.5, 8, 1.5 >  translate < -2.25, -1, 0 > }
   object { CubeY1                                       
            scale < 1.5, 8, 1.5 >  translate <  2.25, -1, 0 > }
   object { CubeX1                                        
            scale < 10, 1.5, 1.5 >  translate < 0, 3, 0 > }
   #if ( ShowDetails = 0 )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end Frame for Door  A1

// **************************************************************

//   DEFINE  a 4x 7y door: CLOSED
#declare DoorA1_Closed =
union {
   difference {
      object { UnitBox
               scale < 2, 3.8, 0.10 >
             }//end main panel
      object { UnitBox
               scale < 1.25, 0.4, 1 >
               translate y*1
             }//end cut-out bottom
      object { UnitBox
               scale < 1, 0.3, 1 >
               translate < 0.25, 2.1, 0 >
             }//end cut-out
      object { UnitBox
               scale < 0.75, 0.2, 1 >
               translate < 0.5, 3, 0 >
             }//end cut-out
               #if ( ShowDetails = 0 )
                  texture { Gray50_Tex }
               #else
                  texture { EMBWood1  scale < 2, 11, 2 > }
               #end
              }//end difference
   object { UnitBox 
            scale < 1.4, 1.65, 0.02 >
            translate < 0, 1.9, 0 > 
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               #if ( ShowGlass = 0 )
                  texture { Black_Tex }
               #else  
                  texture { T_Glass1 }
               #end
            #end
          } //end window glass
   object { sphere { <0, 0, 0>  0.25 }
            translate < -1.5, -0.5, -0.19 >
            #if ( ShowDetails = 0 )
               texture { Yellow_Tex }
            #else
               texture { Bright_Bronze }
            #end
          }//end knob
      }//end union door 1a closed

// **************************************************************

//   DEFINE  a 4x 7y door: OPEN
#declare DoorA1_Open =
object { DoorA1_Closed
         rotate y*-45
         translate < -0.75, 0, -1.5 >
       } // end Door A1 open

// **************************************************************

//   DEFINE  set of solid wall panels scaled for Door_Front
#declare Panel_Door_A1 =
union {
   object { UnitBox
            scale < 5, 1, 0.25 >  translate < 0, 4.25, 0 >
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { T_MBH_Brick_1  scale < 4, 1, 4 > }
            #end
          }//upper brick panel
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate < -3.5, -1, 0 > 
          }//left glass
   object { UnitBox
            #if ( ShowDetails = 0 )
               texture { Black_Tex }
            #else
               texture { T_Glass1 }//end textr
            #end      
            scale < 1.5, 4, 0.1 >  translate <  3.5, -1, 0 > 
          }//right glass
      } // end Panels New Door A1

// **************************************************************

//    DEFINE  a front door:
#declare M_Front_Door =
union {
   //frames & panels:
   object { Frame_A2
            #if ( ShowDetails = 0 )
               texture { Red_Tex }
            #else
               texture { T_Wood2  scale < 1, 5, 1 > }
            #end
          } //south front frame
   object { Panel_Door_A1 } //south front panels
   //door:
   object { Frame_Door_A1 } // door jams
   #if ( DoorOpen = 0 )
      object { DoorA1_Closed  translate y*-1.2 }
   #else
      object { DoorA1_Open  translate y*-1.2 }
   #end
      }//end door union

// **************************************************************
// **************************************************************


// **************************************************************
// **************************************************************
//       B.  North Room:
// **************************************************************

//    DEFINE  north room roof:
#declare North_Roof =
union {
   object {
      #declare RB_P1 = <  10,  1.25,  21 >; // right upper rear corner
      #declare RB_P2 = < -10, -1.25, -21 >; // left lower front corner
      #include "roundbox.inc"              // calls file
      translate < -19.5, 21, 0 > 
          } // end west section roof
   object {
      #declare RB_P1 = <  13.5,  1.25,  14.5 >;
      #declare RB_P2 = < -13.5, -1.25, -14.5 >;
      #include "roundbox.inc"
      translate < 0, 21, 6 > 
          } // end center section roof
   object {
      #declare RB_P1 = <  19.5,  1.25,  21 >;
      #declare RB_P2 = < -19.5, -1.25, -21 >;
      #include "roundbox.inc"
      translate < 29, 21, 0 > 
          } // end east section roof
   #if ( ShowDetails = 0 )
      texture { Gray_Tex }
   #else
      texture { T_Stone5 scale < 10, 2, 1.5 > }
   #end
      } // end north roof union

// **************************************************************

//    DEFINE  north room chimneys:
#declare North_Chimneys =
union {
   union  {                            // chimney southeast
      object { Build_Block_1
               scale < 12, 28, 5 >
               translate < 22, 14.5, -17.5 >
               #if ( ShowDetails = 0 )
                  texture { FireBrick_Tex }
               #else
                  texture { T_MBH_Brick_1  scale < 0.4, 0.1, 0.4 > }
               #end
             }// end chimney
         object { Build_Block_1
                  scale < 14, 1.5, 6 >
                  translate < 22, 28.5, -17.5 >
                  texture { Gray95_Tex }
                }// end cap
         object { Build_Block_1
                  scale < 14.5, 1.75, 6.5 >
                  translate < 22, 1.5, -17.5 >
                  texture { Gray95_Tex }
                }// end footer
          }// end southeast chimney union
   union  {                            // chimney northwest
      object { Build_Block_1
               scale < 5, 28, 12 >
               translate < -25, 14.5, -1.5 >
               #if ( ShowDetails = 0 )
                  texture { FireBrick_Tex }
               #else
                  texture { T_MBH_Brick_1  scale < 0.4, 0.1, 0.4 > }
               #end
             }// end chimney
         object { Build_Block_1
                  scale < 6, 1.5, 14 >
                  translate < -25, 28.5, -1.5 >
                  texture { Gray95_Tex }
                }// end cap
         object { Build_Block_1
                  scale < 6.5, 1.75, 14.5 >
                  translate < -25, 1.5, -1.5 >
                  texture { Gray95_Tex }
                }// end footer
          }// end west chimney union
      } // end north room chimneys

// **************************************************************

//    DEFINE  north room: north wall frame: 1st floor:
#declare N_North_Frame_Up =
union {
   union {
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate < -12.5, 0, 0 > }//w
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <  -6.5, 0, 0 > }
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <   6.5, 0, 0 > }
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <  12.5, 0, 0 > }//e
      object { CubeX1
               scale < 25, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
      object { CubeX1
               scale < 25, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
      translate < 22.5, 0, 0 >
         }//end union east side 
   object { Frame_A  translate < 5, 0, 0 > } //center 
   union {
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate < -12.5, 0, 0 > }//w
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <  -6.5, 0, 0 > }
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <   6.5, 0, 0 > }
      object { CubeY1
               scale < 0.5, 10.0, 0.5 >  translate <  12.5, 0, 0 > }//e
      object { CubeX1
               scale < 25, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
      object { CubeX1
               scale < 25, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
      translate < -12.5, 0, 0 > 
         }//end union west side 
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end north frames up stairs

// **************************************************************

//    DEFINE  north room: north wall upper panels:
#declare N_North_Panel_Up =
union {
   union {
      object { Panel_D  translate <  45, 0, 0 > }
      object { Panel_D  translate <  25, 0, 0 > }
      object { Panel_D  translate <  10, 0, 0 > }
      object { Panel_D  translate < -10, 0, 0 > }
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 2, 4, 1.5 > }
      #else
         texture { Green_Tex }
      #end
         }//end inner union
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  scale < 13, 10, 0.05 >  translate x*35   }
      object { Pane_Square_2  scale < 10, 10, 0.05 >  translate x*17.5 }
      object { Pane_Square_2  scale < 13, 10, 0.05 >  translate x*0    }
   #end
      } // end north panels up stairs

// **************************************************************

//    DEFINE  north room: north wall lower frame:
#declare N_North_Frame_Dn =
union {
   object { CubeY1
            scale < 0.5, 10.0, 0.5 >  translate < -12.5, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10.0, 0.5 >  translate <  -6.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10.0, 0.5 >  translate <   6.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10.0, 0.5 >  translate <  12.5, 0, 0 > }//e
   object { CubeX1
            scale < 25, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 25, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end north frames down stairs

// **************************************************************

//    DEFINE  north room: south wall, east frame:
#declare N_South_Frame_East =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -10, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  -4, 0, 0 > }//w
   //south chimney goes here:
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  8, 0, 0 > }//e
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 15, 0, 0 > }//e
   object { CubeX1
            scale < 7, 0.5, 0.5 >  translate < -7,  5, 0 > }//wtop
   object { CubeX1
            scale < 7, 0.5, 0.5 >  translate < -7, -5, 0 > }//wbot
   object { CubeX1
            scale < 7, 0.5, 0.5 >  translate < 11.5,  5, 0 > }//etop
   object { CubeX1
            scale < 7, 0.5, 0.5 >  translate < 11.5, -5, 0 > }//ebot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end south frame east side union

// **************************************************************

//    DEFINE  north room: south wall, west frame:
#declare N_South_Frame_West =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -7.5, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <    0, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  7.5, 0, 0 > }//e
   object { CubeX1
            scale < 15, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 15, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end south frame west side

// **************************************************************

//    DEFINE  north room: south walls:
#declare N_South_Panel=
union {
  union {
   object { Panel_D  scale < 1.25, 1, 1 >  translate < 0, 10, 0 > } //w
   object { Panel_D  scale < 1.25, 1, 1 >  translate < 0,  0, 0 > }
   #if ( ShowDetails = 1 )
      texture { T_Stone15 scale < 2, 4, 2 > }
   #else
      texture { Coral_Tex }
   #end
        }//end union western panels
  union {
   object { Panel_D  scale < 1.25, 1, 1 > translate <    7, 10, 0 > } //e
   object { Panel_D  scale < 1.25, 1, 1 > translate <    7,  0, 0 > }
   object { Panel_D  scale < 1.25, 1, 1 > translate < 34.5, 10, 0 > } //w
   object { Panel_D  scale < 1.25, 1, 1 > translate < 52.5, 10, 0 > } //e
   #if ( ShowDetails = 1 )
      texture { T_Glass1 }
   #end
        }//end union all other panels:glass
      } // end union south wall panels
 
// **************************************************************

//    DEFINE  north room: south wall, center foyer, doorway:
#declare N_South_Frame_Center =
union {
   //middle section:
   object { Arch_Z2 scale < 10, 9.5, 1 >  translate < 0, -5, 0 > }
   object { CubeY1
            scale < 1, 20, 1 >  translate < -10, -5, 0 > }//w
   object { CubeY1
            scale < 1, 20, 1 >  translate <  10, -5, 0 > }//e
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0,  5,   0 > }//rear top
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0,  5, -10 > }//front top
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0, -5,   0 > }//rear bot 
   object { CubeX1
            scale < 22, 1.5, 1.5 >  translate < 0, -5, -10 > }//front bot 
   //east section:
   object { CubeY1
            scale < 1, 10, 1 >  translate < 10,  0,   0 > }//ne
   object { CubeY1
            scale < 1, 10, 1 >  translate < 10,  0, -10 > }//se
   object { CubeZ1
            scale < 1, 1, 10 >  translate < 10,  5,  -5 > }//top
   object { CubeZ1
            scale < 1, 1, 10 >  translate < 10, -5,  -5 > }//bot
   //west section:
   object { CubeY1
            scale < 1, 10, 1 >  translate < -10,  0,   0 > }//nw
   object { CubeY1
            scale < 1, 10, 1 >  translate < -10,  0, -10 > }//sw
   object { CubeZ1
            scale < 1, 1, 10 >  translate < -10,  5,  -5 > }//top
   object { CubeZ1
            scale < 1, 1, 10 >  translate < -10, -5,  -5 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end union south side center, upper frames

// **************************************************************

//    DEFINE  north room: south wall, foyer panels above and below:
#declare N_South_Panel_Center =
union {
   //roof:
   object { Pane_Square_2
            rotate x*90
            scale < 20, 0.5, 10 >
            translate < 0, 5, -5 >
          }//end center front window pane
   //upper:
   object { Pane_Square_2
            scale < 20, 10, 0.05 >
            translate z*-10
          }//end center front window pane
   object { Pane_Square_2
            scale < 20, 10, 0.05 >
          }//end center rear window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 10, 10 >
            translate < -10, 0, -5 >
          }//end west window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 10, 10 >
            translate < 10, 0, -5 >
          }//end east window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 10, 10 >
            translate < -10, -10, -5 >
          }//end west window pane
   object { Pane_Square_2
            rotate y*90
            scale < 0.05, 10, 10 >
            translate < 10, -10, -5 >
          }//end east window pane
   //lower:
   object { Frame_D2
            translate < -7.5, -10, 0 >
            #if ( ShowDetails = 1 )
               texture { T_Wood2 scale < 2, 4, 2 > }
            #else
              texture { Black_Tex }
            #end
          }//end lower west frame
   object { Pane_Square_2
            scale < 5, 10, 0.05 >
            translate < -7.5, -10, 0 >
          }//west of door
   object { Frame_D2
            translate < 7.5, -10, 0 >
            #if ( ShowDetails = 1 )
               texture { T_Wood2 scale < 2, 4, 2 > }
            #else
              texture { Black_Tex }
            #end
          }//end lower east frame
   object { Pane_Square_2
            scale < 5, 10, 0.05 >
            translate < 7.5, -10, 0 >
          }//east of door
      } // end union south center foyer panels

// **************************************************************

//    DEFINE  north room: east wall frame:
#declare N_East_Frame =
union {
   object { rotated_Frame_A  translate < 0, 0,  0 > }
   object { rotated_Frame_A  translate < 0, 0, 25 > }
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0,  5, 10 > }//top
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0, -5, 10 > }//bot
   object { CubeY1
            scale < 1, 10, 1 >  translate < 0, -10, 30 > }
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } // end east frame union

// **************************************************************

//    DEFINE  north room: east wall panels:
#declare N_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  18 >;  // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -18 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"                
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  3.5,  13.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -3.5, -13.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"                
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Green_Tex }
      #end
      translate < 0, 0, -12.5 >
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90
                              scale < 0.05, 10, 25 > 
                              translate < 0, 0, -12.5 > }
   #end
      } // end east panel union

// **************************************************************

//    DEFINE  north room: west wall frame:
#declare N_West_Frame =
union {
   object { CubeY1  
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  17.5 > }//n
   object { CubeY1  
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  10.5 > }//
   object { CubeY1  
            scale < 0.5, 10, 0.5 >  translate < 0, 0,   4.5 > }//
   //west chimney goes here...
   object { CubeY1  
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  -7.5 > }//
   object { CubeY1  
            scale < 0.5, 10, 0.5 >  translate < 0, 0, -17.5 > }//s
   object { CubeZ1
            scale < 0.5, 0.5, 35 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 0.5, 0.5, 35 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      } //end west frame union

// **************************************************************

//    DEFINE  north room: west wall panels:
#declare N_West_Panel =
union {
   union {
      object { Panel_A  scale < 1.25, 1, 1 >
                        rotate y*90  translate < 0,   0, -1.5 > }
      object { Panel_A  rotate y*90  translate < 0,   0,  -25 > }
      object { Panel_D  rotate y*90  translate < 0, -10,   -5 > }
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 2, 4, 1.5 > }
      #else
         texture { Green_Tex }
      #end
         }//end inner union
   object { UnitBox
            scale < 3.6, 1.2, 0.25 >
            translate < -1.5, -6, 0 >
            rotate y*90
            #if ( ShowDetails = 0 )
               texture { Brown_Tex }
            #else
               texture { T_MBH_Brick_1  scale < 0.02, 0.02, 0.02 > }
            #end
          }//above door brick panel
   object { Pane_Square_2  rotate y*90
                           scale < 0.05, 7.7, 2.9 > 
                           translate < 0, -11, 3.4 > 
          }//window left of door
   object { CubeZ1
            scale < 0.5, 0.5, 7 >
            translate < 0, -14.9, 1.5 >
            #if ( ShowDetails = 1 )
               texture { T_Wood2 scale < 2, 2, 4 > }
            #else
               texture { Black_Tex }
            #end
          }//bottom frame 
      } // end west panel union

// **************************************************************
// **************************************************************
//       C.  East Room:
// **************************************************************

//    DEFINE  east room roof:
#declare East_Roof =
union {
   object {
      #declare RB_P1 = <  14.5,  1.1,  8 >;  // right upper rear corner
      #declare RB_P2 = < -14.5, -1.1, -8 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 23.5, 10.5, 26 > 
         }//end north section roof
   object {
      #declare RB_P1 = <  7,  1.1,  26.5 >;  // right upper rear corner
      #declare RB_P2 = < -7, -1.1, -26.5 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 42, 10.5, 7 > 
         }//end east section roof
   object {
      #declare RB_P1 = <  19.5,  1.1,  12 >;  // right upper rear corner
      #declare RB_P2 = < -19.5, -1.1, -12 >;  // left lower front corner
      #include "roundbox.inc"
      translate < 29.5, 10.5, -29 > 
         } // end south section roof
   #if ( ShowDetails = 1 )
      texture { T_Stone5 scale < 1.5, 2, 10 > }
   #else
      texture { Coral_Tex }
   #end
      } // end union east wing roof

// **************************************************************

//    DEFINE  East room, south wall frames:
#declare E_South_Frame =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -17.5, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -8.65, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  8.65, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  17.5, 0, 0 > }//e
   object { CubeX1
            scale < 35, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 35, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      }// end south frame union 

// **************************************************************

//    DEFINE East room, south panel:
#declare E_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  18.5,  5.5,  1.1 >;  // right upper rear corner
         #declare RB_P2 = < -18.5, -5.5, -1.1 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  10,  3.5,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -10, -3.5, -2.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Magenta_Tex }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 17, 7.2, 0.05 >
               translate < 0, 1, 0 > 
             }//center window
   #end
         }// end front/south wall panels
 
// **************************************************************

//    DEFINE  East room, east frames:
#declare E_East_Frame =
union {
   object { rotated_Frame_A  translate < 0, 0,  0 > }
   object { rotated_Frame_A  translate < 0, 0, 10 > }
   object { rotated_Frame_A  translate < 0, 0, 20 > }
   object { rotated_Frame_A  translate < 0, 0, 40 > }
   object { rotated_Frame_A  translate < 0, 0, 50 > }
   object { rotated_Frame_A  translate < 0, 0, 60 > }
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
      }// end east wall union 

// **************************************************************

//    DEFINE  east room: east wall panels:
#declare E_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  15.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -15.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  3.5,  10.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -3.5, -10.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Magenta_Tex }
      #end
      translate z*21
              }//end difference north
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  15.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -15.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  3.5,  11 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -3.5, -11 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Magenta_Tex }
      #end
      translate z*-20
              }//end difference south
   object {
      object {
         #declare RB_P1 = <  1.1,  5.5,  8 >;  // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -8 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Magenta_Tex }
      #end
          }//end middle panel
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90
                              scale < 0.05, 10, 25 >
                              translate z*22.5 }
      object { Pane_Square_2  rotate y*90
                              scale < 0.05, 10, 25 >
                              translate z*-20 }
   #end
      } // end east window panel union

// **************************************************************

//    DEFINE  East room, west frames:
#declare E_West_Frame =
union {
   object { rotated_Frame_A  translate < 0, 0,  0 > }
   object { rotated_Frame_A  translate < 0, 0, 10 > }
   object { rotated_Frame_A  translate < 0, 0, 20 > }
   #if ( ShowDetails = 1 )
      texture { T_Wood2  scale < 2, 4, 2 > }
   #else
      texture { Black_Tex }
   #end
         }// end west wall union 

// **************************************************************
// **************************************************************
//       D.  West Room: 
// **************************************************************

//    DEFINE  West room roof:
#declare West_Roof =
object {
   #declare RB_P1 = <  19,  1.25,  17 >;  // right upper rear corner
   #declare RB_P2 = < -19, -1.25, -17 >;  // left lower front corner
   #include "roundbox.inc"
   #if ( ShowDetails = 1 )
      texture { T_Stone5 scale < 10, 2, 1.5 > }
   #else
      texture { Orchid_Tex }
   #end
      } // end west roof

// **************************************************************

//    DEFINE  West room: north wall frames:
#declare W_North_Frame =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -17, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  17, 0, 0 > }//e
   object { CubeX1
            scale < 33, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 33, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Goldenrod_Tex }
   #end
      } // end west room north frames

// **************************************************************

//    DEFINE  West room: north panel:
#declare W_North_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  11.5,  5.5,  1.1 >; // right upper rear corner
         #declare RB_P2 = < -11.5, -5.5, -1.1 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  4.5,  1,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -4.5, -3, -2.5 >; // left lower front corner
         #include "roundbox.inc"
         translate < -2.5, 1.75, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Goldenrod_Tex }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 9, 4.2, 0.05 >
               translate < 0, 1.4, 0 > 
             }//center window
   #end
      } // end west room north panels

// **************************************************************

//    DEFINE  West room: south wall frames:
#declare W_South_Frame =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -17, 0, 0 > }//w
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -11, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  11, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  17, 0, 0 > }//e
   object { CubeX1
            scale < 33, 0.5, 0.5 >  translate < 0,  5, 0 > }//top
   object { CubeX1
            scale < 33, 0.5, 0.5 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 4, 2 > }
   #else
      texture { Goldenrod_Tex }
   #end
      } // end west room south frames

// **************************************************************

//    DEFINE  West room: south panel:
#declare W_South_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  18.5,  5.5,  1.1 >;  // right upper rear corner
         #declare RB_P2 = < -18.5, -5.5, -1.1 >;  // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  9,  2.25,  2.5 >; // right upper rear corner
         #declare RB_P2 = < -9, -2.05, -2.5 >; // left lower front corner
         #include "roundbox.inc"
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 4, 2, 1.5 > }
      #else
         texture { Goldenrod_Tex }
      #end
              }//end difference
   #if ( ShowGlass = 1 )
      object { Pane_Square_2
               scale < 17, 7.2, 0.05 >
               translate < 0, 1, 0 > 
             }//center window
   #end
      } // end west room south panels

// **************************************************************

//    DEFINE  West room: west wall frames:
#declare W_West_Frame =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  15 > }//n
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0,   9 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  -9 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0, -15 > }//s
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 2, 4 > }
   #else
      texture { Goldenrod_Tex }
   #end
      } // end west room west frames

// **************************************************************

//    DEFINE  West room: west wall panels:
#declare W_West_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  15.5 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -15.5 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  3.5,  10.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -3.5, -10.5 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #else
         texture { Goldenrod_Tex }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 25 > }
   #end
      } // end west wall window panels

// **************************************************************

//    DEFINE  West room: east wall frames:
#declare W_East_Frame =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  15 > }//rear
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0,  5 > }//middle
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0, -5 > }//middle
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < 0, 0, -15 > }//front
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0,  5, 0 > }//top
   object { CubeZ1
            scale < 0.5, 0.5, 30 >  translate < 0, -5, 0 > }//bot
   #if ( ShowDetails = 1 )
      texture { T_Wood2 scale < 2, 2, 4 > }
   #else
      texture { Goldenrod_Tex }
   #end
      } // end west room east frames

// **************************************************************

//    DEFINE  West room: east wall panels:
#declare W_East_Panel =
union {
   difference {
      object {
         #declare RB_P1 = <  1.1,  5.5,  10 >; // right upper rear corner
         #declare RB_P2 = < -1.1, -5.5, -10 >; // left lower front corner
         #declare RB_Thickness = 2;      
         #declare RB_Solid = 1;          
         #include "roundbox.inc"
             } // end panel
      object {
         #declare RB_P1 = <  2.5,  3.5,  5.5 >; // right upper rear corner
         #declare RB_P2 = < -2.5, -3.5, -5.5 >; // left lower front corner
         #include "roundbox.inc"
         translate < 0, 1, 0 >
             } // end cut-out
      #if ( ShowDetails = 1 )
         texture { T_Stone15 scale < 1.5, 2, 4 > }
      #else
         texture { Goldenrod_Tex }
      #end
              }//end difference 
   #if ( ShowGlass = 1 )
      object { Pane_Square_2  rotate y*90  scale < 0.05, 10, 13 > }
   #end
      } // end east wall window panel

// **************************************************************
// **************************************************************

//    DEFINE  a stove:
#declare Stove_1 =
union {
   box { < 3.15, 10.5, 1.00 > < -3.15,  8, -2.00 > }  //hood
   box { < 1.55, 10.1, 1.00 > < -1.55,  0, -0.75 > }  //stack
   box { < 3.25,  3.5, 1.00 > < -3.25, -1, -3.50 > }  //body
   texture { Gray_Tex } 
      } // end stove

// **************************************************************

//    DEFINE  a table:
#declare Table_1 =
object {
   box { < 4, 2, 3 > < -4, -2, -3 > }
   texture { Red_Tex }
       } // end table

// **************************************************************

//    DEFINE  a hanging cabinet: 10x 2.5y 3z:
#declare Cabinet_1 =
object {
   box { < 5.0, 1.25, 1.5 > < -5.0, -1.25, -1.5 > }
   texture { Green_Tex }
       } // end cabinet 1

// **************************************************************

//    DEFINE  a counter: 10x 3y 3z:
#declare Counter_1 =
object {
   box { < 5.0, 1.5, 1.5 > < -5.0, -1.5, -1.5 > }
   texture { Coral_Tex }
       } // end counter 1

// **************************************************************

//    DEFINE  a counter: 3x 3.5y 10z:
#declare Counter_2 =
object {
   box { < 1.5, 1.75, 5.0 > < -1.5, -1.75, -5.0 > }
   texture { Orchid_Tex }
       } // end counter 2

// **************************************************************

//    DEFINE  a cylinder counter: 5x 4y 4z:
#declare Counter_3 =
object {
   cylinder { 0*y,  4*y,  2.5 }
   texture { Violet_Tex }
       } // end cyl counter 3

// **************************************************************

//    DEFINE a refrigerator:
#declare Frig_1 =
object {
   box { < 1.7, 7, 1.5 > < -1.7, -0.1, -1.5 > }
   texture { Blue_Tex }
       } // end frig

// **************************************************************

//    DEFINE  generic kitchen:
#declare W_Kitchen =
union {
   object { Stove_1  translate < 12.5, 0, 13 > }
   object { Frig_1  translate < 10.5, 0, -13 > }
   object { Table_1  translate < -10, 2, -10 > }

   object { Cabinet_1  translate < -12.0, 8.5, -13 > }//up front
   object { Cabinet_1  translate <  12.0, 8.5, -13 > }//up front
   object { Cabinet_1  translate <   3.5, 9.0, 13 > }//up rear
   object { Counter_1  translate <   3.5, 1.5, 13 > }//down rear

   //prep area:
   object { Counter_1  translate < 12.5,  1.50,  -13 > }//down rt front
   object { Counter_1  translate <  5.5,  1.50,  -13 > }//down ct front
   object { Counter_2  translate <    2,  1.00, -8.0 > }//center
   object { Counter_2  translate <   15,  1.00, -8.0 > }//right side
   object { Counter_3  translate <    2, -1.25, -2.5 > }//center

      } // end kitchen fixtures

// *******************************************************************
// *******************************************************************
//       F.  a Modernist/International Style House:
// *******************************************************************
// *******************************************************************
/*
#declare Modernist_Home =
union {

   object { North_Room }
   object { East_Room }
   object { West_Room }

   object { Front_SideWalk
            translate z*-30 }

   object { Arched_Hall_1
            translate < 0, 5, -30 >
          }// end arched hallway

   object { Planter_Box_2  translate < -17, 1, -24 > }
   object { 
      box {< -5.5, -0.5, -5.5 > < 5.5, 0.5, 5.5 >
           pigment { VeryDarkBrown } }
      translate < -17, 1, -24 >
          }// end generic dirt

   // ------------------------------------------
   // Tree include files by Giles Tran:
   //-----------------------------------------
   #declare colLeaf_1=rgb <0.7,1,0.2>*0.8; // greenish 
   #declare colLeaf_2=rgb <1,0.7,0.2>*0.8; // yellow
   #declare txtLeaf_5=texture {
                         pigment{
                            agate
                            color_map{
                                 [ 0.0 color colLeaf_1 ]
                                 [ 0.3 color colLeaf_2 ] 
                                 [ 0.7 color colLeaf_2 ]
                                 [ 1.0 color colLeaf_1 ] }
                                }//end pigment       
                         finish{ambient 0.1 specular 0.3 roughness 0.01}
                         scale 10 }// end texture
   #declare Leaf = object {#include "gtleaf7.inc" } 
   #declare Tree1= object {#include "gttree7.inc" }                        
   // remove the following for leafless tree or for test:
   #declare Foliage1=object {#include "gtfoliage7.inc"  texture{ txtLeaf_5 } }
                                                     
   union {
      object { Tree1 }
      object { Foliage1 }
      scale < 0.3, 0.3, 0.3 >
      translate < -17, 0, -24 >
         } // end union Tran's tree

      } // end union modernist house

*/

// *******************************************************************
// *******************************************************************
//    M_HOME00.INC      (c) Michael Brendan Hurley      Winter 2000
//    www.geocities.com/mbrendanh/                 mbhcgc@saber.net
// *******************************************************************
// *******************************************************************
