
// Kari Kivisalo rayalist@engineer.com

// +w600 +h400

#version 3.5;

#declare BLUR=1;    // depth of field
#declare PHOTON=1;  // photons
#declare AREA=1;    // area lights

global_settings{
  #if(PHOTON=1)
   photons {
     spacing 0.05
     autostop 0
     jitter 0
   }
  #end
  max_trace_level 30
  adc_bailout 0.002
  assumed_gamma 1.0  
} 

#macro Spot(Col,Loc,Look,Rad,Fall,Tigh,Dim,N,A,P)
  #local Nloc=Loc-Look;
  #local R=vlength(Nloc);
  light_source{
    R*x rgb Col 
    #if(N>0) area_light Dim*z,Dim*y, N, N  adaptive A #end 
    spotlight radius Rad falloff Fall tightness Tigh point_at 0
    photons{#if(P=1) refraction on reflection on area_light #else refraction off reflection off #end}
    rotate degrees(asin(Nloc.y/R))*z
    rotate degrees(atan2(-Nloc.z,Nloc.x))*y
    translate Look 
  }
#end

#include "vase.inc"

#macro Vase(Col,Loc)
  object{VaseObj
    rotate -90*x
    translate Loc  
    photons{target collect off reflection on refraction on}
    pigment{
      bozo
      color_map{
        [0.2 rgb Col filter 1]
        [0.5 rgb Col filter 0.96]
        [1   rgb Col filter 0.96]
      }
      scale 0.2
    }
    finish{conserve_energy diffuse 0.3 ambient 0 reflection{0.8 fresnel on}}
    normal{bumps 0.003 scale<5,0.7,5>}
    interior{ior 1.4 fade_distance 1.5 fade_power 1000 fade_color rgb Col^3}    
  }
#end

camera{
  location <-100,140,-340>
  direction 50/35*z  // 50mm lens
  up 24/35*y right x // 35mm film
  look_at<-100,113,-250>
  #if(BLUR=1)   
    aperture 2
    blur_samples 40
    focal_point <-100,113,-270>
    confidence 0.95
    variance 0.00005
  #end
}

Vase(<0.8,0.95,1>,<-100,100,-250>)
Vase(<0.7,0.7,1>,<-83,100,-265>)
Vase(<0.8,1,0.85>,<-117,100,-265>)

Spot(<1,0.9,0.8>*1.4,<-150,220,-300>,<-100,30,0>,1,30,0,5,0,0,0)
Spot(<1,0.8,0.6>,<-50,290,-350>,<-100,100,-250>,1,14,1,5,4*AREA,0,1)

plane{z,0
  pigment{rgb 1} finish{diffuse 0.95 ambient 0.05}
  normal{bumps 0.05}
  photons{collect off} no_shadow
}

box{
  0,1
  pigment{
   gradient y
   color_map{[0 rgb<0.7,0.9,1>][1 rgb<0.2,0.5,1>]}
  }
  finish{diffuse 0 ambient 6}
  photons{collect off} no_shadow
  scale<1,180,180>
  translate <60,100,-300>
}

#declare i=0;#while(i<2)
  #declare j=0;#while(j<4)
    disc{
      <-i*500/4-500/8-20,280,-j*500/4-500/8>,y,7 
      pigment{rgb 1} finish{diffuse 0 ambient 100}
      photons{collect off} no_shadow
    }
  #declare j=j+1;#end
#declare i=i+1;#end

cylinder{-y,0,50
  texture{
    pigment{image_map{jpeg "wood1.jpg"}rotate 90*x rotate 60*y scale 10}
    finish{diffuse 0.9 ambient 0}
  }
  texture{
    pigment{image_map{jpeg "wood2.jpg" transmit all 0.5}rotate 90*x scale 30}
    finish{diffuse 0.9 ambient 0 reflection{0.8 fresnel on}}
    normal{bumps 0.01 scale 0.1}
  }
  interior{ior 1.7}
  translate <-100,100,-270>
}
