 
motion.mcr      
Kp 8"
KPJ  JGt
4_x
4d
3
6w`   
Kp
4TEXTttxt  E         ζN/                       r  //**************************************//
//*           Motion  Macro            *//
//**************************************//
//				- by "Rico"
//
// This macro can be used for complicated animations
// simply by determining where, when, and how an object 
// will move.  The macro takes the values that you 
// determine and returns a value stored in "value".
// Making multiple motions is as simple as putting
// one macro after another.
//
//  example:
//		motion (new_motion() + accel_decel(2) + from(0,1) + key_pos(1,2))
//   	motion (accel_decel(2) + from(1,2) + key_pos(2,0))
//   	#declare pointx = value;
//		object {
//			MyObject 
//			translate <pointx,0,0>
//		}
//
// syntax:
// motion(new_motion() + type( <exponent> ) + from(begin,stop) + key_pos(a,b))
//
// style:
//  1  = steady motion- - - - - - - - ->  /   
//  2  = accelerate - - - - - - - - - ->  _   _/
//  3  = decelerate - - - - - - - - - -> /      _
//  4  = accelerate, then decelerate- ->      _/
//  5  = decelerate, then accelerate- ->   _
//  6  = s-curve- - - - - - - - - - - -> _/
//  7  = triangle - - - - - - - - - - ->  _   /\
//  8  = smooth triangle- - - - - - - ->_/ \_  _  _
//  9  = bounce - - - - - - - - - - - ->   _    \/
// 10  = bounce2  - - - - - - - - - - -> _/ \_
//
// exponent:
//  determines power of function with acceleration or 
//  deceleration (not sine wave functions or linear functions)
//  1 = linear; 2 = quadratic, 3 = cubic, etc...
//
// begin:
//  point in time when the motion begins:
//  note: I reccomend that you declare something such as
//  #declare time = clock * 10;  this way, you can work in seconds
//  instead of a value from 0 to 1.  if you do not define a time value,
//  the clock value will be used instead.
//
// stop
//  point in time when the motion ends
//  note: the value will remain the same after the motion finishes
//
// a & b
//  These represent the starting and finishing points for the value
//  i.e. to make something go from 0 to 90 degrees:
//   a=0 ; b=90  ->  from(0,90)
//
//
#macro new_motion() 			#declare switch1 = on; #ifdef (style) #undef style #undef begin #end 0 #end
#macro steady()					#declare style = 1; 0 #end
#macro accel(d1)				#declare style = 2; #declare power = d1; 0 #end
#macro decel(d1)				#declare style = 3; #declare power = d1; 0 #end
#macro accel_decel(d1)		#declare style = 4; #declare power = d1; 0 #end
#macro decel_accel(d1)		#declare style = 5; #declare power = d1; 0 #end
#macro s_curve()				#declare style = 6; 0 #end
#macro triangular_()			#declare style = 7; 0 #end
#macro smooth_triangular()	#declare style = 8; 0 #end
#macro bounce(d1)				#declare style = 9; #declare power = d1; 0 #end
#macro bounce2(d1)				#declare style = 10;#declare power = d1; 0 #end
#macro from(d1,d2)				#declare begin = d1; #declare stop = d2; 0 #end
#macro key_pos(d1,d2)			#declare low = d1; #declare high = d2; 0 #end

#macro motion(options)//YEAH, I KNOW THIS COULD BE CLEANED UP A LOT, BUT IT WORKS!
	#declare switch2 = off;
	#declare buffer1 = 0;
	#declare buffer2 = 0;
	#if (low<0)
		#declare buffer1 = low;
		#declare low = low-buffer1;
		#declare high = high-buffer1;
		#declare switch2 = on;
	#end
	#if (high<0)
		#declare buffer2 = high;
		#declare low = low-buffer2;
		#declare high = high-buffer2;
		#declare switch2 = on;
	#end
	#ifndef (style)
		#declare style = 1;
	#end
	#ifndef (begin)
		#declare begin = 0;
		#declare stop = 1;
	#end
	#ifdef (time) 							//check for a defined "time" value
	#else
		#declare time = clock;
	#end
	#if (switch1 = on) 					//check for a new animation set
		#ifdef (value)
			#undef value							//reset the "value" variable
		#end
		#declare prev = low;				//reset the previous value
		#declare switch1 = off;			//reset the switch
	#else
		#declare prev = value-buffer1-buffer2;			//store previous value
	#end
	#declare dt = stop-begin; 			//determing change in time
	#declare dp = high-low; 			//determine change in position
	#declare nt = (time-begin)/dt; 	//transform time to new time between 0 and 1
	
	#if (nt>1) 								//check for invalid values (greater than 1 or less than 0)
		#declare nt = 1;
	#end
	#if (nt<0)
		#declare nt = 0;
	#end
		
	//steady
	#if (style = 1)
		#declare f = nt;
	#end
	//accelerate
	#if (style = 2)
		#declare f = pow(nt,power);
	#end
	//decelerate
	#if (style = 3) 
		#declare f = 1-pow(nt-1,power);
	#end
	//accelerate, decelerate
	#if (style = 4)
		#if (time<= (begin+stop)/2)
			#declare f = .5 * abs(pow(2*nt,power));
		#else
			#declare f = 1-.5 * abs(pow(2*(nt-1),power));
		#end
	#end
	//decelerate, accelerate
	#if (style = 5)
		#if (time <= begin)
			#declare f = 0;
		#else
			#if (time = stop)
				#declare f = 1;
			#else
				#if (time<= (begin+stop)/2)
					#declare f = .5 * abs(pow(2*nt,1/power));
				#else
					#declare f = 1-.5 * abs(pow(-2*(nt-1),1/power));
				#end
			#end
		#end
	#end
	//s-curve
	#if (style = 6)
		#declare f = .5-.5*cos(nt*pi);
	#end
	//triangle
	#if (style = 7)
		#declare f = -2*abs(nt-.5)+1;
	#end
	//smooth triangle 0->1->0
	#if (style = 8)
		#declare f = .5-.5*cos(nt*pi*2);
	#end
	//bounce
	#if (style = 9)
		#declare f = 1-pow(1-abs(nt*2-1),power);
	#end
	//bounce2
	#if (style = 10)
		#declare f = 1-(1-(nt*2))*(1-(nt*2));
	#end
	//stores variable:
	#declare value = prev + f * dp + buffer1 + buffer2;
#end
                                                                            h   h   f619,-0.458,-0.638 > <92.16,113.178,335.829 > <0.394,-0.168,-0.903 > <94.414,113.543,338.401 > <0.568,-0.472,-0.675 > }
smooth_triangle {  <96.375,134.903,335.829 > <0.204,-0.867,-0.454 > <92.16,132.633,335.829 > <0.425,-0.45,-0.785 > <94.41                 	   	         $  6 &                                                  h   h   fSORT   f NwPo   SELc   &styl  2    &                N	"z                                                         