/*

shader_swirl.pov
================
 
An attempt to reproduce the swirl effect I made with
a very slow set of function calls ...

Author:
------
Written by Michael Andrews, 10th July 2001
Version 0.2

Purpose:
-------
A test scene for the swirl2.sl shader.

This file works with POVMan 0.71.4 and needs the shader
file swirl2.slp produced from swirl2.sl

*/

#version unofficial MegaPov 0.7;

global_settings { 
  max_trace_level 10
  assumed_gamma 1
  ambient_light 1
}

#declare Type = 0;

// Axis along Dir
#if (Type = 0)
  #declare Dir = -z;
#end

// Axis along intersection (point) - Dir (point)
#if (Type = 1)
  #declare Dir = <0,0,0>-20;
#end

// Axis along geometric normal of object
// This can't be used in a displace warp?
#if (Type = 2)
  #declare Dir = <0,0,0>;
#end

#if (Type = 3)
  #declare Dir = <0,0,0>;
#end

#declare swirl = pigment {
  shader{
    shader_file "swirl2.slp"
    "Rot" 2
    "Power" 3
    "Dir" Dir
    "Steps" 9
    "Type" Type
  }
}

#declare twirl = pigment {
  shader{
    shader_file "twirl.slp"
    "Rot" -2
    "Power" 3
    "Origin" <0,0,0>
    "Radius" 4
    "Dir" Dir
  }
}

/*
#declare CL = <0.1, 5, -9>*2.5;
#declare BC = 0.25;

camera {
  location  CL
  direction 2.4*z  
  right     x*image_width/image_height
  look_at   <5, -2.5, 0>
}

background { color rgb BC }

//#declare O_Test = sphere { 0, 5 }
#declare O_Test = box { -4, 4 }

object { O_Test
  texture{
    pigment{
      average
      pigment_map {
        [1 leopard colour_map {[0 rgb x][0.5 rgb y][1 rgb z]} rotate 1987 translate 10]
        [1 leopard colour_map {[0 rgb y][0.5 rgb z][1 rgb x]} rotate 4854 translate 20]
        [1 leopard colour_map {[0 rgb z][0.5 rgb x][1 rgb y]} rotate 8654 translate 30]
      }
      scale 1/2
      warp { displace { swirl type 0 } }
      scale 5
      warp { displace { swirl type 0 } }
      scale 1/5
      translate 20
    }
    finish{ ambient 1 diffuse 0 }
  }
  rotate 15*y
  scale 1
  translate <10,-5,0>
}

object { O_Test
  texture{
    pigment{
      average
      pigment_map {
        [1 leopard colour_map {[0 rgb x][0.5 rgb y][1 rgb z]} rotate 1987 translate 10]
        [1 leopard colour_map {[0 rgb y][0.5 rgb z][1 rgb x]} rotate 4854 translate 20]
        [1 leopard colour_map {[0 rgb z][0.5 rgb x][1 rgb y]} rotate 8654 translate 30]
      }
      scale 1/2
      rotate 30
      rotate 30
      translate 20
    }
    finish{ ambient 1 diffuse 0 }
  }
  rotate 15*y
  scale 1
}
// */

//*
// set viewer's position in the scene
camera
{
// (camera types)
orthographic
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  <0.0, .01, -6.0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
//  sky       y                // rarely used
  up        10*y                // which way is +up <X Y Z>
  right     10*4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
//  angle FLOAT                // overrides "direction" with specific angle
//  normal { ripples 0.2 }     // perturb the camera lens with a pattern
// (focal blur extras)
//  aperture 0.2               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point <VECTOR>       // x,y,z point that is in focus
}

#declare S = seed(1);

plane {
  -z,0
  texture{
    pigment{
      pigment_pattern {
        spherical
        pigment_map {
          [0 rgb 0]
          [0.5 radial rotate x*90 cubic_wave frequency 5 colour_map {[0 rgb 0][0.5 rgb 1][1 rgb 0]} ]
          [0.9 rgb 1]
        }
        scale 3/2
      }
      pigment_map {
        [0 rgb 0]
        [0.7 
          average
          pigment_map {
            [1 bozo colour_map {[0 rgb x][1/3 rgb y][2/3 rgb z][1 rgb x]} rotate <rand(S),rand(S),rand(S)>*360 translate (<rand(S),rand(S),rand(S)>-0.5)*200]
            [1 bozo colour_map {[0 rgb y][1/3 rgb z][2/3 rgb x][1 rgb y]} rotate <rand(S),rand(S),rand(S)>*360 translate (<rand(S),rand(S),rand(S)>-0.5)*200]
            [1 bozo colour_map {[0 rgb z][1/3 rgb x][2/3 rgb y][1 rgb z]} rotate <rand(S),rand(S),rand(S)>*360 translate (<rand(S),rand(S),rand(S)>-0.5)*200]
          }
        ]
      }
      scale 3
      scale 1/2
      warp { displace { swirl type 0 } }
      scale 2
      warp { displace { twirl type 0 } }
      scale 1/2
      scale 5
      warp { displace { swirl type 0 } }
      scale 2/5
      translate 0
    }
    finish{ ambient 1 diffuse 0 }
  }
}
// */
