 
stairs.pov      \ 8"\*  K ,M]F*   \TEXTttxt         Lcucu                         #version unofficial megapov .7;
$radiosity_ = on;
$area_lights = on;

global_settings{
	#if (radiosity_)
		//ini_option "+qr"
	#end
	radiosity{
		// pretrace_start 0.04
		// pretrace_end .007
		count 100
		recursion_limit 1
		nearest_count 1
		error_bound 0.3
		normal on
	}
}

light_source{ //main light source
  <-50,30,-30>
  color rgb <1,.97,.9>*2.5
	#if (area_lights)
	  area_light 10*x 10*y 6,6 adaptive 2 jitter circular
	#end
}

light_source{<-3,2,3>	rgb -.4 shadowless} //for contrast between ground and stairs
light_source{<-3,2,-3>	rgb -.4 shadowless}

sky_sphere{ //not seen, but for radiosity - reflects blue into shadows
	pigment{
		gradient y
		color_map { [0 color rgb <.7,.7,1>] [1 color blue .5]}
	}
}

#declare cement =
	texture{
		pigment{crackle solid 
			color_map {
				[ 0 rgb <0.811490, 0.713359, 0.608484> ]
				[ 1 rgb <0.884993, 0.777646, 0.654978> ]
			}
		}
		normal{granite 0.6}
		finish{ambient 0 diffuse .8 }
		scale 0.3
	}
	
#declare ground =
	texture{
		pigment{crackle solid 
			color_map {
				[ 0 rgb <0.811490, 0.713359, 0.608484> ]
				[ 1 rgb <0.884993, 0.777646, 0.654978> ]
			}
		}
		normal{granite 0.4}
		finish{ambient 0 diffuse .8 }
		scale 0.4
	}

plane{y,0 texture{ground}}

#macro super(a,b,c) //creates a superellipsoid with box syntax
	%tr = (a+b)/2;
	%sc = (a-b)/2;
	c
	scale sc
	translate tr
#end

#macro step(point) //macro for individual step placement
	$height = height+step_rise;
	%C = 0;
	#while (C*step_rise<height+.01)
		superellipsoid{
			super( point-<.5,-step_rise*C-.03,.5>,  point+<.5,step_rise*(C+1),.5>,  .15)
		}
		%C = C+1;
	#end
#end

$height = 1;
$step_rise = .2;
$original_height = height;
union{
	step(<-1,0,0>)
	step(<-1,0,1>)
	step(<-1,0,2>)
	step(<0,0,2>)
	step(<1,0,2>)
	step(<2,0,2>)
	step(<2,0,1>)
	step(<2,0,0>)
	step(<2,0,-1>)
	step(<1,0,-1>)
	step(<0,0,-1>)
	texture{cement}
}

$rise = height-original_height-step_rise;
$zoom_factor = 2.5;
$shift = <.25,0,1.25>;

camera{
	location <1,rise,-1> * zoom_factor + shift
	//<1,2,1>: ratio is 2:sqrt(2) - the stairs rise (rise) units while they are
	//displaced sqrt(2) units horizontally, so the camera only has to be at 
	//this correct ratio for the effect, offset makes no difference.
	orthographic
	look_at shift
}                                                                     2                                                                                                                                                                                                                                                                               2SORT
   2  styl   
     
(                                                    