// polyhedra.inc version 2 alpha
// POV-Ray version 3.1
// Dan Johnson zapob@hotmail.com

// Currently no functions require Megapov
// !!!---Warning Alpha version some functions may not have been tested yet---!!!
// Please report Bugs to me.  

// Long overdue rewrite
// 
// Todo List
//
// Integrate geodesic functions
// Create bounding routine for Torus segment function
// Face, and vertex placing functions for basic polyhedra
// Achimedean solids, Star polyhedra, Johnson solids, Semisolid polyhedra
// Multi polyhedron compounds
// Skeletons
// Antiprizims
// Solid mesh versions
// Demonstration files
// Tutorial
// Spaceframes

// Old Arrange_3d
/*#macro Arrange_3d (A,B,C,N)
       ( (mod(N+A-1,A))*x + (B-mod(div(N+A-1,A)+B-1,B))*y + (mod(div(N+B*A-1,B*A)+C-1,C))*z -<A-1,B+1,C-1>/2)
#end  // use only natural numbers aka 1,2,3,4,5,6... no fractions 0 or negative numbers 
*/
#macro Angle_between_vectors(U,V)  // angle in degrees between two vectors.
        (degrees (acos(vdot(U,V)/(vlength(U)*vlength(V)))))
#end
#macro Proj (U,V)  // projection of U onto V
        (V*(vdot(U,V)/vdot(V,V)))
#end
#macro Same_test (Vector1,Vector2) //tests if two vectors are the same returns boolean
        (vdot((Vector1 = Vector2),<1,1,1>) = 3)
#end
#macro Collinear_test (Vector1,Vector2,Vector3)  //tests if three points are on the same line
        #local U = (Vector1-Vector2);
        #local V = (Vector1-Vector3);
        (vcross(U,V) = 0)
#end
#macro On_plane_test (Point_on_plane,Normal,Test_point)     //  Uses a point on the plane, and normal vector to test if Test_point
        (vlength(Proj (Point_on_plane-Test_point,Normal)) = 0)  // is on the plane, returns boolean.
#end
#macro Same_direction_test (Vector1,Vector2) // Tests if two vectors point in same direction.  If either point is the zero vector,
        (2*(vdot(Vector1,Vector2)/(vlength(Vector1)*vlength(Vector2)) = 1)-1) // you will get a divide by zero error.
#end                                                                          // Returns positive or negative 1.

#macro Same_side_test (Point_on_plane,Normal,Test_point1,Test_point2)  //  Tests if both test points are on same side of plane.
        #local Vec1 = Proj(Test_point1-Point_on_plane,Normal);         //  If either test point is in the plane you will get a 
        #local Vec2 = Proj(Test_point2-Point_on_plane,Normal);         //  divide by zero error.  Returns positive or negative 1.
        Same_direction_test (Vec1,Vec2)
#end
#macro Integer_test (Float)
        (abs(Float-int(Float))!>0)
#end        
#macro Vectorize (Float_or_vector)  // turns a float into a vector
        (Float_or_vector * <1,1,1>) // leaves vectors unchanged
#end
#macro Natural_test_scalar (Float)
        (Float > 0 & Integer_test (Float) & Float != 0)
#end
#macro Natural_test_vector (Vector)
        (Natural_test_scalar (Vector.x) & Natural_test_scalar (Vector.y) & Natural_test_scalar (Vector.z))
#end
#macro Arrange_3d (Dimentions_vector0,N)
        #if (Natural_test_vector(Dimentions_vector0)=0)
        #warning "Vector has a dimention that is not a natural number, may produce unexpected results"
        #end
        #local Dimentions_vector = Vectorize (Dimentions_vector0);
        #undef Dimentions_vector0
        #local A = Dimentions_vector.x;
        #local B = Dimentions_vector.y;
        #local C = Dimentions_vector.z;
              
       ( (mod(N+A-1,A))*x + (B-mod(div(N+A-1,A)+B-1,B))*y + (mod(div(N+B*A-1,B*A)+C-1,C))*z -<A-1,B+1,C-1>/2)
#end  // use only natural numbers aka 1,2,3,4,5,6... no fractions 0 or negative numbers 


#macro Grid (Dimentions_vector0,Marker_interval,Marker_scale)
        #if (Natural_test_vector(Dimentions_vector0)=0)
        #warning "Vector has a dimention that is not a natural number, may produce unexpected results"
        #end
        #local Dimentions_vector = Vectorize (Dimentions_vector0);
        #undef Dimentions_vector0
        #local N = 1;
        union {
        #while (N <= (((Dimentions_vector.x * 2) + 1)*((Dimentions_vector.y * 2) +1)*((Dimentions_vector.z * 2) + 1)))
                #local Grid_vector = Arrange_3d(<(Dimentions_vector.x * 2) + 1,(Dimentions_vector.y * 2) +1,(Dimentions_vector.z * 2) + 1>,N) * Marker_interval;
                union {
                sphere {0,.5}
                text { ttf "timrom.ttf" concat("<",str(Grid_vector.x,1,0),",",str(Grid_vector.y,1,0),",",str(Grid_vector.z,1,0),">") .5 0  translate .5}
                scale Marker_scale
                translate Grid_vector}
                #local N = N+1;
        #end
        }
#end  // use only natural numbers aka 1,2,3,4,5,6... no fractions 0 or negative numbers 

////////////////////////////////////////////////////////////////
// Four_point_plane  version 1  June 15 2001
// 
// Original Idea Dan Johnson
// Code Dan Johnson, and Tor Olav Kristensen
//
// In povray everything on one side of the plane is considered inside the plane object
// P1, P2, and P3 are points on the plane, none of these points can be the same as any other,
// and they can't be in a strait line.  Inside point is a control point to determine witch side of the plane
// is considered inside. Tor Olav posted much simpler code to do the same job a few days after me.  
// I beleive that I can prove it always works.  The plane generating code is based on Tor Olav's with a 
// few minor simplifications, and the error trapping is mostly mine.  
// Dan Johnson


#macro Four_point_plane(P1, P2, P3, I)// P1-3 = points on plane I = inside point

  #local Cross = vcross(P2 - P1, P3 - P1);
  #local STP = vdot(Cross, I - P1); // Scalar Triple Product
  #if (STP = 0) // Check for invalid data
    //determine specific error, or errors.
    #local Errors = "\nFour_point_plane did not create a plane because of the following bad imput\n"
    #local S1 = (vdot((P1 = P2),<1,1,1>) = 3);   // same checks, Tor suggests I use (vlength(p2-p1) = 0)
    #local S2 = (vdot((P2 = P3),<1,1,1>) = 3);   // fewer computations but mine is all integer math,
    #local S3 = (vdot((P3 = P1),<1,1,1>) = 3);   // and vlength uses sqrt, so I don't know witch is faster
    #local S = S1 + S2 + S3;
    #if (S > 1)
     #local Errors = concat (Errors,"All points are the same\n")
    #else
    #if (S > 0) 
     #if (S1) #local Errors = concat (Errors,"Point1 = Point2\n")#end  // I could make this part better
     #if (S2) #local Errors = concat (Errors,"Point2 = Point3\n")#end  // what was I thinking?
     #if (S3) #local Errors = concat (Errors,"Point3 = Point1\n")#end
    #else
     #if (abs(vdot(vnormalize(P2-P1),vnormalize(P3-P2))) = 1) 
      #local Errors = concat (Errors,"All points on same line\n")
     #else
      #local Errors = concat (Errors,"Inside point is on plane\n")
     #end
    #end
    #end
    #warning Errors
    sphere {<0,0,0>,0 inverse}  //Whatever called Four_point_plane is expecting an object.
  #else
    #local N = (STP > 0 ? -1 : 1)*vnormalize(Cross);// normal vector
    plane { N, vdot(P1, N) }
  #end // if

#end // macro Four_point_plane

//  Three_point_plane assumes that the origin is in the object.
#macro Three_point_plane(P1,P2,P3)
        Four_point_plane(P1,P2,P3,<0,0,0>)
#end

// Angles are in degrees.  Torus is descirbed counter_clockwise around the z axis for positive angles 
// clockwise for negative angles, (when veiwed from -z) starting at Major_radius * x
// Angles with an absolute value greater than 360 returns a complete torus.

#macro Torus_segment (Major_radius,Minor_radius,Angle)
        #if (abs(Angle)>=360)
         torus {Major_radius,Minor_radius rotate 90*x}
        #else
         #if ((abs(Angle)/Angle)>0)
          #if (Angle <= 180)
           intersection{
            torus {Major_radius,Minor_radius rotate 90*x}
            plane {-y,0}
            plane {y,0 rotate Angle*z}
           }
          #else 
           intersection {
            merge {
             plane {-y,0}
             plane {y,0 rotate Angle*z}
            }
            torus {Major_radius,Minor_radius rotate 90*x}
           }
          #end
         #else
          #if (Angle >= -180)
           intersection{
            torus {Major_radius,Minor_radius rotate 90*x}
            plane {y,0}
            plane {-y,0 rotate Angle*z}
           }
          #else 
           intersection {
            merge {
             plane {y,0}
             plane {-y,0 rotate Angle*z}
            }
            torus {Major_radius,Minor_radius rotate 90*x}
           }
          #end
         #end
        #end                
#end
/*#macro Quaternion(Angle,Vector)   // creates a normalized rotation quaternion... angle in radians
        #if (vlength(Vector)=0) 
         #warning "0 vector not allowed\nUsing identity Quaternion" 
         <1,0,0,0>
        #else
         #local A = Angle/2;
         #local V = sin(A)*vnormalize(Vector);
         <cos(A),V.x,V.y,V.z>
        #end
#end
#macro Quaternion(Angle,Vector)   //Old version
        #if (vlength(Vector)=0) #warning "0 vector not allowed" #end
        #local A = Angle/2;
        #local V = sin(A)*vnormalize(Vector);
        <cos(A),V.x,V.y,V.z>
#end */
#macro Quaternion(Angle,Vector)   // creates a normalized rotation    version 3 rewritten by Tim Attwood
         #if (vlength(Vector)=0)  //quaternion... angle in radians
          #warning "0 vector not allowed\nUsing identity Quaternion"
          #local A = 1;
          #local V = <0,0,0>;
         #else
          #local A = cos(Angle/2);
          #local V = sin(Angle/2)*vnormalize(Vector);
         #end
       <A,V.x,V.y,V.z>
#end
#macro Q_conjugate(Q)         // the conjugate of a quaternion
        <Q.x,-Q.y,-Q.z,-Q.t>  // will rotate around the same axis in the opposite direction
#end
#macro Q_axis (Quat) // returns normalized axis of Quaternion
        #local V = vnormalize (<Quat.y,Quat.z,Quat.t>);
        #if (vlength(V) = 0)
          #warning "Degenerate Axis"
        #end
        V
#end
#macro Q_angle(Quat) // returns angle in radians of Quaternion
        acos(Quat.x)
#end
#macro Q_multiply(P,Q)  // multiplies two quaternions
        #local P0 = P.x;
        #local Pv = <P.y,P.z,P.t>;
        #local Q0 = Q.x;
        #local Qv = <Q.y,Q.z,Q.t>;
        #local PQ0 = P0*Q0 - vdot(Pv,Qv);
        #local PQv = P0*Qv + Q0*Pv + vcross(Pv,Qv);
        <PQ0,PQv.x,PQv.y,PQv.z>
#end
#macro Q_matrix_array (Q)      // converts a quaternion into a matrix
        #local Q0 = Q.x;
        #local Q1 = Q.y;
        #local Q2 = Q.z;
        #local Q3 = Q.t;
        #local QT = 2*pow(Q0,2)-1;
        array[12]
        {QT+2*pow(Q1,2),2*(Q1*Q2+Q0*Q3),2*(Q1*Q3-Q0*Q2),
         2*(Q1*Q2-Q0*Q3),QT+2*pow(Q2,2),2*(Q2*Q3+Q0*Q1),
         2*(Q1*Q3+Q0*Q2),2*(Q2*Q3-Q0*Q1),QT+2*pow(Q3,2),
         0,0,0}
#end
#macro Rotate_displace (Q,V)  // rotate using Quaternion displace using vector, returns matrix array
        #local Mat = Q_matrix_array (Q);
        #local Mat[9] = V.x;
        #local Mat[10] = V.y;
        #local Mat[11] = V.z;
        Mat
#end
/*
#macro Matrix_2_matrix (M)  // Creates a translation matrix from matrix array
        matrix<M[0],M[1],M[2],M[3],M[4],M[5],M[6],M[7],M[8],M[9],M[10],M[11]>
#end
#macro Q_vdot(Q1,Q2)
        ((Q1.x*Q2.x) + (Q1.y*Q2.y) + (Q1.z*Q2.z) + (Q1.t*Q2.t))
#end
#macro Matrix_mult (M1,M2) // multiplys two matrices stored as arrays
        #local R1 = <M1[0],M1[1],M1[2],0>;  // matrix 1 rows
        #local R2 = <M1[3],M1[4],M1[5],0>;
        #local R3 = <M1[6],M1[7],M1[8],0>;
        #local R4 = <M1[9],M1[10],M1[11],0>;
        
        #local C1 = <M2[0],M2[3],M2[6],M2[9]>;  // matrix 2 columns
        #local C2 = <M2[1],M2[4],M2[7],M2[10]>;
        #local C3 = <M2[2],M2[5],M2[8],M2[11]>;
        
        array[12]                  // The calculations
        {(Q_vdot(R1,C1)),(Q_vdot(R1,C2)),(Q_vdot(R1,C3)),
         (Q_vdot(R2,C1)),(Q_vdot(R2,C2)),(Q_vdot(R2,C3)),
         (Q_vdot(R3,C1)),(Q_vdot(R3,C2)),(Q_vdot(R3,C3)),
         (Q_vdot(R4,C1)),(Q_vdot(R4,C2)),(Q_vdot(R4,C3))}
        
#end */
/*#macro Matrix_mult (M1,M2) // multiplys two matrices stored as arrays
        #local R1 = <M1[0],M1[1],M1[2],0>;  // matrix 1 rows
        #local R2 = <M1[3],M1[4],M1[5],0>;
        #local R3 = <M1[6],M1[7],M1[8],0>;
        #local R4 = <M1[9],M1[10],M1[11],0>;
        
        #local C1 = <M2[0],M2[3],M2[6],M2[9]>;  // matrix 2 columns
        #local C2 = <M2[1],M2[4],M2[7],M2[10]>;
        #local C3 = <M2[2],M2[5],M2[8],M2[11]>;
        
        #local Matrix_out = array[12]
        #local Matrix_out[0] = (Q_vdot(R1,C1));
        #local Matrix_out[1] = (Q_vdot(R1,C2));
        #local Matrix_out[2] = (Q_vdot(R1,C3));
        #local Matrix_out[3] = (Q_vdot(R2,C1));
        #local Matrix_out[4] = (Q_vdot(R2,C2));
        #local Matrix_out[5] = (Q_vdot(R2,C3));
        #local Matrix_out[6] = (Q_vdot(R3,C1));
        #local Matrix_out[7] = (Q_vdot(R3,C2));
        #local Matrix_out[8] = (Q_vdot(R3,C3));
        #local Matrix_out[9] = (Q_vdot(R4,C1));
        #local Matrix_out[10] = (Q_vdot(R4,C2));
        #local Matrix_out[11] = (Q_vdot(R4,C3));
        
        Matrix_out
#end */
/*
#macro H2tr_m(U1,U2,V1,V2) // Here to there rotation
        #local X1 = vnormalize(U1);                // find basis vectors of initial and
        #local Z1 = vnormalize(vcross(X1,U2));     // final refrence frames
        #local Y1 = vcross(Z1,X1);                 
        #local X2 = vnormalize(V1);
        #local Z2 = vnormalize(vcross(X2,V2));
        #local Y2 = vcross(Z2,X2);
        #local M1 = array[12]{X1.x,Y1.x,Z1.x,X1.y,Y1.y,Z1.y,X1.z,Y1.z,Z1.z,0,0,0}
        #local M2 = array[12]{vdot(X2,X1),vdot(X2,Y1),vdot(X2,Z1),vdot(Y2,X1),vdot(Y2,Y1),vdot(Y2,Z1),vdot(Z2,X1),vdot(Z2,Y1),vdot(Z2,Z1),0,0,0}
        #local M3 = array[12]{X1.x,X1.y,X1.z,Y1.x,Y1.y,Y1.z,Z1.x,Z1.y,Z1.z,0,0,0} // this is the transpose of the first matrix

        Matrix_mult(Matrix_mult(M1,M2),M3)
#end*/
#macro Q_vdot(Q1,Q2)
        ((Q1.x*Q2.x) + (Q1.y*Q2.y) + (Q1.z*Q2.z) + (Q1.t*Q2.t))
#end
#macro Matrix_2_matrix (M)  // Creates a translation matrix from matrix array
        matrix<M[0],M[1],M[2],M[3],M[4],M[5],M[6],M[7],M[8],M[9],M[10],M[11]>
#end
#macro Matrix_mult (M1,M2) // multiplys two matrices stored as arrays
        #local R1 = <M1[0],M1[1],M1[2],0>;  // matrix 1 rows
        #local R2 = <M1[3],M1[4],M1[5],0>;
        #local R3 = <M1[6],M1[7],M1[8],0>;
        #local R4 = <M1[9],M1[10],M1[11],0>;
        
        #local C1 = <M2[0],M2[3],M2[6],M2[9]>;  // matrix 2 columns
        #local C2 = <M2[1],M2[4],M2[7],M2[10]>;
        #local C3 = <M2[2],M2[5],M2[8],M2[11]>;
        
        array[12]                  // The calculations
        {(Q_vdot(R1,C1)),(Q_vdot(R1,C2)),(Q_vdot(R1,C3)),
         (Q_vdot(R2,C1)),(Q_vdot(R2,C2)),(Q_vdot(R2,C3)),
         (Q_vdot(R3,C1)),(Q_vdot(R3,C2)),(Q_vdot(R3,C3)),
         (Q_vdot(R4,C1)),(Q_vdot(R4,C2)),(Q_vdot(R4,C3))}
        
#end
/**/
#macro H2tr_m(U1,U2,V1,V2) // Here to there rotation
        #local X1 = vnormalize(U1);                // find basis vectors of initial and
        #local Z1 = vnormalize(vcross(X1,U2));     // final refrence frames
        #local Y1 = vcross(Z1,X1);                 
        #local X2 = vnormalize(V1);
        #local Z2 = vnormalize(vcross(X2,V2));
        #local Y2 = vcross(Z2,X2);
        #local M1 = array[12]{X1.x,Y1.x,Z1.x,X1.y,Y1.y,Z1.y,X1.z,Y1.z,Z1.z,0,0,0}
        #local M2 = array[12]{vdot(X2,X1),vdot(X2,Y1),vdot(X2,Z1),vdot(Y2,X1),vdot(Y2,Y1),vdot(Y2,Z1),vdot(Z2,X1),vdot(Z2,Y1),vdot(Z2,Z1),0,0,0}
        #local M3 = array[12]{X1.x,X1.y,X1.z,Y1.x,Y1.y,Y1.z,Z1.x,Z1.y,Z1.z,0,0,0} // this is the transpose of the first matrix

        Matrix_mult(Matrix_mult(M1,M2),M3)
#end  
        
#macro V_matrix (V,M)// V is a vector M is a 12 element array in the same pattern as a matrix
        #local Vx = V.x*M[0] + V.y*M[3] + V.z*M[6] + M[9];
        #local Vy = V.x*M[1] + V.y*M[4] + V.z*M[7] + M[10];
        #local Vz = V.x*M[2] + V.y*M[5] + V.z*M[8] + M[11];
        <Vx,Vy,Vz>
#end
#macro VQ(V,Q)// applies a Quaternion oporator to a vector
        /*#local Qs = Q.x;                              // Last line replaced this code wich misteriously does not work
        #local Qv = <Q.y,Q.z,Q.t>;
        (((2*Qs*Qs)-1)*v + 2*vdot(Qv,V)*Qv + 2*Qs*vcross(Qv,V))*/
        V_matrix (V,Q_matrix_array (Q))                 // less efficient way.
#end

#macro Q_matrix (Q)      // converts a quaternion into a matrix
        #local Q0 = Q.x;
        #local Q1 = Q.y;
        #local Q2 = Q.z;
        #local Q3 = Q.t;
        #local QT = 2*pow(Q0,2)-1;
        matrix 
        <QT+2*pow(Q1,2),2*(Q1*Q2+Q0*Q3),2*(Q1*Q3-Q0*Q2),
         2*(Q1*Q2-Q0*Q3),QT+2*pow(Q2,2),2*(Q2*Q3+Q0*Q1),
         2*(Q1*Q3+Q0*Q2),2*(Q2*Q3-Q0*Q1),QT+2*pow(Q3,2),
         0,0,0>
#end
#macro Q_half_turn(V)   //180 degree rotation about vector
        #local V = vnormalize(V);
        <0,V.x,V.y,V.z>
#end

#macro H2tr(U1,U2,V1,V2) // Here to there rotation... two reference points for initial and final positions
        #local X1 = vnormalize(U1);                // find basis vectors of initial and
        #local Z1 = vnormalize(vcross(X1,U2));     // final refrence frames
        #local Y1 = vcross(Z1,X1);                 
        #local X2 = vnormalize(V1);
        #local Z2 = vnormalize(vcross(X2,V2));
        #local Y2 = vcross(Z2,X2);
        matrix <X1.x,Y1.x,Z1.x,X1.y,Y1.y,Z1.y,X1.z,Y1.z,Z1.z,0,0,0>
        matrix <vdot(X2,X1),vdot(X2,Y1),vdot(X2,Z1),vdot(Y2,X1),vdot(Y2,Y1),vdot(Y2,Z1),vdot(Z2,X1),vdot(Z2,Y1),vdot(Z2,Z1),0,0,0>
        matrix <X1.x,X1.y,X1.z,Y1.x,Y1.y,Y1.z,Z1.x,Z1.y,Z1.z,0,0,0> // this is the transpose of the first matrix
#end
// Here to There simple rotation version
#macro H2t_sr (V1,V2) // rotates object pointing at V1 so that it points at V2
        #if ((vlength(V1) = 0) | (vlength (V2) = 0) | (Same_test(vnormalize(V1),vnormalize(V2))))
          translate 0  // if either input vector is zero, or angle between them is zero... Identity matrix
        #else                           
          #if (vlength (vcross(V1,V2)) = 0)      // see if vectors point in opposite directions
            #if (vlength(vcross(<1,1,1>,V1))!=0) // if V1 is not parralel to <1,1,1>
              H2tr(V1,<1,1,1>,V2,<1,1,1>)        // I'm sure I could use a simpler function to do the same thing,
            #else                                // but H2tr makes it so easy.                 
              Q_matrix(Q_half_turn(<1,0,-1>))
            #end 
          #else
            #local Angle = acos(vdot(V1,V2)/(vlength(V1)*vlength(V2)));  // I could completly eliminate trig functions,
            #local Axis  = vcross (V1,V2);                               // but again it works perfectly the way it is.
            Q_matrix(Quaternion(Angle,Axis))                             
          #end
        #end
#end
#macro Axis_rotate(Axis,Angle) // rotates around axis by angle... angle in radians
        Q_matrix (Quaternion(Angle,Axis))
#end

// Here to there rotation... two reference points for initial and final positions
// This version returns an array
#macro H2tr_m(U1,U2,V1,V2) 
        #local X1 = vnormalize(U1);                // find basis vectors of initial and
        #local Z1 = vnormalize(vcross(X1,U2));     // final refrence frames
        #local Y1 = vcross(Z1,X1);                 
        #local X2 = vnormalize(V1);
        #local Z2 = vnormalize(vcross(X2,V2));
        #local Y2 = vcross(Z2,X2);
        #local M1 = array[12]{X1.x,Y1.x,Z1.x,X1.y,Y1.y,Z1.y,X1.z,Y1.z,Z1.z,0,0,0}
        #local M2 = array[12]{vdot(X2,X1),vdot(X2,Y1),vdot(X2,Z1),vdot(Y2,X1),vdot(Y2,Y1),vdot(Y2,Z1),vdot(Z2,X1),vdot(Z2,Y1),vdot(Z2,Z1),0,0,0}
        #local M3 = array[12]{X1.x,X1.y,X1.z,Y1.x,Y1.y,Y1.z,Z1.x,Z1.y,Z1.z,0,0,0} // this is the transpose of the first matrix

        (Matrix_mult(Matrix_mult(M1,M2),M3))
#end
#macro H2t (Oi,Ai,Ri,Of,Af,Rf)                // Here to there 
       translate (<0,0,0> - Oi)               // center, and two reference points on object
       H2tr((Ai-Oi),(Ri-Oi),(Af-Of),(Rf-Of))  // New center, and refrence point locations
       translate Of 
#end   // (Origin, Absolute vector, Relative vector) initial, and final orientations


// constants used many times

#declare Golden = ((1+ pow(5,.5))/2); // the golden section...  1 + the square root of 5 over 2
#declare Golden_I = (Golden -1);  // the golden ratio is the only ratio where one is the difference between it and its inverse
#declare Golden_I_SQ = pow (Golden_I,2); // Golden^-2
#declare Golden_SQ = (Golden +1); // Golden Squared

// vertex arrays

#declare Tetrahedron = array[4]{<1,1,1>,<1,-1,-1>,<-1,1,-1>,<-1,-1,1>} // Tetrahedron vertexes
#declare Tetrahedron2 = array[4]{<1,1,-1>,<1,-1,1>,<-1,1,1>,<-1,-1,-1>} // vector in the direction of the faces of the tetrahedron
#declare Cube = array[8]{<1,1,1>,<1,1,-1>,<1,-1,1>,<1,-1,-1>,<-1,1,1>,<-1,1,-1>,<-1,-1,1>,<-1,-1,-1>} // Cube vertexes
#declare Icosahedron = array[12]{<Golden_I,0,Golden_I_SQ>,<Golden_I,0,-Golden_I_SQ>,<Golden_I_SQ,Golden_I,0>,
                                 <Golden_I_SQ,-Golden_I,0>,<0,Golden_I_SQ,Golden_I>,<0,Golden_I_SQ,-Golden_I>,
/*Icosahedron vertexes*/         <0,-Golden_I_SQ,Golden_I>,<0,-Golden_I_SQ,-Golden_I>,<-Golden_I_SQ,Golden_I,0>,
                                 <-Golden_I_SQ,-Golden_I,0>,<-Golden_I,0,Golden_I_SQ>,<-Golden_I,0,-Golden_I_SQ>}
#declare Dodecahedron = array[20]{<Golden, Golden_I,0>,<Golden, -Golden_I,0>,<1,1,1>,<1,1,-1>,<1,-1,1>,<1,-1,-1>,
                                  <Golden_I,0,Golden>,<Golden_I,0,-Golden>,<0,Golden,Golden_I>,<0,Golden,-Golden_I>,
/* Dodecahedron vertexes*/        <0,-Golden,Golden_I>,<0,-Golden,-Golden_I>,<-Golden_I,0,Golden>,<-Golden_I,0,-Golden>,
                                  <-1,1,1>,<-1,1,-1>,<-1,-1,1>,<-1,-1,-1>,<-Golden,Golden_I,0>,<-Golden,-Golden_I,0>}

// circumscribe radius's

#declare Tetrahedron_c_radius = pow(3,.5); 
#declare Octahedron_c_radius = 1; // for consitancy's sake
#declare Cube_c_radius = Tetrahedron_c_radius;
#declare Icosahedron_c_radius = pow((Golden_I_SQ + pow(Golden_I_SQ,2)),.5);
#declare Dodecahedron_c_radius = Tetrahedron_c_radius;

// inscribe radius's

#declare Tetrahedron_i_radius = pow(3,.5)/3; //distance from origin to a tetrahedrons face
#declare Octahedron_i_radius = Tetrahedron_i_radius;
#declare Cube_i_radius = 1;  // for consitancy's sake
#declare Icasahedron_i_radius = Tetrahedron_i_radius; // length from origin to face of Icosahedron
#declare Dodecahedron_i_radius = Icosahedron_c_radius*Golden;// lengh from origin to Dodecahedron face

#macro Pentagram (Major_radius,Minor_radius)
merge {
        torus {Major_radius,Minor_radius rotate 90*x}
        cylinder {<0,Major_radius,0>,<cos(pi/2+4*pi/5)*Major_radius,sin(pi/2+4*pi/5)*Major_radius,0>,Minor_radius}
        cylinder {<cos(pi/2+4*pi/5)*Major_radius,sin(pi/2+4*pi/5)*Major_radius,0>,<cos(pi/2+8*pi/5)*Major_radius,sin(pi/2+8*pi/5)*Major_radius,0>,Minor_radius}
        cylinder {<cos(pi/2+8*pi/5)*Major_radius,sin(pi/2+8*pi/5)*Major_radius,0>,<cos(pi/2+2*pi/5)*Major_radius,sin(pi/2+2*pi/5)*Major_radius,0>,Minor_radius}
        cylinder {<cos(pi/2+2*pi/5)*Major_radius,sin(pi/2+2*pi/5)*Major_radius,0>,<cos(pi/2+6*pi/5)*Major_radius,sin(pi/2+6*pi/5)*Major_radius,0>,Minor_radius}
        cylinder {<cos(pi/2+6*pi/5)*Major_radius,sin(pi/2+6*pi/5)*Major_radius,0>,<0,Major_radius,0>,Minor_radius}
        }
#end
#declare Cube_faces = box { <-1,-1,-1>, <1,1,1> }                    // 2x2x2 box  why bother... I don't know

                
// edge arrays
               
#declare Tetrahedron_edge_a
        = array[6][2]{
                 { Tetrahedron[0],Tetrahedron[1]},
                 { Tetrahedron[0],Tetrahedron[2]},
                 { Tetrahedron[0],Tetrahedron[3]},
                 { Tetrahedron[1],Tetrahedron[2]},
                 { Tetrahedron[1],Tetrahedron[3]},
                 { Tetrahedron[2],Tetrahedron[3]}}

#declare Tetrahedron2_edge_a
        = array[6][2]{
                 { Tetrahedron2[0],Tetrahedron2[1]},
                 { Tetrahedron2[0],Tetrahedron2[2]},
                 { Tetrahedron2[0],Tetrahedron2[3]},
                 { Tetrahedron2[1],Tetrahedron2[2]},
                 { Tetrahedron2[1],Tetrahedron2[3]},
                 { Tetrahedron2[2],Tetrahedron2[3]}}

#declare Cube_edge_a
        = array[12][2]{
                 { Cube[0],Cube[1]},
                 { Cube[0],Cube[2]},
                 { Cube[1],Cube[3]},
                 { Cube[2],Cube[3]},
                 { Cube[0],Cube[4]},
                 { Cube[1],Cube[5]},
                 { Cube[2],Cube[6]},
                 { Cube[3],Cube[7]},
                 { Cube[4],Cube[5]},
                 { Cube[4],Cube[6]},
                 { Cube[5],Cube[7]},
                 { Cube[6],Cube[7]}}


#declare Octahedron_edge_a
        = array[12][2]{
                 {  x,  y},
                 {  x,  z},
                 {  x, -z},
                 {  x, -y},
                 {  y,  z},
                 {  y, -z},
                 { -y,  z},
                 { -y, -z},
                 { -x,  y},
                 { -x,  z},
                 { -x, -z},
                 { -x, -y}}

#declare Dodecahedron_edge_a
        = array[30][2]{ 
                 { Dodecahedron[0],  Dodecahedron[1] },
                 { Dodecahedron[0],  Dodecahedron[2] },
                 { Dodecahedron[0],  Dodecahedron[3] },
                 { Dodecahedron[1],  Dodecahedron[4] },
                 { Dodecahedron[1],  Dodecahedron[5] },
                 { Dodecahedron[2],  Dodecahedron[6] },
                 { Dodecahedron[3],  Dodecahedron[7] },
                 { Dodecahedron[4],  Dodecahedron[6] },
                 { Dodecahedron[5],  Dodecahedron[7] },
                 { Dodecahedron[2],  Dodecahedron[8] },
                 { Dodecahedron[3],  Dodecahedron[9] },
                 { Dodecahedron[4],  Dodecahedron[10]},
                 { Dodecahedron[5],  Dodecahedron[11]},
                 { Dodecahedron[8],  Dodecahedron[9] },
                 { Dodecahedron[6],  Dodecahedron[12]},
                 { Dodecahedron[7],  Dodecahedron[13]},
                 { Dodecahedron[10], Dodecahedron[11]},
                 { Dodecahedron[8],  Dodecahedron[14]},
                 { Dodecahedron[9],  Dodecahedron[15]},
                 { Dodecahedron[10], Dodecahedron[16]},
                 { Dodecahedron[11], Dodecahedron[17]},
                 { Dodecahedron[12], Dodecahedron[14]},
                 { Dodecahedron[13], Dodecahedron[15]},
                 { Dodecahedron[12], Dodecahedron[16]},
                 { Dodecahedron[13], Dodecahedron[17]},
                 { Dodecahedron[14], Dodecahedron[18]},
                 { Dodecahedron[15], Dodecahedron[18]},
                 { Dodecahedron[16], Dodecahedron[19]},
                 { Dodecahedron[17], Dodecahedron[19]},
                 { Dodecahedron[18], Dodecahedron[19]}}

#declare Icosahedron_edge_a
        = array[30][2]{ 
                 { Icosahedron[0], Icosahedron[1]},
                                              
                 { Icosahedron[0], Icosahedron[2]},
                 { Icosahedron[1], Icosahedron[2]},
                 { Icosahedron[0], Icosahedron[3]},
                 { Icosahedron[1], Icosahedron[3]},
                
                 { Icosahedron[0], Icosahedron[4]},
                 { Icosahedron[1], Icosahedron[5]},
                 { Icosahedron[0], Icosahedron[6]},
                 { Icosahedron[1], Icosahedron[7]},
                
                 { Icosahedron[2], Icosahedron[4]},
                 { Icosahedron[2], Icosahedron[5]},
                 { Icosahedron[3], Icosahedron[6]},
                 { Icosahedron[3], Icosahedron[7]},
                
                 { Icosahedron[2], Icosahedron[8]},
                 { Icosahedron[4], Icosahedron[6]},
                 { Icosahedron[5], Icosahedron[7]},
                 { Icosahedron[3], Icosahedron[9]},
                
                 { Icosahedron[4], Icosahedron[8]},
                 { Icosahedron[5], Icosahedron[8]},
                 { Icosahedron[6], Icosahedron[9]},
                 { Icosahedron[7], Icosahedron[9]},
                
                 { Icosahedron[4], Icosahedron[10]},
                 { Icosahedron[5], Icosahedron[11]},
                 { Icosahedron[6], Icosahedron[10]},
                 { Icosahedron[7], Icosahedron[11]},
                
                 { Icosahedron[8], Icosahedron[10]},
                 { Icosahedron[8], Icosahedron[11]},
                 { Icosahedron[9], Icosahedron[10]},
                 { Icosahedron[9], Icosahedron[11]},
                 
                 { Icosahedron[10], Icosahedron[11]}}



#declare Cube_loops
        = array[4]{Cube[0],Cube[1],Cube[2],Cube[3]}


#declare Icosahedron_loops
        = array[6]{Icosahedron[0],Icosahedron[1],Icosahedron[2],Icosahedron[3],Icosahedron[4],Icosahedron[5]}

#declare Dodecahedron_loops
        = array[10]{Dodecahedron[0],Dodecahedron[1],Dodecahedron[2],Dodecahedron[3],Dodecahedron[4],
        Dodecahedron[5],Dodecahedron[6],Dodecahedron[7],Dodecahedron[8],Dodecahedron[9]}

#macro Arc_connect(Major_radius,Minor_radius,U,V)
        object {Torus_segment(Major_radius,Minor_radius,Angle_between_vectors(U,V))
        H2tr(x,y,U,V)}
#end

#macro Cylinder_edges(Array,Scale,Radius)
        #local N_edges = dimension_size(Array,1)-1; // Find out the number of edges in edge array, then subtract 1
        #local N = 0;  // counter initialzer
        union {
        #while (N <= N_edges)
          cylinder{Array[N][0]*Scale,Array[N][1]*Scale,Radius}
          #local N = N + 1;
        #end }
#end
#macro Arc_edges(Array,Major,Minor)
        #local N_edges = (dimension_size(Array,1)-1); // Find out the number of edges in edge array, then subtract 1
        #local N = 0;  // counter initialzer
        union {
        #while (N <= N_edges)
          object{Arc_connect(Major,Minor,Array[N][0],Array[N][1])}
          #local N = N + 1;
        #end }
#end

#macro Dodecahedron_edges(Scale,Cylinder_radius)
        Cylinder_edges(Dodecahedron_edge_a,Scale,Cylinder_radius)
#end
#macro Icosahedron_edges(Scale,Cylinder_radius)
        Cylinder_edges(Icosahedron_edge_a,Scale,Cylinder_radius)
#end
#macro Octahedron_edges(Scale,Cylinder_radius)
        Cylinder_edges(Octahedron_edge_a,Scale,Cylinder_radius)
#end
#macro Cube_edges(Scale,Cylinder_radius)
        Cylinder_edges(Cube_edge_a,Scale,Cylinder_radius)
#end
#macro Tetrahedron_edges(Scale,Cylinder_radius)
        Cylinder_edges(Tetrahedron_edge_a,Scale,Cylinder_radius)
#end
#macro Tetrahedron2_edges(Scale,Cylinder_radius)
        Cylinder_edges(Tetrahedron2_edge_a,Scale,Cylinder_radius)
#end

#declare Icosahedron_face_a = array[20][2]{  // Only has one axis of rotational symetry
        {Dodecahedron[0],Icosahedron[0]},
        {Dodecahedron[1],Icosahedron[0]},
        {Dodecahedron[2],Icosahedron[0]},
        {Dodecahedron[3],Icosahedron[11]},
        {Dodecahedron[4],Icosahedron[0]},
        {Dodecahedron[5],Icosahedron[11]},
        {Dodecahedron[6],Icosahedron[0]},
        {Dodecahedron[7],Icosahedron[0]},
        {Dodecahedron[8],Icosahedron[11]},
        {Dodecahedron[9],Icosahedron[0]},
        {Dodecahedron[10],Icosahedron[11]},
        {Dodecahedron[11],Icosahedron[0]},
        {Dodecahedron[12],Icosahedron[11]},
        {Dodecahedron[13],Icosahedron[11]},
        {Dodecahedron[14],Icosahedron[0]},
        {Dodecahedron[15],Icosahedron[11]},
        {Dodecahedron[16],Icosahedron[0]},
        {Dodecahedron[17],Icosahedron[11]},
        {Dodecahedron[18],Icosahedron[11]},
        {Dodecahedron[19],Icosahedron[11]}}
        
#macro Face_rotate(Center,Corner,Face_array,Object) //
        #local N_faces = dimension_size(Face_array,1);
        #local N = 0;
        union {
        #while (N < N_faces)
                object {Object H2tr(Center,Corner,Face_array[N][0],Face_array[N][1])}
                #local N = N + 1;
        #end
        }
#end