//#version unofficial MegaPov 0.7;  // version number may be different

//  !!!---Warning expirimental code---!!!

//  Todo list
//
//  Create fuction to place objects at vertexes
//  Generate mesh instead of a union of triangles
//  Use objects other than cylinders, and triangles for struts, and faces
//  Optimize some struts currently generated more than once on complete sphere
//  Other symetry types

#include "polyhedra2.inc"
#include "colors.inc"
#include "finish.inc"
#include "skies.inc"


// For some reason H2tr_m does not work unless specifically put into the file instead of being called from
// polyhedra2.inc included it, and it's support functions so that it would work

#macro Q_vdot(Q1,Q2)
        ((Q1.x*Q2.x) + (Q1.y*Q2.y) + (Q1.z*Q2.z) + (Q1.t*Q2.t))
#end
#macro Matrix_2_matrix (M)  // Creates a translation matrix from matrix array
        matrix<M[0],M[1],M[2],M[3],M[4],M[5],M[6],M[7],M[8],M[9],M[10],M[11]>
#end
#macro Matrix_mult (M1,M2) // multiplys two matrices stored as arrays
        #local R1 = <M1[0],M1[1],M1[2],0>;  // matrix 1 rows
        #local R2 = <M1[3],M1[4],M1[5],0>;
        #local R3 = <M1[6],M1[7],M1[8],0>;
        #local R4 = <M1[9],M1[10],M1[11],0>;
        
        #local C1 = <M2[0],M2[3],M2[6],M2[9]>;  // matrix 2 columns
        #local C2 = <M2[1],M2[4],M2[7],M2[10]>;
        #local C3 = <M2[2],M2[5],M2[8],M2[11]>;
        
        array[12]                  // The calculations
        {(Q_vdot(R1,C1)),(Q_vdot(R1,C2)),(Q_vdot(R1,C3)),
         (Q_vdot(R2,C1)),(Q_vdot(R2,C2)),(Q_vdot(R2,C3)),
         (Q_vdot(R3,C1)),(Q_vdot(R3,C2)),(Q_vdot(R3,C3)),
         (Q_vdot(R4,C1)),(Q_vdot(R4,C2)),(Q_vdot(R4,C3))}
        
#end
/**/
#macro H2tr_m(U1,U2,V1,V2) // Here to there rotation
        #local X1 = vnormalize(U1);                // find basis vectors of initial and
        #local Z1 = vnormalize(vcross(X1,U2));     // final refrence frames
        #local Y1 = vcross(Z1,X1);                 
        #local X2 = vnormalize(V1);
        #local Z2 = vnormalize(vcross(X2,V2));
        #local Y2 = vcross(Z2,X2);
        #local M1 = array[12]{X1.x,Y1.x,Z1.x,X1.y,Y1.y,Z1.y,X1.z,Y1.z,Z1.z,0,0,0}
        #local M2 = array[12]{vdot(X2,X1),vdot(X2,Y1),vdot(X2,Z1),vdot(Y2,X1),vdot(Y2,Y1),vdot(Y2,Z1),vdot(Z2,X1),vdot(Z2,Y1),vdot(Z2,Z1),0,0,0}
        #local M3 = array[12]{X1.x,X1.y,X1.z,Y1.x,Y1.y,Y1.z,Z1.x,Z1.y,Z1.z,0,0,0} // this is the transpose of the first matrix

        Matrix_mult(Matrix_mult(M1,M2),M3)
#end  

light_source { <3,20,-40> rgb 2}
camera {location <0,0,-2.3> /*up<0,1,0> right <1,0,0>*/ look_at 0}
sky_sphere { S_Cloud4 }

// A material I made in hamapatch
#declare hama_mat0=material{
	texture{
		pigment{
						agate
			agate_turb 2.212
			color_map{
				[ 0.000 rgbft<0/255,255/255,164/255,0.000,0.000>]
				[ 0.708 rgbft<158/255,118/255,223/255,0.000,0.000>]
				[ 1.000 rgbft<255/255,62/255,3/255,0.000,0.000>]
			}
		}
		normal{
			agate
			agate_turb 2.212
		}
		finish{
			specular 0.183
		}
	}
 }


//////////////////////////////////////////////
//
//  Function list      
//
//  Arc_connect(Major_radius,Minor_radius,U,V)... connects two points on sphere with torus segment
//  Cylinder_edges(Array,Scale,Radius)...  with an array of edge points connects them with cylinders
//  Icosahedron_c_radius... Icosahedron circumscribe radius
//  Dodecahedron[7] // center of triangle
//  vaxis_rotate(A,B,F)
//  Angle_between_vectors(U,V) ... angle in degrees between two vectors.  
//  
//  some functions, constants and vectors I wanted to keep in mind when writing this

#macro V2s(V) // vector to string
        concat("<",str(V.x,1,-1),",",str(V.y,1,-1),",",str(V.z,1,-1),">")
#end

/////////////////////////////////////////////////////
// Geopoint...                                     //
// June 22 2001                                    //
// Dan Johnson                                     //
// Zapob@hotmail.com                               //
/////////////////////////////////////////////////////
//
// Three points define spherical triangle
// Frequency is the number of divisions on an edge of the triangle defined by the three points
// U, and V are coordinates like this
//
//  V
//
//  ^
// / \
//  |
//  |    P3
//  |    |
//  |
//  | 4- x
//  |    |\
//  | 3- x-x
//  |    |\|\
//  | 2- x-x-x
//  |    |\|\|\
//  | 1- x-x-x-x
//  |    |\|\|\|\
//  | 0- x-x-x-x-x -P1
//  |  
//  |  / | | | | |
//  |P2  0 1 2 3 4 \
//  +---------------> U
//                 /
//
// Where each x represents a point on a unit sphere, 
// and P1, P2, and P3 are the corners of the spherical triagle being subdivided.
//
#macro Geopoint (P1,P2,P3,Frequency,U,V)
        #local P1c = Frequency - U;  // triangulation coordinates
        #local P2c = Frequency - V;
        #local P3c = U + V;
        
        #local Arc_div_P1P2 = Angle_between_vectors(P1,P2)/Frequency; // even divisions between corners
        #local Arc_div_P2P3 = Angle_between_vectors(P2,P3)/Frequency;
        #local Arc_div_P3P1 = Angle_between_vectors(P3,P1)/Frequency;
        
        #local P1P2_axis = vcross(P1,P2);  // axis's to take one corner to another
        #local P2P3_axis = vcross(P2,P3);
        #local P3P1_axis = vcross(P3,P1);
        
        #local P1_corner_normal = vcross(vcross(P1,(P2+P3)/2),P1); // normal to a plane passing through
        #local P2_corner_normal = vcross(vcross(P2,(P3+P1)/2),P2); // corner with equal angles to each
        #local P3_corner_normal = vcross(vcross(P3,(P1+P2)/2),P3); // of the other points.
        
        #if (P1c = 0)
           #local P1_norm = -P1_corner_normal;
        #else 
           #local P1A = vaxis_rotate(P1,P3P1_axis,-P1c*Arc_div_P3P1);
           #local P1B = vaxis_rotate(P1,P1P2_axis,P1c*Arc_div_P1P2);
           #local P1_norm = vcross(P1A,P1B);
        #end
        #if (P2c = 0)
           #local P2_norm = -P2_corner_normal;
        #else 
           #local P2A = vaxis_rotate(P2,P1P2_axis,-P2c*Arc_div_P1P2);
           #local P2B = vaxis_rotate(P2,P2P3_axis,P2c*Arc_div_P2P3);
           #local P2_norm = vcross(P2A,P2B);
        #end
        #if (P3c = 0)
           #local P3_norm = -P3_corner_normal;
        #else 
           #local P3A = vaxis_rotate(P3,P2P3_axis,-P3c*Arc_div_P2P3);
           #local P3B = vaxis_rotate(P3,P3P1_axis,P3c*Arc_div_P3P1);
           #local P3_norm = vcross(P3A,P3B);
        #end
        
        #local Point_Red = -vnormalize(vcross(P1_norm,P2_norm));
        #local Point_Green = -vnormalize(vcross(P2_norm,P3_norm));
        #local Point_Blue = -vnormalize(vcross(P3_norm,P1_norm));
        
        vnormalize(Point_Red + Point_Green + Point_Blue)
        
#end

#macro Geoarray (P1,P2,P3,Frequency) // doesn't use whole array
        #local P1 = vnormalize(P1);  // I could rewrite this to use a one dimentional array, I guess.
        #local P2 = vnormalize(P2);  // So far memory useage has not been a problem
        #local P3 = vnormalize(P3);
        #local Vertex_array = array[Frequency + 1][Frequency + 1]
        #local N = 0;
        #while (N <= Frequency)
           #local U_max = (Frequency - N);
           #local NU = 0;
           #while (NU <= U_max)
              #local Vertex_array[NU][N] = Geopoint(P1,P2,P3,Frequency,NU,N);
              #local NU = (NU + 1);
           #end
           #local N = (N+1);
        #end
        Vertex_array  
#end

// Geo_edge_e   
//
// One of the three edges of each triagle found in an array produced by Geoarray
// meant for use with an equalateral spherical triangle.  Just rotate around center
// of triangle to get other two edges.  Output is a two dimentional array, the first
// dimention is the refrence number of the edge, the second dimention is for the the 
// endpoints of each edge.
#macro Geo_edge_e (Array)
        #local Size = dimension_size(Array,1);
        #local Edges = array[(Size*(Size -1))/2][2]
        #local Max = Size -2;
        #local E = 0;
        #local N = 0;
        #while (N <= Max)
           #local U_max = (Max - N);
           #local NU = 0;
           #while (NU <= U_max)
              #local Edges[E][0] = Array[NU][N];
              #local Edges[E][1] = Array[NU][N+1];
              #local NU = (NU + 1);
              #local E = E + 1;
           #end
           #local N = (N+1);
           
        #end
        Edges
#end
// Geo_triangles_a
//
// Uses output from Geoarray
// finds something like (Total_triangles + Frequency)/2 triangles
// Or about a little over half of the triangles.  
// Output is similar to Geo_edge_e except that the second dimention size is three for the 
// three corners of a triangle.
#macro Geo_triangles_a (Array)
        #local Size = dimension_size(Array,1);
        #local Triangles = array[(Size*(Size -1))/2][3]
        #local Max = Size -2;
        #local E = 0;
        #local N = 0;
        #while (N <= Max)
           #local U_max = (Max - N);
           #local NU = 0;
           #while (NU <= U_max)
              #local Triangles[E][0] = Array[NU][N];
              #local Triangles[E][1] = Array[NU][N+1];
              #local Triangles[E][2] = Array[NU + 1][N];
              #local NU = (NU + 1);
              #local E = E + 1;
           #end
           #local N = (N+1);
           
        #end
        Triangles
#end        

#macro Geo_triangles_b (Array)  // the ones Geo_triangles_a misses
        #local Size = dimension_size(Array,1);
        #local Triangles = array[((Size-2)*(Size -1))/2][3]
        #local Max = Size -3;
        #local E = 0;
        #local N = 0;
        #while (N <= Max)
           #local U_max = (Max - N);
           #local NU = 0;
           #while (NU <= U_max)
              #local Triangles[E][0] = Array[NU + 1][N + 1];
              #local Triangles[E][1] = Array[NU][N+1];
              #local Triangles[E][2] = Array[NU + 1][N];
              #local NU = (NU + 1);
              #local E = E + 1;
           #end
           #local N = (N+1);
           
        #end
        Triangles
#end        

//  Display_triangles
//
//  uses data of the type generated by Geo_triangles a, and b 
//  written quickly to test Geo_triangles_a.  I plan on rewritting this so that it generates a mesh.  

#macro Display_triangles(Array)
        #local N_triangles = dimension_size(Array,1)-1; // Find out the number of Triangles in Triangles array, then subtract 1
        #local N = 0;  // counter initialzer
        union {
        #while (N <= N_triangles)
          triangle{Array[N][0],Array[N][1],Array[N][2]}
          #local N = N + 1;
        #end }
#end
//  Geo_frame_mid
//
//  The struts that go up, and downish, rather than parrallel to the surface.
//  Data format similar to Geo_edge_e
#macro Geo_frame_mid (Array,Thickness)
        #local Size = dimension_size(Array,1);
        #local Struts = array[(Size) * 3][2]
        #local Max = (Size - 1);
        #local N = 0;
        #while (N <= Max)
           #local Triangle_center = vnormalize(Array[N][0] + Array[N][1] + Array[N][2])* (1 - Thickness);
           
           #local Struts[(3 * N) + 0][0] = Array[N][0];
           #local Struts[(3 * N) + 0][1] = Triangle_center;
           #local Struts[(3 * N) + 1][0] = Array[N][1];
           #local Struts[(3 * N) + 1][1] = Triangle_center;
           #local Struts[(3 * N) + 2][0] = Array[N][2];
           #local Struts[(3 * N) + 2][1] = Triangle_center;
           #local N = (N+1);
           
        #end
        Struts
#end        
//  Geo_frame_inner
//
//  The part on the inside of the sphere
#macro Geo_frame_inner_e (Array,Thickness)
        #local Size = dimension_size(Array,1);
        #local Edges = array[((Size - 2)*(Size -1))/2][2]
        #local Max = Size -3;
        #local E = 0;
        #local N = 0;
        #while (N <= Max)
           #local U_max = (Max - N);
           #local NU = 0;
           #while (NU <= U_max)
              #local TA1 = Array[NU][N];
              #local TA2 = Array[NU][N+1];
              #local TA3 = Array[NU + 1][N];
              #local TA = vnormalize(TA1 + TA2 + TA3)* (1 - Thickness);
              #local TB1 = Array[NU][N + 1];
              #local TB2 = Array[NU][N + 2];
              #local TB3 = Array[NU + 1][N + 1];
              #local TB = vnormalize(TB1 + TB2 + TB3)* (1 - Thickness);
              #local Edges[E][0] = TA;
              #local Edges[E][1] = TB;
              
              #local NU = (NU + 1);
              #local E = E + 1;
           #end
           #local N = (N+1);
           
        #end
        Edges
#end        
#macro Apply_matrix_to_triangle_array(Matrix,Array)// matrix,Array
        #local Size = dimension_size(Array,1);
        #local Max = (Size -1);
        #local N = 0;
        #while (N <= Max)
           #local Array[N][0] = V_matrix (Array[N][0],Matrix);
           #local Array[N][1] = V_matrix (Array[N][1],Matrix);
           #local Array[N][2] = V_matrix (Array[N][2],Matrix);
           
        #local N = N + 1;
        #end
        Array
#end
#macro Triangle_array_splice(Triangle_array1,Triangle_array2)
        #local Array_size1 = dimension_size(Triangle_array1,1);
        #local Array_size2 = dimension_size(Triangle_array2,1);
        #local Spliced_size = (Array_size1 + Array_size2);
        #local Spliced = array[Spliced_size][3]
        #local N = 0;
        #while (N < Spliced_size)
            #while (N < Array_size1)
                 #local Spliced[N][0] = Triangle_array1[N][0];
                 #local Spliced[N][1] = Triangle_array1[N][1];
                 #local Spliced[N][2] = Triangle_array1[N][2];
            #local N = N + 1;
            #end
            #while (N >= Array_size1 & N < Spliced_size)
                 #local N2 = N - Array_size1;
                 #local Spliced[N][0] = Triangle_array2[N2][0];
                 #local Spliced[N][1] = Triangle_array2[N2][1];
                 #local Spliced[N][2] = Triangle_array2[N2][2];
            #local N = N + 1;
            #end
        #end
        Spliced
#end
#macro Icosahedron_geodesic_triangles_all(Frequency)
        #local P1 = vnormalize(Icosahedron[1]);  //  The corners of one triangle on an icosahedron
        #local P2 = vnormalize(Icosahedron[5]);
        #local P3 = vnormalize(Icosahedron[7]);
        #local Center = Dodecahedron[7];         //  Center of triangle face
        #local Geo = Geoarray (P1,P2,P3,Frequency)
        #local Triangles1 = Geo_triangles_a(Geo)
        #local Triangles2 = Geo_triangles_b(Geo)
        #local Triangles = Triangle_array_splice(Triangles1,Triangles2)
        #local First_transform = H2tr_m(Center,P1,Icosahedron_face_a[0][0],Icosahedron_face_a[0][1])
        #local All_triangles = Apply_matrix_to_triangle_array(First_transform,Triangles)
        #local N_faces = 20;                     //  Number of faces
        #local N = 1;                            //  Counter initializer
        #while (N < N_faces)
                #local This_transform = H2tr_m(Center,P1,Icosahedron_face_a[N][0],Icosahedron_face_a[N][1])
                #local Next_peice = Apply_matrix_to_triangle_array(This_transform,Triangles)
                #local All_triangles = Triangle_array_splice(All_triangles,Next_peice)
                #local N = N + 1;
        #end
        All_triangles
#end
// For convenience
#declare P1 = vnormalize(Icosahedron[1]);  //  The corners of one triangle on an icosahedron
#declare P2 = vnormalize(Icosahedron[5]);
#declare P3 = vnormalize(Icosahedron[7]);
#declare Frequency = 10;                   //  Divisions of an edge of said triangle
#declare Sphere_size = .006;               //  used during testing of Geopoint
#declare Frame_thickness = .08;            //  Distance between the outside, and iside of the sphere
#declare Strut_radius = .002;              //  Thickness of each cylinder

#declare Geo = Geoarray (P1,P2,P3,Frequency)     //  Calling most functions
#declare Geo_edges = Geo_edge_e(Geo)             //  I usually do this to test for parsing errors
#declare Geo_triangles1 = Geo_triangles_a(Geo)   //  Before trying to render
#declare Geo_triangles2 = Geo_triangles_b(Geo)
#declare Geo_triangle_patch = Triangle_array_splice(Geo_triangles1,Geo_triangles2)
#declare Midframe = Geo_frame_mid (Geo_triangles1,Frame_thickness)
#declare Innerframe = Geo_frame_inner_e (Geo,Frame_thickness)
//#declare Geo_triangle_patch2 = Apply_matrix_to_triangle_array(H2tr_m(-z,P1,-z,-x),Geo_triangle_patch)
//#declare Roaklsjdh = H2tr_m(-z,P1,-z,-x)
//#declare Triag = Icosahedron_geodesic_triangles_all(10)
//object{Display_triangles(Geo_triangles) pigment{Blue}}
//object {Cylinder_edges(Geo_edges,1,.02) pigment {Green}}
/*#declare Triangle_patch =
union {
        sphere{Geopoint (P1,P2,P3,Frequency,0,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,6) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,7) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,8) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,9) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,0,10) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,1) ,Sphere_size}      //  Still haven't 
        sphere{Geopoint (P1,P2,P3,Frequency,1,2) ,Sphere_size}      //  written a function
        sphere{Geopoint (P1,P2,P3,Frequency,1,3) ,Sphere_size}      //  to display vertex points
        sphere{Geopoint (P1,P2,P3,Frequency,1,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,6) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,7) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,8) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,1,9) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,6) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,7) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,2,8) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,6) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,3,7) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,4,6) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,5,5) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,6,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,6,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,6,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,6,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,6,4) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,7,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,7,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,7,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,7,3) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,8,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,8,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,8,2) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,9,0) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,9,1) ,Sphere_size}
        sphere{Geopoint (P1,P2,P3,Frequency,10,0) ,Sphere_size}
        union{ object {Cylinder_edges(Geo_edges,1,.005) }
               object {Cylinder_edges(Geo_edges,1,.005) R(Dodecahedron[7],2*pi/3)}
               object {Cylinder_edges(Geo_edges,1,.005) R(Dodecahedron[7],-2*pi/3)}
               material{hama_mat0}}
        object{Display_triangles(Geo_triangles) pigment {rgbft<0,0,1,.4,.4>}finish{Dull}}
        pigment {Red}} 
          */
#declare Triangle_patch_e =  union{ object {Cylinder_edges(Geo_edges,1,Strut_radius)}
               object {Cylinder_edges(Geo_edges,1,Strut_radius) Axis_rotate(Dodecahedron[7],2*pi/3)}
               object {Cylinder_edges(Geo_edges,1,Strut_radius) Axis_rotate(Dodecahedron[7],-2*pi/3)}
               object {Cylinder_edges(Midframe,1,Strut_radius) }
               object {Cylinder_edges(Innerframe,1,Strut_radius) }
               object {Cylinder_edges(Innerframe,1,Strut_radius) Axis_rotate(Dodecahedron[7],2*pi/3)}
               object {Cylinder_edges(Innerframe,1,Strut_radius) Axis_rotate(Dodecahedron[7],-2*pi/3)}
               }
#declare Triangle_patch_t = object{Display_triangles(Geo_triangles1) pigment {rgbft<0,0,1,.4,.4>}finish{Dull}}     
#declare Triangle_patch_t2 = object{Display_triangles(Geo_triangles2) pigment {rgbft<0,0,1,.4,.4>}finish{Dull}}     

//object {Triangle_patch_e pigment{Green}}
//Triangle_patch_t
//sphere {Icosahedron_c_radius*Dodecahedron[7]/Dodecahedron_c_radius .1 pigment{Green}}
//Triangle_patch
//object {Face_rotate(Dodecahedron[7],P1,Icosahedron_face_a,Triangle_patch) H2t_sr(P3,-z) finish {Dull}}
object {Face_rotate(Dodecahedron[7],P1,Icosahedron_face_a,Triangle_patch_e) H2t_sr(P3,-z) material{hama_mat0}}
object {Face_rotate(Dodecahedron[7],P1,Icosahedron_face_a,Triangle_patch_t) H2t_sr(P3,-z)}
//object {Face_rotate(Dodecahedron[7],P1,Icosahedron_face_a,Triangle_patch_t2) H2t_sr(P3,-z)}

//object {Display_triangles(Geo_triangle_patch) pigment{Blue}}
//object {Display_triangles(Geo_triangles1) pigment{Blue}}
//#render str(dimension_size(Geo_triangles1,1),1,-1)
//object {Display_triangles(Triag) pigment{Blue}}
//object {Display_triangles(Geo_triangle_patch2) pigment{Blue}}
