#version unofficial megapov 0.7;

#include "hsl.inc"
//#include "mymacros.inc"

/*
Important!
In MegaPOV 0.7 at least there seems to be a bug with using trace()
in conjunction with isosurfaces. A workaround in the Windows version
is to set FirstRender to "yes" for the first time you render the
scene; this will just produce a black image, but will allow you to
set FirstRender to "no" for subsequent renders, producing the actual
ground image.
I could not get this to work with my Linux compile of MP 0.7
*/
#declare FirstRender=no; //Set to "no" for subsequent renders

#declare Rad=30000; //Earth radius

//Camera
#declare CPos=<1,1.5,-5>;
camera{location CPos look_at y*1}

//Kludge to overcome what appears to be a bug with trace() and isosurfaces
#if(FirstRender)

#declare O=sphere{0,1}
#declare N=<0,0,0>;
#declare P=trace(O,0,z,N);
object{O}

#else

//Fill light
light_source{
  CPos hsl(.75,.7,.2)
  shadowless
  media_interaction 0
}

//Sky light
light_source{
  y*1000 hsl(.75,.4,.2)
  parallel point_at 0
  shadowless
  media_attenuation 0 media_interaction 1
}

//Sun

#declare LPos=<-50,13,-100>*100;

light_source{
  LPos color hsl(.95,0,2)
  media_attenuation 0
  media_interaction 1
  parallel point_at 0
  glow{size 200 color hsl(.95,.3,1)}
}

//Macros

#macro rand_ext(M,D,Seed)
  (M+(rand(Seed)-.5)*2*D)
#end

#macro v_rand_ext(M,D,Seed)
  #local MV=M+<0,0,0>;
  #local DV=D+<0,0,0>;
  (<rand_ext(MV.x,DV.x,Seed),rand_ext(MV.y,DV.y,Seed),rand_ext(MV.z,DV.z,Seed)>)
#end

#macro v_debug(V)
  concat("<",str(V.x,0,3),",",str(V.y,0,3),",",str(V.z,0,3),">")
#end

//Ground

#declare S=function{sqrt(x^2+y^2+z^2)-Rad-1.7}
#declare N=function{"ridgedMF",<.8,1.5,3,.8,.2>}
#declare N2=function{pigment{crackle color_map{[.1 rgb 0][1 rgb 1]} scale .04 offset .5}}

#declare GroundTex=
texture{
  pigment{crackle color_map{[0 hsl(.13,.3,.5)][.7 hsl(.19,.3,.75)]} solid offset .5 scale .04}
  finish{ambient 0 diffuse .7 brilliance 1.2}
}

#declare Ground=
isosurface{
  function{S(x,y,z)+noise3d(x*.05,0,z*.1-7.8)*4-N(x*.75,y*.75,z*.75)*.17-N2(x,y,z)*.15}
  contained_by{sphere{0,Rad+10}}
  translate -y*Rad
}

object{Ground texture{GroundTex}}

//Throw in some stones

#declare Seed=seed(44224);
#declare StoneTex=
texture{
  normal{granite .5 scale .1}
  finish{diffuse .7 brilliance 1.3}
}

#macro PlaceStones(Radius,Number,Size,Rand,Seed)
  #local C=0;
  #while(C<Number)
    #local PosXZ=vrotate(z*rand_ext(0,Radius,Seed),y*rand(Seed)*360);
    #local N=<0,0,0>;
    #local Pos=trace(Ground,PosXZ-100*y,y,N);
    #if(N.x!=0&N.y!=0&N.z!=0)
      #local RandTrans=v_rand_ext(0,20,Seed);
      #local RandSize=Size*v_rand_ext(1,Rand,Seed);
      #local RandScale=v_rand_ext(Size*11,Size*2,Seed);
      #local SphereFunc=function{"sphere",<1>}
      #local ModFunc=
        function{
          pigment{
            crackle
            color_map{[0 rgb 0][.3 rgb .5][1 rgb 1]}
            turbulence .1
            scale RandScale
            translate RandTrans
          }
        }
      isosurface{
        function{SphereFunc(x,y,z)+ModFunc(x,y,z)*.3}
        contained_by{sphere{0,1}}
        scale RandSize
        translate Pos
        texture{
          StoneTex
          pigment{
            granite
            color_map{
              [0 hsl(rand_ext(.15,.1,Seed),rand_ext(.2,.1,Seed),rand_ext(.4,.2,Seed))]
              [1 hsl(rand_ext(.13,.2,Seed),rand_ext(.2,.1,Seed),rand_ext(.7,.3,Seed))]
            }
            scale .1
          }
        }
      }
    #else
      #warning concat("No intersection at PosXZ:",v_debug(PosXZ),"\n")
    #end
    #local C=C+1;
  #end
#end //Macro

PlaceStones(300,2000,.17,.7,Seed)
PlaceStones(100,5000,.07,.5,Seed)

#end //FirstRender