//"hslft" lets you specify colours with the
//hue-saturation-lightness colour model.
//You can also use "hsl", "hslf" and "hslt" as shortcuts,
//just like "rgb", "rgbf" and "rgbt";
//H - hue; circular spectrum running red-green-blue-red
//S - saturation, i.e. the amount of colour in relation to gray
//L - lightness of the colour
//F,T - filter and transmit of the colour
#macro hslft(H,S,L,F,T)
    //Construct rgb from hue
    #if(H<1/3) #local R=min(2-H*6,1); #end
    #if(H>2/3) #local R=min((H-2/3)*6,1); #end
    #if(H>=1/3&H<=2/3) #local R=0; #end

    #if(H<=1/3) #local G=min(H*6,1); #end
    #if(H>1/3&H<2/3) #local G=min(2-(H-1/3)*6,1); #end
    #if(H>=2/3) #local G=0; #end

    #if(H>1/3&H<=2/3) #local B=min((H-1/3)*6,1); #end
    #if(H>2/3) #local B=min(2-(H-2/3)*6,1); #end
    #if(H<=1/3) #local B=0; #end
    
    //Incorporate saturation and lightness
    #local RGB=((1-S)+S*<R,G,B>)*L;
    rgbft<RGB.x,RGB.y,RGB.z,F,T>
#end
#macro hsl(H,S,L) hslft(H,S,L,0,0) #end
#macro hslf(H,S,L,F) hslft(H,S,L,F,0) #end
#macro hslt(H,S,L,T) hslft(H,S,L,0,T) #end


//"cslft" lets you change the saturation and brightness
//of a specified rgb colour.
//You can also use "csl", "cslf" and "cslt" as shortcuts,
//just like "rgb", "rgbf" and "rgbt".
//C - rgb colour
//S - saturation, relative to C
//L - lightness, relative to C
//F,T - filter and transmit of the colour
#macro cslft(C,S,L,F,T)
    #local C=C+<0,0,0>; //force C to vector
    //Calculate luminance of C
    //#local Lum=.3*C.x+.59*C.y+.11*C.z; //retains visual brightness
    #local Lum=(C.x+C.y+C.z)/3; //retains hue
    
    //Rescale R,G,B using Lum as origin
    #local R=Lum+(C.x-Lum)*S;
    #local G=Lum+(C.y-Lum)*S;
    #local B=Lum+(C.z-Lum)*S;
    
    //Incorporate lightness
    rgbft<R,G,B,F,T>*L
#end
#macro csl(C,S,L) cslft(C,S,L,0,0) #end
#macro cslf(C,S,L,F) cslft(C,S,L,F,0) #end
#macro cslt(C,S,L,T) cslft(C,S,L,0,T) #end
