//Infinity in a box, an experiment in creative bounding
//NB! Remember to turn off user bounds removal (-UR command-line switch)
//
//Margus Ramst 2000

//Some features require MegaPOV
#version unofficial megapov 0.6;

//Include HSL colour macros
#include "hsl.inc"

//Interpolation macro
//GC - global current
//GS - global start
//GE - global end
//TS - target start
//TE - target end
//Method - interpolation method:
//         Method = 0 - cosine interpolation
//         Method > 0 - exponential (1 - linear, etc)

#macro Interpolate(GC,GS,GE,TS,TE,Method)
    (#if(Method!=0)
        (TS+(TE-TS)*pow((GC-GS)/(GE-GS),Method))
    #else
        #local X=(GC-GS)/(GE-GS);
        #local F=(1-cos(X*pi))*.5;
        (TS*(1-F)+TE*F)
    #end)
#end


global_settings{max_trace_level 10}

//Camera position
#declare CPos=<2.4,1,-3>*1.3;
#declare CPos=vrotate(CPos,x*Interpolate(clock,0,1,0,35,1.6));
#declare CPos=vrotate(CPos,y*Interpolate(clock,0,1,0,360,.8));

//Light source positions
#declare LPos=<-7,10,-6>;
#declare LPos2=<-.5,-2,.5>*10

camera{location CPos look_at y*-.3}

light_source{
  -y*.1 hsl(0,.2,.7)
  shadowless
  groups "iso"
}

light_source{LPos color hsl(.05,.2,.8) parallel point_at 0 groups "main"}

light_source{LPos2 hsl(.02,.8,1) fade_distance 10 fade_power 3 shadowless groups "iso"}

#declare Tex=
texture{
  pigment{hsl(.1,.6,1)}
  finish{ambient .1 diffuse .7 brilliance 5}
}
#declare CTex=
texture{
  pigment{hsl(.69,.06,.6)}
  finish{brilliance 6 specular .6 roughness .03}
}

//Radius of the cylinders in the frame
#declare CRad=.05;
               
//Corners of the box
#declare A1=<-1,-1,-1>;
#declare A2=<1,-1,-1>;
#declare A3=<1,-1,1>;
#declare A4=<-1,-1,1>;
#declare B1=<-1,1,-1>;
#declare B2=<1,1,-1>;
#declare B3=<1,1,1>;
#declare B4=<-1,1,1>;

//Array of normals for the box faces
#declare Normal=array[6]{-y,-z,x,z,-x,y}

//Array of face centers, with unit box this is the same as the array of normals
#declare CA=Normal

//Declare array for flags designating visible faces
#declare DA=array[6]

//Declare counter for visible faces
#declare FC=0;

#declare C=0;
#while(C<6)
  //Determine if a face is visible from the current camera position
  #if(vdot(vnormalize(CPos-CA[C]),Normal[C])>=0)
    #declare DA[C]=1;
    #declare FC=FC+1;
  #else
    #declare DA[C]=0;
  #end
  #declare C=C+1;
#end

//Determine how many corners are visible
#if(FC=1) #declare CC=4;
#else
  #if(FC=2) #declare CC=7;
  #else
    #declare CC=9;
  #end
#end

//Declare array for endpoints of visible edges
#declare P=array[CC][2]

//Array for those edges that are on the object horizon
//(only those are needed for constructing the bounding object below)
#declare IsHorizon=array[CC]

#declare C=0;

//Find edges at object horizon (those between a visible and invisible face)
#if(DA[0]!=DA[1]) #declare P[C][0]=A1; #declare P[C][1]=A2; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[0]!=DA[2]) #declare P[C][0]=A2; #declare P[C][1]=A3; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[0]!=DA[3]) #declare P[C][0]=A3; #declare P[C][1]=A4; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[0]!=DA[4]) #declare P[C][0]=A4; #declare P[C][1]=A1; #declare IsHorizon[C]=1; #declare C=C+1; #end

#if(DA[1]!=DA[2]) #declare P[C][0]=A2; #declare P[C][1]=B2; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[2]!=DA[3]) #declare P[C][0]=A3; #declare P[C][1]=B3; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[3]!=DA[4]) #declare P[C][0]=A4; #declare P[C][1]=B4; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[4]!=DA[1]) #declare P[C][0]=A1; #declare P[C][1]=B1; #declare IsHorizon[C]=1; #declare C=C+1; #end

#if(DA[5]!=DA[1]) #declare P[C][0]=B1; #declare P[C][1]=B2; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[5]!=DA[2]) #declare P[C][0]=B2; #declare P[C][1]=B3; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[5]!=DA[3]) #declare P[C][0]=B3; #declare P[C][1]=B4; #declare IsHorizon[C]=1; #declare C=C+1; #end
#if(DA[5]!=DA[4]) #declare P[C][0]=B4; #declare P[C][1]=B1; #declare IsHorizon[C]=1; #declare C=C+1; #end

//find edges between two visible faces
#if(DA[0]=DA[1]&DA[0]=1) #declare P[C][0]=A1; #declare P[C][1]=A2; #declare C=C+1; #end
#if(DA[0]=DA[2]&DA[0]=1) #declare P[C][0]=A2; #declare P[C][1]=A3; #declare C=C+1; #end
#if(DA[0]=DA[3]&DA[0]=1) #declare P[C][0]=A3; #declare P[C][1]=A4; #declare C=C+1; #end
#if(DA[0]=DA[4]&DA[0]=1) #declare P[C][0]=A4; #declare P[C][1]=A1; #declare C=C+1; #end

#if(DA[1]=DA[2]&DA[1]=1) #declare P[C][0]=A2; #declare P[C][1]=B2; #declare C=C+1; #end
#if(DA[2]=DA[3]&DA[2]=1) #declare P[C][0]=A3; #declare P[C][1]=B3; #declare C=C+1; #end
#if(DA[3]=DA[4]&DA[3]=1) #declare P[C][0]=A4; #declare P[C][1]=B4; #declare C=C+1; #end
#if(DA[4]=DA[1]&DA[4]=1) #declare P[C][0]=A1; #declare P[C][1]=B1; #declare C=C+1; #end

#if(DA[5]=DA[1]&DA[5]=1) #declare P[C][0]=B1; #declare P[C][1]=B2; #declare C=C+1; #end
#if(DA[5]=DA[2]&DA[5]=1) #declare P[C][0]=B2; #declare P[C][1]=B3; #declare C=C+1; #end
#if(DA[5]=DA[3]&DA[5]=1) #declare P[C][0]=B3; #declare P[C][1]=B4; #declare C=C+1; #end
#if(DA[5]=DA[4]&DA[5]=1) #declare P[C][0]=B4; #declare P[C][1]=B1; #declare C=C+1; #end

// Create the bounding object that is the "inverse" of the box.
// It is basically a tapering prism, open at the base, with its endpoint
// behind the camera, and its faces tangent to the "infinity box".
// This has the effect that only those camera rays which _do_not_ hit the
// "infinity box" will hit this bounding object, and thus the shilouette
// of the box is cut out of any objects bounded with this shape.
// The ground plane and sky sphere (no, not sky_sphere) are bounded like this.
#declare C=0;
#declare BObj=
union{
#while(C<CC)
  #if(defined(IsHorizon[C]))
    polygon{3,P[C][0],P[C][1],CPos*1.0001 translate -CPos scale 10000 translate CPos}
  #end
  #declare C=C+1;
#end
}

//The ground
plane{
  y,0
  pigment{
    crackle metric 100 solid
    color_map{[0 hsl(.9,.2,.8)][1 hsl(.6,.4,.1)]}
  }
  translate <0,-1-CRad,0>
  bounded_by {object{BObj}}
  light_group "main"
}

//The sky
sphere{-.8*y,1
  texture{
  pigment{gradient y color_map{[.13 hsl(0,.9,.25)][.27 hsl(.6,.5,.13)][.6 hsl(.67,.3,.05)]} rotate -x*10 translate y*-.3}
  finish{ambient 1 diffuse 0}
  }
  texture{
    pigment{
      bozo color_map{[.3 rgbf 1][.5 hslf(.04,.1,.7,1)][1 hslf(.04,0,.7,.8)]}
      scale <.16,.03,.16> turbulence .4 octaves 8 lambda 3 omega .65
    }
    finish{ambient 1 diffuse 0}
  }
  scale 1000
  no_shadow
  bounded_by{BObj}
  hollow
}

//Create the "infinite" array of boxes with an isosurface
#declare CubeTex=
texture{
  pigment{
    crackle
    solid
    color_map{[0 hsl(.05,.15,.7)][.5 hsl(.45,.1,1)][1 hsl(.6,.1,1)]}
    metric 10
    scale .07
  }
  finish{ambient 0}
}
#declare F1=function{max(abs(x),max(abs(y),abs(z)))-.15}
#declare F1=function{F1(x-.5,y-.5,z-.5)}
#declare F1=function{F1(x-floor(x),y-floor(y),z-floor(z))}
#declare Iso=
isosurface{
  function{F1(x/3,y/3+.5,z/3)}
  threshold 0
  contained_by{box{<-2000,-2000,-2000>,<2000,-1,2000>}}
  texture{CubeTex}
}
object{Iso bounded_by{union{box{-1,1} sphere{LPos2,.001}}} light_group "iso"}


// Create the visible frame for the box, excluding those edges
// that should not be visible from the current camear position.
#declare C=0;
#declare Frame=
union{
#while(C<CC)
    cylinder{P[C][0],P[C][1],CRad}
    sphere{P[C][0],CRad}
    sphere{P[C][1],CRad}
    #declare C=C+1;
#end
}

object{
  Frame
  texture{CTex finish{reflection .3 reflection_exponent .7}}
  light_group "main"
}

//Create a second frame to help cast correct shadows
#declare Frame2=
union{
  cylinder{A1,A2,CRad}
  cylinder{A2,A3,CRad}
  cylinder{A3,A4,CRad}
  cylinder{A4,A1,CRad}
  
  cylinder{A1,B1,CRad}
  cylinder{A2,B2,CRad}
  cylinder{A3,B3,CRad}
  cylinder{A4,B4,CRad}
  
  cylinder{B1,B2,CRad}
  cylinder{B2,B3,CRad}
  cylinder{B3,B4,CRad}
  cylinder{B4,B1,CRad}
  
  sphere{A1,CRad}
  sphere{A2,CRad}
  sphere{A3,CRad}
  sphere{A4,CRad}
  sphere{B1,CRad}
  sphere{B2,CRad}
  sphere{B3,CRad}
  sphere{B4,CRad}
}

object{
  Frame2
  //box{-1,1} //use this instead if you want to give the "infinity box" a solid shadow
  no_image
  light_group "main"
}
