// *******************************************************************
//
//             Persistence of Vision Raytracer Version 3.1g
//             MBH   Revision   of  Standard   TEXTURES.INC
//             for Our_House.INC v4.0             Fall 1999
//             for Modernist_House v2.0         Winter 2000
//
//   Contents:
//   ===========================
//   Grass,
//   T_Glass1, T_Ruby_Glass, T_Green_Glass,
//   T_Stone2, Spex, T_Grnt0, Grnt20, B_Red_Brick, JB_Brick_1,
//   Red_Marble,
//   T_Wood2, T_Wood5, EBWood1, Seams_X, Seams_Y,
//
// *******************************************************************
// Thanks to Jeff Lee <shipbrk@gate.net> for use of Bricks.INC  
// *******************************************************************

#version 3.1;

#include "finish.inc"

#ifdef(View_POV_Include_Stack)
#   debug "including tex_home.inc\n"
#end

#local Tex_Home_Inc_Temp = version;

// *******************************************************************
// *******************************************************************

#declare Grass =
texture {
   pigment {
      spotted
      color_map {
         [ 0.00  0.35  color Green        color PaleGreen   ]
         [ 0.35  0.60  color PaleGreen    color Green       ]
         [ 0.60  0.80  color Green        color SpringGreen ]
         [ 0.80  1.00  color SpringGreen  color LimeGreen   ]
                } // end color map
   turbulence 7.5
   quick_color Green
           } // end pigment
   scale < 0.75, 0.4, 0.75 >
   normal { bumps 0.4  scale 0.2 }
        } // end Grass texture

// *******************************************************************
//                           GLASS Textures
// *******************************************************************

#declare I_Glass=
   interior { ior 1.5 }
  
#declare F_Glass1 =
   finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1 }   
  
#declare F_Glass3 =
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    specular 0.8
    roughness 0.003
    phong 1
    phong_size 400 }

#declare F_Glass4 =
finish {
    ambient 0.1
    diffuse 0.1
    reflection .25
    specular 1
    roughness 0.001 }

// **************************************************************

// Clear:
#declare T_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.9> }
    finish  { F_Glass1 }
        }

// **************************************************************

// Red:
#declare T_Ruby_Glass =
texture {
    finish { F_Glass4 }
    pigment { color rgbf <0.9, 0.1, 0.2, 0.8> }
        }

// **************************************************************

// Green:
#declare T_Green_Glass =
texture {
    pigment { color rgbf <0.5, 1, 0.85, 0.8> }
    finish { F_Glass3 }
        }

// **************************************************************

// Blue:
#declare T_Blue_Glass =
texture {
    pigment { color rgbf <0.3, 0.9, 0.9, 0.8> }
    finish { F_Glass3 }
        }

//********************************************************************
//                           STONE PIGMENTS
//********************************************************************

//--------- Gray  Tan with Rose
#declare T_Grnt0 =
texture {
   pigment
      { granite
        turbulence 0.4
        color_map
           { [0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                             color rgbf <0.769, 0.686, 0.592, 0.000>]
             [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                             color rgbf <0.843, 0.753, 0.718, 0.000>]
             [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                             color rgbf <0.780, 0.667, 0.561, 0.000>]
             [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                             color rgbf <0.741, 0.659, 0.576, 0.000>]
             [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                              color rgbf <0.729, 0.502, 0.451, 0.000>] }
        quick_color White
      } // end pigment
        } // end texture
       
//--------- Tan Cream & Red Rose
#declare T_Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.969, 0.800, 0.000>]
   }
 }
 }

//--------- White Marble with Gray feather Viens
#declare T_Grnt20 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color Mica color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]
   }
  quick_color Gray90 
 }
 finish {
  crand 0.02
 }
 }


//----- Translucent T_Grnt0
#declare T_Grnt0a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                    color rgbf <0.769, 0.686, 0.592, 0.792>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                    color rgbf <0.843, 0.753, 0.718, 0.396>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                    color rgbf <0.780, 0.667, 0.561, 0.976>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                    color rgbf <0.741, 0.659, 0.576, 0.820>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                    color rgbf <0.729, 0.502, 0.451, 0.306>]
   }
 }
 }


// -----Translucent T_Grnt7
#declare T_Grnt7a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.439, 0.310, 0.282, 0.631>
                    color rgbf <0.463, 0.369, 0.259, 0.847>]
    [0.119, 0.322   color rgbf <0.463, 0.369, 0.259, 0.847>
                    color rgbf <0.541, 0.369, 0.298, 0.549>]
    [0.322, 0.449   color rgbf <0.541, 0.369, 0.298, 0.549>
                    color rgbf <0.573, 0.424, 0.286, 0.965>]
    [0.449, 0.729   color rgbf <0.573, 0.424, 0.286, 0.965>
                    color rgbf <0.494, 0.396, 0.306, 0.741>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.741>
                    color rgbf <0.439, 0.310, 0.282, 0.631>] }//end map
  quick_color White
 }//end pigment
        } // end texture


//-----Aqua Tints
#declare T_Grnt8a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>]
   }
   quick_color Clear
 }
 }

//-----Filter Creams With T_Cracks
#declare T_Grnt9a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.745, 0.843, 0.835, 0.847>]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                    color rgbf <0.404, 0.337, 0.337, 0.463>]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                    color rgbf <0.773, 0.729, 0.745, 0.622>]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                    color rgbf <0.914, 0.843, 0.725, 0.651>]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                    color rgbf <0.153, 0.133, 0.208, 0.437>]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
   }
 }
 }

#declare T_Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

// --------------------T_Crack & OverTint /Red---------------------
#declare T_Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//********************************************************************
//                           STONE TEXTURES
//********************************************************************

// ------------- Light Greenish Tan Marble with Agate style veining
#declare T_Stone2 =
texture { T_Grnt0  scale <  2, 3,   2> rotate < 0, 0,  40> }
texture { T_Grnt7a scale <1.3, 2, 1.3> rotate <40, 0, -30> }

//------------- White Cream Marble with Pink veining
#declare T_Stone5 =
texture{T_Grnt12  scale <2, 3, 2> rotate <0, 0, 40>}
texture{T_Grnt17a scale <2, 3, 2> rotate <0, 0, -30>}
texture{T_Crack1  scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Gray Granite with white patches
#declare T_Stone8 =
texture{pigment{color White}
        finish{ambient 0.4 crand 0.06 diffuse 0.7}
}
texture{T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30>}
texture{T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
        finish{phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90}
}

//------------- Deep Gray Marble with white veining
#declare T_Stone15 =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{T_Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

// **************************************************************

#declare Spex=                         // By Dan Farmer
texture {
    pigment {
        granite
        color_map {
            [ 0.0 0.7  color Black   color Black  ]
            [ 0.7 1.0  color Orange  color Orange ] }//end map
        quick_color Orange
            }//end pigment
    finish {
        phong 0.35
        phong_size 15
        ambient 0.3
        diffuse 0.26
        reflection 0.15
            }//end finish
        } // end texture

// **************************************************************

// --------- Gray  Tan with Rose
#declare T_Grnt0 =
texture {
   pigment
      { granite
        turbulence 0.4
        color_map {
           [0.000, 0.153  color rgbf <0.729, 0.502, 0.451, 0.000>
                          color rgbf <0.769, 0.686, 0.592, 0.000>]
           [0.153, 0.398  color rgbf <0.769, 0.686, 0.592, 0.000>
                          color rgbf <0.843, 0.753, 0.718, 0.000>]
           [0.398, 0.559  color rgbf <0.843, 0.753, 0.718, 0.000>
                          color rgbf <0.780, 0.667, 0.561, 0.000>]
           [0.559, 0.729  color rgbf <0.780, 0.667, 0.561, 0.000>
                          color rgbf <0.741, 0.659, 0.576, 0.000>]
           [0.729, 1.001  color rgbf <0.741, 0.659, 0.576, 0.000>
                          color rgbf <0.729, 0.502, 0.451, 0.000>] }
        quick_color Tan
      }// end pigment
        } // end texture

// **************************************************************

#declare Grnt20 =                      // White Marble, gray feather veins
texture {
   pigment {
      granite
      turbulence 0.5
      color_map {
         [ 0.0  0.3  color Black  color White ]
         [ 0.3  0.4  color White  color White ]
         [ 0.4  0.7  color White  color White ]
         [ 0.7  1.0  color White  color Gray50 ]
                }  // end color map
   quick_color Yellow
           }//end pigment
   finish {
      ambient 0.3
      diffuse 0.3
      reflection 0.25
          }//end finish
        }  // end texture

// **************************************************************
/*
//  DEFINE Brendan's Red Brick

#declare B_Red_Brick =
texture {
   pigment { brick  Gray50  Firebrick  scale 0.25 } //end pigment
   finish  { ambient 0.3   diffuse 0.5
             specular 0.4  roughness 0.02 }
        } //end texture

// **************************************************************

//    DEFINE  a variation of brick texture:
//    uses Jeff Lee's BRICKS.INC (c) 1998  <shipbrk@gate.net>
#declare JB_Brick_1 =
   #declare newBrickHeight = 0.30;
   #declare newBrickWidth  = 0.65;
   #declare newBrickDepth  = 0.5;
   #declare newBrickClearMortar=1;
   #declare newBrickMortarWidth = 0.05;
   #declare newBrickTurbulence=0.005;
   #declare newBrickNormal = normal { marble 0.01 }
   #include "bricks.inc"
   texture { T_newBrick }

// **************************************************************
// **************************************************************

//    DEFINE  Ib Rassmensen's brick texture:   (c)Nov 99
#declare BHeight =  0.6;  //my changes
#declare BWidth  =  1.0;

//#declare BHeight =  0.4;  // original
//#declare BWidth  =  0.9;

#declare T_MBH_MortarColor = 
texture {
   pigment { 
      granite
      turbulence 0.6
      color_map{
	  [0.000, 0.154   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.154, 0.300   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.300, 0.320   color rgbf <0.5, 0.5, 0.500, 0.000>
			  color rgbf <0.6, 0.6, 0.600, 0.000>]
	  [0.320, 0.615   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.7, 0.7, 0.566, 0.000>]
	  [0.615, 0.812   color rgbf <0.7, 0.7, 0.566, 0.000>
			  color rgbf <0.7, 0.7, 0.677, 0.000>]
	  [0.812, 1.001   color rgbf <0.7, 0.7, 0.700, 0.000>
			  color rgbf <0.1, 0.1, 0.100, 0.000>]
               }// end map
           }// end pigment
   scale <3, 3, 3>
   finish { ambient 0.3 diffuse 0.7 }
        } // end mortar texture

#declare T_MBH_BrickColor = 
texture {
   pigment { 
      bozo
      turbulence 1.0
      color_map{
         [0.0, 0.5   color rgbf <0.13, 0.04, 0.04, 0.0>
                     color rgbf <0.20, 0.07, 0.04, 0.0>]
         [0.5, 1.001 color rgbf <0.20, 0.07, 0.04, 0.0>
                     color rgbf <0.13, 0.04, 0.04, 0.0>]
               }// end map
           }// end pigment
   scale <30, 30, 30>
        } // end brick texture

#declare T_MBH_Brick = 
texture {
   brick texture {T_MBH_MortarColor}, texture {T_MBH_BrickColor}
   brick_size <BWidth, BHeight, BWidth/2>
   mortar 0.05
        } // end BS Brick textr
*/

// **************************************************************

//    DEFINE  variation of Ib Rassmensen's brick texture (c)Nov 99
#declare BHeight =  10;
#declare BWidth  =  15;

#declare T_MBH_MortarColor_1 = 
texture {
   pigment { Gray80 }                  // end pigment
   finish { ambient 0.3 diffuse 0.4 }  // end finish
        } // end mortar texture 1

#declare C_MBH_Brick_Color=
color rgbf <0.70, 0.22, 0.24, 0.0>;

#declare T_MBH_BrickColor_1 = 
texture {
   pigment { C_MBH_Brick_Color }       // end pigment
   finish { ambient 0.3 diffuse 0.4 }  // end finish
        } // end brick texture 1

#declare T_MBH_Brick_1 = 
texture {
   brick texture { T_MBH_MortarColor_1 }, texture { T_MBH_BrickColor_1 }
   brick_size < BWidth, BHeight, BWidth/2 >
   mortar 0.75
        } // end MBH Brick texture

// **************************************************************

//    DEFINE  Red Marble from TEXTURES.INC:
// Classic white marble with red veins.
#declare Red_Marble_Map = 
color_map {
    [0.0 rgb <0.8, 0.8, 0.6>]
    [0.8 rgb <0.8, 0.4, 0.4>]
    [1.0 rgb <0.8, 0.2, 0.2>]
}

#declare Red_Marble = 
pigment {
    marble
    color_map { Red_Marble_Map }
    turbulence 1
}

// **************************************************************
// **************************************************************

// *******************************************************************
//                           SKY PIGMENTS
// *******************************************************************

#declare Bright_AquaBlue4 =            //AQUA09 version
pigment {
   bozo
   turbulence  0.75
   octaves 5
   lambda 9
   color_map {
      [ 0.0  0.2  color rgbt < 0.4392, 0.7008, 0.7606, 0.0 >
                  color rgbt < 0.4,    0.6,    0.8,    0.0 > ]
      [ 0.2  0.5  color rgbt < 0.4     0.6     0.8,    0.0 >
                  color rgbt < 0.5,    0.5,    0.9,    0.0 > ]
      [ 0.5  0.7  color rgbt < 0.5,    0.5,    1.0,    0.0 >
                  color rgbt < 1.0,    1.0,    1.0,    0.0 > ]
      [ 0.7  1.0  color rgbt < 1.0,    1.0,    1.0,    0.0 >
                  color rgbt < 0.5,    0.5,    0.5,    0.0 > ] } //end map
        } // end pigment

// *******************************************************************
//                            Wood Textures
// *******************************************************************

//   DEFINE  variant for deco trim panels:
#declare T_Wood2_MBH =
texture { T_Wood2
          scale < 1, 1, 2 >
          rotate y*90 rotate x*80 
          finish {
             ambient 0.3 diffuse 0.5
             specular 0.5
             roughness 0.00075
             reflection 0.05
                  }//end finish
       } // end my wood 2

// **************************************************************

#declare EMBWood1 = 
texture {                              // Bottom wood-grain layer
    pigment {
        wood
        turbulence 0.5       // 0.05
        color_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
                  }//end map
        quick_color Yellow
            }//end pigment
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0.2
        phong_size 10
           }//end finish
    normal { bumps 0.05 }
}
texture {                              // top layer, adds small dark spots
    pigment {
        bozo
        color_map {
            [ 0.0 0.8  color rgbf < 1.00, 1.00, 1.00, 1.00 >
                       color rgbf < 1.00, 0.90, 0.80, 0.80 > ]
            [ 0.8 1.0  color rgbf < 1.00, 0.90, 0.80, 0.80 >
                       color rgbf < 0.30, 0.20, 0.10, 0.40 > ]
                  }//end map
    scale 0.25
    quick_color Yellow
            }//end pigment
        } // end texture 2nd layer

// **************************************************************

//   DEFINE   to simulate the seams between wooden boards
#declare Seams_Y =
texture {
   pigment {
      gradient y
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
        } // end Seams Y-axis

#declare Seams_X =
texture {
   pigment {
      gradient x
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
        } // end Seams X-axis

// **************************************************************

//   DEFINE RosewoodB  to fit 1x 0.5y 1z box scaled to 30x 1y 40z
#declare RosewoodB =
texture {
   pigment {
      bozo
      turbulence  0.4
      color_map {          // -0.05 b:    +0.2 r:
      [0.000, 0.256   color rgbf <0.404, 0.110, 0.028, 0.000>
                      color rgbf <0.431, 0.125, 0.030, 0.000>]
      [0.256, 0.393   color rgbf <0.431, 0.125, 0.030, 0.000>
                      color rgbf <0.444, 0.135, 0.039, 0.000>]
      [0.393, 0.581   color rgbf <0.444, 0.135, 0.039, 0.000>
                      color rgbf <0.445, 0.135, 0.025, 0.000>]
      [0.581, 0.826   color rgbf <0.445, 0.135, 0.025, 0.000>
                      color rgbf <0.460, 0.134, 0.032, 0.000>]
      [0.826, 0.983   color rgbf <0.460, 0.134, 0.032, 0.000>
                      color rgbf <0.431, 0.126, 0.136, 0.000>]
      [0.983, 1.000   color rgbf <0.431, 0.126, 0.136, 0.000>
                      color rgbf <0.404, 0.110, 0.028, 0.000>] } //end map
      scale < 0.15, 0.05, 0.5 >
      rotate z*3
      quick_color Brown
           } //end pigment
   finish {
      ambient 0.3
      diffuse 0.32
      reflection 0.08 } //end finish
        } // end texture layer 1
// Rosewood layer 2
texture {
   pigment {
      wood
      turbulence 0.4
      color_map {
         [ 0.000, 0.139  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.139, 0.148  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.148, 0.287  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.287, 0.443  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.443, 0.626  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.626, 0.635  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.635, 0.843  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.843, 1      color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ] }
      scale < 0.15, 0.05, 1 >
      rotate z*3
      quick_color Brown
           } //end pigment
   finish {
      ambient 0.25
      diffuse 0.25
      reflection 0.08 } //end finish
        } // end texture layer 2


// *******************************************************************
//                           METAL FINISHES
// *******************************************************************

#declare Metallic_Finish =
    finish {
        metallic
        ambient 0.1
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection 0.45
        brilliance 1.5
    }

// *******************************************************************
//                           METAL TEXTURES
// *******************************************************************

#declare Bright_Bronze  = 
texture {
    pigment { rgb <0.36, 0.28, 0.20> }
    finish { Metallic_Finish }
}

// *******************************************************************
// *******************************************************************

#version Tex_Home_Inc_Temp;

//********************************************************************
// Michael Brendan Hurley     ShadowDancer, LTD.      Fall-Winter 2000
//********************************************************************
