#ifdef(Woods_Inc_Temp)
// do nothing
#else
#declare Woods_Inc_Temp=version
#version 3.1

#ifdef(View_POV_Include_Stack)
#   debug "including woods_b.inc\n"
#end

#include "woodmaps.inc"

// ************************************************************************
//             Persistence of Vision Raytracer Version 3.0
//                        Basic wooden textures
//                    Edited from Woods.INC  by MBH
//                    for use with Our_House scenes
// ************************************************************************

//*************************************************************************
//                           WOODEN PIGMENTS
//*************************************************************************

#declare P_WoodGrain1A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}

#declare P_WoodGrain1B =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}

#declare P_WoodGrain2A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.15, .15, 1>
}

#declare P_WoodGrain2B =
pigment {
    wood  
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2
}

#declare P_WoodGrain5A =
pigment {
    wood  
    turbulence <0.04, 0.04, 0.1>
    octaves 4
    omega 1.25
    scale <0.15, .15, 1>
}

#declare P_WoodGrain5B =
pigment {
    wood  
    turbulence <0.025, 0.025, 0.1>
    octaves 4
    omega 1.3
    scale <0.30, .20, 1>
    translate <0.1, 0.1, 0.20>
}

#declare P_WoodGrain8A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}

#declare P_WoodGrain8B =
pigment {
    wood
    turbulence <0.04, 0.04, 1>
    octaves 4
    scale <0.05, 0.05, 1> * 0.66
}

#declare P_WoodGrain12A =
pigment {
    bozo
    turbulence 0.04
    lambda 2.5
    omega 0.1
    octaves 7
    scale <0.5, 0.05, 0.05>
}

#declare P_WoodGrain12B =
pigment {
    wood
    turbulence <0.1, 0.04, 1>
    scale <0.15, 0.5, 1>
//    translate <10, 0, 0>
    rotate x*2
}

#declare P_WoodGrain16A =
pigment {
    bozo
    colour_map { M_Wood16A }
    turbulence 0.04
    scale <0.02 0.02 1>
}

#declare P_WoodGrain16B =
pigment {
    wood
    colour_map { M_Wood16B }
    scale <0.075 0.075 1>
    turbulence 0.035
    rotate <-2, 2, 0>
}

// ************************************************************************
//                            WOOD TEXTURES
// ************************************************************************

// Dark brown
#declare T_Wood2   =
    texture { pigment { P_WoodGrain2A
                        color_map { M_Wood2A }
                        quick_color Firebrick } }
    texture { pigment { P_WoodGrain2B
                        color_map { M_Wood2B }
                        quick_color Firebrick } }

// ************************************************************************

#declare T_Wood2b =
texture { T_Wood2
          scale < .55, 1.1, 1 >
          finish {
               specular 0.1
               roughness 0.025
                }//end finish 
        } // end texture Wood 2b

// ************************************************************************

// Dark yellow with reddish overgrain
#declare T_Wood5   =         
    texture { pigment { P_WoodGrain5A
                        color_map { M_Wood5A }
                        quick_color Blue } }
    texture { pigment { P_WoodGrain5B
                        color_map { M_Wood5B }
                        quick_color Blue } }

// ************************************************************************

// Dark brown. Walnut?    
#declare T_Wood8   =
    texture { pigment { P_WoodGrain8A
                        color_map { M_Wood8A }
                        quick_color SteelBlue } }
    texture { pigment { P_WoodGrain8B
                        color_map { M_Wood8B }
                        quick_color SteelBlue } }

// ************************************************************************

// Another very dark brown.  Walnut-stained pine, perhaps?
#declare T_Wood12 = 
    texture {  pigment { P_WoodGrain12A color_map { M_Wood12A }
               quick_color Red } }
    texture {  pigment { P_WoodGrain12B color_map { M_Wood12B }
               quick_color Red } }

// ************************************************************************

// Medium brown
#declare T_Wood16 = 
    texture {  pigment { P_WoodGrain16A
                         color_map { M_Wood16A }
                         quick_color Maroon } }
    texture {  pigment { P_WoodGrain16B
                         color_map { M_Wood16B }
                         quick_color Maroon } }

// ************************************************************************

#declare T_Wood30 =
    texture {  pigment{ P_WoodGrain1A
                        color_map { M_Wood1A }
                        quick_color Blue } }
    texture {  pigment{ P_WoodGrain1B
                        color_map { M_Wood1B }
                        quick_color Blue } }

// ************************************************************************

#declare DMFWood2 =                    //Our House door
pigment {
    wood
    turbulence 0.03
    octaves 4
    scale < 0.05, 0.05, 1 >
    color_map {
        [ 0.0, 0.1 color rgb < 0.52, 0.37, 0.26 >
                   color rgb < 0.52, 0.37, 0.26 > ]
        [ 0.1, 0.9 color rgb < 0.52, 0.37, 0.26 >
                   color rgb < 0.42, 0.26, 0.15 > ]
        [ 0.9, 1.0 color rgb < 0.42, 0.26, 0.15 >
                   color rgb < 0.42, 0.26, 0.15 > ]
              }//end map
    quick_color Red
}

// ************************************************************************

// Looks like old desk oak if used correctly.
#declare DMFDarkOak = 
pigment {
    wood
    turbulence 0.7            // altered
    octaves 3
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0, 0.1 color rgb <0.60, 0.30, 0.18>
                  color rgb <0.60, 0.30, 0.18>]
        [0.1, 0.9 color rgb <0.60, 0.30, 0.18>
                  color rgb <0.30, 0.15, 0.09>]
        [0.9, 1.0 color rgb <0.30, 0.15, 0.09>
                  color rgb <0.30, 0.15, 0.09>]
              }//end map
    quick_color Violet
        } // end pigment

// ************************************************************************

#declare EMBWood1 = 
texture {                              // Bottom wood-grain layer
    pigment {
        wood
        turbulence 0.5       // 0.05
        color_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
                  }//end map
        quick_color Yellow
            }//end pigment
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0.2
        phong_size 10
           }//end finish
    normal { bumps 0.05 }
}
texture {                              // top layer, adds small dark spots
    pigment {
        bozo
        color_map {
            [ 0.0 0.8  color rgbf < 1.00, 1.00, 1.00, 1.00 >
                       color rgbf < 1.00, 0.90, 0.80, 0.80 > ]
            [ 0.8 1.0  color rgbf < 1.00, 0.90, 0.80, 0.80 >
                       color rgbf < 0.30, 0.20, 0.10, 0.40 > ]
                  }//end map
    scale 0.25
    quick_color Yellow
            }//end pigment
        } // end texture 2nd layer

// ************************************************************************

#declare EMBWood1_B =
texture {                              // Bottom wood-grain layer
    pigment {
        wood
        turbulence 0.25       // 0.05
        color_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.43, 0.33, 0.23>] //+10 from orig.
            [0.40 0.47  color rgb <0.43, 0.33, 0.23>
                        color rgb <0.70, 0.50, 0.30>] //+10 from original
            [0.47 1.00  color rgb <0.70, 0.50, 0.30>
                        color rgb <0.25, 0.15, 0.05>]
                  }//end map
        quick_color Yellow
            }//end pigment
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0.2
        phong_size 10
           }//end finish
    normal { bumps 0.05 }
} // end 1st layer EMBWood 1_B

texture {                              // top layer, adds small dark spots
    pigment {
        bozo
        color_map {
            [ 0.0 0.8  color rgbf < 0.90, 0.90, 0.90, 1.00 >
                       color rgbf < 0.90, 0.80, 0.70, 0.90 > ]
            [ 0.8 1.0  color rgbf < 0.90, 0.80, 0.70, 0.90 >
                       color rgbf < 0.30, 0.20, 0.10, 0.40 > ]
                  }//end map
    scale 0.25
    quick_color Yellow
            }//end pigment
        } // end texture 2nd layer EMB Wood 1_B

//*************************************************************************

//   DEFINE Seams Texture: to simulate the seams between wooden boards

#declare Seams_X =
texture {
   pigment {
      gradient x
      turbulence 0.0
      frequency 2
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
   scale 0.1                          // scaled to make 1 board per unit
//   scale 0.05                         // scaled to make 2 board per unit
        } // end Seams X-axis

// ***********************************************************************

//   DEFINE RosewoodB  to fit 1x 0.5y 1z box scaled to 30x 1y 20z

#declare RosewoodB = texture {
 pigment {
   bozo
   turbulence  0.4  // 0.04
   color_map {
      [0.000, 0.256   color rgbf <0.204, 0.110, 0.078, 0.000>
                      color rgbf <0.231, 0.125, 0.080, 0.000>]
      [0.256, 0.393   color rgbf <0.231, 0.125, 0.080, 0.000>
                      color rgbf <0.244, 0.135, 0.089, 0.000>]
      [0.393, 0.581   color rgbf <0.244, 0.135, 0.089, 0.000>
                      color rgbf <0.245, 0.135, 0.075, 0.000>]
      [0.581, 0.826   color rgbf <0.245, 0.135, 0.075, 0.000>
                      color rgbf <0.260, 0.134, 0.102, 0.000>]
      [0.826, 0.983   color rgbf <0.260, 0.134, 0.102, 0.000>
                      color rgbf <0.231, 0.126, 0.186, 0.000>]
      [0.983, 1.000   color rgbf <0.231, 0.126, 0.186, 0.000>
                      color rgbf <0.204, 0.110, 0.078, 0.000>]
             } //end map
   scale < 0.15, 0.05, 0.5 > //   scale <0.5, 0.5, 1>
   rotate z*3
   quick_color Yellow
 } //end pigment
 finish {
   ambient 0.3
   diffuse 0.6
   reflection 0.15
        } //end finish
} // end texture layer 1

// Rosewood layer 2
texture {
 pigment {
   wood
   turbulence 0.4
   color_map {
      [0.000, 0.139   color rgbf <0.545, 0.349, 0.247, 1.000>
                      color rgbf <0.000, 0.000, 0.000, 0.004>]
      [0.139, 0.148   color rgbf <0.000, 0.000, 0.000, 0.004>
                      color rgbf <0.000, 0.000, 0.000, 0.004>]
      [0.148, 0.287   color rgbf <0.000, 0.000, 0.000, 0.004>
                      color rgbf <0.545, 0.349, 0.247, 1.000>]
      [0.287, 0.443   color rgbf <0.545, 0.349, 0.247, 1.000>
                      color rgbf <0.545, 0.349, 0.247, 1.000>]
      [0.443, 0.626   color rgbf <0.545, 0.349, 0.247, 1.000>
                      color rgbf <0.000, 0.000, 0.000, 0.004>]
      [0.626, 0.635   color rgbf <0.000, 0.000, 0.000, 0.004>
                      color rgbf <0.000, 0.000, 0.000, 0.004>]
      [0.635, 0.843   color rgbf <0.000, 0.000, 0.000, 0.004>
                      color rgbf <0.545, 0.349, 0.247, 1.000>]
      [0.843, 1       color rgbf <0.545, 0.349, 0.247, 1.000>
                      color rgbf <0.545, 0.349, 0.247, 1.000>]
   }
   scale < 0.15, 0.05, 1 >
   rotate z*3
   quick_color Yellow
 }
 finish {
   ambient 0.3
   diffuse 0.6
   reflection 0.15
 }
}

// ************************************************************************

#version Woods_Inc_Temp
#end

// ************************************************************************

