// *******************************************************************
// O_HOME00.INC        for POV WIN 3.1g         Ver 1.0 Fall-Winter 99
//         Definitions of assorted basic objects and effects         
// for Final Draft of OUR_HOUSE                   Ver 4.0  Winter 1999
// *******************************************************************

// *******************************************************************
// *******************************************************************
// I.    DEFINE Includes, Constants and Conditionals:
// *******************************************************************

#version 3.1; 

#declare TestMode = true;
//#declare TestMode = false;

//#declare Seams = true;       // on
#declare Seams = false;      // off

//#declare Lights = true;      // night lights on
#declare Lights = false;     // day lights off

#declare Intensity = 2;

#include "brendan.inc"                 // universal scene objects

// **************************************************************
//                  The Dreaded Media Statements:
// **************************************************************
/*
   // Add media: media01.pov  : total darkness
   media {
     intervals  10
     scattering { 3, rgb 0.03 }
     samples 1, 10         
     confidence 0.9999
     variance 1/1000
     ratio 0.9 } // end media
// visible cylinders of light, but still very dark elsewhere
media {
   scattering { 1. 0.1 extinction 0.1 }
   samples 20, 200
   intervals 10
     confidence 0.9999
     variance 1/1000
     ratio 0.9
      } // end media
// visible exter. cylinders of light, but very dim:
// way too bright interior:
media {
   scattering { 1, 0.01 extinction 0.75 }
   samples 20, 200
   intervals 10
     confidence 0.9999
     variance 1/1000
     ratio 0.9
      } // end media
// dim the media down from way too bright, interior shot, night:
media {
   scattering { 1, 0.01 extinction 0.33 }
   samples 10, 15 // 20, 200
   intervals 10
     confidence 0.9999
     variance 1/1000
     ratio 0.9
      } // end media
*/

// *******************************************************************
// *******************************************************************
// II.     DEFINE Structural Components
// *******************************************************************
//    A.   Frames: Single: Wall:
// *******************************************************************

//   DEFINE   a frame 10x / 10y units
#declare Frame_A =
union {
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate < -5,  0, 0 > }
   object { CubeY1
            scale <   0.5, 10.0, 0.5 >  translate <  5,  0, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0,  5, 0 > }
   object { CubeX1
            scale < 10.25,  0.5, 0.5 >  translate <  0, -5, 0 > }
      } // end Frame A

// **************************************************************

//   DEFINE   a half-height frame 10x 5y units
#declare Frame_B =
union {
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                         
            scale <  0.5, 5, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1                                        
            scale < 10.25, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame B

// **************************************************************

//   DEFINE   a quarter-height frame 10x 2.5y units
#declare Frame_C =
union {
   object { CubeY1                                         
            scale < 0.5, 2.75, 0.5 >  translate < -5, 0, 0 > }
   object { CubeY1                                          
            scale < 0.5, 2.75, 0.5 >  translate <  5, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame C

// **************************************************************

//   DEFINE   half-wide frame unit 5x 10y
#declare Frame_D =
union {
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 10, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  5, 0 > }
      } // end Frame D

// *************************************************************

//   DEFINE   a 5x 5y frame
#declare Frame_E =
union {
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate < -2.5, 0, 0 > }
   object { CubeY1
            scale < 0.5, 5.25, 0.5 >  translate <  2.5, 0, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0,  2.5, 0 > }
   object { CubeX1
            scale < 5, 0.5, 0.5 >  translate < 0, -2.5, 0 > }
      } // end Frame E

// **************************************************************

//   DEFINE   a quarter-height 5x 2.5y frame:
#declare Frame_F =
union {
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate < -2.5, 0, 0 > }            
   object { CubeY1                                         
            scale < 0.5, 2.5, 0.5 >  translate <  2.5, 0, 0 > }            
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0,  1.25, 0 > }
   object { CubeX1                                        
            scale < 5.25, 0.5, 0.5 >  translate < 0, -1.25, 0 > }
      } // end Frame F

// *******************************************************************
//    B.   Frames: Single: Window:
// *******************************************************************

//    DEFINE  an inset frame for 3x 4y window: like Window_1
#declare Window_Frame_1 =
union {
   object { CubeY1                                        
            scale < 0.76, 10, 0.75 >  translate < -1.76, 0, 0 > }
   object { CubeY1                                       
            scale < 0.76, 10, 0.75 >  translate <  1.76, 0, 0 > }
   object { CubeX1                                        
            scale <   10, 0.75, 0.75 >  translate < 0,  2, 0 > }
   object { CubeX1                                        
            scale < 4.25, 0.75, 0.75 >  translate < 0, -2, 0 > }
   object { Frame_A } // end frame
   #if ( TestMode )
      texture { Red_Tex }
   #else
      texture { T_Wood2 }
   #end
      }//end window frame 1

// **************************************************************

//    DEFINE  an inset frame for Window Panel 2:
#declare Window_Frame_2 =
union {
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate < -3.45,      0, 0 > }
   object { CubeY1                                        
            scale < 0.5,  10, 0.5 >  translate <  3.45,      0, 0 > }
   object { CubeX1                                        
            scale <  10, 0.5, 0.5 >  translate <     0,   3.15, 0 > }
   object { CubeX1                                        
            scale <   7, 0.5, 0.5 >  translate <     0, -1.125, 0 > }
   object { Frame_A } // end frame
   #if ( TestMode )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      }//end window frame 2

// **************************************************************

//    DEFINE  a round post frame for Pane_Square_1:
#declare Frame_Square_1 =
union {
   object { PostY1  scale < 0.5,    2, 0.5 >  translate < -1,  0, 0 > }
   object { PostY1  scale < 0.5,    2, 0.5 >  translate <  1,  0, 0 > }
   object { PostX1  scale < 2.25, 0.5, 0.5 >  translate <  0,  1, 0 > }
   object { PostX1  scale < 2.25, 0.5, 0.5 >  translate <  0, -1, 0 > }
      } // end frame square one

// **************************************************************

//    DEFINE  a round post frame for ... :
#declare Frame_Diamond_1 =
union {
  object { PostY1
           scale <0.5, 2.25, 0.5> rotate z*45  translate <-0.75,-0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*45  translate < 0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate <-0.75, 0.75,0> }
  object { PostY1 
           scale <0.5, 2.25, 0.5> rotate z*-45 translate < 0.75,-0.75,0> }
      } // end diamond frame 1

// **************************************************************

//    DEFINE  frame for stained glass window: 
//            diamond pattern: 6x 10y: matches SG_Panel_1
#declare SG_Frame_1 =
union {
   object { PostX1
            scale < 3, 0.5, 0.5 >
            translate < 0, 6, 0 > }         // end top post
   object { PostY1
            scale < 0.5, 2, 0.5 >
            rotate z*45            
            translate < -0.75, 5.25, 0 > }  // end uul post
   object { PostY1
            scale < 0.5, 2, 0.5 >
            rotate z*-45            
            translate < 0.75, 5.25, 0 > }   // end uur post
   object { PostY1
            scale < 0.5, 2, 0.5 >
            rotate z*-45            
            translate < -0.75, -5.25, 0 > } // end ull post
   object { PostY1
            scale < 0.5, 2, 0.5 >
            rotate z*45            
            translate < 0.75, -5.25, 0 > }  // end ulr post
   object { PostY1
            scale < 0.5, 6, 0.5 >
            translate < -1.5, 3, 0 > }      // end ul post
   object { PostY1
            scale < 0.5, 6, 0.5 >
            translate < 1.5, 3, 0 > }       // end ur post
   object { PostY1
            scale < 0.5, 6, 0.5 >
            translate < -1.5, -3, 0 > }     // end ll post
   object { PostY1
            scale < 0.5, 6, 0.5 >
            translate < 1.5, -3, 0 > }      // end lr post
   object { PostX1
            scale < 3, 0.5, 0.5 >
            translate < 0, -6, 0 > }        // end bottom post
   object { Frame_Square_1
            rotate z*45
            translate y*3 }            // end top square frame
   object { Frame_Square_1
            rotate z*45 }              // end middle square frame
   object { Frame_Square_1
            rotate z*45
            translate y*-3 }           // end bottom square frame
   texture { Gray25_Tex }
      } // end stained glass frame 1

// **************************************************************

//    DEFINE  frame for stained glass window: 
//            square pattern: 5x 5y: matches SG_Panel_2
#declare SG_Frame_2 =
union {
   // second above center row:
   object { Frame_Square_1  translate < -4, 4, 0 > }
   object { Frame_Square_1  translate < -2, 4, 0 > }
   object { Frame_Square_1  translate <  0, 4, 0 > }
   object { Frame_Square_1  translate <  2, 4, 0 > }
   object { Frame_Square_1  translate <  4, 4, 0 > }
   // first above center row:
   object { Frame_Square_1  translate < -4, 2, 0 > }
   object { Frame_Square_1  translate < -2, 2, 0 > }
   object { Frame_Square_1  translate <  0, 2, 0 > }
   object { Frame_Square_1  translate <  2, 2, 0 > }
   object { Frame_Square_1  translate <  4, 2, 0 > }
   // center row:
   object { Frame_Square_1  translate < -4, 0, 0 > }
   object { Frame_Square_1  translate < -2, 0, 0 > }
   object { Frame_Square_1 }           
   object { Frame_Square_1  translate <  2, 0, 0 > }
   object { Frame_Square_1  translate <  4, 0, 0 > }
   // first below center row:
   object { Frame_Square_1  translate < -4, -2, 0 > }
   object { Frame_Square_1  translate < -2, -2, 0 > }
   object { Frame_Square_1  translate <  0, -2, 0 > }
   object { Frame_Square_1  translate <  2, -2, 0 > }
   object { Frame_Square_1  translate <  4, -2, 0 > }
   texture { Gray25_Tex }
      } // end stained glass frame 2

// **************************************************************
 
//    DEFINE  frame for stained glass window: 
//            diamond pattern: 5x 5y: matches SG_Panel_3
#declare SG_Frame_3 =
union {
   object { Frame_Diamond_1  translate < -3.0,  3.0, 0 > }//ul
   object { Frame_Diamond_1  translate <  0.0,  3.0, 0 > }//uc
   object { Frame_Diamond_1  translate <  3.0,  3.0, 0 > }//ur
   object { Frame_Diamond_1  translate < -3.0,  0.0, 0 > }//lf1
   object { Frame_Diamond_1  translate <  0.0,  0.0, 0 > }//cntr
   object { Frame_Diamond_1  translate <  3.0,  0.0, 0 > }//rt1
   object { Frame_Diamond_1  translate < -3.0, -3.0, 0 > }//ll
   object { Frame_Diamond_1  translate <  0.0, -3.0, 0 > }//lc
   object { Frame_Diamond_1  translate <  3.0, -3.0, 0 > }//lr
   texture { Gray25_Tex }
      } // end glass frame 3 

// **************************************************************
 
//    DEFINE  frame for stained glass window: 
//            diamond pattern: 5x 5y: matches SG_Panel_4
#declare SG_Frame_4 =
union {
   // top row:
   object { Frame_Diamond_1  translate < -3.0,  3.0, 0 > }//ul
   object { Frame_Diamond_1  translate <  0.0,  3.0, 0 > }//uc
   object { Frame_Diamond_1  translate <  3.0,  3.0, 0 > }//ur
   object { PostY1
            scale <0.5, 2.25, 0.5> rotate z*45  translate <-2.0,3.5,0> }
   object { PostY1
            scale <0.5, 2.25, 0.5> rotate z*-45 translate < 2.0,3.5,0> }
   // center diamond:
   object { Frame_Diamond_1  translate < -3.0,  0.0, 0 > }//lf 2
   object { Frame_Diamond_1  translate < -1.5,  0.0, 0 > }//lf 1
   object { Frame_Diamond_1  translate <  0.0,  1.5, 0 > }//mid uc
   object { Frame_Diamond_1  translate <  0.0,  0.0, 0 > }//cntr
   object { Frame_Diamond_1  translate <  0.0, -1.5, 0 > }//mid lc
   object { Frame_Diamond_1  translate <  1.5,  0.0, 0 > }//rt 1
   object { Frame_Diamond_1  translate <  3.0,  0.0, 0 > }//rt 2
   // bottom row:
   object { Frame_Diamond_1  translate < -3.0, -3.0, 0 > }//ll
   object { Frame_Diamond_1  translate <  0.0, -3.0, 0 > }//lc
   object { Frame_Diamond_1  translate <  3.0, -3.0, 0 > }//lr
   object { PostY1
            scale <0.5, 2.25, 0.5> rotate z*45  translate < 2.0, -3.5, 0> }
   object { PostY1
            scale <0.5, 2.25, 0.5> rotate z*-45 translate <-2.0, -3.5, 0> }
   texture { Gray50_Tex }
      } // end glass frame 4

// **************************************************************

//    DEFINE  frame for stained glass window: 
//            square pattern: 5x 5y: matches SG_Panel_5
#declare SG_Frame_5 =
union {
   // second above center row:
   object { Frame_Square_1  translate < -4, 4, 0 > }
   object { Frame_Square_1  translate < -2, 4, 0 > }
   object { Frame_Square_1  translate <  0, 4, 0 > }
   object { Frame_Square_1  translate <  2, 4, 0 > }
   object { Frame_Square_1  translate <  4, 4, 0 > }
   // first above center row:
   object { Frame_Square_1  translate < -4, 2, 0 > }
   object { Frame_Square_1  translate < -2, 2, 0 > }
   object { Frame_Square_1  translate <  0, 2, 0 > }
   object { Frame_Square_1  translate <  2, 2, 0 > }
   object { Frame_Square_1  translate <  4, 2, 0 > }
   // center row:
   object { Frame_Square_1  translate < -4, 0, 0 > }
   object { Frame_Square_1  translate < -2, 0, 0 > }
   object { Frame_Square_1 }           
   object { Frame_Square_1  translate <  2, 0, 0 > }
   object { Frame_Square_1  translate <  4, 0, 0 > }
   // first below center row:
   object { Frame_Square_1  translate < -4, -2, 0 > }
   object { Frame_Square_1  translate < -2, -2, 0 > }
   object { Frame_Square_1  translate <  0, -2, 0 > }
   object { Frame_Square_1  translate <  2, -2, 0 > }
   object { Frame_Square_1  translate <  4, -2, 0 > }
   // second below center row:
   object { Frame_Square_1  translate < -4, -4, 0 > }
   object { Frame_Square_1  translate < -2, -4, 0 > }
   object { Frame_Square_1  translate <  0, -4, 0 > }
   object { Frame_Square_1  translate <  2, -4, 0 > }
   object { Frame_Square_1  translate <  4, -4, 0 > }
   texture { Gray25_Tex }
      } // end stained glass frame 5

// *******************************************************************
//    C.   Panels: Single: Wall:
// *******************************************************************

//    DEFINE  a 10x 10y 1z panel:
#declare Panel_A =
object { UnitBox  scale < 5, 5, 0.5 > } // end panel a

// **************************************************************

//    DEFINE  a 10x 5y 1z panel:
#declare Panel_B =
object { UnitBox  scale < 5, 2.5, 0.5 > } // end panel b

// **************************************************************

//    DEFINE  a 10x 2.5y 1z panel:
#declare Panel_C =
object { UnitBox  scale < 5, 1.25, 0.5 > } // end panel c

// **************************************************************

//    DEFINE  a 5x 10y 1z panel:
#declare Panel_D =
object { UnitBox  scale < 2.5, 5, 0.5 > } // end panel d

// **************************************************************

//    DEFINE  a 5x 5y 1z panel:
#declare Panel_E =
object { UnitBox  scale < 2.5, 2.5, 0.5 > } // end panel e

// **************************************************************

//    DEFINE  a 5x 2.5y 1z panel:
#declare Panel_F =
object { UnitBox  scale < 2.5, 1.25, 0.25 > } // end panel f

// *******************************************************************
//    D.   Panels: Single: windows:
// *******************************************************************

//   DEFINE   A beveled-edged square box: a window pane:
#declare Pane_Square_1 =
intersection {
   object { Cube  scale < 1, 1, 0.1 > }// 2"x2"x2/10"
   //beveled edges
   plane { y, 0                        // top front x edge
           rotate x*-45
           translate y*1
           hollow on } //end plane a
   plane { y, 0                        // top rear x edge
           rotate x*45
           translate y*1
           hollow on } //end plane b
   plane { y, 0                        // bottom front x edge
           rotate x*-135
           translate y*-1
           hollow on } //end plane c
   plane { y, 0                        // bottom rear x edge
           rotate x*135
           translate y*-1
           hollow on } //end plane d
   plane { x, 0                        // front left y edge
           rotate y*135
           translate x*-1
           hollow on } //end plane e
   plane { x, 0                        // rear left y edge
           rotate y*-135
           translate x*-1
           hollow on } //end plane f
   plane { x, 0                        // front right y edge
           rotate y*45
           translate x*1
           hollow on } //end plane g
   plane { x, 0                        // rear right y edge
           rotate y*-45
           translate x*1
           hollow on } //end plane h
             } // end square window pane

// **************************************************************

//   DEFINE   a 1-unit square window glass pane:
#declare Pane_Square_2 =
object { UnitBox
         scale < 0.5, 0.5, 0.01 >
         #if ( TestMode )
            texture { White_Tex }
         #else
            texture { T_Glass1 }
         #end
       } // end square glass pane

// **************************************************************

//   DEFINE   A beveled-edged square box: clipped into triangle
//            ---------
//             \      |
//              \     |
//               \    |
//                \   |
//                 \  |
//                  \ |
//                   \|

#declare Pane_Tri_1 =
intersection {
   object { Pane_Square_1 }
   plane { y, 0            
           rotate z*135
           hollow on } //end plane a
             } // end  triangle pane 1

// **************************************************************

//  DEFINE  triangle pane rotated point up:non-beveled edge down
#declare Tri_Up =
object { Pane_Tri_1  rotate z*45 } //end tri up

// **************************************************************

//  DEFINE  triangle pane rotated point down:non-beveled edge up
#declare Tri_Down =
object { Pane_Tri_1  rotate z*-135 } //end tri down

// **************************************************************

//  DEFINE  triangle pane rotated point left:non-beveled edge right
#declare Tri_Left =
object { Pane_Tri_1  rotate z*135 } //end tri left

// **************************************************************

//  DEFINE  triangle pane rotated point right:non-beveled edge left
#declare Tri_Right =
object { Pane_Tri_1  rotate z*-45  } //end tri right

// *******************************************************************
//    E.   Frames: Compound: Wall:
// *******************************************************************

//  DEFINE   a 3-panel, 30x 10y frame:
#declare Frame_30x10 =
union {
   object { Frame_A  translate <   0, 0, 0 > }
   object { Frame_A  translate <  10, 0, 0 > }
   object { Frame_A  translate < -10, 0, 0 > }
      } // end union wall frame 30x10

// **************************************************************

//  DEFINE   a 4-panel, 40x 10y frame:
#declare Frame_40x10 =
union {
   object { Frame_A  translate <   5, 0, 0 > }
   object { Frame_A  translate <  15, 0, 0 > }
   object { Frame_A  translate <  -5, 0, 0 > }
   object { Frame_A  translate < -15, 0, 0 > }
      } // end union wall frame 40x10

// **************************************************************

//  DEFINE   a 3-panel, 30x 5y frame:
#declare Frame_30x05 =
union {
   object { Frame_B  translate <   0, 0, 0 > }
   object { Frame_B  translate <  10, 0, 0 > }
   object { Frame_B  translate < -10, 0, 0 > }
      } // end union wall frame 30x5

// **************************************************************

//  DEFINE   a 4-panel, 40x 5y frame:
#declare Frame_40x05 =
union {
   object { Frame_B  translate <   5, 0, 0 > }
   object { Frame_B  translate <  15, 0, 0 > }
   object { Frame_B  translate <  -5, 0, 0 > }
   object { Frame_B  translate < -15, 0, 0 > }
      } // end union wall frame 40x5

// *******************************************************************
//    F.   Frames: Compound: Windows:
// *******************************************************************
//                 none...
// *******************************************************************
//    G.   Panels: Compound: Wall:
// *******************************************************************

// ROUNDBOX.INC for POV Version 3.0 and above
// by Philip Cowley (philip.cowley@totem.co.uk) 13/07/97
//   DEFINE  an art deco style panel: 10x 2y 2z:
#declare D_Panel_1 =
object {
   #declare RB_P1 = <  5,  1.01,  1.01 >;
   #declare RB_P2 = < -5, -1.01, -1.01 >;
   #declare RB_Thickness = 2;      //Assumes 1 if not defined
   #declare RB_Solid = 0;          //Assumes "On" if not defined
   #include "roundbox.inc"
       } //end union deco panel 1

// **************************************************************

//   DEFINE  an art deco style trim panel: 10x 2y 0.5z:
#declare D_Panel_2 =
union {
   object { D_Panel_1
            scale < 1, 1, 0.25 >
          }// end lower 
   object { D_Panel_1
            scale < 0.75, 0.75, 0.25 >
            translate < 0, 1, 0 > 
          }// end middle
   object { D_Panel_1
            scale < 0.5, 0.5, 0.25 >
            translate < 0, 1.5, 0 > 
          }// end upper
      } // end union deco panel 2
 
// *******************************************************************
//    H.   Panels: compound: windows:
// *******************************************************************

//    DEFINE  a standard 3x 4y window panel:
#declare Window_Panel_1 =
union {
   object { Pane_Square_2  scale < 3, 4, 1 > }
   object { Frame_E        scale < 0.65, 0.75, 1 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // window frame
   // wood panels:
   union {
   object { UnitBox  scale <2.0,1.5,0.1>  translate <   0, 3.5,0> }  //uc
   object { UnitBox  scale <1.5,1.5,0.1>  translate <-3.5, 3.5,0> }  //ul
   object { UnitBox  scale <1.5,1.5,0.1>  translate < 3.5, 3.5,0> }  //ur
   object { UnitBox scale <1.5,3.5,0.1> translate <-3.5,-1.5,0> }    //ll
   object { UnitBox scale <1.5,3.5,0.1> translate < 3.5,-1.5,0> }    //lr
   object { UnitBox scale <2.0,1.5,0.1> translate <   0,-3.5,0> }    //lc
   #if ( TestMode )
      texture { Green_Tex }
   #else
      texture { EMBWood1
                scale < 9, 0.6, 1 >  }//end textr
      finish { ambient 0.4  diffuse 0.6 }//end finish
      #if ( Seams )
         texture { Seams_Y  scale 0.5 }
      #end 
    #end      
         }// end union wood panels
      }//end union window panel 1

// **************************************************************

//    DEFINE  a standard 6x 4y window panel:
#declare Window_Panel_2 =
union {
   object { Pane_Square_2  scale < 6, 4, 1 > translate y*1 }
   object { Frame_E
            scale < 1.25, 0.75, 1 >
            translate y*1
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // frame
   // wood panels:
   union {
     object { PostX1 scale < 10, 3.5, 0.5 > translate < 0,  4, 0 > }//top
     object { PostX1 scale < 10,   8, 0.5 > translate < 0, -3, 0 > }//bot
     object { PostY1 scale <  3,   8, 0.5 > translate < -4.25, -1, 0 > }//l
     object { PostY1 scale <  3,   8, 0.5 > translate <  4.25, -1, 0 > }//r
      #if ( TestMode )
         texture { Green_Tex }
      #else
         texture { EMBWood1
                   scale < 9, 0.6, 1 >  }//end textr
         finish { ambient 0.4  diffuse 0.6 }//end finish
         #if ( Seams )
            texture { Seams_Y  scale 0.5 }
         #end 
       #end      
         }// end union wood panels
      }//end window panel 2

// **************************************************************

//    DEFINE  standard wood panels for a 5x 5y window:
#declare Window_Panel_3 =
union {
   // wood panels:
   union {
     object { CubeX1 
              scale < 10, 3.00, 0.75 >  translate < 0,  4.25, 0 > } // top
     object { CubeX1 
              scale < 10, 6.50, 0.75 >  translate < 0, -3.25, 0 > } // bot
     object { CubeY1
              scale < 5.125, 5.25, 0.75 >  translate < -3.75, 1, 0 > } // left
     object { CubeY1 
              scale < 5.125, 5.25, 0.75 >  translate <  3.75, 1, 0 > } // right
     #if ( TestMode )
        texture { Coral_Tex }
     #else
        texture { EMBWood1
                  scale < 9, 0.6, 1 >  }//end textr
        finish { ambient 0.4  diffuse 0.6 }//end finish
     #end
     #if ( Seams )
        texture { Seams_Y  scale 0.5 }
     #end 
         }// end union wood panels
   union {
     object { CubeY1
              scale < 1, 10, 1 >  translate < -2.75, 0, 0 > } // left
     object { CubeY1 
              scale < 1, 10, 1 >  translate <  2.75, 0, 0 > } // right
     object { CubeX1 
              scale < 10, 1, 1 >  translate < 0, 3.8, 0 > } // top
     #if ( TestMode )
        texture { Brown_Tex }
     #else
        texture { T_Wood2 }
     #end
         }// end union inner frames
      }//end window panel 3

// **************************************************************

//   DEFINE   a stained glass panel:
//            diamond pattern: 6x 10y: matches SG_Frame_1
#declare SG_Panel_1 =
union {
   // upper sides:
   union {
      object { Tri_Down  translate < 0, 6, 0 > }      // end uc tri 
      object { Tri_Left  translate < 1.5, 4.5, 0 > }  // end uur tri 1
      object { Tri_Left  translate < 1.5, 1.5, 0 > }  // end lur tri 2
      object { Tri_Right translate < -1.5, 4.5, 0 > } // end uul tri 1
      object { Tri_Right translate < -1.5, 1.5, 0 > } // end lul tri 2
      #if ( TestMode )
         texture { Blue_Tex }
      #else
         texture { T_Glass1 }
      #end 
         }// end upper panel union
   // upper center panel:
   object { Pane_Square_1
            rotate z*45
            translate y*3
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end 
          }//end pane 1
   // center center panel:             // centered on <0,0,0>
   object { Pane_Square_1
            rotate z*45
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Green_Glass }
            #end 
          }//end pane 1
   // lower center panel:
   object { Pane_Square_1
            rotate z*45
            translate y*-3
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end 
          }//end pane 1
   // lower sides:
   union {
      object { Tri_Left  translate < 1.5, -4.5, 0 > } // end ulr tri 1
      object { Tri_Left  translate < 1.5, -1.5, 0 > } // end llr tri 2
      object { Tri_Right translate < -1.5, -4.5, 0 > }// end ull tri 1
      object { Tri_Right translate < -1.5, -1.5, 0 > }// end lll tri 2
      object { Tri_Up    translate < 0, -6, 0 > }     // end lc tri
      #if ( TestMode )
         texture { Blue_Tex }
      #else
         texture { T_Glass1 }
      #end 
         }// end lower panel union
      } // end Stained Glass Panel 1

// **************************************************************

//   DEFINE  rectangular glass panels for SG_Frame_2
#declare SG_Panel_2 =
union {
   // far left column:
   #declare Count = 1;
   #declare XSpot = -4;
   #declare YSpot = 4;
   #while ( Count < 4.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               texture { T_Glass1 } } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid left column:
   #declare Count = 1;
   #declare XSpot = -2;
   #declare YSpot = 4;
   #while ( Count < 4.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               texture { T_Ruby_Glass } } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // center column:
   #declare Count = 1;
   #declare XSpot = 0;
   #declare YSpot = 4;
   #while ( Count < 4.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( Count = 2 )
                  texture { T_Green_Glass }
               #else
                  texture { T_Glass1 }
               #end 
               #if ( Count = 3 )
                  texture { T_Green_Glass }
               #else
                  texture { T_Glass1 }
               #end 
             } // end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid right column:
   #declare Count = 1;
   #declare XSpot = 2;
   #declare YSpot = 4;
   #while ( Count < 4.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               texture { T_Ruby_Glass } } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // far right column:
   #declare Count = 1;
   #declare XSpot = 4;
   #declare YSpot = 4;
   #while ( Count < 4.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               texture { T_Glass1 } }
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
      } // end SG panel 2

// **************************************************************

//   DEFINE  diamond glass panels for SG_Frame_3
#declare SG_Panel_3 =
union {
   //top row:
   object { Pane_Square_1              // upper left
            rotate z*45
            translate < -3, 3, 0 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // upper center
            rotate z*45
            translate y*3
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // upper right 
            rotate z*45
            translate < 3, 3, 0 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   // center row:
   object { Pane_Square_1              // left center
            rotate z*45
            translate < -3, 0, 0 >
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Green_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // center center: <0,0,0>
            rotate z*45
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Green_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // right center
            rotate z*45
            translate < 3, 0, 0 >
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Green_Glass }
            #end } //end pane 1
   // bottom row:
   object { Pane_Square_1              // lower left:  
            rotate z*45
            translate < -3, -3, 0 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // lower center
            rotate z*45
            translate y*-3
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   object { Pane_Square_1              // lower right 
            rotate z*45
            translate < 3, -3, 0 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Ruby_Glass }
            #end }//end pane 1
   // upper middle:
   object { Pane_Square_1              // up left
            rotate z*45
            translate < -1.5, 1.5, 0 >
            #if ( TestMode )
               texture { Blue_Tex }
            #else
               texture { T_Glass1 }
            #end }//end pane 1
   object { Pane_Square_1              // up right 
            rotate z*45
            translate < 1.5, 1.5, 0 >
            #if ( TestMode )
               texture { Blue_Tex }
            #else
               texture { T_Glass1 }
            #end }//end pane 1
   // lower middle:
   object { Pane_Square_1              // low left
            rotate z*45
            translate < -1.5, -1.5, 0 >
            #if ( TestMode )
               texture { Blue_Tex }
            #else
               texture { T_Glass1 }
            #end }//end pane 1
   object { Pane_Square_1              // low right 
            rotate z*45
            translate < 1.5, -1.5, 0 >
            #if ( TestMode )
               texture { Blue_Tex }
            #else
               texture { T_Glass1 }
            #end }//end pane 1
   // tri's on 4 edges:
   union {
      object { Tri_Right  translate < -4.5, -1.5, 0 > }// end ll 
      object { Tri_Right  translate < -4.5,  1.5, 0 > }// end ul 
      object { Tri_Left   translate <  4.5, -1.5, 0 > }// end lr 
      object { Tri_Left   translate <  4.5,  1.5, 0 > }// end ur 
      object { Tri_Down   translate < -1.5,  4.5, 0 > }// end ul 
      object { Tri_Down   translate <  1.5,  4.5, 0 > }// end ur 
      object { Tri_Up     translate < -1.5, -4.5, 0 > }// end ll 
      object { Tri_Up     translate <  1.5, -4.5, 0 > }// end lr 
      #if ( TestMode )
         texture { Magenta_Tex }
      #else
         texture { T_Ruby_Glass }
      #end
         } // end union of side tri's
   // 4 corners:
   union {
      object { Pane_Tri_1
               rotate z*90
               translate < -3.75,  3.75, 0 > }// end ul corner
      object { Pane_Tri_1
               translate <  3.75,  3.75, 0 > }// end ur corner
      object { Pane_Tri_1
               rotate z*180
               translate < -3.75, -3.75, 0 > }// end ll corner 
      object { Pane_Tri_1
               rotate z*-90
               translate <  3.75, -3.75, 0 > }// end lr corner
      #if ( TestMode )
         texture { Black_Tex }
      #else
         texture { T_Wood5 }
      #end
         } // end union corners
      }//end stained glass panel 3

// **************************************************************

//   DEFINE  diamond shaped glass panels for SG_Frame_4
#declare SG_Panel_4 =
union {
   // tri's on 4 edges:
   union {
      object { Tri_Right  translate < -4.5, -1.5, 0 > }// end ll 
      object { Tri_Right  translate < -4.5,  1.5, 0 > }// end ul 
      object { Tri_Left   translate <  4.5, -1.5, 0 > }// end lr 
      object { Tri_Left   translate <  4.5,  1.5, 0 > }// end ur 
      object { Tri_Down   translate < -1.5,  4.5, 0 > }// end ul 
      object { Tri_Down   translate <  1.5,  4.5, 0 > }// end ur 
      object { Tri_Up     translate < -1.5, -4.5, 0 > }// end ll 
      object { Tri_Up     translate <  1.5, -4.5, 0 > }// end lr 
      #if ( TestMode )
         texture { Magenta_Tex }
      #else
         texture { T_Ruby_Glass }
      #end
         } // end union of side tri's
   // 4 corners:
   union {
      object { Pane_Tri_1
               rotate z*90
               translate < -3.75,  3.75, 0 > }// end ul corner
      object { Pane_Tri_1
               translate <  3.75,  3.75, 0 > }// end ur corner
      object { Pane_Tri_1
               rotate z*180
               translate < -3.75, -3.75, 0 > }// end ll corner 
      object { Pane_Tri_1
               rotate z*-90
               translate <  3.75, -3.75, 0 > }// end lr corner
      #if ( TestMode )
         texture { Black_Tex }
      #else
         texture { T_Wood5 }
      #end
         } // end union corners
   // diamonds around the sides:
   union {
      object { Pane_Square_1              // top left
               rotate z*45
               translate < -3, 3, 0 >
             }//end pane 1
      object { Pane_Square_1              // top center
               rotate z*45
               translate < 0, 3, 0 >
             }//end pane 1
      object { Pane_Square_1              // top right
               rotate z*45
               translate < 3, 3, 0 >
             }//end pane 1
      object { Pane_Square_1              // bottom left
               rotate z*45
               translate < -3, -3, 0 >
             }//end pane 1
      object { Pane_Square_1              // bottom center
               rotate z*45
               translate < 0, -3, 0 >
             }//end pane 1
      object { Pane_Square_1              // bottom right
               rotate z*45
               translate < 3, -3, 0 >
             }//end pane 1
      #if ( TestMode )
         texture { Red_Tex }
      #else
         texture { T_Ruby_Glass }
      #end
         } // end union red glass panels
   // blue glass center square:
   union {
      object { Pane_Square_1 
               rotate z*45
               translate < -1.5, 0, 0 > }//end cl 
      object { Pane_Square_1
               rotate z*45
               translate < 0, 1.5, 0 >  }//end cu 
      // center: <0,0,0>: no pane needed:
      object { Pane_Square_1
               rotate z*45
               translate < 0, -1.5, 0 > } //end cd
      object { Pane_Square_1            
               rotate z*45
               translate < 1.5, 0, 0 >  }//end cr
      #if ( TestMode )
         texture { Blue_Tex }
      #else
         texture { T_Blue_Glass }
      #end
         } // end union blue glass 
      } //end stained glass panel 4

// **************************************************************

//   DEFINE  rectangular glass panels for SG_Frame_5
#declare SG_Panel_5 =
union {
   // far left column:
   #declare Count = 1;
   #declare XSpot = -4;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( TestMode )
                  texture { White_Tex }
               #else
                  texture { T_Glass1 } 
               #end
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid left column:
   #declare Count = 1;
   #declare XSpot = -2;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( TestMode )
                  texture { Blue_Tex }
               #else
                  texture { T_Blue_Glass }
               #end
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // center column:
   #declare Count = 1;
   #declare XSpot = 0;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( Count = 1 )
                  texture { T_Green_Glass }
               #else
                  texture { T_Glass1 }
               #end 
               #if ( Count = 3 )
                  texture { T_Green_Glass }
               #else
                  texture { T_Glass1 }
               #end 
               #if ( Count = 5 )
                  texture { T_Green_Glass }
               #else
                  texture { T_Glass1 }
               #end 
             } // end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid right column:
   #declare Count = 1;
   #declare XSpot = 2;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( TestMode )
                  texture { Blue_Tex }
               #else
                  texture { T_Blue_Glass }
               #end
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // far right column:
   #declare Count = 1;
   #declare XSpot = 4;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
               #if ( TestMode )
                  texture { White_Tex }
               #else
                  texture { T_Glass1 }
               #end
             }// end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
      } // end SG panel 5

// **************************************************************

//   DEFINE  square clear glass panels for SG_Frame_6
#declare SG_Panel_6 =
union {
   // far left column:
   #declare Count = 1;
   #declare XSpot = -4;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid left column:
   #declare Count = 1;
   #declare XSpot = -2;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // center column:
   #declare Count = 1;
   #declare XSpot = 0;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
             } // end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // mid right column:
   #declare Count = 1;
   #declare XSpot = 2;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
             } //end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   // far right column:
   #declare Count = 1;
   #declare XSpot = 4;
   #declare YSpot = 4;
   #while ( Count < 5.5 )
      object { Pane_Square_1
               translate < XSpot, YSpot, 0 >
             }// end pane 1
      #declare YSpot = YSpot-2;
      #declare Count = Count + 1;
   #end
   #if ( TestMode )
      texture { White_Tex }
   #else
      texture { T_Glass1 }
   #end
      } // end union SG panel 6

// **************************************************************


// *******************************************************************
// *******************************************************************
// III.    DEFINE Basic Elements
// *******************************************************************
//    A.   Simple Objects
// *******************************************************************

//    DEFINE  a torus for pillars
#declare Torus_1 =
torus { 0.5,       // MAJOR = radius of whole ring
        0.2        // MINOR = radius of tube
      } // end torus 1

// *******************************************************************
//    B.   Compound Objects
// *******************************************************************
//      1.   Lamps:
// *******************************************************************

//   DEFINE   an object as a light source
#declare Globe_Light =
object {
   sphere { < 0, 0, 0 > 0.5
      #if ( TestMode )
         texture { White_Tex }
      #else
         texture { T_Glass1 }
      #end
      hollow
          } // end sphere of glass
       } // end obj Globe Light

// **************************************************************

//   DEFINE   A Wall Lamp, facing south, -z:   light source on:
#declare WallLamp_A =
union {
   object {
      UnitBox                           // lamp base
      texture { T_Wood2 }
      scale < 1, 1, 0.25 >
      translate < 0, 0, 0.5 >        
          } //end object Lamp Base
   light_source {                      // sphere as light bulb
      < 0, 0, 0 >
      color White
      looks_like { Globe_Light }
      fade_distance 10
      fade_power 2
                } // end light source  
      } // end union Wall Lamp A

// **************************************************************

//   DEFINE   A Wall Lamp, facing south, -z:   light source off
#declare WallLamp_B =
union {
   object {
      UnitBox                           // lamp base
      texture { T_Wood2 }
      scale < 1, 1, 0.25 >
      translate < 0, 0, 0.5 >        
          } //end object Lamp Base
   object { Globe_Light 
          }//end sphere
      } // end union Wall Lamp B

// **************************************************************

//   DEFINE   A Wall Lamp   cylinder light source on
#declare WallLamp_C =
union {
   object {
      UnitBox                           // lamp base
      texture { T_Wood2 }
      scale < 1, 1, 0.25 >
      translate < 0, 0, 0.5 >        
          } //end object Lamp Base
   light_source {                      // sphere as light bulb
      < 0, 0, 0 >
      color White
      cylinder
      looks_like { Globe_Light }
      radius 30
      falloff 15
      tightness 15
      point_at < 0, -10, -2 >
      fade_distance 10
      fade_power 2
      media_attenuation on
                } // end light source
    hollow
      } // end union Wall Lamp C

// *******************************************************************
//      2.    Lighting arrays:
// *******************************************************************

//    DEFINE  atrium lighting:
#declare Lights_Atrium =
union {
   #if ( Lights) 
      // interior lights:
      object { WallLamp_A
               rotate x*-90  translate < -7.5, 6.6,  10 > }
      object { WallLamp_A
               rotate x*-90  translate <  7.5, 6.6,  10 > }
      object { WallLamp_A
               rotate x*-90  translate < -7.5, 6.6, -10 > }
      object { WallLamp_A
               rotate x*-90  translate <  7.5, 6.6, -10 > }
      // exterior lights:
      object { WallLamp_A translate <-3.15, 1.5, -20.5> }//above front door 
      object { WallLamp_A translate < 3.15, 1.5, -20.5> }
   #else
      // interior lights:
      object { WallLamp_B
               rotate x*-90  translate < -7.5, 6.6,  10 > }
      object { WallLamp_B
               rotate x*-90  translate <  7.5, 6.6,  10 > }
      object { WallLamp_B
               rotate x*-90  translate < -7.5, 6.6, -10 > }
      object { WallLamp_B
               rotate x*-90  translate <  7.5, 6.6, -10 > }
      // exterior lights:
      object { WallLamp_B translate <-3.15, 1.5, -20.5> }//above front door 
      object { WallLamp_B translate < 3.15, 1.5, -20.5> }
   #end  //if lights on/off
      } // end atrium lighting union

// **************************************************************

//    DEFINE  lights for East Room:
#declare Lights_East =
union {
   #if ( Lights) 
      // interior lights ON:
      object { WallLamp_A
               rotate x*-90  translate < -10, 4.6, 0 > }
      object { WallLamp_A
               rotate x*-90  translate <  10, 4.6, 0 > }
      // exterior lights ON:
      object { WallLamp_C              //above east door
               scale 0.5 translate < 2.45, 4, -10.25> }
      object { WallLamp_C
               scale 0.5 translate < 7.55, 4, -10.25> }
   #else
      // interior lights OFF:
      object { WallLamp_B
               rotate x*-90  translate < -10, 4.6, 0 > }
      object { WallLamp_B
               rotate x*-90  translate <  10, 4.6, 0 > }
      // exterior lights OFF:
      object { WallLamp_B              //above east door 
               scale 0.5 translate < 2.45, 4, -10.25> }
      object { WallLamp_B
               scale 0.5 translate < 7.55, 4, -10.25> }
   #end  //if lights on/off
      } // end east room lights

// **************************************************************

//    DEFINE  lights for East Room:
#declare Lights_West =
union {
   #if ( Lights) 
      // interior lights ON:
      object { WallLamp_A
               rotate x*-90  translate < -10, 4.6, 0 > }
      object { WallLamp_A
               rotate x*-90  translate <  10, 4.6, 0 > }
      // exterior lights ON:
      object { WallLamp_C              //above west door
               scale 0.5 translate < -2, 4, -10.35> }
      object { WallLamp_C
               scale 0.5 translate < -8, 4, -10.35> }
   #else
      // interior lights OFF:
      object { WallLamp_B
               rotate x*-90  translate < -10, 4.6, 0 > }
      object { WallLamp_B
               rotate x*-90  translate <  10, 4.6, 0 > }
      // exterior lights OFF:
      object { WallLamp_B              //above east door 
               scale 0.5 translate < -2, 4, -10.25> }
      object { WallLamp_B
               scale 0.5 translate < -8, 4, -10.25> }
   #end  //if lights on/off
      } // end west room lights

// **************************************************************

//    DEFINE  north room lighting:
#declare Lights_North =
union {
   #if ( Lights) 
      // interior: 1st floor: ON
      object { WallLamp_A
               rotate x*-90  translate <  -15, -0.5,  10 > }
      object { WallLamp_A
               rotate x*-90  translate <   15, -0.5,  10 > }
      object { WallLamp_A
               rotate x*-90  translate <    0, -0.53,   5 > }
      // interior: 2nd floor: ON
      object { WallLamp_A
               rotate x*-90  translate <  -15, 9.3,  10 > }
      object { WallLamp_A
               rotate x*-90  translate <   15, 9.3,  10 > }
      object { WallLamp_A
               rotate x*-90  translate <    0, 9.3,   5 > }
      object { WallLamp_A
               rotate x*-90  translate < -7.5, 9.3, -15 > }
      object { WallLamp_A
               rotate x*-90  translate <  7.5, 9.3, -15 > }
      // exterior lights:  ON
      object { WallLamp_C
               rotate y*180  translate < -3.0, -1.0, 20.5> } //north door 
      object { WallLamp_C 
               rotate y*180  translate <  3.0, -1.0, 20.5> } //north door
      object { WallLamp_C
               rotate y*90   translate < -25.3, -1.0, 8 > } //west door 
      object { WallLamp_C
               rotate y*90   translate < -25.3, -1.0, 2 > } //west door 
      object { WallLamp_C
               rotate y*-90  translate <  25.3, -1.0, 8 > } //east door 
      object { WallLamp_C
               rotate y*-90  translate <  25.3, -1.0, 2 > } //east door 
   #else
      // interior: 1st floor: OFF
      object { WallLamp_B
               rotate x*-90  translate <  -15, -0.5,  10 > }
      object { WallLamp_B
               rotate x*-90  translate <   15, -0.5,  10 > }
      object { WallLamp_B
               rotate x*-90  translate <    0, -0.53,   5 > }
      // interior: 2nd floor: OFF
      object { WallLamp_B
               rotate x*-90  translate <  -15, 9.3,  10 > }
      object { WallLamp_B
               rotate x*-90  translate <   15, 9.3,  10 > }
      object { WallLamp_B
               rotate x*-90  translate <    0, 9.3,   5 > }
      object { WallLamp_B
               rotate x*-90  translate < -7.5, 9.3, -15 > }
      object { WallLamp_B
               rotate x*-90  translate <  7.5, 9.3, -15 > }
      // exterior lights:  OFF
      object { WallLamp_B
               rotate y*180  translate < -3.0, -1.0, 20.5> } //north door 
      object { WallLamp_B 
               rotate y*180  translate <  3.0, -1.0, 20.5> } //north door
      object { WallLamp_B
               rotate y*90   translate < -25.3, -1.0, 8 > } //west door 
      object { WallLamp_B
               rotate y*90   translate < -25.3, -1.0, 2 > } //west door 
      object { WallLamp_B
               rotate y*-90  translate <  25.3, -1.0, 8 > } //east door 
      object { WallLamp_B
               rotate y*-90  translate <  25.3, -1.0, 2 > } //east door 
   #end  //if lights on/off
      } // end north room lighting

// *******************************************************************
//      3.   Arches:
// *******************************************************************

#declare Arch_Z1 =                     // 0.3 thick
difference {
   object { Disk_Z  scale < 1.0, 1.0, 1.0 > } 
   object { Disk_Z  scale < 0.7, 0.7, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 1

// **************************************************************

#declare Arch_Z2 =                     // 0.05 thick
difference {
   object { Disk_Z  scale <  1.0,  1.0, 1.0 > }
   object { Disk_Z  scale < 0.95, 0.95, 1.1 > }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z 2

// *******************************************************************
//    C.   Floors                                                     
// *******************************************************************

//    DEFINE   basic floor: 2x 0.5y 2z
#declare Floor_One =
object { UnitBox  scale < 1, 0.25, 1 > }

// **************************************************************

//    DEFINE  a tiled Floor: 10x 1y 10z
#declare Tiled_Floor_1 =
object {
   UnitBox
   scale < 5, 0.5, 5 >
   translate < 0, 0.02, 0 >
   texture {
      tiles {
        #if ( TestMode )
           texture { Black_Tex }
        #else
           texture { Spex }
        #end
      tile2
        #if ( TestMode )
           texture { White_Tex }
        #else
           texture { Grnt20 }
        #end
            }  //end of tiles
           }  //end of texture
       }  //end of Tiled Floor 1

// **************************************************************

// declare the set of tiles as a union built by a loop: WHILTILE.POV
#declare Max  = 10;                    // # of tiles across and down
#declare XMax = Max/2;
#declare ZMax = Max/2;
#declare ZCount = -ZMax;

#declare Tiled_Floor_2 =
union {
    #while (ZCount <= ZMax)
      #declare XCount = -XMax;
      #while (XCount <= XMax)
      object {
        UnitBox scale < 0.5, 0.5, 0.5 >
        #if(XCount=0 & ZCount=0)
        // Center tile
          texture { Red_Tex }
        #else
          #if (abs(XCount) = abs(ZCount))
            // An "X" pattern of tiles, diagonal through origin
            texture { Grnt20 }
          #else
            #if (abs(XCount)*abs(ZCount) < XMax)
              // A "fat plus" pattern, centered on origin
               #if ( TestMode )
                  texture { Black_Tex }
               #else
                  texture { Spex }
               #end
            #else
              #if (abs(mod(XCount,3)) = abs(mod(ZCount,2)))
                // An alternating sprinkle of remaining tiles
                 #if ( TestMode )
                    texture { Black_Tex }
                 #else
                    texture { Spex pigment { turbulence 3.5 } }
                 #end
              #else
                 #if ( TestMode )
                    texture { Black_Tex }
                 #else
                    texture { Spex pigment { turbulence 2.5 } }
                 #end
              #end
            #end
          #end
        #end
        translate <XCount, 0, ZCount>
      }
      #declare XCount = XCount+1;
      #end  // Inner X loop
    #declare ZCount = ZCount+1;
    #end  // Outer Z loop
      } // end union

// **************************************************************

//    DEFINE  a floor for the atrium:
#declare Floor_Atrium =
object { Floor_One
         scale < 15.5, 1, 20.5 >
         #if ( TestMode )
            texture { Brown_Tex }
         #else
            texture { RosewoodB  scale < 2, 2, 25 > } 
            #if ( Seams )
               texture { Seams_X  scale 0.5 }
            #end 
         #end 
       }//end atrium floor

// **************************************************************

//   DEFINE  a floor for East and West Rooms:
#declare Floor_East =
   union {
      object { Floor_One  scale < 20.5, 1, 10.5 > }
      object { Floor_One  scale < 15.5, 1, 5.5 >
                          translate <  -5, 0,  15 > }
      object { Floor_One  scale < 10.5, 1, 5.5 >
                          translate < -10, 0, -15 > }
      #if ( TestMode )
         texture { Tan_Tex }
      #else
         texture { RosewoodB  scale < 2, 2, 25 > rotate y*90 }
         #if ( Seams )
            texture { Seams_X  scale 0.5  rotate y*90 }
         #end
      #end 
         }//end floor union  

// **************************************************************

//   DEFINE  a floor for East and West Rooms:
#declare Floor_West =
object { Floor_East  rotate z*180 }

// *******************************************************************
//    D.   Roofs
// *******************************************************************

//    DEFINE  a flat slab roof: 2x 1y 2z
#declare Roof_One =
object { Cube  scale < 1, 0.5, 1 > }

// **************************************************************

//    DEFINE   A beveled-edged square box: original square version
#declare Roof_Two =
intersection {
   object { Cube                       //body of roof
            scale < 1, 1, 1 > }
   //beveled edges:
   plane { < 0, 1, 0 > 0.5                  // front x edge
           scale < 1, 1, 0.25 >
           rotate < -85, 0, 0 >
           translate < 0, 0.15, 0 >
         } //end plane a
   plane { < 0, 1, 0 > 0.5                  // rear x edge
           scale < 1, 1, 0.25 >
           rotate < 85, 0, 0 >
           translate < 0, 0.15, 0 >
         } //end plane b
   plane { < 0, 1, 0 > 0.5                  // left z edge
           scale < 1, 1, 0.25 >
           rotate < -85, 90, 0 >
           translate < 0, 0.15, 0 >
         } //end plane c
   plane { < 0, 1, 0 > 0.5                  // right z edge
           scale < 1, 1, 0.25 >
           rotate < 85, 90, 0 >
           translate < 0, 0.15, 0 >
         } //end plane d
             } // end intersection Roof Two

// **************************************************************

//    DEFINE  an a-frame roof, about 5x 2.5y 5z:
#declare Roof_Three =
union {
   object { CubeZ1 scale < 4.75, 0.5, 5.5 > 
                   rotate z*45 
                   translate < -0.75, 0.75, 0 >
          }// end left half of a-frame
   object { CubeZ1 scale < 4.75, 0.5, 5.5 > 
                   rotate z*-45 
                   translate < 0.75, 0.75, 0 >
          }// end right half of a-frame
   object { Tri_Up  scale < 1, 1, 0.5 >
                    translate z*-2.5
          }// end front panel
   object { Tri_Up  scale < 1, 1, 0.5 >
                    translate z*2.5
          }// end rear panel
   #if ( TestMode )
      texture { Coral_Tex }
   #else
      texture { Gray50_Tex }
   #end
      } // end a-frame roof union

// **************************************************************

//   DEFINE  the roof for East and West Rooms:
#declare Roof_East =
   union {
      object { Roof_One
               scale < 21, 0.75, 11 >
               translate < 0, 0, 0 > }      //end center panel  
      object { Roof_One
               scale < 11, 0.75, 6 >
               translate < 0, 0, 15 > }    //end north panel 
      object { Roof_One
               scale < 11, 0.75, 6 >
               translate < -10, 0, -15 > }  //end south panel 
      // east edge:
      object { PostZ1 
               scale < 1.5, 1.5, 22 >
               translate < 21, 0, 0 > }     //end east edge cyl
      sphere { <0,0,0> 0.375 
               translate < 21, 0, 11 > }    //end sphere left rear
      sphere { <0,0,0> 0.375 
               translate < 21, 0, -11 > }   //end sphere left front
      // south edge:
      object { PostX1 
               scale < 22, 1.5, 1.5 >
               translate < 10, 0, -11 > }   //end south right edge cyl
      object { PostX1 
               scale < 22, 1.5, 1.5 >
               translate < -10, 0, -21 > }  //end south left edge cyl
      object { PostZ1 
               scale < 1.5, 1.5, 12 >
               translate < 1, 0, -15 > }    //end middle turned edge cyl
      sphere { <0,0,0> 0.375 
               translate < 1, 0, -21 > }    //end sphere left front left
      sphere { <0,0,0> 0.375 
               translate < -21, 0, -21 > }  //end sphere left front right
      // north edge:
      object { PostX1 
               scale < 32, 1.5, 1.5 >
               translate < -5, 0, 21 > }    //end north left edge cyl
      object { PostZ1 
               scale < 1.5, 1.5, 12 >
               translate < 11, 0, 15 > }    //end middle turned edge cyl
      object { PostX1 
               scale < 12, 1.5, 1.5 >
               translate < 15, 0, 11 > }    //end north right edge cyl
      sphere { <0,0,0> 0.375 
               translate < -21, 0, 21 > }   //end sphere left rear
      sphere { <0,0,0> 0.375 
               translate < 11, 0, 21 > }    //end sphere middle rear
      // west edge:
      object { PostZ1 
               scale < 1.5, 1.5, 42 >
               translate < -21, 0, 0 > }    //end west edge cyl
      texture { Gray50_Tex }
         } // end union east or west room roof 

// *******************************************************************
//    E.   Stairs                                                     
// *******************************************************************

//    DEFINE   a set of stairs:
#declare North_Stairs =
union { 
   object { Pane_Tri_1 
               scale < 5, 5, 8 >
               rotate y*-90   //long edge toward front
               rotate x*90   //tilt long edge toward back
          }// end triangle stair support

   #declare sz = 5;
   #declare sy = 5;
   #declare Offset = 0.5;
   #declare Looper = 0;
   #while ( Looper < 20.1)
      object { CubeX1
               scale < 7.5, 1.2, 3 >
               translate < 0, sy, sz >
             }// end step
      #declare sy = sy - Offset;
      #declare sz = sz - Offset;
      #declare Looper = Looper + 1;
   #end
   #if (TestMode )
      texture { Red_Tex }
   #else 
      texture { pigment { Red_Marble  scale < 10,4,1> } }
   #end
      } // end union stair block

// *******************************************************************
//    F.   Doors:                                                     
// *******************************************************************

//   DEFINE   basic door frame inset for 10x 10y Frame_A
#declare Frame_Door_A1 =
union {
   object { CubeY1                                        
            scale < 0.5, 10, 0.5 >  translate < -2, 0, 0 > }
   object { CubeY1                                       
            scale < 0.5, 10, 0.5 >  translate <  2, 0, 0 > }
   object { CubeX1                                        
            scale < 10, 0.5, 0.5 >  translate <  0, 2, 0 > }
   #if ( TestMode )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end Frame for Door  A1

// **************************************************************

//   DEFINE  a 4x 7y door: CLOSED
#declare Door_D1a =
object { UnitBox
         scale < 2, 3.5, 0.10 >
         #if ( TestMode )
            texture { Gray50_Tex }
         #else
            texture { EMBWood1  scale < 1, 11, 1 > }
         #end
          } // end Door D1a

// **************************************************************

//   DEFINE  a 4x 7y door: OPEN
#declare Door_D1b =
object { UnitBox  scale < 2, 3.5, 0.10 >
                  translate < -0.75, 0, -1.5 >
                  rotate y*-45
         #if ( TestMode )
            texture { Gray50_Tex }
         #else
            texture { EMBWood1  scale < 1, 11, 1 > }
         #end
       } // end Door D1 b

// **************************************************************

//   DEFINE  set of solid wall panels scaled for Door_Front
#declare Panel_Door_A1a =
union {
   object { UnitBox                                             // UC
            scale < 2, 1.5, 0.1 >  translate <    0,  3.5, 0 > }
   object { UnitBox                                             // UL
            scale < 1.5, 1.5, 0.1 >  translate < -3.5, 3.5, 0 > }
   object { UnitBox                                             // UR
            scale < 1.5, 1.5, 0.1 >  translate <  3.5, 3.5, 0 > }
   object { UnitBox                                             // LL
            scale < 1.5, 3.5, 0.1 >  translate < -3.5, -1.5, 0 > }
   object { UnitBox                                             // LR
            scale < 1.5, 3.5, 0.1 >  translate <  3.5, -1.5, 0 > }
   #if ( TestMode )
      texture { Green_Tex }
   #else
      texture { EMBWood1
                scale < 11, 0.5, 0.5 >  }//end textr
      finish { ambient 0.4  diffuse 0.6 }//end finish
      #if ( Seams )
         texture { Seams_Y  scale 0.5 }
      #end 
    #end      
      } // end Panels New Door A1a

// **************************************************************

//   DEFINE   a front door for Atrium wall
#declare Door_Front =
union {
   object { Frame_Door_A1 }  // door jams
//   object { Panel_Door_A1a } // door panels
   object { Door_D1a
            translate  < 0, -1.5, 0 > }  // door, closed  
//   object { Door_D1b
//            translate  < 0, -1.5, 0 > }  // door, open
      } // end union Front Door

// *******************************************************************
//    G.   Windows:
// *******************************************************************

//    DEFINE  a 10x 10y panel w/ 3x 4y window:
#declare G_Window_1 =
union {
   object { Window_Panel_1 }
   object { Window_Frame_1 }
   object { D_Panel_2 } // deco window dressing
      } // end plain glass window 1

// **************************************************************

//    DEFINE  a 10x 10y panel w/ 6x 4y window:
#declare G_Window_2 =
union {
   object { Window_Panel_2 }
   object { Window_Frame_2 }
      } // end plain glass window 2

// **************************************************************

//    DEFINE  a 6x10 stained glass window: diamond pattern:
#declare SG_Window_1 =
union {
   object { SG_Frame_1 }
   object { SG_Panel_1 }
      } // end stained glass window pattern 1
      
// **************************************************************

//    DEFINE  a 10x10 stained glass window: square pattern:
//            scaled for Frame_A: brick paneling at bottom
#declare SG_Window_2 =
union {
   object { UnitBox
            scale < 5, 0.6, 0.25>
            translate y*4.4
            #if ( TestMode )
               texture { Magenta_Tex }
            #else
               texture { T_Wood5 }
            #end
          }// end upper panel
   object { SG_Frame_2  scale < 1, 0.75, 1 > }
   object { SG_Panel_2  scale < 1, 0.75, 1 > }
   object { UnitBox
            scale < 4.95, 1.20, 0.495 >
            translate y*-3.6
            texture { Gray_Tex }
          }// end inset mortar box
   object { Panel_C
            translate y*-3.6
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { JB_Brick_1 }
            #end
          }// end bottom brick panel
   object { Frame_A
            #if ( TestMode )
               texture { Yellow_Tex }
            #else
               texture { T_Wood2 }
            #end
          }// end frame A 
         } // end glass window 2   

// **************************************************************

//    DEFINE  a 5x5 stained glass window: diamond pattern:
#declare SG_Window_3 =
union {
   object { SG_Panel_3 scale < 0.55, 0.55, 1 > }
   object { SG_Frame_3 scale < 0.55, 0.55, 1 > }
   object { Frame_E  texture { T_Wood2 } }    // 5x 5y 
      } // end stained glass window version 3
 
// **************************************************************

//    DEFINE  a 5x5 stained glass window: complex diamond pattern:
#declare SG_Window_4 =
union {
   object { SG_Panel_4 scale < 0.55, 0.55, 1 > }
   object { SG_Frame_4 scale < 0.55, 0.55, 1 > }
   object { Frame_E  texture { T_Wood2 } }    // 5x 5y 
      } // end stained glass window version 4
 
// **************************************************************

//    DEFINE  a 5x5 stained glass window: simple square pattern:
#declare SG_Window_5 =
union {
   object { SG_Frame_5  scale < 0.5, 0.5, 1 > } // end frame 5
   object { SG_Panel_5  scale < 0.5, 0.5, 1 > } // end panel 5
   object { Frame_E
            #if ( TestMode )
               texture { Yellow_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // 5x 5y frame
      } // end stained glass window 5

// **************************************************************

//    DEFINE  a 10x10 stained glass window: simple square pattern:
#declare SG_Window_6 =
union {
   object { SG_Window_5  translate < -2.5,  2.5, 0 > } // ul
   object { SG_Window_5  translate <  2.5,  2.5, 0 > } // ur
   object { SG_Window_5  translate < -2.5, -2.5, 0 > } // ll
   object { SG_Window_5  translate <  2.5, -2.5, 0 > } // lr
   object { Frame_A
            #if ( TestMode )
               texture { Yellow_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // 10x 10y frame
      } // end stained glass window 6

// *******************************************************************
//    H.   FirePlace
// *******************************************************************

//    DEFINE  Fire Place: center of firebox = < 0,0,0 >:
#declare FirePlace_A =
   union {
      object {                              //the Firebox
         difference { object { UnitBox         
                               scale < 2.5, 1.75, 1.5 > }
                      object { UnitBox         
                               scale < 2.0, 1.55, 1.0 >
                               translate z*-0.6 }
                     } // end diference
             } // end object fire box
      object { UnitBox                      // Chimney
               scale < 2.1, 6.5, 0.8 >
               translate < 0, 4.5, 1.4 >
             } // end object
      object { UnitBox                      // Chimney Top
               scale < 2.5, 0.5, 1 >
               translate < 0, 11, 1.4 >
             }  // end obj Box
      object { UnitBox                      // Fire floor
               scale < 2.75, 0.125, 3 >
               translate < 0, -1.75, -0.75 >
             }  // end obj Box
      #if ( TestMode )
         texture { Black_Tex }
      #else
         texture { Grnt20 } 
      #end      
      }  // end union Fire Place A

// *******************************************************************
//    I.    DEFINE Front Yard
// *******************************************************************

#include "l_scape.inc"                 // landscaping
 
// *******************************************************************
// *******************************************************************
// *******************************************************************



// *******************************************************************
// IV.   DEFINE  Rooms
// *******************************************************************
//       A. The Atrium:
// *******************************************************************
//          1. Frames:
// *******************************************************************

//   DEFINE   front/south Atrium wall frame:
//            30x 15y: w/ arches: centered on 0,0,0:
#declare Atrium_SFrame_1 =
union {
   object { CubeY1                                        // left
            scale < 0.75, 15, 0.75 >  translate < -15,  0, 0 > }
   object { CubeY1                                        // right
            scale < 0.75, 15, 0.75 >  translate <  15,  0, 0 > }
   object { CubeX1                                        // top
            scale < 30.5, 0.75, 0.75 >  translate <  0,  7.5, 0 > }
   object { CubeX1                                        // bottom
            scale < 30.5, 0.75, 0.75 >  translate <  0, -7.5, 0 > }
   object { CubeX1                                        // middle
            scale < 30.2, 0.65, 0.65 >  translate <  0, 2.5, 0 > }
   object { CubeY1                                        // left2 of door
            scale < 0.5, 15, 0.5 >  translate <  -10, 0, 0 > }
   object { CubeY1                                        // right2 of door
            scale < 0.5, 15, 0.5 >  translate <   10, 0, 0 > }
   object { CubeY1                                        // left1 of door
            scale < 0.5, 15, 0.5 >  translate <  -5, 0, 0 > }
   object { CubeY1                                        // right1 of door
            scale < 0.5, 15, 0.5 >  translate <   5, 0, 0 > }
   object { Arch_Z2                                        // the arch
            scale < 5.0, 4.75, 0.5 > }
/* use these instead of art deco trim:
   object { Arch_Z2                                        // arch west
            scale < 2.4, 2.5, 0.25 >  translate < -12.5, 0, 0 > }
   object { Arch_Z2                                        // arch west
            scale < 2.4, 2.5, 0.25 >  translate <  -7.5, 0, 0 > }
   object { Arch_Z2                                        // arch east
            scale < 2.4, 2.5, 0.25 >  translate <  12.5, 0, 0 > }
   object { Arch_Z2                                        // arch east
            scale < 2.4, 2.5, 0.25 >  translate <   7.5, 0, 0 > }
*/
   #if ( TestMode )
      texture { Yellow_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end atrium south/front wall frame 1

// **************************************************************

/*   NOT NEEDED...north_room front wall replaces this:
//   DEFINE   rear/north Atrium wall frame:
//            30x 15y: w/ arches: centered on 0,0,0:
#declare Atrium_NFrame_1 =
union {
   object { CubeY1                                        // left
            scale < 0.75, 15, 0.75 >  translate < -15,  0, 0 > }
   object { CubeY1                                        // right
            scale < 0.75, 15, 0.75 >  translate <  15,  0, 0 > }
   object { CubeX1                                        // top
            scale < 30.5, 0.75, 0.75 >  translate <  0,  7.5, 0 > }
   object { CubeX1                                        // bottom
            scale < 30.5, 0.75, 0.75 >  translate <  0, -7.5, 0 > }
   object { CubeX1                                        // middle
            scale < 30.2, 0.65, 0.65 >  translate <  0, 2.5, 0 > }
   object { CubeY1                                        // left2 of door
            scale < 0.5, 15, 0.5 >  translate <  -10, 0, 0 > }
   object { CubeY1                                        // right2 of door
            scale < 0.5, 15, 0.5 >  translate <   10, 0, 0 > }
   object { CubeY1                                        // left1 of door
            scale < 0.5, 15, 0.5 >  translate <  -5, 0, 0 > }
   object { CubeY1                                        // right1 of door
            scale < 0.5, 15, 0.5 >  translate <   5, 0, 0 > }
   #if ( TestMode )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end atrium north/rear wall frame 1
*/

// **************************************************************

//   DEFINE   west/left Atrium wall frame:
//            15y 30z: centered on 0,0,0:
#declare Atrium_WFrame_1 =
union {
   object { Frame_30x10
            rotate y*90
            translate < 0, -2.5, 0 >
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // end frame 30x10
   object { Frame_30x05
            rotate y*90
            translate < 0, 5, 0 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // end frame 30x05
      } // end west frame union

// **************************************************************

//   DEFINE   east/right Atrium wall frame:
//            15y 30z: centered on 0,0,0:
#declare Atrium_EFrame_1 =
union {
   object { Frame_30x10 
            rotate y*90
            translate < 0, -2.5, 0 >
            #if ( TestMode )
               texture { Magenta_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // end frame 3010
   object { Frame_30x05
            rotate y*90
            translate < 0, 5, 0 >
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2 }
            #end
          } // end frame 3005
      } // end union east frames

// *******************************************************************
//          2. Panels:
// *******************************************************************

//   DEFINE   front/south Atrium wall panels: 30x 15y centered on 0,0,0:
//            solid panels to match windows in Panel_2:
#declare Atrium_SPanel_1 =
union {
   object { CubeY1                                        // low left 2
            scale < 10, 10, 0.5 >  translate <  -12.5, -2.5, 0 > } 
   object { CubeY1                                        // low right 2
            scale < 10, 10, 0.5 >  translate <   12.5, -2.5, 0 > }
   object { CubeY1                                        // up left 2
            scale < 10, 5, 0.01 >  translate < -12.5, 5, 0 > }
   object { CubeY1                                        // up right 2
            scale < 10, 5, 0.01 >  translate <  12.5, 5, 0 > }
   #if ( TestMode )
      texture { Red_Tex }
   #else
      texture { EMBWood1
                scale < 13, 0.5, 0.5 >
                finish { ambient 0.4  diffuse 0.6 } 
              } //end texture
   #end           
   #if ( Seams )
       texture { Seams_Y  scale 0.5 }
   #end 
      } // end union atrium south wall panels   solid version 

// ************************************************************** 

//   DEFINE   front/south Atrium wall panels: 30x 15y centered on 0,0,0:
//            glass panels to match walls in Panel_1:
#declare Atrium_SPanel_2 =
union {
   object { CubeY1                                        // center
            scale < 20,  5, 0.01 >  translate < 0, 5, 0 > }
   object { CubeY1                                        // up left 1
            scale < 10,  5, 0.01 >  translate <  -7.5, 5, 0 > }
   object { CubeY1                                        // up right 1
            scale < 10,  5, 0.01 >  translate <   7.5, 5, 0 > }
   object { CubeY1                                        // low left 1
            scale < 10, 10, 0.01 >  translate <  -7.5, -2.5, 0 > }
   object { CubeY1                                        // low right 1
            scale < 10, 10, 0.01 >  translate <   7.5, -2.5, 0 > }
   #if ( TestMode )
      texture { Gray25_Tex }
   #else
      texture { T_Glass1 }
   #end
      } // end union atrium south wall panels   glass version 1

// ************************************************************** 

//   DEFINE   front/south Atrium wall panels: alternative to Panel_2:
//            glass panels to match solids in Panel_1:
#declare Atrium_SPanel_3 =
union {
  // upper tier clear windows:
  union {
   object { CubeY1                                        // center
            scale < 20, 5, 0.01 >  translate <    0, 5, 0 > }
   object { CubeY1                                        // up left 1
            scale < 10, 5, 0.01 >  translate < -7.5, 5, 0 > }
   object { CubeY1                                        // up right 1
            scale < 10, 5, 0.01 >  translate <  7.5, 5, 0 > }
   #if ( TestMode )
      texture { White_Tex }
   #else
      texture { T_Glass1 }
   #end
        }//end clear glass union
   // lower tier colored glass panels:
   object { SG_Window_1 
            scale < 0.75, 0.75, 0.75 >  translate < -8.65, -2.5, 0> }
   object { SG_Window_1 
            scale < 0.75, 0.75, 0.75 >  translate < -6.35, -2.5, 0> }
   object { SG_Window_1 
            scale < 0.75, 0.75, 0.75 >  translate <  8.65, -2.5, 0> }
   object { SG_Window_1 
            scale < 0.75, 0.75, 0.75 >  translate <  6.35, -2.5, 0> }
  // extra window frames:
  union {
   object { CubeX1
            scale < 10, 0.5, 0.5 > translate < -10,  2.2, 0 > }
   object { CubeX1
            scale < 10, 0.5, 0.5 > translate < -10, -7.2, 0 > }
   object { CubeX1
            scale < 10, 0.5, 0.5 > translate <  10,  2.2, 0 > }
   object { CubeX1
            scale < 10, 0.5, 0.5 > translate <  10, -7.2, 0 > }
   #if ( TestMode )
      texture { Magenta_Tex }
   #else
      texture { T_Wood2 }
   #end
        }//end extra frames union
      } // end union atrium south wall panels   glass version 2

// **************************************************************

//    DEFINE  art deco style trim for Atrium:
#declare Atrium_Deco_Trim =
union {
   // south trim:
   object { D_Panel_2 
            scale < 1.075, 0.5, 1 >
            translate < -10, 0, -20.15 > 
          }// end panel front west
   object { D_Panel_2 
            scale < 1.075, 0.5, 1 >
            translate < 10, 0, -20.15 > 
          }// end panel front east
   object { D_Panel_2 
            scale < 1.075, 0.4, 1 >
            translate < 0, -2.6, -20.15 > 
          }// end panel above door
   // west trim:
   #declare wy = -15;
   #declare counter = 1;
   #while ( counter < 7.5 )
   object { D_Panel_2
            scale < 1.075, 0.5, 1 >
            rotate y*90  
            translate < -15.15, 0, wy > 
          } // end atrium west trim 
   #declare counter = counter + 1;
   #declare wy = wy + 5; 
   #end
   // east trim:
   #declare wy = -15;
   #declare counter = 1;
   #while ( counter < 7.5 )
   object { D_Panel_2
            scale < 1.075, 0.5, 1 >
            rotate y*90  
            translate < 15.15, 0, wy > 
          } // end atrium east trim 
   #declare counter = counter + 1;
   #declare wy = wy + 5; 
   #end
   // north trim:
   object { D_Panel_2 
            scale < 1.075, 0.5, 1 >
            translate < -10, 0, 20.15 > 
          } // end panel atrium rear west
   object { D_Panel_2 
            scale < 1.075, 0.5, 1 >
            translate < 10, 0, 20.15 > 
          } // end panel atrium rear east
   #if ( TestMode )
      texture { Orange_Tex }
   #else
      texture { T_Wood2_MBH }
   #end
      }//end union deco trim

// **************************************************************

//   DEFINE   right/east Atrium upper wall panels:
//            glass & solid panels to match Panel_1:
#declare Atrium_EPanel_1 =
union {
   object { Pane_Square_2
            scale < 10, 5, 1 >
            rotate y*90
            translate < 0, 5, -5 > } // end glass panel
   object { Pane_Square_2
            scale < 10, 5, 1 >
            rotate y*90
            translate < 0, 5,  5 > } // end glass panel
   object { Panel_B
            rotate y*90
            translate < 0, 5, -15 > 
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
                         finish { ambient 0.4  diffuse 0.6 }
                       } //end texture
            #end           
           } // end wood panel
      } // end union atrium upper east panels

/*   REMODELLED TO ACCOMMODATE NORTH_ROOM:
   union {
      object { Panel_B
               rotate y*90
               translate < 0, 5, -15 > }
      object { Panel_B
               rotate y*90
               translate < 0, 5,  15 > }
      #if ( TestMode )
         texture { Red_Tex }
      #else
         texture { EMBWood1
                   scale < 13, 0.5, 0.5 >
                   finish { ambient 0.4  diffuse 0.6 } } //end texture
      #end           
         }// end wood panels
*/
// *******************************************************************
// *******************************************************************

//    DEFINE   the Atrium: version 4: centered on 0,0,0:
#declare Atrium =
union {
   // framing:
   object { Atrium_SFrame_1  translate z*-20 }
   object { Atrium_WFrame_1  translate x*-15 translate z*-5 }
   object { Atrium_EFrame_1  translate x*15 translate z*-5 }
//   object { Atrium_NFrame_1  translate z*20  }

   // south panels:
//   object { Atrium_SPanel_1  translate z*-20 }   // solid walls
// either...
//   object { Atrium_SPanel_2  translate z*-20 }   // glass walls V.1
// or...
//   object { Atrium_SPanel_3  translate z*-20 }   // glass walls V.2

   // north panels:
//   object { Atrium_SPanel_1  translate z*20 }   // solid walls
//   object { Atrium_SPanel_2  translate z*20 }   // glass walls V.1

   // east panels:
   object { Atrium_EPanel_1  translate x*15 }

   // west panels:
   object { Atrium_EPanel_1  translate x*-15 }

   // art deco trim:
//   object { Atrium_Deco_Trim  translate y*2.5 } 

   // doors:
//   object { Door_Front  translate < 0, -2.5, -20 > }

   // roof:
   object { Roof_One scale < 16, 1, 11 >
                     translate y*7.5
                     translate z*-10
                     texture { Gray25_Tex }
          } // the ceiling

   // floor:
   object { Floor_Atrium  translate y*-7.5 }

   // lights:
//   object { Lights_Atrium }
      } // end atrium

// *******************************************************************
// *******************************************************************
// *******************************************************************


// *******************************************************************
//       B. The East Room: Solarium:
// *******************************************************************
//          1.Frames:
// *******************************************************************

//    DEFINE   east room northern frame: 30x 10y 10z:
#declare EastRoom_NFrame_1 =
union {
//   object { Frame_A  translate < -15, 0, 10 > } //end left 2:north room 
   object { Frame_A  translate <  -5, 0, 10 > } //end left 1 
   object { Frame_A  translate <   5, 0, 10 > } //end right 1 
   object { Frame_A  translate <  15, 0,  0 > } //end right 2 
   object { Frame_A  rotate y*90
                     translate <  10, 0,  5 > } //end right turned
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <  10, 0, 10 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <  10, 0,  0 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <  20, 0,  0 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate < -10, 0, 10 > }
   #if ( TestMode )
      texture { Red_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end union east northern frame

// **************************************************************

//    DEFINE   east room southern frame: 30x 10y 10z:
#declare EastRoom_SFrame_1 =
union {
   object { Frame_A  translate < -15, 0, -10 > } // end left 2 
   object { Frame_A  translate <  -5, 0, -10 > } // end left 1 
   object { Frame_A  translate <   5, 0,   0 > } // end right 1 
   object { Frame_A  translate <  15, 0,   0 > } // end right 2 
   object { Frame_A  rotate y*90
                     translate <   0, 0,  -5 > } // end middle turned
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <  20, 0,   0 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <   0, 0,   0 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate <   0, 0, -10 > }
   object { CubeY1  scale < 2.5, 10, 2.5 >  translate < -20, 0, -10 > }
   #if ( TestMode )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end union east southern frame

// **************************************************************

//    DEFINE   east room eastern frame: 20z 10y:
#declare EastRoom_EFrame_1 =
union {
   object { Frame_A  rotate y*90  translate < 0, 0, -5 > } //end south 
   object { Frame_A  rotate y*90  translate < 0, 0,  5 > } //end north
   #if ( TestMode )
      texture { Magenta_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end union east eastern frame

// **************************************************************
/*   NOT REALLY NEEDED...north_room, atrium does this job:
//   DEFINE  an east room western frame: 10y 40z:
#declare  EastRoom_WFrame_1 =
union {
   object { Frame_A  rotate y*90  translate < 0, 0, -15 > } //end south 2
   object { Frame_A  rotate y*90  translate < 0, 0,  -5 > } //end south 1
   object { Frame_A  rotate y*90  translate < 0, 0,   5 > } //end north 1 
   object { Frame_A  rotate y*90  translate < 0, 0,  15 > } //end north 2
   #if ( TestMode )
      texture { Green_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end east room western frame
*/
// *******************************************************************
//          2. Panels:
// *******************************************************************

//    DEFINE  East Room north side paneling:
#declare EastRoom_NPanel_1 =
union {
   object { Pane_Square_2
            scale < 10, 10, 1 >
            translate < 15, 0, 0 >
          } //end panel far right
   object { Panel_A
            rotate y*90
            translate < 10, 0, 5 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end rotated panel
   object { SG_Window_4
            translate < 5, 1, 10 >
          } //end panel right right
   object { Window_Panel_3
            translate < 5, 0, 10 >
          } //end inset window frames
   object { Panel_A               //fireplace location
            translate < -5, 0, 10 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end panel mid left: fireplace location
/* REMOVED TO ACCOMDATE  NORTH_ROOM:
   object { SG_Window_2
            translate < -15, 0, 10 >
          } //end panel far left
*/
      } // end east room north side panel union

// **************************************************************

//    DEFINE  East Room south side paneling:
#declare EastRoom_SPanel_1 =
union {
   object { Pane_Square_2
            scale < 10, 10, 1 >
            translate < 15, 0, 0 > } // end right 2 
   object { SG_Window_2
            translate <  -5, 0, -10 > } // end left 1 
   object { SG_Window_2
            translate < -15, 0, -10 > } // end left 2 
   object { Panel_A
            rotate y*90
            translate < 0, 0, -5 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end rotated panel
     } // end east room southern panel

// **************************************************************

//    DEFINE  East Room east side paneling:
#declare EastRoom_EPanel_1 =
union {
   object { SG_Panel_6                 // squares 
            rotate y*90
            translate z*5
          } //end northern panel 
   object { SG_Frame_5
            rotate y*90
            translate z*5
          } //end northern frame
   object {  SG_Panel_6
            rotate y*90
            translate z*-5
          } //end southern panel
   object { SG_Frame_5
            rotate y*90
            scale < 2, 1, 1 >
            translate z*-5
          } //end southern frames
      } // end east room eastern panels

// **************************************************************

//    DEFINE  art deco style trim for East Room:
#declare East_Deco_Trim =
union {
   // door trim:
   object { D_Panel_2 
            scale < 1.075, 0.5, 1 >
            translate < 5, 2.4, -10.15 > 
          }// end panel above door
   // front west trim:
   #declare wx = -15;
   #declare counter = 1;
   #while ( counter < 3.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, -20.15 > 
          } // end front west trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
   //front mid trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < -0.15, 6, -15 > 
          } // end front rotated trim 
   // front east trim:
   #declare wx = 5;
   #declare counter = 1;
   #while ( counter < 3.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, -10.15 > 
          } // end front east trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
   // east trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < 20.15, 6, -5 > 
          } // end east front trim 
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < 20.15, 6, 0 > 
          } // end east mid trim 
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < 20.15, 6, 5 > 
          } // end east rear trim 
   // north trim:
   object { D_Panel_2 
            scale < 1.25, 0.75, 1 >
            translate < 15, 6, 10.15 > 
          }// end north far east
   //rear mid trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < 10.15, 6, 15 > 
          } // end rear rotated trim 
   // rear west trim:
   #declare wx = -15;
   #declare counter = 1;
   #while ( counter < 5.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, 20.15 > 
          } // end rear west trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
   #if ( TestMode )
      texture { Orange_Tex }
   #else
      texture { T_Wood2_MBH }
   #end
      }//end east room deco trim

// *******************************************************************
// *******************************************************************

//    DEFINE   the East Room: version 4: centered on 0,0,0:
#declare East_Room =
union {
   // framing:
   object { EastRoom_NFrame_1  translate <   0, 0,  10 > }
   object { EastRoom_SFrame_1  translate <   0, 0, -10 > }
   object { EastRoom_EFrame_1  translate <  20, 0,   0 > }

   // north panels:
   object { EastRoom_NPanel_1  translate <  0, 0,  10 > }

   // south panels:
   object { EastRoom_SPanel_1  translate <  0, 0, -10 > }

   // east panels:
   object { EastRoom_EPanel_1  translate < 20, 0,   0 > }

   // west panels: connecting to atrium: none for now:

   // doors:
   object { Door_Front  translate < 5, 0, -10 > }

   // deco trim:
//   object { East_Deco_Trim }

   // roof:
   object { Roof_East translate y*5.5 }

   // floor:
   object { Floor_East  translate y*-5 }

   // railings:

   // decore and furnishings:
   object { FirePlace_A
            translate < 0, -3, -1 >    //up against any wall
            translate < -5, 0, 19 >   //up against this Wall
          } // end fireplace A

   // lights:
//   object { Lights_East }

      } // end east room

// *******************************************************************
// *******************************************************************
// *******************************************************************



// *******************************************************************
//       C. The West Room: Kitchen, Dining, Entertaining:
// *******************************************************************
//          1.Frames: presently uses East Frames rotated z*180
// *******************************************************************
// *******************************************************************
//          2.Panels:
// *******************************************************************

//    DEFINE  West Room  north side paneling:
#declare WestRoom_NPanel_1 =
union {
   object {  SG_Window_2
            translate < -15, 0, 0 >
          } //end panel farthest left
   object { Panel_A
            rotate y*90
            translate < -10, 0, 5 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end rotated panel
/* removed to accodate north_room:
   object { SG_Window_4
            translate < 15, 1, 10 >
          } //end panel rear right
   object { Window_Panel_3 
            translate < 15, 0, 10 >
          } //end wood panel rear right
*/
   object { Panel_A
            translate < 5, 0, 10 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end panel rear middle
/*
   object { SG_Window_4
            translate < -5, 1, 10 >
          } //end glass panel rear left
*/
   object { Window_Panel_3 
            translate < -5, 0, 10 >
          } //end wood panel rear left
      } // end west room north side panel union

// **************************************************************

//    DEFINE  West Room  south side paneling:
#declare WestRoom_SPanel_1 =
union {
   object { G_Window_2
            translate < 15, 0, -10 > } // end right 2 
   object { G_Window_2 
            translate <  5, 0, -10 > } // end right 1 
   object { SG_Window_2
            translate < -15, 0,   0 > } // end left 1 
   object { Panel_A
            rotate y*90
            translate < 0, 0, -5 >
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
               finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
            #end           
          } //end rotated panel
     } // end west room southern panel

// **************************************************************

//    DEFINE  West Room  west side paneling:
#declare WestRoom_WPanel_1 =
union {
   object { SG_Panel_6                 // squares 
            rotate y*90
            translate z*5
          } //end northern panel 
   object { SG_Frame_5
            rotate y*90
            translate z*5
          } //end northern frame
   object {  SG_Panel_6
            rotate y*90
            translate z*-5
          } //end southern panel
   object { SG_Frame_5
            rotate y*90
            scale < 2, 1, 1 >
            translate z*-5
          } //end southern frames
      } // end west room western panels

// ************************************************************** 

//    DEFINE  art deco style trim for West Room:
#declare West_Deco_Trim =
union {
   // door trim:
   object { D_Panel_2 
            scale < 0.8, 0.5, 1 >
            translate < -5, 2.4, -10.15 > 
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          }// end panel above door
   // front east trim:
   #declare wx = 5;
   #declare counter = 1;
   #while ( counter < 3.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, -20.15 > 
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end front west trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
   //front mid trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < 0.15, 6, -15 > 
            #if ( TestMode )
               texture { Green_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end front rotated trim 
   // front east trim:
   #declare wx = -15;
   #declare counter = 1;
   #while ( counter < 3.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, -10.15 > 
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end front east trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
   // west trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < -20.15, 6, -5 > 
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end west front trim 
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < -20.15, 6, 0 > 
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end west mid trim 
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < -20.15, 6, 5 > 
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end west rear trim 
   // north trim:
   object { D_Panel_2 
            scale < 1.25, 0.75, 1 >
            translate < -15, 6, 10.15 > 
            #if ( TestMode )
               texture { White_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          }// end north far west
   //rear mid trim:
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            rotate y*90
            translate < -10.15, 6, 15 > 
            #if ( TestMode )
               texture { Yellow_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end rear rotated trim 
   // rear west trim:
   #declare wx = -5;
   #declare counter = 1;
   #while ( counter < 5.5 )
   object { D_Panel_2
            scale < 1.25, 0.75, 1 >
            translate < wx, 6, 20.15 > 
            #if ( TestMode )
               texture { Orange_Tex }
            #else
               texture { T_Wood2_MBH }
            #end
          } // end rear west trim 
   #declare counter = counter + 1;
   #declare wx = wx + 5; 
   #end
      }//end west room deco trim

// *******************************************************************
// *******************************************************************

//    DEFINE   the West Room: version 4: centered on 0,0,0:
#declare West_Room =
union {
   // framing:
   object { EastRoom_NFrame_1  rotate z*180  translate <   0, 0,  10 > }
   object { EastRoom_SFrame_1  rotate z*180  translate <   0, 0, -10 > }
   object { EastRoom_EFrame_1  rotate z*180  translate < -20, 0,   0 > }
//OPTIONAL:   object { EastRoom_WFrame_1  rotate z*180  translate <  20, 0,   0 > }

   // north panels:
   object { WestRoom_NPanel_1  translate < 0, 0,  10 > }

   // south panels:
   object { WestRoom_SPanel_1  translate < 0, 0, -10 > }

   // east panels: connecting to atrium: none for now

   // west panels:
   object { WestRoom_WPanel_1  translate x*-20 }

   // doors:
   object { Door_Front  translate < -5, 0, -10 > }

   // deco trim:
//   object { West_Deco_Trim }

   // roof:
   object { Roof_East  rotate z*180  translate y*5.5 }

   // floor:
   object { Floor_East rotate z*180  translate y*-5 }

   // railings:

   // decore and furnishings:
   object { FirePlace_A
            translate < 0, -3, -1 >    //up against any wall
            translate < 5, 0, 19  >  //up against this Wall
          } // end fireplace A

   // lights:
//   object { Lights_West }
      } // end west room

// *******************************************************************
// *******************************************************************
// *******************************************************************


// *******************************************************************
//       B. The North Room: Living, Bed, Bath, Office, Utility:
// *******************************************************************
// **************************************************************
//          1.Frames:
// **************************************************************

//    DEFINE  East Frame: 40z 20y:
#declare NRoom_EastFrame_1 =
union {
   object { Frame_40x10 rotate y*90 
                        translate < 0, -5, 0 > }// end lower
   object { Frame_40x10 rotate y*90 
                        translate < 0, 5, 0 >  }// end upper
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate < 0, 0, 20 > }
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate < 0, 0,-20 > }
   #if ( TestMode )
      texture { Coral_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end union north room east frame
  
// **************************************************************

//    DEFINE  West Frame: 40z 20y:
#declare NRoom_WestFrame_1 =
union {
   object { Frame_40x10 rotate y*90 
                        translate < 0, -5, 0 > } // end down
   object { Frame_40x10 rotate y*90 
                        translate < 0,  5, 0 > } // end up
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate < 0, 0, 20 > }
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate < 0, 0,-20 > }
   #if ( TestMode )
      texture { Black_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end union north room east frame
  
// **************************************************************

//    DEFINE  North Frame: 50x 20y:
#declare NRoom_NorthFrame_1 =
union {
   object { Frame_40x10 translate < -5, -5, 0 > } // low left
   object { Frame_A     translate < 20, -5, 0 > } // low right
   object { Frame_40x10 translate < -5,  5, 0 > } // up left
   object { Frame_A     translate < 20,  5, 0 > } // up right
   #if ( TestMode )
      texture { Blue_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end north room north frame

// **************************************************************

//    DEFINE  South Frame: 50x 20y:
#declare NRoom_SouthFrame_1 =
union {
   object { Frame_A  translate <  20, 5, 0 > }// end up right
   object { Frame_A  translate < -20, 5, 0 > }// end up left
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate <  15, 0, 0 > }
   object { CubeY1  scale < 2.5, 20, 2.5 >  translate < -15, 0, 0 > }
// REMOVED FOR STAIRWELL:
//   object { Frame_A  translate <  20,-5, 0 > }// end low right
//   object { Frame_A  translate < -20,-5, 0 > }// end low left
   #if ( TestMode )
      texture { Violet_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end north room south frame

// **************************************************************

//    DEFINE  interior frame:
#declare NRoom_InterFrame_1 =
union {
   object { Frame_A  translate <  -5, 0, 0 > }
   object { Frame_D  translate < 2.5, 0, 0 > }
   object { Frame_D  translate < 7.5, 0, 0 > }
   #if ( TestMode )
      texture { Orange_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end nw interior bottom frames

// **************************************************************

//    DEFINE  interior frame:
#declare NRoom_InterFrame_2 =
union {
   object { Frame_A  translate < -5, 0, 0 > }
   object { Frame_A  translate <  5, 0, 0 > }
   #if ( TestMode )
      texture { Orange_Tex }
   #else
      texture { T_Wood2 }
   #end
      } // end more interior 1st floor frames

// **************************************************************

//    DEFINE  Roof rafters:
#declare North_Rafters =
union {
   object { CubeX1  scale < 50, 2.5, 2.5 >  translate <   0, 10, -20 > }
   object { CubeX1  scale < 50, 2.5, 2.5 >  translate <   0, 10,  20 > }
   object { CubeZ1  scale < 2.5, 2.5, 40 >  translate < -25, 10,   0 > }
   object { CubeZ1  scale < 2.5, 2.5, 40 >  translate <  25, 10,   0 > }
   object { CubeX1  scale < 30, 2.5, 2.5 >  translate <   0,  5, -30 > }
   #if ( TestMode )
      texture { Brown_Tex }
   #else
      texture { T_Wood2 } 
   #end 
      } // end rafters union

// **************************************************************
//          2. Panels:
// **************************************************************

//    DEFINE  east panels: upper tier:
#declare  NRoom_EastPanel_1 =
union {
   union {
   object { Panel_A  rotate y*90  translate < 0, 5,  5 > } // north middle
   object { Panel_A  rotate y*90  translate < 0, 5, -5 > } // south middle
   #if ( TestMode )
      texture { Violet_Tex }
   #else
      texture { EMBWood1
                scale < 13, 0.5, 0.5 >
                finish { ambient 0.4  diffuse 0.6 } 
              } //end texture
      #if ( Seams )
         texture { Seams_Y  scale 0.5 }
      #end 
   #end
         }//end solid panels union
   object { Pane_Square_2
            scale < 10, 10, 1 >
            rotate y*90
            translate < 0, 5,  15 > } // north glass panel
   object { Pane_Square_2
            scale < 10, 10, 1 >
            rotate y*90
            translate < 0, 5, -15 > } // south glass panel
      } // end north room east upper panels

// **************************************************************

//    DEFINE  East Panels: lower tier:
#declare  NRoom_EastPanel_2 =
union {
   object { G_Window_2
            rotate y*90
            translate < 0, -5, 15 >
            #if ( TestMode )
               texture { Violet_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
                         finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
               #if ( Seams )
                  texture { Seams_Y  scale 0.5 }
               #end 
            #end           
          } //end northmost panel 
/* SUBSITUTE  Door here:
   object { Pane_Square_2
            scale < 10, 10, 1 >
            rotate y*90
            translate < 0, -5, 5 > } // end mid north panel
*/
   object { Panel_A
            rotate y*90
            translate < 0, -5, -5 > 
            #if ( TestMode )
               texture { Blue_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
                         finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
               #if ( Seams )
                  texture { Seams_Y  scale 0.5 }
               #end 
            #end           
          } // end mid south panel
   object { Panel_C
            rotate y*90
            translate < 0, -9, -15 >
            #if ( TestMode )
               texture { Yellow_Tex }
            #else
               texture { EMBWood1
                         scale < 13, 0.5, 0.5 >
                         finish { ambient 0.4  diffuse 0.6 } 
                       } //end texture
               #if ( Seams )
                  texture { Seams_Y  scale 0.5 }
               #end 
            #end           
          } //end southmost panel
      } // end north room east lower panels

// **************************************************************

//    DEFINE  north side panels:
#declare NRoom_NorthPanel_1 =
union {
   union {
      object { Panel_A  translate < -20,  5, 0 > } // left upper           
      object { Panel_A  translate <  20,  5, 0 > } // right upper
      object { Panel_A  translate < -20, -5, 0 > } // left lower           
      object { Panel_A  translate <  20, -5, 0 > } // right lower
      #if ( TestMode )
         texture { Red_Tex }
      #else
         texture { EMBWood1
                   scale < 12, 0.5, 0.5 >
                   finish { ambient 0.4  diffuse 0.6 } 
                 } //end texture
         #if ( Seams )
            texture { Seams_Y  scale 0.5 }
         #end 
      #end           
         }// end union wood panels
   object { SG_Window_3  scale < 2,2,1 > translate y*5 } // center window
   object { G_Window_2
            translate <  10, -5, 0 > } //end east down
   object { G_Window_2
            translate < -10, -5, 0 > } //end west down
   object { G_Window_2
            translate <  10,  5, 0 > } //end east up
   object { G_Window_2
            translate < -10,  5, 0 > } //end west up
      } // end union north panel 1

// **************************************************************

//    DEFINE  south side upper panels:
#declare NRoom_SouthPanel_1 =
union {
   object { Pane_Square_2 scale < 10, 10, 1 >
                          translate < -20, 5, 0 > } // end left
   object { Pane_Square_2 scale < 10, 10, 1 >
                          translate <  20, 5, 0 > } // end right
      } // end union south panel 1

// **************************************************************

//    DEFINE  first story interior panels:
#declare NRoom_Lower_Interior =
union {
   object { Panel_A translate <  20, -5, -10 >
                    texture { Tan_Tex } } // far south east
   object { Panel_A translate <  10, -5, -10 >
                    texture { Tan_Tex } } // mid south east
   object { Panel_A translate < -20, -5, -10 >
                    texture { Tan_Tex } } // far south west
   object { Panel_A translate < -10, -5, -10 >
                    texture { Tan_Tex } } // mid south west
   object { Panel_A rotate y*90
                    translate <  5, -5, 15 >    //north
                    texture { Tan_Tex } }
   object { Panel_A rotate y*90
                    translate < -5, -5, 15 >
                    texture { Tan_Tex } }
   object { Frame_A rotate y*90
                    translate <  5, -5,  5 >    // middle
                    texture { LB_Tex } }  //doors
   object { Frame_A rotate y*90
                    translate < -5, -5,  5 >
                    texture { LB_Tex } }  //doors
   object { Panel_A rotate y*90
                    translate <  5, -5, -5 >    //south
                    texture { Tan_Tex } }
   object { Panel_A rotate y*90
                    translate < -5, -5, -5 >
                    texture { Tan_Tex } }
   //downstairs bathroom: east cubical:
   object { Panel_A rotate y*90
                    translate < 15, -5, -5 >
                    texture { Tan_Tex } }
   object { Frame_D translate < 17.5, -5,  0 >
                    texture { LB_Tex } } //door
   object { Panel_D translate < 22.5, -5,  0 >
                    texture { Tan_Tex } }  
   //downstairs closet: west cubical:
   object { Panel_A rotate y*90
                    translate < -15.5, -5, -5 >
                    texture { Tan_Tex } }
   object { Frame_D translate < -17.5, -5,  0 >
                    texture { LB_Tex } }  // door
   object { Panel_D translate < -22.5, -5,  0 >
                    texture { Tan_Tex } }  
      } // end 1st floor interiors

// **************************************************************

//    DEFINE  second story interior panels:
#declare NRoom_Upper_Interior =
union {
   object { Panel_A translate <  20, 5, 0 >
                    texture { Tan_Tex } } // far south east
   object { Panel_A translate <  10, 5, 0 >
                    texture { Tan_Tex } } // mid south east
   object { Panel_A translate < -20, 5, 0 >
                    texture { Tan_Tex } } // far south west
   object { Panel_A translate < -10, 5, 0 >
                    texture { Tan_Tex } } // mid south west
   object { Panel_A rotate y*90
                    translate <  5, 5,  5 >    // middle
                    texture { LB_Tex } }  //doors
   object { Panel_A rotate y*90
                    translate < -5, 5,  5 >
                    texture { LB_Tex } }  //doors
   object { Panel_A rotate y*90
                    translate <  5, 5, 15 >    //north
                    texture { Tan_Tex } }
   object { Panel_A rotate y*90
                    translate < -5, 5, 15 >
                    texture { Tan_Tex } }
     } // end 2nd floor interior walls

// **************************************************************
//          3. Other Copmponents:
// **************************************************************

//    DEFINE  sloping window frame:
#declare North_Slope_Window =
union {
   object { Frame_A
            scale < 3, 1, 1.5 >
            rotate x*60
            #if ( TestMode )
               texture { Red_Tex }
            #else
               texture { T_Wood2 }
            #end
          }// end window frame 
   object { Pane_Square_2
            scale < 30, 10, 1 >
            rotate x*60
          }// end window glass
   union {
      object { Pane_Tri_1
                  scale < 4, 4, 1 >
                  rotate y*-90
                  rotate x*105
                  translate < 15, 0.45, 0.5 >
             } // end east side
      object { Pane_Tri_1
                  scale < 4, 4, 1 >
                  rotate y*-90
                  rotate x*105
                  translate < -15, 0.45, 0.5 >
             } // end side
      #if ( TestMode )
         texture { White_Tex }
      #else
         texture { T_Glass1 }
      #end
         }//end end pieces union
      } // end union sloping window

// **************************************************************

//    DEFINE  Arch Way between north room and atrium:
#declare ArchWay_1 =
   difference {
   union {
      object { CubeY1
               scale < 4, 20, 2 >
               translate x*-13.5 
             } // end arch marker left
      object { CubeY1
               scale < 4, 20, 2 >
               translate x*13.5 
             } // end arch marker right
      object { CubeX1
               scale < 29.1, 4, 2 >
               translate y*9 
             } // end arch marker top
            #if ( TestMode )
               texture { Goldenrod_Tex }
            #else
               texture { T_Wood2 }
            #end
         }//inner frame union
   object {
      #declare RB_P1 = <  13,  9,  2 >;
      #declare RB_P2 = < -13, -8.75, -2 >;
      #declare RB_Thickness = 2;      //Assumes 1 if not defined
      #declare RB_Solid = 0;          //Assumes "On" if not defined
      #include "roundbox.inc"
      translate < 0, -1, 0 >
            #if ( TestMode )
               texture { Gold_Tex }
            #else
               texture { T_Wood2 }
            #end
          } //end roundbox cut-out
              } // end difference arch way 1

// **************************************************************
// **************************************************************

//    DEFINE  north room:  
#declare North_Room =
union {
   // roof:
   object { Roof_One  scale < 27, 2, 22 >
                      translate < 0, 11, 0 >
                      texture { Gray25_Tex } }// end roof

   // roof rafters:
   object { North_Rafters }

   // frames: exterior:
   object { NRoom_EastFrame_1   translate x*25  }
   object { NRoom_WestFrame_1   translate x*-25 }
   object { NRoom_NorthFrame_1  translate z*20  }
   object { NRoom_SouthFrame_1  translate z*-20 }

   // panels: exterior
   object { NRoom_EastPanel_1   translate x*25  } //east top
   object { NRoom_EastPanel_2   translate x*25  } //east bottom
   object { NRoom_EastPanel_1   translate x*-25 } //west top
   object { NRoom_EastPanel_2   translate x*-25 } //west bottom
   object { NRoom_NorthPanel_1  translate z*20  } //north
   object { NRoom_SouthPanel_1  translate z*-20 } //south

   // front skylight window:
   object { North_Slope_Window  translate < 0, 7, -25 > }

   //archway: between north room and atrium:
   object { ArchWay_1  translate z*-20 }
   object { ArchWay_1  translate < -62, -10, -20 >
                       scale < 0.33, 0.5, 1 > }
   object { ArchWay_1  translate <  62, -10, -20 > 
                       scale < 0.33, 0.5, 1 > }

   // panels: 2nd floor: interior rooms:
   object { NRoom_Upper_Interior }

   // floor: second floor:
   object { Floor_One  scale < 25, 0.5, 15 >
                       translate z*5
            #if ( TestMode )
               texture { Goldenrod_Tex }
            #else
               texture { RosewoodB  scale < 2, 2, 25 > } 
               #if ( Seams )
                  texture { Seams_X  scale 0.5 }
               #end 
            #end 
          }// end second floor

   // doors:
   object { Door_Front rotate y*90  translate <  25, -5,  5 > } //east
   object { Door_Front rotate y*90  translate < -25, -5,  5 > } //west
   object { Door_Front              translate <   0, -5, 20 > } //north


   // panels: 1st floor: interior:
   object { NRoom_Lower_Interior }
   
   // stairs:
   object { North_Stairs  translate <  20, -5, -15 > } //east side
   object { North_Stairs  translate < -20, -5, -15 > } //west side

   // lights:
   object { Lights_North }

   // floor: ground floor:
   object { Floor_One  scale < 26, 0.5, 21 >
                       translate y*-10
                       #if ( TestMode )
                          texture { Brown_Tex }
                       #else
                          texture { RosewoodB  scale < 2, 2, 25 > } 
                          #if ( Seams )
                             texture { Seams_X  scale 0.5 }
                          #end 
                       #end 
          }// end ground floor
      } // end union north room
 
// *******************************************************************
// *******************************************************************
// *******************************************************************
 


// *******************************************************************
// V.   DEFINE Our_House
// *******************************************************************

//    DEFINE   the components of the Our_House scene:
//             <0,0,0> = center of atrium:
#declare Our_House =
union {
   object { Atrium      translate y*2.5}
//   object { East_Room   translate x*35  }   
//   object { West_Room   translate x*-35 }    
   object { North_Room  translate z*30 
                        translate y*5  }    
//   object { Front_Arch  translate < 0,   2.5,   -25 > }
//   object { Front_Yard  translate < 0, -5.25, -37.5 > }
      } // end our house

// *******************************************************************
// *******************************************************************
//    O_HOME00.INC         Michael Brendan Hurley         Fall 1999
// www.geocities.com/siliconvalley/network/4969/      mbhcgc@saber.net
// *******************************************************************
