// ***********************************************************************
// BASIC000.POV                                            Ver 1.0 Aug 97
//                                                         Ver 2.0 Jan 99
// Universal PoV V.3 Scene Template by Michael Brendan Hurley
// ***********************************************************************

#version 3.0
global_settings { assumed_gamma 1.8 }

#include "brendan.inc"

// ***********************************************************************
// Define Ambient Lights                                             *****
// ***********************************************************************

light_source { < -100, 100, -100 > color White }

// ***********************************************************************

// Define Test Lights
#declare Test_Spot =
light_source {
   < -25, 25, -25 >
   color White
   spotlight
   radius 25
   falloff 15
   tightness 15
   point_at < 0, 0, 0 >
             } // end Test Spotlight 1

// ***********************************************************************
// Define Sky                                                        *****
// ***********************************************************************

background { color Black }

sky_sphere { pigment  { Black } }                // real night
//sky_sphere { pigment  { LightBlue } }            // day
//sky_sphere { pigment  { MidnightBlue } }         // twilight
//sky_sphere { pigment { Bright_AquaBlue4 } scale < 0.6, 0.15, 0.15 > }

// ***********************************************************************
// Define Camera
// ***********************************************************************

#declare Camera_BS =
camera {
   direction <    0,  0,    2 >
   location  < -180, 45, -230 >         // SE of center
   look_at   <   -5, 15,    0 > }       // The Beauty Shot

#declare Camera_SE =
camera {
   direction <   0,  0,    2 >
   location  < 200, 50, -130 >         // SE of center
   look_at   <   0,  0,    0 > }       //    long shot

#declare Camera_SE_Close =
camera {
   direction <   0,  0, 1.5 >
   location  < -38, 26, -38 >          // SW balcony
   look_at   <  30, 13, -10 > }        //      ATRIUM INTERIOR

#declare Camera_SE_Low =
camera {
   direction <   0, 0,    2 >
   location  < 165, 6, -180 >          // SE of center
   look_at   <   0, 6,   40 > }        //       EYEBALL LEVEL

#declare Camera_SW =
camera {
   direction < 0, 0, 4 >
   location  < -50, 20, -110 >          // SW of center
   look_at   <   0,  5,  -25 > }        //            medium

#declare Camera_South =
camera {
   direction < 0, 0, 3 >
   location  < 0, 20, -30 >            // south of cntr
   look_at   < 0,  0,  10 > }          //

#declare Camera_West =
camera {
   direction <    0, 0,  2 >
   location  < -190, 6, 10 >          // West
   look_at   <    0, 9, 60 > }        //   of room 2 cntr

#declare Camera_East =
camera {
   direction <   0,  0, 2 >
   location  < 210, 110, 0 >           // East
   look_at   <  95,  10, 0 > }         //   of cntr

#declare Camera_Above =
camera {
   direction < 0,   0, 2 >
   location  < 0, 230, -80 >           // Above
   look_at   < 0,   0, -60 > }         //    cntr

// ***********************************************************************
//  Define Test Scene                                                *****
// ***********************************************************************

// CAMERA
//camera { Camera_BS }
//camera { Camera_SE }
camera { Camera_SW }
//camera { Camera_SE_Close }
//camera { Camera_SE_Low }
//camera { Camera_South }
//camera { Camera_West }
//camera { Camera_East }
//camera { Camera_Above }

// LIGHTS
//object { Test_Spot }                   //variable

// FLOOR
object { Clip_Floor }
//object { Check_Floor }
//object { Test_Floor }
//object { Grass_Floor }
//object { Gray50_Floor }

/*
// GRID MARKERS
#declare This_Marker =
union {
object { Mark01  translate <   0,  0,   0 > }    // center
object { Mark01  translate <  20,  0,   0 > }    // east
object { Mark01  translate < -20,  0,   0 > }    // west
object { Mark01  translate <  40,  0,   0 > }    // more east
object { Mark01  translate < -40,  0,   0 > }    // more west
object { Mark01  translate <  60,  0,   0 > }    // still more east
object { Mark01  translate < -60,  0,   0 > }    // still more west
object { Mark01  translate <   0,  0, -20 > }    // south
object { Mark01  translate <   0,  0,  20 > }    // north
object { Mark01  translate <   0,  0,  40 > }    // more north
object { Mark01  translate <   0,  0, -40 > }    // more south
object { Mark01  translate <   0,  0,  60 > }    // still more north
object { Mark01  translate <   0,  0, -60 > }    // still more south
      } // end This Marker

object { This_Marker translate < 0, 0, 0 > }
*/


// ***********************************************************************
//  Generate this image :
// ***********************************************************************

object { TestBox
            scale 5
            translate < 0, 5, 0 >
         texture { T_Wood2
                     scale 0.5
                 }//end texture
       } // end Test Box

// ***********************************************************************
// Michael Brendan Hurley, SDE, Ltd.                              Jan 1999
// ***********************************************************************
