// *******************************************************************
// L_SCAPE.INClude                                            Oct 1999
// called by O_HOMEnn.INC and others
// *******************************************************************
// *******************************************************************

// *******************************************************************
//   H.    DEFINE Front Yard
// *******************************************************************
//     1.    Structures
// **************************************************************

#declare BigArch_Posts =               // posts centered on 0,0,0
union {
   //west pillars
   object { PostY1  scale < 2, 9, 2 >  translate < -5, 0, -4 > }
   object { PostY1  scale < 2, 9, 2 >  translate < -5, 0,  0 > }
   object { PostY1  scale < 2, 9, 2 >  translate < -5, 0,  4 > }
   //west capitals
   object { Torus_1  translate < -5, 3.8, -4 > }
   object { Torus_1  translate < -5, 3.8,  0 > }
   object { Torus_1  translate < -5, 3.8,  4 > }
   object { Torus_1  translate < -5, -3.8, -4 > }
   object { Torus_1  translate < -5, -3.8,  0 > }
   object { Torus_1  translate < -5, -3.8,  4 > }
   //west pediments
   object { CubeZ1  scale < 3.2, 2, 10.15 >  translate < -5,  4.5, 0 > }
   object { CubeZ1  scale < 3.2, 2, 10.15 >  translate < -5, -4.5, 0 > }
   //east pillars
   object { PostY1  scale < 2, 9, 2 >  translate <  5, 0, -4 > }
   object { PostY1  scale < 2, 9, 2 >  translate <  5, 0,  0 > }
   object { PostY1  scale < 2, 9, 2 >  translate <  5, 0,  4 > }
   //east capitals
   object { Torus_1  translate < 5,  3.8, -4 > }
   object { Torus_1  translate < 5,  3.8,  0 > }
   object { Torus_1  translate < 5,  3.8,  4 > }
   object { Torus_1  translate < 5, -3.8, -4 > }
   object { Torus_1  translate < 5, -3.8,  0 > }
   object { Torus_1  translate < 5, -3.8,  4 > }
   //east pediments
   object { CubeZ1  scale < 3.2, 2, 10.15 >  translate <  5,  4.5,  0 > }
   object { CubeZ1  scale < 3.2, 2, 10.15 >  translate <  5, -4.5,  0 > }
   #if ( ShowDetails )
      texture { Magenta_Tex }
   #else
      texture { T_Stone2
                scale < 3.5, 2.5, 3.5 >
                rotate z*10                
                finish { ambient 0.3
                         diffuse 0.4 //0.3
                         specular 0.8
                         roughness 0.05
                         reflection 0.05 }//end finish
              } // end texture
   #end              
      } // end Posts for Front Arch             

// **************************************************************

//   DEFINE an arch way for Atrium: Posts centered on 0, 0, 0
#declare Front_Arch =
union {
   object { BigArch_1
               translate < 0, 0, 0 > }
   object { BigArch_Posts  
               scale < 1, 0.8, 1 >
               translate < 0, -3.75, 0 > }
   #if ( ShowDetails )
      texture { Magenta_Tex }
   #else
      texture { T_Stone2
                scale < 3.5, 2.5, 3.5 >
                rotate z*10                
                finish { ambient 0.3
                         diffuse 0.4
                         specular 0.8
                         roughness 0.05
                         reflection 0.05 }//end finish
              } // end texture
   #end              
      } // end Front Arch

// **************************************************************

//   DEFINE   a planter box: 2x 1.2y 6z:
#declare Planter_Box_1 =
object {                            
   difference {
      object { UnitBox
               scale < 1.0, 0.6, 3.0 >
             } // end Box outside
      object { UnitBox
               scale < 0.9, 0.5, 2.9 >
               translate y*0.11
              } // end Box inside
      #if ( ShowDetails )
         texture { Gray75_Tex }
      #else
         texture { Spex
         finish { ambient 0.3
                  diffuse 0.4
                  reflection 0.2 } //end finish
                 } // end texture
      #end
              } // end difference
       } // end planter box

// **************************************************************

//   DEFINE   a planter box: 7x 2y 7z:
#declare Planter_Box_2 =
object {                            
   difference {
      object { UnitBox
               scale < 6.0, 1.0, 6.0 >
             } // end Box outside
      object { UnitBox
               scale < 5.5, 1.0, 5.5 >
               translate y*0.2
              } // end Box inside
      #if ( ShowDetails = 0 )
         texture { Magenta_Tex }
      #else
         texture { Spex
         finish { ambient 0.3
                  diffuse 0.4
                  reflection 0.25 } //end finish
                 } // end texture
      #end
              } // end difference
       } // end planter box 2

// **************************************************************

//    DEFINE  Front Yard: 30x 35z:
#declare Front_Yard =
union {

object { Floor_One scale < 2.5,1.5,2.5 > texture { Blue_Tex }}//temp pool   

   // north section
   object { Tiled_Floor_2  translate <   0, 0, 12.5 > }       
   object { Tiled_Floor_1  translate <  10, 0, 12.5 > }
   object { Tiled_Floor_1  translate < -10, 0, 12.5 > }
   // middle section
   object { Tiled_Floor_2  translate <  10, 0, 0 > }     
   object { Tiled_Floor_2  translate < -10, 0, 0 > }
   object { Tiled_Floor_1              // north of center section
            scale < 1, 1, 0.25 > 
            translate < -10, 0, 6.125 > }
   object { Tiled_Floor_1 
            scale < 1, 1, 0.25 > 
            translate <  10, 0, 6.125 > }
   object { Tiled_Floor_1 
            scale < 1, 1, 0.25 > 
            translate <   0, 0, 6.125 > }
   object { Tiled_Floor_1              // south of center section
            scale < 1, 1, 0.25 > 
            translate < -10, 0, -6.125 > }
   object { Tiled_Floor_1 
            scale < 1, 1, 0.25 > 
            translate <  10, 0, -6.125 > }
   object { Tiled_Floor_1 
            scale < 1, 1, 0.25 > 
            translate <   0, 0, -6.125 > }
   // center cross:
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.5 >
            translate < -3.75, 0, 0 > }
   object { Tiled_Floor_1 
            scale < 0.5, 1, 0.25 > 
            translate < 0, 0, -3.75 > }
   object { Tiled_Floor_1 
            scale < 0.5, 1, 0.25 > 
            translate < 0, 0,  3.75 > }
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.5 >
            translate < 3.75, 0, 0 > }
   // corners of the cross:
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.25 >
            translate < -3.75, 0, 3.75 > }
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.25 >
            translate <  3.75, 0, 3.75 > }
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.25 >
            translate < -3.75, 0, -3.75 > }
   object { Tiled_Floor_1 
            scale < 0.25, 1, 0.25 >
            translate <  3.75, 0, -3.75 > }
   // south section
   object { Tiled_Floor_2  translate <   0, 0, -12.5 > }
   object { Tiled_Floor_1  translate <  10, 0, -12.5 > }
   object { Tiled_Floor_1  translate < -10, 0, -12.5 > }
   // planter boxes:
   object { Planter_Box_1  translate <  3, 1, 12.5 > }
   object { Planter_Box_1  translate < -3, 1, 12.5 > }
   object { Planter_Box_1  translate <  12, 1, 0 > }
   object { Planter_Box_1  translate < -12, 1, 0 > }
   object { Planter_Box_1  translate <  12, 1, -12.5 > }
   object { Planter_Box_1  translate < -12, 1, -12.5 > }
      } // end union Front Yard

// *******************************************************************
//     2.                        Landscaping
// *******************************************************************

//    DEFINE trees, shrubs, grass, etc.:

// *******************************************************************
// *******************************************************************
//    L_SCAPE.INC         Michael Brendan Hurley          1999-2000
//    www.geocities.com/mbrendanh/                 mbhcgc@saber.net
// *******************************************************************
// *******************************************************************

