// *******************************************************************
// O_HOME00.POV                                              19 Nov 99
// Our_Home Elements Tester 
// *******************************************************************

#version 3.1;

#include "o_home00.inc"          // declarations specific to Our_House

// *******************************************************************
// Define Ambient Lights                                             
// *******************************************************************

#if ( TestMode )
   light_source { < 140, 150, -200 >  color White }
//   light_source { < 140, 150, -200 >  color White  shadowless }
#else
   light_source { < 140, 150, -200 >  color White }
/*
   light_source {
      0*x                              // position (translated below)
      color rgb 1.0                    // color
      area_light < 2,0,0 > < 0,0,2 >   // light's spread
      2, 2                             // total number of lights
      adaptive 0                       // 0,1,2,3... 
      jitter                           // random softening
      translate < 140, 150, -200>      // <x y z> position of light
             } // end area light
*/
#end

// *******************************************************************
// Define Sky                                                        
// *******************************************************************

//background { color Black }
background { color LightBlue }
//background { color Gray50 }

//sky_sphere { pigment  { Black } }                // real night
sky_sphere { pigment  { LightBlue } }            // day
//sky_sphere { pigment { Bright_AquaBlue4 scale < 65, 2, 15 > } }

// *******************************************************************
// Define Spot Lights  
// *******************************************************************

// Define Test Lights
#declare Test_Spot =
light_source {
   < 20, 30, 15 >
   color White
   spotlight
   radius 40
   falloff 15
   tightness 15
   point_at < 20, 0, 15 >
             } // end Test Spotlight 1

// *******************************************************************
// Define Camera
// *******************************************************************

#declare Beauty_Shot =
camera {
   direction <    0,  0,    2 >
   location  < -180, 45, -230 >         // SE of center
   look_at   <   -5, 15,    0 > }       // The Beauty Shot

#declare Mid_Beauty_Shot =             // home1.jpg 
camera {
   direction < 0, 0, 2 >
   location  < -80, 40, -170 >         // 3/4 ul viewpoint
   look_at   < -10,  0,    0 > }
       
#declare Camera_SE =
camera {
   direction <   0,  0, 5 >
   location  <   10, 27, -45 >         // SE of center
   look_at   < 0,  2.5,    0 > }       //

#declare Camera_SW =
camera {
   direction < 0, 0, 3 >
   location  < -10, 5, -15 >           // SW of center
   look_at   <  5, 5,  10 > }         //            medium

#declare Camera_North =
camera {
   direction < 0, 0, 4 >
   location  < 0, 10, 100 >           // North  of center
   look_at   < 0, 10,  0 > }         // center

#declare Camera_South =                // 2/-20=view exactly y*10 units
camera {                               // 3/-30=   "         ", etc.
   direction < 0, 0, 2 >
   location  < 0, 30, -140 >             // south of cntr
   look_at   < 0, 10, 0 > }           
                                       
#declare Camera_West =
camera {
   direction < 0, 0, 4 >
   location  < -100, 5, 5 >             // West
   look_at   <    0, 5, 5 > }           

#declare Camera_East =
camera {
   direction <   0,  0, 6 >
   location  < 80, 0, 0 >         // East
   look_at   <  0, 0, 0 > }       

#declare Camera_Above =
camera {
   direction < 0, 0, 2 >
   location  < 0, 160, -1 >         // Above
   look_at   < 0,  0,  0 > }           

#declare Quarter_Above =
camera {
   direction < 0, 0, 2 >
   location  < -120, 60, -120 >        // 3/4 ul viewpoint
   look_at   <  0,  5,    0 > }      //    cntr

// *******************************************************************
//  Define Test Scene:
// *******************************************************************

// CAMERA
//camera { Beauty_Shot }
//camera { Mid_Beauty_Shot }
//camera { Camera_SE }
//camera { Camera_SW }
//camera { Camera_North }
//camera { Camera_South }
//camera { Camera_West }
//camera { Camera_East }
//camera { Camera_Above }
camera { Quarter_Above }

// LIGHTS
//object { Test_Spot }                   

// FLOOR
object { Clip_Floor }
//object { Test_Floor }

// *******************************************************************
//  Generate this image :
// *******************************************************************

// ************************************************************** 
// **************************************************************
// **************************************************************
// **************************************************************
// **************************************************************



//   DEFINE  template scene:
#declare Scene =
union {
   object { Our_House  translate y*5  }   // to ground level
      } // end test scene

object { Scene }                       // centered <0,0,0>



//object { Scene  translate y*5 }        // to ground level
//object { Mark01 } // center
//object { Atrium translate y*7.5 }      // to ground level
//object { Our_House  translate y*5  }   // to ground level

// *************************************

//#declare GridOn = true;
#declare GridOn = false;

#if ( GridOn )
   object { Grid10XY } // vert rods
//   object { Grid10XZ scale <10,1,10>} // horz rods
//   object { Grid5XY } // vert balls
//   object { Mark01 } // center
//   object { Man01  translate < 2, 0, 5 > }
#end 

// *******************************************************************
// *******************************************************************

/*    STORAGE OF TESTED OBJECTS:

object { Frame_A  texture { Blue_Tex } }    // 10x 10y
object { Frame_B  texture { Blue_Tex } }    // 10x 5y
object { Frame_C  texture { Blue_Tex } }    // 10x 2.5y
object { Frame_D  texture { Blue_Tex } }    // 5x 10y
object { Frame_E  texture { Blue_Tex } }    // 5x 5y 
object { Frame_F  texture { Blue_Tex } }    // 5x 2.5y 

object { Panel_A  texture { Red_Tex } }     // 10x 10y
object { Panel_B  texture { Red_Tex } }     // 10x 5y
object { Panel_C  texture { Red_Tex } }     // 10x 2.5y
object { Panel_D  texture { Red_Tex } }     // 5x 10y
object { Panel_E  texture { Red_Tex } }     // 5x 5y
object { Panel_F  texture { Red_Tex } }     // 5x 2.5y

object { WallFrame_4010 }
object { WallFrame_4005 }

object { Globe_Light }
object { WallLamp_A }
object { WallLamp_B }
object { WallLamp_C }

   object { Atrium_SFrame_1 translate z*-20 }
   object { Atrium_NFrame_1 translate z*20  }
   object { Atrium_WFrame_1  translate x*-15 }
   object { Atrium_EFrame_1  translate x*15  }
   object { Atrium_SPanel_1 }  //WOOD
   object { Atrium_SPanel_2 }  //GLASS v.1 clear
   object { Atrium_SPanel_3 }  //GLASS v.2 colored
   object { Door_Front  translate y*-2.5 }
   object { Roof_Three  scale < 11, 3, 8.5 >  translate y*7.55 }
   object { Atrium_Deco_Trim  translate y*10 } 
object { Atrium translate y*7.5 }

   object { EastRoom_NFrame_1 }
   object { EastRoom_SFrame_1 }
   object { EastRoom_EFrame_1 }
   object { EastRoom_WFrame_1 }
   object { EastRoom_NPanel_1  translate <  0, 0,  10 > }
   object { EastRoom_SPanel_1  translate <  0, 0, -10 > }
   object { EastRoom_EPanel_1  translate < 20, 0,   0 > }
   object { East_Deco_Trim }
object { East_Room  translate x*35 }     // east of atrium

   object { EastRoom_NFrame_1  rotate z*180  translate <   0, 0,  10 > }
   object { EastRoom_SFrame_1  rotate z*180  translate <   0, 0, -10 > }
   object { EastRoom_EFrame_1  rotate z*180  translate < -20, 0,   0 > }
   object { EastRoom_WFrame_1  rotate z*180  translate <  20, 0,   0 > }
   object { WestRoom_NPanel_1                translate <   0, 0,  10 > }
   object { WestRoom_SPanel_1                translate <   0, 0, -10 > }
   object { WestRoom_WPanel_1                translate x*-20 }
object { West_Room  translate x*-35 }    // west of atrium

object { North_Room }
 
   object { BigArch_1 translate < 0, 0, -5 > }
   object { BigArch_Posts  scale < 1, 0.8, 1 > translate < 0, -3.75, -5 > }
   object { Front_Arch  translate < 0, 7.5, -25 > }
   object { Planter_Box }
   object { Tiled_Floor_1 }
   object { Tiled_Floor_2 }
object { Front_Yard  translate < 0, -0.25, -37.5 > }

object { Pane_Square_1 }
object { Pane_Tri_1 }
object { Tri_Up }
object { Tri_Down }
object { Tri_Left }
object { Tri_Right }

   object { SG_Frame_1 }
   object { SG_Panel_1 }
object { SG_Window_1  scale < 1.5, 0.8, 1 > } //scaled for Frame_C

   object { SG_Frame_2 }
   object { SG_Panel_2 }
object { SG_Window_2 } scaled for Frame_A

   object { Frame_Diamond_1 }
   object { SG_Frame_3 scale < 0.55, 0.55, 0 > } //scaled for Frame_E
   object { SG_Panel_3 scale < 0.55, 0.55, 0 > } }
object { SG_Window_3 }

   object { SG_Panel_4 scale < 0.55, 0.55, 0 > }
   object { SG_Frame_4 scale < 0.55, 0.55, 0 > } //scaled for Frame_E
object { SG_Window_4 }

   object { SG_Panel_5 scale < 0.55, 0.55, 0 > }
   object { SG_Frame_5 scale < 0.55, 0.55, 0 > } //scaled for Frame_E
object { SG_Window_5 }

object { SG_Window_6 }

   object { SG_Panel_6 }
   
   object { D_Panel_1 }
   object { D_Panel_2 }
object { G_Window_1 }

   object { Window_Panel_2 }
   object { Window_Frame_2 }
object { G_Window_2 }

object { FirePlace_A  translate < 0, -3.25, -1 > }

texture { T_Wood2  rotate < 10,0,5 >  scale < 1,10,1 > }// y axis posts
texture { T_Wood2  rotate < 0,-100,0 > }// x axis posts
texture { T_Wood2  scale <1,1,5 > }//z axis posts

// *************************************
text { ttf "crystal.ttf", "Frame NA", 2, 0
   translate <-2, 0, 0>
   pigment { color rgb <1, 0.2, 0.2> }
   finish { ambient 0.2   diffuse 0.6
            phong 0.3     phong_size 100 }
   scale <4, 4, 1>
     } // end text
// *************************************

   #if ( TestMode )
      texture { Red_Tex }
   #else
      texture { T_Wood2 }
   #end

// *************************************

*/

// *******************************************************************
// *******************************************************************
//    Michael Brendan Hurley, SDE, Ltd.                   Fall 1999
// *******************************************************************
