// *******************************************************************
// BRENDAN.INClude file   for POV WIN 3.1g   Ver 2.0 Fall 99-Winter 00
// Definitions of assorted basic objects and effects             *****
// *******************************************************************

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "woods.inc"
#include "tex_home.inc"

// *******************************************************************
// CONSTANTS:
// *******************************************************************

// *******************************************************************
//                           Plain Textures
// *******************************************************************
 
//    DEFINE  flat latex paint finish:
#declare PlainFinish =
finish { ambient 0.3
         diffuse 0.3
         specular 0.4
         roughness 0.01 }

// *************************************
#declare Red_Tex =
texture { pigment { Red  quick_color Red }
          finish { PlainFinish } }

// *************************************
#declare Blue_Tex =
texture { pigment { Blue  quick_color Blue }
          finish { PlainFinish } }

// *************************************
#declare Green_Tex =
texture { pigment { Green  quick_color Green }
          finish { PlainFinish } }

// *************************************
#declare Yellow_Tex =
texture { pigment { Yellow  quick_color Yellow }
          finish { PlainFinish } }

// *************************************
#declare Orange_Tex =
texture { pigment { Orange  quick_color Orange }
          finish { PlainFinish } }

// *************************************
#declare Magenta_Tex =
texture { pigment { Magenta  quick_color Magenta }
          finish { PlainFinish } }

// *************************************
#declare GreenYellow_Tex =
texture { pigment { GreenYellow  quick_color GreenYellow }
          finish { PlainFinish } }

// *************************************
#declare LB_Tex =
texture { pigment { LightBlue  quick_color LightBlue }
          finish { PlainFinish } }

// *************************************
#declare Violet_Tex =
texture { pigment { Violet  quick_color Violet }
          finish { PlainFinish } }

// *************************************
#declare Goldenrod_Tex =
texture { pigment { Goldenrod  quick_color Goldenrod }
          finish { PlainFinish } }

// *************************************
#declare Coral_Tex =
texture { pigment { Coral  quick_color Coral }
          finish { PlainFinish } }

// *************************************
#declare Orchid_Tex =
texture { pigment { Orchid  quick_color Orchid }
          finish { PlainFinish } }

// *************************************
#declare Gold_Tex =
texture { pigment { Gold  quick_color Gold }
          finish { PlainFinish } }

// *************************************
#declare Tan_Tex =
texture { pigment { Tan  quick_color Tan }
          finish { PlainFinish } }

// *************************************
#declare Brown_Tex =
texture { pigment { Brown  quick_color Brown }
          finish { PlainFinish } }

// *************************************
#declare DarkWood_Tex =
texture { pigment { DarkWood  quick_color DarkWood }
          finish { PlainFinish } }

// *************************************
#declare FireBrick_Tex =
texture { pigment { Firebrick  quick_color Firebrick }
          finish { PlainFinish } }

// *************************************
#declare White_Tex =
texture { pigment { White  quick_color White }
          finish { PlainFinish } }

// *************************************
#declare Black_Tex =
texture { pigment { Black  quick_color Black }
          finish { PlainFinish } }

// *************************************
#declare Gray_Tex =
texture { pigment { Gray  quick_color Gray }
          finish { PlainFinish } }

// *************************************
#declare Gray25_Tex =                  // dark
texture { pigment { Gray25  quick_color Gray25 }
          finish { PlainFinish } }

// *************************************
#declare Gray50_Tex =
texture { pigment { Gray50  quick_color Gray50 }
          finish { PlainFinish } }

// *************************************
#declare Gray75_Tex =
texture { pigment { Gray75  quick_color Gray75 }
          finish { PlainFinish } }

// *************************************
#declare Gray95_Tex =                  // light
texture { pigment { Gray95  quick_color Gray95 }
          finish { PlainFinish } }

// *******************************************************************
//  Define Floors                                             
// *******************************************************************

#declare Check_Floor =
plane { y, 0
   pigment {
      checker color White color Black
      scale 10
           } //end pigment
   finish {
      ambient 0.2
      diffuse 0.8
          } //end finish
   hollow
      } // end Plane Check Floor

// **************************************************************

#declare Gray50_Floor =
plane { y, 0
   pigment {
      colour Gray50
           } //end pigment
   finish {
      ambient 0.2
      diffuse 0.8
          } //end finish
   hollow
      } // end Gray 50 Floor

// **************************************************************

#declare Grass_Floor =
plane { y, 0
   texture { Grass
             scale 4
           } //end texture
   finish {
      ambient 0.2
      diffuse 0.9
          } //end finish
   hollow
      } // end Grass Floor

// **************************************************************

#declare Test_Floor =
plane { y, 0
   texture { Gray95_Tex
           } //end texture
   finish {
      ambient 0.3
      diffuse 0.8
          } //end finish
   hollow
   clipped_by { UnitBox scale < 1000, 1, 1000 > }
      } // end Test Floor

// **************************************************************

#declare Clip_Floor =
plane { y, 0
   texture { GreenYellow_Tex
             scale 4
           } //end texture
   finish {
      ambient 0.2
      diffuse 0.8
          } //end finish
   hollow
   clipped_by { UnitBox scale < 1000, 1, 1000 > }
      } // end Clipped Floor

// *******************************************************************
//  Define Basic Objects                                              
// *******************************************************************

//  Define a Test Box   edge = 5 units
#declare TestBox =
object { UnitBox  scale 2.5 }

// **************************************************************

//  Define a Test Sphere  diameter = 0.50
#declare TestSphere =
object { sphere { < 0, 0, 0 > 0.25 } } // end test ball

// **************************************************************

//    DEFINE  cylinders 1 unit primary axis, flat-ended:
#declare PostX1 =
object { Disk_X  scale < 0.50, 0.25, 0.25 > } 

#declare PostY1 =
object { Disk_Y  scale < 0.25, 0.50, 0.25 > } 

#declare PostZ1 =
object { Disk_Z  scale < 0.25, 0.25, 0.50 > } 


// **************************************************************

//    DEFINE  1x0.5x0.5 unit boxes in each axis: 
#declare CubeX1 =
box { < -0.50, -0.25, -0.25 > < 0.50,  0.25, 0.25 > }

#declare CubeY1 =
box { < -0.25, -0.50, -0.25 > < 0.25,  0.50, 0.25 > }

#declare CubeZ1 =
box { < -0.25, -0.25, -0.50 > < 0.25,  0.25, 0.50 > }

// **************************************************************

//    DEFINE  10x0.5x0.5 unit rods in each axis:                 
#declare XRod =
object { PostX1  scale < 10, 0.25, 0.25 > }

#declare YRod =
object { PostY1  scale < 0.25, 10, 0.25 > }

#declare ZRod =
object { PostZ1  scale < 0.25, 0.25, 10 > }

// **************************************************************

//    DEFINE  a 3-axis grid marker: each bar = 10 units end to end
#declare Mark01 =
union {
   object { XRod }
   object { YRod }
   object { ZRod }
   texture { Orange_Tex }
      } // end Marker 1

// **************************************************************

//    DEFINE  a 6-foot tall human marker:
#declare Man01 =
union {
object { PostY1 scale < 0.5, 6, 0.5 >     // body
                texture { Orange_Tex } }
object { sphere { < 0, 0, 0 > 0.45           // head
                texture { Green_Tex }
                translate y*3 } }
       } // end Manikin

// *******************************************************************
//                          GRID MARKERS                         
// *******************************************************************

//   DEFINE  markers +/- 5x 5y:
#declare Grid5XY =
union {
   object { TestSphere  translate <  0,  0, 0 > }     //cntr
   object { TestSphere  translate < -5,  5, 0 > }     //ul
   object { TestSphere  translate <  5,  5, 0 > }     //ur
   object { TestSphere  translate < -5, -5, 0 > }     //ll
   object { TestSphere  translate <  5, -5, 0 > }     //lr
   texture { Red_Tex }
      } // end grid 5x 5y

// **************************************************************

//    DEFINE  a horizontal grid: 10x 10z:
#declare Grid10XZ =
union {
   object { XRod }
   object { XRod  translate z*1 }
   object { XRod  translate z*2 }
   object { XRod  translate z*3 }
   object { XRod  translate z*4 }
   object { XRod  translate z*5 }
   object { XRod  translate z*-1 }
   object { XRod  translate z*-2 }
   object { XRod  translate z*-3 }
   object { XRod  translate z*-4 }
   object { XRod  translate z*-5 }
   object { ZRod }
   object { ZRod  translate x*1 }
   object { ZRod  translate x*2 }
   object { ZRod  translate x*3 }
   object { ZRod  translate x*4 }
   object { ZRod  translate x*5 }
   object { ZRod  translate x*-1 }
   object { ZRod  translate x*-2 }
   object { ZRod  translate x*-3 }
   object { ZRod  translate x*-4 }
   object { ZRod  translate x*-5 }
   texture { Black_Tex }
      } // end grid 10x 10z

// **************************************************************

//   DEFINE  a vertical grid: 10x 10y:
#declare Grid10XY =
union {
   object { XRod }
   object { YRod }
   object { XRod  translate y*1 }
   object { XRod  translate y*2 }
   object { XRod  translate y*3 }
   object { XRod  translate y*4 }
   object { XRod  translate y*5 }
   object { XRod  translate y*-1 }
   object { XRod  translate y*-2 }
   object { XRod  translate y*-3 }
   object { XRod  translate y*-4 }
   object { XRod  translate y*-5 }
   object { YRod  translate x*1 }
   object { YRod  translate x*2 }
   object { YRod  translate x*3 }
   object { YRod  translate x*4 }
   object { YRod  translate x*5 }
   object { YRod  translate x*-1 }
   object { YRod  translate x*-2 }
   object { YRod  translate x*-3 }
   object { YRod  translate x*-4 }
   object { YRod  translate x*-5 }
   texture { Black_Tex }
      } // end 10x 10y grid

// **************************************************************

// X-AXIS  Red spheres spaced 50 units apart centered on < 0 0 0 >

#declare X_Axis =
union {
sphere { < 0, 0, 0 >, 2 
         pigment { Red } //end pigment
       } // end Origin Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < 50, 0, 0 >
       } // end Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < 100, 0, 0 >
       } // end Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < 150, 0, 0 >
       } // end Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < -50, 0, 0 >
       } // end Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < -100, 0, 0 >
       } // end Sphere
sphere { <0, 0, 0>, 1
         pigment { Red } //end pigment
         translate < -150, 0, 0 >
       } // end Sphere
      } // end Union X_Axis

// **************************************************************

// Z-AXIS  Green spheres spaced 50 units apart centered on < 0 0 0 >

#declare Z_Axis =
union {
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, 50 > } // end Sphere
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, 100 > } // end Sphere
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, 150 > } // end Sphere
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, -50 > } // end Sphere
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, -100 > } // end Sphere
sphere { <0, 0, 0>, 1
   pigment { Green } //end pigment
   translate < 0, 0, -150 > } // end Sphere
      } // end union Z Axis

// *******************************************************************
// *******************************************************************
//   BRENDAN.INC ver 2.0     Michael Brendan Hurley        Fall 1999
// *******************************************************************
// *******************************************************************
