//Final - just needs figures

#version unofficial MegaPov 0.5;
#include"colors.inc" 

#include"GMF.inc" 
#declare Rad = 2500000 / (2 * pi);
 
global_settings {
max_trace_level 155
  assumed_gamma 1.0   
}    
    
#declare Image_Length = 800;
#declare Image_Height = 375;

camera
{
  location <-15,6,80>
  direction 1/2
  right Image_Length/Image_Height*x
  look_at <0,18,0>
}

light_source {
<1500, 2000,-5500> 
color rgb<.75,.65,.5> 
//color rgb<1,.75,.4>   
media_attenuation on 
media_interaction on 
rotate y*-20
}

//fill in
light_source {
<-5000,1000,5000>
//rgb <.6,.25,0>/6
//rgb <.45,.25,.6>/3 
//rgb <.45,.35,.55>/3 
rgb <.525,.4,.45>/3 
shadowless 
media_attenuation off 
media_interaction off
rotate y*25
} 

light_source {< 1200, 1100,-5500> 
glow{ type 1 
	size 1500
	//color<1,1,.25>/2 
	color<1,1,.5>/3
	rotate y*-30  
	}
	
    }
    
sky_sphere
{
  pigment
  {
    gradient y turbulence .2
    color_map { [0.0 color rgb <1,.9,.65> /1.125 ] [0.8 color rgb<.7,.8,1>/1.125] }rotate x*15 
  }
} 

//-------------------------------------------------

$ Ground_on = 1; 
$ Clouds_on = 0;
$ Grass_on = 0 ;
$ Fog_on = 1; 
 
//-------------------------------------------------
#if (Ground_on = 1)

#declare GMTex = texture{
	pigment{
	ripples 
	color_map {
		[0 rgb <1,.85,.75>*2]
		[1 rgb <.85,.75,.5>*2]} //.85
			scale <1, 5,10>/3 
			rotate y*-20
			warp{turbulence .375}
			}
	finish { ambient-.0001 diffuse .9 specular .25 roughness .01 crand .05}
	normal{
		average normal_map{
			[0 ripples .0075 scale <2, 5,10>/3 warp{turbulence .25}rotate y*-20 translate x*.5]
			[.5 agate normal_map{[0 bumps 1 scale .1][.5 bumps.0001]}scale 5 rotate y*76]
			}
    	}	
}

#declare R = seed(463);

#declare GM =
height_field {
pattern 1000, 1000 {
hf_gray_16
	spotted
		color_map {
			[ 0.0 rgb 0 ]
			[ 1.0 rgb .1 ]
		}
		rotate y*35
warp {turbulence 2 lambda .25 }
scale 0.05
}
smooth
}

object{GM rotate y*-18 scale <350,50,600>translate <-50, 0, -50>texture{GMTex}}

#end 

//------------------------------------------------------------
#if (Grass_on = 1)

$ TracedObj = union{
$ Norm = <0,0,0>;
$ Xpos = 0;
$ Zpos = 0; 

$ Pig=pigment{spotted color_map{[0 rgb 1][1 rgb 0]}scale .0325 translate <-1,0,005>} //5
 
#while (Xpos<1)

   #while (Zpos<1)
        
       $ SPos = <Xpos,1,Zpos>;
       $ PP=eval_pigment( Pig, <Xpos,0,Zpos> );
       $ XX = PP.x;
           // #warning concat(str(XX,10,3),"\n")
       $ Inter = trace (GM,SPos,<0,-1,0>, Norm ); 
                        
            #if (vlength(Norm)!=0 & XX >.45)
              #if(Inter.y<.05 )
				object{Grass scale <.00007,.0006+(rand(R)/2000),.000065> rotate y*rand(R)*360 
				translate <Inter.x+(rand(R)/30),Inter.y,Inter.z+(rand(R)/30)>
				}
			  #end
            #end 
                        
    $ Zpos = Zpos +.00275;
    #end           
    $ Zpos = 0;
  $ Xpos = Xpos +.00275; 
 #end 
}
object{TracedObj rotate y*-18 scale <350,50,600>translate <-50, -.5, -50>}
  
#end
//-----------------------------------------------------------------

plane{y,-.01 
	pigment{rgbt<0,.5,.5,0>}
		normal{ bumps 5 scale 10}	
			finish{reflection .3 phong 1 phong_size .05}
			hollow					
			}
			
//------------------------------------------------------------------
#if(Clouds_on = 1)

difference {
  sphere {0,Rad}
  sphere {0,Rad-7000}
  material{
    texture{
      pigment{ rgbf 1}
    }
    interior{
      media{            
        scattering {3, .01 extinction 0.2}
        scattering {3, <.011,.013,.01> extinction 0.5}//.5
        
        method 3
        samples 18,18 
        intervals 1
        
        density {
          wrinkles
          color_map {           
            [0 rgb 0]           
            [0.5 rgb 0]     
            [0.6 rgb 0.2]    
            [1 rgb 0.5]         
          }                     
          turbulence .3 lambda 3 //lambda 3.5
          scale <200,100,400>*120  //y was 100
          rotate y*-60
          translate <100,Rad-9000,0> 
        }
        

         
      }
    }
  }
  rotate y*22 
  rotate x*.75  //.75
  translate <0,12000-Rad,0>
  hollow
}

#end
//------------------------------------------------------------

#if(Fog_on = 1)

fog {fog_type 2 
distance 1000// 2000
rgb <1,.75,.45>*.75
fog_offset 0
fog_alt 25//50
}

#end

//-------------------------------------------------------------

#declare Rocks =
height_field{
  tga "rocks2.tga"     
inverse 
texture {pigment{agate pigment_map{[0 rgb <1,.75,.4>/1.2][.99 rgb 1]}scale .01}
normal{ average normal_map{[0 bumps 5 scallop_wave][1 dents 5 triangle_wave]}scale .025}
finish{ambient-.0001 diffuse .9}
}
smooth        
translate <-.5,-.5,0> 
}
 
 
 object{Rocks translate<-.5,.1,-1> scale <75,25,75>} 
  object{Rocks rotate y*180 translate<-.5,.1,-.85> scale <55,15,55>}