// Persistence of Vision Ray Tracer Scene Description File
// File: pensacola lighthouse.pov
// Vers: 3.1g, MegaPov 0.5a
// Desc: Historic Pensacola Lighthouse
// Date: 2000.7
// Auth: Bob Hughes
// Mail: persistenceofv@aol.com?subject=Pov-Scene
// Note: version 2. Can be used without MegaPov.
//       Facsimile.

/*
Pensacola Lighthouse Facts 
Built - 1857-58 
First lit - January 1, 1859
Designer - Captain John Newton, U.S. Army Corps of Engineers
Cost of construction including keeper's quarters and range beacons - $55,000
Construction materials - brick with concrete fill; granite foundation
Height of focal plane (light beam) above sea level - 191 feet 
Height of focal plane above ground - 150 feet 
Number of steps to lantern - 177 
Diameter of tower at base - 30 feet (granite block foundation width?)
Diameter of tower at top - 15 feet 
*Height of white/black paint border - 58 feet?
*Height of base of lower deck, deck, rail top - 130 feet, 135.5 feet, 140.5 feet
*Height of base of upper deck, deck, rail top - 144.5 feet, 145 feet, 149 feet
*Length of upper tower (both lower and upper decks to roof bottom) - 34.667 feet
*Height of lantern room base, top - 145 feet, 155 feet
*Length of lantern room - 10 feet
*Height of roof base, top, gas vent top - 155 feet, 160 feet, 164 feet
*Height of lightning rod top - 171 feet?
Optic - 1st order Fresnel lens 
Light Source - electric bulb, pair used for auto-replacing when one fails
Range - 27 miles 
Characteristic of light - flashing white; 20 second interval (non-rotating?)
Characteristic of tower - lower third white; upper two thirds black 
Current owner and operator - U. S. Coast Guard.
*/

#declare Use_MP=yes; // MegaPov or not?
#declare Use_Media=no; // Radiosity or not?
#declare Rad=yes; // Radiosity or not?
#declare DN=.9;
#declare DNs=.33;
#declare DNr=.6;
#declare LRp=-4.5;
#declare UDp=.6;
#declare NFp=.6;
#declare LRl=.75;
#declare UDl=.875;
#declare NFl=2;
#declare Z=.6;

#if (Use_MP=yes)
#version unofficial MegaPov 0.5;
#end

global_settings {
        assumed_gamma 2.6
        max_trace_level 11
#if (Use_MP & Rad = yes)
 ambient_light <.1,.05,.025>
 ini_option "+qr"
 radiosity {
pretrace_start .08
pretrace_end .01
         media off
         normal on
         count 150
         nearest_count 4
         error_bound .321
         low_error_factor .321
         gray_threshold .05
         recursion_limit 1
         minimum_reuse .0167
         brightness 1.5
          }
#else
 ambient_light <1,1.025,1.05>*.75
// photons {spacing .1 gather 20,100 autostop 0 media on}
#end
}

#declare ClockL=clock;

/*
// Chris Colefax's ClockMod Include needed for animation
#declare clock_type="A"
#include "clockmod.inc"
#declare ClockML=.5;//1-mclock;
#declare ClockMC=.45;//mclock;

light_source {-9999*z, 1.5//<1.5-(.75*ClockML),1.5-(.95*ClockML),1.5-(1.1*ClockML)>
         rotate <90-(87.5*ClockML),-90+(180*ClockML),0> rotate 80*y
 media_interaction off
}

light_source {9999*y,<.15,.25,.33>*2*ClockML
 media_interaction off shadowless
}

camera {location <-30,5.5,-350+(80*ClockMC)>
        angle 60
       rotate <(70*ClockMC),-30+(45*ClockMC),0> rotate <4.5,180,0>
        look_at <-12.5+(-5*ClockMC),80+(40*ClockMC),(-7.5*ClockMC)>
}
*/

light_source {-9999*z, <1.5,1.45,1.4>*.9*DN
         rotate <5+(79*DNr),115-(85*DNr),-90>
 media_interaction off
//photons {reflection off refraction off}
}

light_source {-9999*z,<.15,.25,.33>*1.5*DNs
         rotate <89,1,0>
 media_interaction off shadowless
//photons {reflection off refraction off}
}

camera {location <-40*LRp,155*UDp,-400*NFp> // <-40,155*.8,400*.525>
        angle 67*Z
       rotate <-22.5,0,0>
        look_at <-30*LRl,90*UDl,-15*NFl>
}

// no sky_sphere here because of media being used
sphere{0,1
 texture {
  pigment {
    gradient y
    color_map {
         [0 color rgb <.8,.75,.85>*<1,1.1,1.075>]
         [.1 color rgb <.5,.75,1>*<.9,1.15,1.1>]
         [.4 color rgb <.33,.67,.9>]
         [1 color rgb <.25,.33,.67>]
          }
  }
  finish {
#if (Rad=yes)
        ambient .6 diffuse .6 // -(.5*ClockML)
#else
        ambient .67 diffuse .33
#end
        }
 }
/*
 texture {
  pigment {
    bozo turbulence .4 frequency 3 octaves 9
    color_map {
         [0 color rgbf <1,.725,.775,.05>]
         [.05 color rgbf <1.15,1.075,.7,.1>]
         [.05 color rgbf <1,.725,.775,.05>]
         [.1 color rgbf <1.15,1.075,.7,.1>]
         [.1 color rgbf <1,.725,.775,.05>]
         [.2 color rgbf <1.15,1.075,.7,.1>]
         [.25 color rgbf 1]
         [1 color rgbf 1]
          } sine_wave scale 1
  }
  finish {ambient 1.5-(.5*ClockML) diffuse .5} // try a diffuse of 1.5 for radiosity
 }
*/
   scale 10000
 hollow
}

fog {fog_type 2
        distance 2000
        color <.9,.925,.93>*.9
        fog_alt 50
        fog_offset -40
}

#if (Use_MP & Use_Media = yes)
media { method 2
  intervals 3 // raise this if more lights are used
  scattering { 5, rgb .01 extinction .75 eccentricity .25}
  samples 9, 9
  density {rgb 0.01}
}
#end

/*
plane {y,0
        pigment {granite frequency 2 color_map {
         [0 color rgb <.8,.8,.8>]
         [.1 color rgb <.85,.85,.85>]
         [.3 color rgb <.775,.75,.7>]
         [.67 color rgb <.75,.7,.65>]
         [.75 color rgb <.67,.5,.33>]
         [.8 color rgb <.5,.33,.25>]
         [.99 color rgb <.2,.45,.35>]
         } scallop_wave scale 50}
        normal {granite -1.5 scale 1.5 ramp_wave}
        finish {ambient .25 diffuse .75 specular .025 roughness .25}
}

#declare BluffMap=function {pigment {image_map {png "pensacolalh.png"}}}

isosurface {function {y-BluffMap(x,y,z)}
        method 2
       // threshold 1
        eval
      contained_by {box {<-300,0,-300>,<300,40,300>}}
        pigment {granite frequency 2 color_map {
         [0 color rgb <.8,.8,.8>]
         [.1 color rgb <.85,.85,.85>]
         [.3 color rgb <.775,.75,.7>]
         [.67 color rgb <.75,.7,.65>]
         [.75 color rgb <.67,.5,.33>]
         [.8 color rgb <.5,.33,.25>]
         [.99 color rgb <.2,.45,.35>]
         } scallop_wave scale 50}
        normal {granite -.5 scale 1.5}
        finish {ambient .25 diffuse .75 specular .025 roughness .25}

   translate -25*y
}
*/

#if (Use_MP=yes)
// slope dependant texturing
#declare FA=255; #declare FN=1;
#declare DrySand=
texture {pigment {granite color_map {
        [0 rgb <.96,.97,.99>][.5 rgb <.96,.77,.69>*.75][1 rgb <.65,.77,.625>*.67]} scallop_wave scale .039}
 normal {wrinkles .4 ramp_wave turbulence .3 scale .039}
  finish {ambient .275 diffuse .75 specular .125 roughness .1}
}
 texture {pigment {image_map {png "RoadsPaths.png"
 // #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
 // #declare FA=FA-1; #end
         }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare DrySand2=
texture {pigment {granite color_map {
        [0 rgb <.98,.97,.96>][.5 rgb <.96,.77,.69>*.75][1 rgb <.675,.75,.725>*.67]} scallop_wave scale .036}
 normal {wrinkles .3 ramp_wave turbulence .25 scale .036}
  finish {ambient .3 diffuse .75 specular .15 roughness .075}
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare Rock=
texture {pigment {crackle turbulence .2 color_map {
        [0 color  rgb <.75,.75,.75>]
        [1 color  rgb <.67,.67,.67>*.8]
        }scale .01}
 normal {crackle .6 turbulence .2}
  finish {ambient .225 diffuse .3 specular .05 roughness .6}
 scale .016
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare Rock2=
texture {pigment {crackle turbulence .4 color_map {
        [0 color  rgb <.8,.775,.75>]
        [1 color  rgb <.75,.7,.67>*.8]
        }scale .0125}
 normal {crackle .9 turbulence .4}
  finish {ambient .25 diffuse .25 specular .05 roughness .6}
 scale .018
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare WetSand=
texture {pigment {spotted turbulence .5 color_map {
        [0 color rgb <.8,.725,.7125>*1.1]
        [1 color rgb <.825,.825,.825>*1.1]
        }scale .01}
 normal {spotted .025 turbulence .5}
  finish {ambient .3 diffuse .875 specular .15 roughness .075}
 scale .009
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare WetSand2=
texture {pigment {spotted turbulence .5 color_map {
        [0 color rgb <.875,.875,.875>]
        [1 color rgb <.925,.925,.925>]
        }scale .015}
 normal {spotted .05 turbulence .5}
  finish {ambient .35 diffuse .9 specular .075 roughness .125}
 scale .007
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare Trees=
texture {pigment {bumps turbulence .6 color_map {
        [.3 color rgb <.4,.425,.375>]
        [.5 color rgb <.45,.5,.35>]
        }scale .02}
 normal {bumps .3 turbulence .6}
  finish {ambient .225 diffuse .6 specular .1 roughness .3}
 scale .003
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare Trees2=
texture {pigment {bumps turbulence .7 color_map {
        [.5 color rgb <.55,.65,.4>]
        [.7 color rgb <.575,.525,.55>*1.33]
        }scale .125}
 normal {bumps .2 turbulence .7}
  finish {ambient .25 diffuse .7 specular .15 roughness .2}
 scale .00275
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare FA=255;
#declare Grass=
texture {pigment {dents turbulence .3 color_map {
        [0 color rgb <.4,.7,.3>]
        [1 color rgb <.45,.55,.25>]
        }scale .001}
 normal {dents .6 turbulence .3 scale .001}
  finish {ambient .175 diffuse .8 specular .075 roughness .075}
 scale .00225
}
 texture {pigment {image_map {png "RoadsPaths.png"
//  #while (FA>234)
         filter 14, 1 filter 13, .75 filter 12, 1 filter 11, 1 filter 10, 1 filter 9, 1 filter 8, 1
//  #declare FA=FA-1; #end
        }
  translate <-.5,-.5,0> scale .525 rotate <90,0,0> translate <1.05,0,1.025>}
  finish {ambient .35 diffuse .95 crand .2}
 }

#declare TerrainTex1=
 texture {
  slope -y, y, <0,.25>, <0,1>
  texture_map {
    [.05 WetSand]
    [.25 WetSand2]
    [.375 Grass]
    [.425 Trees]
    [.475 Trees2]
    [.55 DrySand2]
    [.6 DrySand]
    [.7 Rock2]
    [.8 Rock]
    [.9 DrySand2]
    [1 DrySand]
  }
 }
#else

#declare TerrainTex1=
texture {pigment {crackle turbulence 1 color_map {
        [0 rgb 1][1 rgb 0]
        }}
}

#end

height_field {png "pensacolalh.png"
 texture {TerrainTex1}
  translate <-.5,0,-.5> scale <1250,40,1250> rotate 180*y translate -40*y
}

/*
plane {y,0
 texture {pigment {image_map {png "RoadsPaths.png" once transmit 215, 1}
  translate -.5 scale .525 rotate <90,180,0>}
 }
   scale <1250,1,1250> translate <0,.1,0> translate <15,.1,-50>
}
*/

#declare _Cw_=.8;
#declare _mCo_=1;
#declare _C_=1;

#declare W1=
texture {pigment {ripples phase clock turbulence .5-(.25*_Cw_) frequency 3 color_map {
        [0 color rgbft <.65,.75,.8,.8,.6>]
        [1 color rgbft <.75,.8,.75,.85,.5>]
        }scale .01}
 normal {ripples .33-(.067*_Cw_) phase clock turbulence .75-(.25*_Cw_) scale .005-(.00125*_Cw_) scallop_wave}
  finish {ambient .25-(.2*_Cw_) diffuse 1-(.75*_Cw_) specular .75 roughness .005 phong .075 phong_size 10
#if (Use_MP=yes)
         reflection_type 1 reflection_min .03*(2*_Cw_) reflection_max .09*(7*_Cw_) reflection_falloff 1
         reflection_exponent .67 conserve_energy
#end
         }
 scale .05
  translate <-.05,.015,-5+(.05*clock)>
}
texture {
 pigment {gradient z frequency 1 turbulence <1.4,10,.15>*3 color_map {
        [0 rgbf <1,1,1,.025>]
        [.005 rgbf <1.5,1.5,1.5,.025>]
        [.01 rgbf <1,1,1,.025>]
        [.0125 rgbf <1,1,1,1>]
        [.0345 rgbf <1,1,1,1>]
        [.035 rgbf <1.5,1.5,1.5,.025>]
        [.04 rgbf <1,1,1,.025>]
        [.0425 rgbf <1,1,1,1>]
        [.0445 rgbf <1,1,1,1>]
        [.045 rgbf <1.5,1.5,1.5,.025>]
        [.05 rgbf <1,1,1,.025>]
        [.053 rgbf <1,1,1,1>]
 }scale <25,1,125> translate -1196*z}
  finish {ambient .25 diffuse .75}
}

#declare W2=
texture {pigment {crackle turbulence .5-(.25*_Cw_) color_map {
        [0 color rgbft <.65,.75,.8,.8,.5>]
        [1 color rgbft <.75,.8,.75,.75,.6>]
        }scale .05}
 normal {bozo .33-(.067*_Cw_) phase clock turbulence .25-(.25*_Cw_) scale .005-(.00125*_Cw_) scallop_wave}
  finish {ambient .25-(.2*_Cw_) diffuse 1-(.75*_Cw_) specular .75 roughness .005 phong .075 phong_size 10
#if (Use_MP=yes)
         reflection_type 1 reflection_min .03*(2*_Cw_) reflection_max .09*(7*_Cw_) reflection_falloff 1
         reflection_exponent .67 conserve_energy
#end
         }
 // translate <-.05,.015,-5+(.05*clock)>
}
texture {
 pigment {gradient z frequency 1 turbulence <5,5,.125>*2 octaves 6 color_map {
        [0 rgbf <1,1,1,.025>]
        [.005 rgbf <1.5,1.5,1.5,.025>]
        [.01 rgbf <1,1,1,.025>]
        [.0125 rgbf <1,1,1,1>]
        [.03 rgbf <1,1,1,1>]
        [.03125 rgbf <1.5,1.5,1.5,.025>]
        [.0367 rgbf <1,1,1,.025>]
        [.04 rgbf <1,1,1,1>]
        [.0445 rgbf <1,1,1,1>]
        [.045 rgbf <1.5,1.5,1.5,.025>]
        [.05 rgbf <1,1,1,.025>]
        [.053 rgbf <1,1,1,1>]
 }scale <25,1,125> translate <100,0,-1196>}
  finish {ambient .25 diffuse .75}
}

#declare W3=
texture {pigment {crackle turbulence .5-(.25*_Cw_) color_map {
        [0 color rgbft <.65,.75,.8,.8,.65>]
        [1 color rgbft <.75,.8,.75,.85,.55>]
        }scale .005}
 normal {wrinkles .67-(.067*_Cw_) phase clock turbulence .25-(.125*_Cw_) scale .0025-(.00125*_Cw_) triangle_wave}
  finish {ambient .25-(.2*_Cw_) diffuse 1-(.75*_Cw_) specular .75 roughness .005 phong .075 phong_size 10
#if (Use_MP=yes)
         reflection_type 1 reflection_min .03*(2*_Cw_) reflection_max .07*(7*_Cw_) reflection_falloff 1
         reflection_exponent .67 conserve_energy
#end
         }
 // translate <-.05,.015,-5+(.05*clock)>
}
texture {
 pigment {gradient z frequency 1 turbulence <1.5,10,.125>*1.75 color_map {
        [0 rgbf <1,1,1,.025>]
        [.005 rgbf <1.5,1.5,1.5,.025>]
        [.01 rgbf <1,1,1,.025>]
        [.0125 rgbf <1,1,1,1>]
        [.0345 rgbf <1,1,1,1>]
        [.035 rgbf <1.5,1.5,1.5,.025>]
        [.04 rgbf <1,1,1,.025>]
        [.0425 rgbf <1,1,1,1>]
        [.0445 rgbf <1,1,1,1>]
        [.045 rgbf <1.5,1.5,1.5,.025>]
        [.05 rgbf <1,1,1,.025>]
        [.053 rgbf <1,1,1,1>]
 }scale <25,1,125> translate -1196*z}
  finish {ambient .25 diffuse .75}
}

#declare Water= material {
texture {wrinkles turbulence .025 frequency 1 texture_map {
        [.125 W1]
        [.5 W2]
        [.875 W3]
        }}
 interior {ior 1.33 caustics 1 fade_distance 10
#if (Use_MP=yes)
         fade_power 1000 fade_color <.625,.825,.8>*.75
#end
         }
  scale <60,1,10> rotate -5*y translate <-100,0,50>
}

plane {y,0 material {Water}
 translate -39.5*y
//photons {target 1 reflection on refraction off}
}

plane {y,-27.5 pigment {wrinkles turbulence .75 color_map {
        [0 rgb <.725,.675,.65>*1.333][1 rgb <.625,.7,.65>*.9]} scale <200,1,125>}
         normal {dents .05 scale <150,1,50>}
         finish {ambient .125 diffuse .67}
 rotate -1.05*x
}

/* &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& */
// lighthouse
union {

// foundation
#declare FC=0;
union {
#while (FC<24)
 box {-1,1 scale <2.25,1.5,1.75> translate <0,.25,16> rotate 15*FC*y}
 box {-1,1 scale <2,1,.5> translate <0,3,15> rotate 15*FC*y}
#declare FC=FC+1;
#end
 texture {
        pigment {rgb 1.1}
        normal {granite .125 scale 1.5}
        finish {ambient .3 diffuse .55 specular .075 roughness .333 phong .1 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
}

// main tower
union {
difference {
cone {0,15,127.5*y,8.25}
// window and interior cutaways
union {
cone {0,14,127.5*y,8}
 box {-1,1 scale <1.25,2.5,2> translate <0,110,-9> rotate 75*y}
 box {-1,1 scale <1.25,2.5,2> translate <0,88.75,-10.25> rotate 255*y}
 box {-1,1 scale <1.25,2.5,2> translate <0,35,-13> rotate 165*y}
  pigment {rgb 1.1}
}
}
// windows
union {
 box {-1,1 scale <1.25,2.5,.02> translate <0,110,-8.5> rotate 75*y}
 box {-1,1 scale <1.25,2.5,.02> translate <0,88.75,-10.33> rotate 255*y}
 box {-1,1 scale <1.25,2.5,.02> translate <0,35,-13.125> rotate 165*y}
        pigment {rgbft <.8,.8,.8,.7,.1>}
        finish {ambient .0125 diffuse .125 specular .75 roughness .0025
#if (Use_MP=yes)
                reflection_type 1 reflection_min .125 reflection_max .33
#end
        }
        interior {ior 1.5 caustics 1}
}
 texture {
        pigment {gradient y
                color_map {
                        [.333 rgb 1.25] [.333 rgb .175]
        } scale 175}
        normal {brick .5 scallop_wave scale .5}
        finish {ambient .3 diffuse .55 specular .075 roughness .333 phong .1 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {gradient y .125 turbulence .1 scallop_wave scale 6}
        finish {ambient .25 diffuse .6 specular .05 roughness .125 phong .025 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}

// topmost part of tower, below light room

// dayboard brackets
union {
cylinder {0*z,4*z,.333 rotate -30*x}
cylinder {-1*z,4*z,.333}
cylinder {0*z,4*z,.333 rotate 30*x}
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20}
 translate <0,111,-12.5>
}

union {
cylinder {0*z,4*z,.333 rotate -30*x}
cylinder {-1*z,4*z,.333}
cylinder {0*z,4*z,.333 rotate 30*x}
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20}
 translate <0,117.5,-12.5>
}

cylinder {-12.5*z,-8.5*z,.333 translate 132.25*y
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20}
}

cylinder {-12.5*z,-8.5*z,.333 translate 142.25*y
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20}
}

// dayboard
box {0,-1
        pigment {gradient z color_map {
                [.4 rgb <1.25,.33,.125>] [.4 rgb 1.33] [.6 rgb 1.33] [.6 rgb <1.25,.33,.125>]
                }}
        finish {ambient .3 diffuse .8}
         scale <.1,12,6> translate <0,130.5,-11.5>
}

// lower deck
difference {
cone {127.5*y,7.25,132.5*y,9.25}
cone {129*y,7.75,132.6*y,9}
 texture {
        pigment {rgb .175}
        normal {brick .2}
        finish {ambient .175 diffuse .67 specular .125 roughness .333 phong .125 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {brick .2}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}

difference {
cone {132.5*y,8,133*y,9.25}
cone {132.75*y,7.5,133.1*y,9}
 texture {
        pigment {rgb .175}
        normal {brick .2}
        finish {ambient .175 diffuse .67 specular .125 roughness .333 phong .125 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {brick .2}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}
// rail
torus {9,.125 translate 137.5*y
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// posts
#declare BC=0;
union {
#while (BC<72)
 cylinder {-y,y,.075 scale <1,2,1.25> translate <0,135.5,9> rotate 5*BC*y}
#declare BC=BC+1;
#end
  pigment {rgb .175} finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
  }
}

// wall facets
#declare WC=0;
union {
#while (WC<12)
 box {-1,1 scale <1.75,5,.05> translate 6.67*z rotate 30*WC*y}
#declare WC=WC+1;
#end
 texture {
        pigment {rgb .175}
        normal {brick .2}
        finish {ambient .175 diffuse .67 specular .125 roughness .333 phong .125 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {brick .2}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
 scale <.825,1,.825> translate 136*y
  rotate 210*y
}
        
// upper deck
difference {
cone {142*y,7,142.5*y,8.5}
cone {142.25*y,6.5,142.6*y,8.25}
 texture {
        pigment {rgb .175}
        normal {brick .2}
        finish {ambient .175 diffuse .67 specular .125 roughness .333 phong .125 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {brick .2}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}

difference {
cone {142.5*y,7.5,143*y,8.5}
cone {142.75*y,7.75,143.1*y,8.25}
 texture {
        pigment {rgb .175}
        normal {brick .2}
        finish {ambient .175 diffuse .67 specular .125 roughness .333 phong .125 phong_size 10
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {brick .2}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}
// rail
torus {8.25,.15 translate 147.5*y
        pigment {rgb .175}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// posts
#declare BC=0;
union {
#while (BC<72)
 cylinder {-y,y,.075 scale <1,2,1.25> translate <0,145.5,8.25> rotate 5*BC*y}
#declare BC=BC+1;
#end
  pigment {rgb .175} finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
  }
}

// glass
#declare Mirrored=
texture {pigment {rgb .25} normal {wrinkles .1 scale 2.5} finish {ambient 0 diffuse .1 reflection .75}}

#declare Blacked=
texture {pigment {rgb .25} normal {wrinkles .125 scale .5} finish {ambient 0 diffuse .5 reflection .075}}

#declare WC=0;
union {
#while (WC<12)
 box {-1,1 translate z
 #if (WC<2 | WC>8)
        pigment {rgbft <.9,.925,.9125,.85,.15>}
        finish {ambient .0125 diffuse .125 specular .75 roughness .0025
#if (Use_MP=yes)
                reflection_type 1 reflection_min .125 reflection_max .33
#end
        }
        interior {ior 1.5 caustics 1}
 #else
       texture {gradient z texture_map {
        [.5 Mirrored] [.5 Blacked]
        }scale 1.01}
 #end
 translate -z scale <1.75,5,.05> translate 6.67*z rotate 30*WC*y
  rotate 210*y
}
union {
difference {
 box {-1,1 scale <1.85,5.4/3,.075>}
 box {-1,1 scale <1.7,4.9/3,.1>} translate 3.33*y
}
difference {
 box {-1,1 scale <1.85,5.4/3,.075>}
 box {-1,1 scale <1.7,4.9/3,.1>} translate -3.33*y
}
  pigment {rgb .175} finish {ambient .175 diffuse .67 specular .15 roughness .25}
  translate 6.67*z rotate 30*WC*y}
#declare WC=WC+1;
#end
 scale <.8125,1,.8125> translate 150*y
}

// roof
union {
cone {154.75*y,6.67,155.25*y,7.125 open} // inside lip

#declare RC=0;
#while (RC<18)
union {
cylinder {-2*x,2*x,8.25 // minor facets
         clipped_by {box {0,1 rotate -45*y scale <2.125,1,12> translate -3.75*y}}
          scale <1.1,.95,1.1> translate 7*y}
sphere {0,1 pigment {rgb<.75,.9,.85>} finish {ambient .15 diffuse .65 specular .2 roughness .1}
         scale <.275,.3,.333> rotate 36*x translate <0,3.33,7.7> rotate 10*y}
 rotate 20*RC*y translate 151*y
}
#declare RC=RC+1;
#end

#declare RC=0;
#while (RC<18)
cylinder {-2*x,2*x,8.5 // major facets
         clipped_by {box {0,1 rotate -45*y scale <2.125,5,12> translate 3.75*y}}
 rotate 20*RC*y translate 151*y
}
#declare RC=RC+1;
#end

sphere {0,1.5 scale <1.075,1.15,1.075> translate 162*y}
torus {2.75,1.67
         clipped_by {sphere {0,2.125 translate -1.25*y}}
          scale <1,.667,1> translate 160.25*y}

 texture {
        pigment {rgb .175}
        normal {bumps .1}
        finish {ambient .175 diffuse .67 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.33 rgbf .98] [.67 rgbf <.8,.8,.8,.8>]}
                scale 5}
        normal {bumps .1}
        finish {ambient .25 diffuse .6 specular .1 roughness .125 phong .1 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
 scale <.8,.925,.8> translate 11.75*y
}

// lightning rod
cylinder {163*y,171*y,.15
  pigment {rgb .25}
   finish {ambient .15 diffuse .75 specular .15 roughness .25 phong .125 phong_size 20
#if (Use_MP=yes)
                reflection_type 0 reflection_min .125 reflection_max .33
#end
  }
}

#declare Fresnel=
union {
sphere {0,1 scale <.15,.25,.15>*3.5
        pigment {rgb <1.33,1.3,1.25>*(1-(DN/2)) filter .125 transmit .25}
         finish {ambient 1.25 diffuse 1.25 specular .25 roughness .1}
}
sphere {0,1 scale <2.5,3.5,2.5> // <1.75,1.75,.25> translate -2*z
        pigment {rgb <1.3,1.25,1.15>*(1-(DN/2)) filter .8 transmit .3}
         normal {gradient y .5 scale .25 ramp_wave}
         finish {ambient .25 diffuse .75 specular .25 roughness .1
#if (Use_MP=yes)
                reflection_type 1 reflection_min .125 reflection_max .33
#end
         }
       interior {ior 1.5 caustics 1}
//photons {reflection off refraction off pass_through}
}
}

// light beam
// union {
// object {Fresnel}
light_source {6*z,<1.1,1.05,1>*(1-(DN/2))
        looks_like {Fresnel}
        spotlight point_at -z radius 3 falloff 6 tightness 9
        fade_distance 999 fade_power 2
 media_interaction on media_attenuation on
//photons {reflection on refraction off}
// }
        translate 150*y // rotate -5*y
         rotate 360*ClockL*y
}

light_source {0,<1.1,1.05,1>*(.75-(DN/2))
       looks_like {Fresnel}
 area_light <3,0,0>,<0,3,0>,3,3 jitter
#if (Use_MP=yes)
  orient circular
#end
        fade_distance 99 fade_power 2
 media_interaction off media_attenuation off
//photons {reflection on refraction off}
  translate 150*y
}

// lens cradle
#declare LC=0;
union {
#while (LC<3)
torus {1,.075 rotate 90*z rotate 120*LC*y
        pigment {rgb .175}}
#declare LC=LC+1;
#end
 scale <2.5,3.5,2.5> rotate 15*y translate 150*y
}


// connecting house
// roof
difference {
box {-1,1 rotate 45*x scale <15.5,5,10> translate <-20,17.5,0>}
box {-1,1 rotate 45*x scale <15.51,5,10> translate <-20,17,0>}
        pigment {rgb<.9,.4,.2>}
        normal {brick .5 scale <1.5,.25,1>*2}
        finish {ambient .25 diffuse .75 specular .1 roughness .2 crand .15
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// walls
difference {
box {-1,1 scale <15,12,10> translate <-20,12,0>}
plane {-y,0 rotate -25*x translate 23*y}
plane {-y,0 rotate 25*x translate 23*y}
box {-1,1 scale <14.5,12,9.5> translate <-20,12,0> pigment {rgb .5}}
// window cutouts
#declare WH=0;
#while (WH<2)
box {-1,1 scale <1.25,1.75,1> translate <-27.5,5,10> translate WH*10*x}
box {-1,1 scale <1.25,1.75,1> translate <-20,13,10> translate WH*15*x}
box {-1,1 scale <1.25,1.75,1> translate <-27.5,5,-10> translate WH*10*x}
box {-1,1 scale <1.25,1.75,1> translate <-20,13,-10> translate WH*15*x}
#declare WH=WH+1;
#end
 texture {
        pigment {rgb 1.3}
        normal {brick .5 scale <10,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.5 rgbf .98] [.67 rgbf .89]}
                scale 2}
        normal {granite .25 triangle_wave scale 1}
        finish {ambient .025 diffuse .5 specular .05 roughness .125 phong .025 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
}
// windows
union {
#declare WH=0;
#while (WH<2)
box {-1,1 scale <1.25,1.75,.025> translate <-27.5,5,10> translate WH*10*x}
box {-1,1 scale <1.25,1.75,.025> translate <-20,13,10> translate WH*15*x}
box {-1,1 scale <1.25,1.75,.025> translate <-27.5,5,-10> translate WH*10*x}
box {-1,1 scale <1.25,1.75,.025> translate <-20,13,-10> translate WH*15*x}
#declare WH=WH+1;
#end
material {
      texture {
        pigment {rgbft <.9,.925,.9125,.85,.15>}
        finish {ambient .0125 diffuse .125 specular .75 roughness .0025
#if (Use_MP=yes)
                reflection_type 1 reflection_min .125 reflection_max .33
#end
        }
      }
        interior {ior 1.5 caustics 1}
 }
}
 rotate -15*y translate -.5*y // shift lighthouse position in relation to main house
}

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
// main house
union {
// main
difference {
box {-1,1 scale <22.5,13,14.5> translate 2.5*z}
plane {-y,0 rotate -25*x translate 13*y}
plane {-y,0 rotate 25*x translate 13*y}
box {-1,1 scale <22.25,12.75,14.25> translate 2.5*z pigment {rgb .5}}
// door cutouts
box {-1,1 scale <1.5,3,1> translate <-3,-8,-12>}
box {-1,1 scale <1.5,3,1> translate <3,-8,-12>}
box {-1,1 scale <1.5,3,1> translate <-3,1,-12>}
box {-1,1 scale <1.5,3,1> translate <3,1,-12>}
// window cutouts
// back/front
#declare WH=0;
#while (WH<6)
box {-1,1 scale <1.25,1.75,1> translate <-18.5,-7,17> translate WH*7.5*x}
box {-1,1 scale <1.25,1.75,1> translate <-18.5,2,17> translate WH*7.5*x}
 #if (WH<2 | WH>3)
box {-1,1 scale <1.25,1.75,1> translate <-18.5,-7,-12> translate WH*7.5*x}
box {-1,1 scale <1.25,1.75,1> translate <-18.5,2,-12> translate WH*7.5*x}
 #end
#declare WH=WH+1;
#end
// left side
box {-1,1 scale <1,1.75,1.25> translate <-22.5,2,-4>}
box {-1,1 scale <1,1.75,1.25> translate <-22.5,2,6.5>}
box {-1,1 scale <1,1.75,1.25> translate <-22.5,-7,-4>}
box {-1,1 scale <1,1.75,1.25> translate <-22.5,-7,6.5>}
// right side
box {-1,1 scale <1,1.75,1.25> translate <22.5,2,-4>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,2,6.5>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,-7,-4>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,-7,6.5>}
 texture {
  pigment {rgb 1.3}
        normal {gradient y .5 scale <1,.75,1>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 }
 texture {
        pigment {spotted
                color_map {
                        [.5 rgbf .98] [.67 rgbf .89]}
                scale 1}
        normal {granite .25 triangle_wave scale 1}
        finish {ambient .025 diffuse .5 specular .05 roughness .125 phong .025 phong_size 2
#if (Use_MP=yes)
                reflection_type 0 reflection_min .0125 reflection_max .0133
#end
                }
 }
 translate <-30,14,-40>
}
// doors
difference {
union {
box {-1,1 scale <1.5,3,.15> translate <-3,-8,-12>}
box {-1,1 scale <1.5,3,.15> translate <3,-8,-12>}
box {-1,1 scale <1.5,3,.15> translate <-3,1,-12>}
box {-1,1 scale <1.5,3,.15> translate <3,1,-12>}
}
union {
box {-1,1 scale <1,2,.1> translate <-3,-8,-12.15>}
box {-1,1 scale <1,2,.1> translate <3,-8,-12.15>}
box {-1,1 scale <1,2,.1> translate <-3,1,-12.15>}
box {-1,1 scale <1,2,.1> translate <3,1,-12.15>}
 pigment {rgb 1.2}
        normal {leopard .25 scale <.75,1.25,1>}
        finish {ambient .25 diffuse .75 specular .1 roughness .125}
}
 pigment {rgb 1.1}
        normal {leopard .5 scale <.75,1.25,1>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
        }
 translate <-30,14,-40>
}
// windows
union {
// back/front
#declare WH=0;
#while (WH<6)
box {-1,1 scale <1.25,1.75,.025> translate <-18.5,-7,17> translate WH*7.5*x}
box {-1,1 scale <1.25,1.75,.025> translate <-18.5,2,17> translate WH*7.5*x}
 #if (WH<2 | WH>3)
box {-1,1 scale <1.25,1.75,.025> translate <-18.5,-7,-12> translate WH*7.5*x}
box {-1,1 scale <1.25,1.75,.025> translate <-18.5,2,-12> translate WH*7.5*x}
 #end
#declare WH=WH+1;
#end
// left side
box {-1,1 scale <.025,1.75,1.25> translate <-22.5,2,-4>}
box {-1,1 scale <.025,1.75,1.25> translate <-22.5,2,6.5>}
box {-1,1 scale <.025,1.75,1.25> translate <-22.5,-7,-4>}
box {-1,1 scale <.025,1.75,1.25> translate <-22.5,-7,6.5>}
// right side
box {-1,1 scale <1,1.75,1.25> translate <22.5,2,-4>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,2,6.5>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,-7,-4>}
box {-1,1 scale <1,1.75,1.25> translate <22.5,-7,6.5>}
material {
      texture {
        pigment {rgbft <.9,.925,.9125,.85,.15>}
        finish {ambient .0125 diffuse .125 specular .75 roughness .0025
#if (Use_MP=yes)
                reflection_type 1 reflection_min .125 reflection_max .33
#end
        }
      }
        interior {ior 1.5 caustics 1}
 }
 translate <-30,14,-40>
}
// roof
union {
difference {
difference {
box {-1,1 rotate 45*x scale <29.5,7.5,15> translate <-30,17.5,-40>}
box {-1,1 rotate 45*x scale <29.51,7.5,15> translate <-30,17,-40>}
}
box {-1,1 scale <5,5,15> translate <-60,25,-40>}
box {-1,1 scale <2.5,7.5,20> rotate -75*z translate <-63.5,17,-40>}
box {-1,1 scale <5,5,15> translate <0,25,-40>}
box {-1,1 scale <2.5,7.5,20> rotate 75*z translate <3.5,17,-40>}
}
// left side
difference {
difference {
 box {-1,1 rotate 45*z scale <10,7.5,20> translate <-46,17.5,-40>}
 box {-1,1 rotate 45*z scale <10,7.5,20.1> translate <-46,17,-40>}
 }
box {-1,1 rotate -47.5*x scale <29.51,7.5,15> translate <-30,17,-40> inverse}
}
// right side
difference {
difference {
 box {-1,1 rotate 45*z scale <10,7.5,20> translate <-14,17.5,-40>}
 box {-1,1 rotate 45*z scale <10,7.5,20.1> translate <-14,17,-40>}
 }
box {-1,1 rotate 47.5*x scale <29.51,7.5,15> translate <-30,17,-40> inverse}
}
 texture {
        pigment {rgb<.9,.4,.2>}
        normal {brick .5 scale <1.5,.25,1>*2}
        finish {ambient .25 diffuse .75 specular .1 roughness .2 crand .15
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
        }
 }
}
// chimney
union {
box {-1,1 scale <1.25,4,1.5> translate <-22,25,-10>}
box {-1,1 scale <1.25,4,1.5> translate <-22,25,10>}
box {-1,1 scale <1.25,4,1.5> translate <22,25,-10>}
box {-1,1 scale <1.25,4,1.5> translate <22,25,10>}
box {-1,1 scale <1.25,12,1.75> translate <-22,9,-10>}
box {-1,1 scale <1.25,12,1.75> translate <-22,9,10>}
box {-1,1 scale <1.25,12,1.75> translate <22,9,-10>}
box {-1,1 scale <1.25,12,1.75> translate <22,9,10>}
        pigment {gradient y turbulence .03 color_map {
                [.85 rgb 1.3][.925 rgb 1.1][.95 rgb .9][1 rgb .6]} scale 30 translate -.75*y}
        normal {brick .25 scale <.5,.25,.5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
 translate <-30,0,-40>
}
// upper porch
difference {
box {-1,1 scale <28.75,1.75,18> translate <-30,13,-42.25>}
box {-1,1 scale <28.625,1.76,17.875> translate <-30,13,-42.25>}
        pigment {gradient x color_map {[.125 rgb 1.3][.125 rgbf 1]} scale .75 rotate 45*y}
        finish {ambient .3 diffuse .6 specular .1 roughness .125}
}
// floor
box {-1,1 scale <28.75,.5,18> translate <-30,11.25,-42.25>
        pigment {rgb 1.3}
        normal {brick .25 scale <5,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// railing
difference {
box {-1,1 scale <28.75,.25,18> translate <-30,14.75,-42.25>}
box {-1,1 scale <28,.751,17.75> translate <-30,14.75,-42.25>}
        pigment {rgb 1.3}
        normal {brick .25 scale <5,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// lower porch
difference {
box {-1,1 scale <28.75,1.75,18> translate <-30,4.25,-42.25>}
box {-1,1 scale <28.625,1.76,17.875> translate <-30,4.25,-42.25>}
box {-1,1 scale <8,2,1> translate <-30,4.25,-60>}
        pigment {gradient x color_map {[.125 rgb 1.3][.125 rgbf 1]} scale .75 rotate 45*y}
        finish {ambient .3 diffuse .6 specular .1 roughness .125}
}
// floor
box {-1,1 scale <28.75,.5,18> translate <-30,2.5,-42.25>
        pigment {rgb 1.3}
        normal {brick .25 scale <5,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// railing
difference {
box {-1,1 scale <28.75,.25,18> translate <-30,6,-42.25>}
box {-1,1 scale <28,.751,17.75> translate <-30,6,-42.25>}
box {-1,1 scale <5,1,1> translate <-30,6,-60>}
        pigment {rgb 1.3}
        normal {brick .25 scale <5,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
// steps
union {
box {-1,1 scale <5,.25,.5> translate <-30,2.25,-60.25>}
box {-1,1 scale <5,.25,.5> translate <-30,1.75,-61.25>}
box {-1,1 scale <5,.25,.5> translate <-30,1.25,-62.25>}
box {-1,1 scale <5,.25,.5> translate <-30,.75,-63.25>}
       pigment {rgb 1.3}
        normal {brick .25 scale <5,1,5>}
        finish {ambient .3 diffuse .6 specular .1 roughness .125
#if (Use_MP=yes)
                reflection_type 0 reflection_min .025 reflection_max .033
#end
                }
}
//posts
union {
// front
box {-1,1 scale <.25,9,.25> translate <-29,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <-21,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <-13,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <-5,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <5,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <13,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <21,0,-17.5>}
box {-1,1 scale <.25,9,.25> translate <29,0,-17.5>}
// left side
box {-1,1 scale <.25,9,.25> translate <-29,0,15.5>}
box {-1,1 scale <.25,9,.25> translate <-29,0,7.25>}
box {-1,1 scale <.25,9,.25> translate <-29,0,-1>}
box {-1,1 scale <.25,9,.25> translate <-29,0,-9.25>}
// right side
box {-1,1 scale <.25,9,.25> translate <29,0,15.5>}
box {-1,1 scale <.25,9,.25> translate <29,0,7.25>}
box {-1,1 scale <.25,9,.25> translate <29,0,-1>}
box {-1,1 scale <.25,9,.25> translate <29,0,-9.25>}
        pigment {rgb 1.3}
        finish {ambient .3 diffuse .6 specular .1 roughness .125}
  translate <-30,9,-42>
}

 translate <0,-1,-25> // final transformation
}


// SUV
union {
difference {
box {-1,1 scale <6,1.75,3.25>}
plane {-x,0 rotate 30*z translate 6.25*x}
plane {x,0 rotate -60*z translate -5*x}
}
difference {
box {-1,1 scale <4,.75,3>}
plane {-x,0 rotate 30*z translate 3.25*x}
plane {x,0 rotate -60*z translate -3.5*x}
 pigment {gradient y color_map {
        [.8 rgbf <.7,.85,.8,.9>][.8 rgb <.9,.175,.15>]
 } scale 1.5 translate -.725*y}
 finish {ambient .2 diffuse .65 specular .33 roughness .033 reflection .2}
  translate 2.5*y
}
 pigment {rgb <.9,.175,.15>}
 finish {ambient .2 diffuse .65 specular .33 roughness .033 reflection .2}
  translate 2.75*y
   rotate 25*y translate <160,-5,-165>
}
