// Persistence of Vision Ray Tracer Scene Description File
// File: glo_go.pov
// Vers: MegaPOV 0.5a MOD v0.3.0
// Desc: Seeing if I can display a picture pixel by pixel using glows.
// Date: 9 September 2000
// Auth: Alan Holding - manhog@freeuk.com

/*

WOT YOU NEED
------------
You will need Chris Huff's MegaPOV 0.5 MOD 0.3.0 to run this
scene.  At the time of writing, his website is located here:
http://homepage.mac.com/chrishuff/

It has been mooted that the syntax for the glow command will
change with future versions of MegaMOD, so if you're now using
a version higher than 0.3.0 it may be best to check, yes?

WOT I WANTED
------------
I thought it find be interesting to see if I could 'draw' a
bitmap in POV using glows as pixels.  Might eventually be
useful for TV screens, neon signs, etc.

WOT I DID
---------
Using Paint Shop Pro v5.03, I saved a bitmap as an ASCII
format Portable Pixelmap (.ppm) file.

I then edited the .ppm file in NoteTab Light (though any
good text editor will do), removed the first four lines,
replaced all the spaces between the numbers with commas so
that POV would be able to read the RGB information
'correctly', and finally saved it as a .txt file.

Opened up Chris Huff's MegaPOV 0.5 MOD 0.3.0 and wrote this
scene file.  (I had to stick a sphere behind the camera as
the scene wouldn't render with no objects in it.)

If I wasn't so lazy I'd change this process and get POV to
read the .ppm file directly - I could bring in the x and y
sizes that way, too.  Ho hum...

BUT!
----
At 640x480 AA 0.3 this scene took 10 and a half hours (eek!)
to render at the highest priority on my 375Mhz Celery.  Maybe
that's down to my bad coding, but unless glows become faster I
think I'll leave this technique alone for a bit.

But why stick with glows?  You could use this technique to
make coloured grids of blobs, spheres, etc.

*/

#version unofficial MegaPOV 0.5;

global_settings {assumed_gamma 1.8}

camera {
  location <0,0,-1000>
  right x*image_width up y*image_height
  angle 70
  look_at 0
  perspective
}

sphere {<0,0,-1001> 0.1 pigment {rgb 0}}

//  Size of the original bitmap.
#local grid_x=128;
#local grid_y=77;

#fopen picture "glo-go.txt" read

#local pixy=0;
#while (pixy<grid_y)

  #local pixx=0;
  #while (pixx<grid_x)

    #read (picture,R,G,B)

//  If pixel colour is black, don't create a glow for it.
    #local pixel=(R+G+B)/255;
    #if (pixel>0)
      glow {
        0.01
        glow_type 0
        color rgb <R,G,B>/192
        location <((-grid_x/2)+pixx)*8,((grid_y/2)-pixy)*8,0>
        turbulence pixel/5 pixel/10
      }
    #end

    #local pixx=pixx+1;
  #end

#local pixy=pixy+1;
#end

#fclose picture
