// Persistence of Vision Ray Tracer Scene Description File
// File: awStoneBlockMacs2.inc
// Vers: MegaPov 0.5a
// Desc: Test scene of isosurface stone blocks and image mapped column segments
// Date: 2000.08.12     
// Auth: the autowitch (aka d. gold)
//       The Pittsburg Tank And Boiler Company  
             
// This file is licensed under the Gnu Public License for Libraries (LGPL).
// See www.gnu.org for further details.
             
// Known Bugs:                            

// None

// Todo:

// Usage:

// awSuperellipsoid
//   Creates a superellipsoid - used for rounded cylinders
//   and column parts.  Primarily used to create cylinders
//   along the y axis.

// awSuperellipsoid (p1,                // Base of the object
//                   Height,            // height of the object 
//                   XRadius,           // X Radius
//                   ZRadius,           // Y Radius 
//                   V1,                // First parm to superellipsoid 
//                   V2,                // Second parm to superellipsoid 
//                   SType,             // Type of surface noise
//                   BumpSize,          // Size of granite noise 
//                   CrackSize,         // Size of crack noise 
//                   CrackScale)        // Scale of crack noise
                                                               
// Inclusion control
                                                               
#ifndef (awSuperellipsoidMac1)
  #declare awSuperellipsoidMac1 = true;

// Random seed

#ifndef (awSERandom)                           
  #declare awSERandom = seed(0);                                           
#end                                                                          

// Declare superellipsoid surface types

#declare awSEPerfect    = 0;                     
#declare awSERough      = 1;
#declare awSEWeathered1 = 2;       
#declare awSEWeathered2 = 3;
#declare awSEWeathered3 = 4;
#declare awSEWeathered4 = 5;

// awSuperellipsoid

#macro awSuperellipsoid (p1, Height, XRadius, ZRadius, V1, V2, SType,
                         BumpSize, CrackSize, CrackScale)

  object {           
    #local RoundedCylinder = function { "superellipsoid", <V1, V2>} // ,x,y,z> }
    
    #local awfnColBumps   = function {pigment { granite } }
    #local awfnColCracks  = function {pigment { dents scale CrackScale} } 
    #local awfnColCracks2 = function {pigment { wrinkles turbulence 0.5 scale CrackScale} }
    #local awfnColCrackle = function {pigment { crackle turbulence 0.1 scale CrackScale} }

    // Calculate texture offsets           
    
    #local bumpx = rand (awSERandom) * 100000;
    #local bumpy = rand (awSERandom) * 100000;
    #local bumpz = rand (awSERandom) * 100000;    
    
    isosurface {              
      #switch (SType)
        #case (awSEPerfect)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
          }
        #break
        #case (awSERough)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
                                       + awfnColBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize }
        #break
        #case (awSEWeathered1)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
                                       + awfnColBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize + 
                                       awfnColCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize } 
        #break
        #case (awSEWeathered2)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
                                       + awfnColBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize + 
                                       awfnColCrackle (x + bumpx, y + bumpy, z + bumpz) * CrackSize } 
        #break
        #case (awSEWeathered3)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
                                       + awfnColCrackle (x + bumpx, y + bumpy, z + bumpz) * CrackSize } 
        #break
        #case (awSEWeathered4)              
          function { RoundedCylinder (x/XRadius, y/ZRadius, (z*2)/(Height)) 
                                       + awfnColCrackle (x + bumpx, y + bumpy, z + bumpz) * CrackSize } 
        #break

      #end  
                         
      accuracy 0.0000001
      max_trace 15   
      eval         
      method 2       
      sign -1
      contained_by {box { <-XRadius-1, -ZRadius-1, -Height/2-1>, <XRadius+1, ZRadius+1, Height/2+1> } }
    }                   
    rotate 90*x
    translate <p1.x, p1.y + Height/2, p1.z>
  }
#end

#end