// Persistence of Vision Ray Tracer Scene Description File
// File: awStoneBlockMacs2.inc
// Vers: MegaPov 0.5a
// Desc: Test scene of isosurface stone blocks and image mapped column segments
// Date: 2000.08.14     
// Auth: the autowitch (aka d. gold)
//       The Pittsburg Tank And Boiler Company  
             
// This file is licensed under the Gnu Public License for Libraries (LGPL).
// See www.gnu.org for further details.
                        
// Requires:
//  awStoneBlockMacs2
                        
// Known Bugs:      
// Wall macro offsets position and width (WidthVar and zVar) should not be used
// for the ending blocks.  The variance causes problems with 90 degree joins
// of walls.

// Todo:               

// Texture randomization.  See awStoneBlockMacs2.

// Usage:                                                                              
                
// awStoneWallCourse1
//   Creates a single course of the stone wall
                
// awStoneWallCourse1 (CourseLength,            // Length of the row of blocks
//                     BlockLength,             // Length of an individual block 
//                     BlockWidth,              // Width of an individual block 
//                     BlockHeight,             // Height of an individual block 
//                     BlockOffset,             // Offset distance between blocks
                                                // This may need to be negative with
                                                // some block noise types
//                     BlockOffsetVar,          // Horizontal variance between blocks 
//                     LengthVar,               // Amount that an individual blocks 
                                                // Length may vary 
//                     WidthVar,                // Amount that an individual blocks
                                                // Width may vary 
//                     zVar,                    // Amount by which a block may be
                                                // out of line from other blocks            
//                     Bevel,                   // Amount of bevel on the blocks 
//                     BumpSize,                // Size of granite noise on the blocks 
//                     CrackSize,               // Size of crack noise on blocks 
//                     CrackScale,              // Scale of crack noise 
//                     BlockType,               // Type of block.  See awStoneBlockMacs2 
//                     BlockTexture)            // Texture to use for block // !!!!

// awStoneWall (WallLength,                     // Length of wall
//              NumRows,                        // Number of rows (will determine wall height) 
//              BlockLength,                    // Length of an individual block 
//              BlockWidth,                     // Width of an individual block
//              BlockHeight,                    // Height of an individual block 
//              BlockOffset,                    // Offset between blocks
//              BlockOffsetVar,                 // Horizontal amount of difference between
                                                // blocks 
//              LengthVar,                      // Amount that an individual blocks
                                                // length may vary 
//              WidthVar,                       // Amount that an individual blocks
                                                // Width may vary
//              zVar,                           // Amount that a block can be out of
                                                // line from the the other blocks     
//              Bevel,                          // Amount of bevel on blocks                                   
//              BumpSize,                       // size of granite noise on blocks 
//              CrackSize,                      // Size of crack noise on blocks 
//              CrackScale,                     // Scale of crack noise on blocks 
//              BlockType,                      // block type (see awStoneBlockMacs2) 
//              BlockTexture,                   // Texture for wall 
//              VerticalOffset,                 // Vertical offset between rows of blocks 
//              CourseOffset1,                  // Left hand offset betweem rows.  This and
                                                // the next parameter are used to make offsets
                                                // to join together walls at 90 degress
                                                // Set to 0 to line the blocks up. 
//              CourseOffset2)                  // Right hand offset.  Same as CourseOffset1 


// Inclusion Control

#ifndef (awStoneWallMacs1)
  #declare awStoneWallMacs1 = true;

// Random seed

#ifndef (awWallRandom)                           
  #declare awWallRandom = seed(0);                                           
#end                                                                          

// Needed includes

#include "awStoneBlockMacs2.inc"

// awStoneWallCourse1

#macro awStoneWallCourse1 (CourseLength, BlockLength, BlockWidth, BlockHeight, BlockOffset,
                           BlockOffsetVar, LengthVar, WidthVar, zVar,     
                           Bevel, BumpSize, CrackSize, CrackScale, BlockType, BlockTexture)
  union {         
    #local CurBlockOffsetVar = BlockOffsetVar;
    #local CurBlockOffset = BlockOffset;         
    #local i = 0;
    #while (i < CourseLength)         
      #local ThisBlockLength = BlockLength + rand (awWallRandom) * LengthVar - LengthVar / 2; 
      #if (i + ThisBlockLength + BlockLength / 3 > CourseLength)
        #local ThisBlockLength = CourseLength - i;
        #local CurBlockOffsetVar = 0;
        #local CurBlockOffset = 1;
      #end                    
      #local ThisZVar = rand (awWallRandom) * zVar - zVar / 2;
      object {
        awStoneBrick (<i, 0, ThisZVar>, 
                      <i + ThisBlockLength, BlockHeight, BlockWidth + rand (awWallRandom) * WidthVar - WidthVar / 2 + ThisZVar>, 
                      Bevel, BumpSize, CrackSize, CrackScale, BlockType)
        texture { BlockTexture }
      }
      #local i = i + ThisBlockLength + rand (awWallRandom) * CurBlockOffsetVar - CurBlockOffsetVar / 2 + CurBlockOffset;
    #end
  }
#end

// awStoneWall

#macro awStoneWall (WallLength, NumRows, BlockLength, BlockWidth, BlockHeight, BlockOffset,
                    BlockOffsetVar, LengthVar, WidthVar, zVar,     
                    Bevel, BumpSize, CrackSize, CrackScale, BlockType, BlockTexture,
                    VerticalOffset, CourseOffset1, CourseOffset2) 
  #render "Creating wall\n"                         
  union { 
    #local OffsetDir = 0;
    #local ThisVerticalPos = 0;
    #local i = 0;
    #while (i < NumRows)               
      #if (OffsetDir = 0)     
        #local ThisOffset = CourseOffset1;
        #local ThisHorizOffset = CourseOffset1; 
      #else
        #local ThisOffset = CourseOffset2; 
        #local ThisHorizOffset = 0;
      #end
      object {
        awStoneWallCourse1 (WallLength-ThisOffset, BlockLength, BlockWidth, BlockHeight, BlockOffset,
                            BlockOffsetVar, LengthVar, WidthVar, zVar,
                            Bevel, BumpSize, CrackSize, CrackScale, BlockType, BlockTexture)
        translate <ThisHorizOffset,ThisVerticalPos, 0>                            
      }
      #local i = i + 1;  
      #local OffsetDir = 1 - OffsetDir;
      #local ThisVerticalPos = ThisVerticalPos + BlockHeight + VerticalOffset;
    #end
  }
#end          

#end