// Persistence of Vision Ray Tracer Scene Description File
// File: awStoneBlockMacs2.inc
// Vers: MegaPov 0.5a
// Desc: Test scene of isosurface stone blocks and image mapped column segments
// Date: 2000.08.12     
// Auth: the autowitch (aka d. gold)
//       The Pittsburg Tank And Boiler Company  
             
// This file is licensed under the Gnu Public License for Libraries (LGPL).
// See www.gnu.org for further details.
             
// Known Bugs:                     

// The point sorter is not working correctly.  For now, specify the points for 
// the block as smallest, highest.

// Todo:

// Use a texture randomizer, so block texture is chosen at random from user
// #declare controled list.  Possibly an array.  I may put this texture
// controller in the stone wall macro.

// use #declare awStoneBlockTexture : texture and 
// awStoneBlockForceTexture : bool to be able to force a single texture

// Usage:       

// awStoneBrick
//   Creates one roughened up stone brick

// awStoneBrick (p1,                    // Once corner of the block
//               p2,                    // The oposite corner of the block
//               Bevel,                 // amount of rounding on the edges  
//               BumpSize,              // Size of granite noise on block 
//               CrackSize,             // Size of cracking noise on the block 
//               CrackScale,            // Scale for cracking noise 
//               BlockType)             // Type of noise to use (eg awPerfectBlock).
                        
// Inclusion control
                        
#ifndef (awStoneBlockMacs2)
  #declare awStoneBlockMacs2 = true;

// Random seed

#ifndef (awBlockRandom)                           
  #declare awBlockRandom = seed(0);                                           
#end                                                                          

// Declare block types

#declare awPerfectBlock                 = 0;
#declare awDamagedFaceBlock1            = 1;
#declare awRoughBlock                   = 2;
#declare awWeatheredBlock               = 3;
#declare awCrackedBlock                 = 4;
#declare awDamagedFaceBlock2            = 5;
#declare awSmoothWeatheredBlock1        = 6;
#declare awSmoothWeatheredBlock2        = 7;
#declare awDamagedBlock                 = 8;
#declare awCrackleBlock                 = 9;

// awStoneBrikc

#macro awStoneBrick (p1, p2, Bevel, BumpSize, CrackSize, CrackScale, BlockType)

  object {  
      
    // Sort the points
      
    #local pt1 = p1;
    #local pt2 = p2;
    #if (pt1.x > pt2.x)
      #local tmp = pt1.x;
      #local pt1 = <pt2.x, pt1.y, pt1.z>;
      #local pt2 = <tmp, pt2.y, pt2.z>;
    #end 
    #if (pt1.y > pt2.y)
      #local tmp = pt1.y;
      #local pt1 = <pt1.x, pt2.y, pt1.z>;
      #local pt2 = <pt2.x, tmp, pt2.z>;
    #end 
    #if (pt1.z > pt2.z)
      #local tmp = pt1.x;
      #local pt1 = <pt1.x, pt1.y, pt2.z>; 
      #local pt2 = <pt2.x, pt2.y, tmp>; 
    #end                  
    #local dpt = <pt2.x - pt1.x, pt2.y-pt1.y, pt2.z-pt1.z>;
    
    // Calculate texture offsets           
    
    #local bumpx = rand (awBlockRandom) * 100000;
    #local bumpy = rand (awBlockRandom) * 100000;
    #local bumpz = rand (awBlockRandom) * 100000;    
    
    // Calculate other useful factors
    
    #local ErosionOffset = 0; // (bumpsize/2 + cracksize / 2)/10;
     
    // Declare functions for isosurface
     
    #local awfnBrick   = function {"rounded_box", <Bevel, dpt.x/2 + ErosionOffset,
                                                   dpt.y/2 + ErosionOffset, dpt.z/2 + ErosionOffset> }
    #local awfnBumps   = function {pigment { granite } }
    #local awfnCracks  = function {pigment { dents scale CrackScale} } 
    #local awfnCracks2 = function {pigment { wrinkles turbulence 0.5 scale CrackScale} }
    #local awfnCrackle = function {pigment { crackle turbulence 0.1 scale CrackScale} }
    
    // The brick isosurface
    
    #switch (BlockType) 

      #case (awPerfectBlock)
        isosurface { 
          function {awfnBrick (x,y,z) }
          method 2
          max_trace 5
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awDamagedFaceBlock1)
        isosurface { 
          function {awfnBrick (x,y,z) -
                    awfnBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awDamagedFaceBlock2)
        isosurface { 
          function {awfnBrick (x, y, z) -
                    awfnBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize +
                    awfnCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awRoughBlock)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awWeatheredBlock)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize +
                    awfnCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          method 2
          max_trace 5 
          eval
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awCrackedBlock)
        isosurface { 
          function {awfnBrick (x, y, z) -
                    awfnBumps (x + bumpx, y + bumpy, z + bumpz) * BumpSize +
                    awfnCracks2 (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awSmoothWeatheredBlock1)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awSmoothWeatheredBlock2)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnCracks2 (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awDamagedBlock)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize +
                    awfnCracks2 (x + bumpx, y + bumpy, z + bumpz) * CrackSize }
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #case (awCrackleBlock)
        isosurface { 
          function {awfnBrick (x, y, z) +
                    awfnCracks (x + bumpx, y + bumpy, z + bumpz) * CrackSize +
                    awfnCrackle (x + bumpx, y + bumpy, z + bumpz) * CrackSize }                
          method 2
          eval
          accuracy 0.000001
          max_trace 15                    
          contained_by { box { <-dpt.x/2, -dpt.y/2, -dpt.z/2>, <dpt.x/2, dpt.y/2, dpt.z/2> } } 
        }    
      #break

      #else                                     
        #warning concat ("Unrecognize BlockType of ", str(BlocKType), " in awStoneBrick");
    #end

    // Position the block where it belongs
    
    translate <pt1.x+dpt.x/2,pt1.y+dpt.y/2,pt1.z+dpt.z/2>
  }  
#end                                     
      
#end