// Persistence of Vision Ray Tracer Scene Description File
// File: ColumnTest2.pov
// Vers: MegaPov 0.5a
// Desc: Test scene of isosurface stone blocks and image mapped column segments
// Date: 2000.08.27     
// Auth: the autowitch (aka d. gold)
//       The Pittsburg Tank And Boiler Company 
   
// Standard includes
   
#include "colors.inc"
#include "stones.inc"

// Custom Macro Includes

#include "awStoneBlockMacs2.inc"
#include "awStoneWallMacs1.inc"
#include "awSuperellipsoid.inc"

#version unofficial MegaPov 0.5;      

// Global settings
// Undergroung scene: Use extremely low ambient light.  

global_settings
{
  assumed_gamma 1.0    
  ambient_light 0
}

// ----------------------------------------

// Test cameras

/*camera
{
  location  <10, 4, 10.0>
  direction 1.5*z
  right     4/3*x
  look_at   <20.0, 4.0, 20.0>
}

camera { location <17,4,10> look_at <17,4,20> }
camera { location <17,1,10> look_at <17,1,20> }
camera { location <17,40,19> look_at <17,1,20> }
*/

// Final camera

camera
{
  location  <2, 6, 8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <18.0, 1.5, 20.0>
}

// Background settings

background { Black } 
             
// Test Light sources

/* 
light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
*/
/*
light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <8, 8, -18>
}          
*/

// Final light source

light_source {
  <8, 8, 0>
  White * 0.5 + Gold
  spotlight 
    radius 3 
    falloff 30 
    tightness 1 
    point_at <15, 2.0, 20>
  area_light <2, 0, 0>, <0, 2, 0>, 8, 8 
    jitter 
    adaptive 1
  fade_distance 17
  fade_power 4
}
                                                          
                                                          
#declare verydull = finish { specular 0.35 roughness 0.35 }

#declare awBlockRandom = seed(32121.432);                                           

union {
  
  // Test code from Temple1.inc
  // Raise walls to prevent seeing over the low Temple1.inc walls and strip
  // fallen blocks, front walls, t1 columns, and left wall, *other than that*
  // leave intact.  
  
  // Textures from stones.inc are used.  The effects of the isosurface make
  // them look a bit different.  **** custom stone textures could result in
  // some very interesting results...  The isosurface and verydull finish
  // have a tendency to really deintensify the texture.
  
  // Note: rework finish texture.

  // Temple walls

  // back wall
    
  object { 
    awStoneWall (40, 30, 6, 2, 2, -0.2,
                 0.05, 2, 0.25, 0.25,
                 0.3, 0.08, 0.3, 1, awWeatheredBlock, texture { T_Stone11 finish { verydull } },
                 -0.15, 2, 2) 
    translate <-20, -18.5, 23> 
  }                                 

  // Right wall         

  object { 
    awStoneWall (50, 30, 6, 2, 2, -0.2,
                 0.05, 2, 0.25, 0.25,
                 0.3, 0.08, 0.3, 1, awWeatheredBlock, texture { T_Stone11 finish { verydull } },
                 -0.15, 2, 2) 
    rotate 90*y                 
    translate <18, -18.5, 25> 
  }                           

                  
  // Floor                         

  object { 
    awStoneWall (36, 14, 3, 3, 3.1357, -0.2,
                 0.05, 1, 0.5, 0.25,
                 0.3, 0.08, 0.3, 1, awWeatheredBlock, texture { T_Stone11 finish { verydull } },
                 -0.15, 0, 0) 
    rotate 90*x                 
    translate <-18, 0.14, -17> 
  }                                  
}


// The three column segments

// Note: Clipping to walls and floor is intentional
// Variances in intersecting cylinder diameter control amount of weathering.
// increase diameter to increase weathering.  It would pry make more sense to
// decreae the isosurface diameter, but....

intersection {
  
  object { awSuperellipsoid (<0, 0, 0>, 5, 1.5, 1.5, 1, 0.2, awSEWeathered1, 0.08, 0.3, 1)
           texture { T_Stone3 finish { verydull } }   
  }
  
  cylinder { <0, -1, 0>, <0, 6, 0>, 1.525 
    texture {                        
      pigment {
        image_map {
          png "A73.png"  
          once
          map_type 2
        } 
        scale 5
      }
      normal {
        granite 
          bump_size 0.01
      }
    }
  }
  rotate <0, 0, -20>
  translate <15, 0.25, 20>
}   
  
intersection {
  
  object { awSuperellipsoid (<0, 0, 0>, 5, 1.5, 1.5, 1, 0.2, awSEWeathered1, 0.08, 0.3, 1)
           texture { T_Stone14 finish { verydull } }   
  }
  
  cylinder {<0,-1,0>, <0,6,0>, 1.54 
    texture {                        
      pigment {
        image_map {
          png "A73.png"  
          once
          map_type 2
        } 
        scale 5
      }
      normal {
        granite 
          bump_size 0.01
      }
    }
  }
  rotate <90,-70,0>
  translate <15.95,1.53,14>
  texture { pigment { colour Red } }
}   

 
intersection {
  
  object { awSuperellipsoid (<0, 0, 0>, 5, 1.5, 1.5, 1, 0.2, awSEWeathered1, 0.08, 0.3, 1)
           texture { T_Stone11 finish { verydull } }   
  }
  
  cylinder {<0, -1, 0>, <0, 6, 0>, 1.60 
   texture {                        
      pigment {
        image_map {
          png "A73.png"  
          once
          map_type 2
        } 
        scale 5
      }
      normal {
        granite bump_size 0.01
      }
    }
  }
  rotate <90, -20, 0>
  translate <11, 1.59, 17.2>
} 

  
