// demo file for "lightning.inc"

#include "colors.inc"
camera{location<0,10,-25> look_at<0,5,0>}
light_source{0*x color rgb<1,1,1> translate y*50}
plane{y,-0.1 pigment{Grey}} // normal{wrinkles}}

#include "lightning.inc"

Make_Bolt()
object{
  Lightning_Bolt
  pigment{Blue}
  finish{ambient 1}
  translate y*10
}

#declare LSeed = 5234;
#declare LBranch = 0.035;
#declare LSpread = 0.5;
#declare LSpike = 0.75;
#declare doLights = true;
#declare lightColour = <1,1,0.5>*0.5;
#declare doMerge = true; // remove or set this to false (union rather than merge) for a faster render
Make_Bolt()
object{
  Lightning_Bolt
  pigment{rgbf 1}
  interior{media{emission <10,10,5>}}
  hollow on
  translate y*10
  translate x*10
}

#declare LSeed = 7258;
#declare LBranch = 0.032;
#declare LSpread = 0.15;
#declare LSpike = 0.05;
#declare doLights = false;
#declare LCutoff = 2.5;
#declare LWidth = 0.1;
Make_Bolt()
object{
  Lightning_Bolt
  pigment{Green}
  finish{ambient 1}
  translate y*10
  translate x*-10
}

