color LocIllumWardAnisotropic (normal N;  vector V;
                         vector xdir;  float xroughness, yroughness;)
{
    float sqr (float x) { return x*x; }

    float cos_theta_r = clamp (N.V, 0.0001, 1);
    vector X = xdir / xroughness;
    vector Y = (N ^ xdir) / yroughness;

    color C = 0;
    extern point P;
    illuminance (P, N, PI/2) {
        extern vector L;
        extern color Cl;
        vector LN = normalize (L);
        float cos_theta_i = LN . N;
        if (cos_theta_i > 0.0) {
            vector H = normalize (V + LN);
            float rho = exp (-2 * (sqr(X.H) + sqr(Y.H)) / (1 + H.N))
                    / sqrt (cos_theta_i * cos_theta_r);
            C += Cl * ( cos_theta_i * rho);
        }
    }
    return C / (4 * xroughness * yroughness);
}


color MaterialMetal (normal Nf;  color basecolor;
            float Ka, Kd, Ks;
            vector xdir;  float xroughness, yroughness;)
{
    extern vector I;
    color spec = LocIllumWardAnisotropic (Nf, -normalize(I),
          xdir, xroughness, yroughness);
    return basecolor * (Ka*ambient() + Kd*diffuse(Nf) + Ks*spec);
}

surface anisoMetal ( float Ka = 1, Kd = 0.1, Ks = .9;
               float xroughness = 0.15, yroughness = 0.5; 
               vector brush_direction = vector(1,0,0))
{
    normal Nf = faceforward (normalize(N), I);
    normal vec = N ^ brush_direction;
    Ci = MaterialMetal (Nf, Cs, Ka, Kd, Ks, 
        normalize(vec), xroughness, yroughness);
}
