//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 26 materials and 950 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 09/18/2000    (18.09.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

#version unofficial MegaPov 0.5;

default {
  texture {
    pigment { rgb <1,1,1> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.007843,0.007843,0.007843>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  reflection_samples 10
  radiosity {
    brightness       1.0
    count            100
    distance_maximum 4.0
    error_bound      .2
    gray_threshold   0.0
    low_error_factor 0.5
    minimum_reuse    0.015
    nearest_count    3
    recursion_limit  1
    pretrace_start .08
    pretrace_end .001
	  normal on
  } 
}

background { color <0.843,0.843,0.843> }

camera {  //  Camera StdCam1
  location  <      6.079,       1.262,       1.220>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.78492,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         15.15769    // Vertical       8.526
  look_at   <     -0.865,       0.012,      -0.146>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <     10.000,     -14.000,       1.500>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.79830,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         25.52056    // Vertical      14.355
  look_at   <     -4.000,       0.000,      -0.500> // Following R2AndTracks
}

*/

/*
camera {  //  Camera StdCam2
  location  <      0.000,       3.621,       0.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33725,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         16.19795    // Vertical      12.148
  look_at   <      0.009,       0.096,      -0.157>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.829>*1.5000
  translate  <-161.6547, -155.5143, 122.4132>
}


//
// ********  MATERIALS  *******
//

#include "r2d2s33.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube403 = object {
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, -9.75, 0.0>
    material {
      R2D2Clear
      translate <0.003000, -8.750000, 0.000000>
    }
    scale <0.004, 0.02, 0.037>
    rotate -48.0*z
    translate  -0.42*z
  }
}
#declare CircleCorner = difference {
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    scale <0.028188, 0.0275, 0.025>
    rotate 90.0*x
    translate  <0.0, -0.189, -0.446>
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    scale <0.017938, 0.0175, 0.03>
    rotate 90.0*x
    translate  <0.0, -0.1881, -0.446>
  }
  plane { // Plane269
    z,0
    rotate -90.0*y
    translate  -0.0082*x
  }
  plane { // Plane270
    z,0
    translate  -0.4376*z
  }
  translate  0.446*z
  translate  -0.446*z
}
#declare CircleCorner1 = object {
  object { // CircleCorner1 -> CircleCorner
    CircleCorner
    scale -1.0
    rotate 180.0*z
    translate  -0.892*z
  }
}
#declare VentOne = difference {
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.01, 0.002>
    translate  <0.0, -0.2069, -0.2202>
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0145, 0.01, 0.01>
    translate  <0.0, -0.202, -0.2203>
  }
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2Aluminum
    }
    scale <0.018, 0.01, 0.002>
    translate  <0.0, -0.204, -0.2165>
  }
  translate  <0.0, 0.1969, 0.2182>
  material {
    R2D2AluminumDark
  }
  scale <1.0, 1.3, 1.0>
  rotate 75.0*x
  translate  <0.0, -0.191, -0.1953>
}
#declare VentOne4 = difference {
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.01, 0.002>
    translate  <0.0, -0.2069, -0.2202>
  }
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0145, 0.01, 0.01>
    translate  <0.0, -0.202, -0.2203>
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2Aluminum
    }
    scale <0.018, 0.01, 0.002>
    translate  <0.0, -0.204, -0.2165>
  }
  translate  <0.0, 0.1969, 0.2182>
  material {
    R2D2AluminumDark
  }
  scale <1.0, 1.3, 1.0>
  rotate 75.0*x
  translate  <0.0, -0.1996, -0.1953>
}
#declare Cube419 = object {
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.01, 0.0045>
    translate  <0.0, -0.2069, -0.26835>
  }
}
#declare OneCubeSet = difference {
  object { Cube419 }
  object { // Cube420 -> Cube419
    Cube419
    material {
      R2D2BlueMetal
    }
    scale <0.85, 1.1, 0.7>
    translate  <0.0, 0.0025, -0.080505>
  }
  translate  0.0057*y
}
#declare Cylndr311 = object {
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    scale <0.01025, 0.01, 0.001>
    rotate 90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
}
#declare WedgePlaneCuts = difference {
  box { // Cube421
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00825, 0.00855, 0.012>
    translate  <0.0, -0.1984, -0.4294>
  }
  plane { // Plane381
    z,0
    rotate <0.0, 95.0, 10.0>
    translate  <-0.0082, -0.1899, -0.44>
  }
  plane { // Plane382
    z,0
    rotate <0.0, -95.0, -10.0>
    translate  <0.0082, -0.1899, -0.44>
  }
  translate  0.446*z
  translate  -0.446*z
}
#declare WedgePlaneCuts1 = difference {
  box { // Cube422
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00825, 0.00855, 0.012>
    translate  <0.0, -0.1984, -0.4294>
  }
  plane { // Plane383
    z,0
    rotate <0.0, 95.0, 10.0>
    translate  <-0.0082, -0.1899, -0.44>
  }
  plane { // Plane384
    z,0
    rotate <0.0, -95.0, -10.0>
    translate  <0.0082, -0.1899, -0.44>
  }
  translate  0.446*z
  scale <1.025, 1.0, 1.0>
  rotate -90.0*y
  translate  -0.446*z
}
#declare Cube434 = object {
  box { // Cube434
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, -9.75, 0.0>
    material {
      R2D2AlumBlueGrad
      translate <0.003000, -8.750000, 0.000000>
    }
    scale <0.004, 0.02, 0.06>
    rotate -82.0*z
    translate  -0.2998*z
  }
}
#declare CutAngle = union {
  box { // Cube446
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate 22.0*y
    translate  <0.2282, 0.0, -0.5298>
  }
  box { // Cube447
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate -22.0*y
    translate  <-0.2282, 0.0, -0.5298>
  }
  rotate -40.0*z
}
#declare ArmMain = union {
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 0.040199>
    rotate 90.0*y
    translate  <-0.255, 0.02, -0.1275>
  }
  box { // Cube468
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0201, 0.05314, 0.120773>
    translate  <-0.2349, 0.02, -0.359564>
  }
  box { // Cube469
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0201, 0.09, 0.0644>
    translate  <-0.2349, 0.02, -0.1915>
  }
  box { // Cube470
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 1.0>
    scale <0.0201, 0.025, 0.02>
    rotate 20.0*x
    translate  <-0.2349, 0.11, -0.2559>
  }
  box { // Cube471
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.0, 1.0>
    scale <0.0201, 0.025, 0.02>
    rotate -20.0*x
    translate  <-0.2349, -0.07, -0.2559>
  }
}
#declare CSG170 = union {
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    scale <0.0875, 0.0875, 0.01>
    rotate 90.0*y
    translate  <-0.2399, 0.02, -0.1275>
  }
  box { // Cube472
    <-1, -1, -1>, <1, 1, 1>
    scale <0.005, 0.0875, 0.0644>
    translate  <-0.2349, 0.02, -0.1915>
  }
  box { // Cube473
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 1.0>
    scale <0.005, 0.025, 0.02>
    rotate 20.0*x
    translate  <-0.2349, 0.1075, -0.2559>
  }
  box { // Cube474
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.0, 1.0>
    scale <0.005, 0.025, 0.02>
    rotate -20.0*x
    translate  <-0.2349, -0.0675, -0.2559>
  }
  scale 1.052632
  translate  <0.0128, 0.0, 0.0067>
}
#declare ArmThin = difference {
  object { CSG170 }
  scale 0.95
  translate  <-0.0337, 0.0, -0.0064>
}
#declare CSG171 = union {
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 0.018273>
    rotate 90.0*y
    translate  <-0.24403, 0.02, -0.1275>
  }
  box { // Cube475
    <-1, -1, -1>, <1, 1, 1>
    scale <0.009136, 0.09, 0.0644>
    translate  <-0.2349, 0.02, -0.1915>
  }
  box { // Cube476
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 1.0>
    scale <0.009136, 0.025, 0.02>
    rotate 20.0*x
    translate  <-0.2349, 0.11, -0.2559>
  }
  box { // Cube477
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.0, 1.0>
    scale <0.009136, 0.025, 0.02>
    rotate -20.0*x
    translate  <-0.2349, -0.07, -0.2559>
  }
}
#declare CSG172 = union {
  box { // Cube478
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.046875, 0.1>
    translate  <-0.2657, 0.02, -0.2668>
  }
  box { // Cube479
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.0, 1.0>
    scale <0.01, 0.025, 0.02>
    rotate -50.0*x
    translate  <-0.2657, -0.026877, -0.1668>
  }
  box { // Cube480
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 1.0>
    scale <0.01, 0.025, 0.02>
    rotate 50.0*x
    translate  <-0.2657, 0.0668, -0.1668>
  }
  scale <1.1, 1.0, 1.0>
  translate  0.05737*x
}
#declare ArmUpper = difference {
  object { CSG171 }
  object { CSG172 }
  box { // Cube481
    <-1, -1, -1>, <1, 1, 1>
    scale 0.0125
    translate  <-0.239, 0.0898, -0.145>
  }
  box { // Cube482
    <-1, -1, -1>, <1, 1, 1>
    scale 0.0125
    translate  <-0.239, 0.0898, -0.179>
  }
  box { // Cube483
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0075, 0.0125, 0.0575>
    translate  <-0.2441, -0.0491, -0.1935>
  }
  translate  -0.0311*x
}
#declare Arm = union {
  object { ArmMain }
  object { ArmThin }
  object { ArmUpper }
}
#declare ArmCuts = difference {
  object { Arm }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    scale <0.039581, 0.039581, 0.03>
    rotate -90.0*y
    translate  <-0.2466, 0.02, -0.1275>
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    scale <0.019791, 0.019791, 0.03>
    rotate -90.0*y
    translate  <-0.2185, 0.02, -0.1275>
  }
  material {
    R2D2BodyMain
  }
}
#declare CSG173 = union {
  box { // Cube484
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.0, 0.999998>
    scale <0.02, 0.04, 0.1543>
    translate  <-0.2657, 0.02, -0.48034>
  }
  box { // Cube485
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.0, 1.0>
    scale <0.02, 0.025, 0.02>
    rotate -50.0*x
    translate  <-0.2657, -0.02, -0.1718>
  }
  box { // Cube486
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 1.0>
    scale <0.02, 0.025, 0.02>
    rotate 50.0*x
    translate  <-0.2657, 0.06, -0.1718>
  }
  material {
    R2D2BlueMetal
  }
  scale <1.1, 1.0, 1.0>
  translate  0.0263*x
}
#declare BlueAtrmCuts = difference {
  object { CSG173 }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 0.05
    material {
      R2D2BlueMetal
    }
    scale <1.0, 1.0, 0.045>
    rotate -90.0*y
    translate  <-0.2466, 0.02, -0.1275>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.039581, 0.039581, 0.06>
    rotate -90.0*y
    translate  <-0.2396, 0.02, -0.1275>
  }
  box { // Cube487
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale 0.05
    rotate -3.0*y
    translate  <-0.2843, 0.02, -0.2352>
  }
  box { // Cube488
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale 0.05
    rotate -35.0*y
    translate  <-0.2752, 0.02, -0.2393>
  }
  box { // Cube489
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale 0.05
    rotate -25.0*y
    translate  <-0.2752, 0.02, -0.2812>
  }
  box { // Cube490
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <0.1, 0.05, 0.05>
    rotate -90.0*y
    translate  <-0.2752, 0.02, -0.2812>
  }
  box { // Cube491
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale 0.05
    rotate -25.0*y
    translate  <-0.2752, 0.02, -0.2491>
  }
  box { // Cube492
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.0, 1.0, 1.0>
    scale 0.05
    rotate <0.0, -90.0, 60.0>
    translate  <-0.2752, -0.0044, -0.2438>
  }
  box { // Cube493
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.0, 1.0, 1.0>
    scale 0.05
    rotate <0.0, -90.0, 30.0>
    translate  <-0.2752, 0.0446, -0.2438>
  }
  box { // Cube494
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <0.05, 0.05, 0.005>
    translate  <-0.2752, 0.02, -0.2491>
  }
  box { // Cube495
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.0, 1.0, 1.0>
    scale <0.01605, 0.05, 0.05>
    rotate -90.0*y
    translate  <-0.2752, 0.0446, -0.2491>
  }
  box { // Cube496
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.0, 1.0, 1.0>
    scale <0.01605, 0.05, 0.05>
    rotate <0.0, -90.0, 90.0>
    translate  <-0.2752, -0.0044, -0.2491>
  }
  material {
    R2D2BlueMetal
  }
}
#declare BlueMainLong = union {
  object { BlueAtrmCuts }
}
#declare SquareInsert = union {
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    scale <0.011, 0.011, 0.016>
    rotate -90.0*y
    translate  <-0.26, 0.0898, -0.145>
  }
  sphere { // Sphere067
    <0,0,0>,1
    scale <0.002, 0.005, 0.005>
    translate  <-0.276, 0.0898, -0.145>
  }
  material {
    R2D2Aluminum
  }
}
#declare SquareInsert1 = union {
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    scale <0.011, 0.011, 0.016>
    rotate -90.0*y
    translate  <-0.26, 0.0898, -0.179>
  }
  sphere { // Sphere068
    <0,0,0>,1
    scale <0.002, 0.005, 0.005>
    translate  <-0.276, 0.0898, -0.179>
  }
  material {
    R2D2Aluminum
  }
}
#declare RectangleInsert = union {
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    scale <0.008, 0.008, 0.015>
    translate  <-0.27, -0.0491, -0.167>
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    scale <0.005, 0.005, 0.015>
    translate  <-0.27, -0.0491, -0.1598>
  }
  sphere { // Sphere069
    <0,0,0>,1
    scale <0.005, 0.005, 0.0075>
    translate  <-0.27, -0.0491, -0.1448>
  }
  material {
    R2D2Aluminum
  }
  translate  -0.0035*z
}
#declare RectangleInsert1 = union {
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    scale <0.008, 0.008, 0.025>
    translate  <-0.27, -0.0491, -0.167>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    scale <0.005, 0.005, 0.015>
    translate  <-0.27, -0.0491, -0.1457>
  }
  sphere { // Sphere070
    <0,0,0>,1
    scale <0.005, 0.005, 0.015>
    translate  <-0.27, -0.0491, -0.1307>
  }
  material {
    R2D2Aluminum
  }
  translate  -0.077*z
}
#declare RndDisc012 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0067, 0.0067, 0.0150> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0057, 0.0057, 0.0153> translate -0.0001*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0075, 0.0075, 0.0135> translate 0.0007*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0050, 0.0050, 0.0153> translate -0.0006*z }
  }
  torus { 0.0067, 0.0007  rotate -x*90 translate  0.0142*z bounded_by { box { <-0.0075, -0.0075, 0.0135>, <0.0075, 0.0075, 0.0150> } } }
  torus { 0.0067, 0.0007  rotate -x*90 translate  0.0007*z bounded_by { box { <-0.0075, -0.0075, -0.0000>, <0.0075, 0.0075, 0.0015> } } }
  torus { 0.0057, 0.0007  rotate -x*90 translate  0.0142*z bounded_by { box { <-0.0065, -0.0065, 0.0135>, <0.0065, 0.0065, 0.0150> } } }
  torus { 0.0057, 0.0007  rotate -x*90 translate  0.0007*z bounded_by { box { <-0.0058, -0.0058, -0.0000>, <0.0058, 0.0058, 0.0008> } } }
  scale <0.75, 1.0, 1.0>
  translate  <-0.2752, 0.02, -0.3032>
}
#declare RndDisc013 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0067, 0.0067, 0.0150> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0057, 0.0057, 0.0153> translate -0.0001*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0075, 0.0075, 0.0135> translate 0.0007*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0050, 0.0050, 0.0153> translate -0.0006*z }
  }
  torus { 0.0067, 0.0007  rotate -x*90 translate  0.0142*z bounded_by { box { <-0.0075, -0.0075, 0.0135>, <0.0075, 0.0075, 0.0150> } } }
  torus { 0.0067, 0.0007  rotate -x*90 translate  0.0007*z bounded_by { box { <-0.0075, -0.0075, -0.0000>, <0.0075, 0.0075, 0.0015> } } }
  torus { 0.0057, 0.0007  rotate -x*90 translate  0.0142*z bounded_by { box { <-0.0065, -0.0065, 0.0135>, <0.0065, 0.0065, 0.0150> } } }
  torus { 0.0057, 0.0007  rotate -x*90 translate  0.0007*z bounded_by { box { <-0.0058, -0.0058, -0.0000>, <0.0058, 0.0058, 0.0008> } } }
  scale <0.75, 1.0, 1.0>
  translate  <-0.2752, 0.02, -0.3293>
}
#declare BlueWhiteThing = union {
  box { // Cube497
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <0.003, 0.0125, 0.0125>
    rotate -25.0*y
    translate  <-0.2752, 0.02, -0.2812>
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    scale 0.005
    rotate <180.0, -65.0, 180.0>
    translate  <-0.285, 0.02, -0.272>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    scale <0.0035, 0.005, 0.2>
    rotate <180.0, 0.0, 180.0>
    translate  <-0.2752, 0.02, -0.2812>
  }
  object { RndDisc012 }
  object { RndDisc013 }
  material {
    R2D2White
  }
}
#declare Joint = union {
  box { // Cube498
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0275, 0.0575, 0.047293>
    translate  <-0.237, 0.02, -0.5246>
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.0575, 0.094585>
    translate  <-0.2651, 0.02, -0.5719>
  }
}
#declare JointCut = difference {
  object { Joint }
  plane { // Plane420
    z,0
    rotate 65.0*y
    translate  <-0.2637, 0.0, -0.5725>
  }
}
#declare CSG174 = intersection {
  box { // Cube501
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014, 0.06, 0.025>
    translate  <-0.2206, 0.02, -0.54>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.125>
    rotate -90.0*x
    translate  <-0.2204, -0.0434, -0.5146>
  }
}
#declare CSG175 = union {
  box { // Cube499
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.06, 0.02>
    translate  <-0.2498, 0.02, -0.5235>
  }
  box { // Cube500
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 0.0, 1.0>
    scale <0.0155, 0.06, 0.0185>
    rotate 22.0*y
    translate  <-0.2348, 0.02, -0.5435>
  }
  object { CSG174 }
  translate  -0.0284*z
}
#declare MoreJointCut = difference {
  object { CSG175 }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 0.135>
    rotate -90.0*x
    translate  <-0.2096, -0.0481, -0.5323>
  }
  material {
    R2D2Aluminum
  }
}
#declare JointBase = intersection {
  box { // Cube502
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035, 0.0575, 0.02>
    translate  <-0.2456, 0.02, -0.616>
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.08>
    rotate -90.0*y
    translate  <-0.2071, 0.02, -0.536>
  }
  translate  0.0283*z
}
#declare LegJoint = union {
  object { JointCut }
  object { MoreJointCut }
  object { JointBase }
  material {
    R2D2BodyMain
  }
  translate  0.0284*z
}
#declare Pivot = union {
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate 90.0*x
    translate  <-0.2698, 0.0, -0.5447>
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate -90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.012, 0.012, 0.04>
    rotate 90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  sphere { // Sphere071
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, -0.05, -0.5447>
  }
  sphere { // Sphere072
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, 0.09, -0.5447>
  }
  box { // Cube503
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.007, 0.02, 0.02>
    rotate 10.0*y
    translate  <-0.2603, 0.02, -0.5245>
  }
  box { // Cube504
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.01, 0.02, 0.007>
    translate  <-0.2555, 0.02, -0.5373>
  }
  material {
    R2D2Aluminum
  }
  translate  <-0.0157, 0.0, 0.001>
}
#declare Cube507 = object {
  box { // Cube507
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.3044, -0.1464, -0.711>
  }
}
#declare Cube508 = object {
  box { // Cube508
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.3044, 0.1834, -0.711>
  }
}
#declare Cube509 = object {
  box { // Cube509
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.022, 0.003>
    translate  <-0.3367, 0.1384, -0.711>
  }
}
#declare Cube520 = object {
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.022, 0.003>
    translate  <-0.1581, 0.1384, -0.711>
  }
}
#declare Cube531 = object {
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0025, 0.004, 0.0075>
    translate  <-0.3157, 0.02, -0.641>
  }
}
#declare CableNipple = difference {
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    scale 0.007
    rotate 90.0*x
    translate  <-0.1813, -0.0576, -0.689>
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    scale <0.006, 0.006, 0.008>
    rotate 90.0*x
    translate  <-0.1813, -0.0572, -0.689>
  }
  translate  <0.0012, 0.0, 0.0034>
}
#declare CableNipple2 = difference {
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    scale 0.007
    rotate 90.0*x
    translate  <-0.1813, -0.0576, -0.689>
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    scale <0.006, 0.006, 0.008>
    rotate 90.0*x
    translate  <-0.1813, -0.0572, -0.689>
  }
  translate  <-0.0699, 0.0, 0.006>
}
#declare Tubes = union {
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    scale <0.006, 0.006, 0.106>
    translate  <-0.1839, -0.049, -0.6696>
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    scale <0.0075, 0.0075, 0.03>
    translate  <-0.1839, -0.049, -0.6156>
  }
  material {
    R2D2Aluminum
  }
  translate  <-0.002, 0.02, -0.1279>
}
#declare RndCube029 = merge {
  sphere { <0.0000, 0.1450, 0.0550>, 0.0350 }
  sphere { <0.0000, -0.1450, 0.0550>, 0.0350 }
  sphere { <0.0000, 0.1450, -0.0550>, 0.0350 }
  sphere { <0.0000, -0.1450, -0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, -0.0550>, <0.0000, 0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, -0.1450, -0.0550>, <0.0000, -0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, 0.0550>, <0.0000, -0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, -0.0550>, <0.0000, -0.1450, -0.0550>, 0.0350 }
  box { <-0.0350, -0.1450, -0.0550> <0.0350, 0.1450, 0.0550> }
// Attributes returned success!
  translate  <-0.1675, 0.02, -0.617>
}
#declare Foot = difference {
  box { // Cube505
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.155715, 0.075633>
    translate  <-0.2477, 0.02, -0.6559>
  }
  object { RndCube029 }
  plane { // Plane421
    z,0
    rotate -60.0*y
    translate  <-0.1677, 0.0, -0.7071>
  }
  plane { // Plane422
    z,0
    rotate 60.0*y
    translate  <-0.3277, 0.0, -0.7071>
  }
  plane { // Plane423
    z,0
    rotate -60.0*x
    translate  <-0.2477, -0.135716, -0.7071>
  }
  plane { // Plane424
    z,0
    rotate 60.0*x
    translate  <-0.2477, 0.175714, -0.7071>
  }
  plane { // Plane425
    z,0
    rotate 107.0*y
    translate  <-0.3277, 0.0, -0.7071>
  }
  plane { // Plane426
    z,0
    rotate -117.0*x
    translate  <-0.2477, -0.135716, -0.7071>
  }
  plane { // Plane427
    z,0
    rotate 117.0*x
    translate  <-0.2477, 0.175714, -0.7071>
  }
  box { // Cube506
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 0.16, 0.02>
    translate  <-0.2512, 0.0196, -0.5999>
  }
  object { Cube507 }
  object { Cube508 }
  object { Cube509 }
  object { // Cube510 -> Cube509
    Cube509
    rotate -0.0*z
    translate  -0.06*y
  }
  object { // Cube511 -> Cube509
    Cube509
    rotate -0.0*z
    translate  -0.12*y
  }
  object { // Cube512 -> Cube509
    Cube509
    rotate -0.0*z
    translate  -0.18*y
  }
  object { // Cube513 -> Cube509
    Cube509
    rotate -0.0*z
    translate  -0.24*y
  }
  object { // Cube514 -> Cube508
    Cube508
    rotate <0.0, 0.0, 0.0>
    translate  <0.038, 0.0, -0.0>
  }
  object { // Cube515 -> Cube508
    Cube508
    rotate <0.0, 0.0, 0.0>
    translate  <0.076, 0.0, -0.0>
  }
  object { // Cube516 -> Cube508
    Cube508
    rotate <0.0, 0.0, 0.0>
    translate  <0.114, 0.0, -0.0>
  }
  object { // Cube517 -> Cube507
    Cube507
    translate  <0.038, -0.0, 0.0>
  }
  object { // Cube518 -> Cube507
    Cube507
    translate  <0.076, -0.0, 0.0>
  }
  object { // Cube519 -> Cube507
    Cube507
    translate  <0.114, -0.0, 0.0>
  }
  object { Cube520 }
  object { // Cube521 -> Cube520
    Cube520
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.06, 0.0>
  }
  object { // Cube522 -> Cube520
    Cube520
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.12, 0.0>
  }
  object { // Cube523 -> Cube520
    Cube520
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.18, 0.0>
  }
  object { // Cube524 -> Cube520
    Cube520
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.24, 0.0>
  }
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 0.125, 0.03>
    translate  <-0.22, 0.02, -0.723>
  }
  material {
    R2D2BodyMain
  }
  translate  <0.0, 0.02, -0.1275>
}
#declare RndCube030 = merge {
  sphere { <0.0000, 0.1450, 0.0550>, 0.0350 }
  sphere { <0.0000, -0.1450, 0.0550>, 0.0350 }
  sphere { <0.0000, 0.1450, -0.0550>, 0.0350 }
  sphere { <0.0000, -0.1450, -0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, -0.0550>, <0.0000, 0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, -0.1450, -0.0550>, <0.0000, -0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, 0.0550>, <0.0000, -0.1450, 0.0550>, 0.0350 }
  cylinder { <0.0000, 0.1450, -0.0550>, <0.0000, -0.1450, -0.0550>, 0.0350 }
  box { <-0.0350, -0.1450, -0.0550> <0.0350, 0.1450, 0.0550> }
// Attributes returned success!
  translate  <-0.1675, 0.02, -0.617>
}
#declare RoundCubeCuts = difference {
  object { RndCube030 }
  plane { // Plane428
    z,0
    rotate -90.0*x
    translate  <0.0, -0.0577, -0.5802>
  }
  plane { // Plane429
    z,0
    rotate 90.0*x
    translate  <0.0, 0.0977, -0.5802>
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.0075, 0.0525>
    translate  <-0.1675, -0.0507, -0.617>
  }
  translate  <0.0, 0.02, -0.1275>
}
#declare FootMetal = difference {
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 0.16, 0.0375>
    translate  <-0.2512, 0.0196, -0.659>
  }
  plane { // Plane430
    z,0
    rotate -117.0*x
    translate  <-0.2477, -0.1389, -0.707>
  }
  plane { // Plane431
    z,0
    rotate 117.0*x
    translate  <-0.2477, 0.1804, -0.7077>
  }
  material {
    R2D2Aluminum
  }
  translate  <0.0, 0.02, -0.1275>
}
#declare CylinderHalf = difference {
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.08, 0.05>
    rotate 90.0*y
  }
  plane { // Plane432
    z,0
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    scale <0.088, 0.078, 0.00704>
    rotate -90.0*y
    translate  0.002*x
  }
  translate  <-0.3228, 0.04, -0.8196>
}
#declare FootAdds = union {
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.025, 0.03>
    translate  <-0.306, 0.02, -0.6529>
  }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.02, 0.025>
    rotate 15.0*y
    translate  <-0.3014, 0.1339, -0.6529>
  }
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.02, 0.025>
    rotate 15.0*y
    translate  <-0.3014, -0.0934, -0.6529>
  }
}
#declare FootAddCuts = difference {
  object { FootAdds }
  plane { // Plane433
    z,0
    rotate -117.0*x
    translate  <-0.2477, -0.1387, -0.7071>
  }
  plane { // Plane434
    z,0
    rotate 117.0*x
    translate  <-0.2477, 0.1792, -0.7071>
  }
  object { Cube531 }
  object { // Cube532 -> Cube531
    Cube531
    translate  -0.015*y
  }
  object { // Cube533 -> Cube531
    Cube531
    translate  0.015*y
  }
  translate  <-0.0069, 0.02, -0.142>
}
#declare PairOne = union {
  object { CableNipple }
  object { // CableNipple1 -> CableNipple
    CableNipple
    translate  0.025*x
  }
}
#declare PairTwo = union {
  object { CableNipple2 }
  object { // CableNipple3 -> CableNipple2
    CableNipple2
    translate  0.05*z
  }
  rotate -27.0*x
  translate  <0.0, 0.2356, -0.0999>
}
#declare Couplers = union {
  object { PairOne }
  object { PairTwo }
  material {
    R2D2Aluminum
  }
  translate  <0.0, 0.02, -0.1275>
}
#declare BSpline001 = merge {
triangle { <14.9991, -0.0003, -0.0939>, <14.9403, 0.0001, -0.0748>, <14.9991, -0.0009, -0.0939>}
triangle { <14.9403, 0.0001, -0.0748>, <14.9991, -0.0009, -0.0939>, <14.9403, -0.0005, -0.0748>}
triangle { <14.9403, 0.0001, -0.0748>, <14.9040, 0.0004, -0.0248>, <14.9403, -0.0005, -0.0748>}
triangle { <14.9040, 0.0004, -0.0248>, <14.9403, -0.0005, -0.0748>, <14.9040, -0.0002, -0.0248>}
triangle { <14.9040, 0.0004, -0.0248>, <14.9040, 0.0006, 0.0370>, <14.9040, -0.0002, -0.0248>}
triangle { <14.9040, 0.0006, 0.0370>, <14.9040, -0.0002, -0.0248>, <14.9040, 0.0000, 0.0370>}
triangle { <14.9040, 0.0006, 0.0370>, <14.9404, 0.0006, 0.0870>, <14.9040, 0.0000, 0.0370>}
triangle { <14.9404, 0.0006, 0.0870>, <14.9040, 0.0000, 0.0370>, <14.9403, -0.0000, 0.0870>}
triangle { <14.9404, 0.0006, 0.0870>, <14.9991, 0.0003, 0.1061>, <14.9403, -0.0000, 0.0870>}
triangle { <14.9991, 0.0003, 0.1061>, <14.9403, -0.0000, 0.0870>, <14.9991, -0.0003, 0.1061>}
triangle { <14.9991, 0.0003, 0.1061>, <15.0579, -0.0001, 0.0870>, <14.9991, -0.0003, 0.1061>}
triangle { <15.0579, -0.0001, 0.0870>, <14.9991, -0.0003, 0.1061>, <15.0579, -0.0006, 0.0870>}
triangle { <15.0579, -0.0001, 0.0870>, <15.0942, -0.0004, 0.0370>, <15.0579, -0.0006, 0.0870>}
triangle { <15.0942, -0.0004, 0.0370>, <15.0579, -0.0006, 0.0870>, <15.0942, -0.0010, 0.0370>}
triangle { <15.0942, -0.0004, 0.0370>, <15.0942, -0.0006, -0.0248>, <15.0942, -0.0010, 0.0370>}
triangle { <15.0942, -0.0006, -0.0248>, <15.0942, -0.0010, 0.0370>, <15.0942, -0.0012, -0.0248>}
triangle { <15.0942, -0.0006, -0.0248>, <15.0579, -0.0006, -0.0748>, <15.0942, -0.0012, -0.0248>}
triangle { <15.0579, -0.0006, -0.0748>, <15.0942, -0.0012, -0.0248>, <15.0579, -0.0011, -0.0748>}
triangle { <15.0579, -0.0006, -0.0748>, <14.9991, -0.0003, -0.0939>, <15.0579, -0.0011, -0.0748>}
triangle { <14.9991, -0.0003, -0.0939>, <15.0579, -0.0011, -0.0748>, <14.9991, -0.0009, -0.0939>}
triangle { <14.9991, -0.0009, -0.0939>, <14.9403, -0.0005, -0.0748>, <14.9991, -0.0048, -0.0939>}
triangle { <14.9403, -0.0005, -0.0748>, <14.9991, -0.0048, -0.0939>, <14.9403, -0.0045, -0.0748>}
triangle { <14.9403, -0.0005, -0.0748>, <14.9040, -0.0002, -0.0248>, <14.9403, -0.0045, -0.0748>}
triangle { <14.9040, -0.0002, -0.0248>, <14.9403, -0.0045, -0.0748>, <14.9040, -0.0041, -0.0248>}
triangle { <14.9040, -0.0002, -0.0248>, <14.9040, 0.0000, 0.0370>, <14.9040, -0.0041, -0.0248>}
triangle { <14.9040, 0.0000, 0.0370>, <14.9040, -0.0041, -0.0248>, <14.9040, -0.0039, 0.0370>}
triangle { <14.9040, 0.0000, 0.0370>, <14.9403, -0.0000, 0.0870>, <14.9040, -0.0039, 0.0370>}
triangle { <14.9403, -0.0000, 0.0870>, <14.9040, -0.0039, 0.0370>, <14.9403, -0.0040, 0.0870>}
triangle { <14.9403, -0.0000, 0.0870>, <14.9991, -0.0003, 0.1061>, <14.9403, -0.0040, 0.0870>}
triangle { <14.9991, -0.0003, 0.1061>, <14.9403, -0.0040, 0.0870>, <14.9991, -0.0042, 0.1061>}
triangle { <14.9991, -0.0003, 0.1061>, <15.0579, -0.0006, 0.0870>, <14.9991, -0.0042, 0.1061>}
triangle { <15.0579, -0.0006, 0.0870>, <14.9991, -0.0042, 0.1061>, <15.0579, -0.0046, 0.0870>}
triangle { <15.0579, -0.0006, 0.0870>, <15.0942, -0.0010, 0.0370>, <15.0579, -0.0046, 0.0870>}
triangle { <15.0942, -0.0010, 0.0370>, <15.0579, -0.0046, 0.0870>, <15.0942, -0.0049, 0.0370>}
triangle { <15.0942, -0.0010, 0.0370>, <15.0942, -0.0012, -0.0248>, <15.0942, -0.0049, 0.0370>}
triangle { <15.0942, -0.0012, -0.0248>, <15.0942, -0.0049, 0.0370>, <15.0942, -0.0051, -0.0248>}
triangle { <15.0942, -0.0012, -0.0248>, <15.0579, -0.0011, -0.0748>, <15.0942, -0.0051, -0.0248>}
triangle { <15.0579, -0.0011, -0.0748>, <15.0942, -0.0051, -0.0248>, <15.0579, -0.0051, -0.0748>}
triangle { <15.0579, -0.0011, -0.0748>, <14.9991, -0.0009, -0.0939>, <15.0579, -0.0051, -0.0748>}
triangle { <14.9991, -0.0009, -0.0939>, <15.0579, -0.0051, -0.0748>, <14.9991, -0.0048, -0.0939>}
triangle { <14.9991, -0.0048, -0.0939>, <14.9403, -0.0045, -0.0748>, <14.9990, -0.0156, -0.0939>}
triangle { <14.9403, -0.0045, -0.0748>, <14.9990, -0.0156, -0.0939>, <14.9403, -0.0152, -0.0748>}
triangle { <14.9403, -0.0045, -0.0748>, <14.9040, -0.0041, -0.0248>, <14.9403, -0.0152, -0.0748>}
triangle { <14.9040, -0.0041, -0.0248>, <14.9403, -0.0152, -0.0748>, <14.9039, -0.0149, -0.0248>}
triangle { <14.9040, -0.0041, -0.0248>, <14.9040, -0.0039, 0.0370>, <14.9039, -0.0149, -0.0248>}
triangle { <14.9040, -0.0039, 0.0370>, <14.9039, -0.0149, -0.0248>, <14.9039, -0.0147, 0.0371>}
triangle { <14.9040, -0.0039, 0.0370>, <14.9403, -0.0040, 0.0870>, <14.9039, -0.0147, 0.0371>}
triangle { <14.9403, -0.0040, 0.0870>, <14.9039, -0.0147, 0.0371>, <14.9403, -0.0147, 0.0871>}
triangle { <14.9403, -0.0040, 0.0870>, <14.9991, -0.0042, 0.1061>, <14.9403, -0.0147, 0.0871>}
triangle { <14.9991, -0.0042, 0.1061>, <14.9403, -0.0147, 0.0871>, <14.9991, -0.0150, 0.1061>}
triangle { <14.9991, -0.0042, 0.1061>, <15.0579, -0.0046, 0.0870>, <14.9991, -0.0150, 0.1061>}
triangle { <15.0579, -0.0046, 0.0870>, <14.9991, -0.0150, 0.1061>, <15.0578, -0.0154, 0.0871>}
triangle { <15.0579, -0.0046, 0.0870>, <15.0942, -0.0049, 0.0370>, <15.0578, -0.0154, 0.0871>}
triangle { <15.0942, -0.0049, 0.0370>, <15.0578, -0.0154, 0.0871>, <15.0942, -0.0157, 0.0371>}
triangle { <15.0942, -0.0049, 0.0370>, <15.0942, -0.0051, -0.0248>, <15.0942, -0.0157, 0.0371>}
triangle { <15.0942, -0.0051, -0.0248>, <15.0942, -0.0157, 0.0371>, <15.0942, -0.0159, -0.0248>}
triangle { <15.0942, -0.0051, -0.0248>, <15.0579, -0.0051, -0.0748>, <15.0942, -0.0159, -0.0248>}
triangle { <15.0579, -0.0051, -0.0748>, <15.0942, -0.0159, -0.0248>, <15.0578, -0.0158, -0.0748>}
triangle { <15.0579, -0.0051, -0.0748>, <14.9991, -0.0048, -0.0939>, <15.0578, -0.0158, -0.0748>}
triangle { <14.9991, -0.0048, -0.0939>, <15.0578, -0.0158, -0.0748>, <14.9990, -0.0156, -0.0939>}
triangle { <14.9990, -0.0156, -0.0939>, <14.9403, -0.0152, -0.0748>, <14.9989, -0.0366, -0.0938>}
triangle { <14.9403, -0.0152, -0.0748>, <14.9989, -0.0366, -0.0938>, <14.9402, -0.0362, -0.0747>}
triangle { <14.9403, -0.0152, -0.0748>, <14.9039, -0.0149, -0.0248>, <14.9402, -0.0362, -0.0747>}
triangle { <14.9039, -0.0149, -0.0248>, <14.9402, -0.0362, -0.0747>, <14.9038, -0.0359, -0.0247>}
triangle { <14.9039, -0.0149, -0.0248>, <14.9039, -0.0147, 0.0371>, <14.9038, -0.0359, -0.0247>}
triangle { <14.9039, -0.0147, 0.0371>, <14.9038, -0.0359, -0.0247>, <14.9038, -0.0357, 0.0371>}
triangle { <14.9039, -0.0147, 0.0371>, <14.9403, -0.0147, 0.0871>, <14.9038, -0.0357, 0.0371>}
triangle { <14.9403, -0.0147, 0.0871>, <14.9038, -0.0357, 0.0371>, <14.9402, -0.0357, 0.0871>}
triangle { <14.9403, -0.0147, 0.0871>, <14.9991, -0.0150, 0.1061>, <14.9402, -0.0357, 0.0871>}
triangle { <14.9991, -0.0150, 0.1061>, <14.9402, -0.0357, 0.0871>, <14.9989, -0.0359, 0.1062>}
triangle { <14.9991, -0.0150, 0.1061>, <15.0578, -0.0154, 0.0871>, <14.9989, -0.0359, 0.1062>}
triangle { <15.0578, -0.0154, 0.0871>, <14.9989, -0.0359, 0.1062>, <15.0577, -0.0363, 0.0871>}
triangle { <15.0578, -0.0154, 0.0871>, <15.0942, -0.0157, 0.0371>, <15.0577, -0.0363, 0.0871>}
triangle { <15.0942, -0.0157, 0.0371>, <15.0577, -0.0363, 0.0871>, <15.0940, -0.0367, 0.0371>}
triangle { <15.0942, -0.0157, 0.0371>, <15.0942, -0.0159, -0.0248>, <15.0940, -0.0367, 0.0371>}
triangle { <15.0942, -0.0159, -0.0248>, <15.0940, -0.0367, 0.0371>, <15.0940, -0.0368, -0.0247>}
triangle { <15.0942, -0.0159, -0.0248>, <15.0578, -0.0158, -0.0748>, <15.0940, -0.0368, -0.0247>}
triangle { <15.0578, -0.0158, -0.0748>, <15.0940, -0.0368, -0.0247>, <15.0577, -0.0368, -0.0747>}
triangle { <15.0578, -0.0158, -0.0748>, <14.9990, -0.0156, -0.0939>, <15.0577, -0.0368, -0.0747>}
triangle { <14.9990, -0.0156, -0.0939>, <15.0577, -0.0368, -0.0747>, <14.9989, -0.0366, -0.0938>}
triangle { <14.9989, -0.0366, -0.0938>, <14.9402, -0.0362, -0.0747>, <14.9988, -0.0711, -0.0937>}
triangle { <14.9402, -0.0362, -0.0747>, <14.9988, -0.0711, -0.0937>, <14.9400, -0.0707, -0.0746>}
triangle { <14.9402, -0.0362, -0.0747>, <14.9038, -0.0359, -0.0247>, <14.9400, -0.0707, -0.0746>}
triangle { <14.9038, -0.0359, -0.0247>, <14.9400, -0.0707, -0.0746>, <14.9037, -0.0704, -0.0246>}
triangle { <14.9038, -0.0359, -0.0247>, <14.9038, -0.0357, 0.0371>, <14.9037, -0.0704, -0.0246>}
triangle { <14.9038, -0.0357, 0.0371>, <14.9037, -0.0704, -0.0246>, <14.9037, -0.0702, 0.0372>}
triangle { <14.9038, -0.0357, 0.0371>, <14.9402, -0.0357, 0.0871>, <14.9037, -0.0702, 0.0372>}
triangle { <14.9402, -0.0357, 0.0871>, <14.9037, -0.0702, 0.0372>, <14.9400, -0.0702, 0.0872>}
triangle { <14.9402, -0.0357, 0.0871>, <14.9989, -0.0359, 0.1062>, <14.9400, -0.0702, 0.0872>}
triangle { <14.9989, -0.0359, 0.1062>, <14.9400, -0.0702, 0.0872>, <14.9988, -0.0705, 0.1063>}
triangle { <14.9989, -0.0359, 0.1062>, <15.0577, -0.0363, 0.0871>, <14.9988, -0.0705, 0.1063>}
triangle { <15.0577, -0.0363, 0.0871>, <14.9988, -0.0705, 0.1063>, <15.0575, -0.0709, 0.0872>}
triangle { <15.0577, -0.0363, 0.0871>, <15.0940, -0.0367, 0.0371>, <15.0575, -0.0709, 0.0872>}
triangle { <15.0940, -0.0367, 0.0371>, <15.0575, -0.0709, 0.0872>, <15.0939, -0.0712, 0.0372>}
triangle { <15.0940, -0.0367, 0.0371>, <15.0940, -0.0368, -0.0247>, <15.0939, -0.0712, 0.0372>}
triangle { <15.0940, -0.0368, -0.0247>, <15.0939, -0.0712, 0.0372>, <15.0939, -0.0714, -0.0246>}
triangle { <15.0940, -0.0368, -0.0247>, <15.0577, -0.0368, -0.0747>, <15.0939, -0.0714, -0.0246>}
triangle { <15.0577, -0.0368, -0.0747>, <15.0939, -0.0714, -0.0246>, <15.0575, -0.0714, -0.0746>}
triangle { <15.0577, -0.0368, -0.0747>, <14.9989, -0.0366, -0.0938>, <15.0575, -0.0714, -0.0746>}
triangle { <14.9989, -0.0366, -0.0938>, <15.0575, -0.0714, -0.0746>, <14.9988, -0.0711, -0.0937>}
triangle { <14.9988, -0.0711, -0.0937>, <14.9400, -0.0707, -0.0746>, <14.9985, -0.1227, -0.0935>}
triangle { <14.9400, -0.0707, -0.0746>, <14.9985, -0.1227, -0.0935>, <14.9397, -0.1223, -0.0744>}
triangle { <14.9400, -0.0707, -0.0746>, <14.9037, -0.0704, -0.0246>, <14.9397, -0.1223, -0.0744>}
triangle { <14.9037, -0.0704, -0.0246>, <14.9397, -0.1223, -0.0744>, <14.9034, -0.1219, -0.0244>}
triangle { <14.9037, -0.0704, -0.0246>, <14.9037, -0.0702, 0.0372>, <14.9034, -0.1219, -0.0244>}
triangle { <14.9037, -0.0702, 0.0372>, <14.9034, -0.1219, -0.0244>, <14.9034, -0.1218, 0.0374>}
triangle { <14.9037, -0.0702, 0.0372>, <14.9400, -0.0702, 0.0872>, <14.9034, -0.1218, 0.0374>}
triangle { <14.9400, -0.0702, 0.0872>, <14.9034, -0.1218, 0.0374>, <14.9397, -0.1218, 0.0874>}
triangle { <14.9400, -0.0702, 0.0872>, <14.9988, -0.0705, 0.1063>, <14.9397, -0.1218, 0.0874>}
triangle { <14.9988, -0.0705, 0.1063>, <14.9397, -0.1218, 0.0874>, <14.9985, -0.1220, 0.1065>}
triangle { <14.9988, -0.0705, 0.1063>, <15.0575, -0.0709, 0.0872>, <14.9985, -0.1220, 0.1065>}
triangle { <15.0575, -0.0709, 0.0872>, <14.9985, -0.1220, 0.1065>, <15.0573, -0.1224, 0.0874>}
triangle { <15.0575, -0.0709, 0.0872>, <15.0939, -0.0712, 0.0372>, <15.0573, -0.1224, 0.0874>}
triangle { <15.0939, -0.0712, 0.0372>, <15.0573, -0.1224, 0.0874>, <15.0936, -0.1227, 0.0374>}
triangle { <15.0939, -0.0712, 0.0372>, <15.0939, -0.0714, -0.0246>, <15.0936, -0.1227, 0.0374>}
triangle { <15.0939, -0.0714, -0.0246>, <15.0936, -0.1227, 0.0374>, <15.0936, -0.1229, -0.0244>}
triangle { <15.0939, -0.0714, -0.0246>, <15.0575, -0.0714, -0.0746>, <15.0936, -0.1229, -0.0244>}
triangle { <15.0575, -0.0714, -0.0746>, <15.0936, -0.1229, -0.0244>, <15.0573, -0.1229, -0.0744>}
triangle { <15.0575, -0.0714, -0.0746>, <14.9988, -0.0711, -0.0937>, <15.0573, -0.1229, -0.0744>}
triangle { <14.9988, -0.0711, -0.0937>, <15.0573, -0.1229, -0.0744>, <14.9985, -0.1227, -0.0935>}
triangle { <14.9985, -0.1227, -0.0935>, <14.9397, -0.1223, -0.0744>, <14.9981, -0.1946, -0.0933>}
triangle { <14.9397, -0.1223, -0.0744>, <14.9981, -0.1946, -0.0933>, <14.9393, -0.1942, -0.0742>}
triangle { <14.9397, -0.1223, -0.0744>, <14.9034, -0.1219, -0.0244>, <14.9393, -0.1942, -0.0742>}
triangle { <14.9034, -0.1219, -0.0244>, <14.9393, -0.1942, -0.0742>, <14.9030, -0.1939, -0.0242>}
triangle { <14.9034, -0.1219, -0.0244>, <14.9034, -0.1218, 0.0374>, <14.9030, -0.1939, -0.0242>}
triangle { <14.9034, -0.1218, 0.0374>, <14.9030, -0.1939, -0.0242>, <14.9030, -0.1937, 0.0376>}
triangle { <14.9034, -0.1218, 0.0374>, <14.9397, -0.1218, 0.0874>, <14.9030, -0.1937, 0.0376>}
triangle { <14.9397, -0.1218, 0.0874>, <14.9030, -0.1937, 0.0376>, <14.9393, -0.1937, 0.0876>}
triangle { <14.9397, -0.1218, 0.0874>, <14.9985, -0.1220, 0.1065>, <14.9393, -0.1937, 0.0876>}
triangle { <14.9985, -0.1220, 0.1065>, <14.9393, -0.1937, 0.0876>, <14.9981, -0.1940, 0.1067>}
triangle { <14.9985, -0.1220, 0.1065>, <15.0573, -0.1224, 0.0874>, <14.9981, -0.1940, 0.1067>}
triangle { <15.0573, -0.1224, 0.0874>, <14.9981, -0.1940, 0.1067>, <15.0569, -0.1943, 0.0876>}
triangle { <15.0573, -0.1224, 0.0874>, <15.0936, -0.1227, 0.0374>, <15.0569, -0.1943, 0.0876>}
triangle { <15.0936, -0.1227, 0.0374>, <15.0569, -0.1943, 0.0876>, <15.0932, -0.1947, 0.0376>}
triangle { <15.0936, -0.1227, 0.0374>, <15.0936, -0.1229, -0.0244>, <15.0932, -0.1947, 0.0376>}
triangle { <15.0936, -0.1229, -0.0244>, <15.0932, -0.1947, 0.0376>, <15.0932, -0.1949, -0.0242>}
triangle { <15.0936, -0.1229, -0.0244>, <15.0573, -0.1229, -0.0744>, <15.0932, -0.1949, -0.0242>}
triangle { <15.0573, -0.1229, -0.0744>, <15.0932, -0.1949, -0.0242>, <15.0569, -0.1948, -0.0742>}
triangle { <15.0573, -0.1229, -0.0744>, <14.9985, -0.1227, -0.0935>, <15.0569, -0.1948, -0.0742>}
triangle { <14.9985, -0.1227, -0.0935>, <15.0569, -0.1948, -0.0742>, <14.9981, -0.1946, -0.0933>}
triangle { <14.9981, -0.1946, -0.0933>, <14.9393, -0.1942, -0.0742>, <14.9976, -0.2904, -0.0930>}
triangle { <14.9393, -0.1942, -0.0742>, <14.9976, -0.2904, -0.0930>, <14.9388, -0.2899, -0.0739>}
triangle { <14.9393, -0.1942, -0.0742>, <14.9030, -0.1939, -0.0242>, <14.9388, -0.2899, -0.0739>}
triangle { <14.9030, -0.1939, -0.0242>, <14.9388, -0.2899, -0.0739>, <14.9025, -0.2895, -0.0239>}
triangle { <14.9030, -0.1939, -0.0242>, <14.9030, -0.1937, 0.0376>, <14.9025, -0.2895, -0.0239>}
triangle { <14.9030, -0.1937, 0.0376>, <14.9025, -0.2895, -0.0239>, <14.9025, -0.2892, 0.0379>}
triangle { <14.9030, -0.1937, 0.0376>, <14.9393, -0.1937, 0.0876>, <14.9025, -0.2892, 0.0379>}
triangle { <14.9393, -0.1937, 0.0876>, <14.9025, -0.2892, 0.0379>, <14.9388, -0.2893, 0.0879>}
triangle { <14.9393, -0.1937, 0.0876>, <14.9981, -0.1940, 0.1067>, <14.9388, -0.2893, 0.0879>}
triangle { <14.9981, -0.1940, 0.1067>, <14.9388, -0.2893, 0.0879>, <14.9976, -0.2896, 0.1070>}
triangle { <14.9981, -0.1940, 0.1067>, <15.0569, -0.1943, 0.0876>, <14.9976, -0.2896, 0.1070>}
triangle { <15.0569, -0.1943, 0.0876>, <14.9976, -0.2896, 0.1070>, <15.0564, -0.2901, 0.0879>}
triangle { <15.0569, -0.1943, 0.0876>, <15.0932, -0.1947, 0.0376>, <15.0564, -0.2901, 0.0879>}
triangle { <15.0932, -0.1947, 0.0376>, <15.0564, -0.2901, 0.0879>, <15.0927, -0.2906, 0.0379>}
triangle { <15.0932, -0.1947, 0.0376>, <15.0932, -0.1949, -0.0242>, <15.0927, -0.2906, 0.0379>}
triangle { <15.0932, -0.1949, -0.0242>, <15.0927, -0.2906, 0.0379>, <15.0927, -0.2908, -0.0239>}
triangle { <15.0932, -0.1949, -0.0242>, <15.0569, -0.1948, -0.0742>, <15.0927, -0.2908, -0.0239>}
triangle { <15.0569, -0.1948, -0.0742>, <15.0927, -0.2908, -0.0239>, <15.0564, -0.2907, -0.0739>}
triangle { <15.0569, -0.1948, -0.0742>, <14.9981, -0.1946, -0.0933>, <15.0564, -0.2907, -0.0739>}
triangle { <14.9981, -0.1946, -0.0933>, <15.0564, -0.2907, -0.0739>, <14.9976, -0.2904, -0.0930>}
triangle { <14.9976, -0.2904, -0.0930>, <14.9388, -0.2899, -0.0739>, <14.9968, -0.4124, -0.0925>}
triangle { <14.9388, -0.2899, -0.0739>, <14.9968, -0.4124, -0.0925>, <14.9380, -0.4113, -0.0734>}
triangle { <14.9388, -0.2899, -0.0739>, <14.9025, -0.2895, -0.0239>, <14.9380, -0.4113, -0.0734>}
triangle { <14.9025, -0.2895, -0.0239>, <14.9380, -0.4113, -0.0734>, <14.9017, -0.4103, -0.0234>}
triangle { <14.9025, -0.2895, -0.0239>, <14.9025, -0.2892, 0.0379>, <14.9017, -0.4103, -0.0234>}
triangle { <14.9025, -0.2892, 0.0379>, <14.9017, -0.4103, -0.0234>, <14.9017, -0.4097, 0.0384>}
triangle { <14.9025, -0.2892, 0.0379>, <14.9388, -0.2893, 0.0879>, <14.9017, -0.4097, 0.0384>}
triangle { <14.9388, -0.2893, 0.0879>, <14.9017, -0.4097, 0.0384>, <14.9380, -0.4099, 0.0884>}
triangle { <14.9388, -0.2893, 0.0879>, <14.9976, -0.2896, 0.1070>, <14.9380, -0.4099, 0.0884>}
triangle { <14.9976, -0.2896, 0.1070>, <14.9380, -0.4099, 0.0884>, <14.9968, -0.4107, 0.1075>}
triangle { <14.9976, -0.2896, 0.1070>, <15.0564, -0.2901, 0.0879>, <14.9968, -0.4107, 0.1075>}
triangle { <15.0564, -0.2901, 0.0879>, <14.9968, -0.4107, 0.1075>, <15.0556, -0.4118, 0.0884>}
triangle { <15.0564, -0.2901, 0.0879>, <15.0927, -0.2906, 0.0379>, <15.0556, -0.4118, 0.0884>}
triangle { <15.0927, -0.2906, 0.0379>, <15.0556, -0.4118, 0.0884>, <15.0919, -0.4128, 0.0384>}
triangle { <15.0927, -0.2906, 0.0379>, <15.0927, -0.2908, -0.0239>, <15.0919, -0.4128, 0.0384>}
triangle { <15.0927, -0.2908, -0.0239>, <15.0919, -0.4128, 0.0384>, <15.0919, -0.4133, -0.0234>}
triangle { <15.0927, -0.2908, -0.0239>, <15.0564, -0.2907, -0.0739>, <15.0919, -0.4133, -0.0234>}
triangle { <15.0564, -0.2907, -0.0739>, <15.0919, -0.4133, -0.0234>, <15.0555, -0.4131, -0.0734>}
triangle { <15.0564, -0.2907, -0.0739>, <14.9976, -0.2904, -0.0930>, <15.0555, -0.4131, -0.0734>}
triangle { <14.9976, -0.2904, -0.0930>, <15.0555, -0.4131, -0.0734>, <14.9968, -0.4124, -0.0925>}
triangle { <14.9968, -0.4124, -0.0925>, <14.9380, -0.4113, -0.0734>, <14.9944, -0.5568, -0.0913>}
triangle { <14.9380, -0.4113, -0.0734>, <14.9944, -0.5568, -0.0913>, <14.9357, -0.5547, -0.0722>}
triangle { <14.9380, -0.4113, -0.0734>, <14.9017, -0.4103, -0.0234>, <14.9357, -0.5547, -0.0722>}
triangle { <14.9017, -0.4103, -0.0234>, <14.9357, -0.5547, -0.0722>, <14.8994, -0.5527, -0.0222>}
triangle { <14.9017, -0.4103, -0.0234>, <14.9017, -0.4097, 0.0384>, <14.8994, -0.5527, -0.0222>}
triangle { <14.9017, -0.4097, 0.0384>, <14.8994, -0.5527, -0.0222>, <14.8994, -0.5517, 0.0396>}
triangle { <14.9017, -0.4097, 0.0384>, <14.9380, -0.4099, 0.0884>, <14.8994, -0.5517, 0.0396>}
triangle { <14.9380, -0.4099, 0.0884>, <14.8994, -0.5517, 0.0396>, <14.9358, -0.5521, 0.0896>}
triangle { <14.9380, -0.4099, 0.0884>, <14.9968, -0.4107, 0.1075>, <14.9358, -0.5521, 0.0896>}
triangle { <14.9968, -0.4107, 0.1075>, <14.9358, -0.5521, 0.0896>, <14.9945, -0.5536, 0.1087>}
triangle { <14.9968, -0.4107, 0.1075>, <15.0556, -0.4118, 0.0884>, <14.9945, -0.5536, 0.1087>}
triangle { <15.0556, -0.4118, 0.0884>, <14.9945, -0.5536, 0.1087>, <15.0533, -0.5557, 0.0896>}
triangle { <15.0556, -0.4118, 0.0884>, <15.0919, -0.4128, 0.0384>, <15.0533, -0.5557, 0.0896>}
triangle { <15.0919, -0.4128, 0.0384>, <15.0533, -0.5557, 0.0896>, <15.0896, -0.5577, 0.0396>}
triangle { <15.0919, -0.4128, 0.0384>, <15.0919, -0.4133, -0.0234>, <15.0896, -0.5577, 0.0396>}
triangle { <15.0919, -0.4133, -0.0234>, <15.0896, -0.5577, 0.0396>, <15.0895, -0.5587, -0.0222>}
triangle { <15.0919, -0.4133, -0.0234>, <15.0555, -0.4131, -0.0734>, <15.0895, -0.5587, -0.0222>}
triangle { <15.0555, -0.4131, -0.0734>, <15.0895, -0.5587, -0.0222>, <15.0532, -0.5584, -0.0722>}
triangle { <15.0555, -0.4131, -0.0734>, <14.9968, -0.4124, -0.0925>, <15.0532, -0.5584, -0.0722>}
triangle { <14.9968, -0.4124, -0.0925>, <15.0532, -0.5584, -0.0722>, <14.9944, -0.5568, -0.0913>}
triangle { <14.9944, -0.5568, -0.0913>, <14.9357, -0.5547, -0.0722>, <14.9893, -0.7187, -0.0886>}
triangle { <14.9357, -0.5547, -0.0722>, <14.9893, -0.7187, -0.0886>, <14.9306, -0.7151, -0.0696>}
triangle { <14.9357, -0.5547, -0.0722>, <14.8994, -0.5527, -0.0222>, <14.9306, -0.7151, -0.0696>}
triangle { <14.8994, -0.5527, -0.0222>, <14.9306, -0.7151, -0.0696>, <14.8944, -0.7119, -0.0196>}
triangle { <14.8994, -0.5527, -0.0222>, <14.8994, -0.5517, 0.0396>, <14.8944, -0.7119, -0.0196>}
triangle { <14.8994, -0.5517, 0.0396>, <14.8944, -0.7119, -0.0196>, <14.8945, -0.7102, 0.0422>}
triangle { <14.8994, -0.5517, 0.0396>, <14.9358, -0.5521, 0.0896>, <14.8945, -0.7102, 0.0422>}
triangle { <14.9358, -0.5521, 0.0896>, <14.8945, -0.7102, 0.0422>, <14.9309, -0.7108, 0.0922>}
triangle { <14.9358, -0.5521, 0.0896>, <14.9945, -0.5536, 0.1087>, <14.9309, -0.7108, 0.0922>}
triangle { <14.9945, -0.5536, 0.1087>, <14.9309, -0.7108, 0.0922>, <14.9896, -0.7133, 0.1113>}
triangle { <14.9945, -0.5536, 0.1087>, <15.0533, -0.5557, 0.0896>, <14.9896, -0.7133, 0.1113>}
triangle { <15.0533, -0.5557, 0.0896>, <14.9896, -0.7133, 0.1113>, <15.0483, -0.7169, 0.0922>}
triangle { <15.0533, -0.5557, 0.0896>, <15.0896, -0.5577, 0.0396>, <15.0483, -0.7169, 0.0922>}
triangle { <15.0896, -0.5577, 0.0396>, <15.0483, -0.7169, 0.0922>, <15.0845, -0.7202, 0.0422>}
triangle { <15.0896, -0.5577, 0.0396>, <15.0895, -0.5587, -0.0222>, <15.0845, -0.7202, 0.0422>}
triangle { <15.0895, -0.5587, -0.0222>, <15.0845, -0.7202, 0.0422>, <15.0844, -0.7218, -0.0196>}
triangle { <15.0895, -0.5587, -0.0222>, <15.0532, -0.5584, -0.0722>, <15.0844, -0.7218, -0.0196>}
triangle { <15.0532, -0.5584, -0.0722>, <15.0844, -0.7218, -0.0196>, <15.0480, -0.7213, -0.0696>}
triangle { <15.0532, -0.5584, -0.0722>, <14.9944, -0.5568, -0.0913>, <15.0480, -0.7213, -0.0696>}
triangle { <14.9944, -0.5568, -0.0913>, <15.0480, -0.7213, -0.0696>, <14.9893, -0.7187, -0.0886>}
triangle { <14.9893, -0.7187, -0.0886>, <14.9306, -0.7151, -0.0696>, <14.9801, -0.8931, -0.0839>}
triangle { <14.9306, -0.7151, -0.0696>, <14.9801, -0.8931, -0.0839>, <14.9216, -0.8876, -0.0649>}
triangle { <14.9306, -0.7151, -0.0696>, <14.8944, -0.7119, -0.0196>, <14.9216, -0.8876, -0.0649>}
triangle { <14.8944, -0.7119, -0.0196>, <14.9216, -0.8876, -0.0649>, <14.8855, -0.8827, -0.0149>}
triangle { <14.8944, -0.7119, -0.0196>, <14.8945, -0.7102, 0.0422>, <14.8855, -0.8827, -0.0149>}
triangle { <14.8945, -0.7102, 0.0422>, <14.8855, -0.8827, -0.0149>, <14.8857, -0.8802, 0.0469>}
triangle { <14.8945, -0.7102, 0.0422>, <14.9309, -0.7108, 0.0922>, <14.8857, -0.8802, 0.0469>}
triangle { <14.9309, -0.7108, 0.0922>, <14.8857, -0.8802, 0.0469>, <14.9221, -0.8810, 0.0968>}
triangle { <14.9309, -0.7108, 0.0922>, <14.9896, -0.7133, 0.1113>, <14.9221, -0.8810, 0.0968>}
triangle { <14.9896, -0.7133, 0.1113>, <14.9221, -0.8810, 0.0968>, <14.9807, -0.8849, 0.1159>}
triangle { <14.9896, -0.7133, 0.1113>, <15.0483, -0.7169, 0.0922>, <14.9807, -0.8849, 0.1159>}
triangle { <15.0483, -0.7169, 0.0922>, <14.9807, -0.8849, 0.1159>, <15.0393, -0.8904, 0.0968>}
triangle { <15.0483, -0.7169, 0.0922>, <15.0845, -0.7202, 0.0422>, <15.0393, -0.8904, 0.0968>}
triangle { <15.0845, -0.7202, 0.0422>, <15.0393, -0.8904, 0.0968>, <15.0753, -0.8953, 0.0469>}
triangle { <15.0845, -0.7202, 0.0422>, <15.0844, -0.7218, -0.0196>, <15.0753, -0.8953, 0.0469>}
triangle { <15.0844, -0.7218, -0.0196>, <15.0753, -0.8953, 0.0469>, <15.0751, -0.8978, -0.0149>}
triangle { <15.0844, -0.7218, -0.0196>, <15.0480, -0.7213, -0.0696>, <15.0751, -0.8978, -0.0149>}
triangle { <15.0480, -0.7213, -0.0696>, <15.0751, -0.8978, -0.0149>, <15.0387, -0.8970, -0.0649>}
triangle { <15.0480, -0.7213, -0.0696>, <14.9893, -0.7187, -0.0886>, <15.0387, -0.8970, -0.0649>}
triangle { <14.9893, -0.7187, -0.0886>, <15.0387, -0.8970, -0.0649>, <14.9801, -0.8931, -0.0839>}
triangle { <14.9801, -0.8931, -0.0839>, <14.9216, -0.8876, -0.0649>, <14.9654, -1.0749, -0.0765>}
triangle { <14.9216, -0.8876, -0.0649>, <14.9654, -1.0749, -0.0765>, <14.9071, -1.0671, -0.0574>}
triangle { <14.9216, -0.8876, -0.0649>, <14.8855, -0.8827, -0.0149>, <14.9071, -1.0671, -0.0574>}
triangle { <14.8855, -0.8827, -0.0149>, <14.9071, -1.0671, -0.0574>, <14.8713, -1.0600, -0.0075>}
triangle { <14.8855, -0.8827, -0.0149>, <14.8857, -0.8802, 0.0469>, <14.8713, -1.0600, -0.0075>}
triangle { <14.8857, -0.8802, 0.0469>, <14.8713, -1.0600, -0.0075>, <14.8718, -1.0564, 0.0542>}
triangle { <14.8857, -0.8802, 0.0469>, <14.9221, -0.8810, 0.0968>, <14.8718, -1.0564, 0.0542>}
triangle { <14.9221, -0.8810, 0.0968>, <14.8718, -1.0564, 0.0542>, <14.9082, -1.0577, 0.1041>}
triangle { <14.9221, -0.8810, 0.0968>, <14.9807, -0.8849, 0.1159>, <14.9082, -1.0577, 0.1041>}
triangle { <14.9807, -0.8849, 0.1159>, <14.9082, -1.0577, 0.1041>, <14.9667, -1.0633, 0.1232>}
triangle { <14.9807, -0.8849, 0.1159>, <15.0393, -0.8904, 0.0968>, <14.9667, -1.0633, 0.1232>}
triangle { <15.0393, -0.8904, 0.0968>, <14.9667, -1.0633, 0.1232>, <15.0250, -1.0711, 0.1041>}
triangle { <15.0393, -0.8904, 0.0968>, <15.0753, -0.8953, 0.0469>, <15.0250, -1.0711, 0.1041>}
triangle { <15.0753, -0.8953, 0.0469>, <15.0250, -1.0711, 0.1041>, <15.0607, -1.0782, 0.0542>}
triangle { <15.0753, -0.8953, 0.0469>, <15.0751, -0.8978, -0.0149>, <15.0607, -1.0782, 0.0542>}
triangle { <15.0751, -0.8978, -0.0149>, <15.0607, -1.0782, 0.0542>, <15.0603, -1.0818, -0.0075>}
triangle { <15.0751, -0.8978, -0.0149>, <15.0387, -0.8970, -0.0649>, <15.0603, -1.0818, -0.0075>}
triangle { <15.0387, -0.8970, -0.0649>, <15.0603, -1.0818, -0.0075>, <15.0239, -1.0805, -0.0574>}
triangle { <15.0387, -0.8970, -0.0649>, <14.9801, -0.8931, -0.0839>, <15.0239, -1.0805, -0.0574>}
triangle { <14.9801, -0.8931, -0.0839>, <15.0239, -1.0805, -0.0574>, <14.9654, -1.0749, -0.0765>}
triangle { <14.9654, -1.0749, -0.0765>, <14.9071, -1.0671, -0.0574>, <14.9437, -1.2593, -0.0656>}
triangle { <14.9071, -1.0671, -0.0574>, <14.9437, -1.2593, -0.0656>, <14.8860, -1.2484, -0.0466>}
triangle { <14.9071, -1.0671, -0.0574>, <14.8713, -1.0600, -0.0075>, <14.8860, -1.2484, -0.0466>}
triangle { <14.8713, -1.0600, -0.0075>, <14.8860, -1.2484, -0.0466>, <14.8507, -1.2386, 0.0033>}
triangle { <14.8713, -1.0600, -0.0075>, <14.8718, -1.0564, 0.0542>, <14.8507, -1.2386, 0.0033>}
triangle { <14.8718, -1.0564, 0.0542>, <14.8507, -1.2386, 0.0033>, <14.8515, -1.2337, 0.0649>}
triangle { <14.8718, -1.0564, 0.0542>, <14.9082, -1.0577, 0.1041>, <14.8515, -1.2337, 0.0649>}
triangle { <14.9082, -1.0577, 0.1041>, <14.8515, -1.2337, 0.0649>, <14.8880, -1.2355, 0.1147>}
triangle { <14.9082, -1.0577, 0.1041>, <14.9667, -1.0633, 0.1232>, <14.8880, -1.2355, 0.1147>}
triangle { <14.9667, -1.0633, 0.1232>, <14.8880, -1.2355, 0.1147>, <14.9463, -1.2433, 0.1337>}
triangle { <14.9667, -1.0633, 0.1232>, <15.0250, -1.0711, 0.1041>, <14.9463, -1.2433, 0.1337>}
triangle { <15.0250, -1.0711, 0.1041>, <14.9463, -1.2433, 0.1337>, <15.0041, -1.2542, 0.1147>}
triangle { <15.0250, -1.0711, 0.1041>, <15.0607, -1.0782, 0.0542>, <15.0041, -1.2542, 0.1147>}
triangle { <15.0607, -1.0782, 0.0542>, <15.0041, -1.2542, 0.1147>, <15.0393, -1.2640, 0.0649>}
triangle { <15.0607, -1.0782, 0.0542>, <15.0603, -1.0818, -0.0075>, <15.0393, -1.2640, 0.0649>}
triangle { <15.0603, -1.0818, -0.0075>, <15.0393, -1.2640, 0.0649>, <15.0385, -1.2689, 0.0033>}
triangle { <15.0603, -1.0818, -0.0075>, <15.0239, -1.0805, -0.0574>, <15.0385, -1.2689, 0.0033>}
triangle { <15.0239, -1.0805, -0.0574>, <15.0385, -1.2689, 0.0033>, <15.0020, -1.2671, -0.0466>}
triangle { <15.0239, -1.0805, -0.0574>, <14.9654, -1.0749, -0.0765>, <15.0020, -1.2671, -0.0466>}
triangle { <14.9654, -1.0749, -0.0765>, <15.0020, -1.2671, -0.0466>, <14.9437, -1.2593, -0.0656>}
triangle { <14.9437, -1.2593, -0.0656>, <14.8860, -1.2484, -0.0466>, <14.9137, -1.4413, -0.0506>}
triangle { <14.8860, -1.2484, -0.0466>, <14.9137, -1.4413, -0.0506>, <14.8568, -1.4265, -0.0316>}
triangle { <14.8860, -1.2484, -0.0466>, <14.8507, -1.2386, 0.0033>, <14.8568, -1.4265, -0.0316>}
triangle { <14.8507, -1.2386, 0.0033>, <14.8568, -1.4265, -0.0316>, <14.8225, -1.4132, 0.0181>}
triangle { <14.8507, -1.2386, 0.0033>, <14.8515, -1.2337, 0.0649>, <14.8225, -1.4132, 0.0181>}
triangle { <14.8515, -1.2337, 0.0649>, <14.8225, -1.4132, 0.0181>, <14.8240, -1.4066, 0.0795>}
triangle { <14.8515, -1.2337, 0.0649>, <14.8880, -1.2355, 0.1147>, <14.8240, -1.4066, 0.0795>}
triangle { <14.8880, -1.2355, 0.1147>, <14.8240, -1.4066, 0.0795>, <14.8607, -1.4091, 0.1292>}
triangle { <14.8880, -1.2355, 0.1147>, <14.9463, -1.2433, 0.1337>, <14.8607, -1.4091, 0.1292>}
triangle { <14.9463, -1.2433, 0.1337>, <14.8607, -1.4091, 0.1292>, <14.9185, -1.4198, 0.1482>}
triangle { <14.9463, -1.2433, 0.1337>, <15.0041, -1.2542, 0.1147>, <14.9185, -1.4198, 0.1482>}
triangle { <15.0041, -1.2542, 0.1147>, <14.9185, -1.4198, 0.1482>, <14.9754, -1.4346, 0.1292>}
triangle { <15.0041, -1.2542, 0.1147>, <15.0393, -1.2640, 0.0649>, <14.9754, -1.4346, 0.1292>}
triangle { <15.0393, -1.2640, 0.0649>, <14.9754, -1.4346, 0.1292>, <15.0097, -1.4479, 0.0795>}
triangle { <15.0393, -1.2640, 0.0649>, <15.0385, -1.2689, 0.0033>, <15.0097, -1.4479, 0.0795>}
triangle { <15.0385, -1.2689, 0.0033>, <15.0097, -1.4479, 0.0795>, <15.0082, -1.4545, 0.0181>}
triangle { <15.0385, -1.2689, 0.0033>, <15.0020, -1.2671, -0.0466>, <15.0082, -1.4545, 0.0181>}
triangle { <15.0020, -1.2671, -0.0466>, <15.0082, -1.4545, 0.0181>, <14.9716, -1.4520, -0.0316>}
triangle { <15.0020, -1.2671, -0.0466>, <14.9437, -1.2593, -0.0656>, <14.9716, -1.4520, -0.0316>}
triangle { <14.9437, -1.2593, -0.0656>, <14.9716, -1.4520, -0.0316>, <14.9137, -1.4413, -0.0506>}
triangle { <14.9137, -1.4413, -0.0506>, <14.8568, -1.4265, -0.0316>, <14.8737, -1.6158, -0.0307>}
triangle { <14.8568, -1.4265, -0.0316>, <14.8737, -1.6158, -0.0307>, <14.8183, -1.5961, -0.0118>}
triangle { <14.8568, -1.4265, -0.0316>, <14.8225, -1.4132, 0.0181>, <14.8183, -1.5961, -0.0118>}
triangle { <14.8225, -1.4132, 0.0181>, <14.8183, -1.5961, -0.0118>, <14.7857, -1.5786, 0.0376>}
triangle { <14.8225, -1.4132, 0.0181>, <14.8240, -1.4066, 0.0795>, <14.7857, -1.5786, 0.0376>}
triangle { <14.8240, -1.4066, 0.0795>, <14.7857, -1.5786, 0.0376>, <14.7883, -1.5699, 0.0988>}
triangle { <14.8240, -1.4066, 0.0795>, <14.8607, -1.4091, 0.1292>, <14.7883, -1.5699, 0.0988>}
triangle { <14.8607, -1.4091, 0.1292>, <14.7883, -1.5699, 0.0988>, <14.8252, -1.5735, 0.1483>}
triangle { <14.8607, -1.4091, 0.1292>, <14.9185, -1.4198, 0.1482>, <14.8252, -1.5735, 0.1483>}
triangle { <14.9185, -1.4198, 0.1482>, <14.8252, -1.5735, 0.1483>, <14.8822, -1.5879, 0.1672>}
triangle { <14.9185, -1.4198, 0.1482>, <14.9754, -1.4346, 0.1292>, <14.8822, -1.5879, 0.1672>}
triangle { <14.9754, -1.4346, 0.1292>, <14.8822, -1.5879, 0.1672>, <14.9376, -1.6077, 0.1483>}
triangle { <14.9754, -1.4346, 0.1292>, <15.0097, -1.4479, 0.0795>, <14.9376, -1.6077, 0.1483>}
triangle { <15.0097, -1.4479, 0.0795>, <14.9376, -1.6077, 0.1483>, <14.9703, -1.6252, 0.0988>}
triangle { <15.0097, -1.4479, 0.0795>, <15.0082, -1.4545, 0.0181>, <14.9703, -1.6252, 0.0988>}
triangle { <15.0082, -1.4545, 0.0181>, <14.9703, -1.6252, 0.0988>, <14.9677, -1.6338, 0.0376>}
triangle { <15.0082, -1.4545, 0.0181>, <14.9716, -1.4520, -0.0316>, <14.9677, -1.6338, 0.0376>}
triangle { <14.9716, -1.4520, -0.0316>, <14.9677, -1.6338, 0.0376>, <14.9308, -1.6302, -0.0118>}
triangle { <14.9716, -1.4520, -0.0316>, <14.9137, -1.4413, -0.0506>, <14.9308, -1.6302, -0.0118>}
triangle { <14.9137, -1.4413, -0.0506>, <14.9308, -1.6302, -0.0118>, <14.8737, -1.6158, -0.0307>}
triangle { <14.8737, -1.6158, -0.0307>, <14.8183, -1.5961, -0.0118>, <14.8230, -1.7778, -0.0056>}
triangle { <14.8183, -1.5961, -0.0118>, <14.8230, -1.7778, -0.0056>, <14.7697, -1.7528, 0.0131>}
triangle { <14.8183, -1.5961, -0.0118>, <14.7857, -1.5786, 0.0376>, <14.7697, -1.7528, 0.0131>}
triangle { <14.7857, -1.5786, 0.0376>, <14.7697, -1.7528, 0.0131>, <14.7393, -1.7308, 0.0623>}
triangle { <14.7857, -1.5786, 0.0376>, <14.7883, -1.5699, 0.0988>, <14.7393, -1.7308, 0.0623>}
triangle { <14.7883, -1.5699, 0.0988>, <14.7393, -1.7308, 0.0623>, <14.7435, -1.7204, 0.1231>}
triangle { <14.7883, -1.5699, 0.0988>, <14.8252, -1.5735, 0.1483>, <14.7435, -1.7204, 0.1231>}
triangle { <14.8252, -1.5735, 0.1483>, <14.7435, -1.7204, 0.1231>, <14.7806, -1.7254, 0.1722>}
triangle { <14.8252, -1.5735, 0.1483>, <14.8822, -1.5879, 0.1672>, <14.7806, -1.7254, 0.1722>}
triangle { <14.8822, -1.5879, 0.1672>, <14.7806, -1.7254, 0.1722>, <14.8364, -1.7440, 0.1910>}
triangle { <14.8822, -1.5879, 0.1672>, <14.9376, -1.6077, 0.1483>, <14.8364, -1.7440, 0.1910>}
triangle { <14.9376, -1.6077, 0.1483>, <14.8364, -1.7440, 0.1910>, <14.8897, -1.7691, 0.1722>}
triangle { <14.9376, -1.6077, 0.1483>, <14.9703, -1.6252, 0.0988>, <14.8897, -1.7691, 0.1722>}
triangle { <14.9703, -1.6252, 0.0988>, <14.8897, -1.7691, 0.1722>, <14.9201, -1.7910, 0.1231>}
triangle { <14.9703, -1.6252, 0.0988>, <14.9677, -1.6338, 0.0376>, <14.9201, -1.7910, 0.1231>}
triangle { <14.9677, -1.6338, 0.0376>, <14.9201, -1.7910, 0.1231>, <14.9159, -1.8014, 0.0623>}
triangle { <14.9677, -1.6338, 0.0376>, <14.9308, -1.6302, -0.0118>, <14.9159, -1.8014, 0.0623>}
triangle { <14.9308, -1.6302, -0.0118>, <14.9159, -1.8014, 0.0623>, <14.8788, -1.7964, 0.0131>}
triangle { <14.9308, -1.6302, -0.0118>, <14.8737, -1.6158, -0.0307>, <14.8788, -1.7964, 0.0131>}
triangle { <14.8737, -1.6158, -0.0307>, <14.8788, -1.7964, 0.0131>, <14.8230, -1.7778, -0.0056>}
triangle { <14.8230, -1.7778, -0.0056>, <14.7697, -1.7528, 0.0131>, <14.7619, -1.9251, 0.0239>}
triangle { <14.7697, -1.7528, 0.0131>, <14.7619, -1.9251, 0.0239>, <14.7115, -1.8945, 0.0426>}
triangle { <14.7697, -1.7528, 0.0131>, <14.7393, -1.7308, 0.0623>, <14.7115, -1.8945, 0.0426>}
triangle { <14.7393, -1.7308, 0.0623>, <14.7115, -1.8945, 0.0426>, <14.6842, -1.8683, 0.0914>}
triangle { <14.7393, -1.7308, 0.0623>, <14.7435, -1.7204, 0.1231>, <14.6842, -1.8683, 0.0914>}
triangle { <14.7435, -1.7204, 0.1231>, <14.6842, -1.8683, 0.0914>, <14.6903, -1.8564, 0.1517>}
triangle { <14.7435, -1.7204, 0.1231>, <14.7806, -1.7254, 0.1722>, <14.6903, -1.8564, 0.1517>}
triangle { <14.7806, -1.7254, 0.1722>, <14.6903, -1.8564, 0.1517>, <14.7275, -1.8634, 0.2005>}
triangle { <14.7806, -1.7254, 0.1722>, <14.8364, -1.7440, 0.1910>, <14.7275, -1.8634, 0.2005>}
triangle { <14.8364, -1.7440, 0.1910>, <14.7275, -1.8634, 0.2005>, <14.7817, -1.8866, 0.2192>}
triangle { <14.8364, -1.7440, 0.1910>, <14.8897, -1.7691, 0.1722>, <14.7817, -1.8866, 0.2192>}
triangle { <14.8897, -1.7691, 0.1722>, <14.7817, -1.8866, 0.2192>, <14.8321, -1.9171, 0.2005>}
triangle { <14.8897, -1.7691, 0.1722>, <14.9201, -1.7910, 0.1231>, <14.8321, -1.9171, 0.2005>}
triangle { <14.9201, -1.7910, 0.1231>, <14.8321, -1.9171, 0.2005>, <14.8595, -1.9433, 0.1517>}
triangle { <14.9201, -1.7910, 0.1231>, <14.9159, -1.8014, 0.0623>, <14.8595, -1.9433, 0.1517>}
triangle { <14.9159, -1.8014, 0.0623>, <14.8595, -1.9433, 0.1517>, <14.8534, -1.9552, 0.0914>}
triangle { <14.9159, -1.8014, 0.0623>, <14.8788, -1.7964, 0.0131>, <14.8534, -1.9552, 0.0914>}
triangle { <14.8788, -1.7964, 0.0131>, <14.8534, -1.9552, 0.0914>, <14.8161, -1.9482, 0.0426>}
triangle { <14.8788, -1.7964, 0.0131>, <14.8230, -1.7778, -0.0056>, <14.8161, -1.9482, 0.0426>}
triangle { <14.8230, -1.7778, -0.0056>, <14.8161, -1.9482, 0.0426>, <14.7619, -1.9251, 0.0239>}
triangle { <14.7619, -1.9251, 0.0239>, <14.7115, -1.8945, 0.0426>, <14.6916, -2.0563, 0.0570>}
triangle { <14.7115, -1.8945, 0.0426>, <14.6916, -2.0563, 0.0570>, <14.6450, -2.0200, 0.0755>}
triangle { <14.7115, -1.8945, 0.0426>, <14.6842, -1.8683, 0.0914>, <14.6450, -2.0200, 0.0755>}
triangle { <14.6842, -1.8683, 0.0914>, <14.6450, -2.0200, 0.0755>, <14.6215, -1.9897, 0.1239>}
triangle { <14.6842, -1.8683, 0.0914>, <14.6903, -1.8564, 0.1517>, <14.6215, -1.9897, 0.1239>}
triangle { <14.6903, -1.8564, 0.1517>, <14.6215, -1.9897, 0.1239>, <14.6300, -1.9768, 0.1838>}
triangle { <14.6903, -1.8564, 0.1517>, <14.7275, -1.8634, 0.2005>, <14.6300, -1.9768, 0.1838>}
triangle { <14.7275, -1.8634, 0.2005>, <14.6300, -1.9768, 0.1838>, <14.6671, -1.9864, 0.2322>}
triangle { <14.7275, -1.8634, 0.2005>, <14.7817, -1.8866, 0.2192>, <14.6671, -1.9864, 0.2322>}
triangle { <14.7817, -1.8866, 0.2192>, <14.6671, -1.9864, 0.2322>, <14.7189, -2.0147, 0.2507>}
triangle { <14.7817, -1.8866, 0.2192>, <14.8321, -1.9171, 0.2005>, <14.7189, -2.0147, 0.2507>}
triangle { <14.8321, -1.9171, 0.2005>, <14.7189, -2.0147, 0.2507>, <14.7654, -2.0509, 0.2322>}
triangle { <14.8321, -1.9171, 0.2005>, <14.8595, -1.9433, 0.1517>, <14.7654, -2.0509, 0.2322>}
triangle { <14.8595, -1.9433, 0.1517>, <14.7654, -2.0509, 0.2322>, <14.7889, -2.0813, 0.1838>}
triangle { <14.8595, -1.9433, 0.1517>, <14.8534, -1.9552, 0.0914>, <14.7889, -2.0813, 0.1838>}
triangle { <14.8534, -1.9552, 0.0914>, <14.7889, -2.0813, 0.1838>, <14.7805, -2.0941, 0.1239>}
triangle { <14.8534, -1.9552, 0.0914>, <14.8161, -1.9482, 0.0426>, <14.7805, -2.0941, 0.1239>}
triangle { <14.8161, -1.9482, 0.0426>, <14.7805, -2.0941, 0.1239>, <14.7433, -2.0846, 0.0755>}
triangle { <14.8161, -1.9482, 0.0426>, <14.7619, -1.9251, 0.0239>, <14.7433, -2.0846, 0.0755>}
triangle { <14.7619, -1.9251, 0.0239>, <14.7433, -2.0846, 0.0755>, <14.6916, -2.0563, 0.0570>}
triangle { <14.6916, -2.0563, 0.0570>, <14.6450, -2.0200, 0.0755>, <14.6128, -2.1699, 0.0926>}
triangle { <14.6450, -2.0200, 0.0755>, <14.6128, -2.1699, 0.0926>, <14.5714, -2.1278, 0.1110>}
triangle { <14.6450, -2.0200, 0.0755>, <14.6215, -1.9897, 0.1239>, <14.5714, -2.1278, 0.1110>}
triangle { <14.6215, -1.9897, 0.1239>, <14.5714, -2.1278, 0.1110>, <14.5528, -2.0937, 0.1590>}
triangle { <14.6215, -1.9897, 0.1239>, <14.6300, -1.9768, 0.1838>, <14.5528, -2.0937, 0.1590>}
triangle { <14.6300, -1.9768, 0.1838>, <14.5528, -2.0937, 0.1590>, <14.5639, -2.0806, 0.2183>}
triangle { <14.6300, -1.9768, 0.1838>, <14.6671, -1.9864, 0.2322>, <14.5639, -2.0806, 0.2183>}
triangle { <14.6671, -1.9864, 0.2322>, <14.5639, -2.0806, 0.2183>, <14.6006, -2.0935, 0.2664>}
triangle { <14.6671, -1.9864, 0.2322>, <14.7189, -2.0147, 0.2507>, <14.6006, -2.0935, 0.2664>}
triangle { <14.7189, -2.0147, 0.2507>, <14.6006, -2.0935, 0.2664>, <14.6489, -2.1275, 0.2847>}
triangle { <14.7189, -2.0147, 0.2507>, <14.7654, -2.0509, 0.2322>, <14.6489, -2.1275, 0.2847>}
triangle { <14.7654, -2.0509, 0.2322>, <14.6489, -2.1275, 0.2847>, <14.6902, -2.1696, 0.2664>}
triangle { <14.7654, -2.0509, 0.2322>, <14.7889, -2.0813, 0.1838>, <14.6902, -2.1696, 0.2664>}
triangle { <14.7889, -2.0813, 0.1838>, <14.6902, -2.1696, 0.2664>, <14.7089, -2.2038, 0.2183>}
triangle { <14.7889, -2.0813, 0.1838>, <14.7805, -2.0941, 0.1239>, <14.7089, -2.2038, 0.2183>}
triangle { <14.7805, -2.0941, 0.1239>, <14.7089, -2.2038, 0.2183>, <14.6977, -2.2169, 0.1590>}
triangle { <14.7805, -2.0941, 0.1239>, <14.7433, -2.0846, 0.0755>, <14.6977, -2.2169, 0.1590>}
triangle { <14.7433, -2.0846, 0.0755>, <14.6977, -2.2169, 0.1590>, <14.6610, -2.2040, 0.1110>}
triangle { <14.7433, -2.0846, 0.0755>, <14.6916, -2.0563, 0.0570>, <14.6610, -2.2040, 0.1110>}
triangle { <14.6916, -2.0563, 0.0570>, <14.6610, -2.2040, 0.1110>, <14.6128, -2.1699, 0.0926>}
triangle { <14.6128, -2.1699, 0.0926>, <14.5714, -2.1278, 0.1110>, <14.5268, -2.2645, 0.1298>}
triangle { <14.5714, -2.1278, 0.1110>, <14.5268, -2.2645, 0.1298>, <14.4923, -2.2166, 0.1480>}
triangle { <14.5714, -2.1278, 0.1110>, <14.5528, -2.0937, 0.1590>, <14.4923, -2.2166, 0.1480>}
triangle { <14.5528, -2.0937, 0.1590>, <14.4923, -2.2166, 0.1480>, <14.4796, -2.1793, 0.1956>}
triangle { <14.5528, -2.0937, 0.1590>, <14.5639, -2.0806, 0.2183>, <14.4796, -2.1793, 0.1956>}
triangle { <14.5639, -2.0806, 0.2183>, <14.4796, -2.1793, 0.1956>, <14.4937, -2.1669, 0.2545>}
triangle { <14.5639, -2.0806, 0.2183>, <14.6006, -2.0935, 0.2664>, <14.4937, -2.1669, 0.2545>}
triangle { <14.6006, -2.0935, 0.2664>, <14.4937, -2.1669, 0.2545>, <14.5291, -2.1841, 0.3021>}
triangle { <14.6006, -2.0935, 0.2664>, <14.6489, -2.1275, 0.2847>, <14.5291, -2.1841, 0.3021>}
triangle { <14.6489, -2.1275, 0.2847>, <14.5291, -2.1841, 0.3021>, <14.5723, -2.2244, 0.3203>}
triangle { <14.6489, -2.1275, 0.2847>, <14.6902, -2.1696, 0.2664>, <14.5723, -2.2244, 0.3203>}
triangle { <14.6902, -2.1696, 0.2664>, <14.5723, -2.2244, 0.3203>, <14.6068, -2.2723, 0.3021>}
triangle { <14.6902, -2.1696, 0.2664>, <14.7089, -2.2038, 0.2183>, <14.6068, -2.2723, 0.3021>}
triangle { <14.7089, -2.2038, 0.2183>, <14.6068, -2.2723, 0.3021>, <14.6195, -2.3096, 0.2545>}
triangle { <14.7089, -2.2038, 0.2183>, <14.6977, -2.2169, 0.1590>, <14.6195, -2.3096, 0.2545>}
triangle { <14.6977, -2.2169, 0.1590>, <14.6195, -2.3096, 0.2545>, <14.6054, -2.3219, 0.1956>}
triangle { <14.6977, -2.2169, 0.1590>, <14.6610, -2.2040, 0.1110>, <14.6054, -2.3219, 0.1956>}
triangle { <14.6610, -2.2040, 0.1110>, <14.6054, -2.3219, 0.1956>, <14.5700, -2.3047, 0.1480>}
triangle { <14.6610, -2.2040, 0.1110>, <14.6128, -2.1699, 0.0926>, <14.5700, -2.3047, 0.1480>}
triangle { <14.6128, -2.1699, 0.0926>, <14.5700, -2.3047, 0.1480>, <14.5268, -2.2645, 0.1298>}
triangle { <14.5268, -2.2645, 0.1298>, <14.4923, -2.2166, 0.1480>, <14.4350, -2.3382, 0.1674>}
triangle { <14.4923, -2.2166, 0.1480>, <14.4350, -2.3382, 0.1674>, <14.4093, -2.2850, 0.1854>}
triangle { <14.4923, -2.2166, 0.1480>, <14.4796, -2.1793, 0.1956>, <14.4093, -2.2850, 0.1854>}
triangle { <14.4796, -2.1793, 0.1956>, <14.4093, -2.2850, 0.1854>, <14.4038, -2.2457, 0.2328>}
triangle { <14.4796, -2.1793, 0.1956>, <14.4937, -2.1669, 0.2545>, <14.4038, -2.2457, 0.2328>}
triangle { <14.4937, -2.1669, 0.2545>, <14.4038, -2.2457, 0.2328>, <14.4207, -2.2353, 0.2914>}
triangle { <14.4937, -2.1669, 0.2545>, <14.5291, -2.1841, 0.3021>, <14.4207, -2.2353, 0.2914>}
triangle { <14.5291, -2.1841, 0.3021>, <14.4207, -2.2353, 0.2914>, <14.4534, -2.2578, 0.3387>}
triangle { <14.5291, -2.1841, 0.3021>, <14.5723, -2.2244, 0.3203>, <14.4534, -2.2578, 0.3387>}
triangle { <14.5723, -2.2244, 0.3203>, <14.4534, -2.2578, 0.3387>, <14.4895, -2.3045, 0.3568>}
triangle { <14.5723, -2.2244, 0.3203>, <14.6068, -2.2723, 0.3021>, <14.4895, -2.3045, 0.3568>}
triangle { <14.6068, -2.2723, 0.3021>, <14.4895, -2.3045, 0.3568>, <14.5152, -2.3578, 0.3387>}
triangle { <14.6068, -2.2723, 0.3021>, <14.6195, -2.3096, 0.2545>, <14.5152, -2.3578, 0.3387>}
triangle { <14.6195, -2.3096, 0.2545>, <14.5152, -2.3578, 0.3387>, <14.5207, -2.3971, 0.2914>}
triangle { <14.6195, -2.3096, 0.2545>, <14.6054, -2.3219, 0.1956>, <14.5207, -2.3971, 0.2914>}
triangle { <14.6054, -2.3219, 0.1956>, <14.5207, -2.3971, 0.2914>, <14.5038, -2.4075, 0.2328>}
triangle { <14.6054, -2.3219, 0.1956>, <14.5700, -2.3047, 0.1480>, <14.5038, -2.4075, 0.2328>}
triangle { <14.5700, -2.3047, 0.1480>, <14.5038, -2.4075, 0.2328>, <14.4711, -2.3850, 0.1854>}
triangle { <14.5700, -2.3047, 0.1480>, <14.5268, -2.2645, 0.1298>, <14.4711, -2.3850, 0.1854>}
triangle { <14.5268, -2.2645, 0.1298>, <14.4711, -2.3850, 0.1854>, <14.4350, -2.3382, 0.1674>}
triangle { <14.4350, -2.3382, 0.1674>, <14.4093, -2.2850, 0.1854>, <14.3394, -2.3899, 0.2043>}
triangle { <14.4093, -2.2850, 0.1854>, <14.3394, -2.3899, 0.2043>, <14.3246, -2.3326, 0.2223>}
triangle { <14.4093, -2.2850, 0.1854>, <14.4038, -2.2457, 0.2328>, <14.3246, -2.3326, 0.2223>}
triangle { <14.4038, -2.2457, 0.2328>, <14.3246, -2.3326, 0.2223>, <14.3272, -2.2929, 0.2696>}
triangle { <14.4038, -2.2457, 0.2328>, <14.4207, -2.2353, 0.2914>, <14.3272, -2.2929, 0.2696>}
triangle { <14.4207, -2.2353, 0.2914>, <14.3272, -2.2929, 0.2696>, <14.3460, -2.2859, 0.3280>}
triangle { <14.4207, -2.2353, 0.2914>, <14.4534, -2.2578, 0.3387>, <14.3460, -2.2859, 0.3280>}
triangle { <14.4534, -2.2578, 0.3387>, <14.3460, -2.2859, 0.3280>, <14.3740, -2.3142, 0.3753>}
triangle { <14.4534, -2.2578, 0.3387>, <14.4895, -2.3045, 0.3568>, <14.3740, -2.3142, 0.3753>}
triangle { <14.4895, -2.3045, 0.3568>, <14.3740, -2.3142, 0.3753>, <14.4004, -2.3671, 0.3934>}
triangle { <14.4895, -2.3045, 0.3568>, <14.5152, -2.3578, 0.3387>, <14.4004, -2.3671, 0.3934>}
triangle { <14.5152, -2.3578, 0.3387>, <14.4004, -2.3671, 0.3934>, <14.4151, -2.4243, 0.3753>}
triangle { <14.5152, -2.3578, 0.3387>, <14.5207, -2.3971, 0.2914>, <14.4151, -2.4243, 0.3753>}
triangle { <14.5207, -2.3971, 0.2914>, <14.4151, -2.4243, 0.3753>, <14.4126, -2.4641, 0.3280>}
triangle { <14.5207, -2.3971, 0.2914>, <14.5038, -2.4075, 0.2328>, <14.4126, -2.4641, 0.3280>}
triangle { <14.5038, -2.4075, 0.2328>, <14.4126, -2.4641, 0.3280>, <14.3937, -2.4711, 0.2696>}
triangle { <14.5038, -2.4075, 0.2328>, <14.4711, -2.3850, 0.1854>, <14.3937, -2.4711, 0.2696>}
triangle { <14.4711, -2.3850, 0.1854>, <14.3937, -2.4711, 0.2696>, <14.3658, -2.4428, 0.2223>}
triangle { <14.4711, -2.3850, 0.1854>, <14.4350, -2.3382, 0.1674>, <14.3658, -2.4428, 0.2223>}
triangle { <14.4350, -2.3382, 0.1674>, <14.3658, -2.4428, 0.2223>, <14.3394, -2.3899, 0.2043>}
triangle { <14.3394, -2.3899, 0.2043>, <14.3246, -2.3326, 0.2223>, <14.2422, -2.4191, 0.2394>}
triangle { <14.3246, -2.3326, 0.2223>, <14.2422, -2.4191, 0.2394>, <14.2397, -2.3600, 0.2575>}
triangle { <14.3246, -2.3326, 0.2223>, <14.3272, -2.2929, 0.2696>, <14.2397, -2.3600, 0.2575>}
triangle { <14.3272, -2.2929, 0.2696>, <14.2397, -2.3600, 0.2575>, <14.2501, -2.3218, 0.3050>}
triangle { <14.3272, -2.2929, 0.2696>, <14.3460, -2.2859, 0.3280>, <14.2501, -2.3218, 0.3050>}
triangle { <14.3460, -2.2859, 0.3280>, <14.2501, -2.3218, 0.3050>, <14.2693, -2.3191, 0.3637>}
triangle { <14.3460, -2.2859, 0.3280>, <14.3740, -2.3142, 0.3753>, <14.2693, -2.3191, 0.3637>}
triangle { <14.3740, -2.3142, 0.3753>, <14.2693, -2.3191, 0.3637>, <14.2900, -2.3528, 0.4111>}
triangle { <14.3740, -2.3142, 0.3753>, <14.4004, -2.3671, 0.3934>, <14.2900, -2.3528, 0.4111>}
triangle { <14.4004, -2.3671, 0.3934>, <14.2900, -2.3528, 0.4111>, <14.3044, -2.4101, 0.4293>}
triangle { <14.4004, -2.3671, 0.3934>, <14.4151, -2.4243, 0.3753>, <14.3044, -2.4101, 0.4293>}
triangle { <14.4151, -2.4243, 0.3753>, <14.3044, -2.4101, 0.4293>, <14.3068, -2.4691, 0.4111>}
triangle { <14.4151, -2.4243, 0.3753>, <14.4126, -2.4641, 0.3280>, <14.3068, -2.4691, 0.4111>}
triangle { <14.4126, -2.4641, 0.3280>, <14.3068, -2.4691, 0.4111>, <14.2965, -2.5073, 0.3637>}
triangle { <14.4126, -2.4641, 0.3280>, <14.3937, -2.4711, 0.2696>, <14.2965, -2.5073, 0.3637>}
triangle { <14.3937, -2.4711, 0.2696>, <14.2965, -2.5073, 0.3637>, <14.2773, -2.5101, 0.3050>}
triangle { <14.3937, -2.4711, 0.2696>, <14.3658, -2.4428, 0.2223>, <14.2773, -2.5101, 0.3050>}
triangle { <14.3658, -2.4428, 0.2223>, <14.2773, -2.5101, 0.3050>, <14.2565, -2.4764, 0.2575>}
triangle { <14.3658, -2.4428, 0.2223>, <14.3394, -2.3899, 0.2043>, <14.2565, -2.4764, 0.2575>}
triangle { <14.3394, -2.3899, 0.2043>, <14.2565, -2.4764, 0.2575>, <14.2422, -2.4191, 0.2394>}
triangle { <14.2422, -2.4191, 0.2394>, <14.2397, -2.3600, 0.2575>, <14.1452, -2.4273, 0.2718>}
triangle { <14.2397, -2.3600, 0.2575>, <14.1452, -2.4273, 0.2718>, <14.1541, -2.3689, 0.2901>}
triangle { <14.2397, -2.3600, 0.2575>, <14.2501, -2.3218, 0.3050>, <14.1541, -2.3689, 0.2901>}
triangle { <14.2501, -2.3218, 0.3050>, <14.1541, -2.3689, 0.2901>, <14.1705, -2.3335, 0.3380>}
triangle { <14.2501, -2.3218, 0.3050>, <14.2693, -2.3191, 0.3637>, <14.1705, -2.3335, 0.3380>}
triangle { <14.2693, -2.3191, 0.3637>, <14.1705, -2.3335, 0.3380>, <14.1881, -2.3346, 0.3972>}
triangle { <14.2693, -2.3191, 0.3637>, <14.2900, -2.3528, 0.4111>, <14.1881, -2.3346, 0.3972>}
triangle { <14.2900, -2.3528, 0.4111>, <14.1881, -2.3346, 0.3972>, <14.2002, -2.3717, 0.4452>}
triangle { <14.2900, -2.3528, 0.4111>, <14.3044, -2.4101, 0.4293>, <14.2002, -2.3717, 0.4452>}
triangle { <14.3044, -2.4101, 0.4293>, <14.2002, -2.3717, 0.4452>, <14.2021, -2.4307, 0.4635>}
triangle { <14.3044, -2.4101, 0.4293>, <14.3068, -2.4691, 0.4111>, <14.2021, -2.4307, 0.4635>}
triangle { <14.3068, -2.4691, 0.4111>, <14.2021, -2.4307, 0.4635>, <14.1931, -2.4890, 0.4452>}
triangle { <14.3068, -2.4691, 0.4111>, <14.2965, -2.5073, 0.3637>, <14.1931, -2.4890, 0.4452>}
triangle { <14.2965, -2.5073, 0.3637>, <14.1931, -2.4890, 0.4452>, <14.1767, -2.5244, 0.3972>}
triangle { <14.2965, -2.5073, 0.3637>, <14.2773, -2.5101, 0.3050>, <14.1767, -2.5244, 0.3972>}
triangle { <14.2773, -2.5101, 0.3050>, <14.1767, -2.5244, 0.3972>, <14.1591, -2.5234, 0.3380>}
triangle { <14.2773, -2.5101, 0.3050>, <14.2565, -2.4764, 0.2575>, <14.1591, -2.5234, 0.3380>}
triangle { <14.2565, -2.4764, 0.2575>, <14.1591, -2.5234, 0.3380>, <14.1471, -2.4862, 0.2901>}
triangle { <14.2565, -2.4764, 0.2575>, <14.2422, -2.4191, 0.2394>, <14.1471, -2.4862, 0.2901>}
triangle { <14.2422, -2.4191, 0.2394>, <14.1471, -2.4862, 0.2901>, <14.1452, -2.4273, 0.2718>}
triangle { <14.1452, -2.4273, 0.2718>, <14.1541, -2.3689, 0.2901>, <14.0493, -2.4171, 0.3006>}
triangle { <14.1541, -2.3689, 0.2901>, <14.0493, -2.4171, 0.3006>, <14.0680, -2.3611, 0.3192>}
triangle { <14.1541, -2.3689, 0.2901>, <14.1705, -2.3335, 0.3380>, <14.0680, -2.3611, 0.3192>}
triangle { <14.1705, -2.3335, 0.3380>, <14.0680, -2.3611, 0.3192>, <14.0884, -2.3288, 0.3677>}
triangle { <14.1705, -2.3335, 0.3380>, <14.1881, -2.3346, 0.3972>, <14.0884, -2.3288, 0.3677>}
triangle { <14.1881, -2.3346, 0.3972>, <14.0884, -2.3288, 0.3677>, <14.1029, -2.3324, 0.4276>}
triangle { <14.1881, -2.3346, 0.3972>, <14.2002, -2.3717, 0.4452>, <14.1029, -2.3324, 0.4276>}
triangle { <14.2002, -2.3717, 0.4452>, <14.1029, -2.3324, 0.4276>, <14.1059, -2.3706, 0.4762>}
triangle { <14.2002, -2.3717, 0.4452>, <14.2021, -2.4307, 0.4635>, <14.1059, -2.3706, 0.4762>}
triangle { <14.2021, -2.4307, 0.4635>, <14.1059, -2.3706, 0.4762>, <14.0963, -2.4287, 0.4947>}
triangle { <14.2021, -2.4307, 0.4635>, <14.1931, -2.4890, 0.4452>, <14.0963, -2.4287, 0.4947>}
triangle { <14.1931, -2.4890, 0.4452>, <14.0963, -2.4287, 0.4947>, <14.0777, -2.4847, 0.4762>}
triangle { <14.1931, -2.4890, 0.4452>, <14.1767, -2.5244, 0.3972>, <14.0777, -2.4847, 0.4762>}
triangle { <14.1767, -2.5244, 0.3972>, <14.0777, -2.4847, 0.4762>, <14.0572, -2.5170, 0.4276>}
triangle { <14.1767, -2.5244, 0.3972>, <14.1591, -2.5234, 0.3380>, <14.0572, -2.5170, 0.4276>}
triangle { <14.1591, -2.5234, 0.3380>, <14.0572, -2.5170, 0.4276>, <14.0427, -2.5134, 0.3677>}
triangle { <14.1591, -2.5234, 0.3380>, <14.1471, -2.4862, 0.2901>, <14.0427, -2.5134, 0.3677>}
triangle { <14.1471, -2.4862, 0.2901>, <14.0427, -2.5134, 0.3677>, <14.0397, -2.4752, 0.3192>}
triangle { <14.1471, -2.4862, 0.2901>, <14.1452, -2.4273, 0.2718>, <14.0397, -2.4752, 0.3192>}
triangle { <14.1452, -2.4273, 0.2718>, <14.0397, -2.4752, 0.3192>, <14.0493, -2.4171, 0.3006>}
triangle { <14.0493, -2.4171, 0.3006>, <14.0680, -2.3611, 0.3192>, <13.9557, -2.3907, 0.3251>}
triangle { <14.0680, -2.3611, 0.3192>, <13.9557, -2.3907, 0.3251>, <13.9822, -2.3381, 0.3438>}
triangle { <14.0680, -2.3611, 0.3192>, <14.0884, -2.3288, 0.3677>, <13.9822, -2.3381, 0.3438>}
triangle { <14.0884, -2.3288, 0.3677>, <13.9822, -2.3381, 0.3438>, <14.0052, -2.3085, 0.3930>}
triangle { <14.0884, -2.3288, 0.3677>, <14.1029, -2.3324, 0.4276>, <14.0052, -2.3085, 0.3930>}
triangle { <14.1029, -2.3324, 0.4276>, <14.0052, -2.3085, 0.3930>, <14.0159, -2.3131, 0.4537>}
triangle { <14.1029, -2.3324, 0.4276>, <14.1059, -2.3706, 0.4762>, <14.0159, -2.3131, 0.4537>}
triangle { <14.1059, -2.3706, 0.4762>, <14.0159, -2.3131, 0.4537>, <14.0101, -2.3502, 0.5028>}
triangle { <14.1059, -2.3706, 0.4762>, <14.0963, -2.4287, 0.4947>, <14.0101, -2.3502, 0.5028>}
triangle { <14.0963, -2.4287, 0.4947>, <14.0101, -2.3502, 0.5028>, <13.9902, -2.4056, 0.5215>}
triangle { <14.0963, -2.4287, 0.4947>, <14.0777, -2.4847, 0.4762>, <13.9902, -2.4056, 0.5215>}
triangle { <14.0777, -2.4847, 0.4762>, <13.9902, -2.4056, 0.5215>, <13.9636, -2.4581, 0.5028>}
triangle { <14.0777, -2.4847, 0.4762>, <14.0572, -2.5170, 0.4276>, <13.9636, -2.4581, 0.5028>}
triangle { <14.0572, -2.5170, 0.4276>, <13.9636, -2.4581, 0.5028>, <13.9406, -2.4878, 0.4537>}
triangle { <14.0572, -2.5170, 0.4276>, <14.0427, -2.5134, 0.3677>, <13.9406, -2.4878, 0.4537>}
triangle { <14.0427, -2.5134, 0.3677>, <13.9406, -2.4878, 0.4537>, <13.9299, -2.4832, 0.3930>}
triangle { <14.0427, -2.5134, 0.3677>, <14.0397, -2.4752, 0.3192>, <13.9299, -2.4832, 0.3930>}
triangle { <14.0397, -2.4752, 0.3192>, <13.9299, -2.4832, 0.3930>, <13.9357, -2.4461, 0.3438>}
triangle { <14.0397, -2.4752, 0.3192>, <14.0493, -2.4171, 0.3006>, <13.9357, -2.4461, 0.3438>}
triangle { <14.0493, -2.4171, 0.3006>, <13.9357, -2.4461, 0.3438>, <13.9557, -2.3907, 0.3251>}
triangle { <13.9557, -2.3907, 0.3251>, <13.9822, -2.3381, 0.3438>, <13.8655, -2.3498, 0.3443>}
triangle { <13.9822, -2.3381, 0.3438>, <13.8655, -2.3498, 0.3443>, <13.8985, -2.3011, 0.3632>}
triangle { <13.9822, -2.3381, 0.3438>, <14.0052, -2.3085, 0.3930>, <13.8985, -2.3011, 0.3632>}
triangle { <14.0052, -2.3085, 0.3930>, <13.8985, -2.3011, 0.3632>, <13.9230, -2.2736, 0.4128>}
triangle { <14.0052, -2.3085, 0.3930>, <14.0159, -2.3131, 0.4537>, <13.9230, -2.2736, 0.4128>}
triangle { <14.0159, -2.3131, 0.4537>, <13.9230, -2.2736, 0.4128>, <13.9295, -2.2777, 0.4741>}
triangle { <14.0159, -2.3131, 0.4537>, <14.0101, -2.3502, 0.5028>, <13.9295, -2.2777, 0.4741>}
triangle { <14.0101, -2.3502, 0.5028>, <13.9295, -2.2777, 0.4741>, <13.9157, -2.3118, 0.5238>}
triangle { <14.0101, -2.3502, 0.5028>, <13.9902, -2.4056, 0.5215>, <13.9157, -2.3118, 0.5238>}
triangle { <13.9902, -2.4056, 0.5215>, <13.9157, -2.3118, 0.5238>, <13.8867, -2.3630, 0.5427>}
triangle { <13.9902, -2.4056, 0.5215>, <13.9636, -2.4581, 0.5028>, <13.8867, -2.3630, 0.5427>}
triangle { <13.9636, -2.4581, 0.5028>, <13.8867, -2.3630, 0.5427>, <13.8536, -2.4117, 0.5238>}
triangle { <13.9636, -2.4581, 0.5028>, <13.9406, -2.4878, 0.4537>, <13.8536, -2.4117, 0.5238>}
triangle { <13.9406, -2.4878, 0.4537>, <13.8536, -2.4117, 0.5238>, <13.8291, -2.4392, 0.4741>}
triangle { <13.9406, -2.4878, 0.4537>, <13.9299, -2.4832, 0.3930>, <13.8291, -2.4392, 0.4741>}
triangle { <13.9299, -2.4832, 0.3930>, <13.8291, -2.4392, 0.4741>, <13.8226, -2.4351, 0.4128>}
triangle { <13.9299, -2.4832, 0.3930>, <13.9357, -2.4461, 0.3438>, <13.8226, -2.4351, 0.4128>}
triangle { <13.9357, -2.4461, 0.3438>, <13.8226, -2.4351, 0.4128>, <13.8365, -2.4010, 0.3632>}
triangle { <13.9357, -2.4461, 0.3438>, <13.9557, -2.3907, 0.3251>, <13.8365, -2.4010, 0.3632>}
triangle { <13.9557, -2.3907, 0.3251>, <13.8365, -2.4010, 0.3632>, <13.8655, -2.3498, 0.3443>}
triangle { <13.8655, -2.3498, 0.3443>, <13.8985, -2.3011, 0.3632>, <13.7803, -2.2960, 0.3572>}
triangle { <13.8985, -2.3011, 0.3632>, <13.7803, -2.2960, 0.3572>, <13.8187, -2.2515, 0.3763>}
triangle { <13.8985, -2.3011, 0.3632>, <13.9230, -2.2736, 0.4128>, <13.8187, -2.2515, 0.3763>}
triangle { <13.9230, -2.2736, 0.4128>, <13.8187, -2.2515, 0.3763>, <13.8441, -2.2254, 0.4262>}
triangle { <13.9230, -2.2736, 0.4128>, <13.9295, -2.2777, 0.4741>, <13.8441, -2.2254, 0.4262>}
triangle { <13.9295, -2.2777, 0.4741>, <13.8441, -2.2254, 0.4262>, <13.8466, -2.2275, 0.4879>}
triangle { <13.9295, -2.2777, 0.4741>, <13.9157, -2.3118, 0.5238>, <13.8466, -2.2275, 0.4879>}
triangle { <13.9157, -2.3118, 0.5238>, <13.8466, -2.2275, 0.4879>, <13.8254, -2.2571, 0.5379>}
triangle { <13.9157, -2.3118, 0.5238>, <13.8867, -2.3630, 0.5427>, <13.8254, -2.2571, 0.5379>}
triangle { <13.8867, -2.3630, 0.5427>, <13.8254, -2.2571, 0.5379>, <13.7885, -2.3028, 0.5569>}
triangle { <13.8867, -2.3630, 0.5427>, <13.8536, -2.4117, 0.5238>, <13.7885, -2.3028, 0.5569>}
triangle { <13.8536, -2.4117, 0.5238>, <13.7885, -2.3028, 0.5569>, <13.7500, -2.3473, 0.5379>}
triangle { <13.8536, -2.4117, 0.5238>, <13.8291, -2.4392, 0.4741>, <13.7500, -2.3473, 0.5379>}
triangle { <13.8291, -2.4392, 0.4741>, <13.7500, -2.3473, 0.5379>, <13.7247, -2.3735, 0.4879>}
triangle { <13.8291, -2.4392, 0.4741>, <13.8226, -2.4351, 0.4128>, <13.7247, -2.3735, 0.4879>}
triangle { <13.8226, -2.4351, 0.4128>, <13.7247, -2.3735, 0.4879>, <13.7221, -2.3713, 0.4262>}
triangle { <13.8226, -2.4351, 0.4128>, <13.8365, -2.4010, 0.3632>, <13.7221, -2.3713, 0.4262>}
triangle { <13.8365, -2.4010, 0.3632>, <13.7221, -2.3713, 0.4262>, <13.7434, -2.3417, 0.3763>}
triangle { <13.8365, -2.4010, 0.3632>, <13.8655, -2.3498, 0.3443>, <13.7434, -2.3417, 0.3763>}
triangle { <13.8655, -2.3498, 0.3443>, <13.7434, -2.3417, 0.3763>, <13.7803, -2.2960, 0.3572>}
triangle { <13.7803, -2.2960, 0.3572>, <13.8187, -2.2515, 0.3763>, <13.7017, -2.2308, 0.3630>}
triangle { <13.8187, -2.2515, 0.3763>, <13.7017, -2.2308, 0.3630>, <13.7448, -2.1908, 0.3821>}
triangle { <13.8187, -2.2515, 0.3763>, <13.8441, -2.2254, 0.4262>, <13.7448, -2.1908, 0.3821>}
triangle { <13.8441, -2.2254, 0.4262>, <13.7448, -2.1908, 0.3821>, <13.7708, -2.1654, 0.4321>}
triangle { <13.8441, -2.2254, 0.4262>, <13.8466, -2.2275, 0.4879>, <13.7708, -2.1654, 0.4321>}
triangle { <13.8466, -2.2275, 0.4879>, <13.7708, -2.1654, 0.4321>, <13.7697, -2.1642, 0.4939>}
triangle { <13.8466, -2.2275, 0.4879>, <13.8254, -2.2571, 0.5379>, <13.7697, -2.1642, 0.4939>}
triangle { <13.8254, -2.2571, 0.5379>, <13.7697, -2.1642, 0.4939>, <13.7420, -2.1877, 0.5439>}
triangle { <13.8254, -2.2571, 0.5379>, <13.7885, -2.3028, 0.5569>, <13.7420, -2.1877, 0.5439>}
triangle { <13.7885, -2.3028, 0.5569>, <13.7420, -2.1877, 0.5439>, <13.6982, -2.2270, 0.5629>}
triangle { <13.7885, -2.3028, 0.5569>, <13.7500, -2.3473, 0.5379>, <13.6982, -2.2270, 0.5629>}
triangle { <13.7500, -2.3473, 0.5379>, <13.6982, -2.2270, 0.5629>, <13.6551, -2.2670, 0.5439>}
triangle { <13.7500, -2.3473, 0.5379>, <13.7247, -2.3735, 0.4879>, <13.6551, -2.2670, 0.5439>}
triangle { <13.7247, -2.3735, 0.4879>, <13.6551, -2.2670, 0.5439>, <13.6291, -2.2924, 0.4939>}
triangle { <13.7247, -2.3735, 0.4879>, <13.7221, -2.3713, 0.4262>, <13.6291, -2.2924, 0.4939>}
triangle { <13.7221, -2.3713, 0.4262>, <13.6291, -2.2924, 0.4939>, <13.6302, -2.2936, 0.4321>}
triangle { <13.7221, -2.3713, 0.4262>, <13.7434, -2.3417, 0.3763>, <13.6302, -2.2936, 0.4321>}
triangle { <13.7434, -2.3417, 0.3763>, <13.6302, -2.2936, 0.4321>, <13.6579, -2.2701, 0.3821>}
triangle { <13.7434, -2.3417, 0.3763>, <13.7803, -2.2960, 0.3572>, <13.6579, -2.2701, 0.3821>}
triangle { <13.7803, -2.2960, 0.3572>, <13.6579, -2.2701, 0.3821>, <13.7017, -2.2308, 0.3630>}
triangle { <13.7017, -2.2308, 0.3630>, <13.7448, -2.1908, 0.3821>, <13.6313, -2.1559, 0.3607>}
triangle { <13.7448, -2.1908, 0.3821>, <13.6313, -2.1559, 0.3607>, <13.6785, -2.1208, 0.3797>}
triangle { <13.7448, -2.1908, 0.3821>, <13.7708, -2.1654, 0.4321>, <13.6785, -2.1208, 0.3797>}
triangle { <13.7708, -2.1654, 0.4321>, <13.6785, -2.1208, 0.3797>, <13.7052, -2.0956, 0.4294>}
triangle { <13.7708, -2.1654, 0.4321>, <13.7697, -2.1642, 0.4939>, <13.7052, -2.0956, 0.4294>}
triangle { <13.7697, -2.1642, 0.4939>, <13.7052, -2.0956, 0.4294>, <13.7013, -2.0898, 0.4908>}
triangle { <13.7697, -2.1642, 0.4939>, <13.7420, -2.1877, 0.5439>, <13.7013, -2.0898, 0.4908>}
triangle { <13.7420, -2.1877, 0.5439>, <13.7013, -2.0898, 0.4908>, <13.6681, -2.1057, 0.5405>}
triangle { <13.7420, -2.1877, 0.5439>, <13.6982, -2.2270, 0.5629>, <13.6681, -2.1057, 0.5405>}
triangle { <13.6982, -2.2270, 0.5629>, <13.6681, -2.1057, 0.5405>, <13.6185, -2.1373, 0.5595>}
triangle { <13.6982, -2.2270, 0.5629>, <13.6551, -2.2670, 0.5439>, <13.6185, -2.1373, 0.5595>}
triangle { <13.6551, -2.2670, 0.5439>, <13.6185, -2.1373, 0.5595>, <13.5713, -2.1724, 0.5405>}
triangle { <13.6551, -2.2670, 0.5439>, <13.6291, -2.2924, 0.4939>, <13.5713, -2.1724, 0.5405>}
triangle { <13.6291, -2.2924, 0.4939>, <13.5713, -2.1724, 0.5405>, <13.5446, -2.1976, 0.4908>}
triangle { <13.6291, -2.2924, 0.4939>, <13.6302, -2.2936, 0.4321>, <13.5446, -2.1976, 0.4908>}
triangle { <13.6302, -2.2936, 0.4321>, <13.5446, -2.1976, 0.4908>, <13.5485, -2.2034, 0.4294>}
triangle { <13.6302, -2.2936, 0.4321>, <13.6579, -2.2701, 0.3821>, <13.5485, -2.2034, 0.4294>}
triangle { <13.6579, -2.2701, 0.3821>, <13.5485, -2.2034, 0.4294>, <13.5817, -2.1875, 0.3797>}
triangle { <13.6579, -2.2701, 0.3821>, <13.7017, -2.2308, 0.3630>, <13.5817, -2.1875, 0.3797>}
triangle { <13.7017, -2.2308, 0.3630>, <13.5817, -2.1875, 0.3797>, <13.6313, -2.1559, 0.3607>}
triangle { <13.6313, -2.1559, 0.3607>, <13.6785, -2.1208, 0.3797>, <13.5704, -2.0723, 0.3494>}
triangle { <13.6785, -2.1208, 0.3797>, <13.5704, -2.0723, 0.3494>, <13.6212, -2.0424, 0.3681>}
triangle { <13.6785, -2.1208, 0.3797>, <13.7052, -2.0956, 0.4294>, <13.6212, -2.0424, 0.3681>}
triangle { <13.7052, -2.0956, 0.4294>, <13.6212, -2.0424, 0.3681>, <13.6491, -2.0171, 0.4171>}
triangle { <13.7052, -2.0956, 0.4294>, <13.7013, -2.0898, 0.4908>, <13.6491, -2.0171, 0.4171>}
triangle { <13.7013, -2.0898, 0.4908>, <13.6491, -2.0171, 0.4171>, <13.6435, -2.0059, 0.4776>}
triangle { <13.7013, -2.0898, 0.4908>, <13.6681, -2.1057, 0.5405>, <13.6435, -2.0059, 0.4776>}
triangle { <13.6681, -2.1057, 0.5405>, <13.6435, -2.0059, 0.4776>, <13.6065, -2.0132, 0.5266>}
triangle { <13.6681, -2.1057, 0.5405>, <13.6185, -2.1373, 0.5595>, <13.6065, -2.0132, 0.5266>}
triangle { <13.6185, -2.1373, 0.5595>, <13.6065, -2.0132, 0.5266>, <13.5523, -2.0362, 0.5453>}
triangle { <13.6185, -2.1373, 0.5595>, <13.5713, -2.1724, 0.5405>, <13.5523, -2.0362, 0.5453>}
triangle { <13.5713, -2.1724, 0.5405>, <13.5523, -2.0362, 0.5453>, <13.5015, -2.0661, 0.5266>}
triangle { <13.5713, -2.1724, 0.5405>, <13.5446, -2.1976, 0.4908>, <13.5015, -2.0661, 0.5266>}
triangle { <13.5446, -2.1976, 0.4908>, <13.5015, -2.0661, 0.5266>, <13.4736, -2.0914, 0.4776>}
triangle { <13.5446, -2.1976, 0.4908>, <13.5485, -2.2034, 0.4294>, <13.4736, -2.0914, 0.4776>}
triangle { <13.5485, -2.2034, 0.4294>, <13.4736, -2.0914, 0.4776>, <13.4792, -2.1026, 0.4171>}
triangle { <13.5485, -2.2034, 0.4294>, <13.5817, -2.1875, 0.3797>, <13.4792, -2.1026, 0.4171>}
triangle { <13.5817, -2.1875, 0.3797>, <13.4792, -2.1026, 0.4171>, <13.5162, -2.0953, 0.3681>}
triangle { <13.5817, -2.1875, 0.3797>, <13.6313, -2.1559, 0.3607>, <13.5162, -2.0953, 0.3681>}
triangle { <13.6313, -2.1559, 0.3607>, <13.5162, -2.0953, 0.3681>, <13.5704, -2.0723, 0.3494>}
triangle { <13.5704, -2.0723, 0.3494>, <13.6212, -2.0424, 0.3681>, <13.5201, -1.9794, 0.3279>}
triangle { <13.6212, -2.0424, 0.3681>, <13.5201, -1.9794, 0.3279>, <13.5736, -1.9543, 0.3463>}
triangle { <13.6212, -2.0424, 0.3681>, <13.6491, -2.0171, 0.4171>, <13.5736, -1.9543, 0.3463>}
triangle { <13.6491, -2.0171, 0.4171>, <13.5736, -1.9543, 0.3463>, <13.6030, -1.9291, 0.3944>}
triangle { <13.6491, -2.0171, 0.4171>, <13.6435, -2.0059, 0.4776>, <13.6030, -1.9291, 0.3944>}
triangle { <13.6435, -2.0059, 0.4776>, <13.6030, -1.9291, 0.3944>, <13.5972, -1.9133, 0.4539>}
triangle { <13.6435, -2.0059, 0.4776>, <13.6065, -2.0132, 0.5266>, <13.5972, -1.9133, 0.4539>}
triangle { <13.6065, -2.0132, 0.5266>, <13.5972, -1.9133, 0.4539>, <13.5584, -1.9129, 0.5020>}
triangle { <13.6065, -2.0132, 0.5266>, <13.5523, -2.0362, 0.5453>, <13.5584, -1.9129, 0.5020>}
triangle { <13.5523, -2.0362, 0.5453>, <13.5584, -1.9129, 0.5020>, <13.5014, -1.9282, 0.5203>}
triangle { <13.5523, -2.0362, 0.5453>, <13.5015, -2.0661, 0.5266>, <13.5014, -1.9282, 0.5203>}
triangle { <13.5015, -2.0661, 0.5266>, <13.5014, -1.9282, 0.5203>, <13.4480, -1.9533, 0.5020>}
triangle { <13.5015, -2.0661, 0.5266>, <13.4736, -2.0914, 0.4776>, <13.4480, -1.9533, 0.5020>}
triangle { <13.4736, -2.0914, 0.4776>, <13.4480, -1.9533, 0.5020>, <13.4186, -1.9785, 0.4539>}
triangle { <13.4736, -2.0914, 0.4776>, <13.4792, -2.1026, 0.4171>, <13.4186, -1.9785, 0.4539>}
triangle { <13.4792, -2.1026, 0.4171>, <13.4186, -1.9785, 0.4539>, <13.4244, -1.9943, 0.3944>}
triangle { <13.4792, -2.1026, 0.4171>, <13.5162, -2.0953, 0.3681>, <13.4244, -1.9943, 0.3944>}
triangle { <13.5162, -2.0953, 0.3681>, <13.4244, -1.9943, 0.3944>, <13.4631, -1.9947, 0.3463>}
triangle { <13.5162, -2.0953, 0.3681>, <13.5704, -2.0723, 0.3494>, <13.4631, -1.9947, 0.3463>}
triangle { <13.5704, -2.0723, 0.3494>, <13.4631, -1.9947, 0.3463>, <13.5201, -1.9794, 0.3279>}
triangle { <13.5201, -1.9794, 0.3279>, <13.5736, -1.9543, 0.3463>, <13.4804, -1.8794, 0.2977>}
triangle { <13.5736, -1.9543, 0.3463>, <13.4804, -1.8794, 0.2977>, <13.5357, -1.8585, 0.3157>}
triangle { <13.5736, -1.9543, 0.3463>, <13.6030, -1.9291, 0.3944>, <13.5357, -1.8585, 0.3157>}
triangle { <13.6030, -1.9291, 0.3944>, <13.5357, -1.8585, 0.3157>, <13.5667, -1.8336, 0.3630>}
triangle { <13.6030, -1.9291, 0.3944>, <13.5972, -1.9133, 0.4539>, <13.5667, -1.8336, 0.3630>}
triangle { <13.5972, -1.9133, 0.4539>, <13.5667, -1.8336, 0.3630>, <13.5616, -1.8143, 0.4215>}
triangle { <13.5972, -1.9133, 0.4539>, <13.5584, -1.9129, 0.5020>, <13.5616, -1.8143, 0.4215>}
triangle { <13.5584, -1.9129, 0.5020>, <13.5616, -1.8143, 0.4215>, <13.5224, -1.8078, 0.4688>}
triangle { <13.5584, -1.9129, 0.5020>, <13.5014, -1.9282, 0.5203>, <13.5224, -1.8078, 0.4688>}
triangle { <13.5014, -1.9282, 0.5203>, <13.5224, -1.8078, 0.4688>, <13.4639, -1.8168, 0.4869>}
triangle { <13.5014, -1.9282, 0.5203>, <13.4480, -1.9533, 0.5020>, <13.4639, -1.8168, 0.4869>}
triangle { <13.4480, -1.9533, 0.5020>, <13.4639, -1.8168, 0.4869>, <13.4087, -1.8377, 0.4688>}
triangle { <13.4480, -1.9533, 0.5020>, <13.4186, -1.9785, 0.4539>, <13.4087, -1.8377, 0.4688>}
triangle { <13.4186, -1.9785, 0.4539>, <13.4087, -1.8377, 0.4688>, <13.3776, -1.8626, 0.4215>}
triangle { <13.4186, -1.9785, 0.4539>, <13.4244, -1.9943, 0.3944>, <13.3776, -1.8626, 0.4215>}
triangle { <13.4244, -1.9943, 0.3944>, <13.3776, -1.8626, 0.4215>, <13.3827, -1.8819, 0.3630>}
triangle { <13.4244, -1.9943, 0.3944>, <13.4631, -1.9947, 0.3463>, <13.3827, -1.8819, 0.3630>}
triangle { <13.4631, -1.9947, 0.3463>, <13.3827, -1.8819, 0.3630>, <13.4220, -1.8884, 0.3157>}
triangle { <13.4631, -1.9947, 0.3463>, <13.5201, -1.9794, 0.3279>, <13.4220, -1.8884, 0.3157>}
triangle { <13.5201, -1.9794, 0.3279>, <13.4220, -1.8884, 0.3157>, <13.4804, -1.8794, 0.2977>}
triangle { <13.4804, -1.8794, 0.2977>, <13.5357, -1.8585, 0.3157>, <13.4504, -1.7757, 0.2609>}
triangle { <13.5357, -1.8585, 0.3157>, <13.4504, -1.7757, 0.2609>, <13.5069, -1.7583, 0.2787>}
triangle { <13.5357, -1.8585, 0.3157>, <13.5667, -1.8336, 0.3630>, <13.5069, -1.7583, 0.2787>}
triangle { <13.5667, -1.8336, 0.3630>, <13.5069, -1.7583, 0.2787>, <13.5394, -1.7340, 0.3253>}
triangle { <13.5667, -1.8336, 0.3630>, <13.5616, -1.8143, 0.4215>, <13.5394, -1.7340, 0.3253>}
triangle { <13.5616, -1.8143, 0.4215>, <13.5394, -1.7340, 0.3253>, <13.5353, -1.7120, 0.3829>}
triangle { <13.5616, -1.8143, 0.4215>, <13.5224, -1.8078, 0.4688>, <13.5353, -1.7120, 0.3829>}
triangle { <13.5224, -1.8078, 0.4688>, <13.5353, -1.7120, 0.3829>, <13.4963, -1.7008, 0.4296>}
triangle { <13.5224, -1.8078, 0.4688>, <13.4639, -1.8168, 0.4869>, <13.4963, -1.7008, 0.4296>}
triangle { <13.4639, -1.8168, 0.4869>, <13.4963, -1.7008, 0.4296>, <13.4373, -1.7047, 0.4474>}
triangle { <13.4639, -1.8168, 0.4869>, <13.4087, -1.8377, 0.4688>, <13.4373, -1.7047, 0.4474>}
triangle { <13.4087, -1.8377, 0.4688>, <13.4373, -1.7047, 0.4474>, <13.3807, -1.7221, 0.4296>}
triangle { <13.4087, -1.8377, 0.4688>, <13.3776, -1.8626, 0.4215>, <13.3807, -1.7221, 0.4296>}
triangle { <13.3776, -1.8626, 0.4215>, <13.3807, -1.7221, 0.4296>, <13.3483, -1.7465, 0.3829>}
triangle { <13.3776, -1.8626, 0.4215>, <13.3827, -1.8819, 0.3630>, <13.3483, -1.7465, 0.3829>}
triangle { <13.3827, -1.8819, 0.3630>, <13.3483, -1.7465, 0.3829>, <13.3523, -1.7684, 0.3253>}
triangle { <13.3827, -1.8819, 0.3630>, <13.4220, -1.8884, 0.3157>, <13.3523, -1.7684, 0.3253>}
triangle { <13.4220, -1.8884, 0.3157>, <13.3523, -1.7684, 0.3253>, <13.3913, -1.7796, 0.2787>}
triangle { <13.4220, -1.8884, 0.3157>, <13.4804, -1.8794, 0.2977>, <13.3913, -1.7796, 0.2787>}
triangle { <13.4804, -1.8794, 0.2977>, <13.3913, -1.7796, 0.2787>, <13.4504, -1.7757, 0.2609>}
triangle { <13.4504, -1.7757, 0.2609>, <13.5069, -1.7583, 0.2787>, <13.4289, -1.6718, 0.2198>}
triangle { <13.5069, -1.7583, 0.2787>, <13.4289, -1.6718, 0.2198>, <13.4863, -1.6572, 0.2374>}
triangle { <13.5069, -1.7583, 0.2787>, <13.5394, -1.7340, 0.3253>, <13.4863, -1.6572, 0.2374>}
triangle { <13.5394, -1.7340, 0.3253>, <13.4863, -1.6572, 0.2374>, <13.5200, -1.6335, 0.2835>}
triangle { <13.5394, -1.7340, 0.3253>, <13.5353, -1.7120, 0.3829>, <13.5200, -1.6335, 0.2835>}
triangle { <13.5353, -1.7120, 0.3829>, <13.5200, -1.6335, 0.2835>, <13.5170, -1.6096, 0.3405>}
triangle { <13.5353, -1.7120, 0.3829>, <13.4963, -1.7008, 0.4296>, <13.5170, -1.6096, 0.3405>}
triangle { <13.4963, -1.7008, 0.4296>, <13.5170, -1.6096, 0.3405>, <13.4786, -1.5948, 0.3865>}
triangle { <13.4963, -1.7008, 0.4296>, <13.4373, -1.7047, 0.4474>, <13.4786, -1.5948, 0.3865>}
triangle { <13.4373, -1.7047, 0.4474>, <13.4786, -1.5948, 0.3865>, <13.4193, -1.5947, 0.4041>}
triangle { <13.4373, -1.7047, 0.4474>, <13.3807, -1.7221, 0.4296>, <13.4193, -1.5947, 0.4041>}
triangle { <13.3807, -1.7221, 0.4296>, <13.4193, -1.5947, 0.4041>, <13.3619, -1.6093, 0.3865>}
triangle { <13.3807, -1.7221, 0.4296>, <13.3483, -1.7465, 0.3829>, <13.3619, -1.6093, 0.3865>}
triangle { <13.3483, -1.7465, 0.3829>, <13.3619, -1.6093, 0.3865>, <13.3283, -1.6330, 0.3405>}
triangle { <13.3483, -1.7465, 0.3829>, <13.3523, -1.7684, 0.3253>, <13.3283, -1.6330, 0.3405>}
triangle { <13.3523, -1.7684, 0.3253>, <13.3283, -1.6330, 0.3405>, <13.3312, -1.6568, 0.2835>}
triangle { <13.3523, -1.7684, 0.3253>, <13.3913, -1.7796, 0.2787>, <13.3312, -1.6568, 0.2835>}
triangle { <13.3913, -1.7796, 0.2787>, <13.3312, -1.6568, 0.2835>, <13.3696, -1.6716, 0.2374>}
triangle { <13.3913, -1.7796, 0.2787>, <13.4504, -1.7757, 0.2609>, <13.3696, -1.6716, 0.2374>}
triangle { <13.4504, -1.7757, 0.2609>, <13.3696, -1.6716, 0.2374>, <13.4289, -1.6718, 0.2198>}
triangle { <13.4289, -1.6718, 0.2198>, <13.4863, -1.6572, 0.2374>, <13.4145, -1.5709, 0.1770>}
triangle { <13.4863, -1.6572, 0.2374>, <13.4145, -1.5709, 0.1770>, <13.4725, -1.5586, 0.1944>}
triangle { <13.4863, -1.6572, 0.2374>, <13.5200, -1.6335, 0.2835>, <13.4725, -1.5586, 0.1944>}
triangle { <13.5200, -1.6335, 0.2835>, <13.4725, -1.5586, 0.1944>, <13.5072, -1.5354, 0.2400>}
triangle { <13.5200, -1.6335, 0.2835>, <13.5170, -1.6096, 0.3405>, <13.5072, -1.5354, 0.2400>}
triangle { <13.5170, -1.6096, 0.3405>, <13.5072, -1.5354, 0.2400>, <13.5052, -1.5103, 0.2965>}
triangle { <13.5170, -1.6096, 0.3405>, <13.4786, -1.5948, 0.3865>, <13.5052, -1.5103, 0.2965>}
triangle { <13.4786, -1.5948, 0.3865>, <13.5052, -1.5103, 0.2965>, <13.4674, -1.4928, 0.3421>}
triangle { <13.4786, -1.5948, 0.3865>, <13.4193, -1.5947, 0.4041>, <13.4674, -1.4928, 0.3421>}
triangle { <13.4193, -1.5947, 0.4041>, <13.4674, -1.4928, 0.3421>, <13.4082, -1.4895, 0.3596>}
triangle { <13.4193, -1.5947, 0.4041>, <13.3619, -1.6093, 0.3865>, <13.4082, -1.4895, 0.3596>}
triangle { <13.3619, -1.6093, 0.3865>, <13.4082, -1.4895, 0.3596>, <13.3502, -1.5018, 0.3421>}
triangle { <13.3619, -1.6093, 0.3865>, <13.3283, -1.6330, 0.3405>, <13.3502, -1.5018, 0.3421>}
triangle { <13.3283, -1.6330, 0.3405>, <13.3502, -1.5018, 0.3421>, <13.3156, -1.5250, 0.2965>}
triangle { <13.3283, -1.6330, 0.3405>, <13.3312, -1.6568, 0.2835>, <13.3156, -1.5250, 0.2965>}
triangle { <13.3312, -1.6568, 0.2835>, <13.3156, -1.5250, 0.2965>, <13.3175, -1.5501, 0.2400>}
triangle { <13.3312, -1.6568, 0.2835>, <13.3696, -1.6716, 0.2374>, <13.3175, -1.5501, 0.2400>}
triangle { <13.3696, -1.6716, 0.2374>, <13.3175, -1.5501, 0.2400>, <13.3553, -1.5676, 0.1944>}
triangle { <13.3696, -1.6716, 0.2374>, <13.4289, -1.6718, 0.2198>, <13.3553, -1.5676, 0.1944>}
triangle { <13.4289, -1.6718, 0.2198>, <13.3553, -1.5676, 0.1944>, <13.4145, -1.5709, 0.1770>}
triangle { <13.4145, -1.5709, 0.1770>, <13.4725, -1.5586, 0.1944>, <13.4058, -1.4763, 0.1346>}
triangle { <13.4725, -1.5586, 0.1944>, <13.4058, -1.4763, 0.1346>, <13.4642, -1.4657, 0.1519>}
triangle { <13.4725, -1.5586, 0.1944>, <13.5072, -1.5354, 0.2400>, <13.4642, -1.4657, 0.1519>}
triangle { <13.5072, -1.5354, 0.2400>, <13.4642, -1.4657, 0.1519>, <13.4995, -1.4431, 0.1972>}
triangle { <13.5072, -1.5354, 0.2400>, <13.5052, -1.5103, 0.2965>, <13.4995, -1.4431, 0.1972>}
triangle { <13.5052, -1.5103, 0.2965>, <13.4995, -1.4431, 0.1972>, <13.4984, -1.4170, 0.2533>}
triangle { <13.5052, -1.5103, 0.2965>, <13.4674, -1.4928, 0.3421>, <13.4984, -1.4170, 0.2533>}
triangle { <13.4674, -1.4928, 0.3421>, <13.4984, -1.4170, 0.2533>, <13.4612, -1.3976, 0.2986>}
triangle { <13.4674, -1.4928, 0.3421>, <13.4082, -1.4895, 0.3596>, <13.4612, -1.3976, 0.2986>}
triangle { <13.4082, -1.4895, 0.3596>, <13.4612, -1.3976, 0.2986>, <13.4021, -1.3921, 0.3159>}
triangle { <13.4082, -1.4895, 0.3596>, <13.3502, -1.5018, 0.3421>, <13.4021, -1.3921, 0.3159>}
triangle { <13.3502, -1.5018, 0.3421>, <13.4021, -1.3921, 0.3159>, <13.3437, -1.4028, 0.2986>}
triangle { <13.3502, -1.5018, 0.3421>, <13.3156, -1.5250, 0.2965>, <13.3437, -1.4028, 0.2986>}
triangle { <13.3156, -1.5250, 0.2965>, <13.3437, -1.4028, 0.2986>, <13.3083, -1.4254, 0.2533>}
triangle { <13.3156, -1.5250, 0.2965>, <13.3175, -1.5501, 0.2400>, <13.3083, -1.4254, 0.2533>}
triangle { <13.3175, -1.5501, 0.2400>, <13.3083, -1.4254, 0.2533>, <13.3095, -1.4514, 0.1972>}
triangle { <13.3175, -1.5501, 0.2400>, <13.3553, -1.5676, 0.1944>, <13.3095, -1.4514, 0.1972>}
triangle { <13.3553, -1.5676, 0.1944>, <13.3095, -1.4514, 0.1972>, <13.3467, -1.4709, 0.1519>}
triangle { <13.3553, -1.5676, 0.1944>, <13.4145, -1.5709, 0.1770>, <13.3467, -1.4709, 0.1519>}
triangle { <13.4145, -1.5709, 0.1770>, <13.3467, -1.4709, 0.1519>, <13.4058, -1.4763, 0.1346>}
triangle { <13.4058, -1.4763, 0.1346>, <13.4642, -1.4657, 0.1519>, <13.4012, -1.3913, 0.0950>}
triangle { <13.4642, -1.4657, 0.1519>, <13.4012, -1.3913, 0.0950>, <13.4598, -1.3816, 0.1122>}
triangle { <13.4642, -1.4657, 0.1519>, <13.4995, -1.4431, 0.1972>, <13.4598, -1.3816, 0.1122>}
triangle { <13.4995, -1.4431, 0.1972>, <13.4598, -1.3816, 0.1122>, <13.4956, -1.3593, 0.1574>}
triangle { <13.4995, -1.4431, 0.1972>, <13.4984, -1.4170, 0.2533>, <13.4956, -1.3593, 0.1574>}
triangle { <13.4984, -1.4170, 0.2533>, <13.4956, -1.3593, 0.1574>, <13.4949, -1.3328, 0.2132>}
triangle { <13.4984, -1.4170, 0.2533>, <13.4612, -1.3976, 0.2986>, <13.4949, -1.3328, 0.2132>}
triangle { <13.4612, -1.3976, 0.2986>, <13.4949, -1.3328, 0.2132>, <13.4581, -1.3122, 0.2584>}
triangle { <13.4612, -1.3976, 0.2986>, <13.4021, -1.3921, 0.3159>, <13.4581, -1.3122, 0.2584>}
triangle { <13.4021, -1.3921, 0.3159>, <13.4581, -1.3122, 0.2584>, <13.3991, -1.3055, 0.2756>}
triangle { <13.4021, -1.3921, 0.3159>, <13.3437, -1.4028, 0.2986>, <13.3991, -1.3055, 0.2756>}
triangle { <13.3437, -1.4028, 0.2986>, <13.3991, -1.3055, 0.2756>, <13.3405, -1.3151, 0.2584>}
triangle { <13.3437, -1.4028, 0.2986>, <13.3083, -1.4254, 0.2533>, <13.3405, -1.3151, 0.2584>}
triangle { <13.3083, -1.4254, 0.2533>, <13.3405, -1.3151, 0.2584>, <13.3048, -1.3375, 0.2132>}
triangle { <13.3083, -1.4254, 0.2533>, <13.3095, -1.4514, 0.1972>, <13.3048, -1.3375, 0.2132>}
triangle { <13.3095, -1.4514, 0.1972>, <13.3048, -1.3375, 0.2132>, <13.3054, -1.3640, 0.1574>}
triangle { <13.3095, -1.4514, 0.1972>, <13.3467, -1.4709, 0.1519>, <13.3054, -1.3640, 0.1574>}
triangle { <13.3467, -1.4709, 0.1519>, <13.3054, -1.3640, 0.1574>, <13.3422, -1.3845, 0.1122>}
triangle { <13.3467, -1.4709, 0.1519>, <13.4058, -1.4763, 0.1346>, <13.3422, -1.3845, 0.1122>}
triangle { <13.4058, -1.4763, 0.1346>, <13.3422, -1.3845, 0.1122>, <13.4012, -1.3913, 0.0950>}
triangle { <13.4012, -1.3913, 0.0950>, <13.4598, -1.3816, 0.1122>, <13.3993, -1.3187, 0.0605>}
triangle { <13.4598, -1.3816, 0.1122>, <13.3993, -1.3187, 0.0605>, <13.4579, -1.3093, 0.0778>}
triangle { <13.4598, -1.3816, 0.1122>, <13.4956, -1.3593, 0.1574>, <13.4579, -1.3093, 0.0778>}
triangle { <13.4956, -1.3593, 0.1574>, <13.4579, -1.3093, 0.0778>, <13.4937, -1.2870, 0.1229>}
triangle { <13.4956, -1.3593, 0.1574>, <13.4949, -1.3328, 0.2132>, <13.4937, -1.2870, 0.1229>}
triangle { <13.4949, -1.3328, 0.2132>, <13.4937, -1.2870, 0.1229>, <13.4932, -1.2604, 0.1787>}
triangle { <13.4949, -1.3328, 0.2132>, <13.4581, -1.3122, 0.2584>, <13.4932, -1.2604, 0.1787>}
triangle { <13.4581, -1.3122, 0.2584>, <13.4932, -1.2604, 0.1787>, <13.4564, -1.2397, 0.2238>}
triangle { <13.4581, -1.3122, 0.2584>, <13.3991, -1.3055, 0.2756>, <13.4564, -1.2397, 0.2238>}
triangle { <13.3991, -1.3055, 0.2756>, <13.4564, -1.2397, 0.2238>, <13.3975, -1.2327, 0.2410>}
triangle { <13.3991, -1.3055, 0.2756>, <13.3405, -1.3151, 0.2584>, <13.3975, -1.2327, 0.2410>}
triangle { <13.3405, -1.3151, 0.2584>, <13.3975, -1.2327, 0.2410>, <13.3389, -1.2421, 0.2238>}
triangle { <13.3405, -1.3151, 0.2584>, <13.3048, -1.3375, 0.2132>, <13.3389, -1.2421, 0.2238>}
triangle { <13.3048, -1.3375, 0.2132>, <13.3389, -1.2421, 0.2238>, <13.3030, -1.2644, 0.1787>}
triangle { <13.3048, -1.3375, 0.2132>, <13.3054, -1.3640, 0.1574>, <13.3030, -1.2644, 0.1787>}
triangle { <13.3054, -1.3640, 0.1574>, <13.3030, -1.2644, 0.1787>, <13.3036, -1.2910, 0.1229>}
triangle { <13.3054, -1.3640, 0.1574>, <13.3422, -1.3845, 0.1122>, <13.3036, -1.2910, 0.1229>}
triangle { <13.3422, -1.3845, 0.1122>, <13.3036, -1.2910, 0.1229>, <13.3403, -1.3117, 0.0778>}
triangle { <13.3422, -1.3845, 0.1122>, <13.4012, -1.3913, 0.0950>, <13.3403, -1.3117, 0.0778>}
triangle { <13.4012, -1.3913, 0.0950>, <13.3403, -1.3117, 0.0778>, <13.3993, -1.3187, 0.0605>}
triangle { <13.3993, -1.3187, 0.0605>, <13.4579, -1.3093, 0.0778>, <13.3981, -1.2615, 0.0332>}
triangle { <13.4579, -1.3093, 0.0778>, <13.3981, -1.2615, 0.0332>, <13.4567, -1.2521, 0.0504>}
triangle { <13.4579, -1.3093, 0.0778>, <13.4937, -1.2870, 0.1229>, <13.4567, -1.2521, 0.0504>}
triangle { <13.4937, -1.2870, 0.1229>, <13.4567, -1.2521, 0.0504>, <13.4925, -1.2298, 0.0956>}
triangle { <13.4937, -1.2870, 0.1229>, <13.4932, -1.2604, 0.1787>, <13.4925, -1.2298, 0.0956>}
triangle { <13.4932, -1.2604, 0.1787>, <13.4925, -1.2298, 0.0956>, <13.4920, -1.2032, 0.1514>}
triangle { <13.4932, -1.2604, 0.1787>, <13.4564, -1.2397, 0.2238>, <13.4920, -1.2032, 0.1514>}
triangle { <13.4564, -1.2397, 0.2238>, <13.4920, -1.2032, 0.1514>, <13.4552, -1.1824, 0.1965>}
triangle { <13.4564, -1.2397, 0.2238>, <13.3975, -1.2327, 0.2410>, <13.4552, -1.1824, 0.1965>}
triangle { <13.3975, -1.2327, 0.2410>, <13.4552, -1.1824, 0.1965>, <13.3963, -1.1754, 0.2137>}
triangle { <13.3975, -1.2327, 0.2410>, <13.3389, -1.2421, 0.2238>, <13.3963, -1.1754, 0.2137>}
triangle { <13.3389, -1.2421, 0.2238>, <13.3963, -1.1754, 0.2137>, <13.3377, -1.1848, 0.1965>}
triangle { <13.3389, -1.2421, 0.2238>, <13.3030, -1.2644, 0.1787>, <13.3377, -1.1848, 0.1965>}
triangle { <13.3030, -1.2644, 0.1787>, <13.3377, -1.1848, 0.1965>, <13.3018, -1.2071, 0.1514>}
triangle { <13.3030, -1.2644, 0.1787>, <13.3036, -1.2910, 0.1229>, <13.3018, -1.2071, 0.1514>}
triangle { <13.3036, -1.2910, 0.1229>, <13.3018, -1.2071, 0.1514>, <13.3024, -1.2337, 0.0956>}
triangle { <13.3036, -1.2910, 0.1229>, <13.3403, -1.3117, 0.0778>, <13.3024, -1.2337, 0.0956>}
triangle { <13.3403, -1.3117, 0.0778>, <13.3024, -1.2337, 0.0956>, <13.3391, -1.2545, 0.0504>}
triangle { <13.3403, -1.3117, 0.0778>, <13.3993, -1.3187, 0.0605>, <13.3391, -1.2545, 0.0504>}
triangle { <13.3993, -1.3187, 0.0605>, <13.3391, -1.2545, 0.0504>, <13.3981, -1.2615, 0.0332>}
triangle { <13.3981, -1.2615, 0.0332>, <13.4567, -1.2521, 0.0504>, <13.3972, -1.2185, 0.0127>}
triangle { <13.4567, -1.2521, 0.0504>, <13.3972, -1.2185, 0.0127>, <13.4558, -1.2090, 0.0299>}
triangle { <13.4567, -1.2521, 0.0504>, <13.4925, -1.2298, 0.0956>, <13.4558, -1.2090, 0.0299>}
triangle { <13.4925, -1.2298, 0.0956>, <13.4558, -1.2090, 0.0299>, <13.4917, -1.1868, 0.0750>}
triangle { <13.4925, -1.2298, 0.0956>, <13.4920, -1.2032, 0.1514>, <13.4917, -1.1868, 0.0750>}
triangle { <13.4920, -1.2032, 0.1514>, <13.4917, -1.1868, 0.0750>, <13.4911, -1.1602, 0.1308>}
triangle { <13.4920, -1.2032, 0.1514>, <13.4552, -1.1824, 0.1965>, <13.4911, -1.1602, 0.1308>}
triangle { <13.4552, -1.1824, 0.1965>, <13.4911, -1.1602, 0.1308>, <13.4544, -1.1394, 0.1760>}
triangle { <13.4552, -1.1824, 0.1965>, <13.3963, -1.1754, 0.2137>, <13.4544, -1.1394, 0.1760>}
triangle { <13.3963, -1.1754, 0.2137>, <13.4544, -1.1394, 0.1760>, <13.3954, -1.1324, 0.1932>}
triangle { <13.3963, -1.1754, 0.2137>, <13.3377, -1.1848, 0.1965>, <13.3954, -1.1324, 0.1932>}
triangle { <13.3377, -1.1848, 0.1965>, <13.3954, -1.1324, 0.1932>, <13.3368, -1.1418, 0.1760>}
triangle { <13.3377, -1.1848, 0.1965>, <13.3018, -1.2071, 0.1514>, <13.3368, -1.1418, 0.1760>}
triangle { <13.3018, -1.2071, 0.1514>, <13.3368, -1.1418, 0.1760>, <13.3009, -1.1641, 0.1308>}
triangle { <13.3018, -1.2071, 0.1514>, <13.3024, -1.2337, 0.0956>, <13.3009, -1.1641, 0.1308>}
triangle { <13.3024, -1.2337, 0.0956>, <13.3009, -1.1641, 0.1308>, <13.3015, -1.1907, 0.0750>}
triangle { <13.3024, -1.2337, 0.0956>, <13.3391, -1.2545, 0.0504>, <13.3015, -1.1907, 0.0750>}
triangle { <13.3391, -1.2545, 0.0504>, <13.3015, -1.1907, 0.0750>, <13.3383, -1.2114, 0.0299>}
triangle { <13.3391, -1.2545, 0.0504>, <13.3981, -1.2615, 0.0332>, <13.3383, -1.2114, 0.0299>}
triangle { <13.3981, -1.2615, 0.0332>, <13.3383, -1.2114, 0.0299>, <13.3972, -1.2185, 0.0127>}
triangle { <13.3972, -1.2185, 0.0127>, <13.4558, -1.2090, 0.0299>, <13.3966, -1.1876, -0.0020>}
triangle { <13.4558, -1.2090, 0.0299>, <13.3966, -1.1876, -0.0020>, <13.4552, -1.1782, 0.0152>}
triangle { <13.4558, -1.2090, 0.0299>, <13.4917, -1.1868, 0.0750>, <13.4552, -1.1782, 0.0152>}
triangle { <13.4917, -1.1868, 0.0750>, <13.4552, -1.1782, 0.0152>, <13.4910, -1.1559, 0.0603>}
triangle { <13.4917, -1.1868, 0.0750>, <13.4911, -1.1602, 0.1308>, <13.4910, -1.1559, 0.0603>}
triangle { <13.4911, -1.1602, 0.1308>, <13.4910, -1.1559, 0.0603>, <13.4905, -1.1293, 0.1161>}
triangle { <13.4911, -1.1602, 0.1308>, <13.4544, -1.1394, 0.1760>, <13.4905, -1.1293, 0.1161>}
triangle { <13.4544, -1.1394, 0.1760>, <13.4905, -1.1293, 0.1161>, <13.4537, -1.1085, 0.1612>}
triangle { <13.4544, -1.1394, 0.1760>, <13.3954, -1.1324, 0.1932>, <13.4537, -1.1085, 0.1612>}
triangle { <13.3954, -1.1324, 0.1932>, <13.4537, -1.1085, 0.1612>, <13.3948, -1.1015, 0.1785>}
triangle { <13.3954, -1.1324, 0.1932>, <13.3368, -1.1418, 0.1760>, <13.3948, -1.1015, 0.1785>}
triangle { <13.3368, -1.1418, 0.1760>, <13.3948, -1.1015, 0.1785>, <13.3362, -1.1110, 0.1612>}
triangle { <13.3368, -1.1418, 0.1760>, <13.3009, -1.1641, 0.1308>, <13.3362, -1.1110, 0.1612>}
triangle { <13.3009, -1.1641, 0.1308>, <13.3362, -1.1110, 0.1612>, <13.3003, -1.1332, 0.1161>}
triangle { <13.3009, -1.1641, 0.1308>, <13.3015, -1.1907, 0.0750>, <13.3003, -1.1332, 0.1161>}
triangle { <13.3015, -1.1907, 0.0750>, <13.3003, -1.1332, 0.1161>, <13.3009, -1.1598, 0.0603>}
triangle { <13.3015, -1.1907, 0.0750>, <13.3383, -1.2114, 0.0299>, <13.3009, -1.1598, 0.0603>}
triangle { <13.3383, -1.2114, 0.0299>, <13.3009, -1.1598, 0.0603>, <13.3376, -1.1806, 0.0152>}
triangle { <13.3383, -1.2114, 0.0299>, <13.3972, -1.2185, 0.0127>, <13.3376, -1.1806, 0.0152>}
triangle { <13.3972, -1.2185, 0.0127>, <13.3376, -1.1806, 0.0152>, <13.3966, -1.1876, -0.0020>}
triangle { <13.3966, -1.1876, -0.0020>, <13.4552, -1.1782, 0.0152>, <13.3961, -1.1670, -0.0119>}
triangle { <13.4552, -1.1782, 0.0152>, <13.3961, -1.1670, -0.0119>, <13.4547, -1.1575, 0.0053>}
triangle { <13.4552, -1.1782, 0.0152>, <13.4910, -1.1559, 0.0603>, <13.4547, -1.1575, 0.0053>}
triangle { <13.4910, -1.1559, 0.0603>, <13.4547, -1.1575, 0.0053>, <13.4906, -1.1353, 0.0505>}
triangle { <13.4910, -1.1559, 0.0603>, <13.4905, -1.1293, 0.1161>, <13.4906, -1.1353, 0.0505>}
triangle { <13.4905, -1.1293, 0.1161>, <13.4906, -1.1353, 0.0505>, <13.4901, -1.1087, 0.1063>}
triangle { <13.4905, -1.1293, 0.1161>, <13.4537, -1.1085, 0.1612>, <13.4901, -1.1087, 0.1063>}
triangle { <13.4537, -1.1085, 0.1612>, <13.4901, -1.1087, 0.1063>, <13.4533, -1.0879, 0.1514>}
triangle { <13.4537, -1.1085, 0.1612>, <13.3948, -1.1015, 0.1785>, <13.4533, -1.0879, 0.1514>}
triangle { <13.3948, -1.1015, 0.1785>, <13.4533, -1.0879, 0.1514>, <13.3944, -1.0809, 0.1686>}
triangle { <13.3948, -1.1015, 0.1785>, <13.3362, -1.1110, 0.1612>, <13.3944, -1.0809, 0.1686>}
triangle { <13.3362, -1.1110, 0.1612>, <13.3944, -1.0809, 0.1686>, <13.3358, -1.0903, 0.1514>}
triangle { <13.3362, -1.1110, 0.1612>, <13.3003, -1.1332, 0.1161>, <13.3358, -1.0903, 0.1514>}
triangle { <13.3003, -1.1332, 0.1161>, <13.3358, -1.0903, 0.1514>, <13.2999, -1.1126, 0.1063>}
triangle { <13.3003, -1.1332, 0.1161>, <13.3009, -1.1598, 0.0603>, <13.2999, -1.1126, 0.1063>}
triangle { <13.3009, -1.1598, 0.0603>, <13.2999, -1.1126, 0.1063>, <13.3004, -1.1392, 0.0505>}
triangle { <13.3009, -1.1598, 0.0603>, <13.3376, -1.1806, 0.0152>, <13.3004, -1.1392, 0.0505>}
triangle { <13.3376, -1.1806, 0.0152>, <13.3004, -1.1392, 0.0505>, <13.3372, -1.1600, 0.0053>}
triangle { <13.3376, -1.1806, 0.0152>, <13.3966, -1.1876, -0.0020>, <13.3372, -1.1600, 0.0053>}
triangle { <13.3966, -1.1876, -0.0020>, <13.3372, -1.1600, 0.0053>, <13.3961, -1.1670, -0.0119>}
triangle { <13.3961, -1.1670, -0.0119>, <13.4547, -1.1575, 0.0053>, <13.3959, -1.1544, -0.0179>}
triangle { <13.4547, -1.1575, 0.0053>, <13.3959, -1.1544, -0.0179>, <13.4545, -1.1450, -0.0006>}
triangle { <13.4547, -1.1575, 0.0053>, <13.4906, -1.1353, 0.0505>, <13.4545, -1.1450, -0.0006>}
triangle { <13.4906, -1.1353, 0.0505>, <13.4545, -1.1450, -0.0006>, <13.4903, -1.1227, 0.0445>}
triangle { <13.4906, -1.1353, 0.0505>, <13.4901, -1.1087, 0.1063>, <13.4903, -1.1227, 0.0445>}
triangle { <13.4901, -1.1087, 0.1063>, <13.4903, -1.1227, 0.0445>, <13.4898, -1.0961, 0.1003>}
triangle { <13.4901, -1.1087, 0.1063>, <13.4533, -1.0879, 0.1514>, <13.4898, -1.0961, 0.1003>}
triangle { <13.4533, -1.0879, 0.1514>, <13.4898, -1.0961, 0.1003>, <13.4530, -1.0753, 0.1454>}
triangle { <13.4533, -1.0879, 0.1514>, <13.3944, -1.0809, 0.1686>, <13.4530, -1.0753, 0.1454>}
triangle { <13.3944, -1.0809, 0.1686>, <13.4530, -1.0753, 0.1454>, <13.3941, -1.0683, 0.1626>}
triangle { <13.3944, -1.0809, 0.1686>, <13.3358, -1.0903, 0.1514>, <13.3941, -1.0683, 0.1626>}
triangle { <13.3358, -1.0903, 0.1514>, <13.3941, -1.0683, 0.1626>, <13.3355, -1.0778, 0.1454>}
triangle { <13.3358, -1.0903, 0.1514>, <13.2999, -1.1126, 0.1063>, <13.3355, -1.0778, 0.1454>}
triangle { <13.2999, -1.1126, 0.1063>, <13.3355, -1.0778, 0.1454>, <13.2996, -1.1000, 0.1003>}
triangle { <13.2999, -1.1126, 0.1063>, <13.3004, -1.1392, 0.0505>, <13.2996, -1.1000, 0.1003>}
triangle { <13.3004, -1.1392, 0.0505>, <13.2996, -1.1000, 0.1003>, <13.3002, -1.1266, 0.0445>}
triangle { <13.3004, -1.1392, 0.0505>, <13.3372, -1.1600, 0.0053>, <13.3002, -1.1266, 0.0445>}
triangle { <13.3372, -1.1600, 0.0053>, <13.3002, -1.1266, 0.0445>, <13.3369, -1.1474, -0.0006>}
triangle { <13.3372, -1.1600, 0.0053>, <13.3961, -1.1670, -0.0119>, <13.3369, -1.1474, -0.0006>}
triangle { <13.3961, -1.1670, -0.0119>, <13.3369, -1.1474, -0.0006>, <13.3959, -1.1544, -0.0179>}
// object MikesBSplineObject exported
  material {
    R2D2Hose
  }
  scale 0.06
  translate  <-1.055, -0.0409, -0.8133>
}
#declare BSpline002 = merge {
triangle { <-3.0030, 0.8875, 0.4342>, <-3.0618, 0.8867, 0.4533>, <-3.0030, 0.8870, 0.4342>}
triangle { <-3.0618, 0.8867, 0.4533>, <-3.0030, 0.8870, 0.4342>, <-3.0618, 0.8861, 0.4533>}
triangle { <-3.0618, 0.8867, 0.4533>, <-3.0981, 0.8858, 0.5033>, <-3.0618, 0.8861, 0.4533>}
triangle { <-3.0981, 0.8858, 0.5033>, <-3.0618, 0.8861, 0.4533>, <-3.0981, 0.8853, 0.5033>}
triangle { <-3.0981, 0.8858, 0.5033>, <-3.0981, 0.8852, 0.5651>, <-3.0981, 0.8853, 0.5033>}
triangle { <-3.0981, 0.8852, 0.5651>, <-3.0981, 0.8853, 0.5033>, <-3.0981, 0.8847, 0.5651>}
triangle { <-3.0981, 0.8852, 0.5651>, <-3.0618, 0.8852, 0.6151>, <-3.0981, 0.8847, 0.5651>}
triangle { <-3.0618, 0.8852, 0.6151>, <-3.0981, 0.8847, 0.5651>, <-3.0618, 0.8847, 0.6151>}
triangle { <-3.0618, 0.8852, 0.6151>, <-3.0030, 0.8857, 0.6342>, <-3.0618, 0.8847, 0.6151>}
triangle { <-3.0030, 0.8857, 0.6342>, <-3.0618, 0.8847, 0.6151>, <-3.0030, 0.8852, 0.6342>}
triangle { <-3.0030, 0.8857, 0.6342>, <-2.9442, 0.8866, 0.6151>, <-3.0030, 0.8852, 0.6342>}
triangle { <-2.9442, 0.8866, 0.6151>, <-3.0030, 0.8852, 0.6342>, <-2.9442, 0.8861, 0.6151>}
triangle { <-2.9442, 0.8866, 0.6151>, <-2.9079, 0.8875, 0.5651>, <-2.9442, 0.8861, 0.6151>}
triangle { <-2.9079, 0.8875, 0.5651>, <-2.9442, 0.8861, 0.6151>, <-2.9079, 0.8869, 0.5651>}
triangle { <-2.9079, 0.8875, 0.5651>, <-2.9079, 0.8880, 0.5033>, <-2.9079, 0.8869, 0.5651>}
triangle { <-2.9079, 0.8880, 0.5033>, <-2.9079, 0.8869, 0.5651>, <-2.9079, 0.8875, 0.5033>}
triangle { <-2.9079, 0.8880, 0.5033>, <-2.9442, 0.8881, 0.4533>, <-2.9079, 0.8875, 0.5033>}
triangle { <-2.9442, 0.8881, 0.4533>, <-2.9079, 0.8875, 0.5033>, <-2.9442, 0.8875, 0.4533>}
triangle { <-2.9442, 0.8881, 0.4533>, <-3.0030, 0.8875, 0.4342>, <-2.9442, 0.8875, 0.4533>}
triangle { <-3.0030, 0.8875, 0.4342>, <-2.9442, 0.8875, 0.4533>, <-3.0030, 0.8870, 0.4342>}
triangle { <-3.0030, 0.8870, 0.4342>, <-3.0618, 0.8861, 0.4533>, <-3.0030, 0.8833, 0.4342>}
triangle { <-3.0618, 0.8861, 0.4533>, <-3.0030, 0.8833, 0.4342>, <-3.0617, 0.8824, 0.4533>}
triangle { <-3.0618, 0.8861, 0.4533>, <-3.0981, 0.8853, 0.5033>, <-3.0617, 0.8824, 0.4533>}
triangle { <-3.0981, 0.8853, 0.5033>, <-3.0617, 0.8824, 0.4533>, <-3.0980, 0.8815, 0.5033>}
triangle { <-3.0981, 0.8853, 0.5033>, <-3.0981, 0.8847, 0.5651>, <-3.0980, 0.8815, 0.5033>}
triangle { <-3.0981, 0.8847, 0.5651>, <-3.0980, 0.8815, 0.5033>, <-3.0980, 0.8810, 0.5651>}
triangle { <-3.0981, 0.8847, 0.5651>, <-3.0618, 0.8847, 0.6151>, <-3.0980, 0.8810, 0.5651>}
triangle { <-3.0618, 0.8847, 0.6151>, <-3.0980, 0.8810, 0.5651>, <-3.0617, 0.8809, 0.6151>}
triangle { <-3.0618, 0.8847, 0.6151>, <-3.0030, 0.8852, 0.6342>, <-3.0617, 0.8809, 0.6151>}
triangle { <-3.0030, 0.8852, 0.6342>, <-3.0617, 0.8809, 0.6151>, <-3.0029, 0.8814, 0.6342>}
triangle { <-3.0030, 0.8852, 0.6342>, <-2.9442, 0.8861, 0.6151>, <-3.0029, 0.8814, 0.6342>}
triangle { <-2.9442, 0.8861, 0.6151>, <-3.0029, 0.8814, 0.6342>, <-2.9442, 0.8823, 0.6151>}
triangle { <-2.9442, 0.8861, 0.6151>, <-2.9079, 0.8869, 0.5651>, <-2.9442, 0.8823, 0.6151>}
triangle { <-2.9079, 0.8869, 0.5651>, <-2.9442, 0.8823, 0.6151>, <-2.9078, 0.8832, 0.5651>}
triangle { <-2.9079, 0.8869, 0.5651>, <-2.9079, 0.8875, 0.5033>, <-2.9078, 0.8832, 0.5651>}
triangle { <-2.9079, 0.8875, 0.5033>, <-2.9078, 0.8832, 0.5651>, <-2.9079, 0.8837, 0.5033>}
triangle { <-2.9079, 0.8875, 0.5033>, <-2.9442, 0.8875, 0.4533>, <-2.9079, 0.8837, 0.5033>}
triangle { <-2.9442, 0.8875, 0.4533>, <-2.9079, 0.8837, 0.5033>, <-2.9442, 0.8838, 0.4533>}
triangle { <-2.9442, 0.8875, 0.4533>, <-3.0030, 0.8870, 0.4342>, <-2.9442, 0.8838, 0.4533>}
triangle { <-3.0030, 0.8870, 0.4342>, <-2.9442, 0.8838, 0.4533>, <-3.0030, 0.8833, 0.4342>}
triangle { <-3.0030, 0.8833, 0.4342>, <-3.0617, 0.8824, 0.4533>, <-3.0028, 0.8731, 0.4341>}
triangle { <-3.0617, 0.8824, 0.4533>, <-3.0028, 0.8731, 0.4341>, <-3.0616, 0.8722, 0.4532>}
triangle { <-3.0617, 0.8824, 0.4533>, <-3.0980, 0.8815, 0.5033>, <-3.0616, 0.8722, 0.4532>}
triangle { <-3.0980, 0.8815, 0.5033>, <-3.0616, 0.8722, 0.4532>, <-3.0979, 0.8713, 0.5032>}
triangle { <-3.0980, 0.8815, 0.5033>, <-3.0980, 0.8810, 0.5651>, <-3.0979, 0.8713, 0.5032>}
triangle { <-3.0980, 0.8810, 0.5651>, <-3.0979, 0.8713, 0.5032>, <-3.0979, 0.8708, 0.5650>}
triangle { <-3.0980, 0.8810, 0.5651>, <-3.0617, 0.8809, 0.6151>, <-3.0979, 0.8708, 0.5650>}
triangle { <-3.0617, 0.8809, 0.6151>, <-3.0979, 0.8708, 0.5650>, <-3.0616, 0.8707, 0.6150>}
triangle { <-3.0617, 0.8809, 0.6151>, <-3.0029, 0.8814, 0.6342>, <-3.0616, 0.8707, 0.6150>}
triangle { <-3.0029, 0.8814, 0.6342>, <-3.0616, 0.8707, 0.6150>, <-3.0028, 0.8713, 0.6341>}
triangle { <-3.0029, 0.8814, 0.6342>, <-2.9442, 0.8823, 0.6151>, <-3.0028, 0.8713, 0.6341>}
triangle { <-2.9442, 0.8823, 0.6151>, <-3.0028, 0.8713, 0.6341>, <-2.9440, 0.8721, 0.6150>}
triangle { <-2.9442, 0.8823, 0.6151>, <-2.9078, 0.8832, 0.5651>, <-2.9440, 0.8721, 0.6150>}
triangle { <-2.9078, 0.8832, 0.5651>, <-2.9440, 0.8721, 0.6150>, <-2.9077, 0.8730, 0.5650>}
triangle { <-2.9078, 0.8832, 0.5651>, <-2.9079, 0.8837, 0.5033>, <-2.9077, 0.8730, 0.5650>}
triangle { <-2.9079, 0.8837, 0.5033>, <-2.9077, 0.8730, 0.5650>, <-2.9077, 0.8736, 0.5032>}
triangle { <-2.9079, 0.8837, 0.5033>, <-2.9442, 0.8838, 0.4533>, <-2.9077, 0.8736, 0.5032>}
triangle { <-2.9442, 0.8838, 0.4533>, <-2.9077, 0.8736, 0.5032>, <-2.9441, 0.8736, 0.4532>}
triangle { <-2.9442, 0.8838, 0.4533>, <-3.0030, 0.8833, 0.4342>, <-2.9441, 0.8736, 0.4532>}
triangle { <-3.0030, 0.8833, 0.4342>, <-2.9441, 0.8736, 0.4532>, <-3.0028, 0.8731, 0.4341>}
triangle { <-3.0028, 0.8731, 0.4341>, <-3.0616, 0.8722, 0.4532>, <-3.0026, 0.8532, 0.4339>}
triangle { <-3.0616, 0.8722, 0.4532>, <-3.0026, 0.8532, 0.4339>, <-3.0614, 0.8524, 0.4530>}
triangle { <-3.0616, 0.8722, 0.4532>, <-3.0979, 0.8713, 0.5032>, <-3.0614, 0.8524, 0.4530>}
triangle { <-3.0979, 0.8713, 0.5032>, <-3.0614, 0.8524, 0.4530>, <-3.0977, 0.8515, 0.5030>}
triangle { <-3.0979, 0.8713, 0.5032>, <-3.0979, 0.8708, 0.5650>, <-3.0977, 0.8515, 0.5030>}
triangle { <-3.0979, 0.8708, 0.5650>, <-3.0977, 0.8515, 0.5030>, <-3.0977, 0.8509, 0.5648>}
triangle { <-3.0979, 0.8708, 0.5650>, <-3.0616, 0.8707, 0.6150>, <-3.0977, 0.8509, 0.5648>}
triangle { <-3.0616, 0.8707, 0.6150>, <-3.0977, 0.8509, 0.5648>, <-3.0614, 0.8509, 0.6148>}
triangle { <-3.0616, 0.8707, 0.6150>, <-3.0028, 0.8713, 0.6341>, <-3.0614, 0.8509, 0.6148>}
triangle { <-3.0028, 0.8713, 0.6341>, <-3.0614, 0.8509, 0.6148>, <-3.0026, 0.8514, 0.6339>}
triangle { <-3.0028, 0.8713, 0.6341>, <-2.9440, 0.8721, 0.6150>, <-3.0026, 0.8514, 0.6339>}
triangle { <-2.9440, 0.8721, 0.6150>, <-3.0026, 0.8514, 0.6339>, <-2.9438, 0.8523, 0.6148>}
triangle { <-2.9440, 0.8721, 0.6150>, <-2.9077, 0.8730, 0.5650>, <-2.9438, 0.8523, 0.6148>}
triangle { <-2.9077, 0.8730, 0.5650>, <-2.9438, 0.8523, 0.6148>, <-2.9075, 0.8532, 0.5648>}
triangle { <-2.9077, 0.8730, 0.5650>, <-2.9077, 0.8736, 0.5032>, <-2.9075, 0.8532, 0.5648>}
triangle { <-2.9077, 0.8736, 0.5032>, <-2.9075, 0.8532, 0.5648>, <-2.9075, 0.8537, 0.5030>}
triangle { <-2.9077, 0.8736, 0.5032>, <-2.9441, 0.8736, 0.4532>, <-2.9075, 0.8537, 0.5030>}
triangle { <-2.9441, 0.8736, 0.4532>, <-2.9075, 0.8537, 0.5030>, <-2.9438, 0.8537, 0.4530>}
triangle { <-2.9441, 0.8736, 0.4532>, <-3.0028, 0.8731, 0.4341>, <-2.9438, 0.8537, 0.4530>}
triangle { <-3.0028, 0.8731, 0.4341>, <-2.9438, 0.8537, 0.4530>, <-3.0026, 0.8532, 0.4339>}
triangle { <-3.0026, 0.8532, 0.4339>, <-3.0614, 0.8524, 0.4530>, <-3.0022, 0.8205, 0.4336>}
triangle { <-3.0614, 0.8524, 0.4530>, <-3.0022, 0.8205, 0.4336>, <-3.0610, 0.8197, 0.4527>}
triangle { <-3.0614, 0.8524, 0.4530>, <-3.0977, 0.8515, 0.5030>, <-3.0610, 0.8197, 0.4527>}
triangle { <-3.0977, 0.8515, 0.5030>, <-3.0610, 0.8197, 0.4527>, <-3.0973, 0.8188, 0.5027>}
triangle { <-3.0977, 0.8515, 0.5030>, <-3.0977, 0.8509, 0.5648>, <-3.0973, 0.8188, 0.5027>}
triangle { <-3.0977, 0.8509, 0.5648>, <-3.0973, 0.8188, 0.5027>, <-3.0973, 0.8182, 0.5645>}
triangle { <-3.0977, 0.8509, 0.5648>, <-3.0614, 0.8509, 0.6148>, <-3.0973, 0.8182, 0.5645>}
triangle { <-3.0614, 0.8509, 0.6148>, <-3.0973, 0.8182, 0.5645>, <-3.0610, 0.8182, 0.6145>}
triangle { <-3.0614, 0.8509, 0.6148>, <-3.0026, 0.8514, 0.6339>, <-3.0610, 0.8182, 0.6145>}
triangle { <-3.0026, 0.8514, 0.6339>, <-3.0610, 0.8182, 0.6145>, <-3.0022, 0.8187, 0.6336>}
triangle { <-3.0026, 0.8514, 0.6339>, <-2.9438, 0.8523, 0.6148>, <-3.0022, 0.8187, 0.6336>}
triangle { <-2.9438, 0.8523, 0.6148>, <-3.0022, 0.8187, 0.6336>, <-2.9434, 0.8196, 0.6145>}
triangle { <-2.9438, 0.8523, 0.6148>, <-2.9075, 0.8532, 0.5648>, <-2.9434, 0.8196, 0.6145>}
triangle { <-2.9075, 0.8532, 0.5648>, <-2.9434, 0.8196, 0.6145>, <-2.9071, 0.8205, 0.5645>}
triangle { <-2.9075, 0.8532, 0.5648>, <-2.9075, 0.8537, 0.5030>, <-2.9071, 0.8205, 0.5645>}
triangle { <-2.9075, 0.8537, 0.5030>, <-2.9071, 0.8205, 0.5645>, <-2.9071, 0.8210, 0.5027>}
triangle { <-2.9075, 0.8537, 0.5030>, <-2.9438, 0.8537, 0.4530>, <-2.9071, 0.8210, 0.5027>}
triangle { <-2.9438, 0.8537, 0.4530>, <-2.9071, 0.8210, 0.5027>, <-2.9434, 0.8210, 0.4527>}
triangle { <-2.9438, 0.8537, 0.4530>, <-3.0026, 0.8532, 0.4339>, <-2.9434, 0.8210, 0.4527>}
triangle { <-3.0026, 0.8532, 0.4339>, <-2.9434, 0.8210, 0.4527>, <-3.0022, 0.8205, 0.4336>}
triangle { <-3.0022, 0.8205, 0.4336>, <-3.0610, 0.8197, 0.4527>, <-3.0017, 0.7717, 0.4332>}
triangle { <-3.0610, 0.8197, 0.4527>, <-3.0017, 0.7717, 0.4332>, <-3.0604, 0.7709, 0.4523>}
triangle { <-3.0610, 0.8197, 0.4527>, <-3.0973, 0.8188, 0.5027>, <-3.0604, 0.7709, 0.4523>}
triangle { <-3.0973, 0.8188, 0.5027>, <-3.0604, 0.7709, 0.4523>, <-3.0967, 0.7700, 0.5023>}
triangle { <-3.0973, 0.8188, 0.5027>, <-3.0973, 0.8182, 0.5645>, <-3.0967, 0.7700, 0.5023>}
triangle { <-3.0973, 0.8182, 0.5645>, <-3.0967, 0.7700, 0.5023>, <-3.0967, 0.7694, 0.5641>}
triangle { <-3.0973, 0.8182, 0.5645>, <-3.0610, 0.8182, 0.6145>, <-3.0967, 0.7694, 0.5641>}
triangle { <-3.0610, 0.8182, 0.6145>, <-3.0967, 0.7694, 0.5641>, <-3.0604, 0.7694, 0.6141>}
triangle { <-3.0610, 0.8182, 0.6145>, <-3.0022, 0.8187, 0.6336>, <-3.0604, 0.7694, 0.6141>}
triangle { <-3.0022, 0.8187, 0.6336>, <-3.0604, 0.7694, 0.6141>, <-3.0016, 0.7699, 0.6332>}
triangle { <-3.0022, 0.8187, 0.6336>, <-2.9434, 0.8196, 0.6145>, <-3.0016, 0.7699, 0.6332>}
triangle { <-2.9434, 0.8196, 0.6145>, <-3.0016, 0.7699, 0.6332>, <-2.9429, 0.7708, 0.6141>}
triangle { <-2.9434, 0.8196, 0.6145>, <-2.9071, 0.8205, 0.5645>, <-2.9429, 0.7708, 0.6141>}
triangle { <-2.9071, 0.8205, 0.5645>, <-2.9429, 0.7708, 0.6141>, <-2.9065, 0.7717, 0.5641>}
triangle { <-2.9071, 0.8205, 0.5645>, <-2.9071, 0.8210, 0.5027>, <-2.9065, 0.7717, 0.5641>}
triangle { <-2.9071, 0.8210, 0.5027>, <-2.9065, 0.7717, 0.5641>, <-2.9065, 0.7722, 0.5023>}
triangle { <-2.9071, 0.8210, 0.5027>, <-2.9434, 0.8210, 0.4527>, <-2.9065, 0.7722, 0.5023>}
triangle { <-2.9434, 0.8210, 0.4527>, <-2.9065, 0.7722, 0.5023>, <-2.9429, 0.7722, 0.4523>}
triangle { <-2.9434, 0.8210, 0.4527>, <-3.0022, 0.8205, 0.4336>, <-2.9429, 0.7722, 0.4523>}
triangle { <-3.0022, 0.8205, 0.4336>, <-2.9429, 0.7722, 0.4523>, <-3.0017, 0.7717, 0.4332>}
triangle { <-3.0017, 0.7717, 0.4332>, <-3.0604, 0.7709, 0.4523>, <-3.0009, 0.7036, 0.4326>}
triangle { <-3.0604, 0.7709, 0.4523>, <-3.0009, 0.7036, 0.4326>, <-3.0596, 0.7028, 0.4517>}
triangle { <-3.0604, 0.7709, 0.4523>, <-3.0967, 0.7700, 0.5023>, <-3.0596, 0.7028, 0.4517>}
triangle { <-3.0967, 0.7700, 0.5023>, <-3.0596, 0.7028, 0.4517>, <-3.0959, 0.7019, 0.5016>}
triangle { <-3.0967, 0.7700, 0.5023>, <-3.0967, 0.7694, 0.5641>, <-3.0959, 0.7019, 0.5016>}
triangle { <-3.0967, 0.7694, 0.5641>, <-3.0959, 0.7019, 0.5016>, <-3.0959, 0.7013, 0.5634>}
triangle { <-3.0967, 0.7694, 0.5641>, <-3.0604, 0.7694, 0.6141>, <-3.0959, 0.7013, 0.5634>}
triangle { <-3.0604, 0.7694, 0.6141>, <-3.0959, 0.7013, 0.5634>, <-3.0596, 0.7013, 0.6134>}
triangle { <-3.0604, 0.7694, 0.6141>, <-3.0016, 0.7699, 0.6332>, <-3.0596, 0.7013, 0.6134>}
triangle { <-3.0016, 0.7699, 0.6332>, <-3.0596, 0.7013, 0.6134>, <-3.0008, 0.7018, 0.6325>}
triangle { <-3.0016, 0.7699, 0.6332>, <-2.9429, 0.7708, 0.6141>, <-3.0008, 0.7018, 0.6325>}
triangle { <-2.9429, 0.7708, 0.6141>, <-3.0008, 0.7018, 0.6325>, <-2.9421, 0.7027, 0.6134>}
triangle { <-2.9429, 0.7708, 0.6141>, <-2.9065, 0.7717, 0.5641>, <-2.9421, 0.7027, 0.6134>}
triangle { <-2.9065, 0.7717, 0.5641>, <-2.9421, 0.7027, 0.6134>, <-2.9057, 0.7036, 0.5634>}
triangle { <-2.9065, 0.7717, 0.5641>, <-2.9065, 0.7722, 0.5023>, <-2.9057, 0.7036, 0.5634>}
triangle { <-2.9065, 0.7722, 0.5023>, <-2.9057, 0.7036, 0.5634>, <-2.9057, 0.7041, 0.5016>}
triangle { <-2.9065, 0.7722, 0.5023>, <-2.9429, 0.7722, 0.4523>, <-2.9057, 0.7041, 0.5016>}
triangle { <-2.9429, 0.7722, 0.4523>, <-2.9057, 0.7041, 0.5016>, <-2.9421, 0.7042, 0.4517>}
triangle { <-2.9429, 0.7722, 0.4523>, <-3.0017, 0.7717, 0.4332>, <-2.9421, 0.7042, 0.4517>}
triangle { <-3.0017, 0.7717, 0.4332>, <-2.9421, 0.7042, 0.4517>, <-3.0009, 0.7036, 0.4326>}
triangle { <-3.0009, 0.7036, 0.4326>, <-3.0596, 0.7028, 0.4517>, <-2.9998, 0.6127, 0.4317>}
triangle { <-3.0596, 0.7028, 0.4517>, <-2.9998, 0.6127, 0.4317>, <-3.0586, 0.6120, 0.4508>}
triangle { <-3.0596, 0.7028, 0.4517>, <-3.0959, 0.7019, 0.5016>, <-3.0586, 0.6120, 0.4508>}
triangle { <-3.0959, 0.7019, 0.5016>, <-3.0586, 0.6120, 0.4508>, <-3.0949, 0.6114, 0.5008>}
triangle { <-3.0959, 0.7019, 0.5016>, <-3.0959, 0.7013, 0.5634>, <-3.0949, 0.6114, 0.5008>}
triangle { <-3.0959, 0.7013, 0.5634>, <-3.0949, 0.6114, 0.5008>, <-3.0949, 0.6110, 0.5626>}
triangle { <-3.0959, 0.7013, 0.5634>, <-3.0596, 0.7013, 0.6134>, <-3.0949, 0.6110, 0.5626>}
triangle { <-3.0596, 0.7013, 0.6134>, <-3.0949, 0.6110, 0.5626>, <-3.0586, 0.6111, 0.6126>}
triangle { <-3.0596, 0.7013, 0.6134>, <-3.0008, 0.7018, 0.6325>, <-3.0586, 0.6111, 0.6126>}
triangle { <-3.0008, 0.7018, 0.6325>, <-3.0586, 0.6111, 0.6126>, <-2.9998, 0.6115, 0.6317>}
triangle { <-3.0008, 0.7018, 0.6325>, <-2.9421, 0.7027, 0.6134>, <-2.9998, 0.6115, 0.6317>}
triangle { <-2.9421, 0.7027, 0.6134>, <-2.9998, 0.6115, 0.6317>, <-2.9410, 0.6122, 0.6126>}
triangle { <-2.9421, 0.7027, 0.6134>, <-2.9057, 0.7036, 0.5634>, <-2.9410, 0.6122, 0.6126>}
triangle { <-2.9057, 0.7036, 0.5634>, <-2.9410, 0.6122, 0.6126>, <-2.9047, 0.6128, 0.5626>}
triangle { <-2.9057, 0.7036, 0.5634>, <-2.9057, 0.7041, 0.5016>, <-2.9047, 0.6128, 0.5626>}
triangle { <-2.9057, 0.7041, 0.5016>, <-2.9047, 0.6128, 0.5626>, <-2.9047, 0.6132, 0.5008>}
triangle { <-2.9057, 0.7041, 0.5016>, <-2.9421, 0.7042, 0.4517>, <-2.9047, 0.6132, 0.5008>}
triangle { <-2.9421, 0.7042, 0.4517>, <-2.9047, 0.6132, 0.5008>, <-2.9410, 0.6132, 0.4508>}
triangle { <-2.9421, 0.7042, 0.4517>, <-3.0009, 0.7036, 0.4326>, <-2.9410, 0.6132, 0.4508>}
triangle { <-3.0009, 0.7036, 0.4326>, <-2.9410, 0.6132, 0.4508>, <-2.9998, 0.6127, 0.4317>}
triangle { <-2.9998, 0.6127, 0.4317>, <-3.0586, 0.6120, 0.4508>, <-2.9987, 0.4962, 0.4310>}
triangle { <-3.0586, 0.6120, 0.4508>, <-2.9987, 0.4962, 0.4310>, <-3.0575, 0.4964, 0.4501>}
triangle { <-3.0586, 0.6120, 0.4508>, <-3.0949, 0.6114, 0.5008>, <-3.0575, 0.4964, 0.4501>}
triangle { <-3.0949, 0.6114, 0.5008>, <-3.0575, 0.4964, 0.4501>, <-3.0938, 0.4969, 0.5001>}
triangle { <-3.0949, 0.6114, 0.5008>, <-3.0949, 0.6110, 0.5626>, <-3.0938, 0.4969, 0.5001>}
triangle { <-3.0949, 0.6110, 0.5626>, <-3.0938, 0.4969, 0.5001>, <-3.0938, 0.4974, 0.5619>}
triangle { <-3.0949, 0.6110, 0.5626>, <-3.0586, 0.6111, 0.6126>, <-3.0938, 0.4974, 0.5619>}
triangle { <-3.0586, 0.6111, 0.6126>, <-3.0938, 0.4974, 0.5619>, <-3.0575, 0.4978, 0.6119>}
triangle { <-3.0586, 0.6111, 0.6126>, <-2.9998, 0.6115, 0.6317>, <-3.0575, 0.4978, 0.6119>}
triangle { <-2.9998, 0.6115, 0.6317>, <-3.0575, 0.4978, 0.6119>, <-2.9987, 0.4979, 0.6310>}
triangle { <-2.9998, 0.6115, 0.6317>, <-2.9410, 0.6122, 0.6126>, <-2.9987, 0.4979, 0.6310>}
triangle { <-2.9410, 0.6122, 0.6126>, <-2.9987, 0.4979, 0.6310>, <-2.9399, 0.4977, 0.6119>}
triangle { <-2.9410, 0.6122, 0.6126>, <-2.9047, 0.6128, 0.5626>, <-2.9399, 0.4977, 0.6119>}
triangle { <-2.9047, 0.6128, 0.5626>, <-2.9399, 0.4977, 0.6119>, <-2.9036, 0.4972, 0.5619>}
triangle { <-2.9047, 0.6128, 0.5626>, <-2.9047, 0.6132, 0.5008>, <-2.9036, 0.4972, 0.5619>}
triangle { <-2.9047, 0.6132, 0.5008>, <-2.9036, 0.4972, 0.5619>, <-2.9036, 0.4967, 0.5001>}
triangle { <-2.9047, 0.6132, 0.5008>, <-2.9410, 0.6132, 0.4508>, <-2.9036, 0.4967, 0.5001>}
triangle { <-2.9410, 0.6132, 0.4508>, <-2.9036, 0.4967, 0.5001>, <-2.9399, 0.4963, 0.4501>}
triangle { <-2.9410, 0.6132, 0.4508>, <-2.9998, 0.6127, 0.4317>, <-2.9399, 0.4963, 0.4501>}
triangle { <-2.9998, 0.6127, 0.4317>, <-2.9399, 0.4963, 0.4501>, <-2.9987, 0.4962, 0.4310>}
triangle { <-2.9987, 0.4962, 0.4310>, <-3.0575, 0.4964, 0.4501>, <-2.9988, 0.3573, 0.4323>}
triangle { <-3.0575, 0.4964, 0.4501>, <-2.9988, 0.3573, 0.4323>, <-3.0576, 0.3591, 0.4514>}
triangle { <-3.0575, 0.4964, 0.4501>, <-3.0938, 0.4969, 0.5001>, <-3.0576, 0.3591, 0.4514>}
triangle { <-3.0938, 0.4969, 0.5001>, <-3.0576, 0.3591, 0.4514>, <-3.0939, 0.3615, 0.5013>}
triangle { <-3.0938, 0.4969, 0.5001>, <-3.0938, 0.4974, 0.5619>, <-3.0939, 0.3615, 0.5013>}
triangle { <-3.0938, 0.4974, 0.5619>, <-3.0939, 0.3615, 0.5013>, <-3.0939, 0.3636, 0.5631>}
triangle { <-3.0938, 0.4974, 0.5619>, <-3.0575, 0.4978, 0.6119>, <-3.0939, 0.3636, 0.5631>}
triangle { <-3.0575, 0.4978, 0.6119>, <-3.0939, 0.3636, 0.5631>, <-3.0575, 0.3646, 0.6131>}
triangle { <-3.0575, 0.4978, 0.6119>, <-2.9987, 0.4979, 0.6310>, <-3.0575, 0.3646, 0.6131>}
triangle { <-2.9987, 0.4979, 0.6310>, <-3.0575, 0.3646, 0.6131>, <-2.9987, 0.3641, 0.6322>}
triangle { <-2.9987, 0.4979, 0.6310>, <-2.9399, 0.4977, 0.6119>, <-2.9987, 0.3641, 0.6322>}
triangle { <-2.9399, 0.4977, 0.6119>, <-2.9987, 0.3641, 0.6322>, <-2.9400, 0.3624, 0.6131>}
triangle { <-2.9399, 0.4977, 0.6119>, <-2.9036, 0.4972, 0.5619>, <-2.9400, 0.3624, 0.6131>}
triangle { <-2.9036, 0.4972, 0.5619>, <-2.9400, 0.3624, 0.6131>, <-2.9037, 0.3600, 0.5631>}
triangle { <-2.9036, 0.4972, 0.5619>, <-2.9036, 0.4967, 0.5001>, <-2.9037, 0.3600, 0.5631>}
triangle { <-2.9036, 0.4967, 0.5001>, <-2.9037, 0.3600, 0.5631>, <-2.9037, 0.3579, 0.5013>}
triangle { <-2.9036, 0.4967, 0.5001>, <-2.9399, 0.4963, 0.4501>, <-2.9037, 0.3579, 0.5013>}
triangle { <-2.9399, 0.4963, 0.4501>, <-2.9037, 0.3579, 0.5013>, <-2.9401, 0.3569, 0.4514>}
triangle { <-2.9399, 0.4963, 0.4501>, <-2.9987, 0.4962, 0.4310>, <-2.9401, 0.3569, 0.4514>}
triangle { <-2.9987, 0.4962, 0.4310>, <-2.9401, 0.3569, 0.4514>, <-2.9988, 0.3573, 0.4323>}
triangle { <-2.9988, 0.3573, 0.4323>, <-3.0576, 0.3591, 0.4514>, <-3.0019, 0.2009, 0.4377>}
triangle { <-3.0576, 0.3591, 0.4514>, <-3.0019, 0.2009, 0.4377>, <-3.0606, 0.2047, 0.4567>}
triangle { <-3.0576, 0.3591, 0.4514>, <-3.0939, 0.3615, 0.5013>, <-3.0606, 0.2047, 0.4567>}
triangle { <-3.0939, 0.3615, 0.5013>, <-3.0606, 0.2047, 0.4567>, <-3.0967, 0.2097, 0.5066>}
triangle { <-3.0939, 0.3615, 0.5013>, <-3.0939, 0.3636, 0.5631>, <-3.0967, 0.2097, 0.5066>}
triangle { <-3.0939, 0.3636, 0.5631>, <-3.0967, 0.2097, 0.5066>, <-3.0965, 0.2139, 0.5683>}
triangle { <-3.0939, 0.3636, 0.5631>, <-3.0575, 0.3646, 0.6131>, <-3.0965, 0.2139, 0.5683>}
triangle { <-3.0575, 0.3646, 0.6131>, <-3.0965, 0.2139, 0.5683>, <-3.0601, 0.2158, 0.6181>}
triangle { <-3.0575, 0.3646, 0.6131>, <-2.9987, 0.3641, 0.6322>, <-3.0601, 0.2158, 0.6181>}
triangle { <-2.9987, 0.3641, 0.6322>, <-3.0601, 0.2158, 0.6181>, <-3.0013, 0.2145, 0.6372>}
triangle { <-2.9987, 0.3641, 0.6322>, <-2.9400, 0.3624, 0.6131>, <-3.0013, 0.2145, 0.6372>}
triangle { <-2.9400, 0.3624, 0.6131>, <-3.0013, 0.2145, 0.6372>, <-2.9427, 0.2107, 0.6181>}
triangle { <-2.9400, 0.3624, 0.6131>, <-2.9037, 0.3600, 0.5631>, <-2.9427, 0.2107, 0.6181>}
triangle { <-2.9037, 0.3600, 0.5631>, <-2.9427, 0.2107, 0.6181>, <-2.9065, 0.2058, 0.5683>}
triangle { <-2.9037, 0.3600, 0.5631>, <-2.9037, 0.3579, 0.5013>, <-2.9065, 0.2058, 0.5683>}
triangle { <-2.9037, 0.3579, 0.5013>, <-2.9065, 0.2058, 0.5683>, <-2.9067, 0.2015, 0.5066>}
triangle { <-2.9037, 0.3579, 0.5013>, <-2.9401, 0.3569, 0.4514>, <-2.9067, 0.2015, 0.5066>}
triangle { <-2.9401, 0.3569, 0.4514>, <-2.9067, 0.2015, 0.5066>, <-2.9431, 0.1997, 0.4567>}
triangle { <-2.9401, 0.3569, 0.4514>, <-2.9988, 0.3573, 0.4323>, <-2.9431, 0.1997, 0.4567>}
triangle { <-2.9988, 0.3573, 0.4323>, <-2.9431, 0.1997, 0.4567>, <-3.0019, 0.2009, 0.4377>}
triangle { <-3.0019, 0.2009, 0.4377>, <-3.0606, 0.2047, 0.4567>, <-3.0095, 0.0312, 0.4494>}
triangle { <-3.0606, 0.2047, 0.4567>, <-3.0095, 0.0312, 0.4494>, <-3.0680, 0.0377, 0.4684>}
triangle { <-3.0606, 0.2047, 0.4567>, <-3.0967, 0.2097, 0.5066>, <-3.0680, 0.0377, 0.4684>}
triangle { <-3.0967, 0.2097, 0.5066>, <-3.0680, 0.0377, 0.4684>, <-3.1038, 0.0460, 0.5181>}
triangle { <-3.0967, 0.2097, 0.5066>, <-3.0965, 0.2139, 0.5683>, <-3.1038, 0.0460, 0.5181>}
triangle { <-3.0965, 0.2139, 0.5683>, <-3.1038, 0.0460, 0.5181>, <-3.1033, 0.0529, 0.5795>}
triangle { <-3.0965, 0.2139, 0.5683>, <-3.0601, 0.2158, 0.6181>, <-3.1033, 0.0529, 0.5795>}
triangle { <-3.0601, 0.2158, 0.6181>, <-3.1033, 0.0529, 0.5795>, <-3.0666, 0.0558, 0.6292>}
triangle { <-3.0601, 0.2158, 0.6181>, <-3.0013, 0.2145, 0.6372>, <-3.0666, 0.0558, 0.6292>}
triangle { <-3.0013, 0.2145, 0.6372>, <-3.0666, 0.0558, 0.6292>, <-3.0079, 0.0536, 0.6482>}
triangle { <-3.0013, 0.2145, 0.6372>, <-2.9427, 0.2107, 0.6181>, <-3.0079, 0.0536, 0.6482>}
triangle { <-2.9427, 0.2107, 0.6181>, <-3.0079, 0.0536, 0.6482>, <-2.9494, 0.0472, 0.6292>}
triangle { <-2.9427, 0.2107, 0.6181>, <-2.9065, 0.2058, 0.5683>, <-2.9494, 0.0472, 0.6292>}
triangle { <-2.9065, 0.2058, 0.5683>, <-2.9494, 0.0472, 0.6292>, <-2.9136, 0.0389, 0.5795>}
triangle { <-2.9065, 0.2058, 0.5683>, <-2.9067, 0.2015, 0.5066>, <-2.9136, 0.0389, 0.5795>}
triangle { <-2.9067, 0.2015, 0.5066>, <-2.9136, 0.0389, 0.5795>, <-2.9141, 0.0319, 0.5181>}
triangle { <-2.9067, 0.2015, 0.5066>, <-2.9431, 0.1997, 0.4567>, <-2.9141, 0.0319, 0.5181>}
triangle { <-2.9431, 0.1997, 0.4567>, <-2.9141, 0.0319, 0.5181>, <-2.9507, 0.0290, 0.4684>}
triangle { <-2.9431, 0.1997, 0.4567>, <-3.0019, 0.2009, 0.4377>, <-2.9507, 0.0290, 0.4684>}
triangle { <-3.0019, 0.2009, 0.4377>, <-2.9507, 0.0290, 0.4684>, <-3.0095, 0.0312, 0.4494>}
triangle { <-3.0095, 0.0312, 0.4494>, <-3.0680, 0.0377, 0.4684>, <-3.0234, -0.1472, 0.4698>}
triangle { <-3.0680, 0.0377, 0.4684>, <-3.0234, -0.1472, 0.4698>, <-3.0814, -0.1373, 0.4886>}
triangle { <-3.0680, 0.0377, 0.4684>, <-3.1038, 0.0460, 0.5181>, <-3.0814, -0.1373, 0.4886>}
triangle { <-3.1038, 0.0460, 0.5181>, <-3.0814, -0.1373, 0.4886>, <-3.1166, -0.1249, 0.5379>}
triangle { <-3.1038, 0.0460, 0.5181>, <-3.1033, 0.0529, 0.5795>, <-3.1166, -0.1249, 0.5379>}
triangle { <-3.1033, 0.0529, 0.5795>, <-3.1166, -0.1249, 0.5379>, <-3.1154, -0.1147, 0.5989>}
triangle { <-3.1033, 0.0529, 0.5795>, <-3.0666, 0.0558, 0.6292>, <-3.1154, -0.1147, 0.5989>}
triangle { <-3.0666, 0.0558, 0.6292>, <-3.1154, -0.1147, 0.5989>, <-3.0784, -0.1105, 0.6482>}
triangle { <-3.0666, 0.0558, 0.6292>, <-3.0079, 0.0536, 0.6482>, <-3.0784, -0.1105, 0.6482>}
triangle { <-3.0079, 0.0536, 0.6482>, <-3.0784, -0.1105, 0.6482>, <-3.0196, -0.1140, 0.6670>}
triangle { <-3.0079, 0.0536, 0.6482>, <-2.9494, 0.0472, 0.6292>, <-3.0196, -0.1140, 0.6670>}
triangle { <-2.9494, 0.0472, 0.6292>, <-3.0196, -0.1140, 0.6670>, <-2.9616, -0.1238, 0.6482>}
triangle { <-2.9494, 0.0472, 0.6292>, <-2.9136, 0.0389, 0.5795>, <-2.9616, -0.1238, 0.6482>}
triangle { <-2.9136, 0.0389, 0.5795>, <-2.9616, -0.1238, 0.6482>, <-2.9264, -0.1362, 0.5989>}
triangle { <-2.9136, 0.0389, 0.5795>, <-2.9141, 0.0319, 0.5181>, <-2.9264, -0.1362, 0.5989>}
triangle { <-2.9141, 0.0319, 0.5181>, <-2.9264, -0.1362, 0.5989>, <-2.9276, -0.1465, 0.5379>}
triangle { <-2.9141, 0.0319, 0.5181>, <-2.9507, 0.0290, 0.4684>, <-2.9276, -0.1465, 0.5379>}
triangle { <-2.9507, 0.0290, 0.4684>, <-2.9276, -0.1465, 0.5379>, <-2.9646, -0.1507, 0.4886>}
triangle { <-2.9507, 0.0290, 0.4684>, <-3.0095, 0.0312, 0.4494>, <-2.9646, -0.1507, 0.4886>}
triangle { <-3.0095, 0.0312, 0.4494>, <-2.9646, -0.1507, 0.4886>, <-3.0234, -0.1472, 0.4698>}
triangle { <-3.0234, -0.1472, 0.4698>, <-3.0814, -0.1373, 0.4886>, <-3.0454, -0.3299, 0.5012>}
triangle { <-3.0814, -0.1373, 0.4886>, <-3.0454, -0.3299, 0.5012>, <-3.1027, -0.3159, 0.5198>}
triangle { <-3.0814, -0.1373, 0.4886>, <-3.1166, -0.1249, 0.5379>, <-3.1027, -0.3159, 0.5198>}
triangle { <-3.1166, -0.1249, 0.5379>, <-3.1027, -0.3159, 0.5198>, <-3.1366, -0.2985, 0.5684>}
triangle { <-3.1166, -0.1249, 0.5379>, <-3.1154, -0.1147, 0.5989>, <-3.1366, -0.2985, 0.5684>}
triangle { <-3.1154, -0.1147, 0.5989>, <-3.1366, -0.2985, 0.5684>, <-3.1343, -0.2843, 0.6285>}
triangle { <-3.1154, -0.1147, 0.5989>, <-3.0784, -0.1105, 0.6482>, <-3.1343, -0.2843, 0.6285>}
triangle { <-3.0784, -0.1105, 0.6482>, <-3.1343, -0.2843, 0.6285>, <-3.0965, -0.2787, 0.6771>}
triangle { <-3.0784, -0.1105, 0.6482>, <-3.0196, -0.1140, 0.6670>, <-3.0965, -0.2787, 0.6771>}
triangle { <-3.0196, -0.1140, 0.6670>, <-3.0965, -0.2787, 0.6771>, <-3.0378, -0.2838, 0.6957>}
triangle { <-3.0196, -0.1140, 0.6670>, <-2.9616, -0.1238, 0.6482>, <-3.0378, -0.2838, 0.6957>}
triangle { <-2.9616, -0.1238, 0.6482>, <-3.0378, -0.2838, 0.6957>, <-2.9805, -0.2978, 0.6771>}
triangle { <-2.9616, -0.1238, 0.6482>, <-2.9264, -0.1362, 0.5989>, <-2.9805, -0.2978, 0.6771>}
triangle { <-2.9264, -0.1362, 0.5989>, <-2.9805, -0.2978, 0.6771>, <-2.9466, -0.3152, 0.6285>}
triangle { <-2.9264, -0.1362, 0.5989>, <-2.9276, -0.1465, 0.5379>, <-2.9466, -0.3152, 0.6285>}
triangle { <-2.9276, -0.1465, 0.5379>, <-2.9466, -0.3152, 0.6285>, <-2.9489, -0.3294, 0.5684>}
triangle { <-2.9276, -0.1465, 0.5379>, <-2.9646, -0.1507, 0.4886>, <-2.9489, -0.3294, 0.5684>}
triangle { <-2.9646, -0.1507, 0.4886>, <-2.9489, -0.3294, 0.5684>, <-2.9867, -0.3350, 0.5198>}
triangle { <-2.9646, -0.1507, 0.4886>, <-3.0234, -0.1472, 0.4698>, <-2.9867, -0.3350, 0.5198>}
triangle { <-3.0234, -0.1472, 0.4698>, <-2.9867, -0.3350, 0.5198>, <-3.0454, -0.3299, 0.5012>}
triangle { <-3.0454, -0.3299, 0.5012>, <-3.1027, -0.3159, 0.5198>, <-3.0775, -0.5123, 0.5460>}
triangle { <-3.1027, -0.3159, 0.5198>, <-3.0775, -0.5123, 0.5460>, <-3.1334, -0.4932, 0.5641>}
triangle { <-3.1027, -0.3159, 0.5198>, <-3.1366, -0.2985, 0.5684>, <-3.1334, -0.4932, 0.5641>}
triangle { <-3.1366, -0.2985, 0.5684>, <-3.1334, -0.4932, 0.5641>, <-3.1653, -0.4698, 0.6116>}
triangle { <-3.1366, -0.2985, 0.5684>, <-3.1343, -0.2843, 0.6285>, <-3.1653, -0.4698, 0.6116>}
triangle { <-3.1343, -0.2843, 0.6285>, <-3.1653, -0.4698, 0.6116>, <-3.1609, -0.4510, 0.6703>}
triangle { <-3.1343, -0.2843, 0.6285>, <-3.0965, -0.2787, 0.6771>, <-3.1609, -0.4510, 0.6703>}
triangle { <-3.0965, -0.2787, 0.6771>, <-3.1609, -0.4510, 0.6703>, <-3.1220, -0.4439, 0.7178>}
triangle { <-3.0965, -0.2787, 0.6771>, <-3.0378, -0.2838, 0.6957>, <-3.1220, -0.4439, 0.7178>}
triangle { <-3.0378, -0.2838, 0.6957>, <-3.1220, -0.4439, 0.7178>, <-3.0634, -0.4514, 0.7360>}
triangle { <-3.0378, -0.2838, 0.6957>, <-2.9805, -0.2978, 0.6771>, <-3.0634, -0.4514, 0.7360>}
triangle { <-2.9805, -0.2978, 0.6771>, <-3.0634, -0.4514, 0.7360>, <-3.0075, -0.4704, 0.7178>}
triangle { <-2.9805, -0.2978, 0.6771>, <-2.9466, -0.3152, 0.6285>, <-3.0075, -0.4704, 0.7178>}
triangle { <-2.9466, -0.3152, 0.6285>, <-3.0075, -0.4704, 0.7178>, <-2.9756, -0.4939, 0.6703>}
triangle { <-2.9466, -0.3152, 0.6285>, <-2.9489, -0.3294, 0.5684>, <-2.9756, -0.4939, 0.6703>}
triangle { <-2.9489, -0.3294, 0.5684>, <-2.9756, -0.4939, 0.6703>, <-2.9800, -0.5127, 0.6116>}
triangle { <-2.9489, -0.3294, 0.5684>, <-2.9867, -0.3350, 0.5198>, <-2.9800, -0.5127, 0.6116>}
triangle { <-2.9867, -0.3350, 0.5198>, <-2.9800, -0.5127, 0.6116>, <-3.0189, -0.5197, 0.5641>}
triangle { <-2.9867, -0.3350, 0.5198>, <-3.0454, -0.3299, 0.5012>, <-3.0189, -0.5197, 0.5641>}
triangle { <-3.0454, -0.3299, 0.5012>, <-3.0189, -0.5197, 0.5641>, <-3.0775, -0.5123, 0.5460>}
triangle { <-3.0775, -0.5123, 0.5460>, <-3.1334, -0.4932, 0.5641>, <-3.1217, -0.6892, 0.6065>}
triangle { <-3.1334, -0.4932, 0.5641>, <-3.1217, -0.6892, 0.6065>, <-3.1754, -0.6642, 0.6240>}
triangle { <-3.1334, -0.4932, 0.5641>, <-3.1653, -0.4698, 0.6116>, <-3.1754, -0.6642, 0.6240>}
triangle { <-3.1653, -0.4698, 0.6116>, <-3.1754, -0.6642, 0.6240>, <-3.2040, -0.6342, 0.6698>}
triangle { <-3.1653, -0.4698, 0.6116>, <-3.1609, -0.4510, 0.6703>, <-3.2040, -0.6342, 0.6698>}
triangle { <-3.1609, -0.4510, 0.6703>, <-3.2040, -0.6342, 0.6698>, <-3.1966, -0.6106, 0.7265>}
triangle { <-3.1609, -0.4510, 0.6703>, <-3.1220, -0.4439, 0.7178>, <-3.1966, -0.6106, 0.7265>}
triangle { <-3.1220, -0.4439, 0.7178>, <-3.1966, -0.6106, 0.7265>, <-3.1559, -0.6025, 0.7723>}
triangle { <-3.1220, -0.4439, 0.7178>, <-3.0634, -0.4514, 0.7360>, <-3.1559, -0.6025, 0.7723>}
triangle { <-3.0634, -0.4514, 0.7360>, <-3.1559, -0.6025, 0.7723>, <-3.0976, -0.6129, 0.7898>}
triangle { <-3.0634, -0.4514, 0.7360>, <-3.0075, -0.4704, 0.7178>, <-3.0976, -0.6129, 0.7898>}
triangle { <-3.0075, -0.4704, 0.7178>, <-3.0976, -0.6129, 0.7898>, <-3.0438, -0.6379, 0.7723>}
triangle { <-3.0075, -0.4704, 0.7178>, <-2.9756, -0.4939, 0.6703>, <-3.0438, -0.6379, 0.7723>}
triangle { <-2.9756, -0.4939, 0.6703>, <-3.0438, -0.6379, 0.7723>, <-3.0152, -0.6680, 0.7265>}
triangle { <-2.9756, -0.4939, 0.6703>, <-2.9800, -0.5127, 0.6116>, <-3.0152, -0.6680, 0.7265>}
triangle { <-2.9800, -0.5127, 0.6116>, <-3.0152, -0.6680, 0.7265>, <-3.0227, -0.6915, 0.6698>}
triangle { <-2.9800, -0.5127, 0.6116>, <-3.0189, -0.5197, 0.5641>, <-3.0227, -0.6915, 0.6698>}
triangle { <-3.0189, -0.5197, 0.5641>, <-3.0227, -0.6915, 0.6698>, <-3.0633, -0.6997, 0.6240>}
triangle { <-3.0189, -0.5197, 0.5641>, <-3.0775, -0.5123, 0.5460>, <-3.0633, -0.6997, 0.6240>}
triangle { <-3.0775, -0.5123, 0.5460>, <-3.0633, -0.6997, 0.6240>, <-3.1217, -0.6892, 0.6065>}
triangle { <-3.1217, -0.6892, 0.6065>, <-3.1754, -0.6642, 0.6240>, <-3.1781, -0.8546, 0.6833>}
triangle { <-3.1754, -0.6642, 0.6240>, <-3.1781, -0.8546, 0.6833>, <-3.2290, -0.8239, 0.7001>}
triangle { <-3.1754, -0.6642, 0.6240>, <-3.2040, -0.6342, 0.6698>, <-3.2290, -0.8239, 0.7001>}
triangle { <-3.2040, -0.6342, 0.6698>, <-3.2290, -0.8239, 0.7001>, <-3.2536, -0.7880, 0.7440>}
triangle { <-3.2040, -0.6342, 0.6698>, <-3.1966, -0.6106, 0.7265>, <-3.2536, -0.7880, 0.7440>}
triangle { <-3.1966, -0.6106, 0.7265>, <-3.2536, -0.7880, 0.7440>, <-3.2424, -0.7607, 0.7983>}
triangle { <-3.1966, -0.6106, 0.7265>, <-3.1559, -0.6025, 0.7723>, <-3.2424, -0.7607, 0.7983>}
triangle { <-3.1559, -0.6025, 0.7723>, <-3.2424, -0.7607, 0.7983>, <-3.1998, -0.7525, 0.8423>}
triangle { <-3.1559, -0.6025, 0.7723>, <-3.0976, -0.6129, 0.7898>, <-3.1998, -0.7525, 0.8423>}
triangle { <-3.0976, -0.6129, 0.7898>, <-3.1998, -0.7525, 0.8423>, <-3.1419, -0.7663, 0.8591>}
triangle { <-3.0976, -0.6129, 0.7898>, <-3.0438, -0.6379, 0.7723>, <-3.1419, -0.7663, 0.8591>}
triangle { <-3.0438, -0.6379, 0.7723>, <-3.1419, -0.7663, 0.8591>, <-3.0910, -0.7970, 0.8423>}
triangle { <-3.0438, -0.6379, 0.7723>, <-3.0152, -0.6680, 0.7265>, <-3.0910, -0.7970, 0.8423>}
triangle { <-3.0152, -0.6680, 0.7265>, <-3.0910, -0.7970, 0.8423>, <-3.0664, -0.8329, 0.7983>}
triangle { <-3.0152, -0.6680, 0.7265>, <-3.0227, -0.6915, 0.6698>, <-3.0664, -0.8329, 0.7983>}
triangle { <-3.0227, -0.6915, 0.6698>, <-3.0664, -0.8329, 0.7983>, <-3.0776, -0.8602, 0.7440>}
triangle { <-3.0227, -0.6915, 0.6698>, <-3.0633, -0.6997, 0.6240>, <-3.0776, -0.8602, 0.7440>}
triangle { <-3.0633, -0.6997, 0.6240>, <-3.0776, -0.8602, 0.7440>, <-3.1203, -0.8685, 0.7001>}
triangle { <-3.0633, -0.6997, 0.6240>, <-3.1217, -0.6892, 0.6065>, <-3.1203, -0.8685, 0.7001>}
triangle { <-3.1217, -0.6892, 0.6065>, <-3.1203, -0.8685, 0.7001>, <-3.1781, -0.8546, 0.6833>}
triangle { <-3.1781, -0.8546, 0.6833>, <-3.2290, -0.8239, 0.7001>, <-3.2450, -1.0056, 0.7733>}
triangle { <-3.2290, -0.8239, 0.7001>, <-3.2450, -1.0056, 0.7733>, <-3.2925, -0.9695, 0.7893>}
triangle { <-3.2290, -0.8239, 0.7001>, <-3.2536, -0.7880, 0.7440>, <-3.2925, -0.9695, 0.7893>}
triangle { <-3.2536, -0.7880, 0.7440>, <-3.2925, -0.9695, 0.7893>, <-3.3125, -0.9288, 0.8314>}
triangle { <-3.2536, -0.7880, 0.7440>, <-3.2424, -0.7607, 0.7983>, <-3.3125, -0.9288, 0.8314>}
triangle { <-3.2424, -0.7607, 0.7983>, <-3.3125, -0.9288, 0.8314>, <-3.2972, -0.8991, 0.8834>}
triangle { <-3.2424, -0.7607, 0.7983>, <-3.1998, -0.7525, 0.8423>, <-3.2972, -0.8991, 0.8834>}
triangle { <-3.1998, -0.7525, 0.8423>, <-3.2972, -0.8991, 0.8834>, <-3.2525, -0.8916, 0.9254>}
triangle { <-3.1998, -0.7525, 0.8423>, <-3.1419, -0.7663, 0.8591>, <-3.2525, -0.8916, 0.9254>}
triangle { <-3.1419, -0.7663, 0.8591>, <-3.2525, -0.8916, 0.9254>, <-3.1955, -0.9093, 0.9415>}
triangle { <-3.1419, -0.7663, 0.8591>, <-3.0910, -0.7970, 0.8423>, <-3.1955, -0.9093, 0.9415>}
triangle { <-3.0910, -0.7970, 0.8423>, <-3.1955, -0.9093, 0.9415>, <-3.1480, -0.9454, 0.9254>}
triangle { <-3.0910, -0.7970, 0.8423>, <-3.0664, -0.8329, 0.7983>, <-3.1480, -0.9454, 0.9254>}
triangle { <-3.0664, -0.8329, 0.7983>, <-3.1480, -0.9454, 0.9254>, <-3.1280, -0.9861, 0.8834>}
triangle { <-3.0664, -0.8329, 0.7983>, <-3.0776, -0.8602, 0.7440>, <-3.1280, -0.9861, 0.8834>}
triangle { <-3.0776, -0.8602, 0.7440>, <-3.1280, -0.9861, 0.8834>, <-3.1433, -1.0158, 0.8314>}
triangle { <-3.0776, -0.8602, 0.7440>, <-3.1203, -0.8685, 0.7001>, <-3.1433, -1.0158, 0.8314>}
triangle { <-3.1203, -0.8685, 0.7001>, <-3.1433, -1.0158, 0.8314>, <-3.1880, -1.0233, 0.7893>}
triangle { <-3.1203, -0.8685, 0.7001>, <-3.1781, -0.8546, 0.6833>, <-3.1880, -1.0233, 0.7893>}
triangle { <-3.1781, -0.8546, 0.6833>, <-3.1880, -1.0233, 0.7893>, <-3.2450, -1.0056, 0.7733>}
triangle { <-3.2450, -1.0056, 0.7733>, <-3.2925, -0.9695, 0.7893>, <-3.3205, -1.1401, 0.8729>}
triangle { <-3.2925, -0.9695, 0.7893>, <-3.3205, -1.1401, 0.8729>, <-3.3638, -1.0988, 0.8882>}
triangle { <-3.2925, -0.9695, 0.7893>, <-3.3125, -0.9288, 0.8314>, <-3.3638, -1.0988, 0.8882>}
triangle { <-3.3125, -0.9288, 0.8314>, <-3.3638, -1.0988, 0.8882>, <-3.3784, -1.0542, 0.9284>}
triangle { <-3.3125, -0.9288, 0.8314>, <-3.2972, -0.8991, 0.8834>, <-3.3784, -1.0542, 0.9284>}
triangle { <-3.2972, -0.8991, 0.8834>, <-3.3784, -1.0542, 0.9284>, <-3.3586, -1.0232, 0.9781>}
triangle { <-3.2972, -0.8991, 0.8834>, <-3.2525, -0.8916, 0.9254>, <-3.3586, -1.0232, 0.9781>}
triangle { <-3.2525, -0.8916, 0.9254>, <-3.3586, -1.0232, 0.9781>, <-3.3119, -1.0176, 1.0182>}
triangle { <-3.2525, -0.8916, 0.9254>, <-3.1955, -0.9093, 0.9415>, <-3.3119, -1.0176, 1.0182>}
triangle { <-3.1955, -0.9093, 0.9415>, <-3.3119, -1.0176, 1.0182>, <-3.2563, -1.0397, 1.0336>}
triangle { <-3.1955, -0.9093, 0.9415>, <-3.1480, -0.9454, 0.9254>, <-3.2563, -1.0397, 1.0336>}
triangle { <-3.1480, -0.9454, 0.9254>, <-3.2563, -1.0397, 1.0336>, <-3.2129, -1.0810, 1.0182>}
triangle { <-3.1480, -0.9454, 0.9254>, <-3.1280, -0.9861, 0.8834>, <-3.2129, -1.0810, 1.0182>}
triangle { <-3.1280, -0.9861, 0.8834>, <-3.2129, -1.0810, 1.0182>, <-3.1983, -1.1256, 0.9781>}
triangle { <-3.1280, -0.9861, 0.8834>, <-3.1433, -1.0158, 0.8314>, <-3.1983, -1.1256, 0.9781>}
triangle { <-3.1433, -1.0158, 0.8314>, <-3.1983, -1.1256, 0.9781>, <-3.2182, -1.1566, 0.9284>}
triangle { <-3.1433, -1.0158, 0.8314>, <-3.1880, -1.0233, 0.7893>, <-3.2182, -1.1566, 0.9284>}
triangle { <-3.1880, -1.0233, 0.7893>, <-3.2182, -1.1566, 0.9284>, <-3.2648, -1.1622, 0.8882>}
triangle { <-3.1880, -1.0233, 0.7893>, <-3.2450, -1.0056, 0.7733>, <-3.2648, -1.1622, 0.8882>}
triangle { <-3.2450, -1.0056, 0.7733>, <-3.2648, -1.1622, 0.8882>, <-3.3205, -1.1401, 0.8729>}
triangle { <-3.3205, -1.1401, 0.8729>, <-3.3638, -1.0988, 0.8882>, <-3.4027, -1.2558, 0.9785>}
triangle { <-3.3638, -1.0988, 0.8882>, <-3.4027, -1.2558, 0.9785>, <-3.4408, -1.2094, 0.9932>}
triangle { <-3.3638, -1.0988, 0.8882>, <-3.3784, -1.0542, 0.9284>, <-3.4408, -1.2094, 0.9932>}
triangle { <-3.3784, -1.0542, 0.9284>, <-3.4408, -1.2094, 0.9932>, <-3.4490, -1.1616, 1.0315>}
triangle { <-3.3784, -1.0542, 0.9284>, <-3.3586, -1.0232, 0.9781>, <-3.4490, -1.1616, 1.0315>}
triangle { <-3.3586, -1.0232, 0.9781>, <-3.4490, -1.1616, 1.0315>, <-3.4241, -1.1307, 1.0788>}
triangle { <-3.3586, -1.0232, 0.9781>, <-3.3119, -1.0176, 1.0182>, <-3.4241, -1.1307, 1.0788>}
triangle { <-3.3119, -1.0176, 1.0182>, <-3.4241, -1.1307, 1.0788>, <-3.3757, -1.1284, 1.1171>}
triangle { <-3.3119, -1.0176, 1.0182>, <-3.2563, -1.0397, 1.0336>, <-3.3757, -1.1284, 1.1171>}
triangle { <-3.2563, -1.0397, 1.0336>, <-3.3757, -1.1284, 1.1171>, <-3.3222, -1.1557, 1.1318>}
triangle { <-3.2563, -1.0397, 1.0336>, <-3.2129, -1.0810, 1.0182>, <-3.3222, -1.1557, 1.1318>}
triangle { <-3.2129, -1.0810, 1.0182>, <-3.3222, -1.1557, 1.1318>, <-3.2840, -1.2020, 1.1171>}
triangle { <-3.2129, -1.0810, 1.0182>, <-3.1983, -1.1256, 0.9781>, <-3.2840, -1.2020, 1.1171>}
triangle { <-3.1983, -1.1256, 0.9781>, <-3.2840, -1.2020, 1.1171>, <-3.2759, -1.2498, 1.0788>}
triangle { <-3.1983, -1.1256, 0.9781>, <-3.2182, -1.1566, 0.9284>, <-3.2759, -1.2498, 1.0788>}
triangle { <-3.2182, -1.1566, 0.9284>, <-3.2759, -1.2498, 1.0788>, <-3.3007, -1.2808, 1.0315>}
triangle { <-3.2182, -1.1566, 0.9284>, <-3.2648, -1.1622, 0.8882>, <-3.3007, -1.2808, 1.0315>}
triangle { <-3.2648, -1.1622, 0.8882>, <-3.3007, -1.2808, 1.0315>, <-3.3492, -1.2831, 0.9932>}
triangle { <-3.2648, -1.1622, 0.8882>, <-3.3205, -1.1401, 0.8729>, <-3.3492, -1.2831, 0.9932>}
triangle { <-3.3205, -1.1401, 0.8729>, <-3.3492, -1.2831, 0.9932>, <-3.4027, -1.2558, 0.9785>}
triangle { <-3.4027, -1.2558, 0.9785>, <-3.4408, -1.2094, 0.9932>, <-3.4899, -1.3499, 1.0866>}
triangle { <-3.4408, -1.2094, 0.9932>, <-3.4899, -1.3499, 1.0866>, <-3.5210, -1.2983, 1.1005>}
triangle { <-3.4408, -1.2094, 0.9932>, <-3.4490, -1.1616, 1.0315>, <-3.5210, -1.2983, 1.1005>}
triangle { <-3.4490, -1.1616, 1.0315>, <-3.5210, -1.2983, 1.1005>, <-3.5213, -1.2484, 1.1370>}
triangle { <-3.4490, -1.1616, 1.0315>, <-3.4241, -1.1307, 1.0788>, <-3.5213, -1.2484, 1.1370>}
triangle { <-3.4241, -1.1307, 1.0788>, <-3.5213, -1.2484, 1.1370>, <-3.4907, -1.2193, 1.1822>}
triangle { <-3.4241, -1.1307, 1.0788>, <-3.3757, -1.1284, 1.1171>, <-3.4907, -1.2193, 1.1822>}
triangle { <-3.3757, -1.1284, 1.1171>, <-3.4907, -1.2193, 1.1822>, <-3.4409, -1.2221, 1.2187>}
triangle { <-3.3757, -1.1284, 1.1171>, <-3.3222, -1.1557, 1.1318>, <-3.4409, -1.2221, 1.2187>}
triangle { <-3.3222, -1.1557, 1.1318>, <-3.4409, -1.2221, 1.2187>, <-3.3909, -1.2557, 1.2326>}
triangle { <-3.3222, -1.1557, 1.1318>, <-3.2840, -1.2020, 1.1171>, <-3.3909, -1.2557, 1.2326>}
triangle { <-3.2840, -1.2020, 1.1171>, <-3.3909, -1.2557, 1.2326>, <-3.3599, -1.3073, 1.2187>}
triangle { <-3.2840, -1.2020, 1.1171>, <-3.2759, -1.2498, 1.0788>, <-3.3599, -1.3073, 1.2187>}
triangle { <-3.2759, -1.2498, 1.0788>, <-3.3599, -1.3073, 1.2187>, <-3.3596, -1.3571, 1.1822>}
triangle { <-3.2759, -1.2498, 1.0788>, <-3.3007, -1.2808, 1.0315>, <-3.3596, -1.3571, 1.1822>}
triangle { <-3.3007, -1.2808, 1.0315>, <-3.3596, -1.3571, 1.1822>, <-3.3902, -1.3862, 1.1370>}
triangle { <-3.3007, -1.2808, 1.0315>, <-3.3492, -1.2831, 0.9932>, <-3.3902, -1.3862, 1.1370>}
triangle { <-3.3492, -1.2831, 0.9932>, <-3.3902, -1.3862, 1.1370>, <-3.4400, -1.3835, 1.1005>}
triangle { <-3.3492, -1.2831, 0.9932>, <-3.4027, -1.2558, 0.9785>, <-3.4400, -1.3835, 1.1005>}
triangle { <-3.4027, -1.2558, 0.9785>, <-3.4400, -1.3835, 1.1005>, <-3.4899, -1.3499, 1.0866>}
triangle { <-3.4899, -1.3499, 1.0866>, <-3.5210, -1.2983, 1.1005>, <-3.5802, -1.4185, 1.1932>}
triangle { <-3.5210, -1.2983, 1.1005>, <-3.5802, -1.4185, 1.1932>, <-3.6013, -1.3620, 1.2065>}
triangle { <-3.5210, -1.2983, 1.1005>, <-3.5213, -1.2484, 1.1370>, <-3.6013, -1.3620, 1.2065>}
triangle { <-3.5213, -1.2484, 1.1370>, <-3.6013, -1.3620, 1.2065>, <-3.5915, -1.3119, 1.2414>}
triangle { <-3.5213, -1.2484, 1.1370>, <-3.4907, -1.2193, 1.1822>, <-3.5915, -1.3119, 1.2414>}
triangle { <-3.4907, -1.2193, 1.1822>, <-3.5915, -1.3119, 1.2414>, <-3.5546, -1.2874, 1.2845>}
triangle { <-3.4907, -1.2193, 1.1822>, <-3.4409, -1.2221, 1.2187>, <-3.5546, -1.2874, 1.2845>}
triangle { <-3.4409, -1.2221, 1.2187>, <-3.5546, -1.2874, 1.2845>, <-3.5047, -1.2979, 1.3194>}
triangle { <-3.4409, -1.2221, 1.2187>, <-3.3909, -1.2557, 1.2326>, <-3.5047, -1.2979, 1.3194>}
triangle { <-3.3909, -1.2557, 1.2326>, <-3.5047, -1.2979, 1.3194>, <-3.4608, -1.3393, 1.3327>}
triangle { <-3.3909, -1.2557, 1.2326>, <-3.3599, -1.3073, 1.2187>, <-3.4608, -1.3393, 1.3327>}
triangle { <-3.3599, -1.3073, 1.2187>, <-3.4608, -1.3393, 1.3327>, <-3.4397, -1.3959, 1.3194>}
triangle { <-3.3599, -1.3073, 1.2187>, <-3.3596, -1.3571, 1.1822>, <-3.4397, -1.3959, 1.3194>}
triangle { <-3.3596, -1.3571, 1.1822>, <-3.4397, -1.3959, 1.3194>, <-3.4495, -1.4459, 1.2845>}
triangle { <-3.3596, -1.3571, 1.1822>, <-3.3902, -1.3862, 1.1370>, <-3.4495, -1.4459, 1.2845>}
triangle { <-3.3902, -1.3862, 1.1370>, <-3.4495, -1.4459, 1.2845>, <-3.4864, -1.4704, 1.2414>}
triangle { <-3.3902, -1.3862, 1.1370>, <-3.4400, -1.3835, 1.1005>, <-3.4864, -1.4704, 1.2414>}
triangle { <-3.4400, -1.3835, 1.1005>, <-3.4864, -1.4704, 1.2414>, <-3.5363, -1.4600, 1.2065>}
triangle { <-3.4400, -1.3835, 1.1005>, <-3.4899, -1.3499, 1.0866>, <-3.5363, -1.4600, 1.2065>}
triangle { <-3.4899, -1.3499, 1.0866>, <-3.5363, -1.4600, 1.2065>, <-3.5802, -1.4185, 1.1932>}
triangle { <-3.5802, -1.4185, 1.1932>, <-3.6013, -1.3620, 1.2065>, <-3.6700, -1.4569, 1.2941>}
triangle { <-3.6013, -1.3620, 1.2065>, <-3.6700, -1.4569, 1.2941>, <-3.6765, -1.3968, 1.3070>}
triangle { <-3.6013, -1.3620, 1.2065>, <-3.5915, -1.3119, 1.2414>, <-3.6765, -1.3968, 1.3070>}
triangle { <-3.5915, -1.3119, 1.2414>, <-3.6765, -1.3968, 1.3070>, <-3.6540, -1.3502, 1.3408>}
triangle { <-3.5915, -1.3119, 1.2414>, <-3.5546, -1.2874, 1.2845>, <-3.6540, -1.3502, 1.3408>}
triangle { <-3.5546, -1.2874, 1.2845>, <-3.6540, -1.3502, 1.3408>, <-3.6111, -1.3348, 1.3826>}
triangle { <-3.5546, -1.2874, 1.2845>, <-3.5047, -1.2979, 1.3194>, <-3.6111, -1.3348, 1.3826>}
triangle { <-3.5047, -1.2979, 1.3194>, <-3.6111, -1.3348, 1.3826>, <-3.5642, -1.3566, 1.4164>}
triangle { <-3.5047, -1.2979, 1.3194>, <-3.4608, -1.3393, 1.3327>, <-3.5642, -1.3566, 1.4164>}
triangle { <-3.4608, -1.3393, 1.3327>, <-3.5642, -1.3566, 1.4164>, <-3.5312, -1.4072, 1.4293>}
triangle { <-3.4608, -1.3393, 1.3327>, <-3.4397, -1.3959, 1.3194>, <-3.5312, -1.4072, 1.4293>}
triangle { <-3.4397, -1.3959, 1.3194>, <-3.5312, -1.4072, 1.4293>, <-3.5246, -1.4673, 1.4164>}
triangle { <-3.4397, -1.3959, 1.3194>, <-3.4495, -1.4459, 1.2845>, <-3.5246, -1.4673, 1.4164>}
triangle { <-3.4495, -1.4459, 1.2845>, <-3.5246, -1.4673, 1.4164>, <-3.5471, -1.5139, 1.3826>}
triangle { <-3.4495, -1.4459, 1.2845>, <-3.4864, -1.4704, 1.2414>, <-3.5471, -1.5139, 1.3826>}
triangle { <-3.4864, -1.4704, 1.2414>, <-3.5471, -1.5139, 1.3826>, <-3.5900, -1.5293, 1.3408>}
triangle { <-3.4864, -1.4704, 1.2414>, <-3.5363, -1.4600, 1.2065>, <-3.5900, -1.5293, 1.3408>}
triangle { <-3.5363, -1.4600, 1.2065>, <-3.5900, -1.5293, 1.3408>, <-3.6369, -1.5075, 1.3070>}
triangle { <-3.5363, -1.4600, 1.2065>, <-3.5802, -1.4185, 1.1932>, <-3.6369, -1.5075, 1.3070>}
triangle { <-3.5802, -1.4185, 1.1932>, <-3.6369, -1.5075, 1.3070>, <-3.6700, -1.4569, 1.2941>}
triangle { <-3.6700, -1.4569, 1.2941>, <-3.6765, -1.3968, 1.3070>, <-3.7516, -1.4614, 1.3838>}
triangle { <-3.6765, -1.3968, 1.3070>, <-3.7516, -1.4614, 1.3838>, <-3.7389, -1.4024, 1.3968>}
triangle { <-3.6765, -1.3968, 1.3070>, <-3.6540, -1.3502, 1.3408>, <-3.7389, -1.4024, 1.3968>}
triangle { <-3.6540, -1.3502, 1.3408>, <-3.7389, -1.4024, 1.3968>, <-3.7031, -1.3654, 1.4311>}
triangle { <-3.6540, -1.3502, 1.3408>, <-3.6111, -1.3348, 1.3826>, <-3.7031, -1.3654, 1.4311>}
triangle { <-3.6111, -1.3348, 1.3826>, <-3.7031, -1.3654, 1.4311>, <-3.6581, -1.3645, 1.4734>}
triangle { <-3.6111, -1.3348, 1.3826>, <-3.5642, -1.3566, 1.4164>, <-3.6581, -1.3645, 1.4734>}
triangle { <-3.5642, -1.3566, 1.4164>, <-3.6581, -1.3645, 1.4734>, <-3.6210, -1.4001, 1.5076>}
triangle { <-3.5642, -1.3566, 1.4164>, <-3.5312, -1.4072, 1.4293>, <-3.6210, -1.4001, 1.5076>}
triangle { <-3.5312, -1.4072, 1.4293>, <-3.6210, -1.4001, 1.5076>, <-3.6059, -1.4586, 1.5207>}
triangle { <-3.5312, -1.4072, 1.4293>, <-3.5246, -1.4673, 1.4164>, <-3.6059, -1.4586, 1.5207>}
triangle { <-3.5246, -1.4673, 1.4164>, <-3.6059, -1.4586, 1.5207>, <-3.6186, -1.5176, 1.5076>}
triangle { <-3.5246, -1.4673, 1.4164>, <-3.5471, -1.5139, 1.3826>, <-3.6186, -1.5176, 1.5076>}
triangle { <-3.5471, -1.5139, 1.3826>, <-3.6186, -1.5176, 1.5076>, <-3.6544, -1.5546, 1.4734>}
triangle { <-3.5471, -1.5139, 1.3826>, <-3.5900, -1.5293, 1.3408>, <-3.6544, -1.5546, 1.4734>}
triangle { <-3.5900, -1.5293, 1.3408>, <-3.6544, -1.5546, 1.4734>, <-3.6994, -1.5555, 1.4311>}
triangle { <-3.5900, -1.5293, 1.3408>, <-3.6369, -1.5075, 1.3070>, <-3.6994, -1.5555, 1.4311>}
triangle { <-3.6369, -1.5075, 1.3070>, <-3.6994, -1.5555, 1.4311>, <-3.7365, -1.5199, 1.3968>}
triangle { <-3.6369, -1.5075, 1.3070>, <-3.6700, -1.4569, 1.2941>, <-3.7365, -1.5199, 1.3968>}
triangle { <-3.6700, -1.4569, 1.2941>, <-3.7365, -1.5199, 1.3968>, <-3.7516, -1.4614, 1.3838>}
triangle { <-3.7516, -1.4614, 1.3838>, <-3.7389, -1.4024, 1.3968>, <-3.8173, -1.4404, 1.4577>}
triangle { <-3.7389, -1.4024, 1.3968>, <-3.8173, -1.4404, 1.4577>, <-3.7867, -1.3886, 1.4718>}
triangle { <-3.7389, -1.4024, 1.3968>, <-3.7031, -1.3654, 1.4311>, <-3.7867, -1.3886, 1.4718>}
triangle { <-3.7031, -1.3654, 1.4311>, <-3.7867, -1.3886, 1.4718>, <-3.7433, -1.3646, 1.5088>}
triangle { <-3.7031, -1.3654, 1.4311>, <-3.6581, -1.3645, 1.4734>, <-3.7433, -1.3646, 1.5088>}
triangle { <-3.6581, -1.3645, 1.4734>, <-3.7433, -1.3646, 1.5088>, <-3.7037, -1.3777, 1.5544>}
triangle { <-3.6581, -1.3645, 1.4734>, <-3.6210, -1.4001, 1.5076>, <-3.7037, -1.3777, 1.5544>}
triangle { <-3.6210, -1.4001, 1.5076>, <-3.7037, -1.3777, 1.5544>, <-3.6831, -1.4227, 1.5914>}
triangle { <-3.6210, -1.4001, 1.5076>, <-3.6059, -1.4586, 1.5207>, <-3.6831, -1.4227, 1.5914>}
triangle { <-3.6059, -1.4586, 1.5207>, <-3.6831, -1.4227, 1.5914>, <-3.6893, -1.4826, 1.6055>}
triangle { <-3.6059, -1.4586, 1.5207>, <-3.6186, -1.5176, 1.5076>, <-3.6893, -1.4826, 1.6055>}
triangle { <-3.6186, -1.5176, 1.5076>, <-3.6893, -1.4826, 1.6055>, <-3.7199, -1.5344, 1.5914>}
triangle { <-3.6186, -1.5176, 1.5076>, <-3.6544, -1.5546, 1.4734>, <-3.7199, -1.5344, 1.5914>}
triangle { <-3.6544, -1.5546, 1.4734>, <-3.7199, -1.5344, 1.5914>, <-3.7633, -1.5583, 1.5544>}
triangle { <-3.6544, -1.5546, 1.4734>, <-3.6994, -1.5555, 1.4311>, <-3.7633, -1.5583, 1.5544>}
triangle { <-3.6994, -1.5555, 1.4311>, <-3.7633, -1.5583, 1.5544>, <-3.8029, -1.5453, 1.5088>}
triangle { <-3.6994, -1.5555, 1.4311>, <-3.7365, -1.5199, 1.3968>, <-3.8029, -1.5453, 1.5088>}
triangle { <-3.7365, -1.5199, 1.3968>, <-3.8029, -1.5453, 1.5088>, <-3.8235, -1.5002, 1.4718>}
triangle { <-3.7365, -1.5199, 1.3968>, <-3.7516, -1.4614, 1.3838>, <-3.8235, -1.5002, 1.4718>}
triangle { <-3.7516, -1.4614, 1.3838>, <-3.8235, -1.5002, 1.4718>, <-3.8173, -1.4404, 1.4577>}
triangle { <-3.8173, -1.4404, 1.4577>, <-3.7867, -1.3886, 1.4718>, <-3.8706, -1.4058, 1.5170>}
triangle { <-3.7867, -1.3886, 1.4718>, <-3.8706, -1.4058, 1.5170>, <-3.8282, -1.3636, 1.5327>}
triangle { <-3.7867, -1.3886, 1.4718>, <-3.7433, -1.3646, 1.5088>, <-3.8282, -1.3636, 1.5327>}
triangle { <-3.7433, -1.3646, 1.5088>, <-3.8282, -1.3636, 1.5327>, <-3.7840, -1.3500, 1.5737>}
triangle { <-3.7433, -1.3646, 1.5088>, <-3.7037, -1.3777, 1.5544>, <-3.7840, -1.3500, 1.5737>}
triangle { <-3.7037, -1.3777, 1.5544>, <-3.7840, -1.3500, 1.5737>, <-3.7549, -1.3701, 1.6244>}
triangle { <-3.7037, -1.3777, 1.5544>, <-3.6831, -1.4227, 1.5914>, <-3.7549, -1.3701, 1.6244>}
triangle { <-3.6831, -1.4227, 1.5914>, <-3.7549, -1.3701, 1.6244>, <-3.7520, -1.4163, 1.6654>}
triangle { <-3.6831, -1.4227, 1.5914>, <-3.6893, -1.4826, 1.6055>, <-3.7520, -1.4163, 1.6654>}
triangle { <-3.6893, -1.4826, 1.6055>, <-3.7520, -1.4163, 1.6654>, <-3.7764, -1.4708, 1.6810>}
triangle { <-3.6893, -1.4826, 1.6055>, <-3.7199, -1.5344, 1.5914>, <-3.7764, -1.4708, 1.6810>}
triangle { <-3.7199, -1.5344, 1.5914>, <-3.7764, -1.4708, 1.6810>, <-3.8188, -1.5130, 1.6654>}
triangle { <-3.7199, -1.5344, 1.5914>, <-3.7633, -1.5583, 1.5544>, <-3.8188, -1.5130, 1.6654>}
triangle { <-3.7633, -1.5583, 1.5544>, <-3.8188, -1.5130, 1.6654>, <-3.8630, -1.5266, 1.6244>}
triangle { <-3.7633, -1.5583, 1.5544>, <-3.8029, -1.5453, 1.5088>, <-3.8630, -1.5266, 1.6244>}
triangle { <-3.8029, -1.5453, 1.5088>, <-3.8630, -1.5266, 1.6244>, <-3.8921, -1.5065, 1.5737>}
triangle { <-3.8029, -1.5453, 1.5088>, <-3.8235, -1.5002, 1.4718>, <-3.8921, -1.5065, 1.5737>}
triangle { <-3.8235, -1.5002, 1.4718>, <-3.8921, -1.5065, 1.5737>, <-3.8950, -1.4604, 1.5327>}
triangle { <-3.8235, -1.5002, 1.4718>, <-3.8173, -1.4404, 1.4577>, <-3.8950, -1.4604, 1.5327>}
triangle { <-3.8173, -1.4404, 1.4577>, <-3.8950, -1.4604, 1.5327>, <-3.8706, -1.4058, 1.5170>}
triangle { <-3.8706, -1.4058, 1.5170>, <-3.8282, -1.3636, 1.5327>, <-3.9188, -1.3610, 1.5646>}
triangle { <-3.8282, -1.3636, 1.5327>, <-3.9188, -1.3610, 1.5646>, <-3.8700, -1.3271, 1.5818>}
triangle { <-3.8282, -1.3636, 1.5327>, <-3.7840, -1.3500, 1.5737>, <-3.8700, -1.3271, 1.5818>}
triangle { <-3.7840, -1.3500, 1.5737>, <-3.8700, -1.3271, 1.5818>, <-3.8284, -1.3185, 1.6267>}
triangle { <-3.7840, -1.3500, 1.5737>, <-3.7549, -1.3701, 1.6244>, <-3.8284, -1.3185, 1.6267>}
triangle { <-3.7549, -1.3701, 1.6244>, <-3.8284, -1.3185, 1.6267>, <-3.8098, -1.3384, 1.6822>}
triangle { <-3.7549, -1.3701, 1.6244>, <-3.7520, -1.4163, 1.6654>, <-3.8098, -1.3384, 1.6822>}
triangle { <-3.7520, -1.4163, 1.6654>, <-3.8098, -1.3384, 1.6822>, <-3.8214, -1.3793, 1.7270>}
triangle { <-3.7520, -1.4163, 1.6654>, <-3.7764, -1.4708, 1.6810>, <-3.8214, -1.3793, 1.7270>}
triangle { <-3.7764, -1.4708, 1.6810>, <-3.8214, -1.3793, 1.7270>, <-3.8588, -1.4255, 1.7442>}
triangle { <-3.7764, -1.4708, 1.6810>, <-3.8188, -1.5130, 1.6654>, <-3.8588, -1.4255, 1.7442>}
triangle { <-3.8188, -1.5130, 1.6654>, <-3.8588, -1.4255, 1.7442>, <-3.9075, -1.4594, 1.7270>}
triangle { <-3.8188, -1.5130, 1.6654>, <-3.8630, -1.5266, 1.6244>, <-3.9075, -1.4594, 1.7270>}
triangle { <-3.8630, -1.5266, 1.6244>, <-3.9075, -1.4594, 1.7270>, <-3.9491, -1.4680, 1.6822>}
triangle { <-3.8630, -1.5266, 1.6244>, <-3.8921, -1.5065, 1.5737>, <-3.9491, -1.4680, 1.6822>}
triangle { <-3.8921, -1.5065, 1.5737>, <-3.9491, -1.4680, 1.6822>, <-3.9677, -1.4480, 1.6267>}
triangle { <-3.8921, -1.5065, 1.5737>, <-3.8950, -1.4604, 1.5327>, <-3.9677, -1.4480, 1.6267>}
triangle { <-3.8950, -1.4604, 1.5327>, <-3.9677, -1.4480, 1.6267>, <-3.9561, -1.4072, 1.5818>}
triangle { <-3.8950, -1.4604, 1.5327>, <-3.8706, -1.4058, 1.5170>, <-3.9561, -1.4072, 1.5818>}
triangle { <-3.8706, -1.4058, 1.5170>, <-3.9561, -1.4072, 1.5818>, <-3.9188, -1.3610, 1.5646>}
triangle { <-3.9188, -1.3610, 1.5646>, <-3.8700, -1.3271, 1.5818>, <-3.9653, -1.3038, 1.6022>}
triangle { <-3.8700, -1.3271, 1.5818>, <-3.9653, -1.3038, 1.6022>, <-3.9132, -1.2760, 1.6204>}
triangle { <-3.8700, -1.3271, 1.5818>, <-3.8284, -1.3185, 1.6267>, <-3.9132, -1.2760, 1.6204>}
triangle { <-3.8284, -1.3185, 1.6267>, <-3.9132, -1.2760, 1.6204>, <-3.8746, -1.2684, 1.6681>}
triangle { <-3.8284, -1.3185, 1.6267>, <-3.8098, -1.3384, 1.6822>, <-3.8746, -1.2684, 1.6681>}
triangle { <-3.8098, -1.3384, 1.6822>, <-3.8746, -1.2684, 1.6681>, <-3.8643, -1.2839, 1.7270>}
triangle { <-3.8098, -1.3384, 1.6822>, <-3.8214, -1.3793, 1.7270>, <-3.8643, -1.2839, 1.7270>}
triangle { <-3.8214, -1.3793, 1.7270>, <-3.8643, -1.2839, 1.7270>, <-3.8862, -1.3166, 1.7747>}
triangle { <-3.8214, -1.3793, 1.7270>, <-3.8588, -1.4255, 1.7442>, <-3.8862, -1.3166, 1.7747>}
triangle { <-3.8588, -1.4255, 1.7442>, <-3.8862, -1.3166, 1.7747>, <-3.9319, -1.3539, 1.7929>}
triangle { <-3.8588, -1.4255, 1.7442>, <-3.9075, -1.4594, 1.7270>, <-3.9319, -1.3539, 1.7929>}
triangle { <-3.9075, -1.4594, 1.7270>, <-3.9319, -1.3539, 1.7929>, <-3.9840, -1.3817, 1.7747>}
triangle { <-3.9075, -1.4594, 1.7270>, <-3.9491, -1.4680, 1.6822>, <-3.9840, -1.3817, 1.7747>}
triangle { <-3.9491, -1.4680, 1.6822>, <-3.9840, -1.3817, 1.7747>, <-4.0226, -1.3893, 1.7270>}
triangle { <-3.9491, -1.4680, 1.6822>, <-3.9677, -1.4480, 1.6267>, <-4.0226, -1.3893, 1.7270>}
triangle { <-3.9677, -1.4480, 1.6267>, <-4.0226, -1.3893, 1.7270>, <-4.0329, -1.3738, 1.6681>}
triangle { <-3.9677, -1.4480, 1.6267>, <-3.9561, -1.4072, 1.5818>, <-4.0329, -1.3738, 1.6681>}
triangle { <-3.9561, -1.4072, 1.5818>, <-4.0329, -1.3738, 1.6681>, <-4.0111, -1.3411, 1.6204>}
triangle { <-3.9561, -1.4072, 1.5818>, <-3.9188, -1.3610, 1.5646>, <-4.0111, -1.3411, 1.6204>}
triangle { <-3.9188, -1.3610, 1.5646>, <-4.0111, -1.3411, 1.6204>, <-3.9653, -1.3038, 1.6022>}
triangle { <-3.9653, -1.3038, 1.6022>, <-3.9132, -1.2760, 1.6204>, <-4.0101, -1.2327, 1.6298>}
triangle { <-3.9132, -1.2760, 1.6204>, <-4.0101, -1.2327, 1.6298>, <-3.9561, -1.2093, 1.6486>}
triangle { <-3.9132, -1.2760, 1.6204>, <-3.8746, -1.2684, 1.6681>, <-3.9561, -1.2093, 1.6486>}
triangle { <-3.8746, -1.2684, 1.6681>, <-3.9561, -1.2093, 1.6486>, <-3.9198, -1.2006, 1.6979>}
triangle { <-3.8746, -1.2684, 1.6681>, <-3.8643, -1.2839, 1.7270>, <-3.9198, -1.2006, 1.6979>}
triangle { <-3.8643, -1.2839, 1.7270>, <-3.9198, -1.2006, 1.6979>, <-3.9152, -1.2100, 1.7588>}
triangle { <-3.8643, -1.2839, 1.7270>, <-3.8862, -1.3166, 1.7747>, <-3.9152, -1.2100, 1.7588>}
triangle { <-3.8862, -1.3166, 1.7747>, <-3.9152, -1.2100, 1.7588>, <-3.9439, -1.2338, 1.8080>}
triangle { <-3.8862, -1.3166, 1.7747>, <-3.9319, -1.3539, 1.7929>, <-3.9439, -1.2338, 1.8080>}
triangle { <-3.9319, -1.3539, 1.7929>, <-3.9439, -1.2338, 1.8080>, <-3.9950, -1.2630, 1.8269>}
triangle { <-3.9319, -1.3539, 1.7929>, <-3.9840, -1.3817, 1.7747>, <-3.9950, -1.2630, 1.8269>}
triangle { <-3.9840, -1.3817, 1.7747>, <-3.9950, -1.2630, 1.8269>, <-4.0490, -1.2864, 1.8080>}
triangle { <-3.9840, -1.3817, 1.7747>, <-4.0226, -1.3893, 1.7270>, <-4.0490, -1.2864, 1.8080>}
triangle { <-4.0226, -1.3893, 1.7270>, <-4.0490, -1.2864, 1.8080>, <-4.0853, -1.2951, 1.7588>}
triangle { <-4.0226, -1.3893, 1.7270>, <-4.0329, -1.3738, 1.6681>, <-4.0853, -1.2951, 1.7588>}
triangle { <-4.0329, -1.3738, 1.6681>, <-4.0853, -1.2951, 1.7588>, <-4.0900, -1.2857, 1.6979>}
triangle { <-4.0329, -1.3738, 1.6681>, <-4.0111, -1.3411, 1.6204>, <-4.0900, -1.2857, 1.6979>}
triangle { <-4.0111, -1.3411, 1.6204>, <-4.0900, -1.2857, 1.6979>, <-4.0613, -1.2619, 1.6486>}
triangle { <-4.0111, -1.3411, 1.6204>, <-3.9653, -1.3038, 1.6022>, <-4.0613, -1.2619, 1.6486>}
triangle { <-3.9653, -1.3038, 1.6022>, <-4.0613, -1.2619, 1.6486>, <-4.0101, -1.2327, 1.6298>}
triangle { <-4.0101, -1.2327, 1.6298>, <-3.9561, -1.2093, 1.6486>, <-4.0518, -1.1484, 1.6467>}
triangle { <-3.9561, -1.2093, 1.6486>, <-4.0518, -1.1484, 1.6467>, <-3.9965, -1.1283, 1.6657>}
triangle { <-3.9561, -1.2093, 1.6486>, <-3.9198, -1.2006, 1.6979>, <-3.9965, -1.1283, 1.6657>}
triangle { <-3.9198, -1.2006, 1.6979>, <-3.9965, -1.1283, 1.6657>, <-3.9617, -1.1176, 1.7157>}
triangle { <-3.9198, -1.2006, 1.6979>, <-3.9152, -1.2100, 1.7588>, <-3.9617, -1.1176, 1.7157>}
triangle { <-3.9152, -1.2100, 1.7588>, <-3.9617, -1.1176, 1.7157>, <-3.9607, -1.1204, 1.7774>}
triangle { <-3.9152, -1.2100, 1.7588>, <-3.9439, -1.2338, 1.8080>, <-3.9607, -1.1204, 1.7774>}
triangle { <-3.9439, -1.2338, 1.8080>, <-3.9607, -1.1204, 1.7774>, <-3.9937, -1.1357, 1.8273>}
triangle { <-3.9439, -1.2338, 1.8080>, <-3.9950, -1.2630, 1.8269>, <-3.9937, -1.1357, 1.8273>}
triangle { <-3.9950, -1.2630, 1.8269>, <-3.9937, -1.1357, 1.8273>, <-4.0483, -1.1575, 1.8464>}
triangle { <-3.9950, -1.2630, 1.8269>, <-4.0490, -1.2864, 1.8080>, <-4.0483, -1.1575, 1.8464>}
triangle { <-4.0490, -1.2864, 1.8080>, <-4.0483, -1.1575, 1.8464>, <-4.1036, -1.1776, 1.8273>}
triangle { <-4.0490, -1.2864, 1.8080>, <-4.0853, -1.2951, 1.7588>, <-4.1036, -1.1776, 1.8273>}
triangle { <-4.0853, -1.2951, 1.7588>, <-4.1036, -1.1776, 1.8273>, <-4.1384, -1.1883, 1.7774>}
triangle { <-4.0853, -1.2951, 1.7588>, <-4.0900, -1.2857, 1.6979>, <-4.1384, -1.1883, 1.7774>}
triangle { <-4.0900, -1.2857, 1.6979>, <-4.1384, -1.1883, 1.7774>, <-4.1394, -1.1855, 1.7157>}
triangle { <-4.0900, -1.2857, 1.6979>, <-4.0613, -1.2619, 1.6486>, <-4.1394, -1.1855, 1.7157>}
triangle { <-4.0613, -1.2619, 1.6486>, <-4.1394, -1.1855, 1.7157>, <-4.1064, -1.1702, 1.6657>}
triangle { <-4.0613, -1.2619, 1.6486>, <-4.0101, -1.2327, 1.6298>, <-4.1064, -1.1702, 1.6657>}
triangle { <-4.0101, -1.2327, 1.6298>, <-4.1064, -1.1702, 1.6657>, <-4.0518, -1.1484, 1.6467>}
triangle { <-4.0518, -1.1484, 1.6467>, <-3.9965, -1.1283, 1.6657>, <-4.0889, -1.0526, 1.6523>}
triangle { <-3.9965, -1.1283, 1.6657>, <-4.0889, -1.0526, 1.6523>, <-4.0327, -1.0353, 1.6713>}
triangle { <-3.9965, -1.1283, 1.6657>, <-3.9617, -1.1176, 1.7157>, <-4.0327, -1.0353, 1.6713>}
triangle { <-3.9617, -1.1176, 1.7157>, <-4.0327, -1.0353, 1.6713>, <-3.9987, -1.0223, 1.7212>}
triangle { <-3.9617, -1.1176, 1.7157>, <-3.9607, -1.1204, 1.7774>, <-3.9987, -1.0223, 1.7212>}
triangle { <-3.9607, -1.1204, 1.7774>, <-3.9987, -1.0223, 1.7212>, <-3.9997, -1.0186, 1.7829>}
triangle { <-3.9607, -1.1204, 1.7774>, <-3.9937, -1.1357, 1.8273>, <-3.9997, -1.0186, 1.7829>}
triangle { <-3.9937, -1.1357, 1.8273>, <-3.9997, -1.0186, 1.7829>, <-4.0355, -1.0258, 1.8328>}
triangle { <-3.9937, -1.1357, 1.8273>, <-4.0483, -1.1575, 1.8464>, <-4.0355, -1.0258, 1.8328>}
triangle { <-4.0483, -1.1575, 1.8464>, <-4.0355, -1.0258, 1.8328>, <-4.0923, -1.0409, 1.8519>}
triangle { <-4.0483, -1.1575, 1.8464>, <-4.1036, -1.1776, 1.8273>, <-4.0923, -1.0409, 1.8519>}
triangle { <-4.1036, -1.1776, 1.8273>, <-4.0923, -1.0409, 1.8519>, <-4.1484, -1.0583, 1.8328>}
triangle { <-4.1036, -1.1776, 1.8273>, <-4.1384, -1.1883, 1.7774>, <-4.1484, -1.0583, 1.8328>}
triangle { <-4.1384, -1.1883, 1.7774>, <-4.1484, -1.0583, 1.8328>, <-4.1825, -1.0713, 1.7829>}
triangle { <-4.1384, -1.1883, 1.7774>, <-4.1394, -1.1855, 1.7157>, <-4.1825, -1.0713, 1.7829>}
triangle { <-4.1394, -1.1855, 1.7157>, <-4.1825, -1.0713, 1.7829>, <-4.1814, -1.0749, 1.7212>}
triangle { <-4.1394, -1.1855, 1.7157>, <-4.1064, -1.1702, 1.6657>, <-4.1814, -1.0749, 1.7212>}
triangle { <-4.1064, -1.1702, 1.6657>, <-4.1814, -1.0749, 1.7212>, <-4.1457, -1.0678, 1.6713>}
triangle { <-4.1064, -1.1702, 1.6657>, <-4.0518, -1.1484, 1.6467>, <-4.1457, -1.0678, 1.6713>}
triangle { <-4.0518, -1.1484, 1.6467>, <-4.1457, -1.0678, 1.6713>, <-4.0889, -1.0526, 1.6523>}
triangle { <-4.0889, -1.0526, 1.6523>, <-4.0327, -1.0353, 1.6713>, <-4.1204, -0.9475, 1.6460>}
triangle { <-4.0327, -1.0353, 1.6713>, <-4.1204, -0.9475, 1.6460>, <-4.0635, -0.9325, 1.6649>}
triangle { <-4.0327, -1.0353, 1.6713>, <-3.9987, -1.0223, 1.7212>, <-4.0635, -0.9325, 1.6649>}
triangle { <-3.9987, -1.0223, 1.7212>, <-4.0635, -0.9325, 1.6649>, <-4.0295, -0.9173, 1.7142>}
triangle { <-3.9987, -1.0223, 1.7212>, <-3.9997, -1.0186, 1.7829>, <-4.0295, -0.9173, 1.7142>}
triangle { <-3.9997, -1.0186, 1.7829>, <-4.0295, -0.9173, 1.7142>, <-4.0316, -0.9077, 1.7753>}
triangle { <-3.9997, -1.0186, 1.7829>, <-4.0355, -1.0258, 1.8328>, <-4.0316, -0.9077, 1.7753>}
triangle { <-4.0355, -1.0258, 1.8328>, <-4.0316, -0.9077, 1.7753>, <-4.0687, -0.9073, 1.8246>}
triangle { <-4.0355, -1.0258, 1.8328>, <-4.0923, -1.0409, 1.8519>, <-4.0687, -0.9073, 1.8246>}
triangle { <-4.0923, -1.0409, 1.8519>, <-4.0687, -0.9073, 1.8246>, <-4.1269, -0.9164, 1.8435>}
triangle { <-4.0923, -1.0409, 1.8519>, <-4.1484, -1.0583, 1.8328>, <-4.1269, -0.9164, 1.8435>}
triangle { <-4.1484, -1.0583, 1.8328>, <-4.1269, -0.9164, 1.8435>, <-4.1838, -0.9315, 1.8246>}
triangle { <-4.1484, -1.0583, 1.8328>, <-4.1825, -1.0713, 1.7829>, <-4.1838, -0.9315, 1.8246>}
triangle { <-4.1825, -1.0713, 1.7829>, <-4.1838, -0.9315, 1.8246>, <-4.2177, -0.9467, 1.7753>}
triangle { <-4.1825, -1.0713, 1.7829>, <-4.1814, -1.0749, 1.7212>, <-4.2177, -0.9467, 1.7753>}
triangle { <-4.1814, -1.0749, 1.7212>, <-4.2177, -0.9467, 1.7753>, <-4.2157, -0.9563, 1.7142>}
triangle { <-4.1814, -1.0749, 1.7212>, <-4.1457, -1.0678, 1.6713>, <-4.2157, -0.9563, 1.7142>}
triangle { <-4.1457, -1.0678, 1.6713>, <-4.2157, -0.9563, 1.7142>, <-4.1785, -0.9566, 1.6649>}
triangle { <-4.1457, -1.0678, 1.6713>, <-4.0889, -1.0526, 1.6523>, <-4.1785, -0.9566, 1.6649>}
triangle { <-4.0889, -1.0526, 1.6523>, <-4.1785, -0.9566, 1.6649>, <-4.1204, -0.9475, 1.6460>}
triangle { <-4.1204, -0.9475, 1.6460>, <-4.0635, -0.9325, 1.6649>, <-4.1455, -0.8346, 1.6277>}
triangle { <-4.0635, -0.9325, 1.6649>, <-4.1455, -0.8346, 1.6277>, <-4.0880, -0.8215, 1.6463>}
triangle { <-4.0635, -0.9325, 1.6649>, <-4.0295, -0.9173, 1.7142>, <-4.0880, -0.8215, 1.6463>}
triangle { <-4.0295, -0.9173, 1.7142>, <-4.0880, -0.8215, 1.6463>, <-4.0538, -0.8045, 1.6949>}
triangle { <-4.0295, -0.9173, 1.7142>, <-4.0316, -0.9077, 1.7753>, <-4.0538, -0.8045, 1.6949>}
triangle { <-4.0316, -0.9077, 1.7753>, <-4.0538, -0.8045, 1.6949>, <-4.0559, -0.7902, 1.7549>}
triangle { <-4.0316, -0.9077, 1.7753>, <-4.0687, -0.9073, 1.8246>, <-4.0559, -0.7902, 1.7549>}
triangle { <-4.0687, -0.9073, 1.8246>, <-4.0559, -0.7902, 1.7549>, <-4.0936, -0.7839, 1.8035>}
triangle { <-4.0687, -0.9073, 1.8246>, <-4.1269, -0.9164, 1.8435>, <-4.0936, -0.7839, 1.8035>}
triangle { <-4.1269, -0.9164, 1.8435>, <-4.0936, -0.7839, 1.8035>, <-4.1524, -0.7881, 1.8221>}
triangle { <-4.1269, -0.9164, 1.8435>, <-4.1838, -0.9315, 1.8246>, <-4.1524, -0.7881, 1.8221>}
triangle { <-4.1838, -0.9315, 1.8246>, <-4.1524, -0.7881, 1.8221>, <-4.2099, -0.8012, 1.8035>}
triangle { <-4.1838, -0.9315, 1.8246>, <-4.2177, -0.9467, 1.7753>, <-4.2099, -0.8012, 1.8035>}
triangle { <-4.2177, -0.9467, 1.7753>, <-4.2099, -0.8012, 1.8035>, <-4.2441, -0.8181, 1.7549>}
triangle { <-4.2177, -0.9467, 1.7753>, <-4.2157, -0.9563, 1.7142>, <-4.2441, -0.8181, 1.7549>}
triangle { <-4.2157, -0.9563, 1.7142>, <-4.2441, -0.8181, 1.7549>, <-4.2419, -0.8325, 1.6949>}
triangle { <-4.2157, -0.9563, 1.7142>, <-4.1785, -0.9566, 1.6649>, <-4.2419, -0.8325, 1.6949>}
triangle { <-4.1785, -0.9566, 1.6649>, <-4.2419, -0.8325, 1.6949>, <-4.2043, -0.8388, 1.6463>}
triangle { <-4.1785, -0.9566, 1.6649>, <-4.1204, -0.9475, 1.6460>, <-4.2043, -0.8388, 1.6463>}
triangle { <-4.1204, -0.9475, 1.6460>, <-4.2043, -0.8388, 1.6463>, <-4.1455, -0.8346, 1.6277>}
triangle { <-4.1455, -0.8346, 1.6277>, <-4.0880, -0.8215, 1.6463>, <-4.1644, -0.7167, 1.5990>}
triangle { <-4.0880, -0.8215, 1.6463>, <-4.1644, -0.7167, 1.5990>, <-4.1065, -0.7053, 1.6173>}
triangle { <-4.0880, -0.8215, 1.6463>, <-4.0538, -0.8045, 1.6949>, <-4.1065, -0.7053, 1.6173>}
triangle { <-4.0538, -0.8045, 1.6949>, <-4.1065, -0.7053, 1.6173>, <-4.0718, -0.6871, 1.6651>}
triangle { <-4.0538, -0.8045, 1.6949>, <-4.0559, -0.7902, 1.7549>, <-4.0718, -0.6871, 1.6651>}
triangle { <-4.0559, -0.7902, 1.7549>, <-4.0718, -0.6871, 1.6651>, <-4.0736, -0.6692, 1.7243>}
triangle { <-4.0559, -0.7902, 1.7549>, <-4.0936, -0.7839, 1.8035>, <-4.0736, -0.6692, 1.7243>}
triangle { <-4.0936, -0.7839, 1.8035>, <-4.0736, -0.6692, 1.7243>, <-4.1112, -0.6583, 1.7721>}
triangle { <-4.0936, -0.7839, 1.8035>, <-4.1524, -0.7881, 1.8221>, <-4.1112, -0.6583, 1.7721>}
triangle { <-4.1524, -0.7881, 1.8221>, <-4.1112, -0.6583, 1.7721>, <-4.1702, -0.6587, 1.7903>}
triangle { <-4.1524, -0.7881, 1.8221>, <-4.2099, -0.8012, 1.8035>, <-4.1702, -0.6587, 1.7903>}
triangle { <-4.2099, -0.8012, 1.8035>, <-4.1702, -0.6587, 1.7903>, <-4.2281, -0.6701, 1.7721>}
triangle { <-4.2099, -0.8012, 1.8035>, <-4.2441, -0.8181, 1.7549>, <-4.2281, -0.6701, 1.7721>}
triangle { <-4.2441, -0.8181, 1.7549>, <-4.2281, -0.6701, 1.7721>, <-4.2628, -0.6883, 1.7243>}
triangle { <-4.2441, -0.8181, 1.7549>, <-4.2419, -0.8325, 1.6949>, <-4.2628, -0.6883, 1.7243>}
triangle { <-4.2419, -0.8325, 1.6949>, <-4.2628, -0.6883, 1.7243>, <-4.2610, -0.7062, 1.6651>}
triangle { <-4.2419, -0.8325, 1.6949>, <-4.2043, -0.8388, 1.6463>, <-4.2610, -0.7062, 1.6651>}
triangle { <-4.2043, -0.8388, 1.6463>, <-4.2610, -0.7062, 1.6651>, <-4.2234, -0.7171, 1.6173>}
triangle { <-4.2043, -0.8388, 1.6463>, <-4.1455, -0.8346, 1.6277>, <-4.2234, -0.7171, 1.6173>}
triangle { <-4.1455, -0.8346, 1.6277>, <-4.2234, -0.7171, 1.6173>, <-4.1644, -0.7167, 1.5990>}
triangle { <-4.1644, -0.7167, 1.5990>, <-4.1065, -0.7053, 1.6173>, <-4.1777, -0.5975, 1.5626>}
triangle { <-4.1065, -0.7053, 1.6173>, <-4.1777, -0.5975, 1.5626>, <-4.1194, -0.5874, 1.5806>}
triangle { <-4.1065, -0.7053, 1.6173>, <-4.0718, -0.6871, 1.6651>, <-4.1194, -0.5874, 1.5806>}
triangle { <-4.0718, -0.6871, 1.6651>, <-4.1194, -0.5874, 1.5806>, <-4.0842, -0.5684, 1.6277>}
triangle { <-4.0718, -0.6871, 1.6651>, <-4.0736, -0.6692, 1.7243>, <-4.0842, -0.5684, 1.6277>}
triangle { <-4.0736, -0.6692, 1.7243>, <-4.0842, -0.5684, 1.6277>, <-4.0855, -0.5478, 1.6859>}
triangle { <-4.0736, -0.6692, 1.7243>, <-4.1112, -0.6583, 1.7721>, <-4.0855, -0.5478, 1.6859>}
triangle { <-4.1112, -0.6583, 1.7721>, <-4.0855, -0.5478, 1.6859>, <-4.1228, -0.5334, 1.7330>}
triangle { <-4.1112, -0.6583, 1.7721>, <-4.1702, -0.6587, 1.7903>, <-4.1228, -0.5334, 1.7330>}
triangle { <-4.1702, -0.6587, 1.7903>, <-4.1228, -0.5334, 1.7330>, <-4.1819, -0.5307, 1.7510>}
triangle { <-4.1702, -0.6587, 1.7903>, <-4.2281, -0.6701, 1.7721>, <-4.1819, -0.5307, 1.7510>}
triangle { <-4.2281, -0.6701, 1.7721>, <-4.1819, -0.5307, 1.7510>, <-4.2401, -0.5408, 1.7330>}
triangle { <-4.2281, -0.6701, 1.7721>, <-4.2628, -0.6883, 1.7243>, <-4.2401, -0.5408, 1.7330>}
triangle { <-4.2628, -0.6883, 1.7243>, <-4.2401, -0.5408, 1.7330>, <-4.2753, -0.5597, 1.6859>}
triangle { <-4.2628, -0.6883, 1.7243>, <-4.2610, -0.7062, 1.6651>, <-4.2753, -0.5597, 1.6859>}
triangle { <-4.2610, -0.7062, 1.6651>, <-4.2753, -0.5597, 1.6859>, <-4.2740, -0.5804, 1.6277>}
triangle { <-4.2610, -0.7062, 1.6651>, <-4.2234, -0.7171, 1.6173>, <-4.2740, -0.5804, 1.6277>}
triangle { <-4.2234, -0.7171, 1.6173>, <-4.2740, -0.5804, 1.6277>, <-4.2367, -0.5948, 1.5806>}
triangle { <-4.2234, -0.7171, 1.6173>, <-4.1644, -0.7167, 1.5990>, <-4.2367, -0.5948, 1.5806>}
triangle { <-4.1644, -0.7167, 1.5990>, <-4.2367, -0.5948, 1.5806>, <-4.1777, -0.5975, 1.5626>}
triangle { <-4.1777, -0.5975, 1.5626>, <-4.1194, -0.5874, 1.5806>, <-4.1861, -0.4801, 1.5208>}
triangle { <-4.1194, -0.5874, 1.5806>, <-4.1861, -0.4801, 1.5208>, <-4.1276, -0.4711, 1.5386>}
triangle { <-4.1194, -0.5874, 1.5806>, <-4.0842, -0.5684, 1.6277>, <-4.1276, -0.4711, 1.5386>}
triangle { <-4.0842, -0.5684, 1.6277>, <-4.1276, -0.4711, 1.5386>, <-4.0919, -0.4516, 1.5851>}
triangle { <-4.0842, -0.5684, 1.6277>, <-4.0855, -0.5478, 1.6859>, <-4.0919, -0.4516, 1.5851>}
triangle { <-4.0855, -0.5478, 1.6859>, <-4.0919, -0.4516, 1.5851>, <-4.0927, -0.4289, 1.6426>}
triangle { <-4.0855, -0.5478, 1.6859>, <-4.1228, -0.5334, 1.7330>, <-4.0927, -0.4289, 1.6426>}
triangle { <-4.1228, -0.5334, 1.7330>, <-4.0927, -0.4289, 1.6426>, <-4.1296, -0.4118, 1.6891>}
triangle { <-4.1228, -0.5334, 1.7330>, <-4.1819, -0.5307, 1.7510>, <-4.1296, -0.4118, 1.6891>}
triangle { <-4.1819, -0.5307, 1.7510>, <-4.1296, -0.4118, 1.6891>, <-4.1886, -0.4067, 1.7069>}
triangle { <-4.1819, -0.5307, 1.7510>, <-4.2401, -0.5408, 1.7330>, <-4.1886, -0.4067, 1.7069>}
triangle { <-4.2401, -0.5408, 1.7330>, <-4.1886, -0.4067, 1.7069>, <-4.2471, -0.4156, 1.6891>}
triangle { <-4.2401, -0.5408, 1.7330>, <-4.2753, -0.5597, 1.6859>, <-4.2471, -0.4156, 1.6891>}
triangle { <-4.2753, -0.5597, 1.6859>, <-4.2471, -0.4156, 1.6891>, <-4.2828, -0.4352, 1.6426>}
triangle { <-4.2753, -0.5597, 1.6859>, <-4.2740, -0.5804, 1.6277>, <-4.2828, -0.4352, 1.6426>}
triangle { <-4.2740, -0.5804, 1.6277>, <-4.2828, -0.4352, 1.6426>, <-4.2820, -0.4579, 1.5851>}
triangle { <-4.2740, -0.5804, 1.6277>, <-4.2367, -0.5948, 1.5806>, <-4.2820, -0.4579, 1.5851>}
triangle { <-4.2367, -0.5948, 1.5806>, <-4.2820, -0.4579, 1.5851>, <-4.2451, -0.4750, 1.5386>}
triangle { <-4.2367, -0.5948, 1.5806>, <-4.1777, -0.5975, 1.5626>, <-4.2451, -0.4750, 1.5386>}
triangle { <-4.1777, -0.5975, 1.5626>, <-4.2451, -0.4750, 1.5386>, <-4.1861, -0.4801, 1.5208>}
triangle { <-4.1861, -0.4801, 1.5208>, <-4.1276, -0.4711, 1.5386>, <-4.1908, -0.3678, 1.4765>}
triangle { <-4.1276, -0.4711, 1.5386>, <-4.1908, -0.3678, 1.4765>, <-4.1320, -0.3597, 1.4941>}
triangle { <-4.1276, -0.4711, 1.5386>, <-4.0919, -0.4516, 1.5851>, <-4.1320, -0.3597, 1.4941>}
triangle { <-4.0919, -0.4516, 1.5851>, <-4.1320, -0.3597, 1.4941>, <-4.0959, -0.3398, 1.5401>}
triangle { <-4.0919, -0.4516, 1.5851>, <-4.0927, -0.4289, 1.6426>, <-4.0959, -0.3398, 1.5401>}
triangle { <-4.0927, -0.4289, 1.6426>, <-4.0959, -0.3398, 1.5401>, <-4.0961, -0.3156, 1.5970>}
triangle { <-4.0927, -0.4289, 1.6426>, <-4.1296, -0.4118, 1.6891>, <-4.0961, -0.3156, 1.5970>}
triangle { <-4.1296, -0.4118, 1.6891>, <-4.0961, -0.3156, 1.5970>, <-4.1326, -0.2964, 1.6430>}
triangle { <-4.1296, -0.4118, 1.6891>, <-4.1886, -0.4067, 1.7069>, <-4.1326, -0.2964, 1.6430>}
triangle { <-4.1886, -0.4067, 1.7069>, <-4.1326, -0.2964, 1.6430>, <-4.1915, -0.2895, 1.6606>}
triangle { <-4.1886, -0.4067, 1.7069>, <-4.2471, -0.4156, 1.6891>, <-4.1915, -0.2895, 1.6606>}
triangle { <-4.2471, -0.4156, 1.6891>, <-4.1915, -0.2895, 1.6606>, <-4.2502, -0.2975, 1.6430>}
triangle { <-4.2471, -0.4156, 1.6891>, <-4.2828, -0.4352, 1.6426>, <-4.2502, -0.2975, 1.6430>}
triangle { <-4.2828, -0.4352, 1.6426>, <-4.2502, -0.2975, 1.6430>, <-4.2863, -0.3174, 1.5970>}
triangle { <-4.2828, -0.4352, 1.6426>, <-4.2820, -0.4579, 1.5851>, <-4.2863, -0.3174, 1.5970>}
triangle { <-4.2820, -0.4579, 1.5851>, <-4.2863, -0.3174, 1.5970>, <-4.2861, -0.3416, 1.5401>}
triangle { <-4.2820, -0.4579, 1.5851>, <-4.2451, -0.4750, 1.5386>, <-4.2861, -0.3416, 1.5401>}
triangle { <-4.2451, -0.4750, 1.5386>, <-4.2861, -0.3416, 1.5401>, <-4.2496, -0.3608, 1.4941>}
triangle { <-4.2451, -0.4750, 1.5386>, <-4.1861, -0.4801, 1.5208>, <-4.2496, -0.3608, 1.4941>}
triangle { <-4.1861, -0.4801, 1.5208>, <-4.2496, -0.3608, 1.4941>, <-4.1908, -0.3678, 1.4765>}
triangle { <-4.1908, -0.3678, 1.4765>, <-4.1320, -0.3597, 1.4941>, <-4.1924, -0.2636, 1.4322>}
triangle { <-4.1320, -0.3597, 1.4941>, <-4.1924, -0.2636, 1.4322>, <-4.1336, -0.2562, 1.4496>}
triangle { <-4.1320, -0.3597, 1.4941>, <-4.0959, -0.3398, 1.5401>, <-4.1336, -0.2562, 1.4496>}
triangle { <-4.0959, -0.3398, 1.5401>, <-4.1336, -0.2562, 1.4496>, <-4.0971, -0.2361, 1.4953>}
triangle { <-4.0959, -0.3398, 1.5401>, <-4.0961, -0.3156, 1.5970>, <-4.0971, -0.2361, 1.4953>}
triangle { <-4.0961, -0.3156, 1.5970>, <-4.0971, -0.2361, 1.4953>, <-4.0969, -0.2108, 1.5517>}
triangle { <-4.0961, -0.3156, 1.5970>, <-4.1326, -0.2964, 1.6430>, <-4.0969, -0.2108, 1.5517>}
triangle { <-4.1326, -0.2964, 1.6430>, <-4.0969, -0.2108, 1.5517>, <-4.1331, -0.1901, 1.5973>}
triangle { <-4.1326, -0.2964, 1.6430>, <-4.1915, -0.2895, 1.6606>, <-4.1331, -0.1901, 1.5973>}
triangle { <-4.1915, -0.2895, 1.6606>, <-4.1331, -0.1901, 1.5973>, <-4.1918, -0.1818, 1.6147>}
triangle { <-4.1915, -0.2895, 1.6606>, <-4.2502, -0.2975, 1.6430>, <-4.1918, -0.1818, 1.6147>}
triangle { <-4.2502, -0.2975, 1.6430>, <-4.1918, -0.1818, 1.6147>, <-4.2506, -0.1892, 1.5973>}
triangle { <-4.2502, -0.2975, 1.6430>, <-4.2863, -0.3174, 1.5970>, <-4.2506, -0.1892, 1.5973>}
triangle { <-4.2863, -0.3174, 1.5970>, <-4.2506, -0.1892, 1.5973>, <-4.2871, -0.2093, 1.5517>}
triangle { <-4.2863, -0.3174, 1.5970>, <-4.2861, -0.3416, 1.5401>, <-4.2871, -0.2093, 1.5517>}
triangle { <-4.2861, -0.3416, 1.5401>, <-4.2871, -0.2093, 1.5517>, <-4.2873, -0.2346, 1.4953>}
triangle { <-4.2861, -0.3416, 1.5401>, <-4.2496, -0.3608, 1.4941>, <-4.2873, -0.2346, 1.4953>}
triangle { <-4.2496, -0.3608, 1.4941>, <-4.2873, -0.2346, 1.4953>, <-4.2512, -0.2553, 1.4496>}
triangle { <-4.2496, -0.3608, 1.4941>, <-4.1908, -0.3678, 1.4765>, <-4.2512, -0.2553, 1.4496>}
triangle { <-4.1908, -0.3678, 1.4765>, <-4.2512, -0.2553, 1.4496>, <-4.1924, -0.2636, 1.4322>}
triangle { <-4.1924, -0.2636, 1.4322>, <-4.1336, -0.2562, 1.4496>, <-4.1921, -0.1705, 1.3905>}
triangle { <-4.1336, -0.2562, 1.4496>, <-4.1921, -0.1705, 1.3905>, <-4.1332, -0.1635, 1.4079>}
triangle { <-4.1336, -0.2562, 1.4496>, <-4.0971, -0.2361, 1.4953>, <-4.1332, -0.1635, 1.4079>}
triangle { <-4.0971, -0.2361, 1.4953>, <-4.1332, -0.1635, 1.4079>, <-4.0965, -0.1432, 1.4533>}
triangle { <-4.0971, -0.2361, 1.4953>, <-4.0969, -0.2108, 1.5517>, <-4.0965, -0.1432, 1.4533>}
triangle { <-4.0969, -0.2108, 1.5517>, <-4.0965, -0.1432, 1.4533>, <-4.0961, -0.1174, 1.5094>}
triangle { <-4.0969, -0.2108, 1.5517>, <-4.1331, -0.1901, 1.5973>, <-4.0961, -0.1174, 1.5094>}
triangle { <-4.1331, -0.1901, 1.5973>, <-4.0961, -0.1174, 1.5094>, <-4.1320, -0.0958, 1.5548>}
triangle { <-4.1331, -0.1901, 1.5973>, <-4.1918, -0.1818, 1.6147>, <-4.1320, -0.0958, 1.5548>}
triangle { <-4.1918, -0.1818, 1.6147>, <-4.1320, -0.0958, 1.5548>, <-4.1906, -0.0867, 1.5721>}
triangle { <-4.1918, -0.1818, 1.6147>, <-4.2506, -0.1892, 1.5973>, <-4.1906, -0.0867, 1.5721>}
triangle { <-4.2506, -0.1892, 1.5973>, <-4.1906, -0.0867, 1.5721>, <-4.2495, -0.0937, 1.5548>}
triangle { <-4.2506, -0.1892, 1.5973>, <-4.2871, -0.2093, 1.5517>, <-4.2495, -0.0937, 1.5548>}
triangle { <-4.2871, -0.2093, 1.5517>, <-4.2495, -0.0937, 1.5548>, <-4.2862, -0.1140, 1.5094>}
triangle { <-4.2871, -0.2093, 1.5517>, <-4.2873, -0.2346, 1.4953>, <-4.2862, -0.1140, 1.5094>}
triangle { <-4.2873, -0.2346, 1.4953>, <-4.2862, -0.1140, 1.5094>, <-4.2867, -0.1398, 1.4533>}
triangle { <-4.2873, -0.2346, 1.4953>, <-4.2512, -0.2553, 1.4496>, <-4.2867, -0.1398, 1.4533>}
triangle { <-4.2512, -0.2553, 1.4496>, <-4.2867, -0.1398, 1.4533>, <-4.2508, -0.1614, 1.4079>}
triangle { <-4.2512, -0.2553, 1.4496>, <-4.1924, -0.2636, 1.4322>, <-4.2508, -0.1614, 1.4079>}
triangle { <-4.1924, -0.2636, 1.4322>, <-4.2508, -0.1614, 1.4079>, <-4.1921, -0.1705, 1.3905>}
triangle { <-4.1921, -0.1705, 1.3905>, <-4.1332, -0.1635, 1.4079>, <-4.1908, -0.0913, 1.3540>}
triangle { <-4.1332, -0.1635, 1.4079>, <-4.1908, -0.0913, 1.3540>, <-4.1319, -0.0845, 1.3714>}
triangle { <-4.1332, -0.1635, 1.4079>, <-4.0965, -0.1432, 1.4533>, <-4.1319, -0.0845, 1.3714>}
triangle { <-4.0965, -0.1432, 1.4533>, <-4.1319, -0.0845, 1.3714>, <-4.0951, -0.0642, 1.4167>}
triangle { <-4.0965, -0.1432, 1.4533>, <-4.0961, -0.1174, 1.5094>, <-4.0951, -0.0642, 1.4167>}
triangle { <-4.0961, -0.1174, 1.5094>, <-4.0951, -0.0642, 1.4167>, <-4.0946, -0.0382, 1.4728>}
triangle { <-4.0961, -0.1174, 1.5094>, <-4.1320, -0.0958, 1.5548>, <-4.0946, -0.0382, 1.4728>}
triangle { <-4.1320, -0.0958, 1.5548>, <-4.0946, -0.0382, 1.4728>, <-4.1305, -0.0164, 1.5182>}
triangle { <-4.1320, -0.0958, 1.5548>, <-4.1906, -0.0867, 1.5721>, <-4.1305, -0.0164, 1.5182>}
triangle { <-4.1906, -0.0867, 1.5721>, <-4.1305, -0.0164, 1.5182>, <-4.1891, -0.0072, 1.5355>}
triangle { <-4.1906, -0.0867, 1.5721>, <-4.2495, -0.0937, 1.5548>, <-4.1891, -0.0072, 1.5355>}
triangle { <-4.2495, -0.0937, 1.5548>, <-4.1891, -0.0072, 1.5355>, <-4.2480, -0.0141, 1.5182>}
triangle { <-4.2495, -0.0937, 1.5548>, <-4.2862, -0.1140, 1.5094>, <-4.2480, -0.0141, 1.5182>}
triangle { <-4.2862, -0.1140, 1.5094>, <-4.2480, -0.0141, 1.5182>, <-4.2848, -0.0344, 1.4728>}
triangle { <-4.2862, -0.1140, 1.5094>, <-4.2867, -0.1398, 1.4533>, <-4.2848, -0.0344, 1.4728>}
triangle { <-4.2867, -0.1398, 1.4533>, <-4.2848, -0.0344, 1.4728>, <-4.2853, -0.0604, 1.4167>}
triangle { <-4.2867, -0.1398, 1.4533>, <-4.2508, -0.1614, 1.4079>, <-4.2853, -0.0604, 1.4167>}
triangle { <-4.2508, -0.1614, 1.4079>, <-4.2853, -0.0604, 1.4167>, <-4.2494, -0.0821, 1.3714>}
triangle { <-4.2508, -0.1614, 1.4079>, <-4.1921, -0.1705, 1.3905>, <-4.2494, -0.0821, 1.3714>}
triangle { <-4.1921, -0.1705, 1.3905>, <-4.2494, -0.0821, 1.3714>, <-4.1908, -0.0913, 1.3540>}
triangle { <-4.1908, -0.0913, 1.3540>, <-4.1319, -0.0845, 1.3714>, <-4.1896, -0.0289, 1.3251>}
triangle { <-4.1319, -0.0845, 1.3714>, <-4.1896, -0.0289, 1.3251>, <-4.1306, -0.0220, 1.3424>}
triangle { <-4.1319, -0.0845, 1.3714>, <-4.0951, -0.0642, 1.4167>, <-4.1306, -0.0220, 1.3424>}
triangle { <-4.0951, -0.0642, 1.4167>, <-4.1306, -0.0220, 1.3424>, <-4.0939, -0.0017, 1.3878>}
triangle { <-4.0951, -0.0642, 1.4167>, <-4.0946, -0.0382, 1.4728>, <-4.0939, -0.0017, 1.3878>}
triangle { <-4.0946, -0.0382, 1.4728>, <-4.0939, -0.0017, 1.3878>, <-4.0934, 0.0243, 1.4438>}
triangle { <-4.0946, -0.0382, 1.4728>, <-4.1305, -0.0164, 1.5182>, <-4.0934, 0.0243, 1.4438>}
triangle { <-4.1305, -0.0164, 1.5182>, <-4.0934, 0.0243, 1.4438>, <-4.1293, 0.0460, 1.4892>}
triangle { <-4.1305, -0.0164, 1.5182>, <-4.1891, -0.0072, 1.5355>, <-4.1293, 0.0460, 1.4892>}
triangle { <-4.1891, -0.0072, 1.5355>, <-4.1293, 0.0460, 1.4892>, <-4.1879, 0.0552, 1.5065>}
triangle { <-4.1891, -0.0072, 1.5355>, <-4.2480, -0.0141, 1.5182>, <-4.1879, 0.0552, 1.5065>}
triangle { <-4.2480, -0.0141, 1.5182>, <-4.1879, 0.0552, 1.5065>, <-4.2468, 0.0484, 1.4892>}
triangle { <-4.2480, -0.0141, 1.5182>, <-4.2848, -0.0344, 1.4728>, <-4.2468, 0.0484, 1.4892>}
triangle { <-4.2848, -0.0344, 1.4728>, <-4.2468, 0.0484, 1.4892>, <-4.2835, 0.0281, 1.4438>}
triangle { <-4.2848, -0.0344, 1.4728>, <-4.2853, -0.0604, 1.4167>, <-4.2835, 0.0281, 1.4438>}
triangle { <-4.2853, -0.0604, 1.4167>, <-4.2835, 0.0281, 1.4438>, <-4.2841, 0.0021, 1.3878>}
triangle { <-4.2853, -0.0604, 1.4167>, <-4.2494, -0.0821, 1.3714>, <-4.2841, 0.0021, 1.3878>}
triangle { <-4.2494, -0.0821, 1.3714>, <-4.2841, 0.0021, 1.3878>, <-4.2482, -0.0197, 1.3424>}
triangle { <-4.2494, -0.0821, 1.3714>, <-4.1908, -0.0913, 1.3540>, <-4.2482, -0.0197, 1.3424>}
triangle { <-4.1908, -0.0913, 1.3540>, <-4.2482, -0.0197, 1.3424>, <-4.1896, -0.0289, 1.3251>}
triangle { <-4.1896, -0.0289, 1.3251>, <-4.1306, -0.0220, 1.3424>, <-4.1886, 0.0180, 1.3033>}
triangle { <-4.1306, -0.0220, 1.3424>, <-4.1886, 0.0180, 1.3033>, <-4.1297, 0.0249, 1.3206>}
triangle { <-4.1306, -0.0220, 1.3424>, <-4.0939, -0.0017, 1.3878>, <-4.1297, 0.0249, 1.3206>}
triangle { <-4.0939, -0.0017, 1.3878>, <-4.1297, 0.0249, 1.3206>, <-4.0929, 0.0452, 1.3660>}
triangle { <-4.0939, -0.0017, 1.3878>, <-4.0934, 0.0243, 1.4438>, <-4.0929, 0.0452, 1.3660>}
triangle { <-4.0934, 0.0243, 1.4438>, <-4.0929, 0.0452, 1.3660>, <-4.0924, 0.0712, 1.4221>}
triangle { <-4.0934, 0.0243, 1.4438>, <-4.1293, 0.0460, 1.4892>, <-4.0924, 0.0712, 1.4221>}
triangle { <-4.1293, 0.0460, 1.4892>, <-4.0924, 0.0712, 1.4221>, <-4.1283, 0.0929, 1.4674>}
triangle { <-4.1293, 0.0460, 1.4892>, <-4.1879, 0.0552, 1.5065>, <-4.1283, 0.0929, 1.4674>}
triangle { <-4.1879, 0.0552, 1.5065>, <-4.1283, 0.0929, 1.4674>, <-4.1869, 0.1021, 1.4848>}
triangle { <-4.1879, 0.0552, 1.5065>, <-4.2468, 0.0484, 1.4892>, <-4.1869, 0.1021, 1.4848>}
triangle { <-4.2468, 0.0484, 1.4892>, <-4.1869, 0.1021, 1.4848>, <-4.2459, 0.0953, 1.4674>}
triangle { <-4.2468, 0.0484, 1.4892>, <-4.2835, 0.0281, 1.4438>, <-4.2459, 0.0953, 1.4674>}
triangle { <-4.2835, 0.0281, 1.4438>, <-4.2459, 0.0953, 1.4674>, <-4.2826, 0.0750, 1.4221>}
triangle { <-4.2835, 0.0281, 1.4438>, <-4.2841, 0.0021, 1.3878>, <-4.2826, 0.0750, 1.4221>}
triangle { <-4.2841, 0.0021, 1.3878>, <-4.2826, 0.0750, 1.4221>, <-4.2831, 0.0490, 1.3660>}
triangle { <-4.2841, 0.0021, 1.3878>, <-4.2482, -0.0197, 1.3424>, <-4.2831, 0.0490, 1.3660>}
triangle { <-4.2482, -0.0197, 1.3424>, <-4.2831, 0.0490, 1.3660>, <-4.2472, 0.0272, 1.3206>}
triangle { <-4.2482, -0.0197, 1.3424>, <-4.1896, -0.0289, 1.3251>, <-4.2472, 0.0272, 1.3206>}
triangle { <-4.1896, -0.0289, 1.3251>, <-4.2472, 0.0272, 1.3206>, <-4.1886, 0.0180, 1.3033>}
triangle { <-4.1886, 0.0180, 1.3033>, <-4.1297, 0.0249, 1.3206>, <-4.1879, 0.0517, 1.2877>}
triangle { <-4.1297, 0.0249, 1.3206>, <-4.1879, 0.0517, 1.2877>, <-4.1290, 0.0585, 1.3051>}
triangle { <-4.1297, 0.0249, 1.3206>, <-4.0929, 0.0452, 1.3660>, <-4.1290, 0.0585, 1.3051>}
triangle { <-4.0929, 0.0452, 1.3660>, <-4.1290, 0.0585, 1.3051>, <-4.0923, 0.0788, 1.3504>}
triangle { <-4.0929, 0.0452, 1.3660>, <-4.0924, 0.0712, 1.4221>, <-4.0923, 0.0788, 1.3504>}
triangle { <-4.0924, 0.0712, 1.4221>, <-4.0923, 0.0788, 1.3504>, <-4.0917, 0.1048, 1.4065>}
triangle { <-4.0924, 0.0712, 1.4221>, <-4.1283, 0.0929, 1.4674>, <-4.0917, 0.1048, 1.4065>}
triangle { <-4.1283, 0.0929, 1.4674>, <-4.0917, 0.1048, 1.4065>, <-4.1276, 0.1266, 1.4518>}
triangle { <-4.1283, 0.0929, 1.4674>, <-4.1869, 0.1021, 1.4848>, <-4.1276, 0.1266, 1.4518>}
triangle { <-4.1869, 0.1021, 1.4848>, <-4.1276, 0.1266, 1.4518>, <-4.1863, 0.1358, 1.4692>}
triangle { <-4.1869, 0.1021, 1.4848>, <-4.2459, 0.0953, 1.4674>, <-4.1863, 0.1358, 1.4692>}
triangle { <-4.2459, 0.0953, 1.4674>, <-4.1863, 0.1358, 1.4692>, <-4.2452, 0.1289, 1.4518>}
triangle { <-4.2459, 0.0953, 1.4674>, <-4.2826, 0.0750, 1.4221>, <-4.2452, 0.1289, 1.4518>}
triangle { <-4.2826, 0.0750, 1.4221>, <-4.2452, 0.1289, 1.4518>, <-4.2819, 0.1086, 1.4065>}
triangle { <-4.2826, 0.0750, 1.4221>, <-4.2831, 0.0490, 1.3660>, <-4.2819, 0.1086, 1.4065>}
triangle { <-4.2831, 0.0490, 1.3660>, <-4.2819, 0.1086, 1.4065>, <-4.2824, 0.0826, 1.3504>}
triangle { <-4.2831, 0.0490, 1.3660>, <-4.2472, 0.0272, 1.3206>, <-4.2824, 0.0826, 1.3504>}
triangle { <-4.2472, 0.0272, 1.3206>, <-4.2824, 0.0826, 1.3504>, <-4.2465, 0.0609, 1.3051>}
triangle { <-4.2472, 0.0272, 1.3206>, <-4.1886, 0.0180, 1.3033>, <-4.2465, 0.0609, 1.3051>}
triangle { <-4.1886, 0.0180, 1.3033>, <-4.2465, 0.0609, 1.3051>, <-4.1879, 0.0517, 1.2877>}
triangle { <-4.1879, 0.0517, 1.2877>, <-4.1290, 0.0585, 1.3051>, <-4.1875, 0.0742, 1.2773>}
triangle { <-4.1290, 0.0585, 1.3051>, <-4.1875, 0.0742, 1.2773>, <-4.1286, 0.0811, 1.2946>}
triangle { <-4.1290, 0.0585, 1.3051>, <-4.0923, 0.0788, 1.3504>, <-4.1286, 0.0811, 1.2946>}
triangle { <-4.0923, 0.0788, 1.3504>, <-4.1286, 0.0811, 1.2946>, <-4.0918, 0.1014, 1.3400>}
triangle { <-4.0923, 0.0788, 1.3504>, <-4.0917, 0.1048, 1.4065>, <-4.0918, 0.1014, 1.3400>}
triangle { <-4.0917, 0.1048, 1.4065>, <-4.0918, 0.1014, 1.3400>, <-4.0913, 0.1273, 1.3960>}
triangle { <-4.0917, 0.1048, 1.4065>, <-4.1276, 0.1266, 1.4518>, <-4.0913, 0.1273, 1.3960>}
triangle { <-4.1276, 0.1266, 1.4518>, <-4.0913, 0.1273, 1.3960>, <-4.1272, 0.1491, 1.4414>}
triangle { <-4.1276, 0.1266, 1.4518>, <-4.1863, 0.1358, 1.4692>, <-4.1272, 0.1491, 1.4414>}
triangle { <-4.1863, 0.1358, 1.4692>, <-4.1272, 0.1491, 1.4414>, <-4.1858, 0.1583, 1.4587>}
triangle { <-4.1863, 0.1358, 1.4692>, <-4.2452, 0.1289, 1.4518>, <-4.1858, 0.1583, 1.4587>}
triangle { <-4.2452, 0.1289, 1.4518>, <-4.1858, 0.1583, 1.4587>, <-4.2447, 0.1515, 1.4414>}
triangle { <-4.2452, 0.1289, 1.4518>, <-4.2819, 0.1086, 1.4065>, <-4.2447, 0.1515, 1.4414>}
triangle { <-4.2819, 0.1086, 1.4065>, <-4.2447, 0.1515, 1.4414>, <-4.2815, 0.1312, 1.3960>}
triangle { <-4.2819, 0.1086, 1.4065>, <-4.2824, 0.0826, 1.3504>, <-4.2815, 0.1312, 1.3960>}
triangle { <-4.2824, 0.0826, 1.3504>, <-4.2815, 0.1312, 1.3960>, <-4.2820, 0.1052, 1.3400>}
triangle { <-4.2824, 0.0826, 1.3504>, <-4.2465, 0.0609, 1.3051>, <-4.2820, 0.1052, 1.3400>}
triangle { <-4.2465, 0.0609, 1.3051>, <-4.2820, 0.1052, 1.3400>, <-4.2461, 0.0834, 1.2946>}
triangle { <-4.2465, 0.0609, 1.3051>, <-4.1879, 0.0517, 1.2877>, <-4.2461, 0.0834, 1.2946>}
triangle { <-4.1879, 0.0517, 1.2877>, <-4.2461, 0.0834, 1.2946>, <-4.1875, 0.0742, 1.2773>}
triangle { <-4.1875, 0.0742, 1.2773>, <-4.1286, 0.0811, 1.2946>, <-4.1872, 0.0879, 1.2709>}
triangle { <-4.1286, 0.0811, 1.2946>, <-4.1872, 0.0879, 1.2709>, <-4.1283, 0.0947, 1.2883>}
triangle { <-4.1286, 0.0811, 1.2946>, <-4.0918, 0.1014, 1.3400>, <-4.1283, 0.0947, 1.2883>}
triangle { <-4.0918, 0.1014, 1.3400>, <-4.1283, 0.0947, 1.2883>, <-4.0915, 0.1150, 1.3336>}
triangle { <-4.0918, 0.1014, 1.3400>, <-4.0913, 0.1273, 1.3960>, <-4.0915, 0.1150, 1.3336>}
triangle { <-4.0913, 0.1273, 1.3960>, <-4.0915, 0.1150, 1.3336>, <-4.0910, 0.1410, 1.3897>}
triangle { <-4.0913, 0.1273, 1.3960>, <-4.1272, 0.1491, 1.4414>, <-4.0910, 0.1410, 1.3897>}
triangle { <-4.1272, 0.1491, 1.4414>, <-4.0910, 0.1410, 1.3897>, <-4.1269, 0.1628, 1.4350>}
triangle { <-4.1272, 0.1491, 1.4414>, <-4.1858, 0.1583, 1.4587>, <-4.1269, 0.1628, 1.4350>}
triangle { <-4.1858, 0.1583, 1.4587>, <-4.1269, 0.1628, 1.4350>, <-4.1855, 0.1720, 1.4524>}
triangle { <-4.1858, 0.1583, 1.4587>, <-4.2447, 0.1515, 1.4414>, <-4.1855, 0.1720, 1.4524>}
triangle { <-4.2447, 0.1515, 1.4414>, <-4.1855, 0.1720, 1.4524>, <-4.2445, 0.1651, 1.4350>}
triangle { <-4.2447, 0.1515, 1.4414>, <-4.2815, 0.1312, 1.3960>, <-4.2445, 0.1651, 1.4350>}
triangle { <-4.2815, 0.1312, 1.3960>, <-4.2445, 0.1651, 1.4350>, <-4.2812, 0.1448, 1.3897>}
triangle { <-4.2815, 0.1312, 1.3960>, <-4.2820, 0.1052, 1.3400>, <-4.2812, 0.1448, 1.3897>}
triangle { <-4.2820, 0.1052, 1.3400>, <-4.2812, 0.1448, 1.3897>, <-4.2817, 0.1188, 1.3336>}
triangle { <-4.2820, 0.1052, 1.3400>, <-4.2461, 0.0834, 1.2946>, <-4.2817, 0.1188, 1.3336>}
triangle { <-4.2461, 0.0834, 1.2946>, <-4.2817, 0.1188, 1.3336>, <-4.2458, 0.0971, 1.2883>}
triangle { <-4.2461, 0.0834, 1.2946>, <-4.1875, 0.0742, 1.2773>, <-4.2458, 0.0971, 1.2883>}
triangle { <-4.1875, 0.0742, 1.2773>, <-4.2458, 0.0971, 1.2883>, <-4.1872, 0.0879, 1.2709>}
// object MikesBSplineObject exported
  material {
    R2D2Hose
  }
  scale 0.06
  translate  <0.0, -0.0941, -0.8451>
}
#declare Wheels = union {
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 0.09, 0.03>
    translate  <-0.22, 0.02, -0.723>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.035>
    rotate -90.0*y
    translate  <-0.2025, 0.11, -0.723>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.035>
    rotate -90.0*y
    translate  <-0.2025, -0.07, -0.723>
  }
  material {
    R2D2GrayRubber
  }
  translate  <0.0, 0.02, -0.1276>
}
#declare FootAll = union {
  object { Foot }
  object { RoundCubeCuts }
  object { FootMetal }
  object { CylinderHalf }
  object { FootAddCuts }
  object { Couplers }
  object { Tubes }
  object { // Tubes1 -> Tubes
    Tubes
    translate  0.035*x
  }
  object { BSpline001 }
  object { BSpline002 }
  object { Wheels }
  translate  <0.2515, -0.0002, 0.7251>
  material {
    R2D2BodyMain
  }
  // Scaling fixed
  // Rot X limited (-20.0 to   2.0)
  // Translation fixed
  rotate -20.0*x
  translate  <-0.2515, -0.0198, -0.5976>
}
#declare Conectorpivot = intersection {
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    scale <0.011, 0.0575, 0.035>
    translate  <-0.2512, 0.02, -0.5814>
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.04>
    rotate -90.0*y
    translate  <-0.231, 0.02, -0.5164>
  }
}
#declare Conector = union {
  object { Conectorpivot }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.04>
    rotate -90.0*y
    translate  <-0.231, 0.02, -0.5976>
  }
  material {
    R2D2BodyMain
  }
}
#declare LeftArm = union {
  object { ArmCuts }
  object { BlueMainLong }
  object { SquareInsert }
  object { SquareInsert1 }
  object { RectangleInsert }
  object { RectangleInsert1 }
  object { BlueWhiteThing }
  object { LegJoint }
  object { Pivot }
  object { FootAll }
  object { Conector }
  translate  <0.0, -0.02, 0.1275>
  // All transformations fixed
  translate  -0.1275*z
}
#declare Cube545 = object {
  box { // Cube545
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.3044, -0.103, -0.711>
  }
}
#declare Cube546 = object {
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.3044, 0.1399, -0.711>
  }
}
#declare Cube547 = object {
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.3367, 0.0947, -0.711>
  }
}
#declare Cube548 = object {
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.017, 0.003>
    translate  <-0.1581, 0.0947, -0.711>
  }
}
#declare Cube563 = object {
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0025, 0.004, 0.0075>
    translate  <-0.0101, 0.0, -0.641>
  }
}




//
// ********  OBJECTS  *******
//

#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-16.173147, -15.690087, 11.808041>, <-15.173147, -15.690087, 11.808041>, <-14.173147, -15.690087, 11.808041>, <-12.991020, -15.371364, 11.324348>, 
      <-16.173147, -14.690087, 11.808041>, <-15.173147, -14.690087, 10.466218>, <-14.173147, -14.690087, 8.856031>, <-13.173147, -14.690087, 7.737845>, 
      <-16.173147, -13.690087, 11.808041>, <-15.173147, -13.690087, 8.856031>, <-14.173147, -13.690087, 7.335298>, <-13.173147, -13.690087, 5.143654>, 
      <-16.173147, -12.690087, 11.808041>, <-14.811812, -12.671118, 9.704865>, <-13.811812, -12.671118, 7.110674>, <-12.992480, -12.680603, 6.641530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-16.173147, -12.690087, 11.808041>, <-14.811812, -12.671118, 9.704865>, <-13.811812, -12.671118, 7.110674>, <-12.992480, -12.680603, 6.641530>, 
      <-16.173147, -11.690087, 11.808041>, <-14.450478, -11.652150, 10.553700>, <-13.450478, -11.652150, 6.886051>, <-12.811812, -11.671118, 8.139405>, 
      <-15.808893, -10.052641, 10.840654>, <-14.450478, -10.652150, 10.553700>, <-13.450478, -10.652150, 6.886051>, <-12.811812, -10.671118, 3.443025>, 
      <-15.991020, -9.371364, 11.324348>, <-14.811812, -9.671118, 8.586680>, <-13.811812, -9.671118, 4.919030>, <-12.992480, -9.680603, 2.459515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.991020, -9.371364, 11.324348>, <-14.811812, -9.671118, 8.586680>, <-13.811812, -9.671118, 4.919030>, <-12.992480, -9.680603, 2.459515>, 
      <-16.173147, -8.690087, 11.808041>, <-15.173147, -8.690087, 6.619659>, <-14.173147, -8.690087, 2.952010>, <-13.173147, -8.690087, 1.476005>, 
      <-15.000000, -7.000000, 11.808041>, <-14.000000, -7.000000, 6.619659>, <-13.000000, -7.000000, 7.066934>, <-12.000000, -7.000000, 6.351295>, 
      <-15.000000, -6.000000, 11.808041>, <-14.000000, -6.000000, 6.619659>, <-13.000000, -6.000000, 5.009472>, <-12.000000, -6.000000, 4.121464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.000000, -6.000000, 11.808041>, <-14.000000, -6.000000, 6.619659>, <-13.000000, -6.000000, 5.009472>, <-12.000000, -6.000000, 4.121464>, 
      <-15.000000, -5.000000, 11.808041>, <-14.000000, -5.000000, 6.619659>, <-13.000000, -5.000000, 2.952010>, <-12.000000, -5.000000, 1.891634>, 
      <-15.000000, -4.000000, 11.808041>, <-14.000000, -4.000000, 6.619659>, <-13.000000, -4.000000, 4.651653>, <-12.000000, -4.000000, 3.591276>, 
      <-15.000000, -3.000000, 11.808041>, <-14.000000, -3.000000, 6.619659>, <-13.000000, -3.000000, 4.651653>, <-12.000000, -3.000000, 3.591276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.000000, -3.000000, 11.808041>, <-14.000000, -3.000000, 6.619659>, <-13.000000, -3.000000, 4.651653>, <-12.000000, -3.000000, 3.591276>, 
      <-15.000000, -2.000000, 11.808041>, <-14.000000, -2.000000, 6.619659>, <-13.000000, -2.000000, 4.651653>, <-12.000000, -2.000000, 3.591276>, 
      <-15.803215, -1.032246, 11.711302>, <-14.000000, -1.000000, 6.619659>, <-13.000000, -1.000000, 2.952010>, <-12.000000, -1.000000, 1.476005>, 
      <-15.401607, -0.016123, 11.759672>, <-14.000000, 0.000000, 6.619659>, <-13.000000, 0.000000, 2.952010>, <-12.000000, 0.000000, 1.476005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.401607, -0.016123, 11.759672>, <-14.000000, 0.000000, 6.619659>, <-13.000000, 0.000000, 2.952010>, <-12.000000, 0.000000, 1.476005>, 
      <-15.000000, 1.000000, 11.808041>, <-14.000000, 1.000000, 6.619659>, <-13.000000, 1.000000, 2.952010>, <-12.000000, 1.000000, 1.476005>, 
      <-15.000000, 2.000000, 11.808041>, <-14.000000, 2.000000, 6.619659>, <-13.000000, 2.000000, 7.156388>, <-12.000000, 2.000000, 4.964745>, 
      <-15.401607, 2.983877, 11.759672>, <-14.000000, 3.000000, 6.619659>, <-13.000000, 3.000000, 5.143654>, <-12.000000, 3.000000, 3.309830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.401607, 2.983877, 11.759672>, <-14.000000, 3.000000, 6.619659>, <-13.000000, 3.000000, 5.143654>, <-12.000000, 3.000000, 3.309830>, 
      <-15.803215, 3.967754, 11.711302>, <-14.000000, 4.000000, 6.619659>, <-13.000000, 4.000000, 3.130920>, <-12.000000, 4.000000, 1.654915>, 
      <-15.803215, 4.967754, 11.711302>, <-14.000000, 5.000000, 6.619659>, <-13.000000, 5.000000, 6.440750>, <-12.000000, 5.000000, 8.050937>, 
      <-15.401607, 5.983877, 11.759672>, <-14.000000, 6.000000, 6.619659>, <-13.000000, 6.000000, 4.696380>, <-12.000000, 6.000000, 4.763471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-15.401607, 5.983877, 11.759672>, <-14.000000, 6.000000, 6.619659>, <-13.000000, 6.000000, 4.696380>, <-12.000000, 6.000000, 4.763471>, 
      <-15.000000, 7.000000, 11.808041>, <-14.000000, 7.000000, 6.619659>, <-13.000000, 7.000000, 2.952010>, <-12.000000, 7.000000, 1.476005>, 
      <-14.378922, 7.723965, 11.808041>, <-13.378922, 7.723965, 6.619659>, <-12.378922, 7.723965, 2.952010>, <-11.378922, 7.723965, 2.952010>, 
      <-14.378922, 8.723965, 11.808041>, <-13.378922, 8.723965, 7.558935>, <-12.378922, 8.723965, 3.936014>, <-11.378922, 8.723965, 3.444012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-14.378922, 8.723965, 11.808041>, <-13.378922, 8.723965, 7.558935>, <-12.378922, 8.723965, 3.936014>, <-11.378922, 8.723965, 3.444012>, 
      <-14.378922, 9.723965, 11.808041>, <-13.378922, 9.723965, 8.498211>, <-12.378922, 9.723965, 4.920017>, <-11.378922, 9.723965, 3.936014>, 
      <-13.619827, 10.240905, 11.808041>, <-12.619827, 10.240905, 8.498211>, <-11.619827, 10.240905, 4.920017>, <-10.999374, 10.482435, 4.159651>, 
      <-13.067757, 11.068383, 11.808041>, <-12.067757, 11.068383, 10.466218>, <-11.619827, 11.240905, 6.843296>, <-10.999374, 11.482435, 5.009472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-13.067757, 11.068383, 11.808041>, <-12.067757, 11.068383, 10.466218>, <-11.619827, 11.240905, 6.843296>, <-10.999374, 11.482435, 5.009472>, 
      <-12.515688, 11.895861, 11.808041>, <-11.515688, 11.895861, 12.434225>, <-11.619827, 12.240905, 8.766576>, <-10.999374, 12.482435, 5.859293>, 
      <-12.515688, 12.895861, 11.808041>, <-11.515688, 12.895861, 6.619659>, <-11.619827, 13.240905, 6.619659>, <-10.999374, 13.482435, 6.619659>, 
      <-12.515688, 13.693706, 11.808041>, <-11.515688, 13.895861, 11.808041>, <-11.619827, 14.240905, 11.808041>, <-10.999374, 14.482435, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.991020, -15.371364, 11.324348>, <-11.808893, -15.052641, 10.840654>, <-10.808893, -15.052641, 10.840654>, <-9.222319, -14.707598, 10.840654>, 
      <-13.173147, -14.690087, 7.737845>, <-12.173147, -14.690087, 6.619659>, <-11.173147, -14.690087, 6.619659>, <-9.586574, -14.345043, 6.619659>, 
      <-13.173147, -13.690087, 5.143654>, <-12.173147, -13.690087, 2.952010>, <-11.173147, -13.690087, 5.546201>, <-9.586574, -13.345043, 4.249106>, 
      <-12.992480, -12.680603, 6.641530>, <-12.173147, -12.690087, 6.172385>, <-11.173147, -12.690087, 2.773101>, <-9.586574, -12.345043, 3.801831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.992480, -12.680603, 6.641530>, <-12.173147, -12.690087, 6.172385>, <-11.173147, -12.690087, 2.773101>, <-9.586574, -12.345043, 3.801831>, 
      <-12.811812, -11.671118, 8.139405>, <-12.173147, -11.690087, 9.392760>, <-11.173147, -11.690087, 0.000000>, <-9.586574, -11.345043, 3.354557>, 
      <-12.811812, -10.671118, 3.443025>, <-12.173147, -10.690087, 0.000000>, <-11.173147, -10.690087, 5.367291>, <-9.586574, -10.345043, 6.038203>, 
      <-12.992480, -9.680603, 2.459515>, <-12.173147, -9.690087, 0.000000>, <-11.173147, -9.690087, 3.488739>, <-9.586574, -9.345043, 3.824195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.992480, -9.680603, 2.459515>, <-12.173147, -9.690087, 0.000000>, <-11.173147, -9.690087, 3.488739>, <-9.586574, -9.345043, 3.824195>, 
      <-13.173147, -8.690087, 1.476005>, <-12.173147, -8.690087, 0.000000>, <-11.173147, -8.690087, 1.610187>, <-9.586574, -8.345043, 1.610187>, 
      <-12.000000, -7.000000, 6.351295>, <-11.000000, -7.000000, 5.635656>, <-10.000000, -7.000000, 5.188382>, <-9.000000, -7.000000, 3.399285>, 
      <-12.000000, -6.000000, 4.121464>, <-11.000000, -6.000000, 3.233457>, <-10.000000, -6.000000, 3.009820>, <-9.000000, -6.000000, 2.063318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.000000, -6.000000, 4.121464>, <-11.000000, -6.000000, 3.233457>, <-10.000000, -6.000000, 3.009820>, <-9.000000, -6.000000, 2.063318>, 
      <-12.000000, -5.000000, 1.891634>, <-11.000000, -5.000000, 0.831258>, <-10.000000, -5.000000, 0.831258>, <-9.000000, -5.000000, 0.727351>, 
      <-12.000000, -4.000000, 3.591276>, <-11.000000, -4.000000, 2.530900>, <-10.000000, -4.000000, 2.530900>, <-9.000000, -4.000000, 2.426993>, 
      <-12.000000, -3.000000, 3.591276>, <-11.000000, -3.000000, 2.530900>, <-10.000000, -3.000000, 1.681079>, <-9.000000, -3.000000, 1.421311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.000000, -3.000000, 3.591276>, <-11.000000, -3.000000, 2.530900>, <-10.000000, -3.000000, 1.681079>, <-9.000000, -3.000000, 1.421311>, 
      <-12.000000, -2.000000, 3.591276>, <-11.000000, -2.000000, 2.530900>, <-10.000000, -2.000000, 0.831258>, <-9.000000, -2.000000, 0.415629>, 
      <-12.000000, -1.000000, 1.476005>, <-11.000000, -1.000000, 0.000000>, <-10.000000, -1.000000, 3.309830>, <-9.000000, -1.000000, 1.654915>, 
      <-12.000000, 0.000000, 1.476005>, <-11.000000, 0.000000, 0.000000>, <-10.000000, 0.000000, 2.693987>, <-9.000000, 0.000000, 1.346994>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.000000, 0.000000, 1.476005>, <-11.000000, 0.000000, 0.000000>, <-10.000000, 0.000000, 2.693987>, <-9.000000, 0.000000, 1.346994>, 
      <-12.000000, 1.000000, 1.476005>, <-11.000000, 1.000000, 0.000000>, <-10.000000, 1.000000, 2.078144>, <-9.000000, 1.000000, 1.039072>, 
      <-12.000000, 2.000000, 4.964745>, <-11.000000, 2.000000, 2.773101>, <-10.000000, 2.000000, 2.078144>, <-9.000000, 2.000000, 1.039072>, 
      <-12.000000, 3.000000, 3.309830>, <-11.000000, 3.000000, 1.476005>, <-10.000000, 3.000000, 2.078144>, <-9.000000, 3.000000, 1.039072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.000000, 3.000000, 3.309830>, <-11.000000, 3.000000, 1.476005>, <-10.000000, 3.000000, 2.078144>, <-9.000000, 3.000000, 1.039072>, 
      <-12.000000, 4.000000, 1.654915>, <-11.000000, 4.000000, 0.178910>, <-10.000000, 4.000000, 2.078144>, <-9.000000, 4.000000, 1.039072>, 
      <-12.000000, 5.000000, 8.050937>, <-11.000000, 5.000000, 9.661124>, <-10.000000, 5.000000, 0.000000>, <-9.000000, 5.000000, 0.779304>, 
      <-12.000000, 6.000000, 4.763471>, <-11.000000, 6.000000, 4.830562>, <-10.000000, 6.000000, 0.000000>, <-9.000000, 6.000000, 0.779304>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-12.000000, 6.000000, 4.763471>, <-11.000000, 6.000000, 4.830562>, <-10.000000, 6.000000, 0.000000>, <-9.000000, 6.000000, 0.779304>, 
      <-12.000000, 7.000000, 1.476005>, <-11.000000, 7.000000, 0.000000>, <-10.000000, 7.000000, 0.000000>, <-9.000000, 7.000000, 0.779304>, 
      <-11.378922, 7.723965, 2.952010>, <-10.378922, 7.723965, 2.952010>, <-9.378922, 7.723965, 1.558608>, <-8.689461, 7.861983, 1.558608>, 
      <-11.378922, 8.723965, 3.444012>, <-10.378922, 8.723965, 2.952010>, <-9.378922, 8.723965, 0.779304>, <-8.689461, 8.861983, 0.779304>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-11.378922, 8.723965, 3.444012>, <-10.378922, 8.723965, 2.952010>, <-9.378922, 8.723965, 0.779304>, <-8.689461, 8.861983, 0.779304>, 
      <-11.378922, 9.723965, 3.936014>, <-10.378922, 9.723965, 2.952010>, <-9.378922, 9.723965, 0.000000>, <-8.689461, 9.861983, 0.000000>, 
      <-10.999374, 10.482435, 4.159651>, <-10.378922, 10.723965, 3.399285>, <-9.378922, 10.723965, 3.399285>, <-8.689461, 10.861983, 3.399285>, 
      <-10.999374, 11.482435, 5.009472>, <-10.378922, 11.723965, 3.175647>, <-9.378922, 11.723965, 3.175647>, <-8.689461, 11.861983, 3.175647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-10.999374, 11.482435, 5.009472>, <-10.378922, 11.723965, 3.175647>, <-9.378922, 11.723965, 3.175647>, <-8.689461, 11.861983, 3.175647>, 
      <-10.999374, 12.482435, 5.859293>, <-10.378922, 12.723965, 2.952010>, <-9.378922, 12.723965, 2.952010>, <-8.689461, 12.861983, 2.952010>, 
      <-10.999374, 13.482435, 6.619659>, <-10.378922, 13.723965, 6.619659>, <-9.378922, 13.723965, 6.619659>, <-8.689461, 13.861983, 6.619659>, 
      <-10.999374, 14.482435, 11.808041>, <-10.378922, 14.723965, 11.808041>, <-9.378922, 14.723965, 11.808041>, <-8.689461, 14.861983, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.222319, -14.707598, 10.840654>, <-7.635745, -14.362555, 10.840654>, <-6.635745, -14.362555, 10.840654>, <-6.728509, -15.578628, 11.840287>, 
      <-9.586574, -14.345043, 6.619659>, <-8.000000, -14.000000, 6.619659>, <-7.000000, -14.000000, 6.619659>, <-6.000000, -14.000000, 6.619659>, 
      <-9.586574, -13.345043, 4.249106>, <-8.000000, -13.000000, 2.952010>, <-7.000000, -13.000000, 2.952010>, <-6.000000, -13.000000, 2.952010>, 
      <-9.586574, -12.345043, 3.801831>, <-8.000000, -12.000000, 4.830562>, <-7.000000, -12.000000, 1.476005>, <-6.000000, -12.000000, 2.079825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.586574, -12.345043, 3.801831>, <-8.000000, -12.000000, 4.830562>, <-7.000000, -12.000000, 1.476005>, <-6.000000, -12.000000, 2.079825>, 
      <-9.586574, -11.345043, 3.354557>, <-8.000000, -11.000000, 6.709114>, <-7.000000, -11.000000, 0.000000>, <-6.000000, -11.000000, 1.207641>, 
      <-9.586574, -10.345043, 6.038203>, <-8.000000, -10.000000, 6.709114>, <-7.000000, -10.000000, 0.000000>, <-6.000000, -10.000000, 1.207641>, 
      <-9.586574, -9.345043, 3.824195>, <-8.000000, -9.000000, 4.159651>, <-7.000000, -9.000000, 0.000000>, <-6.000000, -9.000000, 0.603820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.586574, -9.345043, 3.824195>, <-8.000000, -9.000000, 4.159651>, <-7.000000, -9.000000, 0.000000>, <-6.000000, -9.000000, 0.603820>, 
      <-9.586574, -8.345043, 1.610187>, <-8.000000, -8.000000, 1.610187>, <-7.000000, -8.000000, 0.000000>, <-6.000000, -8.000000, 0.000000>, 
      <-9.000000, -7.000000, 3.399285>, <-8.000000, -7.000000, 1.610187>, <-7.000000, -7.000000, 0.000000>, <-6.000000, -7.000000, 0.000000>, 
      <-9.000000, -6.000000, 2.063318>, <-8.000000, -6.000000, 1.116815>, <-7.000000, -6.000000, -0.467583>, <-6.000000, -6.000000, 0.191119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.000000, -6.000000, 2.063318>, <-8.000000, -6.000000, 1.116815>, <-7.000000, -6.000000, -0.467583>, <-6.000000, -6.000000, 0.191119>, 
      <-9.000000, -5.000000, 0.727351>, <-8.000000, -5.000000, 0.623443>, <-7.000000, -5.000000, -0.935165>, <-6.000000, -5.000000, 0.382239>, 
      <-9.000000, -4.000000, 2.426993>, <-8.000000, -4.000000, 2.323086>, <-7.000000, -4.000000, -0.935165>, <-6.000000, -4.000000, -0.467583>, 
      <-9.000000, -3.000000, 1.421311>, <-8.000000, -3.000000, 1.161543>, <-7.000000, -3.000000, -0.467583>, <-6.000000, -3.000000, -0.493559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.000000, -3.000000, 1.421311>, <-8.000000, -3.000000, 1.161543>, <-7.000000, -3.000000, -0.467583>, <-6.000000, -3.000000, -0.493559>, 
      <-9.000000, -2.000000, 0.415629>, <-8.000000, -2.000000, 0.000000>, <-7.000000, -2.000000, 0.000000>, <-6.000000, -2.000000, -0.519536>, 
      <-9.000000, -1.000000, 1.654915>, <-8.000000, -1.000000, 0.000000>, <-7.000000, -1.000000, 0.000000>, <-6.000000, -1.000000, 0.447274>, 
      <-9.000000, 0.000000, 1.346994>, <-8.000000, 0.000000, 0.000000>, <-7.000000, 0.000000, 0.000000>, <-6.000000, 0.000000, 0.223637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.000000, 0.000000, 1.346994>, <-8.000000, 0.000000, 0.000000>, <-7.000000, 0.000000, 0.000000>, <-6.000000, 0.000000, 0.223637>, 
      <-9.000000, 1.000000, 1.039072>, <-8.000000, 1.000000, 0.000000>, <-7.000000, 1.000000, 0.000000>, <-6.000000, 1.000000, 0.000000>, 
      <-9.000000, 2.000000, 1.039072>, <-8.000000, 2.000000, 0.000000>, <-7.000000, 2.000000, 1.974237>, <-6.000000, 2.000000, 0.987119>, 
      <-9.000000, 3.000000, 1.039072>, <-8.000000, 3.000000, 0.000000>, <-7.000000, 3.000000, 0.987119>, <-6.000000, 3.000000, 0.285745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.000000, 3.000000, 1.039072>, <-8.000000, 3.000000, 0.000000>, <-7.000000, 3.000000, 0.987119>, <-6.000000, 3.000000, 0.285745>, 
      <-9.000000, 4.000000, 1.039072>, <-8.000000, 4.000000, 0.000000>, <-7.000000, 4.000000, 0.000000>, <-6.000000, 4.000000, -0.415629>, 
      <-9.000000, 5.000000, 0.779304>, <-8.000000, 5.000000, 1.558608>, <-7.000000, 5.000000, 1.558608>, <-6.000000, 5.000000, 0.779304>, 
      <-9.000000, 6.000000, 0.779304>, <-8.000000, 6.000000, 1.558608>, <-7.000000, 6.000000, 1.558608>, <-6.000000, 6.000000, 0.779304>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-9.000000, 6.000000, 0.779304>, <-8.000000, 6.000000, 1.558608>, <-7.000000, 6.000000, 1.558608>, <-6.000000, 6.000000, 0.779304>, 
      <-9.000000, 7.000000, 0.779304>, <-8.000000, 7.000000, 1.558608>, <-7.000000, 7.000000, 1.558608>, <-6.000000, 7.000000, 0.779304>, 
      <-8.689461, 7.861983, 1.558608>, <-8.000000, 8.000000, 1.558608>, <-7.000000, 8.000000, 1.558608>, <-6.000000, 8.000000, 0.779304>, 
      <-8.689461, 8.861983, 0.779304>, <-8.000000, 9.000000, 0.779304>, <-7.000000, 9.000000, 0.779304>, <-6.000000, 9.000000, 0.389652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-8.689461, 8.861983, 0.779304>, <-8.000000, 9.000000, 0.779304>, <-7.000000, 9.000000, 0.779304>, <-6.000000, 9.000000, 0.389652>, 
      <-8.689461, 9.861983, 0.000000>, <-8.000000, 10.000000, 0.000000>, <-7.000000, 10.000000, 0.000000>, <-6.000000, 10.000000, 0.000000>, 
      <-8.689461, 10.861983, 3.399285>, <-8.000000, 11.000000, 3.399285>, <-7.000000, 11.000000, 3.399285>, <-6.000000, 11.000000, 1.699642>, 
      <-8.689461, 11.861983, 3.175647>, <-8.000000, 12.000000, 3.175647>, <-7.000000, 12.000000, 3.175647>, <-6.222285, 11.961342, 2.325826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-8.689461, 11.861983, 3.175647>, <-8.000000, 12.000000, 3.175647>, <-7.000000, 12.000000, 3.175647>, <-6.222285, 11.961342, 2.325826>, 
      <-8.689461, 12.861983, 2.952010>, <-8.000000, 13.000000, 2.952010>, <-7.000000, 13.000000, 2.952010>, <-6.444571, 12.922683, 2.952010>, 
      <-8.689461, 13.861983, 6.619659>, <-8.000000, 14.000000, 6.619659>, <-7.000000, 14.000000, 6.619659>, <-6.599837, 13.974439, 6.619659>, 
      <-8.689461, 14.861983, 11.808041>, <-8.000000, 15.000000, 11.808041>, <-7.000000, 15.000000, 11.808041>, <-6.889721, 15.037232, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.728509, -15.578628, 11.840287>, <-6.821273, -16.794701, 12.839920>, <-4.000000, -15.000000, 11.808041>, <-3.439179, -18.030333, 11.808041>, 
      <-6.000000, -14.000000, 6.619659>, <-5.000000, -14.000000, 6.619659>, <-4.000000, -14.000000, 6.619659>, <-3.439179, -17.030333, 6.619659>, 
      <-6.000000, -13.000000, 2.952010>, <-5.000000, -13.000000, 2.952010>, <-4.000000, -13.000000, 2.952010>, <-3.439179, -16.030333, 2.952010>, 
      <-6.000000, -12.000000, 2.079825>, <-5.000000, -12.000000, 2.683646>, <-4.000000, -12.000000, 2.683646>, <-3.219589, -13.515166, 2.079825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, -12.000000, 2.079825>, <-5.000000, -12.000000, 2.683646>, <-4.000000, -12.000000, 2.683646>, <-3.219589, -13.515166, 2.079825>, 
      <-6.000000, -11.000000, 1.207641>, <-5.000000, -11.000000, 2.415281>, <-4.000000, -11.000000, 2.415281>, <-3.000000, -11.000000, 1.207641>, 
      <-6.000000, -10.000000, 1.207641>, <-5.000000, -10.000000, 2.415281>, <-4.000000, -10.000000, 2.415281>, <-3.000000, -10.000000, 1.207641>, 
      <-6.000000, -9.000000, 0.603820>, <-5.000000, -9.000000, 1.207641>, <-4.000000, -9.000000, 1.207641>, <-3.000000, -9.000000, 0.603820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, -9.000000, 0.603820>, <-5.000000, -9.000000, 1.207641>, <-4.000000, -9.000000, 1.207641>, <-3.000000, -9.000000, 0.603820>, 
      <-6.000000, -8.000000, 0.000000>, <-5.000000, -8.000000, 0.000000>, <-4.000000, -8.000000, 0.000000>, <-3.000000, -8.000000, 0.000000>, 
      <-6.000000, -7.000000, 0.000000>, <-5.000000, -7.000000, 0.000000>, <-4.000000, -7.000000, 0.000000>, <-3.000000, -7.000000, 0.000000>, 
      <-6.000000, -6.000000, 0.191119>, <-5.000000, -6.000000, 0.849821>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, -6.000000, 0.191119>, <-5.000000, -6.000000, 0.849821>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.000000>, 
      <-6.000000, -5.000000, 0.382239>, <-5.000000, -5.000000, 1.699642>, <-4.000000, -5.000000, 0.000000>, <-3.000000, -5.000000, 0.000000>, 
      <-6.000000, -4.000000, -0.467583>, <-5.000000, -4.000000, 0.000000>, <-4.000000, -4.000000, 0.000000>, <-3.000000, -4.000000, 0.000000>, 
      <-6.000000, -3.000000, -0.493559>, <-5.000000, -3.000000, -0.519536>, <-4.000000, -3.000000, 0.000000>, <-3.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, -3.000000, -0.493559>, <-5.000000, -3.000000, -0.519536>, <-4.000000, -3.000000, 0.000000>, <-3.000000, -3.000000, 0.000000>, 
      <-6.000000, -2.000000, -0.519536>, <-5.000000, -2.000000, -1.039072>, <-4.000000, -2.000000, 0.000000>, <-3.000000, -2.000000, 0.000000>, 
      <-6.000000, -1.000000, 0.447274>, <-5.000000, -1.000000, 0.894549>, <-4.000000, -1.000000, 0.000000>, <-3.000000, -1.000000, 0.000000>, 
      <-6.000000, 0.000000, 0.223637>, <-5.000000, 0.000000, 0.447274>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, 0.000000, 0.223637>, <-5.000000, 0.000000, 0.447274>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, 
      <-6.000000, 1.000000, 0.000000>, <-5.000000, 1.000000, 0.000000>, <-4.000000, 1.000000, 0.000000>, <-3.000000, 1.000000, 0.000000>, 
      <-6.000000, 2.000000, 0.987119>, <-5.000000, 2.000000, 0.000000>, <-4.000000, 2.000000, 0.000000>, <-3.000000, 2.000000, 0.000000>, 
      <-6.000000, 3.000000, 0.285745>, <-5.000000, 3.000000, -0.415629>, <-4.000000, 3.000000, -0.000184>, <-3.000000, 3.000000, -0.000170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, 3.000000, 0.285745>, <-5.000000, 3.000000, -0.415629>, <-4.000000, 3.000000, -0.000184>, <-3.000000, 3.000000, -0.000170>, 
      <-6.000000, 4.000000, -0.415629>, <-5.000000, 4.000000, -0.831258>, <-4.000000, 4.000000, -0.000367>, <-3.000000, 4.000000, -0.000340>, 
      <-6.000000, 5.000000, 0.779304>, <-5.000000, 5.000000, 0.000000>, <-4.000000, 5.000000, 0.000000>, <-3.000000, 5.000000, -0.000083>, 
      <-6.000000, 6.000000, 0.779304>, <-5.000000, 6.000000, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-3.000000, 6.000000, -0.000042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, 6.000000, 0.779304>, <-5.000000, 6.000000, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-3.000000, 6.000000, -0.000042>, 
      <-6.000000, 7.000000, 0.779304>, <-5.000000, 7.000000, 0.000000>, <-4.000000, 7.000000, 0.000000>, <-3.000000, 7.000000, 0.000000>, 
      <-6.000000, 8.000000, 0.779304>, <-5.000000, 8.000000, 0.000000>, <-4.000000, 8.000000, 0.000000>, <-3.000000, 8.000000, 0.000000>, 
      <-6.000000, 9.000000, 0.389652>, <-5.000000, 9.000000, 0.000000>, <-4.000000, 9.000000, 0.000000>, <-3.000000, 9.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.000000, 9.000000, 0.389652>, <-5.000000, 9.000000, 0.000000>, <-4.000000, 9.000000, 0.000000>, <-3.000000, 9.000000, 0.000000>, 
      <-6.000000, 10.000000, 0.000000>, <-5.000000, 10.000000, 0.000000>, <-4.000000, 10.000000, 0.000000>, <-3.000000, 10.000000, 0.000000>, 
      <-6.000000, 11.000000, 1.699642>, <-5.000000, 11.000000, 0.000000>, <-4.000000, 11.000000, 0.000000>, <-5.434782, 12.922497, 0.000000>, 
      <-6.222285, 11.961342, 2.325826>, <-5.444571, 11.922683, 1.476005>, <-4.444571, 11.922683, 1.476005>, <-6.253421, 14.520989, 1.644422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.222285, 11.961342, 2.325826>, <-5.444571, 11.922683, 1.476005>, <-4.444571, 11.922683, 1.476005>, <-6.253421, 14.520989, 1.644422>, 
      <-6.444571, 12.922683, 2.952010>, <-5.889142, 12.845367, 2.952010>, <-4.889142, 12.845367, 2.952010>, <-7.072061, 16.119482, 3.288844>, 
      <-6.599837, 13.974439, 6.619659>, <-6.199674, 13.948877, 6.619659>, <-5.700967, 13.845367, 6.619659>, <-7.481736, 17.119482, 6.553946>, 
      <-6.889721, 15.037232, 11.808041>, <-6.779442, 15.074463, 11.808041>, <-6.301330, 15.093793, 11.808041>, <-7.781918, 18.243695, 11.742328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.439179, -18.030333, 11.808041>, <-2.878357, -21.060665, 11.808041>, <-1.878357, -21.060665, 11.808041>, <-4.622599, -30.075748, 11.808041>, 
      <-3.439179, -17.030333, 6.619659>, <-2.878357, -20.060665, 6.619659>, <-1.878357, -20.060665, 6.619659>, <-4.622599, -29.075748, 6.619659>, 
      <-3.439179, -16.030333, 2.952010>, <-2.878357, -19.060665, 2.952010>, <-1.878357, -19.060665, 2.952010>, <-4.622599, -28.075748, 2.952010>, 
      <-3.219589, -13.515166, 2.079825>, <-2.439179, -15.030333, 1.476005>, <-1.439179, -15.030333, 1.476005>, <-4.370072, -24.978670, 1.476005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.219589, -13.515166, 2.079825>, <-2.439179, -15.030333, 1.476005>, <-1.439179, -15.030333, 1.476005>, <-4.370072, -24.978670, 1.476005>, 
      <-3.000000, -11.000000, 1.207641>, <-2.000000, -11.000000, 0.000000>, <-1.000000, -11.000000, 0.000000>, <-4.117544, -21.881592, 0.000000>, 
      <-3.000000, -10.000000, 1.207641>, <-2.000000, -10.000000, 0.000000>, <-1.000000, -10.000000, 0.000000>, <-4.117544, -20.881592, 0.000000>, 
      <-3.000000, -9.000000, 0.603820>, <-2.000000, -9.000000, 0.000000>, <-1.000000, -9.000000, 0.000000>, <-2.058772, -14.440796, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, -9.000000, 0.603820>, <-2.000000, -9.000000, 0.000000>, <-1.000000, -9.000000, 0.000000>, <-2.058772, -14.440796, 0.000000>, 
      <-3.000000, -8.000000, 0.000000>, <-2.000000, -8.000000, 0.000000>, <-1.000000, -8.000000, 0.000000>, <0.000000, -8.000000, 0.000000>, 
      <-3.000000, -7.000000, 0.000000>, <-2.000000, -7.000000, 0.000000>, <-1.000000, -7.000000, 0.000000>, <0.000000, -7.000000, 0.000000>, 
      <-3.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, 0.000000>, <-1.000000, -6.000000, -0.034239>, <0.000000, -6.000000, -0.029959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, 0.000000>, <-1.000000, -6.000000, -0.034239>, <0.000000, -6.000000, -0.029959>, 
      <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, -0.068478>, <0.000000, -5.000000, -0.068478>, 
      <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, -0.068478>, <0.000000, -4.000000, -0.068478>, 
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, -0.068478>, <0.000000, -3.000000, -0.064198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, -0.068478>, <0.000000, -3.000000, -0.064198>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, -0.068478>, <0.000000, -2.000000, -0.068478>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, -0.068478>, <0.000000, -1.000000, -0.068478>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, -0.068478>, <0.000000, 0.000000, -0.064198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, -0.068478>, <0.000000, 0.000000, -0.064198>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, -0.068478>, <0.000000, 1.000000, -0.068478>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, -0.068478>, <0.000000, 2.000000, -0.068478>, 
      <-3.000000, 3.000000, -0.000170>, <-2.000000, 3.000000, -0.000156>, <-1.000000, 3.000000, -0.068561>, <0.000000, 3.000000, -0.064240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, 3.000000, -0.000170>, <-2.000000, 3.000000, -0.000156>, <-1.000000, 3.000000, -0.068561>, <0.000000, 3.000000, -0.064240>, 
      <-3.000000, 4.000000, -0.000340>, <-2.000000, 4.000000, -0.000312>, <-1.000000, 4.000000, -0.068644>, <0.000000, 4.000000, -0.068561>, 
      <-3.000000, 5.000000, -0.000083>, <-2.000000, 5.000000, -0.000167>, <-1.000000, 5.000000, -0.068790>, <0.000000, 5.000000, -0.068634>, 
      <-3.000000, 6.000000, -0.000042>, <-2.000000, 6.000000, -0.000083>, <-1.000000, 6.000000, -0.068634>, <0.000000, 6.000000, -0.064276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, 6.000000, -0.000042>, <-2.000000, 6.000000, -0.000083>, <-1.000000, 6.000000, -0.068634>, <0.000000, 6.000000, -0.064276>, 
      <-3.000000, 7.000000, 0.000000>, <-2.000000, 7.000000, 0.000000>, <-1.000000, 7.000000, -0.068478>, <0.000000, 7.000000, -0.068478>, 
      <-3.000000, 8.000000, 0.000000>, <-2.000000, 8.000000, 0.000000>, <-1.000000, 8.000000, -0.068478>, <0.000000, 8.000000, -0.068478>, 
      <-3.000000, 9.000000, 0.000000>, <-2.000000, 9.000000, 0.000000>, <-1.000000, 9.000000, -0.068478>, <0.000000, 9.000000, -0.064198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.000000, 9.000000, 0.000000>, <-2.000000, 9.000000, 0.000000>, <-1.000000, 9.000000, -0.068478>, <0.000000, 9.000000, -0.064198>, 
      <-3.000000, 10.000000, 0.000000>, <-2.000000, 10.000000, 0.000000>, <-1.000000, 10.000000, -0.068478>, <0.000000, 10.000000, -0.068478>, 
      <-5.434782, 12.922497, 0.000000>, <-6.869563, 14.844994, 0.000000>, <-6.391451, 14.864323, 0.000000>, <-2.695725, 12.932161, 0.000000>, 
      <-6.253421, 14.520989, 1.644422>, <-8.062272, 17.119295, 1.812839>, <-7.323215, 17.128960, 1.812839>, <-3.161608, 14.564480, 1.644422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-6.253421, 14.520989, 1.644422>, <-8.062272, 17.119295, 1.812839>, <-7.323215, 17.128960, 1.812839>, <-3.161608, 14.564480, 1.644422>, 
      <-7.072061, 16.119482, 3.288844>, <-9.254980, 19.393597, 3.625678>, <-8.254980, 19.393597, 3.625678>, <-3.627490, 16.196798, 3.288844>, 
      <-7.481736, 17.119482, 6.553946>, <-9.262506, 20.393597, 6.488233>, <-8.262506, 20.393597, 6.488233>, <-3.631253, 17.590139, 6.553946>, 
      <-7.781918, 18.243695, 11.742328>, <-9.262506, 21.393597, 11.676615>, <-8.262506, 21.393597, 11.676615>, <-3.931434, 18.993832, 11.742328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-4.622599, -30.075748, 11.808041>, <-7.366842, -39.090831, 11.808041>, <-6.366842, -39.090831, 11.808041>, <-1.430555, -26.139258, 11.808041>, 
      <-4.622599, -29.075748, 6.619659>, <-7.366842, -38.090831, 6.619659>, <-6.366842, -38.090831, 6.619659>, <-1.430555, -25.139258, 6.619659>, 
      <-4.622599, -28.075748, 2.952010>, <-7.366842, -37.090831, 2.952010>, <-6.366842, -37.090831, 2.952010>, <-1.430555, -24.139258, 2.952010>, 
      <-4.370072, -24.978670, 1.476005>, <-7.300965, -34.927008, 1.476005>, <-6.300965, -34.927008, 1.476005>, <-1.397616, -22.557346, 1.476005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-4.370072, -24.978670, 1.476005>, <-7.300965, -34.927008, 1.476005>, <-6.300965, -34.927008, 1.476005>, <-1.397616, -22.557346, 1.476005>, 
      <-4.117544, -21.881592, 0.000000>, <-7.235088, -32.763184, 0.000000>, <-6.235088, -32.763184, 0.000000>, <-1.364678, -20.975434, 0.000000>, 
      <-4.117544, -20.881592, 0.000000>, <-7.235088, -31.763184, 0.000000>, <-6.235088, -31.763184, 0.000000>, <-1.364678, -19.975434, 0.000000>, 
      <-2.058772, -14.440796, 0.000000>, <-3.117544, -19.881592, 0.000000>, <-2.117544, -19.881592, 0.000000>, <0.817661, -13.987717, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-2.058772, -14.440796, 0.000000>, <-3.117544, -19.881592, 0.000000>, <-2.117544, -19.881592, 0.000000>, <0.817661, -13.987717, 0.000000>, 
      <0.000000, -8.000000, 0.000000>, <1.000000, -8.000000, 0.000000>, <2.000000, -8.000000, 0.000000>, <3.000000, -8.000000, 0.000000>, 
      <0.000000, -7.000000, 0.000000>, <1.000000, -7.000000, 0.000000>, <2.000000, -7.000000, 0.000000>, <3.000000, -7.000000, 0.000000>, 
      <0.000000, -6.000000, -0.029959>, <1.000000, -6.000000, -0.034239>, <2.000000, -6.000000, 0.000000>, <3.000000, -6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, -6.000000, -0.029959>, <1.000000, -6.000000, -0.034239>, <2.000000, -6.000000, 0.000000>, <3.000000, -6.000000, 0.000000>, 
      <0.000000, -5.000000, -0.068478>, <1.000000, -5.000000, -0.068478>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, 
      <0.000000, -4.000000, -0.068478>, <1.000000, -4.000000, -0.068478>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, 
      <0.000000, -3.000000, -0.064198>, <1.000000, -3.000000, -0.068478>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, -3.000000, -0.064198>, <1.000000, -3.000000, -0.068478>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, -0.068478>, <1.000000, -2.000000, -0.068478>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -1.000000, -0.068478>, <1.000000, -1.000000, -0.068478>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, 0.000000, -0.064198>, <1.000000, 0.000000, -0.068478>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -0.064198>, <1.000000, 0.000000, -0.068478>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, -0.068478>, <1.000000, 1.000000, -0.068478>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, -0.068478>, <1.000000, 2.000000, -0.068478>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, -0.064240>, <1.000000, 3.000000, -0.068478>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, 3.000000, -0.064240>, <1.000000, 3.000000, -0.068478>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>, 
      <0.000000, 4.000000, -0.068561>, <1.000000, 4.000000, -0.068478>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.000000>, 
      <0.000000, 5.000000, -0.068634>, <1.000000, 5.000000, -0.068478>, <2.000000, 5.000000, 0.000000>, <3.000000, 5.000000, 0.000000>, 
      <0.000000, 6.000000, -0.064276>, <1.000000, 6.000000, -0.068478>, <2.000000, 6.000000, 0.000000>, <3.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, 6.000000, -0.064276>, <1.000000, 6.000000, -0.068478>, <2.000000, 6.000000, 0.000000>, <3.000000, 6.000000, 0.000000>, 
      <0.000000, 7.000000, -0.068478>, <1.000000, 7.000000, -0.068478>, <2.000000, 7.000000, 0.000000>, <3.000000, 7.000000, 0.000000>, 
      <0.000000, 8.000000, -0.068478>, <1.000000, 8.000000, -0.068478>, <2.000000, 8.000000, 0.000000>, <3.000000, 8.000000, 0.000000>, 
      <0.000000, 9.000000, -0.064198>, <1.000000, 9.000000, -0.068478>, <2.000000, 9.000000, 0.000000>, <3.000000, 9.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.000000, 9.000000, -0.064198>, <1.000000, 9.000000, -0.068478>, <2.000000, 9.000000, 0.000000>, <3.000000, 9.000000, 0.000000>, 
      <0.000000, 10.000000, -0.068478>, <1.000000, 10.000000, -0.068478>, <2.000000, 10.000000, 0.000000>, <3.000000, 10.000000, 0.000000>, 
      <-2.695725, 12.932161, 0.000000>, <1.000000, 11.000000, 0.000000>, <2.000000, 11.000000, 3.399285>, <3.000000, 11.000000, 1.699642>, 
      <-3.161608, 14.564480, 1.644422>, <1.000000, 12.000000, 1.476005>, <2.000000, 12.000000, 3.175647>, <3.000000, 12.000000, 2.325826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-3.161608, 14.564480, 1.644422>, <1.000000, 12.000000, 1.476005>, <2.000000, 12.000000, 3.175647>, <3.000000, 12.000000, 2.325826>, 
      <-3.627490, 16.196798, 3.288844>, <1.000000, 13.000000, 2.952010>, <2.000000, 13.000000, 2.952010>, <3.000000, 13.000000, 2.952010>, 
      <-3.631253, 17.590139, 6.553946>, <1.000000, 14.786682, 6.619659>, <2.000000, 14.414043, 6.619659>, <3.000000, 14.207022, 6.619659>, 
      <-3.931434, 18.993832, 11.742328>, <0.399637, 16.594067, 11.808041>, <1.399637, 16.221428, 11.808041>, <2.699819, 15.610714, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-1.430555, -26.139258, 11.808041>, <3.505732, -13.187685, 11.808041>, <4.505732, -13.187685, 11.808041>, <5.752866, -14.158335, 12.743182>, 
      <-1.430555, -25.139258, 6.619659>, <3.505732, -12.187685, 6.619659>, <4.505732, -12.187685, 6.619659>, <5.752866, -13.093842, 6.619659>, 
      <-1.430555, -24.139258, 2.952010>, <3.505732, -11.187685, 2.952010>, <4.505732, -11.187685, 2.952010>, <5.752866, -12.093842, 2.952010>, 
      <-1.397616, -22.557346, 1.476005>, <3.505732, -10.187685, 1.476005>, <4.505732, -10.187685, 1.476005>, <5.752866, -11.093842, 1.476005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <-1.397616, -22.557346, 1.476005>, <3.505732, -10.187685, 1.476005>, <4.505732, -10.187685, 1.476005>, <5.752866, -11.093842, 1.476005>, 
      <-1.364678, -20.975434, 0.000000>, <3.505732, -9.187685, 0.000000>, <4.505732, -9.187685, 0.000000>, <5.752866, -10.093842, 0.000000>, 
      <-1.364678, -19.975434, 0.000000>, <3.505732, -8.187685, 0.000000>, <4.505732, -8.187685, 0.000000>, <5.654013, -8.550148, 0.000000>, 
      <0.817661, -13.987717, 0.000000>, <3.752866, -8.093842, 0.000000>, <4.752866, -8.093842, 0.000000>, <5.695202, -8.011464, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <0.817661, -13.987717, 0.000000>, <3.752866, -8.093842, 0.000000>, <4.752866, -8.093842, 0.000000>, <5.695202, -8.011464, 0.000000>, 
      <3.000000, -8.000000, 0.000000>, <4.000000, -8.000000, 0.000000>, <5.000000, -8.000000, 0.000000>, <5.736390, -7.472781, 0.000000>, 
      <3.000000, -7.000000, 0.000000>, <4.000000, -7.000000, 0.000000>, <5.000000, -7.000000, 0.000000>, <6.000000, -7.000000, 0.000000>, 
      <3.000000, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, <5.000000, -6.000000, 0.000000>, <5.859957, -5.991762, 0.153170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, <5.000000, -6.000000, 0.000000>, <5.859957, -5.991762, 0.153170>, 
      <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, <5.000000, -5.000000, 0.000000>, <5.719915, -4.983524, 0.306339>, 
      <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, <5.000000, -4.000000, 0.000000>, <5.719915, -3.983524, 0.306339>, 
      <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, <5.000000, -3.000000, 0.000000>, <5.719915, -2.983524, 0.306339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, <5.000000, -3.000000, 0.000000>, <5.719915, -2.983524, 0.306339>, 
      <3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.000000>, <5.000000, -2.000000, 0.000000>, <5.719915, -1.983524, 0.306339>, 
      <3.000000, -1.000000, 0.000000>, <4.000000, -1.000000, 0.000000>, <5.000000, -1.000000, 0.000000>, <5.719915, -0.983524, 0.306339>, 
      <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.000000>, <5.000000, 0.000000, 0.000000>, <5.859957, 0.008238, 0.153170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.000000>, <5.000000, 0.000000, 0.000000>, <5.859957, 0.008238, 0.153170>, 
      <3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>, <5.000000, 1.000000, 0.000000>, <6.000000, 1.000000, 0.000000>, 
      <3.000000, 2.000000, 0.000000>, <4.000000, 2.000000, 0.000000>, <5.000000, 2.000000, 0.000000>, <6.000000, 2.000000, 0.000000>, 
      <3.000000, 3.000000, 0.000000>, <4.000000, 3.000000, 0.000000>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, 3.000000, 0.000000>, <4.000000, 3.000000, 0.000000>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>, 
      <3.000000, 4.000000, 0.000000>, <4.000000, 4.000000, 0.000000>, <5.000000, 4.000000, 0.000000>, <6.000000, 4.000000, 0.000000>, 
      <3.000000, 5.000000, 0.000000>, <4.000000, 5.000000, 0.000000>, <5.000000, 5.000000, 0.000000>, <6.000000, 5.000000, 0.000000>, 
      <3.000000, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, <5.000000, 6.000000, 0.000000>, <6.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, <5.000000, 6.000000, 0.000000>, <6.000000, 6.000000, 0.000000>, 
      <3.000000, 7.000000, 0.000000>, <4.000000, 7.000000, 0.000000>, <5.000000, 7.000000, 0.000000>, <6.000000, 7.000000, 0.000000>, 
      <3.000000, 8.000000, 0.000000>, <4.000000, 8.000000, 0.000000>, <5.000000, 8.000000, 0.000000>, <6.000000, 8.000000, 0.000000>, 
      <3.000000, 9.000000, 0.000000>, <4.000000, 9.000000, 0.000000>, <5.000000, 9.000000, 0.000000>, <6.086261, 9.362296, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, 9.000000, 0.000000>, <4.000000, 9.000000, 0.000000>, <5.000000, 9.000000, 0.000000>, <6.086261, 9.362296, 0.000000>, 
      <3.000000, 10.000000, 0.000000>, <4.000000, 10.000000, 0.000000>, <5.000000, 10.000000, 0.000000>, <6.172522, 10.724591, 0.000000>, 
      <3.000000, 11.000000, 1.699642>, <4.000000, 11.000000, 0.000000>, <5.000000, 11.000000, 3.399285>, <5.516939, 10.585948, 1.699642>, 
      <3.000000, 12.000000, 2.325826>, <4.000000, 12.000000, 1.476005>, <5.000000, 12.000000, 3.175647>, <5.516939, 11.585948, 2.952010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <3.000000, 12.000000, 2.325826>, <4.000000, 12.000000, 1.476005>, <5.000000, 12.000000, 3.175647>, <5.516939, 11.585948, 2.952010>, 
      <3.000000, 13.000000, 2.952010>, <4.000000, 13.000000, 2.952010>, <5.000000, 13.000000, 2.952010>, <5.516939, 12.585948, 4.204378>, 
      <3.000000, 14.207022, 6.619659>, <4.000000, 14.000000, 6.619659>, <5.000000, 14.000000, 6.619659>, <5.516939, 13.585948, 6.619659>, 
      <2.699819, 15.610714, 11.808041>, <4.000000, 15.000000, 11.808041>, <5.000000, 15.000000, 11.808041>, <5.516939, 14.585948, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.752866, -14.158335, 12.743182>, <7.000000, -15.128985, 13.678322>, <7.003308, -12.076683, 11.808041>, <7.937406, -12.454917, 12.211119>, 
      <5.752866, -13.093842, 6.619659>, <7.000000, -14.000000, 6.619659>, <7.003308, -11.076683, 6.619659>, <7.937406, -11.454917, 7.022737>, 
      <5.752866, -12.093842, 2.952010>, <7.000000, -13.000000, 2.952010>, <7.563479, -8.692733, 2.952010>, <8.217491, -9.762942, 3.355088>, 
      <5.752866, -11.093842, 1.476005>, <7.000000, -12.000000, 1.476005>, <7.349296, -9.010781, 1.476005>, <8.003308, -9.355358, 2.524008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.752866, -11.093842, 1.476005>, <7.000000, -12.000000, 1.476005>, <7.349296, -9.010781, 1.476005>, <8.003308, -9.355358, 2.524008>, 
      <5.752866, -10.093842, 0.000000>, <7.000000, -11.000000, 0.000000>, <7.135113, -9.328828, 0.000000>, <7.789126, -8.947775, 1.692927>, 
      <5.654013, -8.550148, 0.000000>, <6.802293, -8.912611, 0.000000>, <6.805601, -8.361780, 0.000000>, <7.970357, -8.392616, 1.692927>, 
      <5.695202, -8.011464, 0.000000>, <6.637537, -7.929086, 0.000000>, <7.402801, -8.180890, 0.000000>, <8.098002, -7.973887, 1.193111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.695202, -8.011464, 0.000000>, <6.637537, -7.929086, 0.000000>, <7.402801, -8.180890, 0.000000>, <8.098002, -7.973887, 1.193111>, 
      <5.736390, -7.472781, 0.000000>, <6.472781, -6.945562, 0.000000>, <8.000000, -8.000000, 0.000000>, <8.225647, -7.555159, 0.693294>, 
      <6.000000, -7.000000, 0.000000>, <7.000000, -7.000000, 0.000000>, <8.000000, -7.000000, 0.000000>, <8.225647, -6.555159, 0.693294>, 
      <5.859957, -5.991762, 0.153170>, <6.719915, -5.983524, 0.306339>, <7.719915, -5.983524, 0.306339>, <8.044416, -5.761104, 0.499817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.859957, -5.991762, 0.153170>, <6.719915, -5.983524, 0.306339>, <7.719915, -5.983524, 0.306339>, <8.044416, -5.761104, 0.499817>, 
      <5.719915, -4.983524, 0.306339>, <6.439830, -4.967049, 0.612678>, <7.439830, -4.967049, 0.612678>, <7.863184, -4.967049, 0.306339>, 
      <5.719915, -3.983524, 0.306339>, <6.439830, -3.967049, 0.612678>, <7.439830, -3.967049, 0.612678>, <7.863184, -3.967049, 0.306339>, 
      <5.719915, -2.983524, 0.306339>, <6.439830, -2.967049, 0.612678>, <7.439830, -2.967049, 0.612678>, <7.863184, -2.967049, 0.306339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.719915, -2.983524, 0.306339>, <6.439830, -2.967049, 0.612678>, <7.439830, -2.967049, 0.612678>, <7.863184, -2.967049, 0.306339>, 
      <5.719915, -1.983524, 0.306339>, <6.439830, -1.967049, 0.612678>, <7.439830, -1.967049, 0.612678>, <7.863184, -1.967049, 0.306339>, 
      <5.719915, -0.983524, 0.306339>, <6.439830, -0.967049, 0.612678>, <7.439830, -0.967049, 0.612678>, <7.863184, -0.967049, 0.306339>, 
      <5.859957, 0.008238, 0.153170>, <6.719915, 0.016476, 0.306339>, <7.719915, 0.016476, 0.306339>, <8.431592, -0.031894, 0.596555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.859957, 0.008238, 0.153170>, <6.719915, 0.016476, 0.306339>, <7.719915, 0.016476, 0.306339>, <8.431592, -0.031894, 0.596555>, 
      <6.000000, 1.000000, 0.000000>, <7.000000, 1.000000, 0.000000>, <8.000000, 1.000000, 0.000000>, <9.000000, 0.903261, 0.886771>, 
      <6.000000, 2.000000, 0.000000>, <7.000000, 2.000000, 0.000000>, <8.000000, 2.000000, 0.000000>, <9.000000, 1.903261, 2.773176>, 
      <6.000000, 3.000000, 0.000000>, <7.000000, 3.000000, 0.000000>, <8.000000, 3.000000, 0.000000>, <9.000000, 2.951631, 2.329790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <6.000000, 3.000000, 0.000000>, <7.000000, 3.000000, 0.000000>, <8.000000, 3.000000, 0.000000>, <9.000000, 2.951631, 2.329790>, 
      <6.000000, 4.000000, 0.000000>, <7.000000, 4.000000, 0.000000>, <8.000000, 4.000000, 0.000000>, <9.000000, 4.000000, 1.886405>, 
      <6.000000, 5.000000, 0.000000>, <7.000000, 5.000000, 0.000000>, <8.000000, 5.000000, 0.000000>, <9.000000, 5.000000, 1.886405>, 
      <6.000000, 6.000000, 0.000000>, <7.000000, 6.000000, 0.000000>, <8.000000, 6.000000, 0.000000>, <9.000000, 6.000000, 1.886405>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <6.000000, 6.000000, 0.000000>, <7.000000, 6.000000, 0.000000>, <8.000000, 6.000000, 0.000000>, <9.000000, 6.000000, 1.886405>, 
      <6.000000, 7.000000, 0.000000>, <7.000000, 7.000000, 0.000000>, <8.000000, 7.000000, 0.000000>, <9.000000, 7.000000, 1.886405>, 
      <6.000000, 8.000000, 0.000000>, <7.000000, 8.000000, 0.000000>, <8.000000, 8.000000, 0.000000>, <9.000000, 8.000000, 0.000000>, 
      <6.086261, 9.362296, 0.000000>, <7.172522, 9.724591, 0.000000>, <8.172522, 9.724591, 0.000000>, <9.172522, 9.724591, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <6.086261, 9.362296, 0.000000>, <7.172522, 9.724591, 0.000000>, <8.172522, 9.724591, 0.000000>, <9.172522, 9.724591, 0.000000>, 
      <6.172522, 10.724591, 0.000000>, <7.345043, 11.449182, 0.000000>, <8.345043, 11.449182, 0.000000>, <9.345043, 11.449182, 0.000000>, 
      <5.516939, 10.585948, 1.699642>, <6.033879, 10.171896, 0.000000>, <7.378922, 11.621078, 0.000000>, <8.378922, 11.621078, 1.699642>, 
      <5.516939, 11.585948, 2.952010>, <6.033879, 11.171896, 2.728373>, <7.033879, 11.689461, 2.728373>, <7.999374, 11.896487, 3.578194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <5.516939, 11.585948, 2.952010>, <6.033879, 11.171896, 2.728373>, <7.033879, 11.689461, 2.728373>, <7.999374, 11.896487, 3.578194>, 
      <5.516939, 12.585948, 4.204378>, <6.033879, 12.171896, 5.456746>, <6.688835, 11.757844, 5.456746>, <7.619827, 12.171896, 5.456746>, 
      <5.516939, 13.585948, 6.619659>, <6.033879, 13.171896, 6.619659>, <6.688835, 12.757844, 6.619659>, <8.137392, 14.000000, 6.619659>, 
      <5.516939, 14.585948, 11.808041>, <6.033879, 14.171896, 11.808041>, <6.688835, 13.757844, 11.808041>, <8.137392, 15.000000, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <7.937406, -12.454917, 12.211119>, <8.871504, -12.833151, 12.614197>, <9.871504, -12.962136, 14.484478>, <10.294858, -12.123995, 13.146260>, 
      <7.937406, -11.454917, 7.022737>, <8.871504, -11.833151, 7.425815>, <9.871504, -11.962136, 9.296097>, <10.294858, -11.123995, 7.957878>, 
      <8.217491, -9.762942, 3.355088>, <8.871504, -10.833151, 3.758166>, <9.871504, -10.833151, 3.758166>, <10.294858, -10.059503, 3.355088>, 
      <8.003308, -9.355358, 2.524008>, <8.657321, -9.699936, 3.572010>, <9.657321, -9.699936, 3.572010>, <10.327809, -9.470688, 3.262010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <8.003308, -9.355358, 2.524008>, <8.657321, -9.699936, 3.572010>, <9.657321, -9.699936, 3.572010>, <10.327809, -9.470688, 3.262010>, 
      <7.789126, -8.947775, 1.692927>, <8.443138, -8.566721, 3.385854>, <9.443138, -8.566721, 3.385854>, <10.360760, -8.881873, 3.168932>, 
      <7.970357, -8.392616, 1.692927>, <9.135113, -8.423452, 3.385854>, <10.135113, -8.423452, 3.385854>, <10.986833, -8.458518, 3.168932>, 
      <8.098002, -7.973887, 1.193111>, <8.793204, -7.766885, 2.386221>, <9.793204, -7.766885, 2.386221>, <10.719063, -7.767943, 2.669116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <8.098002, -7.973887, 1.193111>, <8.793204, -7.766885, 2.386221>, <9.793204, -7.766885, 2.386221>, <10.719063, -7.767943, 2.669116>, 
      <8.225647, -7.555159, 0.693294>, <8.451294, -7.110318, 1.386588>, <9.451294, -7.110318, 1.386588>, <10.451294, -7.077367, 2.169299>, 
      <8.225647, -6.555159, 0.693294>, <8.451294, -6.110318, 1.386588>, <9.451294, -6.110318, 1.386588>, <10.451294, -6.077367, 2.169299>, 
      <8.044416, -5.761104, 0.499817>, <8.368916, -5.538683, 0.693294>, <9.368916, -5.538683, 0.693294>, <10.368916, -5.522208, 1.822652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <8.044416, -5.761104, 0.499817>, <8.368916, -5.538683, 0.693294>, <9.368916, -5.538683, 0.693294>, <10.368916, -5.522208, 1.822652>, 
      <7.863184, -4.967049, 0.306339>, <8.286538, -4.967049, 0.000000>, <9.286538, -4.967049, 0.000000>, <10.286538, -4.967049, 1.476005>, 
      <7.863184, -3.967049, 0.306339>, <8.286538, -3.967049, 0.000000>, <9.286538, -3.967049, 0.000000>, <10.286538, -3.967049, 1.476005>, 
      <7.863184, -2.967049, 0.306339>, <8.286538, -2.967049, 0.000000>, <9.286538, -2.967049, 1.483327>, <10.286538, -2.967049, 2.217668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <7.863184, -2.967049, 0.306339>, <8.286538, -2.967049, 0.000000>, <9.286538, -2.967049, 1.483327>, <10.286538, -2.967049, 2.217668>, 
      <7.863184, -1.967049, 0.306339>, <8.286538, -1.967049, 0.000000>, <9.286538, -1.967049, 2.966653>, <10.286538, -1.967049, 2.959332>, 
      <7.863184, -0.967049, 0.306339>, <8.286538, -0.967049, 0.000000>, <9.286538, -0.967049, 2.966653>, <10.286538, -0.967049, 4.474905>, 
      <8.431592, -0.031894, 0.596555>, <9.143269, -0.080263, 0.886771>, <9.246156, -1.060250, 3.901794>, <10.694713, -0.521887, 4.184689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <8.431592, -0.031894, 0.596555>, <9.143269, -0.080263, 0.886771>, <9.246156, -1.060250, 3.901794>, <10.694713, -0.521887, 4.184689>, 
      <9.000000, 0.903261, 0.886771>, <10.000000, 0.806523, 1.773543>, <9.205775, -1.153450, 4.836935>, <11.102887, -0.076725, 3.894473>, 
      <9.000000, 1.903261, 2.773176>, <10.000000, 1.806523, 5.546352>, <9.205775, -0.153450, 4.836935>, <11.102887, 0.923275, 3.894473>, 
      <9.000000, 2.951631, 2.329790>, <10.000000, 2.903261, 4.659581>, <10.102887, 1.842659, 3.369731>, <11.551444, 2.381022, 4.128258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <9.000000, 2.951631, 2.329790>, <10.000000, 2.903261, 4.659581>, <10.102887, 1.842659, 3.369731>, <11.551444, 2.381022, 4.128258>, 
      <9.000000, 4.000000, 1.886405>, <10.000000, 4.000000, 3.772809>, <11.000000, 3.838769, 1.902528>, <12.000000, 3.838769, 4.362043>, 
      <9.000000, 5.000000, 1.886405>, <10.000000, 5.000000, 3.772809>, <11.000000, 4.838769, 1.902528>, <12.000000, 4.838769, 4.362043>, 
      <9.000000, 6.000000, 1.886405>, <10.000000, 6.000000, 3.772809>, <11.000000, 5.838769, 1.902528>, <12.000000, 5.838769, 4.362043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <9.000000, 6.000000, 1.886405>, <10.000000, 6.000000, 3.772809>, <11.000000, 5.838769, 1.902528>, <12.000000, 5.838769, 4.362043>, 
      <9.000000, 7.000000, 1.886405>, <10.000000, 7.000000, 3.772809>, <11.000000, 6.838769, 1.902528>, <12.000000, 6.838769, 4.362043>, 
      <9.000000, 8.000000, 0.000000>, <10.000000, 8.000000, 0.000000>, <11.000000, 8.000000, 3.757104>, <12.000000, 8.000000, 4.070196>, 
      <9.172522, 9.724591, 0.000000>, <10.172522, 9.724591, 0.000000>, <11.621078, 10.311165, 3.757104>, <12.310539, 9.655582, 4.070196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <9.172522, 9.724591, 0.000000>, <10.172522, 9.724591, 0.000000>, <11.621078, 10.311165, 3.757104>, <12.310539, 9.655582, 4.070196>, 
      <9.345043, 11.449182, 0.000000>, <10.345043, 11.449182, 0.000000>, <12.242156, 12.622330, 3.757104>, <12.621078, 11.311165, 4.070196>, 
      <8.378922, 11.621078, 1.699642>, <9.378922, 11.621078, 3.399285>, <10.378922, 11.621078, 4.830562>, <11.827478, 12.207652, 4.606925>, 
      <7.999374, 11.896487, 3.578194>, <8.964870, 12.103513, 4.428015>, <9.964870, 12.103513, 3.891286>, <11.250300, 12.635180, 5.031836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <7.999374, 11.896487, 3.578194>, <8.964870, 12.103513, 4.428015>, <9.964870, 12.103513, 3.891286>, <11.250300, 12.635180, 5.031836>, 
      <7.619827, 12.171896, 5.456746>, <8.550818, 12.585948, 5.456746>, <9.550818, 12.585948, 2.952010>, <10.673122, 13.062709, 5.456746>, 
      <8.137392, 14.000000, 6.619659>, <9.585948, 15.242156, 6.619659>, <10.585948, 15.242156, 6.619659>, <10.563327, 14.018791, 6.619659>, 
      <8.137392, 15.000000, 11.808041>, <9.585948, 16.242156, 11.808041>, <10.058934, 15.978649, 11.808041>, <10.553878, 15.583388, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.294858, -12.123995, 13.146260>, <10.718212, -11.285855, 11.808041>, <11.520505, -10.989294, 11.808041>, <11.861481, -10.330270, 11.808041>, 
      <10.294858, -11.123995, 7.957878>, <10.718212, -10.285855, 6.619659>, <11.520505, -9.989294, 6.619659>, <12.520505, -9.989294, 11.808041>, 
      <10.294858, -10.059503, 3.355088>, <10.718212, -9.285855, 2.952010>, <11.718212, -9.285855, 6.619659>, <12.718212, -9.285855, 11.808041>, 
      <10.327809, -9.470688, 3.262010>, <10.998297, -9.241439, 2.952010>, <11.998297, -9.241439, 6.619659>, <12.734688, -8.895452, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.327809, -9.470688, 3.262010>, <10.998297, -9.241439, 2.952010>, <11.998297, -9.241439, 6.619659>, <12.734688, -8.895452, 11.808041>, 
      <10.360760, -8.881873, 3.168932>, <11.278382, -9.197024, 2.952010>, <12.278382, -9.197024, 6.619659>, <12.751163, -8.505049, 11.808041>, 
      <10.986833, -8.458518, 3.168932>, <11.838552, -8.493584, 2.952010>, <11.289847, -7.538000, 6.619659>, <13.080675, -7.735707, 11.808041>, 
      <10.719063, -7.767943, 2.669116>, <11.644923, -7.769000, 2.952010>, <11.870570, -7.291208, 6.619659>, <13.265985, -7.390061, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.719063, -7.767943, 2.669116>, <11.644923, -7.769000, 2.952010>, <11.870570, -7.291208, 6.619659>, <13.265985, -7.390061, 11.808041>, 
      <10.451294, -7.077367, 2.169299>, <11.451294, -7.044416, 2.952010>, <12.451294, -7.044416, 6.619659>, <13.451294, -7.044416, 11.808041>, 
      <10.451294, -6.077367, 2.169299>, <11.451294, -6.044416, 2.952010>, <12.451294, -6.044416, 6.619659>, <13.451294, -6.044416, 11.808041>, 
      <10.368916, -5.522208, 1.822652>, <11.368916, -5.505732, 2.952010>, <12.368916, -5.505732, 6.619659>, <12.594563, -5.027940, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.368916, -5.522208, 1.822652>, <11.368916, -5.505732, 2.952010>, <12.368916, -5.505732, 6.619659>, <12.594563, -5.027940, 11.808041>, 
      <10.286538, -4.967049, 1.476005>, <11.286538, -4.967049, 2.952010>, <12.286538, -4.967049, 6.619659>, <11.737832, -4.011464, 11.808041>, 
      <10.286538, -3.967049, 1.476005>, <11.286538, -3.967049, 2.952010>, <12.286538, -3.967049, 6.619659>, <11.737832, -3.011464, 11.808041>, 
      <10.286538, -2.967049, 2.217668>, <11.286538, -2.967049, 2.952010>, <12.286538, -2.967049, 6.619659>, <12.512185, -2.489257, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.286538, -2.967049, 2.217668>, <11.286538, -2.967049, 2.952010>, <12.286538, -2.967049, 6.619659>, <12.512185, -2.489257, 11.808041>, 
      <10.286538, -1.967049, 2.959332>, <11.286538, -1.967049, 2.952010>, <12.286538, -1.967049, 6.619659>, <13.286538, -1.967049, 11.808041>, 
      <10.286538, -0.967049, 4.474905>, <11.286538, -0.967049, 5.983156>, <12.286538, -0.967049, 6.619659>, <13.286538, -0.967049, 11.808041>, 
      <10.694713, -0.521887, 4.184689>, <12.143269, 0.016476, 4.467583>, <13.143269, 0.016476, 6.619659>, <14.143269, 0.016476, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <10.694713, -0.521887, 4.184689>, <12.143269, 0.016476, 4.467583>, <13.143269, 0.016476, 6.619659>, <14.143269, 0.016476, 11.808041>, 
      <11.102887, -0.076725, 3.894473>, <13.000000, 1.000000, 2.952010>, <14.000000, 1.000000, 6.619659>, <15.000000, 1.000000, 11.808041>, 
      <11.102887, 0.923275, 3.894473>, <13.000000, 2.000000, 2.952010>, <14.000000, 2.000000, 6.619659>, <11.734205, 1.643910, 10.808408>, 
      <11.551444, 2.381022, 4.128258>, <13.000000, 2.919384, 4.886784>, <14.000000, 3.000000, 6.619659>, <13.367102, 2.821955, 11.308224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <11.551444, 2.381022, 4.128258>, <13.000000, 2.919384, 4.886784>, <14.000000, 3.000000, 6.619659>, <13.367102, 2.821955, 11.308224>, 
      <12.000000, 3.838769, 4.362043>, <13.000000, 3.838769, 6.821558>, <14.000000, 4.000000, 6.619659>, <15.000000, 4.000000, 11.808041>, 
      <12.000000, 4.838769, 4.362043>, <13.000000, 4.838769, 6.821558>, <14.000000, 5.000000, 6.619659>, <15.000000, 5.000000, 11.808041>, 
      <12.000000, 5.838769, 4.362043>, <13.000000, 5.838769, 6.821558>, <14.000000, 6.000000, 6.619659>, <13.367102, 5.821955, 11.308224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <12.000000, 5.838769, 4.362043>, <13.000000, 5.838769, 6.821558>, <14.000000, 6.000000, 6.619659>, <13.367102, 5.821955, 11.308224>, 
      <12.000000, 6.838769, 4.362043>, <13.000000, 6.838769, 6.821558>, <14.000000, 7.000000, 6.619659>, <11.734205, 6.643910, 10.808408>, 
      <12.000000, 8.000000, 4.070196>, <13.000000, 8.000000, 4.383288>, <14.000000, 8.000000, 6.619659>, <15.000000, 8.000000, 11.808041>, 
      <12.310539, 9.655582, 4.070196>, <13.000000, 9.000000, 4.383288>, <14.000000, 9.000000, 6.619659>, <13.367102, 8.821955, 11.308224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <12.310539, 9.655582, 4.070196>, <13.000000, 9.000000, 4.383288>, <14.000000, 9.000000, 6.619659>, <13.367102, 8.821955, 11.308224>, 
      <12.621078, 11.311165, 4.070196>, <13.000000, 10.000000, 4.383288>, <14.000000, 10.000000, 6.619659>, <11.734205, 9.643910, 10.808408>, 
      <11.827478, 12.207652, 4.606925>, <13.276035, 12.794225, 4.383288>, <12.506864, 9.908389, 6.619659>, <13.506864, 9.908389, 11.808041>, 
      <11.250300, 12.635180, 5.031836>, <12.535731, 13.166848, 6.172385>, <12.472342, 11.438481, 6.619659>, <13.208835, 11.306728, 11.808041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0001 u_steps 3 v_steps 3,
      <11.250300, 12.635180, 5.031836>, <12.535731, 13.166848, 6.172385>, <12.472342, 11.438481, 6.619659>, <13.208835, 11.306728, 11.808041>, 
      <10.673122, 13.062709, 5.456746>, <11.795426, 13.539470, 7.961482>, <12.437820, 12.968574, 6.619659>, <12.910805, 12.705067, 11.808041>, 
      <10.563327, 14.018791, 6.619659>, <10.540707, 12.795426, 6.619659>, <12.048823, 14.188127, 6.619659>, <12.697480, 14.012456, 11.808041>, 
      <10.553878, 15.583388, 11.808041>, <11.048823, 15.188127, 11.808041>, <11.697480, 15.012456, 11.808041>, <12.881585, 14.836784, 10.460267>
    }
  }
  material {
    TheMountains
    scale <10.0, 10.0, 13.0>
  }
  scale 10.0
  translate  -0.611*z
}
#declare cuts = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 20.0, 0.005>
    translate  <-0.9725, 19.8568, -0.611>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 20.0, 0.005>
    translate  <-0.7798, 20.2337, -0.611>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 20.0, 0.005>
    translate  <-1.2202, 20.2359, -0.611>
  }
  rotate 7.0*z
}
#declare ground_cuts = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <20.0, 80.0, 1.0>
    translate  -0.611*z
  }
  object { cuts }
  material {
    TheMountains
    scale <100.0, 100.0, 130.0>
    translate <0.000000, 0.000000, -0.611000>
  }
}
union { // Hills_and_Ground
  object { BezPtch001 }
  object { ground_cuts }
}


#declare EyeAddition = difference {
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  1.0*z
    scale <0.02, 0.01, 0.04>
    translate  <0.0567, -0.2069, 0.0661>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.015, 0.001>
    translate  <0.0656, -0.2069, 0.0942>
  }
  plane { // Plane101
    z,0
    rotate <95.864578, -62.846298, -96.584969>
    translate  <0.0767, -0.220695, 0.05031>
  }
  translate  0.0065*y
}
#declare EyeBodyAndCutouts = difference {
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  1.0*z
    scale <0.063, 0.01, 0.044928>
    translate  <0.0, -0.2069, 0.059116>
  }
  plane { // Plane102
    z,0
    rotate 103.0*y
    translate  <-0.063, -0.2069, 0.05912>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.035, 0.035, 0.04>
    rotate 90.0*x
    translate  <0.0, -0.1913, 0.104>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  1.0*z
    scale <0.04, 0.015, 0.001>
    translate  <0.01, -0.2067, 0.062>
  }
  plane { // Plane103
    z,0
    rotate -93.0*y
    translate  <0.05675, -0.2069, 0.05912>
  }
  rotate -27.0*x
}
#declare EyeCurve = intersection {
  sphere { // Sphere052
    <0,0,0>,1
    scale 0.216
    translate  <0.0, 0.038892, 0.082949>
  }
  object { EyeBodyAndCutouts }
  rotate 27.0*x
}
#declare EyeAll = union {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      R2D2Glass
    }
    scale <0.0375, 0.012, 0.0375>
    translate  <0.0, -0.205, 0.1038>
  }
  object { EyeAddition }
  object { EyeCurve }
  translate  <0.0, 0.1969, -0.0591>
  material {
    R2D2BlueMetal
  }
  rotate -27.0*x
  translate  <0.0, -0.1875, 0.0591>
}
#declare CSG001 = difference {
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale 0.015489
    translate  0.0165*z
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <0.0145, 0.0145, 0.016>
    translate  0.0165*z
  }
  material {
    R2D2GrayRubber
  }
}
#declare Projector = union {
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.023
  }
  object { CSG001 }
  sphere { // Sphere053
    <0,0,0>,1
    material {
      R2D2Glass
    }
    scale <0.015, 0.015, 0.0025>
    translate  0.0228*z
  }
  material {
    R2D2MainWhite
  }
  rotate <-15.0, 15.0, 0.0>
  translate  <0.0471, 0.08158, 0.18>
}
#declare CSG135 = difference {
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale 0.015489
    translate  0.0165*z
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <0.0145, 0.0145, 0.016>
    translate  0.0165*z
  }
  material {
    R2D2GrayRubber
  }
}
#declare ProjectorRubber = difference {
  sphere { // Sphere056
    <0,0,0>,1
    scale 0.025
  }
  plane { // Plane104
    z,0
    rotate -180.0*y
    translate  0.0075*z
  }
  material {
    R2D2BlackRubber
  }
}
#declare Projector1 = union {
  sphere { // Sphere054
    <0,0,0>,1
    scale 0.023
  }
  object { CSG135 }
  sphere { // Sphere055
    <0,0,0>,1
    material {
      R2D2Glass
    }
    scale <0.015, 0.015, 0.0025>
    translate  0.0228*z
  }
  object { ProjectorRubber }
  material {
    R2D2MainWhite
  }
  rotate <90.0, 0.0, 15.0>
  translate  <0.091, -0.1851, 0.0355>
}
#declare CSG136 = difference {
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale 0.015489
    translate  0.0165*z
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <0.0145, 0.0145, 0.016>
    translate  0.0165*z
  }
  material {
    R2D2BlackRubber
  }
}
#declare Projector2 = union {
  sphere { // Sphere057
    <0,0,0>,1
    scale 0.023
  }
  object { CSG136 }
  sphere { // Sphere058
    <0,0,0>,1
    material {
      R2D2Glass
    }
    scale <0.015, 0.015, 0.0025>
    translate  0.0228*z
  }
  material {
    R2D2MainWhite
  }
  rotate <-90.0, 0.0, 15.0>
  translate  <-0.0471, 0.1934, 0.0355>
}
#declare HeadHalf = difference {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      R2D2Head
    }
    scale 0.2069
  }
  plane { // Plane105
    z,0
    material {
      R2D2Aluminum
    }
  }
}
#declare CSG144 = difference {
  sphere { // Sphere059
    <0,0,0>,1
    material {
      R2D2MainWhite
    }
    scale 0.2069
  }
  plane { // Plane001
    z,0
    material {
      R2D2MainWhite
    }
    translate  0.0491*z
  }
  plane { // Plane106
    z,0
    material {
      R2D2MainWhite
    }
    rotate 180.0*x
    translate  0.0762*z
  }
  plane { // Plane107
    z,0
    material {
      R2D2MainWhite
    }
    rotate <-90.0, 0.0, -30.0>
  }
  plane { // Plane108
    z,0
    material {
      R2D2MainWhite
    }
    rotate <90.0, 0.0, -60.0>
  }
  scale <1.00001, 1.00001, 1.0>
}
#declare HeadCutouts = difference {
  object { HeadHalf }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2MainWhite
    }
    scale <0.023, 0.01, 0.036>
    rotate <-10.0, 0.0, -25.0>
    translate  <-0.0856, -0.1756, 0.035>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Reflector
    }
    scale 0.017735
    rotate <82.5, 90.0, 0.0>
    translate  <0.0247, -0.1926, 0.0241>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Reflector
    }
    scale 0.028
    rotate <-90.0, 0.0, -15.0>
    translate  <0.0525, 0.1856, 0.0446>
  }
  object { CSG144 }
}
#declare TwoThingyCutouts = difference {
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022464, 0.01, 0.035469>
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  <0.0, -0.01, 0.03547>
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  <0.0, -0.01, -0.03547>
  }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  -0.01*y
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    scale <0.001, 0.001, 0.037>
    translate  <0.02246, -0.01, 0.0>
  }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    scale <0.001, 0.001, 0.037>
    translate  <-0.02246, -0.01, 0.0>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019, 0.01, 0.015>
    translate  <0.0, -0.001, -0.017735>
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019, 0.01, 0.015>
    translate  <0.0, -0.001, 0.01774>
  }
}
#declare TwoThingies = union {
  object { TwoThingyCutouts }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2ShinyPart
    }
    scale <0.019, 0.007, 0.015>
    translate  0.01774*z
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2ShinyPart
    }
    scale <0.019, 0.007, 0.015>
    translate  -0.01774*z
  }
  material {
    R2D2MainWhite
  }
}
#declare TwoThingyCut = difference {
  object { TwoThingies }
  plane { // Plane109
    z,0
    material {
      R2D2MainWhite
    }
    rotate -180.0*x
  }
  rotate <-5.0, 0.0, -25.0>
  translate  <-0.0839, -0.1721, 0.035>
}
#declare TwoThingyCutouts1 = difference {
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022464, 0.01, 0.035469>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  <0.0, -0.01, 0.03547>
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  <0.0, -0.01, -0.03547>
  }
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.001, 0.001>
    translate  -0.01*y
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    scale <0.001, 0.001, 0.037>
    translate  <0.02246, -0.01, 0.0>
  }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    scale <0.001, 0.001, 0.037>
    translate  <-0.02246, -0.01, 0.0>
  }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019, 0.01, 0.015>
    translate  <0.0, -0.001, -0.017735>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019, 0.01, 0.015>
    translate  <0.0, -0.001, 0.01774>
  }
}
#declare TwoThingies1 = union {
  object { TwoThingyCutouts1 }
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2ShinyPart
    }
    scale <0.019, 0.007, 0.015>
    translate  0.01774*z
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2ShinyPart
    }
    scale <0.019, 0.007, 0.015>
    translate  -0.01774*z
  }
  material {
    R2D2MainWhite
  }
}
#declare TwoThingyCut1 = difference {
  object { TwoThingies1 }
  plane { // Plane110
    z,0
    material {
      R2D2MainWhite
    }
  }
  rotate <-13.5, 0.0, -25.0>
  translate  <-0.0839, -0.1721, 0.035>
}
#declare CSG145 = difference {
  sphere { // Sphere062
    <0,0,0>,1
    material {
      R2D2MainWhite
    }
    scale 0.2069
  }
  plane { // Plane111
    z,0
    material {
      R2D2MainWhite
    }
    translate  0.0491*z
  }
  plane { // Plane112
    z,0
    material {
      R2D2MainWhite
    }
    rotate 180.0*x
    translate  0.0762*z
  }
  plane { // Plane113
    z,0
    material {
      R2D2MainWhite
    }
    rotate <-90.0, 0.0, -30.0>
  }
  plane { // Plane114
    z,0
    material {
      R2D2MainWhite
    }
    rotate <90.0, 0.0, -60.0>
  }
}
#declare CSG150 = difference {
  sphere { // Sphere063
    <0,0,0>,1
    material {
      R2D2MainWhite
    }
    scale 0.2069
  }
  plane { // Plane115
    z,0
    material {
      R2D2MainWhite
    }
    translate  0.051*z
  }
  plane { // Plane116
    z,0
    material {
      R2D2MainWhite
    }
    rotate 180.0*x
    translate  0.0743*z
  }
  plane { // Plane117
    z,0
    material {
      R2D2MainWhite
    }
    rotate <-90.0, 0.0, -31.0>
  }
  plane { // Plane118
    z,0
    material {
      R2D2MainWhite
    }
    rotate <90.0, 0.0, -59.0>
  }
  scale <1.00001, 1.00001, 1.0>
}
#declare BackShinyThing = difference {
  object { CSG145 }
  object { CSG150 }
}
#declare CSG151 = difference {
  sphere { // Sphere064
    <0,0,0>,1
    material {
      R2D2ShinySphere
    }
    scale 0.2035
  }
  plane { // Plane119
    z,0
    material {
      R2D2MainWhite
    }
    translate  0.051*z
  }
  plane { // Plane120
    z,0
    material {
      R2D2MainWhite
    }
    rotate 180.0*x
    translate  0.0743*z
  }
  plane { // Plane121
    z,0
    material {
      R2D2MainWhite
    }
    rotate <-90.0, 0.0, -31.0>
  }
  plane { // Plane122
    z,0
    material {
      R2D2MainWhite
    }
    rotate <90.0, 0.0, -59.0>
  }
  scale <1.00001, 1.00001, 1.0>
}
#declare ShinyBackThingy = union {
  object { BackShinyThing }
  object { CSG151 }
}
#declare HeadAdditions = union {
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Aluminum
      scale 44.540001
    }
    scale <0.2069, 0.2069, 0.02245>
    translate  -0.0449*z
  }
  sphere { // Sphere060
    <0,0,0>,1
    material {
      R2D2RedLens_1
    }
    scale <0.01773, 0.01773, 0.001>
    rotate <71.920029, -69.182037, 23.804077>
    translate  <0.026, -0.2031, 0.0241>
  }
  sphere { // Sphere061
    <0,0,0>,1
    material {
      R2D2YellowLens_1
    }
    scale <0.0285, 0.001, 0.0285>
    rotate <10.0, 0.0, -15.0>
    translate  <0.0548, 0.194, 0.0446>
  }
  object { ShinyBackThingy }
  sphere { // Sphere065
    <0,0,0>,1
    material {
      R2D2BlackRubber
    }
    scale <0.0175, 0.005, 0.0175>
    rotate <30.0, 0.0, -15.0>
    translate  <0.0408, 0.1752, 0.0923>
  }
  sphere { // Sphere066
    <0,0,0>,1
    material {
      R2D2BlackRubber
    }
    scale <0.0175, 0.005, 0.0175>
    rotate <30.0, 0.0, -7.0>
    translate  <0.0189, 0.1789, 0.0923>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.2069, 0.2069, 0.01796>
    translate  -0.02245*z
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Aluminum
    }
    scale <0.2069, 0.2069, 0.00449>
    translate  -0.00449*z
  }
}
#declare HeadAll = union {
  object { EyeAll }
  object { Projector }
  object { Projector1 }
  object { Projector2 }
  object { HeadCutouts }
  object { TwoThingyCut }
  object { TwoThingyCut1 }
  object { HeadAdditions }
  // Scaling fixed
  // Translation fixed
  rotate 50*z
}
#declare Tori1 = union {
  torus { // Torus024
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.181*z
  }
  torus { // Torus025
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.1221*z
  }
}
#declare TorusCuts0 = difference {
  object { Tori1 }
  plane { // Plane123
    z,0
    rotate <90.0, 0.0, -50.0>
  }
  plane { // Plane124
    z,0
    rotate <90.0, 0.0, 50.0>
  }
}
#declare Tori2 = union {
  torus { // Torus026
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.19298*z
  }
  torus { // Torus027
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.25187*z
  }
}
#declare TorusCuts1 = difference {
  object { Tori2 }
  plane { // Plane125
    z,0
    rotate <90.0, 0.0, 50.0>
  }
  plane { // Plane126
    z,0
    rotate <-90.0, 0.0, 75.0>
  }
}
#declare Tori3 = union {
  torus { // Torus028
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.19298*z
  }
  torus { // Torus029
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts2 = difference {
  object { Tori3 }
  plane { // Plane127
    z,0
    rotate <90.0, 0.0, -50.0>
  }
  plane { // Plane128
    z,0
    rotate <-90.0, 0.0, -75.0>
  }
}
#declare Tori4 = union {
  torus { // Torus030
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.26385*z
  }
  torus { // Torus031
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts3 = difference {
  object { Tori4 }
  plane { // Plane129
    z,0
    rotate <90.0, 0.0, 66.0>
  }
  plane { // Plane130
    z,0
    rotate <-90.0, 0.0, 75.0>
  }
}
#declare Tori5 = union {
  torus { // Torus032
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus033
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts4 = difference {
  object { Tori5 }
  plane { // Plane131
    z,0
    rotate <90.0, 0.0, 60.0>
  }
  plane { // Plane132
    z,0
    rotate <-90.0, 0.0, 72.0>
  }
}
#declare Tori6 = union {
  torus { // Torus034
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus035
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts5 = difference {
  object { Tori6 }
  plane { // Plane133
    z,0
    rotate <90.0, 0.0, 78.0>
  }
  plane { // Plane134
    z,0
    rotate <90.0, 0.0, -78.0>
  }
}
#declare Tori7 = union {
  torus { // Torus036
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus037
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts6 = difference {
  object { Tori7 }
  plane { // Plane135
    z,0
    rotate <-90.0, 0.0, -72.0>
  }
  plane { // Plane136
    z,0
    rotate <90.0, 0.0, -50.0>
  }
}
#declare Tori8 = union {
  torus { // Torus038
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4119*z
  }
  torus { // Torus039
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.48*z
  }
}
#declare TorusCuts7 = difference {
  object { Tori8 }
  plane { // Plane137
    z,0
    rotate <90.0, 0.0, -65.0>
  }
  plane { // Plane138
    z,0
    rotate <-90.0, 0.0, -75.0>
  }
}
#declare Tori9 = union {
  torus { // Torus040
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4119*z
  }
  torus { // Torus041
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.48*z
  }
}
#declare TorusCuts8 = difference {
  object { Tori9 }
  plane { // Plane139
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane140
    z,0
    rotate <-90.0, 0.0, -62.0>
  }
}
#declare Tori10 = union {
  torus { // Torus042
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4119*z
  }
  torus { // Torus043
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.48*z
  }
}
#declare TorusCuts9 = difference {
  object { Tori10 }
  plane { // Plane141
    z,0
    rotate <90.0, 0.0, -46.0>
  }
  plane { // Plane142
    z,0
    rotate <-90.0, 0.0, -53.0>
  }
}
#declare Tori11 = union {
  torus { // Torus044
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.07*z
  }
  torus { // Torus045
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts10 = difference {
  object { Tori11 }
  plane { // Plane143
    z,0
    rotate <90.0, 0.0, -28.0>
  }
  plane { // Plane144
    z,0
    rotate <-90.0, 0.0, -45.5>
  }
}
#declare Tori12 = union {
  torus { // Torus046
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.07*z
  }
  torus { // Torus047
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts11 = difference {
  object { Tori12 }
  plane { // Plane145
    z,0
    rotate <90.0, 0.0, 28.0>
  }
  plane { // Plane146
    z,0
    rotate <-90.0, 0.0, 45.5>
  }
}
#declare Tori13 = union {
  torus { // Torus048
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus049
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts12 = difference {
  object { Tori13 }
  plane { // Plane147
    z,0
    rotate <90.0, 0.0, -28.0>
  }
  plane { // Plane148
    z,0
    rotate <-90.0, 0.0, -44.5>
  }
}
#declare CenterCut = difference {
  cylinder { // Body2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  plane { // Plane149
    z,0
    rotate <90.0, 0.0, 78.5>
  }
  plane { // Plane150
    z,0
    rotate <90.0, 0.0, -78.5>
  }
  plane { // Plane151
    z,0
    translate  -0.3646*z
  }
  plane { // Plane152
    z,0
    rotate -180.0*x
    translate  -0.19298*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyTube = difference {
  cylinder { // Body3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body6
    <0,0,1>, <0,0,0>, 1 
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerRightOctagon = difference {
  object { BodyTube }
  plane { // Plane153
    z,0
    rotate <90.0, 0.0, -23.0>
  }
  plane { // Plane154
    z,0
    rotate <-90.0, 0.0, -42.0>
  }
  plane { // Plane155
    z,0
    translate  -0.48*z
  }
  plane { // Plane156
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  plane { // Plane157
    z,0
    rotate <45.0, 0.0, -29.333334>
    translate  -0.48*z
  }
  plane { // Plane158
    z,0
    rotate <-45.0, 0.0, -35.666668>
    translate  -0.48*z
  }
  plane { // Plane159
    z,0
    rotate <-135.0, 0.0, -35.666668>
    translate  -0.4119*z
  }
  plane { // Plane160
    z,0
    rotate <-225.0, 0.0, -29.333334>
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyTube1 = difference {
  cylinder { // Body7
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body8
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerLeftBox = difference {
  object { BodyTube1 }
  plane { // Plane161
    z,0
    rotate <90.0, 0.0, 23.0>
  }
  plane { // Plane162
    z,0
    rotate <-90.0, 0.0, 45.5>
  }
  plane { // Plane163
    z,0
    translate  -0.48*z
  }
  plane { // Plane164
    z,0
    rotate -180.0*x
    translate  -0.37658*z
  }
  material {
    R2D2Aluminum
  }
  scale 1.00001
}
#declare BodyTube2 = difference {
  cylinder { // Body9
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body10
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterCut = difference {
  object { BodyTube2 }
  plane { // Plane165
    z,0
    rotate <90.0, 0.0, -105.0>
  }
  plane { // Plane166
    z,0
    rotate <-90.0, 0.0, -130.0>
  }
  plane { // Plane167
    z,0
    translate  -0.48*z
  }
  plane { // Plane168
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyTube3 = difference {
  cylinder { // Body11
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body12
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerCenterCut = difference {
  object { BodyTube3 }
  plane { // Plane169
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  plane { // Plane170
    z,0
    rotate <-90.0, 0.0, -100.0>
  }
  plane { // Plane171
    z,0
    translate  -0.48*z
  }
  plane { // Plane172
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyTube4 = difference {
  cylinder { // Body13
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body14
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.449278>
    translate  -0.49418*z
  }
}
#declare UpperCenterCut = difference {
  object { BodyTube4 }
  plane { // Plane173
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane174
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane175
    z,0
    translate  -0.07*z
  }
  plane { // Plane176
    z,0
    rotate -180.0*x
    translate  -0.0449*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyTube11 = difference {
  cylinder { // Body25
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body26
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare BodyTube12 = difference {
  cylinder { // Body27
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body28
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper = difference {
  object { BodyTube12 }
  plane { // Plane183
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane184
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane185
    z,0
    translate  -0.0875*z
  }
  plane { // Plane186
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane187
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube13 = difference {
  cylinder { // Body29
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body30
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper1 = difference {
  object { BodyTube13 }
  plane { // Plane188
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane189
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane190
    z,0
    translate  -0.0875*z
  }
  plane { // Plane191
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane192
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  rotate -43.0*z
}
#declare BodyTube14 = difference {
  cylinder { // Body31
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body32
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper2 = difference {
  object { BodyTube14 }
  plane { // Plane193
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane194
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane195
    z,0
    translate  -0.1086*z
  }
  plane { // Plane196
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane197
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube15 = difference {
  cylinder { // Body33
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body34
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper3 = difference {
  object { BodyTube15 }
  plane { // Plane198
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane199
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane200
    z,0
    translate  -0.1086*z
  }
  plane { // Plane201
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane202
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  rotate -43.0*z
}
#declare TopSquigleCut = difference {
  object { BodyTube11 }
  plane { // Plane177
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane178
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane179
    z,0
    translate  -0.1086*z
  }
  plane { // Plane180
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane181
    z,0
    translate  -0.2069*y
    rotate <0.0, 3.0, -20.0>
    translate  -0.1086*z
  }
  plane { // Plane182
    z,0
    translate  -0.2069*y
    rotate <0.0, -183.0, -20.0>
    translate  -0.0835*z
  }
  object { TopSquigleHelper }
  object { TopSquigleHelper1 }
  object { TopSquigleHelper2 }
  object { TopSquigleHelper3 }
  material {
    R2D2BlueMetal
  }
  scale 1.01
  translate  0.0013*z
}
#declare BodyTube16 = difference {
  cylinder { // Body35
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.14*z
  }
  cylinder { // Body36
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.14*z
  }
}
#declare BodyTube17 = difference {
  cylinder { // Body37
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.14*z
  }
  cylinder { // Body38
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.14*z
  }
}
#declare TopSquigleHelper4 = difference {
  object { BodyTube17 }
  plane { // Plane209
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane210
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane211
    z,0
    translate  -0.0875*z
  }
  plane { // Plane212
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane213
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube18 = difference {
  cylinder { // Body39
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.14*z
  }
  cylinder { // Body40
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.14*z
  }
}
#declare TopSquigleHelper5 = difference {
  object { BodyTube18 }
  plane { // Plane214
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane215
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane216
    z,0
    translate  -0.0875*z
  }
  plane { // Plane217
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane218
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  rotate -43.0*z
}
#declare BodyTube19 = difference {
  cylinder { // Body41
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.14*z
  }
  cylinder { // Body42
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.14*z
  }
}
#declare TopSquigleHelper6 = difference {
  object { BodyTube19 }
  plane { // Plane219
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane220
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane221
    z,0
    translate  -0.1086*z
  }
  plane { // Plane222
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane223
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube20 = difference {
  cylinder { // Body43
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.14*z
  }
  cylinder { // Body44
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.14*z
  }
}
#declare TopSquigleHelper7 = difference {
  object { BodyTube20 }
  plane { // Plane224
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane225
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane226
    z,0
    translate  -0.1086*z
  }
  plane { // Plane227
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane228
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  rotate -43.0*z
}
#declare TopSquigleCut1 = difference {
  object { BodyTube16 }
  plane { // Plane203
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane204
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane205
    z,0
    translate  -0.1086*z
  }
  plane { // Plane206
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane207
    z,0
    translate  -0.2069*y
    rotate <0.0, 3.0, -20.0>
    translate  -0.1086*z
  }
  plane { // Plane208
    z,0
    translate  -0.2069*y
    rotate <0.0, -183.0, -20.0>
    translate  -0.0835*z
  }
  object { TopSquigleHelper4 }
  object { TopSquigleHelper5 }
  object { TopSquigleHelper6 }
  object { TopSquigleHelper7 }
  material {
    R2D2BlueMetal
  }
  scale 1.01
  rotate -180.0*y
  translate  -0.2486*z
}
#declare CSG152 = difference {
  cylinder { // Body69
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body70
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube005 = merge {
  sphere { <0.0180, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0180, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0180, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0180, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0180, 0.0130, -0.1355>, 0.0070 }
  sphere { <0.0180, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0180, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0180, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, 0.1355>, <-0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, 0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, -0.1355>, <-0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <-0.0180, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, -0.1355>, <0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0180, -0.0130, -0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, -0.1355>, <-0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, 0.1355>, <0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, -0.1355>, <-0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, 0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  box { <-0.0180, -0.0130, -0.1425> <0.0180, 0.0130, 0.1425> }
  box { <-0.0180, -0.0200, -0.1355> <0.0180, 0.0200, 0.1355> }
  box { <-0.0250, -0.0130, -0.1355> <0.0250, 0.0130, 0.1355> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.2173>
}
#declare SurfaceCut = intersection {
  object { CSG152 }
  object { RndCube005 }
  rotate 53.5*z
}
#declare CSG153 = difference {
  cylinder { // Body71
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body72
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube006 = merge {
  sphere { <0.0180, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0180, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0180, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0180, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0180, 0.0130, -0.1355>, 0.0070 }
  sphere { <0.0180, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0180, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0180, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, 0.1355>, <-0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, 0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, -0.1355>, <-0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <-0.0180, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, -0.0130, -0.1355>, <0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0180, -0.0130, -0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, -0.1355>, <-0.0180, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, 0.1355>, <0.0180, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0180, 0.0130, -0.1355>, <0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, -0.1355>, <-0.0180, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0180, 0.0130, 0.1355>, <-0.0180, -0.0130, 0.1355>, 0.0070 }
  box { <-0.0180, -0.0130, -0.1425> <0.0180, 0.0130, 0.1425> }
  box { <-0.0180, -0.0200, -0.1355> <0.0180, 0.0200, 0.1355> }
  box { <-0.0250, -0.0130, -0.1355> <0.0250, 0.0130, 0.1355> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.2173>
}
#declare SurfaceCut1 = intersection {
  object { CSG153 }
  object { RndCube006 }
  rotate -53.5*z
}
#declare CSG154 = difference {
  cylinder { // Body73
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body74
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube007 = merge {
  sphere { <0.0305, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0305, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0305, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0305, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0305, 0.0130, -0.0730>, 0.0070 }
  sphere { <0.0305, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0305, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0305, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0305, 0.0130, 0.0730>, <-0.0305, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0305, -0.0130, 0.0730>, <-0.0305, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0305, -0.0130, -0.0730>, <-0.0305, -0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0305, 0.0130, -0.0730>, <-0.0305, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0305, 0.0130, -0.0730>, <0.0305, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0305, -0.0130, -0.0730>, <0.0305, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0305, -0.0130, -0.0730>, <-0.0305, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0305, 0.0130, -0.0730>, <-0.0305, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0305, 0.0130, 0.0730>, <0.0305, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0305, 0.0130, -0.0730>, <0.0305, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0305, 0.0130, -0.0730>, <-0.0305, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0305, 0.0130, 0.0730>, <-0.0305, -0.0130, 0.0730>, 0.0070 }
  box { <-0.0305, -0.0130, -0.0800> <0.0305, 0.0130, 0.0800> }
  box { <-0.0305, -0.0200, -0.0730> <0.0305, 0.0200, 0.0730> }
  box { <-0.0375, -0.0130, -0.0730> <0.0375, 0.0130, 0.0730> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.27875>
}
#declare SurfaceCut2 = intersection {
  object { CSG154 }
  object { RndCube007 }
  rotate 27.5*z
}
#declare CSG155 = difference {
  cylinder { // Body75
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body76
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube008 = merge {
  sphere { <0.0030, 0.0130, 0.0380>, 0.0070 }
  sphere { <0.0030, -0.0130, 0.0380>, 0.0070 }
  sphere { <-0.0030, -0.0130, 0.0380>, 0.0070 }
  sphere { <-0.0030, 0.0130, 0.0380>, 0.0070 }
  sphere { <0.0030, 0.0130, -0.0380>, 0.0070 }
  sphere { <0.0030, -0.0130, -0.0380>, 0.0070 }
  sphere { <-0.0030, -0.0130, -0.0380>, 0.0070 }
  sphere { <-0.0030, 0.0130, -0.0380>, 0.0070 }
  cylinder { <0.0030, 0.0130, 0.0380>, <-0.0030, 0.0130, 0.0380>, 0.0070 }
  cylinder { <0.0030, -0.0130, 0.0380>, <-0.0030, -0.0130, 0.0380>, 0.0070 }
  cylinder { <0.0030, -0.0130, -0.0380>, <-0.0030, -0.0130, -0.0380>, 0.0070 }
  cylinder { <0.0030, 0.0130, -0.0380>, <-0.0030, 0.0130, -0.0380>, 0.0070 }
  cylinder { <0.0030, 0.0130, -0.0380>, <0.0030, 0.0130, 0.0380>, 0.0070 }
  cylinder { <0.0030, -0.0130, -0.0380>, <0.0030, -0.0130, 0.0380>, 0.0070 }
  cylinder { <-0.0030, -0.0130, -0.0380>, <-0.0030, -0.0130, 0.0380>, 0.0070 }
  cylinder { <-0.0030, 0.0130, -0.0380>, <-0.0030, 0.0130, 0.0380>, 0.0070 }
  cylinder { <0.0030, 0.0130, 0.0380>, <0.0030, -0.0130, 0.0380>, 0.0070 }
  cylinder { <0.0030, 0.0130, -0.0380>, <0.0030, -0.0130, -0.0380>, 0.0070 }
  cylinder { <-0.0030, 0.0130, -0.0380>, <-0.0030, -0.0130, -0.0380>, 0.0070 }
  cylinder { <-0.0030, 0.0130, 0.0380>, <-0.0030, -0.0130, 0.0380>, 0.0070 }
  box { <-0.0030, -0.0130, -0.0450> <0.0030, 0.0130, 0.0450> }
  box { <-0.0030, -0.0200, -0.0380> <0.0030, 0.0200, 0.0380> }
  box { <-0.0100, -0.0130, -0.0380> <0.0100, 0.0130, 0.0380> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.3142>
}
#declare SurfaceCut3 = intersection {
  object { CSG155 }
  object { RndCube008 }
  rotate -19.5*z
}
#declare BodyTube33 = difference {
  cylinder { // Body77
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body78
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerCenterCut1 = difference {
  object { BodyTube33 }
  plane { // Plane240
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  plane { // Plane241
    z,0
    rotate <-90.0, 0.0, -100.0>
  }
  plane { // Plane242
    z,0
    translate  -0.48*z
  }
  plane { // Plane243
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
  rotate -180.0*z
}
#declare BodyTube34 = difference {
  cylinder { // Body79
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body80
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerLeftBox1 = difference {
  object { BodyTube34 }
  plane { // Plane244
    z,0
    rotate <90.0, 0.0, 23.0>
  }
  plane { // Plane245
    z,0
    rotate <-90.0, 0.0, 45.5>
  }
  plane { // Plane246
    z,0
    translate  -0.48*z
  }
  plane { // Plane247
    z,0
    rotate -180.0*x
    translate  -0.37658*z
  }
  material {
    R2D2Aluminum
  }
  scale 1.00001
  rotate -180.0*z
}
#declare BodyTube35 = difference {
  cylinder { // Body81
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body82
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterCut1 = difference {
  object { BodyTube35 }
  plane { // Plane248
    z,0
    rotate <90.0, 0.0, -105.0>
  }
  plane { // Plane249
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane250
    z,0
    translate  -0.48*z
  }
  plane { // Plane251
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
  rotate -180.0*z
}
#declare BodyTube36 = difference {
  cylinder { // Body83
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body84
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterCut2 = difference {
  object { BodyTube36 }
  plane { // Plane252
    z,0
    rotate <90.0, 0.0, -105.0>
  }
  plane { // Plane253
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane254
    z,0
    translate  -0.48*z
  }
  plane { // Plane255
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale <1.00001, -1.00001, 1.00001>
}
#declare BodyTube37 = difference {
  cylinder { // Body85
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body86
    <0,0,1>, <0,0,0>, 1 
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerRightOctagon1 = difference {
  object { BodyTube37 }
  plane { // Plane256
    z,0
    rotate <90.0, 0.0, -23.0>
  }
  plane { // Plane257
    z,0
    rotate <-90.0, 0.0, -42.0>
  }
  plane { // Plane258
    z,0
    translate  -0.48*z
  }
  plane { // Plane259
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  plane { // Plane260
    z,0
    rotate <45.0, 0.0, -29.333334>
    translate  -0.48*z
  }
  plane { // Plane261
    z,0
    rotate <-45.0, 0.0, -35.666668>
    translate  -0.48*z
  }
  plane { // Plane262
    z,0
    rotate <-135.0, 0.0, -35.666668>
    translate  -0.4119*z
  }
  plane { // Plane263
    z,0
    rotate <-225.0, 0.0, -29.333334>
    translate  -0.4119*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
  rotate -180.0*z
}
#declare Tori14 = union {
  torus { // Torus050
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.07*z
  }
  torus { // Torus051
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts22 = difference {
  object { Tori14 }
  plane { // Plane286
    z,0
    rotate <90.0, 0.0, -210.0>
  }
  plane { // Plane287
    z,0
    rotate <-90.0, 0.0, -225.5>
  }
}
#declare Tori15 = union {
  torus { // Torus052
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.07*z
  }
  torus { // Torus053
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts23 = difference {
  object { Tori15 }
  plane { // Plane288
    z,0
    rotate <90.0, 0.0, 210.0>
  }
  plane { // Plane289
    z,0
    rotate <-90.0, 0.0, 225.5>
  }
}
#declare Tori16 = union {
  torus { // Torus054
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.181*z
  }
  torus { // Torus055
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.0825*z
  }
}
#declare TorusCuts24 = difference {
  object { Tori16 }
  plane { // Plane294
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane295
    z,0
    rotate <90.0, 0.0, 55.0>
  }
  rotate -180.0*z
}
#declare Tori17 = union {
  torus { // Torus056
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.19298*z
  }
  torus { // Torus057
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts25 = difference {
  object { Tori17 }
  plane { // Plane290
    z,0
    rotate <90.0, 0.0, -100.0>
  }
  plane { // Plane291
    z,0
    rotate <-90.0, 0.0, -80.0>
  }
}
#declare Tori18 = union {
  torus { // Torus058
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.19298*z
  }
  torus { // Torus059
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts26 = difference {
  object { Tori18 }
  plane { // Plane292
    z,0
    rotate <90.0, 0.0, -75.0>
  }
  plane { // Plane293
    z,0
    rotate <-90.0, 0.0, -55.0>
  }
}
#declare Tori19 = union {
  torus { // Torus060
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.19298*z
  }
  torus { // Torus061
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.3646*z
  }
}
#declare TorusCuts27 = difference {
  object { Tori19 }
  plane { // Plane296
    z,0
    rotate <90.0, 0.0, -125.0>
  }
  plane { // Plane297
    z,0
    rotate <-90.0, 0.0, -105.0>
  }
}
#declare Tori20 = union {
  torus { // Torus062
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus063
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts28 = difference {
  object { Tori20 }
  plane { // Plane298
    z,0
    rotate <90.0, 0.0, 80.0>
  }
  plane { // Plane299
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  rotate -180.0*z
}
#declare Tori21 = union {
  torus { // Torus064
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus065
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts29 = difference {
  object { Tori21 }
  plane { // Plane300
    z,0
    rotate <90.0, 0.0, 80.0>
  }
  plane { // Plane301
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  rotate -155.0*z
}
#declare Tori22 = union {
  torus { // Torus066
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.4*z
  }
  torus { // Torus067
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.37658*z
  }
}
#declare TorusCuts30 = difference {
  object { Tori22 }
  plane { // Plane302
    z,0
    rotate <90.0, 0.0, 80.0>
  }
  plane { // Plane303
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  rotate -205.0*z
}
#declare CSG156 = difference {
  cylinder { // Body99
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body100
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube009 = merge {
  sphere { <0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0800> <0.0230, 0.0130, 0.0800> }
  box { <-0.0230, -0.0200, -0.0730> <0.0230, 0.0200, 0.0730> }
  box { <-0.0300, -0.0130, -0.0730> <0.0300, 0.0130, 0.0730> }
// Attributes returned success!
  translate  <-0.0, 0.2069, 0.0>
  rotate -180.0*z
  translate  -0.2787*z
}
#declare SurfaceCut4 = intersection {
  object { CSG156 }
  object { RndCube009 }
  rotate -180.0*z
}
#declare CSG157 = difference {
  cylinder { // Body101
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body102
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube010 = merge {
  sphere { <0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0800> <0.0230, 0.0130, 0.0800> }
  box { <-0.0230, -0.0200, -0.0730> <0.0230, 0.0200, 0.0730> }
  box { <-0.0300, -0.0130, -0.0730> <0.0300, 0.0130, 0.0730> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.2787>
}
#declare SurfaceCut5 = intersection {
  object { CSG157 }
  object { RndCube010 }
  rotate -205.0*z
}
#declare CSG158 = difference {
  cylinder { // Body103
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body104
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube021 = merge {
  sphere { <0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0730>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0730>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0730>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, -0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, 0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0730>, <0.0230, -0.0130, 0.0730>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0730>, <0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0730>, <-0.0230, -0.0130, -0.0730>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0730>, <-0.0230, -0.0130, 0.0730>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0800> <0.0230, 0.0130, 0.0800> }
  box { <-0.0230, -0.0200, -0.0730> <0.0230, 0.0200, 0.0730> }
  box { <-0.0300, -0.0130, -0.0730> <0.0300, 0.0130, 0.0730> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.2787>
}
#declare SurfaceCut6 = intersection {
  object { CSG158 }
  object { RndCube021 }
  rotate -155.0*z
}
#declare CSG159 = difference {
  cylinder { // Body105
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body106
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube022 = merge {
  sphere { <0.0155, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0155, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0155, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0155, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0155, 0.0130, -0.1355>, 0.0070 }
  sphere { <0.0155, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0155, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0155, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, 0.1355>, <-0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, 0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, -0.1355>, <-0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <-0.0155, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, -0.1355>, <0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0155, -0.0130, -0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, -0.1355>, <-0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, 0.1355>, <0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, -0.1355>, <-0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, 0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  box { <-0.0155, -0.0130, -0.1425> <0.0155, 0.0130, 0.1425> }
  box { <-0.0155, -0.0200, -0.1355> <0.0155, 0.0200, 0.1355> }
  box { <-0.0225, -0.0130, -0.1355> <0.0225, 0.0130, 0.1355> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.2173>
}
#declare SurfaceCut7 = intersection {
  object { CSG159 }
  object { RndCube022 }
  rotate 127.75*z
}
#declare CSG160 = difference {
  cylinder { // Body107
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body108
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube023 = merge {
  sphere { <0.0155, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0155, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0155, -0.0130, 0.1355>, 0.0070 }
  sphere { <-0.0155, 0.0130, 0.1355>, 0.0070 }
  sphere { <0.0155, 0.0130, -0.1355>, 0.0070 }
  sphere { <0.0155, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0155, -0.0130, -0.1355>, 0.0070 }
  sphere { <-0.0155, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, 0.1355>, <-0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, 0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, -0.1355>, <-0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <-0.0155, 0.0130, -0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, -0.0130, -0.1355>, <0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0155, -0.0130, -0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, -0.1355>, <-0.0155, 0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, 0.1355>, <0.0155, -0.0130, 0.1355>, 0.0070 }
  cylinder { <0.0155, 0.0130, -0.1355>, <0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, -0.1355>, <-0.0155, -0.0130, -0.1355>, 0.0070 }
  cylinder { <-0.0155, 0.0130, 0.1355>, <-0.0155, -0.0130, 0.1355>, 0.0070 }
  box { <-0.0155, -0.0130, -0.1425> <0.0155, 0.0130, 0.1425> }
  box { <-0.0155, -0.0200, -0.1355> <0.0155, 0.0200, 0.1355> }
  box { <-0.0225, -0.0130, -0.1355> <0.0225, 0.0130, 0.1355> }
// Attributes returned success!
  translate  <0.0, -0.2069, -0.2173>
}
#declare SurfaceCut8 = intersection {
  object { CSG160 }
  object { RndCube023 }
  rotate -127.75*z
}
#declare CSG161 = difference {
  cylinder { // Body109
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.207, 0.207, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body110
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2059, 0.2059, 0.449278>
    translate  -0.49418*z
  }
}
#declare RndCube024 = merge {
  sphere { <0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0437> <0.0230, 0.0130, 0.0437> }
  box { <-0.0230, -0.0200, -0.0367> <0.0230, 0.0200, 0.0367> }
  box { <-0.0300, -0.0130, -0.0367> <0.0300, 0.0130, 0.0367> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.13175>
}
#declare CSG162 = union {
  object { RndCube024 }
  rotate -180.0*z
}
#declare RndCube025 = merge {
  sphere { <0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0437> <0.0230, 0.0130, 0.0437> }
  box { <-0.0230, -0.0200, -0.0367> <0.0230, 0.0200, 0.0367> }
  box { <-0.0300, -0.0130, -0.0367> <0.0300, 0.0130, 0.0367> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.13175>
}
#declare CSG163 = union {
  object { RndCube025 }
  rotate -191.5*z
}
#declare RndCube026 = merge {
  sphere { <0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0437> <0.0230, 0.0130, 0.0437> }
  box { <-0.0230, -0.0200, -0.0367> <0.0230, 0.0200, 0.0367> }
  box { <-0.0300, -0.0130, -0.0367> <0.0300, 0.0130, 0.0367> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.13175>
}
#declare CSG164 = union {
  object { RndCube026 }
  rotate -168.5*z
}
#declare RndCube027 = merge {
  sphere { <0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0437> <0.0230, 0.0130, 0.0437> }
  box { <-0.0230, -0.0200, -0.0367> <0.0230, 0.0200, 0.0367> }
  box { <-0.0300, -0.0130, -0.0367> <0.0300, 0.0130, 0.0367> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.13175>
}
#declare CSG165 = union {
  object { RndCube027 }
  rotate -205.0*z
}
#declare RndCube028 = merge {
  sphere { <0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, 0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, 0.0367>, 0.0070 }
  sphere { <0.0230, 0.0130, -0.0367>, 0.0070 }
  sphere { <0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, -0.0130, -0.0367>, 0.0070 }
  sphere { <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, -0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, -0.0130, -0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, -0.0130, -0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, 0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, 0.0367>, <0.0230, -0.0130, 0.0367>, 0.0070 }
  cylinder { <0.0230, 0.0130, -0.0367>, <0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, -0.0367>, <-0.0230, -0.0130, -0.0367>, 0.0070 }
  cylinder { <-0.0230, 0.0130, 0.0367>, <-0.0230, -0.0130, 0.0367>, 0.0070 }
  box { <-0.0230, -0.0130, -0.0437> <0.0230, 0.0130, 0.0437> }
  box { <-0.0230, -0.0200, -0.0367> <0.0230, 0.0200, 0.0367> }
  box { <-0.0300, -0.0130, -0.0367> <0.0300, 0.0130, 0.0367> }
// Attributes returned success!
  rotate -180.0*z
  translate  <0.0, -0.2069, -0.13175>
}
#declare CSG166 = union {
  object { RndCube028 }
  rotate -155.0*z
}
#declare CSG167 = union {
  object { CSG162 }
  object { CSG163 }
  object { CSG164 }
  object { CSG165 }
  object { CSG166 }
  rotate -180.0*z
}
#declare SurfaceCut9 = intersection {
  object { CSG161 }
  object { CSG167 }
  rotate -180.0*z
}
#declare TorusCuts31 = difference {
  torus { // Torus068
    0.2069, 0.002  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -0.07*z
  }
  plane { // Plane304
    z,0
    rotate <90.0, 0.0, 230.25>
  }
  plane { // Plane305
    z,0
    rotate <-90.0, 0.0, -50.25>
  }
}
#declare BodyTube44 = difference {
  cylinder { // Body111
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body112
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerLeftBox2 = difference {
  object { BodyTube44 }
  plane { // Plane306
    z,0
    rotate <90.0, 0.0, -11.25>
  }
  plane { // Plane307
    z,0
    rotate <-90.0, 0.0, 11.25>
  }
  plane { // Plane308
    z,0
    translate  -0.3646*z
  }
  plane { // Plane309
    z,0
    rotate -180.0*x
    translate  -0.235*z
  }
  material {
    R2D2Aluminum
  }
  scale 1.00001
}
#declare BodyTube45 = difference {
  cylinder { // Body113
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body114
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.449278>
    translate  -0.49418*z
  }
}
#declare LowerLeftBox3 = difference {
  object { BodyTube45 }
  plane { // Plane310
    z,0
    rotate <90.0, 0.0, -11.25>
  }
  plane { // Plane311
    z,0
    rotate <-90.0, 0.0, 11.25>
  }
  plane { // Plane312
    z,0
    translate  -0.3646*z
  }
  plane { // Plane313
    z,0
    rotate -180.0*x
    translate  -0.235*z
  }
  material {
    R2D2Aluminum
  }
  scale 1.00001
  rotate -180.0*z
}
#declare BodySubtractions = difference {
  cylinder { // Body1
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2MainWhite
    }
    scale <0.066, 0.066, 0.42>
    rotate -90.0*y
    translate  <0.21, 0.0, -0.1275>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.136>
    rotate -40.0*z
    translate  -0.181*z
  }
  object { TorusCuts0 }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.136>
    rotate 40.0*z
    translate  -0.181*z
  }
  object { TorusCuts1 }
  object { TorusCuts2 }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.05889>
    rotate -40.0*z
    translate  -0.25187*z
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.05889>
    rotate -15.0*z
    translate  -0.25187*z
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.17162>
    rotate 15.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.17162>
    rotate 40.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.10075>
    rotate -15.0*z
    translate  -0.3646*z
  }
  object { TorusCuts3 }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.10075>
    rotate -24.0*z
    translate  -0.3646*z
  }
  object { TorusCuts4 }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate -12.0*z
    translate  -0.4*z
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate 12.0*z
    translate  -0.4*z
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate 18.0*z
    translate  -0.4*z
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate 40.0*z
    translate  -0.4*z
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate -30.0*z
    translate  -0.4*z
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate -18.0*z
    translate  -0.4*z
  }
  object { TorusCuts5 }
  object { TorusCuts6 }
  object { TorusCuts7 }
  object { TorusCuts8 }
  object { TorusCuts9 }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 15.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 25.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 28.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 35.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 37.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0681>
    rotate 44.0*z
    translate  -0.48*z
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate 44.5*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate 62.0*z
    translate  -0.3646*z
  }
  object { TorusCuts10 }
  object { TorusCuts11 }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate -44.5*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate -62.0*z
    translate  -0.3646*z
  }
  object { TorusCuts12 }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate 44.5*z
    translate  -0.4*z
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0235>
    rotate 62.0*z
    translate  -0.4*z
  }
  object { CenterCut }
  object { LowerRightOctagon }
  object { LowerLeftBox }
  object { LeftOfCenterCut }
  object { LowerCenterCut }
  object { UpperCenterCut }
  object { TopSquigleCut }
  object { TopSquigleCut1 }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    scale <0.017, 0.07, 0.05>
    translate  <-0.2146, 0.0, -0.455>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    scale <0.017, 0.07, 0.05>
    translate  <0.2146, 0.0, -0.455>
  }
  object { SurfaceCut }
  object { SurfaceCut1 }
  object { SurfaceCut2 }
  object { SurfaceCut3 }
  object { LowerCenterCut1 }
  object { LowerLeftBox1 }
  object { LeftOfCenterCut1 }
  object { LeftOfCenterCut2 }
  object { LowerRightOctagon1 }
  object { TorusCuts22 }
  object { TorusCuts23 }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate -224.5*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate -240.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate 224.5*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.2946>
    rotate 240.0*z
    translate  -0.3646*z
  }
  object { TorusCuts24 }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0985>
    rotate -215.0*z
    translate  -0.181*z
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.0985>
    rotate -145.0*z
    translate  -0.181*z
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate -190.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate 190.0*z
    translate  -0.3646*z
  }
  object { TorusCuts25 }
  object { TorusCuts26 }
  object { TorusCuts27 }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate 195.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate 215.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate 165.0*z
    translate  -0.3646*z
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.1717>
    rotate 145.0*z
    translate  -0.3646*z
  }
  object { TorusCuts28 }
  object { TorusCuts29 }
  object { TorusCuts30 }
  object { SurfaceCut4 }
  object { SurfaceCut5 }
  object { SurfaceCut6 }
  object { SurfaceCut7 }
  object { SurfaceCut8 }
  object { SurfaceCut9 }
  object { TorusCuts31 }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.4241>
    rotate 140.25*z
    translate  -0.4941*z
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  <0.0, -103.449995, 0.0>
    material {
      R2D2BodyMain
    }
    scale <0.001, 0.002, 0.4241>
    rotate 220.25*z
    translate  -0.4941*z
  }
  object { LowerLeftBox2 }
  object { LowerLeftBox3 }
  material {
    R2D2BodyMain
  }
}
#declare RndCube001 = merge {
  sphere { <0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, 0.0080, -0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  box { <-0.0155, -0.0080, -0.0400> <0.0155, 0.0080, 0.0400> }
  box { <-0.0155, -0.0250, -0.0230> <0.0155, 0.0250, 0.0230> }
  box { <-0.0325, -0.0080, -0.0230> <0.0325, 0.0080, 0.0230> }
// Attributes returned success!
  material {
    R2D2BlackRubber
  }
  translate  <0.0, -0.2, -0.2361>
}
#declare RndCube002 = merge {
  sphere { <0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, 0.0080, -0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  box { <-0.0155, -0.0080, -0.0400> <0.0155, 0.0080, 0.0400> }
  box { <-0.0155, -0.0250, -0.0230> <0.0155, 0.0250, 0.0230> }
  box { <-0.0325, -0.0080, -0.0230> <0.0325, 0.0080, 0.0230> }
// Attributes returned success!
  material {
    R2D2BlackRubber
  }
  translate  <0.0, -0.2, -0.322>
}
#declare CenterCut1 = difference {
  cylinder { // Body15
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  plane { // Plane229
    z,0
    rotate <90.0, 0.0, 78.5>
  }
  plane { // Plane230
    z,0
    rotate <90.0, 0.0, -78.5>
  }
  plane { // Plane231
    z,0
    translate  -0.3646*z
  }
  plane { // Plane232
    z,0
    rotate -180.0*x
    translate  -0.19298*z
  }
  object { RndCube001 }
  object { RndCube002 }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube9 = difference {
  cylinder { // Body21
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.2, 0.2, 0.449278>
    translate  -0.4942*z
  }
  cylinder { // Body22
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2BlueMetal
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.2117*z
}
#declare BodyTube6 = difference {
  cylinder { // Body16
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body17
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.449278>
    translate  -0.49418*z
  }
}
#declare BodyTube10 = difference {
  cylinder { // Body23
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body24
    <0,0,1>, <0,0,0>, 1 
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2Aluminum
  }
  scale <1.0, 1.0, 0.05>
  translate  -0.4581*z
}
#declare Cylinders = union {
  object { BodyTube9 }
  object { BodyTube6 }
  object { BodyTube10 }
}
#declare LowerLeftAddBox = difference {
  object { Cylinders }
  plane { // Plane233
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <90.0, 0.0, 23.0>
  }
  plane { // Plane234
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <-90.0, 0.0, 45.5>
  }
  plane { // Plane235
    z,0
    material {
      R2D2AlumBlueGrad
    }
    translate  -0.48*z
  }
  plane { // Plane236
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate -180.0*x
    translate  -0.37658*z
  }
  object { Cube403 }
  object { // Cube404 -> Cube403
    Cube403
    rotate -4.0*z
    translate  -0.0*z
  }
  object { // Cube405 -> Cube403
    Cube403
    rotate -8.0*z
    translate  -0.0*z
  }
  object { // Cube406 -> Cube403
    Cube403
    rotate -12.0*z
    translate  -0.0*z
  }
  object { // Cube407 -> Cube403
    Cube403
    rotate -16.0*z
    translate  -0.0*z
  }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -10.345, 0.0>
    scale <0.032, 0.02, 0.006>
    rotate -56.0*z
    translate  -0.4684*z
  }
  material {
    R2D2Aluminum
  }
}
#declare BodyTube7 = difference {
  cylinder { // Body18
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body19
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterAddCut = difference {
  object { BodyTube7 }
  plane { // Plane237
    z,0
    rotate <90.0, 0.0, -105.0>
  }
  plane { // Plane238
    z,0
    rotate <-90.0, 0.0, -130.0>
  }
  plane { // Plane239
    z,0
    translate  -0.48*z
  }
  plane { // Plane264
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    scale 0.02
    rotate -32.0*z
    translate  <-0.1105, -0.1845, -0.4468>
  }
  material {
    R2D2Aluminum
  }
}
#declare BodyTube8 = difference {
  cylinder { // Body20
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body45
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare CornerCuts = difference {
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    scale <0.031, 0.005, 0.031>
    translate  <0.0, -0.2069, -0.44595>
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    scale <0.034, 0.034, 0.012>
    rotate 90.0*x
    translate  <0.0, -0.2018, -0.446>
  }
  material {
    R2D2BlueMetal
  }
  scale <1.025, 1.0, 1.0>
}
#declare FourCircleCorners = union {
  object { CircleCorner }
  object { CircleCorner1 }
  object { // CircleCorner2 -> CircleCorner1
    CircleCorner1
    scale -1.0
    rotate <180.0, 0.0, -0.0>
  }
  object { // CircleCorner3 -> CircleCorner
    CircleCorner
    scale -1.0
    rotate 180.0*x
  }
  material {
    R2D2BlueMetal
  }
}
#declare LowerCenterAddCut = difference {
  object { BodyTube8 }
  plane { // Plane265
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  plane { // Plane266
    z,0
    rotate <-90.0, 0.0, -100.0>
  }
  plane { // Plane267
    z,0
    translate  -0.48*z
  }
  plane { // Plane268
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  object { CornerCuts }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    scale <0.031775, 0.031, 0.024>
    rotate 90.0*x
    translate  <0.0, -0.1898, -0.446>
  }
  object { FourCircleCorners }
  material {
    R2D2Aluminum
  }
}
#declare BodyTube21 = difference {
  cylinder { // Body46
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body47
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare BodyTube22 = difference {
  cylinder { // Body48
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body49
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper8 = difference {
  object { BodyTube22 }
  plane { // Plane277
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane278
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane279
    z,0
    translate  -0.0875*z
  }
  plane { // Plane280
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane281
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
}
#declare BodyTube23 = difference {
  cylinder { // Body50
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body51
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper9 = difference {
  object { BodyTube23 }
  plane { // Plane282
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane283
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane284
    z,0
    translate  -0.0875*z
  }
  plane { // Plane285
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane314
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare BodyTube24 = difference {
  cylinder { // Body52
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body53
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper10 = difference {
  object { BodyTube24 }
  plane { // Plane315
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane316
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane317
    z,0
    translate  -0.1086*z
  }
  plane { // Plane318
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane319
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
}
#declare BodyTube25 = difference {
  cylinder { // Body54
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body55
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper11 = difference {
  object { BodyTube25 }
  plane { // Plane320
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane321
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane322
    z,0
    translate  -0.1086*z
  }
  plane { // Plane323
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane324
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare BodyTube26 = difference {
  cylinder { // Body56
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body57
    <0,0,1>, <0,0,0>, 1 
    scale <0.1975, 0.1975, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper12 = difference {
  object { BodyTube26 }
  plane { // Plane325
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane326
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane327
    z,0
    translate  -0.1086*z
  }
  plane { // Plane328
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane329
    z,0
    rotate 20.0*y
    translate  <0.0, 0.0, 0.2069>
    rotate <90.0, 0.0, 17.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare TopSquigleCut2 = difference {
  object { BodyTube21 }
  plane { // Plane271
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane272
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane273
    z,0
    translate  -0.1086*z
  }
  plane { // Plane274
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane275
    z,0
    translate  -0.2069*y
    rotate <0.0, 3.0, -20.0>
    translate  -0.1086*z
  }
  plane { // Plane276
    z,0
    translate  -0.2069*y
    rotate <0.0, -183.0, -20.0>
    translate  -0.0835*z
  }
  object { TopSquigleHelper8 }
  object { TopSquigleHelper9 }
  object { TopSquigleHelper10 }
  object { TopSquigleHelper11 }
  object { TopSquigleHelper12 }
  material {
    R2D2BlueMetal
  }
}
#declare BodyTube27 = difference {
  cylinder { // Body58
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body59
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare BodyTube28 = difference {
  cylinder { // Body60
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body61
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper13 = difference {
  object { BodyTube28 }
  plane { // Plane336
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane337
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane338
    z,0
    translate  -0.0875*z
  }
  plane { // Plane339
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane340
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
}
#declare BodyTube29 = difference {
  cylinder { // Body62
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body63
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper14 = difference {
  object { BodyTube29 }
  plane { // Plane341
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane342
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane343
    z,0
    translate  -0.0875*z
  }
  plane { // Plane344
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane345
    z,0
    translate  -0.2069*y
    rotate <0.0, 15.0, 23.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare BodyTube30 = difference {
  cylinder { // Body64
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body65
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper15 = difference {
  object { BodyTube30 }
  plane { // Plane346
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane347
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane348
    z,0
    translate  -0.1086*z
  }
  plane { // Plane349
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane350
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
}
#declare BodyTube31 = difference {
  cylinder { // Body66
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body67
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper16 = difference {
  object { BodyTube31 }
  plane { // Plane351
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane352
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane353
    z,0
    translate  -0.1086*z
  }
  plane { // Plane354
    z,0
    rotate -180.0*x
    translate  -0.1046*z
  }
  plane { // Plane355
    z,0
    translate  -0.2069*y
    rotate <0.0, -195.0, 23.0>
    translate  -0.1086*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare BodyTube32 = difference {
  cylinder { // Body68
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.1>
    translate  -0.17*z
  }
  cylinder { // Body87
    <0,0,1>, <0,0,0>, 1 
    scale <0.1975, 0.1975, 0.1>
    translate  -0.17*z
  }
}
#declare TopSquigleHelper17 = difference {
  object { BodyTube32 }
  plane { // Plane356
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane357
    z,0
    rotate <-90.0, 0.0, -73.0>
  }
  plane { // Plane358
    z,0
    translate  -0.1086*z
  }
  plane { // Plane359
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane360
    z,0
    rotate 20.0*y
    translate  <0.0, 0.0, 0.2069>
    rotate <90.0, 0.0, 17.0>
    translate  -0.0835*z
  }
  material {
    R2D2BlueMetal
  }
  scale 1.0001
  rotate -43.0*z
}
#declare TopSquigleCut3 = difference {
  object { BodyTube27 }
  plane { // Plane330
    z,0
    rotate <90.0, 0.0, -55.0>
  }
  plane { // Plane331
    z,0
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane332
    z,0
    translate  -0.1086*z
  }
  plane { // Plane333
    z,0
    rotate -180.0*x
    translate  -0.0835*z
  }
  plane { // Plane334
    z,0
    translate  -0.2069*y
    rotate <0.0, 3.0, -20.0>
    translate  -0.1086*z
  }
  plane { // Plane335
    z,0
    translate  -0.2069*y
    rotate <0.0, -183.0, -20.0>
    translate  -0.0835*z
  }
  object { TopSquigleHelper13 }
  object { TopSquigleHelper14 }
  object { TopSquigleHelper15 }
  object { TopSquigleHelper16 }
  object { TopSquigleHelper17 }
  material {
    R2D2BlueMetal
  }
  rotate -180.0*y
  translate  -0.2474*z
}
#declare TorusUnion = union {
  torus { // Torus069
    0.2075, 0.003  rotate -x*90
    translate  -0.2741*z
  }
  torus { // Torus070
    0.2075, 0.003  rotate -x*90
    translate  -0.1981*z
  }
}
#declare TorusCuts = difference {
  object { TorusUnion }
  plane { // Plane361
    z,0
    rotate <-90.0, 0.0, -93.720001>
  }
  plane { // Plane362
    z,0
    rotate <90.0, 0.0, -86.279999>
  }
}
#declare TorusCuts13 = difference {
  torus { // Torus071
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, -4.27>
    translate  <0.002, 0.0, -0.2151>
  }
  plane { // Plane363
    z,0
    translate  -0.2151*z
  }
  plane { // Plane364
    z,0
    rotate <90.0, 0.0, -93.720001>
  }
}
#declare TorusCuts14 = difference {
  torus { // Torus072
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, -4.27>
    translate  <0.002, 0.0, -0.2571>
  }
  plane { // Plane365
    z,0
    rotate -180.0*x
    translate  -0.2571*z
  }
  plane { // Plane366
    z,0
    rotate <90.0, 0.0, -93.720001>
  }
}
#declare TorusCuts15 = difference {
  torus { // Torus073
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, 4.27>
    translate  <-0.002, 0.0, -0.2571>
  }
  plane { // Plane367
    z,0
    rotate -180.0*x
    translate  -0.2571*z
  }
  plane { // Plane368
    z,0
    rotate <-90.0, 0.0, -86.279999>
  }
}
#declare TorusCuts16 = difference {
  torus { // Torus074
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, 4.27>
    translate  <-0.002, 0.0, -0.2151>
  }
  plane { // Plane369
    z,0
    translate  -0.2151*z
  }
  plane { // Plane370
    z,0
    rotate <-90.0, 0.0, -86.279999>
  }
}
#declare RimParts = union {
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    translate  -68.966666*y
    scale <0.003, 0.003, 0.042>
    rotate -8.445*z
    translate  -0.2571*z
  }
  object { TorusCuts }
  object { TorusCuts13 }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    translate  -68.966666*y
    scale <0.003, 0.003, 0.042>
    rotate 8.445*z
    translate  -0.2571*z
  }
  object { TorusCuts14 }
  object { TorusCuts15 }
  object { TorusCuts16 }
  material {
    R2D2Aluminum
  }
}
#declare MiddleTopVent = union {
  object { RimParts }
}
#declare TorusUnion1 = union {
  torus { // Torus075
    0.2075, 0.003  rotate -x*90
    translate  -0.2741*z
  }
  torus { // Torus076
    0.2075, 0.003  rotate -x*90
    translate  -0.1981*z
  }
}
#declare TorusCuts17 = difference {
  object { TorusUnion1 }
  plane { // Plane371
    z,0
    rotate <-90.0, 0.0, -93.720001>
  }
  plane { // Plane372
    z,0
    rotate <90.0, 0.0, -86.279999>
  }
}
#declare TorusCuts18 = difference {
  torus { // Torus077
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, -4.27>
    translate  <0.002, 0.0, -0.2151>
  }
  plane { // Plane373
    z,0
    translate  -0.2151*z
  }
  plane { // Plane374
    z,0
    rotate <90.0, 0.0, -93.720001>
  }
}
#declare TorusCuts19 = difference {
  torus { // Torus078
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, -4.27>
    translate  <0.002, 0.0, -0.2571>
  }
  plane { // Plane375
    z,0
    rotate -180.0*x
    translate  -0.2571*z
  }
  plane { // Plane376
    z,0
    rotate <90.0, 0.0, -93.720001>
  }
}
#declare TorusCuts20 = difference {
  torus { // Torus079
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, 4.27>
    translate  <-0.002, 0.0, -0.2571>
  }
  plane { // Plane377
    z,0
    rotate -180.0*x
    translate  -0.2571*z
  }
  plane { // Plane378
    z,0
    rotate <-90.0, 0.0, -86.279999>
  }
}
#declare TorusCuts21 = difference {
  torus { // Torus080
    0.017, 0.003  rotate -x*90
    translate  <0.0, 0.0, -0.2069>
    rotate <-90.0, 0.0, 4.27>
    translate  <-0.002, 0.0, -0.2151>
  }
  plane { // Plane379
    z,0
    translate  -0.2151*z
  }
  plane { // Plane380
    z,0
    rotate <-90.0, 0.0, -86.279999>
  }
}
#declare RimParts1 = union {
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    translate  -68.966666*y
    scale <0.003, 0.003, 0.042>
    rotate -8.445*z
    translate  -0.2571*z
  }
  object { TorusCuts17 }
  object { TorusCuts18 }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    translate  -68.966666*y
    scale <0.003, 0.003, 0.042>
    rotate 8.445*z
    translate  -0.2571*z
  }
  object { TorusCuts19 }
  object { TorusCuts20 }
  object { TorusCuts21 }
}
#declare MiddleLowerVent = union {
  object { RimParts1 }
  material {
    R2D2Aluminum
  }
  translate  -0.0859*z
}
#declare VentUnion = union {
  object { VentOne }
  object { // VentOne1 -> VentOne
    VentOne
    rotate -0.0*x
    translate  -0.018*z
  }
  object { // VentOne2 -> VentOne
    VentOne
    rotate -0.0*x
    translate  -0.036*z
  }
  object { // VentOne3 -> VentOne
    VentOne
    rotate -0.0*x
    translate  -0.054*z
  }
}
#declare RndCube003 = merge {
  sphere { <0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, 0.0080, -0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  box { <-0.0155, -0.0080, -0.0400> <0.0155, 0.0080, 0.0400> }
  box { <-0.0155, -0.0250, -0.0230> <0.0155, 0.0250, 0.0230> }
  box { <-0.0325, -0.0080, -0.0230> <0.0325, 0.0080, 0.0230> }
// Attributes returned success!
  translate  <0.0, -0.2, -0.2361>
}
#declare VentCut = intersection {
  object { VentUnion }
  object { RndCube003 }
  material {
    R2D2Aluminum
  }
}
#declare VentUnion1 = union {
  object { VentOne4 }
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0075, 0.002, 0.042>
    translate  <0.0257, -0.2072, -0.2361>
  }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0075, 0.002, 0.042>
    translate  <-0.0257, -0.2072, -0.2361>
  }
  object { // VentOne5 -> VentOne4
    VentOne4
    rotate -0.0*x
    translate  -0.018*z
  }
  object { // VentOne6 -> VentOne4
    VentOne4
    rotate -0.0*x
    translate  -0.036*z
  }
  object { // VentOne7 -> VentOne4
    VentOne4
    rotate -0.0*x
    translate  -0.054*z
  }
  translate  0.0115*y
}
#declare RndCube004 = merge {
  sphere { <0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, 0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, 0.0230>, 0.0170 }
  sphere { <0.0155, 0.0080, -0.0230>, 0.0170 }
  sphere { <0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, -0.0080, -0.0230>, 0.0170 }
  sphere { <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, -0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, -0.0080, -0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, -0.0080, -0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, 0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, 0.0230>, <0.0155, -0.0080, 0.0230>, 0.0170 }
  cylinder { <0.0155, 0.0080, -0.0230>, <0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, -0.0230>, <-0.0155, -0.0080, -0.0230>, 0.0170 }
  cylinder { <-0.0155, 0.0080, 0.0230>, <-0.0155, -0.0080, 0.0230>, 0.0170 }
  box { <-0.0155, -0.0080, -0.0400> <0.0155, 0.0080, 0.0400> }
  box { <-0.0155, -0.0250, -0.0230> <0.0155, 0.0250, 0.0230> }
  box { <-0.0325, -0.0080, -0.0230> <0.0325, 0.0080, 0.0230> }
// Attributes returned success!
  translate  <0.0, -0.2, -0.2361>
}
#declare VentCut1 = intersection {
  object { VentUnion1 }
  object { RndCube004 }
  material {
    R2D2Aluminum
  }
  translate  -0.0859*z
}
#declare SixCubes = union {
  object { OneCubeSet }
  object { // OneCubeSet1 -> OneCubeSet
    OneCubeSet
    translate  -0.0185*z
  }
  object { // OneCubeSet2 -> OneCubeSet
    OneCubeSet
    translate  -0.037*z
  }
  object { // OneCubeSet3 -> OneCubeSet
    OneCubeSet
    translate  -0.0555*z
  }
  object { // OneCubeSet4 -> OneCubeSet
    OneCubeSet
    translate  -0.074*z
  }
  object { // OneCubeSet5 -> OneCubeSet
    OneCubeSet
    translate  -0.0925*z
  }
  material {
    R2D2Aluminum
  }
  scale <1.75, 1.0, 1.0>
  rotate -35.0*z
}
#declare Cap = difference {
  object { Cylndr311 }
  object { // Cylndr312 -> Cylndr311
    Cylndr311
    scale <0.8, 1.2, 0.8>
    rotate 0.0*x
    translate  <0.0, 0.0415, -0.0893>
  }
  material {
    R2D2BlueMetal
  }
}
#declare Nipple = union {
  cone { // Cone003
    <0,0,0>, 0.01, <0,0,1>, 0.015
    material {
      R2D2Aluminum
    }
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { Cap }
}
#declare Wedge = intersection {
  object { WedgePlaneCuts }
  cone { // Cone004
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  material {
    R2D2Aluminum
  }
}
#declare Wedge1 = intersection {
  cone { // Cone006
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { // WedgePlaneCuts3 -> WedgePlaneCuts
    WedgePlaneCuts
    scale -1.0
    rotate -180.0*z
    translate  -0.892*z
  }
  material {
    R2D2Aluminum
  }
}
#declare Wedge2 = intersection {
  object { WedgePlaneCuts1 }
  cone { // Cone007
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  material {
    R2D2Aluminum
  }
}
#declare Wedge3 = intersection {
  cone { // Cone008
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { // WedgePlaneCuts5 -> WedgePlaneCuts1
    WedgePlaneCuts1
    rotate -0.0*x
  }
  material {
    R2D2Aluminum
  }
  scale -1.0
  rotate -180.0*x
}
#declare Wedges = union {
  object { Wedge }
  object { Wedge1 }
  object { Wedge2 }
  object { Wedge3 }
}
#declare CSG168 = difference {
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.015>
    rotate 90.0*x
    translate  <0.0, -0.185, -0.446>
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    scale <0.019, 0.019, 0.018>
    rotate 90.0*x
    translate  <0.0, -0.1856, -0.446>
  }
  rotate 57.5*z
  material {
    R2D2Aluminum
  }
}
#declare BodyTube38 = difference {
  cylinder { // Body88
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.19, 0.19, 0.449278>
    translate  -0.4942*z
  }
  cylinder { // Body89
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2BlueMetal
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.2117*z
}
#declare BodyTube39 = difference {
  cylinder { // Body90
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body91
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.449278>
    translate  -0.49418*z
  }
}
#declare BodyTube40 = difference {
  cylinder { // Body92
    <0,0,1>, <0,0,0>, 1 
    scale <0.195, 0.195, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body93
    <0,0,1>, <0,0,0>, 1 
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2Aluminum
  }
  scale <1.0, 1.0, 0.05>
  translate  -0.4581*z
}
#declare Cylinders1 = union {
  object { BodyTube38 }
  object { BodyTube39 }
  object { BodyTube40 }
}
#declare LowerLeftAddBox1 = difference {
  object { Cylinders1 }
  plane { // Plane385
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <90.0, 0.0, 23.0>
  }
  plane { // Plane386
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <-90.0, 0.0, 45.5>
  }
  plane { // Plane387
    z,0
    material {
      R2D2AlumBlueGrad
    }
    translate  -0.48*z
  }
  plane { // Plane388
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate -180.0*x
    translate  -0.37658*z
  }
  box { // Cube423
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, -9.75, 0.0>
    material {
      R2D2AlumBlueGrad
      translate <0.003000, -8.750000, 0.000000>
    }
    scale <0.004, 0.02, 0.037>
    rotate -48.0*z
    translate  -0.42*z
  }
  object { // Cube424 -> Cube403
    Cube403
    rotate -4.0*z
    translate  -0.0*z
  }
  object { // Cube425 -> Cube403
    Cube403
    rotate -8.0*z
    translate  -0.0*z
  }
  object { // Cube426 -> Cube403
    Cube403
    rotate -12.0*z
    translate  -0.0*z
  }
  object { // Cube427 -> Cube403
    Cube403
    rotate -16.0*z
    translate  -0.0*z
  }
  box { // Cube428
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -10.345, 0.0>
    scale <0.032, 0.02, 0.006>
    rotate -56.0*z
    translate  -0.4684*z
  }
  material {
    R2D2Aluminum
  }
  rotate -180.0*z
}
#declare BodyTube41 = difference {
  cylinder { // Body94
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body95
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterAddCut1 = difference {
  object { BodyTube41 }
  plane { // Plane389
    z,0
    rotate <90.0, 0.0, -110.0>
  }
  plane { // Plane390
    z,0
    rotate <-90.0, 0.0, -130.0>
  }
  plane { // Plane391
    z,0
    translate  -0.48*z
  }
  plane { // Plane392
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  box { // Cube429
    <-1, -1, -1>, <1, 1, 1>
    scale 0.02
    rotate -32.0*z
    translate  <-0.1105, -0.1845, -0.4468>
  }
  material {
    R2D2Aluminum
  }
  rotate -175.0*z
}
#declare BodyTube42 = difference {
  cylinder { // Body96
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body97
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare LeftOfCenterAddCut2 = difference {
  object { BodyTube42 }
  plane { // Plane393
    z,0
    rotate <90.0, 0.0, -110.0>
  }
  plane { // Plane394
    z,0
    rotate <-90.0, 0.0, -130.0>
  }
  plane { // Plane395
    z,0
    translate  -0.48*z
  }
  plane { // Plane396
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  box { // Cube430
    <-1, -1, -1>, <1, 1, 1>
    scale 0.02
    rotate -32.0*z
    translate  <-0.1105, -0.1845, -0.4468>
  }
  material {
    R2D2Aluminum
  }
  scale <1.0, -1.0, 1.0>
  rotate -5.0*z
}
#declare BodyTube43 = difference {
  cylinder { // Body98
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body115
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BodyMain
    }
    scale <0.185, 0.185, 0.449278>
    translate  -0.49418*z
  }
}
#declare CornerCuts1 = difference {
  box { // Cube431
    <-1, -1, -1>, <1, 1, 1>
    scale <0.031, 0.005, 0.031>
    translate  <0.0, -0.2069, -0.44595>
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    scale <0.034, 0.034, 0.012>
    rotate 90.0*x
    translate  <0.0, -0.2018, -0.446>
  }
  material {
    R2D2BlueMetal
  }
  scale <1.025, 1.0, 1.0>
}
#declare CircleCorner4 = difference {
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    scale <0.028188, 0.0275, 0.025>
    rotate 90.0*x
    translate  <0.0, -0.189, -0.446>
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    scale <0.017938, 0.0175, 0.03>
    rotate 90.0*x
    translate  <0.0, -0.1881, -0.446>
  }
  plane { // Plane401
    z,0
    rotate -90.0*y
    translate  -0.0082*x
  }
  plane { // Plane402
    z,0
    translate  -0.4376*z
  }
  translate  0.446*z
  translate  -0.446*z
}
#declare FourCircleCorners1 = union {
  object { CircleCorner4 }
  object { // CircleCorner5 -> CircleCorner
    CircleCorner
    scale -1.0
    rotate 180.0*z
    translate  -0.892*z
  }
  object { // CircleCorner6 -> CircleCorner1
    CircleCorner1
    scale -1.0
    rotate <180.0, 0.0, -0.0>
  }
  object { // CircleCorner7 -> CircleCorner
    CircleCorner
    scale -1.0
    rotate 180.0*x
  }
  material {
    R2D2BlueMetal
  }
}
#declare LowerCenterAddCut1 = difference {
  object { BodyTube43 }
  plane { // Plane397
    z,0
    rotate <90.0, 0.0, -80.0>
  }
  plane { // Plane398
    z,0
    rotate <-90.0, 0.0, -100.0>
  }
  plane { // Plane399
    z,0
    translate  -0.48*z
  }
  plane { // Plane400
    z,0
    rotate -180.0*x
    translate  -0.4119*z
  }
  object { CornerCuts1 }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    scale <0.031775, 0.031, 0.024>
    rotate 90.0*x
    translate  <0.0, -0.1898, -0.446>
  }
  object { FourCircleCorners1 }
  material {
    R2D2Aluminum
  }
  rotate -180.0*z
}
#declare Cap1 = difference {
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    scale <0.01025, 0.01, 0.001>
    rotate 90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { // Cylndr320 -> Cylndr311
    Cylndr311
    scale <0.8, 1.2, 0.8>
    rotate 0.0*x
    translate  <0.0, 0.0415, -0.0893>
  }
  material {
    R2D2BlueMetal
  }
}
#declare Nipple1 = union {
  cone { // Cone009
    <0,0,0>, 0.01, <0,0,1>, 0.015
    material {
      R2D2Aluminum
    }
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { Cap1 }
  rotate -180.0*z
}
#declare WedgePlaneCuts2 = difference {
  box { // Cube432
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00825, 0.00855, 0.012>
    translate  <0.0, -0.1984, -0.4294>
  }
  plane { // Plane403
    z,0
    rotate <0.0, 95.0, 10.0>
    translate  <-0.0082, -0.1899, -0.44>
  }
  plane { // Plane404
    z,0
    rotate <0.0, -95.0, -10.0>
    translate  <0.0082, -0.1899, -0.44>
  }
  translate  0.446*z
  translate  -0.446*z
}
#declare Wedge4 = intersection {
  object { WedgePlaneCuts2 }
  cone { // Cone010
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  material {
    R2D2Aluminum
  }
}
#declare Wedge5 = intersection {
  cone { // Cone011
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { // WedgePlaneCuts4 -> WedgePlaneCuts
    WedgePlaneCuts
    scale -1.0
    rotate -180.0*z
    translate  -0.892*z
  }
  material {
    R2D2Aluminum
  }
}
#declare WedgePlaneCuts6 = difference {
  box { // Cube433
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00825, 0.00855, 0.012>
    translate  <0.0, -0.1984, -0.4294>
  }
  plane { // Plane405
    z,0
    rotate <0.0, 95.0, 10.0>
    translate  <-0.0082, -0.1899, -0.44>
  }
  plane { // Plane406
    z,0
    rotate <0.0, -95.0, -10.0>
    translate  <0.0082, -0.1899, -0.44>
  }
  translate  0.446*z
  scale <1.025, 1.0, 1.0>
  rotate -90.0*y
  translate  -0.446*z
}
#declare Wedge6 = intersection {
  object { WedgePlaneCuts6 }
  cone { // Cone012
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  material {
    R2D2Aluminum
  }
}
#declare Wedge7 = intersection {
  cone { // Cone013
    <0,0,0>, 0.01, <0,0,1>, 0.0275
    scale <1.025, 1.0, 0.0171>
    rotate -90.0*x
    translate  <0.0, -0.2069, -0.446>
  }
  object { // WedgePlaneCuts7 -> WedgePlaneCuts1
    WedgePlaneCuts1
    rotate -0.0*x
  }
  material {
    R2D2Aluminum
  }
  scale -1.0
  rotate -180.0*x
}
#declare Wedges1 = union {
  object { Wedge4 }
  object { Wedge5 }
  object { Wedge6 }
  object { Wedge7 }
  rotate -180.0*z
}
#declare CSG169 = difference {
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.015>
    rotate 90.0*x
    translate  <0.0, -0.185, -0.446>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    scale <0.019, 0.019, 0.018>
    rotate 90.0*x
    translate  <0.0, -0.1856, -0.446>
  }
  rotate 57.5*z
  material {
    R2D2Aluminum
  }
  rotate -180.0*z
}
#declare BodyTube46 = difference {
  cylinder { // Body116
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.19, 0.19, 0.449278>
    translate  -0.4942*z
  }
  cylinder { // Body117
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2BlueMetal
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.2117*z
}
#declare BodyTube47 = difference {
  cylinder { // Body118
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body119
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.449278>
    translate  -0.49418*z
  }
}
#declare BodyTube48 = difference {
  cylinder { // Body120
    <0,0,1>, <0,0,0>, 1 
    scale <0.195, 0.195, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body121
    <0,0,1>, <0,0,0>, 1 
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2Aluminum
  }
  scale <1.0, 1.0, 0.05>
  translate  -0.4581*z
}
#declare Cylinders2 = union {
  object { BodyTube46 }
  object { BodyTube47 }
  object { BodyTube48 }
}
#declare LowerLeftAddBox2 = difference {
  object { Cylinders2 }
  plane { // Plane407
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <90.0, 0.0, -11.25>
  }
  plane { // Plane408
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <-90.0, 0.0, 11.25>
  }
  plane { // Plane409
    z,0
    material {
      R2D2AlumBlueGrad
    }
    translate  -0.3646*z
  }
  plane { // Plane410
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate -180.0*x
    translate  -0.235*z
  }
  object { Cube434 }
  object { // Cube435 -> Cube434
    Cube434
    rotate -4.0*z
  }
  object { // Cube436 -> Cube434
    Cube434
    rotate -8.0*z
  }
  object { // Cube437 -> Cube434
    Cube434
    rotate -12.0*z
  }
  object { // Cube438 -> Cube434
    Cube434
    rotate -16.0*z
  }
  material {
    R2D2Aluminum
  }
}
#declare BodyTube49 = difference {
  cylinder { // Body122
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.19, 0.19, 0.449278>
    translate  -0.4942*z
  }
  cylinder { // Body123
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2BlueMetal
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.2117*z
}
#declare BodyTube50 = difference {
  cylinder { // Body124
    <0,0,1>, <0,0,0>, 1 
    scale <0.2069, 0.2069, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body125
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.449278>
    translate  -0.49418*z
  }
}
#declare BodyTube51 = difference {
  cylinder { // Body126
    <0,0,1>, <0,0,0>, 1 
    scale <0.195, 0.195, 0.449278>
    translate  -0.49418*z
  }
  cylinder { // Body127
    <0,0,1>, <0,0,0>, 1 
    scale <0.172, 0.172, 0.449278>
    translate  -0.49418*z
  }
  material {
    R2D2Aluminum
  }
  scale <1.0, 1.0, 0.05>
  translate  -0.4581*z
}
#declare Cylinders3 = union {
  object { BodyTube49 }
  object { BodyTube50 }
  object { BodyTube51 }
}
#declare LowerLeftAddBox3 = difference {
  object { Cylinders3 }
  plane { // Plane411
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <90.0, 0.0, -11.25>
  }
  plane { // Plane412
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate <-90.0, 0.0, 11.25>
  }
  plane { // Plane413
    z,0
    material {
      R2D2AlumBlueGrad
    }
    translate  -0.3646*z
  }
  plane { // Plane414
    z,0
    material {
      R2D2AlumBlueGrad
    }
    rotate -180.0*x
    translate  -0.235*z
  }
  box { // Cube439
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, -9.75, 0.0>
    material {
      R2D2AlumBlueGrad
      translate <0.003000, -8.750000, 0.000000>
    }
    scale <0.004, 0.02, 0.06>
    rotate -82.0*z
    translate  -0.2998*z
  }
  object { // Cube440 -> Cube434
    Cube434
    rotate -4.0*z
  }
  object { // Cube441 -> Cube434
    Cube434
    rotate -8.0*z
  }
  object { // Cube442 -> Cube434
    Cube434
    rotate -12.0*z
  }
  object { // Cube443 -> Cube434
    Cube434
    rotate -16.0*z
  }
  material {
    R2D2Aluminum
  }
  rotate -180.0*z
}
#declare ConeStuff = union {
  cone { // Cone001
    <0,0,0>, 0.2069, <0,0,1>, 0.18
    scale <1.0, 1.0, 0.0373>
    translate  -0.07*z
  }
  cone { // Cone002
    <0,0,0>, 0.2069, <0,0,1>, 0.18
    scale <1.0, 1.0, 0.0373>
    rotate 180.0*x
    translate  -0.0449*z
  }
  plane { // Plane415
    z,0
    rotate <-90.0, 0.0, 180.0>
    translate  -0.17*y
  }
  cylinder { // Body128
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.449278>
    translate  -0.49418*z
  }
  scale 0.99999
}
#declare UpperCenterCut1 = difference {
  object { ConeStuff }
  plane { // Plane416
    z,0
    translate  -0.07*z
  }
  plane { // Plane417
    z,0
    rotate -180.0*x
    translate  -0.0449*z
  }
  plane { // Plane418
    z,0
    scale 0.99999
    rotate <-90.0, 0.0, -125.0>
  }
  plane { // Plane419
    z,0
    scale 0.99999
    rotate <90.0, 0.0, -55.0>
  }
  material {
    R2D2BlueMetal
  }
  scale 1.00001
}
#declare BodyAdditions = union {
  object { CenterCut1 }
  object { LowerLeftAddBox }
  object { LeftOfCenterAddCut }
  object { LowerCenterAddCut }
  object { TopSquigleCut2 }
  object { TopSquigleCut3 }
  object { MiddleTopVent }
  object { MiddleLowerVent }
  object { VentCut }
  object { VentCut1 }
  object { SixCubes }
  object { Nipple }
  object { Wedges }
  object { CSG168 }
  object { LowerLeftAddBox1 }
  object { LeftOfCenterAddCut1 }
  object { LeftOfCenterAddCut2 }
  object { LowerCenterAddCut1 }
  object { Nipple1 }
  object { Wedges1 }
  object { CSG169 }
  object { LowerLeftAddBox2 }
  object { LowerLeftAddBox3 }
  object { UpperCenterCut1 }
}
#declare UnderCuts = difference {
  cone { // Cone014
    <0,0,0>, 0.18, <0,0,1>, 0.2
    scale <1.0, 1.0, 0.055>
    translate  -0.548235*z
  }
  box { // Cube444
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.05>
    rotate -22.0*y
    translate  <-0.1789, 0.0, -0.5298>
  }
  box { // Cube445
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.05>
    rotate 22.0*y
    translate  <0.1789, 0.0, -0.5298>
  }
  object { CutAngle }
  object { // CutAngle1 -> CutAngle
    CutAngle
    rotate 80.0*z
  }
}
#declare AddIt = union {
  box { // Cube448
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.190288, 0.0, -0.520349>
  }
  box { // Cube449
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.19029, 0.0, -0.52035>
  }
  rotate 82.5*z
}
#declare AddIt1 = union {
  box { // Cube450
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.190288, 0.0, -0.520349>
  }
  box { // Cube451
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.19029, 0.0, -0.52035>
  }
  rotate -82.5*z
}
#declare AddIt2 = union {
  box { // Cube452
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.190288, 0.0, -0.520349>
  }
  box { // Cube453
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.19029, 0.0, -0.52035>
  }
  rotate 60.0*z
}
#declare AddIt3 = union {
  box { // Cube454
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.190288, 0.0, -0.520349>
  }
  box { // Cube455
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.19029, 0.0, -0.52035>
  }
  rotate -60.0*z
}
#declare AddIt4 = union {
  box { // Cube456
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.178215, 0.0, -0.520349>
  }
  box { // Cube457
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.17822, 0.0, -0.52035>
  }
  rotate 45.0*z
}
#declare AddIt5 = union {
  box { // Cube458
    <-1, -1, -1>, <1, 1, 1>
    rotate 3.55*y
    scale <0.005, 0.005, 0.03>
    rotate -20.5*y
    translate  <-0.178215, 0.0, -0.520349>
  }
  box { // Cube459
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.55*y
    scale <0.005, 0.005, 0.03>
    rotate 20.5*y
    translate  <0.17822, 0.0, -0.52035>
  }
  rotate -45.0*z
}
#declare UnderTrimMain = difference {
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.19, 0.007>
    translate  -0.554683*z
  }
  box { // Cube460
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.05>
    rotate -22.0*y
    translate  <-0.187088, 0.0, -0.5298>
  }
  box { // Cube461
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.05>
    rotate 22.0*y
    translate  <0.18709, 0.0, -0.5298>
  }
}
#declare UnderPart = union {
  object { UnderCuts }
  object { AddIt }
  object { AddIt1 }
  object { AddIt2 }
  object { AddIt3 }
  object { AddIt4 }
  object { AddIt5 }
  object { UnderTrimMain }
}
#declare CutAngle2 = union {
  box { // Cube464
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate 22.0*y
    translate  <0.2382, 0.0, -0.5298>
  }
  box { // Cube465
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate -22.0*y
    translate  <-0.2382, 0.0, -0.5298>
  }
  rotate -40.0*z
}
#declare CutAngle3 = union {
  box { // Cube466
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate 22.0*y
    translate  <0.2382, 0.0, -0.5298>
  }
  box { // Cube467
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 0.05>
    rotate -22.0*y
    translate  <-0.2382, 0.0, -0.5298>
  }
  rotate 40.0*z
}
#declare UnderTrimMain1 = difference {
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.1>
    translate  -0.55985*z
  }
  box { // Cube462
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.07>
    rotate -22.0*y
    translate  <-0.175, 0.0, -0.5298>
  }
  box { // Cube463
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.225, 0.075>
    rotate 22.0*y
    translate  <0.175, 0.0, -0.5298>
  }
  object { CutAngle2 }
  object { CutAngle3 }
}
#declare ThirdFootHole = difference {
  object { UnderPart }
  object { UnderTrimMain1 }
  material {
    R2D2BodyMain
  }
}
#declare BodyAll = union {
  object { BodySubtractions }
  object { BodyAdditions }
  object { ThirdFootHole }
  // All transformations fixed
}
#declare Arms = union {
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2MainWhite
    }
    scale <0.066, 0.066, 0.43>
    rotate -90.0*y
    translate  <0.215, 0.0, -0.1275>
  }
  object { LeftArm }
  object { // LeftArm1 -> LeftArm
    LeftArm
    scale -1.0
    rotate -180.0*x
  }
  translate  0.1275*z
  // Scaling fixed
  // Rot X limited (-2.0 to   45.0)
  // Translation fixed
  rotate 45.0*x
  translate  -0.1275*z
}
#declare Conectorpivot1 = intersection {
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    scale <0.011, 0.056, 0.035>
    translate  -0.5814*z
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.04>
    rotate -90.0*y
    translate  <0.02, 0.0, -0.5164>
  }
}
#declare Conector1 = union {
  object { Conectorpivot1 }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.04>
    rotate -90.0*y
    translate  <0.02, 0.0, -0.5976>
  }
}
#declare JointBase2 = intersection {
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035, 0.0575, 0.11>
    translate  -0.5369*z
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.08>
    rotate -90.0*y
    translate  <0.04, 0.0, -0.536>
  }
  translate  0.0599*z
}
#declare Pivot1 = union {
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate 90.0*x
    translate  <-0.2698, 0.0, -0.5447>
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate -90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.012, 0.012, 0.04>
    rotate 90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  sphere { // Sphere073
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, -0.05, -0.5447>
  }
  sphere { // Sphere074
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, 0.09, -0.5447>
  }
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.007, 0.02, 0.02>
    rotate 10.0*y
    translate  <-0.2603, 0.02, -0.5245>
  }
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.01, 0.02, 0.007>
    translate  <-0.2555, 0.02, -0.5373>
  }
  material {
    R2D2Aluminum
  }
  translate  <0.2224, -0.02, 0.0>
}
#declare Pivot2 = union {
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate 90.0*x
    translate  <-0.2698, 0.0, -0.5447>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    scale <0.012, 0.012, 0.05>
    rotate -90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2BlueMetal
    }
    scale <0.012, 0.012, 0.04>
    rotate 90.0*x
    translate  <-0.2698, 0.04, -0.5447>
  }
  sphere { // Sphere075
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, -0.05, -0.5447>
  }
  sphere { // Sphere076
    <0,0,0>,1
    scale <0.012, 0.002, 0.012>
    translate  <-0.2698, 0.09, -0.5447>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.007, 0.02, 0.02>
    rotate 10.0*y
    translate  <-0.2603, 0.02, -0.5245>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    material {
      R2D2BlueMetal
    }
    scale <0.01, 0.02, 0.007>
    translate  <-0.2555, 0.02, -0.5373>
  }
  material {
    R2D2Aluminum
  }
  scale <-1.0, 1.0, 1.0>
  translate  <-0.2176, -0.02, 0.0>
}
#declare JointThirdFoot = union {
  object { Conector1 }
  object { JointBase2 }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035, 0.0575, 0.11>
    translate  -0.4428*z
  }
  object { Pivot1 }
  object { Pivot2 }
}
#declare Foot1 = difference {
  box { // Cube543
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.155715, 0.075633>
    translate  <-0.2477, 0.02, -0.6559>
  }
  plane { // Plane435
    z,0
    rotate -60.0*y
    translate  <-0.1677, 0.0, -0.7071>
  }
  plane { // Plane436
    z,0
    rotate 60.0*y
    translate  <-0.3277, 0.0, -0.7071>
  }
  plane { // Plane437
    z,0
    rotate -60.0*x
    translate  <-0.2477, -0.09, -0.7071>
  }
  plane { // Plane438
    z,0
    rotate 60.0*x
    translate  <-0.2477, 0.13, -0.7071>
  }
  plane { // Plane439
    z,0
    rotate 107.0*y
    translate  <-0.3277, 0.0, -0.7071>
  }
  plane { // Plane440
    z,0
    rotate -117.0*x
    translate  <-0.2477, -0.09, -0.7071>
  }
  plane { // Plane441
    z,0
    rotate 117.0*x
    translate  <-0.2477, 0.13, -0.7071>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 0.16, 0.02>
    translate  <-0.2477, 0.0196, -0.5999>
  }
  object { Cube545 }
  object { Cube546 }
  object { Cube547 }
  object { Cube548 }
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    scale <0.018, 0.091, 0.03>
    translate  <-0.22, 0.02, -0.723>
  }
  plane { // Plane442
    z,0
    rotate -107.0*y
    translate  <-0.1677, 0.0, -0.7071>
  }
  object { // Cube550 -> Cube545
    Cube545
    translate  <0.038, -0.0, 0.0>
  }
  object { // Cube551 -> Cube545
    Cube545
    translate  <0.076, -0.0, 0.0>
  }
  object { // Cube552 -> Cube545
    Cube545
    translate  <0.114, -0.0, 0.0>
  }
  object { // Cube553 -> Cube546
    Cube546
    rotate <-0.0, -0.0, 0.0>
    translate  <0.038, 0.0, 0.0>
  }
  object { // Cube554 -> Cube546
    Cube546
    rotate <-0.0, -0.0, 0.0>
    translate  <0.076, 0.0, 0.0>
  }
  object { // Cube555 -> Cube546
    Cube546
    rotate <-0.0, -0.0, 0.0>
    translate  <0.114, 0.0, 0.0>
  }
  object { // Cube556 -> Cube548
    Cube548
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.0, -0.05, 0.0>
  }
  object { // Cube557 -> Cube548
    Cube548
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.0, -0.1, 0.0>
  }
  object { // Cube558 -> Cube548
    Cube548
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.0, -0.15, 0.0>
  }
  object { // Cube559 -> Cube547
    Cube547
    translate  <0.0, -0.05, 0.0>
  }
  object { // Cube560 -> Cube547
    Cube547
    translate  <0.0, -0.1, 0.0>
  }
  object { // Cube561 -> Cube547
    Cube547
    translate  <0.0, -0.15, 0.0>
  }
  material {
    R2D2BodyMain
  }
  translate  <0.2477, -0.02, 0.0>
}
#declare CylinderHalf1 = difference {
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.08, 0.05>
    rotate 90.0*y
  }
  plane { // Plane443
    z,0
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    scale <0.088, 0.078, 0.00704>
    rotate -90.0*y
    translate  0.002*x
  }
  translate  <-0.075, 0.0, -0.6921>
}
#declare CylinderHalf2 = difference {
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.08, 0.05>
    rotate 90.0*y
  }
  plane { // Plane444
    z,0
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    scale <0.088, 0.078, 0.00704>
    rotate -90.0*y
    translate  0.002*x
  }
  scale <-1.0, 1.0, 1.0>
  translate  <0.0751, 0.0, -0.6921>
}
#declare FootAddCuts1 = difference {
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.025, 0.03>
    translate  -0.6529*z
  }
  object { Cube563 }
  object { // Cube564 -> Cube563
    Cube563
    rotate <0.0, -0.0, -0.0>
    translate  0.015*y
  }
  object { // Cube565 -> Cube563
    Cube563
    rotate <-0.0, -0.0, 0.0>
    translate  -0.015*y
  }
  translate  <-0.0639, 0.0, -0.01>
}
#declare FootAddCuts2 = difference {
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.025, 0.03>
    translate  -0.6529*z
  }
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0025, 0.004, 0.0075>
    translate  <-0.0101, 0.0, -0.641>
  }
  object { // Cube568 -> Cube563
    Cube563
    rotate <0.0, -0.0, -0.0>
    translate  0.015*y
  }
  object { // Cube569 -> Cube563
    Cube563
    rotate <-0.0, -0.0, 0.0>
    translate  -0.015*y
  }
  scale <-1.0, 1.0, 1.0>
  translate  <0.0639, 0.0, -0.01>
}
#declare Wheels1 = union {
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0175, 0.06, 0.03>
    translate  <0.0277, 0.0, -0.723>
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.035>
    rotate -90.0*y
    translate  <0.0452, 0.06, -0.723>
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.035>
    rotate -90.0*y
    translate  <0.0452, -0.06, -0.723>
  }
  material {
    R2D2GrayRubber
  }
}
#declare FootMetal1 = difference {
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 0.16, 0.0375>
    translate  -0.659*z
  }
  plane { // Plane445
    z,0
    rotate -117.0*x
    translate  <0.0, -0.1157, -0.707>
  }
  plane { // Plane446
    z,0
    rotate 117.0*x
    translate  <0.0, 0.1162, -0.7077>
  }
  material {
    R2D2Aluminum
  }
}
#declare ThirdFoot = union {
  object { Foot1 }
  object { CylinderHalf1 }
  object { CylinderHalf2 }
  object { FootAddCuts1 }
  object { FootAddCuts2 }
  object { Wheels1 }
  object { FootMetal1 }
  translate  0.5976*z
  // Scaling fixed
  // Rot X limited (0.0 to   25.0)
  // Translation fixed
  rotate 25.0*x
  translate  -0.5976*z
}
#declare ThirdLeg = union {
  object { JointThirdFoot }
  object { ThirdFoot }
  translate  0.3662*z
  material {
    R2D2BodyMain
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-0.3986 to   -0.1325)
  translate  -0.3986*z
}
#declare R2D2 = union {
  object { HeadAll }
  object { BodyAll }
  object { Arms }
  object { ThirdLeg }
  translate  0.1275*z
  // Scaling fixed
  // Rot X limited (-25.0 to   5.0)
  rotate -25.0*x
  translate  -1.0*x
}
union { // R2AndTracks
  object { R2D2 }
}




