// radiosity test file by G. Tran September 2000

//====================================================
// Change the font.txt file to suit your current font directory and font names !!!!!!!!!!!!!!
// This file is needed for the library
//====================================================


#include "colors.inc"
#version unofficial Megapov 0.5;
global_settings{
        max_trace_level 100
        assumed_gamma 1
        ini_option "+QR"
        radiosity{
        pretrace_start 0.16
        pretrace_end   0.01
        count 300             // CHANGE range from 20 to 150
        count 600             // CHANGE range from 20 to 150
//        count 30             // CHANGE range from 20 to 150
        nearest_count 4      // CHANGE range from 3 to 10
        error_bound 0.1        // CHANGE - range from 1 to 3 - should correspond with pretrace_end
    
        
                         //   1 : pretrace_end = 0.02
                         //   3 : pretrace_end = 0.08
                         //   use pretrace_start = 0.08
                         // you can go lower than 1, but then you probably will want to set
                         // pretrace_end to 0.01, which is really slow
        recursion_limit 1    // CHANGE
        low_error_factor 1  // leave this
        gray_threshold 0.5   // leave this
        minimum_reuse 0.015  // leave this
        brightness 2         // leave this
        adc_bailout 0.01/2   // CHANGE - use adc_bailo        
//        normal on
        }
}        
// ----------------------------------------

camera
{
  location  <0.4, 1.22, 0.1>
  direction 1.2*z
  right     4/3*x
  look_at   <1.5, 1.2,  5>
}

//sky_sphere{pigment{gradient y poly_wave 0.7 color_map{[0 rgb<165,185,251>/255][1 rgb<132,164,255>/255]}}}

sphere{
  <0,0,0>,1
  pigment{gradient y color_map{[0 rgb<165,185,251>/255][1 rgb<132,164,255>/255]}}
  finish{diffuse 0 ambient 1}
  no_shadow
  scale 1001
}
//light_source{100000*z color White*1.4 rotate -x*40 rotate y*120}

// Here is the light setup of Kari Kivisalo 
// but I divided the light intensity by 2 so it doesn't make sense anymore

#macro G(Color,g)
  rgb<pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end


#declare Gamma=2.2;
#declare SkyColor=G(<132,164,255>/255,Gamma);  // @ 15000K rgb white=6500K
#declare SunColor=G(<255,235,197>/255,Gamma);  // @ 5400K  rgb white=6500K

#declare EnergyRatio=9;  // sun/sky energy ratio
#declare EQ=1.18;         // normalisation for sun-sky colors

light_source{1000*z 
    color 0.5*SunColor*EnergyRatio/EQ
//    area_light 10*x 10*y 8,8 adaptive 2 circular

    rotate -x*40 rotate y*120
}
#declare txtSol=texture{
        pigment{Tan}
        finish{ambient 0 diffuse 1}
}               
#declare scd=1;
//#declare pigparquet=pigment{image_map{png "parquetmap"} rotate x*90 scale 0.1}
#declare pigparquet1=pigment{color Tan}
#declare pigparquet2=pigment{color Tan*0.5}
#declare txtPlancher=texture{
        pigment{
            checker pigment{pigparquet1},pigment{pigparquet2 rotate y*90}
        }   
//        normal{quilted 0.5}        
        scale 0.2
        finish{ambient 0 diffuse scd reflection 0.1}
        rotate y*45
}
#declare em=0.15;  
#declare txtMur=texture{
        pigment{White}
        finish{ambient 0 diffuse scd specular 0.02 roughness 0.01}
}
#declare txtWall=texture{
        pigment{image_map{png "wpink18"} scale 0.5}
        finish{ambient 0 diffuse scd specular 0.02 roughness 0.01}
}

#declare colBoisChaise=rgb <91,31,5>/255;
#declare colToileChaise=color rgb <0,0.291,0.598>;
#declare colClou=color Gold;
#declare txtClouChaise=texture{
        pigment{colClou}
        finish{metallic brilliance 5 reflection 0.2 ambient 0 diffuse scd specular 0.4 roughness 0.01}
}           
#declare txtBoisChaise=texture{
        pigment{
                granite
                color_map{
                        [0 colBoisChaise*0.7]
                        [0.11 colBoisChaise]
                        [0.6 colBoisChaise*1.5]
                        [1 colBoisChaise*0.4]
                }
        }
//        normal{bumps 1 scale 0.00001}
        finish{ambient 0 diffuse 1 specular scd roughness 0.01 reflection 0.1}
}                                   
#declare txtToileChaise=texture{
        pigment{
                agate
                color_map{
                        [0 colToileChaise*0.2]
                        [0.11 colToileChaise*0.6]
                        [0.2 colToileChaise*1.5]
                        [1 colToileChaise*0.4]
                }
        }
        finish{ambient 0 diffuse 1 specular 0.04 roughness 0.1}
        scale 0.2
}                                   

#declare PiedChaise1=lathe{
	cubic_spline
	26,
	<0.051,-0.005>,	<0.039,0.000>,	<0.041,0.012>,	<0.049,0.017>,	<0.051,0.026>,
	<0.055,0.042>,	<0.042,0.074>,	<0.057,0.099>,	<0.052,0.109>,	<0.062,0.114>,
	<0.067,0.123>,	<0.063,0.135>,	<0.071,0.141>,	<0.079,0.191>,	<0.072,0.226>,
	<0.063,0.264>,	<0.056,0.292>,	<0.045,0.320>,	<0.044,0.354>,	<0.043,0.376>,
	<0.046,0.390>,	<0.050,0.403>,	<0.060,0.419>,	<0.056,0.438>,	<0.055,0.454>,
	<0.055,0.458>
	scale 0.1/0.454
//	scale <1.3,1,1.3>
	scale <2,1,2>
}                                                      
#declare rPiedChaise=0.079*0.1/0.454;
#declare rPiedChaise=0.079*1.5*0.1/0.454;
#declare PiedChaise2=superellipsoid{<0.2,0.2> scale <1,0.5,1> translate y*0.5 scale <rPiedChaise,0.1,rPiedChaise>}
#declare PiedChaise3 = lathe{
	cubic_spline
	10,
	<0.031,-0.003>,	<0.032,0.000>,	<0.035,0.012>,	<0.038,0.020>,	<0.045,0.029>,
	<0.054,0.044>,	<0.049,0.064>,	<0.029,0.081>,	<0.026,0.085>,	<0.013,0.092>
	scale 0.05/0.085
	scale <0.8,1,0.8>
}
#declare yPiedChaise=0.45;
#declare PiedChaise=union{
        object{PiedChaise3}
        object{PiedChaise2 translate y*0.05}
        object{PiedChaise1 rotate x*180 translate y*0.25}
        object{PiedChaise2 translate y*0.25}
        object{PiedChaise1 translate y*0.35}
        scale yPiedChaise/0.45
}                        
#declare xChaise=yPiedChaise*1.1;
#declare zChaise=xChaise;
#declare BarreauChaise1=cylinder{0,xChaise*x,rPiedChaise}
#declare BarreauChaise2=cylinder{0,xChaise*x,rPiedChaise}

#declare BarreauChaise1 = union{
        cylinder{0,x*xChaise,rPiedChaise*0.3 translate y*0.03 translate z*0.01}
        prism{
        	cubic_spline
        	0,
        	1,
        	26,
        	<0.050,0.>,	<0.,0.010>,	<0.,0.060>,	<0.050,0.080>,	<0.100,0.100>,
        	<0.070,0.050>,	<0.110,0.050>,	<0.150,0.070>,	<0.170,0.080>,	<0.190,0.090>,
        	<0.170,0.040>,	<0.230,0.080>,	<0.290,0.040>,	<0.270,0.090>,	<0.290,0.080>,
        	<0.310,0.070>,	<0.350,0.050>,	<0.390,0.050>,	<0.360,0.100>,	<0.410,0.080>,
        	<0.460,0.060>,	<0.460,0.010>,	<0.410,0.>,	<0.050,0.>,	<0.,0.010>,<0.,0.060>
        	translate <-0.23,-0.5,-0.05>
        	scale <1,1,-1>
        	scale <xChaise*0.5/0.23,rPiedChaise*0.7,xChaise*0.3/0.23>
        	rotate x*-90                               
        	translate <xChaise*0.5,0,rPiedChaise*0.5>
	}
	
}
#declare BarreauChaise2= prism{
	cubic_spline
	0,
	xChaise,
	12,
	<0.005,0.006>,	<0.010,0.026>,	<0.020,0.033>,	<0.019,0.073>,	<0.007,0.082>,	<0.005,0.106>,
	<0.042,0.103>,	<0.031,0.046>,	<0.038,0.007>,	<0.005,0.006>,	<0.010,0.026>,	<0.020,0.033>
	translate <-0.021,0,-0.053>
	scale <1,1,-1>
	scale <0.7*rPiedChaise/0.021,1,0.3*rPiedChaise/0.021>
	rotate z*-90
	rotate -x*90
}
#declare yEl=0.02;
#declare elDossier=superellipsoid{<0.4,0.4> scale <1,0.5,1> translate y*0.5 scale <rPiedChaise,0.1,rPiedChaise>
        clipped_by{box{<-rPiedChaise*1.2,0.029,-rPiedChaise*1.2>,<rPiedChaise*1.2,0.071,rPiedChaise*1.2>}}
        scale <1,0.1/0.04,1>
        translate -y*0.03        
        }                       
#declare elDossierBout=superellipsoid{<0.4,0.4> scale <1,0.5,1> translate y*0.5 scale <rPiedChaise,0.1,rPiedChaise>
        clipped_by{box{<-rPiedChaise*1.2,0.029,-rPiedChaise*1.2>,<rPiedChaise*1.2,0.2,rPiedChaise*1.2>}}
        scale <1,0.1/0.04,1>
        translate -y*0.03        
        }                       
//#declare elDossier=box{<-rPiedChaise,0,-rPiedChaise>,<rPiedChaise,0.1,rPiedChaise>}        
#declare ClouChaise=sphere{0,rPiedChaise*0.5 scale <1,1,0.5>}
#declare BarreauDossier=superellipsoid{<0.3,0.3> scale <xChaise*0.5,rPiedChaise,rPiedChaise*0.8>}
#declare elCoussinDossier=difference{
        superellipsoid{<0.5,0.5>}
        plane{z,0 inverse}
        scale <xChaise*0.5,rPiedChaise,rPiedChaise*2>
}

#declare nEl=25;
#declare yEl=0.03;
#declare DossierChaise=union{
        #declare i=0;          
        #declare posEl=<0,0,0>;
        #declare aEl=0;
        #while (i<nEl)                                           
                #if (mod(i,3)=0)
                        union{
                                object{ClouChaise rotate -y*90 translate -x*(xChaise*0.5+rPiedChaise)}
                                object{ClouChaise rotate -y*90 translate x*(xChaise*0.5+rPiedChaise)}
                                rotate x*aEl translate posEl 
                                texture{txtClouChaise}
                        }
                #end
                #if (i<nEl-1)
                        union{
                                object{elDossier scale <1,yEl/0.1,1> translate -x*xChaise*0.5}
                                object{elDossier scale <1,yEl/0.1,1> translate x*xChaise*0.5}
                                rotate x*aEl translate posEl 
                        }
                #else
                        union{
                                object{elDossierBout scale <1,yEl/0.1,1> translate -x*xChaise*0.5}
                                object{elDossierBout scale <1,yEl/0.1,1> translate x*xChaise*0.5}
                                rotate x*aEl translate posEl 
                        }
                #end
                #if (i=11 | i=23)
                        object{BarreauDossier rotate x*aEl translate posEl}
                #end
                #declare posEl=posEl+<0,yEl*cos(radians(aEl)),yEl*sin(radians(aEl))>;
                #declare aEl=aEl+0.28;
                #declare i=i+1;
        #end

        #declare i=0;          
        #declare posEl=<0,0,0>;
        #declare aEl=0;
        union{
                #while (i<nEl)                                                       
                
                        #if (i>11 & i<23)
                                object{elCoussinDossier rotate x*aEl translate posEl}
                        #end
                        #declare posEl=posEl+<0,yEl*cos(radians(aEl)),yEl*sin(radians(aEl))>;
                        #declare aEl=aEl+0.25;
                        #declare i=i+1;
                #end
                texture{txtToileChaise}        
        }

} 
                                  
#declare xClousCoussin=union{
                #declare i=0;
                #while (i<5)
                        object{ClouChaise translate x*xChaise*i/6 translate -z*rPiedChaise} //*0.1*sin(pi*i/6)}
                #declare i=i+1;
                #end
                translate -x*xChaise*0.5
       }                          

#declare zClousCoussin=union{
                #declare i=0;
                #while (i<6)
                        object{ClouChaise translate x*zChaise*i/6 translate -z*rPiedChaise} //*0.1*sin(pi*i/6)}
                #declare i=i+1;
                #end
                translate -x*zChaise*0.5
                
       }                          

#declare Coussin=union{    
        union{
                object{xClousCoussin translate -z*zChaise*0.5}
                object{xClousCoussin scale <1,1,-1> translate z*zChaise*0.5}
                object{zClousCoussin rotate y*-90 scale <1,1,-1> translate -x*xChaise*0.5}
                object{zClousCoussin rotate y*-90 translate x*xChaise*0.5}
//                translate y*rPiedChaise*1.5
                translate y*rPiedChaise*0.25
                texture{txtClouChaise}
        }                             
        
        difference{
                superellipsoid{<0.4,0.4> scale <xChaise*0.5,rPiedChaise*3,zChaise*0.5>*1.01}
                plane{y,0}
                texture{txtToileChaise}
        }
        
        superellipsoid{<0.3,0.3> scale rPiedChaise*1.1 translate <-xChaise,0,-zChaise>*0.5}
        superellipsoid{<0.3,0.3> scale rPiedChaise*1.1 translate <-xChaise,0,zChaise>*0.5}
        superellipsoid{<0.3,0.3> scale rPiedChaise*1.1 translate <xChaise,0,-zChaise>*0.5}
        superellipsoid{<0.3,0.3> scale rPiedChaise*1.1 translate <xChaise,0,zChaise>*0.5}

        superellipsoid{<0.3,0.3> scale <xChaise*0.5,rPiedChaise,rPiedChaise> translate -z*zChaise*0.5}
        superellipsoid{<0.3,0.3> scale <xChaise*0.5,rPiedChaise,rPiedChaise> translate z*zChaise*0.5}

        superellipsoid{<0.3,0.3> scale <zChaise*0.5,rPiedChaise,rPiedChaise> rotate -y*90 translate -x*xChaise*0.5}
        superellipsoid{<0.3,0.3> scale <zChaise*0.5,rPiedChaise,rPiedChaise> rotate -y*90 translate x*xChaise*0.5}

}
#declare Chaise=union{                                                
        union{
                object{DossierChaise translate z*zChaise*0.5}
                object{Coussin}
                translate y*(yPiedChaise+rPiedChaise*0.5)
        }                            
//        sphere{y*yPiedChaise,0.06}
        object{PiedChaise translate <xChaise,0,zChaise>*0.5}
        object{PiedChaise translate <xChaise,0,-zChaise>*0.5}
        object{PiedChaise translate <-xChaise,0,zChaise>*0.5}
        object{PiedChaise translate <-xChaise,0,-zChaise>*0.5}
        
        object{BarreauChaise1 translate <-xChaise*0.5,0.1,-zChaise*0.5>}
        object{BarreauChaise1 scale <1,1,-1> translate <-xChaise*0.5,0.1,zChaise*0.5>}
        object{BarreauChaise1 scale <zChaise/xChaise,1,1> rotate y*-90 scale <-1,1,1> translate <-xChaise*0.5,0.1,-zChaise*0.5>}
        object{BarreauChaise1 scale <zChaise/xChaise,1,1> rotate y*-90 translate <xChaise*0.5,0.1,-xChaise*0.5>}

        object{BarreauChaise2 translate <-xChaise*0.5,0.3,-zChaise*0.5>}
        object{BarreauChaise2 scale <1,1,-1> translate <-xChaise*0.5,0.3,zChaise*0.5>}
        object{BarreauChaise2 scale <zChaise/xChaise,1,1> rotate y*-90 scale <-1,1,1> translate <-xChaise*0.5,0.3,-zChaise*0.5>}
        object{BarreauChaise2 scale <zChaise/xChaise,1,1> rotate y*-90 translate <xChaise*0.5,0.3,-zChaise*0.5>}

        texture{txtBoisChaise}
        scale 0.9
}
#declare xr=3;
#declare yr=3;
#declare zr=5;
#declare yf=1.2;
#declare zf=1.4;
#declare yf0=1.3;
union{  

    box{0,<0.001,yr,zr> texture{txtWall rotate y*90}}
    box{<0,0,-0.001>,<xr,yr,0> translate z*zr texture{txtWall}}
        difference{
                box{-em,<xr,yr,zr>+em}
                box{0,<xr,yr,zr>}
                box{<-em,0,0>,<em*2,yf,zf> translate <xr,yf0,zr-zf-3*em>}
                box{<-em,0,0>,<em*2,yf,zf> translate <xr,yf0,zr-2*zf-6*em>}
                texture{txtMur}
        }        
        
        box{0,<xr,0.01,zr> texture{txtPlancher}}
//        sphere{0,1 translate y scale 0.2 texture{txtMur} translate <0.3,0.01,zr-1>}
//        sphere{0,1 translate y scale 0.2 texture{txtMur} translate <xr-1,0.01,zr-2>}
//        sphere{0,1 translate y scale 0.2 texture{txtMur} translate <2,yf*1.2,zr-1>}
        object{Chaise rotate y*30 translate <xr-0.5,0,zr-0.5>}
        object{Chaise rotate -y*70 translate <0.5,0,zr-2>}
        object{Chaise rotate y*70 translate <xr-0.5,0,zr*0.7>}
}


#declare colSkin=rgb <247,184,159>/255;
/* Vicky stuff here
#declare finVicky=finish{ambient 0 diffuse scd specular 0.03 roughness 0.01}
#declare txtHead=texture{pigment{image_map{png "milhdmap"}} finish{finVicky}}
#declare txtBody=texture{pigment{image_map{png "milbdmap"}}finish{finVicky}}
#declare txtLashes=texture{pigment{image_map{tga "millashes"}}finish{finVicky}}
#declare txtHair=texture{pigment{image_map{tga "mwponytail"}}finish{finVicky}}
                   
#declare T_SkinHead = texture{txtHead}
#declare T_Eyebrows = texture{txtHead}
#declare T_Lips = texture{txtHead}
#declare T_Lacrimal = texture{txtHead}
#declare T_Eyelashes = texture{txtLashes}
#declare T_InnerMouth = texture{txtHead}
#declare T_Nostrils = texture{txtHead}
#declare T_Tongue = texture{txtHead}
#declare T_UpperEyebrows = texture{txtHead}
#declare T_Teeth = texture{txtHead}
#declare T_SkinBody = texture{txtBody}
#declare T_Nipples = texture{txtBody}
#declare T_Eyeballs = texture{txtHead finish{reflection 0.02}}
#declare T_Pupils = texture{txtHead finish{reflection 0.02}}
#declare T_Eyewhites = texture{txtHead finish{reflection 0.02}}
#declare T_Irises = texture{txtHead}
#declare T_Toenails = texture{txtBody}
#declare T_Fingernails = texture{txtBody}
#declare T_hair = texture{txtHair}
#declare T_bangs = texture{txtHair}
#declare T_wrap = texture{txtHair}
#declare T_dress = texture{pigment{image_map{png "dressmap"}}finish{finVicky}} // dress
#include "vicky2_o.inc"
union{
    object{P_Personnage_1}
    object{P_Personnage_2}
    scale yr*<1,1,1> rotate y*130 translate <xr*0.7,0,zr-0.6>
}
*/
#include "MakeBook.inc"
#include "MakeShelf.inc"
#include "MakeLibrary.inc"

#declare rd=seed(0); // seed

#declare xLib=1.5; // library width
#declare yLib=yr*0.95; // library height
#declare zShelf=0.3; // depth of shelves
#declare zLibShelf=0.3; // depth of the side planks (>zShelf)
#declare zLibPanel=0.5; // depth of bottom panels
#declare ePlankShelf=0.025; // thickness of shelf plank
#declare ePlankSide=0.03; // thickness of side plank
#declare ePlankTop=0.06; // thickness of top and main horizontal planks  
#declare yLibPanel=0.8; // height of bottom panel
#declare yPlinth=0.2; // height of bottom plinth
#declare sdyShelf=0.01;  // pseudo standard deviation of shelf height (-sdyShelf*h/2 to +sdShelf*h/2)
#declare xBook=0.06; // Book thickness
#declare sdxBook=0.03;  // pseudo standard deviation of book thickness (-sdxBook*xBook/2 to +sdxBook*xBook/2)
#declare sdyBook=0.1;  // pseudo standard deviation of book height
#declare sdzBook=0.2;  // pseudo standard deviation of book depth
#declare typeShelf=0;     // series
#declare typeBook=0;     // old books
#declare slackShelf=1; 
#declare colLib=rgb 1.5*<71,31,5>/255;
#declare txtLib=texture{
        pigment{
                wood         
                turbulence 0.2
                lambda 3
                rotate x*-80
                rotate z*-20
                scale 0.1*<1,8,1>*0.7
                color_map{
                        [0 colLib*1.1]
                        [1 colLib*0.6]
                }
                        
        }        
        finish{ambient 0     diffuse 1 specular 0.4 roughness 0.01}
}        

#declare doBooks=true; // creates the books
//#declare doBooks=false; // does not create the books
union{

        #declare nShelf=5; // number of shelves
        #declare nSetMax=6;     // maximum number of book sets
        #declare slackShelf=1;  // very slack
        object{mLibrary(xLib*0.9,yLib,zLibShelf,zLibPanel,yLibPanel,yPlinth,nShelf,sdyShelf,ePlankShelf,xBook,sdxBook,sdyBook,sdzBook,typeShelf,typeBook,slackShelf,nSetMax,doBooks,txtLib)}
        
        texture{txtLib}
        translate <0.1,0,zr>
}


plane{y,-em texture{txtSol}}
        