#version unofficial MegaPov 0.5;

global_settings{max_trace_level 7}

#declare Seed=seed(3232);

#declare BrushedMetal=
texture{
    pigment{
        bozo
        color_map{[0 hsl(.72,.1,.5)][.6 hsl(.72,.05,.9)]}
        scale <.002,.2,.2>
    }
    finish{
        ambient 0 brilliance 2 specular .4 roughness .05 metallic
        reflection_min .2 reflection_max .3
        reflection_blur .3 reflection_samples 20
    }
}

#declare BlackMetal=
texture{
    pigment{hsl(.02,.2,.2)}
    normal{granite .2 scale .2}
    finish{ambient 0 brilliance 1.3 specular .3 roughness .05 metallic .4}
}

#declare BoltTex=
texture{
    pigment{hsl(.05,.3,.8)}
    //normal{granite .4 scale .1}
    normal{average normal_map{[1 wood 1.5][1 granite .6 scale .1]}}
    finish{
        ambient 0 brilliance 2 specular .4 roughness .02 metallic
        irid{.3 thickness .5}}
}

#declare ShieldTex=
texture{
    pigment{hsl(0,.9,.35)}
    finish{
        ambient 0 brilliance 2 specular .6 roughness .02
        reflection_min .3 reflection_max .5 //reflection_exponent .7
        //reflection_blur .1 reflection_samples 10 
        irid{.15 thickness .3}
    }
}

#declare BlackPlastic=
texture{
    pigment{hsl(.02,.2,.05)}
    finish{
        ambient 0 specular .5 roughness .03
        reflection_min .15 reflection_max .3 //reflection_exponent .8
    }
}

#declare WireTex=
texture{
    pigment{hsl(.98,.8,.8)}
    finish{ambient 0 specular .1 roughness .08}
}

#declare Chrome=
texture{
    pigment{hsl(.75,.3,.1)}
    finish{
        ambient 0 diffuse .6 brilliance 8
        specular .9 roughness .05
        reflection_min .3 reflection_max .8 //reflection_exponent .8
        //metallic .2 reflect_metallic .2
    }
}

#declare Chrome2=
texture{
    pigment{hsl(.75,.3,.1)}
    normal{bozo 1 slope_map{[0,<0,0>][.6,<1,0>]} scale .06 warp{black_hole 0,1 strength 8 falloff 1 inverse}}
    finish{
        ambient 0 diffuse .6 brilliance 8
        specular .9 roughness .05
        reflection_min .3 reflection_max .8 //reflection_exponent .8
        //metallic .2 reflect_metallic .2
    }
}

#declare Aluminium=
texture{
    pigment{granite color_map{[.5 hsl(.7,.1,1)][.8 hsl(.7,.1,.5)]} scale <.4,.15,.15>}
    finish{
        ambient 0 diffuse .6 brilliance 2.5 specular .3 roughness .04 metallic
        reflection_min .4 reflection_max .6 reflect_metallic //reflection_exponent .8
        //reflection_blur .1 reflection_samples 6
    }
}

#declare Aluminium1A=texture{Aluminium normal{gradient x 2 scale 2}}
#declare Aluminium1B=texture{Aluminium normal{gradient x -2 scale 2}}
#declare Aluminium1=texture{average texture_map{[1 Aluminium1A][1 Aluminium1B]}}

#declare Aluminium2A=texture{Aluminium normal{wood 2 triangle_wave}}
#declare Aluminium2B=texture{Aluminium normal{wood -2 triangle_wave}}
#declare Aluminium2=texture{average texture_map{[1 Aluminium2A][1 Aluminium2B]}}

#declare Copper=
texture{
    pigment{hsl(.07,.7,.9)}
    finish{ambient 0 brilliance 3 specular .3 roughness .05 metallic}
}

#declare LampGlass=
material{
    texture{
        pigment{hslf(.7,1,1,.7)}
        normal{
            gradient y
            normal_map{
                [.7 radial slope_map{[0,<0,0>][.4,<.7,1>][.5,<1,0>]} frequency 20]
                [.8 radial 0 frequency 20]
            }
        }
        finish{
            ambient 0 diffuse .2 brilliance 4 specular .4 roughness .01
            reflection_type 1 reflection_min .15 reflection_max .3 conserve_energy
        }
    }
    interior{ior 1.6}
}

#declare LightBulb=
material{
    texture{pigment{rgbt <0,0,0,1>} finish{ambient 0 diffuse 0}}
    interior{
        media{emission hsl(.16,.05,8)}
    }
}


//OBJECTS

#declare MagnetBracket=
difference{
    difference{
        sphere{0,1}
        box{-1,1-x}
        box{-1,1-y}
    }
    cylinder{z,-z,1 scale <.7,1,1>}
    scale <-1,1,.2>
    translate <.75,0,0>
}

#declare Bolt=
prism{
    #declare C=0;
    #declare N=6;
    linear_sweep linear_sweep
    0,1,N,
    #while(C<N)
        #declare PrismP=vrotate(x,C*(360/N)*y);
        <PrismP.x,PrismP.z>
        #declare C=C+1;
    #end
}

#declare ShooterBody=
union{
    #declare Rmaj=1.6;
    #declare Rmin=1.3;
    #declare SRad=1.3;
    #declare Dist=sqrt(pow(SRad+Rmin,2)-pow(Rmaj,2));
    #declare Angle=acos(1/(SRad+Rmin)*Dist);
    #declare CRad=sin(Angle)*SRad;
    sphere{0,SRad}
    torus{
        Rmaj,Rmin
        rotate z*90
        translate x*Dist
        clipped_by{cylinder{0,x*Dist,CRad}}
    }
    torus{
        .5,.2
        rotate z*90
        clipped_by{cylinder{0,x*.3,.4}}
        translate x*Dist
    }
    scale <1,3/4,3/4>
    texture{BrushedMetal}
}

#declare WS_Normal=<0,0,0>;
#declare WireStart=trace(ShooterBody,0,<1,1,-1>,WS_Normal);
#declare WireEnd=x*(Dist+.3)+vrotate(y*.5,-x*40);

//Shooter magnet

#declare ShooterMagnet=
union{
    isosurface{
        function{"helix1",<2,20,.015,.385,1,1,0>}
        contained_by{box{<-.4,0,-.4>,<.4,1,.4>}}
        rotate -z*90
        texture{Copper}
    }

    torus{.4,.03 rotate z*90 translate x}
    torus{.4,.03 rotate z*90}

    #declare C=0;
    #declare N=2;
    #while(C<N)
        cylinder{y*.4,x+y*.4,.02 rotate (C*(360/N)+90)*x}
        #declare C=C+1;
    #end

    #declare C=0;
    #declare N=5;
    #while(C<N)
        cone{y*.4,.03,y*.6+x*.3,0 rotate C*(360/N)*x translate x}
        #declare C=C+1;
    #end
    texture{Chrome}
    translate x*(Dist+.3)
}    

//Shooter fixtures

#declare ShooterFixture=
union{
    #declare SphTorTouch=sin(Angle)*SRad;
    #declare C=0;
    #declare N=3;
    #while(C<N)
        object{
            MagnetBracket
            rotate -z*90
            scale <(Dist+.3)-SphTorTouch,(CRad-.4)*3/4,.5>
            translate -x*(Rmaj-.1)+y*CRad*3/4
            rotate C*(360/N)*x
        }
        #declare C=C+1;
    #end

    #declare C=0;
    #declare N=3;
    #while(C<N)
        cylinder{-.03*z,.03*z,.07 translate y*.4 rotate C*(360/N)*x}
        #declare C=C+1;
    #end

    superellipsoid{
        <1,.3>
        rotate y*90
        scale <.1,CRad*3/4+.08,CRad*3/4+.08>
        translate -x*(Rmaj-.24)
    }

    #declare C=0;
    #declare N=10;
    union{
        #while(C<N)
            union{
                object{Bolt scale -.05}
                cylinder{0,y*.025,.03}
                texture{BoltTex}
                translate y*(CRad*3/4+.12)
                rotate C*(360/N)*x
            }
            #declare C=C+1;
        #end
        translate -x*(Rmaj-.24)
    }
    
    object{Bolt scale <.1,.1,.1> translate y*.4 rotate x*40}
    object{Bolt scale <.1,.1,.1> translate y*.4 rotate -x*40}
    
    superellipsoid{
        <1,.1> rotate x*90 scale <SRad+.04,.1,SRad*3/4+.04>
        clipped_by{cylinder{0,x*2,CRad*3/4 inverse}}
        translate -x*(Dist+.3)
    }
    
    #declare C=0;
    #declare N=8;
    union{
        #while(C<N)
            #declare B_Normal=<0,0,0>;
            #declare Point=trace(ShooterBody,0,vrotate(x,C*(360/N)*y),B_Normal);
            object{Bolt
                scale -.07
                texture{BoltTex}
                Reorient(y,B_Normal)
                translate Point+B_Normal*.08
            }
            #declare C=C+1;
        #end
        translate -x*(Dist+.3)
    }
    texture{BlackMetal}
    translate x*(Dist+.3)
}

//Shooter wires

#declare WirePath=
spline{
    cubic_spline
    0,WireStart,
    .1,WireStart+WS_Normal*.25,
    .3,WireStart+<.45,.35,-.5>,
    .45,(WireEnd-WireStart)/2+WireStart+<-.1,.4,-.7>,
    //.55,(WireEnd-WireStart)/2+WireStart+<0,.3,-.5>,
    .7,(WireEnd-WireStart)/2+WireStart+<.55,0,-.3>,
    .9,WireEnd+vrotate(y,-x*40)*.1,
    1,WireEnd
}

#declare WireHolder=
union{
    //cylinder{0,y*.2,.15}
    superellipsoid{<1,.1> scale <.2,.2,.2> rotate x*90}
    #declare C=0;
    #declare N=6;
    #while(C<N)
        union{
            object{Bolt scale -.05}
            cylinder{0,y*.025,.03}
            texture{BoltTex}
            translate x*.14+y*.24
            rotate C*(360/N)*y
        }
        #declare C=C+1;
    #end
    texture{BlackPlastic}
}

#declare ShooterWires=
union{
    object{WireHolder Reorient(y,WS_Normal) translate WireStart}
    object{WireHolder Reorient(y,WS_Normal*<1,1,-1>) translate WireStart*<1,1,-1>}
    blob{
        threshold .5
        #declare C=0;
        #declare N=1/100;
        #while(C<1)
            sphere{WirePath(C),.07,1}
            #declare C=C+N;
        #end
    }
    blob{
        threshold .5
        #declare C=0;
        #declare N=1/100;
        #while(C<1)
            sphere{WirePath(C)*<1,1,-1>,.07,1}
            #declare C=C+N;
        #end
    }
    texture{WireTex}
}

//Shooter lamp

#declare ShooterLamp=
union{
    superellipsoid{
        <1,.1>
        texture{BlackPlastic}
        rotate x*90 scale <.28,.1,.28> translate y
    }
    difference{
        merge{
            cone{0,.23,y*.4,.2}
            sphere{0,.2 scale <1,.3,1> translate y*.4}
        }
        merge{
            cone{0,.23,y*.4,.2}
            sphere{0,.2 scale <1,.3,1> translate y*.4}
            scale .95
            translate -y*.01
        }
        material{LampGlass scale <1,.4+.2*.3,1>}
        translate y*1.1
    }
    cone{
        0,.23,y*.4,.2
        texture{Chrome}
        clipped_by{box{<-.25,0,0>,<.25,.38,.25>}}
        scale <.93,.93,.8> rotate -y*70 translate y*1.1
    }
    sphere{0,.1 material{LightBulb} translate y*1.2 hollow}
    light_source{y*1.2 rgb 9 fade_distance .35 fade_power 3}
    hollow
}

//Shooter chassis

#declare RearAxis=<-1.05,-.3,1.1>;
#declare FrontAxis=<.75,-.65,.9>;

#declare ShooterChassis=
union{
    cylinder{RearAxis-z*.15,(RearAxis-z*.15)*<1,1,-1>,.2}
    union{
        cylinder{RearAxis-z*.1,(RearAxis-z*.1)*<1,1,-1>,.17}
        cone{RearAxis-z*.1,.17,RearAxis,.1}
        cone{(RearAxis-z*.1)*<1,1,-1>,.17,RearAxis*<1,1,-1>,.1}
        texture{Chrome}
    }
        
    cylinder{FrontAxis-z*.15,(FrontAxis-z*.15)*<1,1,-1>,.17}
    union{
        cylinder{FrontAxis-z*.1,(FrontAxis-z*.1)*<1,1,-1>,.14}
        cone{FrontAxis-z*.1,.14,FrontAxis,.1}
        cone{(FrontAxis-z*.1)*<1,1,-1>,.14,FrontAxis*<1,1,-1>,.1}
        texture{Chrome}
    }
    superellipsoid{
        <1,.1> rotate x*90 scale <SRad+.05,.2,SRad*3/4+.05>
        clipped_by{union{cylinder{0,x*2,CRad*3/4+.05} box{<-1.4,-1.3,-1.3>,<1.3,1.3,.1>} inverse}}
        rotate x*90
    }
    texture{BlackMetal}
}

//Shooter back shield

#declare ShooterShield=
intersection{
    difference{
        sphere{0,SRad+.01 scale <1,3/4,3/4>}
        sphere{0,SRad scale <1,3/4,3/4>}
        plane{x,SphTorTouch+.2 inverse}
        plane{y,0}
    }
    cylinder{0,2*y,1 scale <SRad+.2,1,.9> translate x*(SphTorTouch+.2)}
    texture{ShieldTex}
}

//Shooter legs

#declare FLeg1Rmin1=.2;
#declare FLeg1Rmin2=.1;
#declare FLeg1Rmaj1=.6;
#declare FLeg1Rmaj2=.3;
#declare FLeg1Beam=.065;
#declare FLeg1Thickness=.05;

#declare FLeg2Rmin=.12;
#declare FLeg2Rmaj1=1.2;
#declare FLeg2Rmaj2=.5;
#declare FLeg2Spike=.4;
#declare FLeg2Thickness=.15;

#declare FLegHydrDist=.2;
#declare FLegHydrRad=.04;
#declare FLegHydrAngle=120;

#declare RLeg1Rmin1=.3;
#declare RLeg1Rmin2=.1;
#declare RLeg1Rmaj1=.7;
#declare RLeg1Rmaj2=.5;
#declare RLeg1Beam=.08;
#declare RLeg1Thickness=.05;

#declare RLeg2Rmin=.15;
#declare RLeg2Rmaj1=2.3;
#declare RLeg2Rmaj2=1.2;
#declare RLeg2Spike=.8;
#declare RLeg2Thickness=.15;

#declare RLegHydrDist=.2;
#declare RLegHydrRad=.04;
#declare RLegHydrAngle=120;

#declare FrontPivot=<FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>;
#declare RearPivot=<-RLeg1Rmaj1-RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>;

#declare FLeg1Hydr=
intersection{
    torus{FLegHydrDist,FLegHydrRad rotate x*90}
    plane{y,0}
    plane{-y,0 rotate z*FLegHydrAngle}
    scale <1,1,.8>
    translate z*.02
    rotate -80*z
}
#declare FLeg2Hydr=
intersection{
    torus{FLegHydrDist,FLegHydrRad-.02 rotate x*90}
    plane{y,0}
    plane{-y,0 rotate z*FLegHydrAngle}
    scale <1,1,.8>
    translate z*.02
    rotate -80*z
}
#declare RLeg1Hydr=
intersection{
    torus{RLegHydrDist,RLegHydrRad rotate x*90}
    plane{y,0}
    plane{-y,0 rotate z*RLegHydrAngle}
    scale <1,1,.8>
    translate z*.02
    rotate -80*z
}
#declare RLeg2Hydr=
intersection{
    torus{RLegHydrDist,RLegHydrRad-.02 rotate x*90}
    plane{y,0}
    plane{-y,0 rotate z*RLegHydrAngle}
    scale <1,1,.8>
    translate z*.02
    rotate -60*z
}

#declare FLeg1=
union{
    difference{
        cylinder{0,z*.1,FLeg1Rmin1}
        cone{z*.1,FLeg1Rmin1-.03,z*.07,FLeg1Rmin1-.05 translate z*.001}
        texture{Aluminium2}
    }
    object{Bolt scale .08 texture{BoltTex} rotate x*90 translate z*.07}
    intersection{
        difference{
            cylinder{0,z*FLeg1Thickness,1 scale <FLeg1Rmaj1+FLeg1Rmin1*2,FLeg1Rmaj2+FLeg1Rmin2*2,1>}
            cylinder{-z,z,1 scale <FLeg1Rmaj1,FLeg1Rmaj2,1>}
            difference{
                cylinder{-z*.5,z*.5,1 scale <FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam,FLeg1Rmaj2+FLeg1Rmin2*2-FLeg1Beam,1>}
                cylinder{-z,z,1 scale <FLeg1Rmaj1+FLeg1Beam,FLeg1Rmaj2+FLeg1Beam,1>}
            }
            union{
                torus{FLeg1Rmaj1+FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Beam/2)>}
                torus{FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Rmin1-FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Rmin2-FLeg1Beam/2)>}
                rotate x*90
                scale <1,1,.7>
                translate z*FLeg1Thickness
            }
            union{
                torus{FLeg1Rmaj1+FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Beam/2)>}
                torus{FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Rmin1-FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Rmin2-FLeg1Beam/2)>}
                rotate x*90
                scale <1,1,.7>
                //translate z*FLeg1Thickness
            }
        }
        box{<-FLeg1Rmaj1-FLeg1Rmin1*2,0,-1>,<0,-FLeg1Rmaj2-FLeg1Rmin2*2,1>}
        translate x*(FLeg1Rmaj1+FLeg1Rmin1)
    }
    cylinder{0,z*.1,FLeg1Rmin2 texture{Aluminium2} translate <FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>}
    object{FLeg1Hydr translate <FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>}
    texture{Aluminium1}
}

#declare FLeg2=
union{
    union{
        difference{
            union{
                cylinder{-z*.1,0,FLeg1Rmin2+.03}
                cylinder{z*.1,z*.14,FLeg1Rmin2+.03}
            }
            cone{z*.14,FLeg1Rmin2,z*.11,FLeg1Rmin2-.02 translate z*.001}
            cone{0,FLeg1Rmin2,z*.03,FLeg1Rmin2-.02 translate -z*.001}
        }
        object{Bolt rotate x*90 scale <.06,.06,.4> texture{BoltTex} translate -z*.25}
        translate -z*.02
        texture{Aluminium2}
    }
    union{
        intersection{
            difference{
                sphere{0,1 scale <FLeg2Rmaj1,FLeg2Rmaj2+FLeg2Rmin*2,FLeg2Thickness>}
                cylinder{-z,z,1 scale <FLeg2Rmaj1,FLeg2Rmaj2,1>}
                torus{FLeg2Rmaj2,FLeg2Rmin rotate x*90 scale <FLeg2Rmaj1/FLeg2Rmaj2,1,1/FLeg2Rmin*FLeg2Thickness> translate -z*FLeg2Thickness}
                torus{FLeg2Rmaj2,FLeg2Rmin rotate x*90 scale <FLeg2Rmaj1/FLeg2Rmaj2,1,1/FLeg2Rmin*FLeg2Thickness> translate z*FLeg2Thickness}
            }
            box{<0,0,-1>,<FLeg2Rmaj1,FLeg2Rmaj2+FLeg2Rmin*2,1>}
            //pigment{rgb x}
        }
        difference{
            cylinder{0,-x*FLeg2Spike,1 scale <1,FLeg2Rmaj2+FLeg2Rmin*2,FLeg2Thickness>}
            cylinder{-z,z,1 scale <FLeg2Spike,FLeg2Rmin*2,1> translate <-FLeg2Spike,FLeg2Rmaj2,0>}
            box{<-1,-2,-1>,<1,FLeg2Rmaj2,1>}
        }
        object{FLeg2Hydr translate y*FLeg2Rmaj2-z*.02}
        texture{Chrome2 scale <FLeg2Rmaj1,FLeg2Rmaj2+FLeg2Rmin*2,1>}
        translate -y*FLeg2Rmaj2+z*.02
    }
}

#declare RLeg1=
union{
    difference{
        cylinder{0,z*.1,RLeg1Rmin1}
        cone{z*.1,RLeg1Rmin1-.03,z*.07,RLeg1Rmin1-.05 translate z*.001}
        texture{Aluminium2}
    }
    object{Bolt scale .08 texture{BoltTex} rotate x*90 translate z*.07}
    intersection{
        difference{
            cylinder{0,z*RLeg1Thickness,1 scale <RLeg1Rmaj1+RLeg1Rmin1*2,RLeg1Rmaj2+RLeg1Rmin2*2,1>}
            cylinder{-z,z,1 scale <RLeg1Rmaj1,RLeg1Rmaj2,1>}
            difference{
                cylinder{-z*.5,z*.5,1 scale <RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam,RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam,1>}
                cylinder{-z,z,1 scale <RLeg1Rmaj1+RLeg1Beam,RLeg1Rmaj2+RLeg1Beam,1>}
            }
            union{
                torus{RLeg1Rmaj1+RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Beam/2)>}
                torus{RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam/2)>}
                rotate x*90
                scale <1,1,.4>
                translate z*RLeg1Thickness
            }
            union{
                torus{RLeg1Rmaj1+RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Beam/2)>}
                torus{RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam/2)>}
                rotate x*90
                scale <1,1,.4>
                //translate z*RLeg1Thickness
            }
        }
        box{<-RLeg1Rmaj1-RLeg1Rmin1*2,0,-1>,<0,-RLeg1Rmaj2-RLeg1Rmin2*2,1>}
        translate x*(RLeg1Rmaj1+RLeg1Rmin1)
    }
    cylinder{0,z*.1,RLeg1Rmin2 texture{Aluminium2} translate <RLeg1Rmaj1+RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>}
    object{RLeg1Hydr translate <RLeg1Rmaj1+RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>}
    scale <-1,1,1>
    texture{Aluminium1}
}

#declare RLeg2=
union{
    union{
        difference{
            union{
                cylinder{-z*.04,0,RLeg1Rmin2+.03}
                cylinder{z*.1,z*.14,RLeg1Rmin2+.03}
            }
            cone{z*.14,RLeg1Rmin2,z*.11,RLeg1Rmin2-.02 translate z*.001}
            cone{0,RLeg1Rmin2,z*.03,RLeg1Rmin2-.02 translate -z*.001}
        }
        object{Bolt rotate x*90 scale <.06,.06,.24> texture{BoltTex} translate -z*.08}
        translate -z*.02
        texture{Aluminium2}
    }
    union{
        intersection{
            difference{
                sphere{0,1 scale <RLeg2Rmaj1,RLeg2Rmaj2+RLeg2Rmin*2,RLeg2Thickness>}
                cylinder{-z,z,1 scale <RLeg2Rmaj1,RLeg2Rmaj2,1>}
                torus{RLeg2Rmaj2,RLeg2Rmin rotate x*90 scale <RLeg2Rmaj1/RLeg2Rmaj2,1,1/RLeg2Rmin*RLeg2Thickness> translate -z*RLeg2Thickness}
                torus{RLeg2Rmaj2,RLeg2Rmin rotate x*90 scale <RLeg2Rmaj1/RLeg2Rmaj2,1,1/RLeg2Rmin*RLeg2Thickness> translate z*RLeg2Thickness}
            }
            box{<0,0,-1>,<RLeg2Rmaj1,RLeg2Rmaj2+RLeg2Rmin*2,1>}
        }
        difference{
            cylinder{0,-x*RLeg2Spike,1 scale <1,RLeg2Rmaj2+RLeg2Rmin*2,RLeg2Thickness>}
            cylinder{-z,z,1 scale <RLeg2Spike,RLeg2Rmin*2,1> translate <-RLeg2Spike,RLeg2Rmaj2,0>}
            box{<-1,-2,-1>,<1,RLeg2Rmaj2,1>}
        }
        object{RLeg2Hydr translate y*RLeg2Rmaj2-z*.02}
        texture{Chrome2 scale <RLeg2Rmaj1,RLeg2Rmaj2+RLeg2Rmin*2,1>}
        scale <-1,1,1>
        translate -y*RLeg2Rmaj2+z*.02
    }
}

//Assemble the Shooter's body parts

#declare ShooterStatic=
union{
    object{ShooterBody}
    object{ShooterMagnet}
    object{ShooterFixture}
    object{ShooterWires}
    object{ShooterLamp}
    object{ShooterChassis}
    object{ShooterShield}
}

//Macro to create Shooter with legs positioned

#macro Shooter(RRLegA1,RRLegA2,LRLegA1,LRLegA2,RFLegA1,RFLegA2,LFLegA1,LFLegA2)
    union{
        object{ShooterStatic}

        object{RLeg1 rotate RRLegA1*z translate RearAxis scale <1,1,-1>}
        object{RLeg2 rotate (RRLegA1+RRLegA2)*z translate RearAxis+vrotate(RearPivot,RRLegA1*z) scale <1,1,-1>}

        object{RLeg1 rotate LRLegA1*z translate RearAxis}
        object{RLeg2 rotate (LRLegA1+LRLegA2)*z translate RearAxis+vrotate(RearPivot,LRLegA1*z)}

        object{FLeg1 rotate -RFLegA1*z translate FrontAxis scale <1,1,-1>}
        object{FLeg2 rotate -(RFLegA1+RFLegA2)*z translate FrontAxis+vrotate(FrontPivot,-RFLegA1*z) scale <1,1,-1>}

        object{FLeg1 rotate -LFLegA1*z translate FrontAxis}
        object{FLeg2 rotate -(LFLegA1+LFLegA2)*z translate FrontAxis+vrotate(FrontPivot,-LFLegA1*z)}
    }
#end

/*
light_source{<-5,5,-5>*10 rgb 1}
#declare CPos=<-.5,4,-8>;
camera{location CPos look_at y}
light_source{CPos*2 rgb .2}
background{hsl(.05,.8,.3)}
object{Shooter(-30,60, -0,120, 0,50, 60,70) rotate -z*5 translate y*2.5}
plane{y,0 pigment{checker rgb .3, rgb x}}
*/