//Fur generator include file (version 2.0)
//Created by Margus Ramst (margus@peak.edu.ee)
//January 23, 2000

//Additional macros

#macro Reorient(Axis1,Axis2)
        #local vX1=vnormalize(Axis1);
        #local vX2=vnormalize(Axis2);
        #local vY=vnormalize(vcross(vX1,vX2));
        #local vZ1=vnormalize(vcross(vX1,vY));
        #local vZ2=vnormalize(vcross(vX2,vY));
        matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
        matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end

#macro v_reorient(V,RefA,RefB)
    (#if((v_parallel(RefA,RefB))=0)
        vaxis_rotate(V,
                     vcross(vnormalize(RefA),vnormalize(RefB)),
                     degrees(atan2(vlength(vcross(vnormalize(RefA),vnormalize(RefB))),
                                   vdot(vnormalize(RefA),vnormalize(RefB)))))
    #else
        ((v_parallel(RefA,RefB))*V)
    #end)
#end

//Interpolation
//GC - global current
//GS - global start
//GE - global end
//TS - target start
//TE - target end
//Method - interpolation method:
//         Method = 0 - cosine interpolation
//         Method > 0 - exponential (1 - linear, etc)

#macro Interpolate(GC,GS,GE,TS,TE,Method)
    (#if(Method!=0)
        (TS+(TE-TS)*pow((GC-GS)/(GE-GS),Method))
    #else
        #local X=(GC-GS)/(GE-GS);
        #local F=(1-cos(X*pi))*.5;
        (TS*(1-F)+TE*F)
    #end)
#end

//Create random number of given mean and maximum deviation
//M - mean value
//D - maximum deviation
//Seed - (declared) random number seed identifier
#macro rand_ext(M,D,Seed)
        (M+(rand(Seed)-.5)*2*D)
#end

//Give a random vector of given mean and max deviation
//M - mean (vector/float)
//D - max deviation (vector/float)
//Seed - (declared) random number seed identifier
#macro v_rand_ext(M,D,Seed)
        #local MV=M+<0,0,0>;
        #local DV=D+<0,0,0>;
        (<rand_ext(MV.x,DV.x,Seed),rand_ext(MV.y,DV.y,Seed),rand_ext(MV.z,DV.z,Seed)>)
#end


/*              THE Fur MACRO               */

//Main macro, samples the object and places the hairs
//
//Parameters:
//
//Object:
//    #declared object to be made furry
//DivIn:
//    sampling rate along each axis (float or vector)
//PosJ:
//    randomness in the position of hairs;
//    PosJ=1 => max_displacement = object_size / DivIn / 2
//NumSegm
//    number of segments (cones) in each hair
//Len:
//    length of hairs (in POV units)
//LenJ:
//    randomness in hair length (fraction of total length)
//RadIn:
//    radius of hair at the base (in POV units)
//Wind:
//    direcion of wind (or any directional force),
//    longer vector => stronger force
//BendExp:
//    how the hair is bent by Wind:
//    1 bends uniformly from start to end;
//    N>1 bends more towards end;
//    N<1 bends more towards start;
//TwistIn:
//    random twisting of hair (fraction of 90 degrees rotation);
//    it is independent of NumSegm:
//    twist per segment is calculated as TwistIn/NumSegm
//HairFile:
//    if true, outputs cones to FileName,
//    #declaring a CSG union object 'Hairs'
//HairFile_Name:
//    name of the output file (in double quotes, e.g. "filename.inc")
//    You need to put something (e.g. '0') here even if FileO=false
//PointFile:
//    if true, outputs hair start points
//    and surface normals to PointFile_Name
//PointFile_Name:
//    name of the output file (in double quotes, e.g. "filename.inc")
//    You need to put something (e.g. '0') here even if PointFile=false
//Culling:
//    if true, enables culling, i.e. removal of hairs that do not
//    affect the image (does not work with reflections)
//TestPos:
//    array identifier; points from which the hair must be visible
//    to be created (when culling is enabled).
//    First entry is considered to be the camera position, the rest light sources.
//    Culling works differently for the two.
//MaxAngle:
//    How much the base of a  hair must be below the horizon
//    before the hair can be culled.
//    The object horizon is at 90 degrees.
//    If MaxAngle = 0 all hairs are discarded.
//    If MaxAngle = 180 no culling occurs.
//    Longer hairs require greater MaxAngle. A good value is around 95 - 110.
//Pigment:
//    Pigment for the fur.
//LenPattern:
//    Pigment pattern multiplying the length of hairs (only x component is used).

//NB! I have added manual bounding to the hairs to save memory;
//this generates warnings. You should either disable the warning
//stream with -GW or comment out the bounded_by statement in worm.inc

#macro Fur(Object, DivIn, PosJ,
           NumSegm, Len, RadIn,
           Wind, BendExp, TwistIn, Turb,
           HairFile, HairFile_Name,
           PointFile, PointFile_Name,
           Culling, TestPos, MaxAngle,
           Pigment,LenPattern)

    #debug "\nFur macro called\n"
    
    //union{

    #local Seed=seed(12121);
    
    #local HairNum=0;
    #local CullFlag=0;
    #local Culled=0;
    #if(Culling!=0)
        #debug "Culling: on\n"
        #local CullTests=dimension_size(TestPos,1);
        #if(CullTests>1)
            #local LightSw=1;
        #else #local LightSw=0;
        #end
    #else #debug "Culling: off\n"
    #end
    #local MaxAngle=radians(MaxAngle);

    #local Divisions=DivIn+<0,0,0>;
    #local Jitter=PosJ+<0,0,0>;
    //#local LenJ=LenJ*Len;
    #local Twist=TwistIn/NumSegm;
    #local PosMin=min_extent(Object);
    #local PosMax=max_extent(Object);
    #local Dim=PosMax-PosMin;
    #local JumpInit=Dim/Divisions;
    #local Start=PosMin;
    #local XYZ=1;
    
    union{

    #if(HairFile!=0)
        #debug "Objets to file: on\n"
        #fopen OFile HairFile_Name write
        #write(OFile,"#declare Hairs=union{\n")
        #local FileO=1;
    #else #debug "Objets to file: off\n"
    #end
    #if(PointFile!=0)
        #debug "Points to file: on\n"
        #fopen PFile PointFile_Name write
    #else #debug "Points to file: off\n"
    #end       

    #debug "Calculating points...\n"
    #while (XYZ<=3)
        #local Count1=1;
        #local Count2=1;
        #switch(XYZ)
            #case(1) #local PosC=<PosMin.x+.5*JumpInit.x,PosMin.y+.5*JumpInit.y,PosMin.z-.1*JumpInit.z>;
                     #local NDir=z;
                     #local CountDim1=Divisions.x;
                     #local CountDim2=Divisions.y;
                     #local Jump1=JumpInit*x;
                     #local Jump2=JumpInit*y;
            #break
            #case(2) #local PosC=<PosMin.x-.1*JumpInit.x,PosMin.y+.5*JumpInit.y,PosMin.z+.5*JumpInit.z>;
                     #local NDir=x;
                     #local CountDim1=Divisions.z;
                     #local CountDim1=Divisions.y;
                     #local Jump1=JumpInit*z;
                     #local Jump2=JumpInit*y;
            #break
            #case(3) #local PosC=<PosMin.x+.5*JumpInit.x,PosMin.y-.1*JumpInit.y,PosMin.z+.5*JumpInit.z>;
                     #local NDir=y;
                     #local CountDim1=Divisions.x;
                     #local CountDim2=Divisions.z;
                     #local Jump1=JumpInit*x;
                     #local Jump2=JumpInit*z;
            #break
        #end

        #local Pos=PosC;
        #while(Count2<=CountDim2)
            #local SeedC=Count1+Count2;
            #local Flag=1;
            #local PosT=Pos+(1-NDir)*v_rand_ext(0,JumpInit/2*Jitter,Seed);
            #while(Flag=1)
                #local Rad=RadIn;
                #local N = <0,0,0>;
                #local Start = trace(Object, PosT, NDir, N);
    
                #if (N.x!=0 | N.y!=0 | N.z!=0)
                    
                    #local N=-N;
    
                    #if(PointFile!=0)
                        #write(PFile,Start,",",N,",\n")
                    #end
    
                    //If culling is enabled
                    #if(Culling!=0)
                        #local CullFlag=1;
                        
                        //Test for camera (first test point)
                        #local CamDir=vnormalize(TestPos[0]-Start);
                        #if(acos(vdot(CamDir,N))<MaxAngle)
                            #local CullFlag=0;
                        #end
                        
                        //Test for light sources (any points after camera)
                        #if(LightSw!=0&CullFlag=1)
                            #local LC=1;
                            #while(LC<CullTests&CullFlag=1)
                                #local LightDir=vnormalize(TestPos[LC]-Start);
                                #if(abs(acos(vdot(LightDir,N))-pi/2)<abs(MaxAngle-pi/2))
                                    #local CullFlag=0;
                                #end
                                #local LC=LC+1;
                            #end
                        #end
                    
                    #end //End culling
    
                    //Call Worm macro to create hairs
                    #if(CullFlag=0)
                        Worm(NumSegm,Len*(eval_pigment(LenPattern,Start).x),
                             Rad,
                             Start,-N,
                             Wind,BendExp,
                             Twist,Turb,Pigment,
                             Seed,HairFile)
                        #local HairNum=HairNum+1;
                    #else #local Culled=Culled+1;
                    #end
    
                    #local PosT=Pos+NDir*(Start-Pos)+(1-NDir)*v_rand_ext(0,JumpInit/2*Jitter,Seed);
    
                #else #local Flag=0;
                #end
            #end
            
            #if(Count1>=CountDim1)
                #local Pos=PosC+Count2*Jump2;
                #local Count1=1;
                #debug concat("Dim ",str(XYZ,0,0)," Block ",str(Count2,0,0)," of ",str(CountDim2,0,0),"\n")
                #local Count2=Count2+1;
            #else
                #local Pos=PosC+Count1*Jump1+(Count2-1)*Jump2;
                #local Count1=Count1+1;
            #end
        
        #end
        #local XYZ=XYZ+1;
    #end
    #if(HairFile!=0)
        #write (OFile,"}")
        #fclose OFile
    #end
    #if(PointFile!=0)
        #fclose PFile
    #end
    
    //Report stats
    #debug concat("Created ",str(HairNum,0,0)," hairs")
    #if(Culling!=0)
        #debug concat(" (discarded ",str(Culled,0,0),")\n")
    #else #debug "\n"
    #end
    }
#end



/*              THE Worm MACRO              */

//Generates random "Worm" or hair strand
//
//NumSegm:
//    number of segments
//Len:
//    length of worm
//RadStart:
//    worm start radius
//PStart:
//    start point
//DirStart:
//    initial direction
//Wind:
//    directional force applied to worm (vector)
//BendExp:
//    1 => Wind bends the worm uniformly; >1 => bends more towards end
//Random:
//    randomness in X,Y and Z directions (vector)
//Seed:
//    random number seed
//OutF:
//    1 => generate output file (works with fur macro, otherwise leave 0)

#macro Worm(NumSegm,Len,RadStart,PStart,DirStart,Wind,BendExp,Random,Turb,Pigment,Seed,OutF)
        #local CurSegm = 0;
        #local LenSegm = Len/NumSegm;
        #local PointStart = <1,1,1>*PStart;
        #local Col=eval_pigment(Pigment,PointStart);
        //#local NDir=vrotate(DirStart,v_rand_ext(0,Random,Seed));
        #local NDir=vrotate(DirStart,(vnormalize(vturbulence(Turb.y,Turb.z,Turb.x,PointStart/Turb.t))*90*Random));
        #local VDir=vnormalize(NDir+Interpolate(CurSegm+1,0,NumSegm,0,Wind,BendExp));
        #if(vdot(DirStart,VDir)<0)
            #if(abs(vdot(Wind,NDir))!=1)
                #local VDir=vnormalize(vcross(vcross(NDir,Wind),DirStart));
            #else
                #local VDir=NDir;
            #end
            //#debug concat("VDir=",v_debug(VDir),"\n")
        #end
        #local RadConst = RadStart;
        #local Obj=
        union{
            #if(OutF!=0)
            #write(OFile,"union{\n")
            #end
            #while (CurSegm < NumSegm)
                    #local RadEnd=(NumSegm-CurSegm-1)/NumSegm*RadConst;
                    #local PointEnd=PointStart+VDir*LenSegm;
                    cone {PointStart, RadStart, PointEnd, RadEnd}
                    /*#if(OutF!=0)
                    #write(OFile,"cone{",PointStart,",",RadStart,",",PointEnd,",",RadEnd,"}\n")
                    #end*/
                    #local CurSegm=CurSegm+1;
                    //#local Dir=vrotate(VDir,v_rand_ext(0,Random,Seed));
                    #local PointStart=PointEnd;
                    #local RadStart=RadEnd;
                    #local NDir=vrotate(VDir,(vnormalize(vturbulence(Turb.y,Turb.z,Turb.x,PointStart/Turb.t))*90*Random));
                    #local VDir=vnormalize(NDir+Interpolate(CurSegm+1,0,NumSegm,0,Wind,BendExp));
            #end
            pigment{rgb Col} finish{ambient .3 diffuse .5 specular .1 roughness .05}
            //bounded_by{sphere{PointStart,Len}} //Comment out for slightly faster render & larger memory consumption
        }
        #object{Obj bounded_by{box{min_extent(Obj),max_extent(Obj)}}}
        /*#if(OutF!=0)
        #write(OFile,"bounded_by{sphere{",PStart,",",Len,"}}}\n")
        #end*/
#end
