#version unofficial MegaPov 0.5;

#include "newfur.inc"

//camera{orthographic location <7.1/2-1.65,5,0> up 7.5*y right 7.5*x look_at (7.1/2-1.65)*x}
/*camera{location <-3,2,-4>*2 look_at y*.5}
light_source{<-10,10,-10> color 1}
plane{y,0 pigment{rgb 1}}
#declare FroggyHair=0;*/

global_settings{max_trace_level 7}

#declare Seed=seed(3232);

#declare FurPigment=
pigment{
    gradient x
    pigment_map{
        [.25
        marble
        color_map{[.2 hsl(.08,.2,.8)][.5 hsl(.03,1,.4)][.8 hsl(.08,.2,.8)]}
        scale 1/5
        warp{turbulence .5}
        scale 5
        scale 1
        ]
        [.5 hsl(.03,.7,.55)]
    }
    scale 7.1
    translate -x*1.7
    warp{reset_children}
}

#declare FurLength=
pigment{
    image_map{png "frog_map.png" interpolate 2}
    rotate x*90 translate (-x-z)*.5 scale 7.7 translate (7.1/2-1.65)*x
}

#declare BodyTex=
texture{
    pigment{
        average
        pigment_map{
            [.6
            crackle
            color_map{[.02 hsl(.01,.8,.4)][.07 hsl(.01,.5,.6)]}
            scale .5
            turbulence .2
            ]
            [1
            bozo
            color_map{[0 hsl(.01,.6,.7)][1 hsl(0,.8,.4)]}
            scale .3
            turbulence .2
            ]
        }
    }
    normal{
        average
        normal_map{
            [1
            crackle .6
            slope_map{[0,<1,0>][.06,<0,0>]}
            scale .5
            turbulence .2
            ]
            [1
            granite .5
            slope_map{[0,<0,1>][.5,<1,0>]}
            scale .3
            ]
        }
    }
    finish{ambient 0 specular .4 roughness .03}
}

#declare TongueTex=
texture{
    pigment{hsl(.97,.6,.45)}
    normal{granite .5 scale <1,.3,.3>}
    finish{ambient 0 brilliance 1.5 specular .3 roughness .03}
}

#declare Spine2Crackle=
pigment{
    crackle
    color_map{[0 hsl(.1,.2,.5)][.06 hsl(.1,.27,.9)]}
    scale <.12,.12,.35>
    turbulence .15
}

#declare Spine2Tex=
texture{
    pigment{
        radial
        pigment_map{
            [.87
            wood pigment_map{[.1 hsl(.03,.9,.6)][.15 Spine2Crackle]}
            rotate x*90
            warp{reset_children}
            ]
            [.89
            wood pigment_map{[.1 hsl(.01,1,.08)][.15 Spine2Crackle]}
            rotate x*90
            warp{reset_children}
            ]
            [.92
            wood pigment_map{[.1 hsl(.01,1,.08)][.15 Spine2Crackle]}
            rotate x*90
            warp{reset_children}
            ]
            [.97 Spine2Crackle]
        }
        //triangle_wave
        rotate -x*90
    }
    normal{
        bozo .35
        slope_map{[0,<0,0>][.5,<1,0>]}
        scale <.5,.5,.05>
    }
    finish{ambient .1 specular .3 roughness .04}
}

//Main body

#declare MainPath=
spline{
    cubic_spline
    0,<0.2,1.5,0>,
    .25,<1.2+.2,1,.2>,
    .5,<2.7+.2,.5,-.2>,
    .75,<3.95+.2,.3,.1>,
    .9,<4.9+.2,.2,-.1>,
    1,<5.2+.2,.5,0>
}

#declare MainScale=
spline{
    cubic_spline
    0,1.5,
    .25,1,
    .5,.5,
    .75,.35,
    .9,.2,
    1,.1
}

#declare Arm1Path=
spline{
    cubic_spline
    0,<0,1.5,0>,
    .25,<0,.8,-1.5>,
    .5,<-.8+.2,.5,-2>,
    .75,<-1.2+.2,.3,-2.8>,
    1,<-1.7+.2,.1,-3.5>
}

#declare Arm1Scale=
spline{
    cubic_spline
    0,.6,
    .25,.5,
    .5,.4,
    .75,.3,
    1,.2
}

#declare MouthPath=
spline{
    cubic_spline
    0,<.2,.7,0>+x*.4,
    .25,<-.4,.6,0>+x*.4,
    .5,<-.8,.5,0>+x*.4,
    .75,<-.9,.4,0>+x*.4,
    1,<-1,.4,0>+x*.4
}

#declare MouthScale=
spline{
    cubic_spline
    0,<.65,.5,.65>,
    .25,<.4,.4,.4>,
    .5,<.35,.35,.35>,
    .75,<.35,.3,.35>,
    1,<.35,.25,.35>
}

#declare TonguePath=
spline{
    cubic_spline
    //.5,<0,3.2,-1.4>,
    0,<-.8,.35,0>+x*.4,
    .3,<-1,.25,0>+x*.4,
    .4,<-1.15,.1,.05>+x*.4
    .6,<-1.4,.08,0>+x*.4
    .75,<-1.55,.03,0>+x*.4
    1,<-1.7,.02,0>+x*.4
}

#declare TongueScale=
spline{
    cubic_spline
    0,.15,
    .4,.15,
    1,.03
}

#declare MainJump=1/50;
#declare MainC=0;
#declare Arm1Jump=1/50;
#declare Arm1C=0;
#declare MouthJump=1/50;
#declare MouthC=0;

#declare Body=
blob{
    threshold .5
    #while(MainC<1)
        sphere{MainPath(MainC),MainScale(MainC).y,1}
        #declare MainC=MainC+MainJump;
    #end

    #while(Arm1C<1)
        sphere{Arm1Path(Arm1C),Arm1Scale(Arm1C).y,1}
        #declare Arm1C=Arm1C+Arm1Jump;
    #end
    #declare Arm1C=0;
    #while(Arm1C<1)
        sphere{Arm1Path(Arm1C)*<1,1,-1>,Arm1Scale(Arm1C).y,1}
        #declare Arm1C=Arm1C+Arm1Jump;
    #end

    #while(MouthC<1)
        sphere{0,1,1 scale MouthScale(MouthC) translate MouthPath(MouthC)}
        #declare MouthC=MouthC+MouthJump;
    #end
    clipped_by{box{<-1.5,0,-.5>,<-.6,1,.5> inverse}}
    scale <1,.75,1>
    hollow
}

//Throat

#declare ThroatC=0;
#declare ThroatJump=1/30;
#declare RingN=20;
#declare RingC=0;
#declare RingA=array[RingN]
#while(RingC<RingN)
    #declare RingA[RingC]=vrotate(y,x*360/RingN*RingC);
    #declare RingC=RingC+1;
#end
#declare Throat=
blob{
    #while(ThroatC<1)
        #declare RingC=0;
        #while(RingC<RingN)
            sphere{RingA[RingC]*MouthScale(ThroatC)*<1,.75,1>*.75+v_rand_ext(0,.015,Seed),.08,1 translate MouthPath(ThroatC)}
            #declare RingC=RingC+1;
        #end
        #declare ThroatC=ThroatC+ThroatJump;
    #end
    translate -y*.1
}

//Tongue

#declare Tongue=
blob{
    #declare TongueC=0;
    #declare TongueJump=1/100;
    #while(TongueC<1)
        sphere{TonguePath(TongueC),TongueScale(TongueC).x,1}
        #declare TongueC=TongueC+TongueJump;
    #end
    texture{TongueTex}
}

//Eyes

#declare EyeDir=vnormalize(<-1,-.3,0>);
#declare EyeSpread=<0,45,15>;
#declare EyeCount=8;
#declare C=0;
#declare Eyes=
union{
    #while(C<EyeCount)
        #declare EyeDir_L=vrotate(EyeDir,v_rand_ext(0,EyeSpread,Seed));
        #declare Pos=trace(Body,y*1.5,EyeDir_L);
        sphere{Pos,rand_ext(.15,.03,Seed)}
        #declare C=C+1;
    #end
}

#declare BodyShape=
object{Body clipped_by{object{Eyes inverse}}}

#declare Eyes=
object{
    Eyes
    pigment{hsl(0,.7,.1)}
    finish{
        ambient 0 specular .6 roughness .02
        reflection_min 0 reflection_max .5 reflect_metallic .2
    }
}

//Dorsal claw
#declare Spine=
difference{
    difference{
        sphere{0,1}
        box{-1,1-x}
        box{-1,1-y}
    }
    cylinder{z,-z,1 scale <.88,1,1>}
    texture{Spine2Tex}
    translate <-1,0,0>
    scale <-1,1,.2>
    //rotate z*30
}

//Hand claw
#declare Spine2=
difference{
    difference{
        sphere{0,1}
        box{-1,1-x}
        box{-1,1-y}
    }
    cylinder{z,-z,1 scale <.8,1,1>}
    texture{Spine2Tex}
    scale <-1,1,.2>
    translate <.75,0,0>
}

#declare Spine2T1=
transform{
    scale 1.2
    rotate y*180 rotate z*50 rotate -x*30 rotate y*20
    translate <-1.5,.05,-3.2>
}

#declare SpineScale=
spline{
    cubic_spline
    0,1,
    .12,1.2,
    .25,.8,
    .5,.45,
    .7,.35,
    .75,.25
    .85,.45
    1,.65
}

#declare DorsalSpines=
union{
#declare SpineJump=1/17;
#declare SpineC=0;
#while(SpineC<1)
    #declare N=<0,0,0>;
    #declare Pos=trace(Body,MainPath(SpineC),vrotate(y,pow(1-SpineC,3)*z*60),N);
    #declare HOrient=vnormalize((MainPath(SpineC+MainJump)-MainPath(SpineC))*<1,0,1>);
    object{
        Spine
        rotate pow(1-SpineC,3)*z*45
        scale SpineScale(SpineC)
        Reorient(y,N)
        Reorient(x,HOrient)
        translate Pos
    }
    #declare SpineC=SpineC+SpineJump;
#end
}

//Put all together

union{
    object{Body}
    object{Throat}
    object{Tongue}
    object{Eyes}
    object{Spine2 transform Spine2T1}
    object{Spine2 transform Spine2T1 scale <1,1,-1>}
    object{DorsalSpines}
    texture{BodyTex}
    translate <11,0,0>
}

//Generate the hair

#if(FroggyHair)
union{
Fur(BodyShape,60,.5,
    2,.35,.012,
    -y,1,.5,<2,.5,6,.1>,
    0,0,0,0,
    0,0,0,
    FurPigment,FurLength
)
translate x*11
}
#end
