#version unofficial MegaPov 0.5;

#include "hsl.inc"
#include "absurd.inc"

#declare Atmosphere=0;
#declare Focalblur=0;
#declare Wall=1;
#declare FloorType=2; //1 = plane, 2 = isosurface
#declare Froggy=1;
#declare FroggyHair=1;
#declare Shooters=1;
#declare Particles=1;

global_settings{
    max_trace_level 7
    radiosity{
        count 80
        error_bound 1
        pretrace_start 0.08
        pretrace_end 0.02
        recursion_limit 4
        gray_threshold .2
        nearest_count 8
        //save_file "absurd.rad"
        //load_file "absurd.rad"
        //always_sample 0
    }
}

#declare LightPos=<-5,10,-5>*6;

//camera{location <2,4,-10> look_at <5,1,0>}
//light_source{<-5,10,-5>*10 rgb 1}

camera{
    location <2,4,-10>*1.05 up y right 2*x look_at <4.25,1.3,0> angle 85
    //location <18,4,-10> up y right 2*x look_at <10,1,0> angle 85
    #if(Focalblur) aperture .18 focal_point <4,1,0> blur_samples 30 confidence .999 variance 1/256 #end
}

light_source{LightPos rgb .8 fade_distance 180 fade_power 2 media_interaction off media_attenuation off}
//light_source{<2,4,-10>*1.05 rgb .2 fade_distance 180 fade_power 2 shadowless media_interaction off media_attenuation off}

#declare FloorTex=
texture{
    boxed
    texture_map{
        [.025
        pigment{hsl(.115,.4,.8)}
        normal{
            bozo
            //slope_map{[0,<0,0>][.28,<.8,1>][.3,<1,0>]}
            scale .1
        }
        finish{
            ambient 0 diffuse .7 brilliance 6 specular .6 roughness .05 metallic .6
            reflection_min .3 reflection_max .6  reflect_metallic .6 //reflection_exponent .8
        }
        ]
        [.025
        pigment{
            average
            pigment_map{
                [1
                granite
                color_map{[.2 hsl(.75,.1,.7)][.5 hsl(.5,.2,.25)]}
                scale .15
                ]
                [.4
                agate
                color_map{[.1 hsl(.5,.15,.4)][.3 hsl(.75,.1,.7)]}
                scale 1/10
                warp{turbulence .5 lambda 2.3 octaves 8}
                scale 10
                scale .6
                rotate y*30
                warp{repeat x offset 5*z}
                warp{repeat z offset 7*x}
                //agate_turb .2
                ]
            }
        }
        normal{
            granite .3
            slope_map{[.2,<0,0>][.5,<0,1>][1,<1,0>]}
            scale .15
        }
        finish{ambient 0 crand .1}
        ]
    }
    translate <1,0,1> scale .5
    warp{repeat x}
    warp{repeat z}
    warp{reset_children}
    scale 3
}

#declare WallTexA=
texture{
    pigment{
        granite
        color_map{[0 hsl(.03,.6,.5)][.2 hsl(.6,.1,.7)]}
        scale 6
    }
    normal{granite .1 scale 4}
    finish{ambient 0 crand .1}
}
#declare WallTexB=
texture{
    pigment{
        granite
        color_map{[0 hsl(.78,.4,.4)][.15 rgbf 1]}
        scale 6.8
    }
    finish{ambient 0}
}
#declare WallTex=
texture{WallTexA}
texture{WallTexB}


//OBJECTS

//Atmosphere

#if(Atmosphere)
box{<-1000,-1,-1000>,1000
    pigment{rgbf 1}
    finish{ambient 0 diffuse 0}
    interior{
        media{
            method 3
            samples 3,3
            aa_level 4
            //intervals 30
            confidence .99
            variance 1/128
            scattering{5, .05 extinction .05 eccentricity .6}
        }
    }
    hollow
}
#end

//Floor

#declare Floor=
plane{y,0 texture{FloorTex} rotate -y*30}

#if(FloorType!=1)
#declare TileFunc=
function{pigment{boxed color_map{[.025 rgb 1][.04 rgb 0]} translate <1,0,1> scale .5 warp{repeat x} warp{repeat z} scale 3}}
isosurface{
    function{y+TileFunc(x,y,z)*.025}
    contained_by{box{<-1000,-.1,-1000>,<1000,0,1000>}}
    max_gradient 5
    //pigment{rgb .5}
    texture{FloorTex}
    rotate -y*30
    hollow
}
#else
object{Floor}
#end

//Wall

#if(Wall)

#declare Function1=function{y}
#declare Function2=function{"ridgedMF" <.8,3,7,1,.8>}
isosurface{
    function{Function1(x,y,z)-Function2(x,y,z)}
    //function{noise3d(x,y,z)}
    //threshold .8
    //eval
    max_gradient 8
    contained_by{box{<-1000,-2,-1000>,<1000,2,1000>}}
    scale 800*<.5,-1,.5>
    texture{WallTex}
    translate y*1000
    hollow
}

#end

//Shooters

#if(Particles|Shooters)
#include "shooter.inc"
#declare EmitterPos=
transform{
    rotate z*10
    translate 1.8*y
    scale .8
    translate -x*.5
}

#declare MagneticField=
cylinder{0,x*(Dist+.9),.3*3/4 open transform EmitterPos}
#end

#if(Shooters)
object{Shooter(-50,58, -90,120, 0,50, 0,50) transform EmitterPos}
object{Shooter(-70,70, -30,40, 10,30, -15,90) rotate -x*10 rotate -z*5 rotate y*45 translate <-8,2.55,25>}
object{Shooter(-30,30, -40,30, 0,30, -15,40) rotate -x*5 rotate z*10 rotate y*65 translate <-10,2.5,50>}
object{Shooter(20,120, 20,120, 40,120, 40,120) rotate -z*10 rotate y*65 translate <-35,2.2,75>}
object{Shooter(-30,60, -0,120, 60,70, 0,50) rotate -z*5 rotate y*55 translate <-50,2.5,100>}
object{Shooter(-30,30, -40,30, 0,30, -15,40) rotate -x*5 rotate z*10 rotate y*50 translate <-55,2.5,130>}
object{Shooter(20,110, 20,110, 40,120, 40,120) rotate z*5 rotate y*35 translate <-28,2.5,48>}

#end

//Froggy

#if(Froggy)

#include "froggy.inc"

#end

//Particle spray

#if(Particles)

#declare Environ=union{object{Floor} object{MagneticField} #if(Froggy) object{Body translate x*11} #end}

#declare PA=array[6]{1.41*y,-x-z,x-z,x+z,z-x,-y*1.41}
#declare PA=a_scale(PA,.018)
#declare P1=
mesh{
    triangle{PA[0],PA[1],PA[2]}
    triangle{PA[0],PA[2],PA[3]}
    triangle{PA[0],PA[3],PA[4]}
    triangle{PA[0],PA[4],PA[1]}
    triangle{PA[5],PA[1],PA[2]}
    triangle{PA[5],PA[2],PA[3]}
    triangle{PA[5],PA[3],PA[4]}
    triangle{PA[5],PA[4],PA[5]}
    hollow
}
#declare P2=box{-.018,.018}
#declare Seed=seed(33232);
#declare Rate=120;
#declare Speed=1.2;
#declare Bounce=0.1;

#declare PartSys=
particle_system {
	wind < 0, 0, 0>
	gravity < 0,-0.08, 0>
	iterations 600
	//time 150
	time 120
	jitter 0.05
	drag .05
	environment object {Environ}
	threshold 1
				
	particle_emitter {
	    //type 1
		location vtransform(x*Dist,EmitterPos)
		//object {sphere {vtransform(x*Dist,EmitterPos),.1}}
		radius 0.023
		lifespan 5000
		rate Rate
		elasticity Bounce
		direction vrotate(x,z*10)*Speed
		particle_stretch 0,0
//		direction < 1, 1, 0>
		angle 5
        
        /*ipf_profile {
        	2, .1,
        	//IPFspline
        	.015,1
    	}*/
	}
	texture {
		pigment {color hsl(.6,.4,.8)}
		finish {brilliance 3 specular .5 roughness .05}
	}
	//interior{ior 1.44}
}

#declare Num=get_particle(PartSys);
#declare C=0;
#declare Pos=<0,0,0>;
union{
#while(C<Num)
    #declare X=get_particle(PartSys,C,Pos);
    #declare PartTex=
    texture{
        pigment{hsl(rand_ext(.1,.06,Seed),rand_ext(.3,.2,Seed),rand_ext(.7,.3,Seed))}
        finish{brilliance 1.5 specular .2 roughness .05}
    }
    #if(Chance(.7,Seed))
        object{P1 rotate v_rand_ext(0,360,Seed) translate Pos texture{PartTex}}
    #else
        object{P2 rotate v_rand_ext(0,360,Seed) translate Pos texture{PartTex}}
    #end
    #declare C=C+1;
#end
}

#end
