//Array scale
//V - scale vector (or float)
#macro a_scale(Array,V)
    #local C=dimension_size(Array,1);
    #local NewArray=array[C]
    #while(C>0)
        #local NewArray[C-1]=Array[C-1]*(V+<0,0,0>);
        #local C=C-1;
   #end
   NewArray
#end

//return 1 with the likelyhood of P (from 0 to 1, constant distribution)
//otherwise return 0
#macro Chance(P,Seed)
    #local R=abs(rand(Seed)-.5)*2;
    (#if(R>=(1-P)) 1 #else 0 #end)
#end

//Create random number of given mean and maximum deviation
//M - mean value
//D - maximum deviation
//Seed - (declared) random number seed identifier
#macro rand_ext(M,D,Seed)
        (M+(rand(Seed)-.5)*2*D)
#end

//Give a random vector of given mean and max deviation
//M - mean (vector/float)
//D - max deviation (vector/float)
//Seed - (declared) random number seed identifier
#macro v_rand_ext(M,D,Seed)
        #local MV=M+<0,0,0>;
        #local DV=D+<0,0,0>;
        (<rand_ext(MV.x,DV.x,Seed),rand_ext(MV.y,DV.y,Seed),rand_ext(MV.z,DV.z,Seed)>)
#end

//John VanSickle's reorient macro
#macro Reorient(Axis1,Axis2)
        #local vX1=vnormalize(Axis1);
        #local vX2=vnormalize(Axis2);
        #local vY=vnormalize(vcross(vX1,vX2));
        #local vZ1=vnormalize(vcross(vX1,vY));
        #local vZ2=vnormalize(vcross(vX2,vY));
        matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
        matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
