#version unofficial MegaPOV 0.5;


global_settings {
ini_option "+QR"

radiosity {
  	
    count 150*1             
    nearest_count 2     // number of samples to average - higher smoother
    error_bound 3      // lower increases shadow detail but increases render time
    recursion_limit 4    
    
    low_error_factor .5  
    gray_threshold 0.0   
    minimum_reuse 0.015  
    brightness .5          
    normal on  
    max_sample 1 //doesn't really do anything in this scene

    } 
  
}


#include "colors.inc"

camera {location <20, 40, -40> look_at <0, 5, 0> angle 55}

light_source {<0, 0, -1000> color 1*White 
area_light <500, 0, 0>, <0, 0, 500>, 8, 8
adaptive 1
jitter 
orient
rotate 80*x rotate -55*y 
} 

sky_sphere{
  pigment{
        gradient y
        color_map{
                [0 rgb <1, 1, 1>]
                [1 rgb <.4, .5, 1>]
        }
  }
} 
 
plane {y, 0
pigment {color rgb 1} 
finish {ambient 0}
}   

/* little things in the flower */

#declare loop_this = 1;
#declare R1 = seed (42534);

#while (loop_this < 50)

union {
cylinder {<0, 0, 0>, <0, 8, 0>, .05}
sphere {<0, 8, 0>, .15}
pigment {color rgb <1, .7, .2>}
finish {diffuse .9 brilliance .5}

rotate -loop_this*x  translate -.04*loop_this*z
rotate rand(R1)*360*y
no_shadow
}

#declare loop_this = loop_this + 1;
#end

union {
#include "flower.inc"
//double_illuminate
}