// Radiosity test file
// Gilles Tran - august 2000
#version unofficial Megapov 0.5;
#include "colors.inc"
global_settings{   
        ini_option "+QR"
        radiosity{
                recursion_limit 5    // CHANGE
                brightness 1.2         // leave this
        
        }
}
// ----------------------------------------
camera
{
  location  <0.0, 6, -21.0>
  direction 1*z
  right     4/3*x
  look_at   <0, 1.0,  2>
}

#declare Blanc=rgb<226,224,228>/255;
#declare Bleu=rgb<55,105,201>/255;
#declare Jaune=rgb<243,199,107>/255;
sky_sphere{
  pigment{       
        gradient y
        color_map{
                [0 White]
                [1 Bleu]
        }
  }
} 

                           
#declare PdV=<-1,0.5,-0.5>*1000 ;
light_source{PdV color Jaune fade_power 2 fade_distance 2000
area_light 100*x 100*z  5,5 jitter orient
}
#declare txt1=texture{
        pigment{crackle solid color_map{[0 color White*0.7][1 color White*1.3]}}
        normal{agate 0.4}
        finish{ambient -0.3 diffuse 0.9 specular 0.1 roughness 0.1 metallic brilliance 1}
        scale 0.3
}
#declare rd=seed(3);                
#declare Deco=array[7]
#include "pipedeco.inc"
#declare p1=object{#include "pipe_1.inc"}
#declare p2=object{#include "pipe_2.inc"}
object{p1 texture{txt1} rotate x*90 translate y*30 scale 0.3 translate <-5,0,20>}
object{p1 texture{txt1} rotate x*90 translate y*30 scale 0.3*<1,1,-1> translate <-1,0,0>}
object{p2 texture{txt1} rotate x*90 scale 0.3 translate <2,0,-10>}
object{p2 texture{txt1} rotate x*90 rotate y*90 scale 0.3 translate <5,0,10>}

box{<-100,-1,-200>,<100,0,50> texture{txt1}}
