// Persistence of Vision Ray Tracer Include File 

// Part of the IRTC GIP object archives 

// Version: 1.0

// Object: Trees 

// Object Description: Trees for the fair.pov image

// Author: Ray Benjamin 

// E-mail: rbenjam2@tampabay.rr.com 

// Web page: www.raybenjamin.com 

// Date (yyyy.mm.dd): 1999.12.27 



// Origin: center bottom 

// Orientation: n/a 

// Dimensions:  



// Includes required: 

// Example: 

// Variables: 



// Scaling ///////////////////////////////////////////////////// 

// 1 cm = 1 baseUnit 

#ifndef(baseUnit) #declare baseUnit = 1; #end 

/////// DO NOT CHANGE ANYTHING BELOW ///////////////////////////// 

// Metric 

#ifndef (m) /***meter****/ #local m  = 100 *baseUnit; #end 

#ifndef(cm) /*centimeter*/ #local cm = 1.0 *baseUnit; #end 

#ifndef(mm) /*millimeter*/ #local mm = 0.1 *baseUnit; #end 

// English 

#ifndef(in) /*inch*/ #local in = 2.54 *baseUnit; #end 

#ifndef(ft) /*foot*/ #local ft = 12*in*baseUnit; #end 

#ifndef(yd) /*yard*/ #local yd = 3*ft *baseUnit; #end 

////////////////////////////////////////////////////////////////// 



global_settings{assumed_gamma 1} 



// Pine



#local T_pine_bark = texture {

    pigment {Brown}

    }



#local T_pine_needles = texture {

    pigment {

        bozo

        color_map {

            [0.0 Green]

            [0.2 DarkGreen]

            [0.3 DarkGreen]

            [0.3 Clear]

            [1.0 Clear]

            }

        }

    scale 2

    }

    

#local pine_trunk_rad = 20*cm;

#local pine_ht = 15*m;

#local pine_branches = 10;



#declare rb_pine = union {

    cone { <0,0,0>, pine_trunk_rad, <0,pine_ht,0>, 3*cm texture {T_pine_bark}}

    sphere {<0,0,0>, 1*m texture {T_pine_needles} scale <1,.3,1> translate pine_ht*7/8*y}

    sphere {<0,0,0>, 1*m texture {T_pine_needles} scale <1.2,.28,1> rotate 20*y translate <2*ft,pine_ht*6/8,0>}

    sphere {<0,0,0>, 1*m texture {T_pine_needles} scale <1.2,.28,1> rotate -30*y translate <-2*ft,pine_ht*5/8,0>}

    }

//

// Pond Plants

//

// cattails

#local ct_avg_Height = 6*ft;

#local ct_max_Height = 9*ft;

#local ct_flower_ht = 8*in;

#local ct_flower_rad = 1*in;

#local ct_stem_rad = 0.125*in;



#local T_ct_head = texture {

    pigment { Brown }

    }

    

#local T_ct_stalk = texture {

    pigment { Tan }

    }

    

#local T_ct_leaves = texture {

    pigment { Green }

    }    



// lily pads



// grasses