// Persistence of Vision Ray Tracer Scene Description File
// File: layout.pov
// Vers: 3.1g
// Desc: Include file defining objects that can be helpful when laying out a scene 
// Date: 12/8/1999 
// Auth: Ray Benjamin

// Origin Marker

#declare T_Origin = texture {
    pigment {Red}
    finish {ambient 1}
    }

#declare T_X = texture {
    pigment {
        gradient x
        color_map  {
            [0.0 Yellow]
            [1.0 Black]
            }
        }
    finish {ambient 1}
    scale <10*m,1,1>
    }

#declare T_Y = texture {
    pigment {
        gradient y
        color_map {
            [0.0    Yellow]
            [1.0    Black]
            }
    }
    finish {ambient 1}
    scale <1,1*m,1>
    }

#declare T_Z = texture {
    pigment {
        gradient x
        color_map {
            [0.0 Green]
            [1.0 Red]
            }
        }
    finish {ambient 1}
    scale <10*m,1,1>
    }
        
#declare Origin_Marker = union {
    #local osize = .5*m;
    #local hsize = .1*km;
    #local vsize = 10*m;
    #local crad = 10*cm;
    #local vstick = cylinder {-vsize*y, vsize*y, crad texture {T_Y}}
    #macro make_hstick(tex)
      union {
        object {vstick translate -hsize*x}
        sphere {<-hsize,0,0>, osize texture {T_Origin}}
        cylinder {-hsize*x, hsize*x, crad texture {tex}}
        sphere {<-hsize,0,0>, osize texture {T_Origin}}
        object {vstick translate hsize*x texture {T_Y}}
        }
    #end
    // origin
    sphere {<0,0,0> osize texture {T_Origin}}
    // x axis
    object {make_hstick(T_X)}
    // z axis
    object {make_hstick(T_Z) rotate 90*y}
    // y axis
    object {vstick}
    }

/////////////////////////
// Bob
////////////////////////

#declare Bob = cylinder {<0,0,0>, <0,6*ft,0>, 1*ft pigment {Black}} 

