// Persistence of Vision Ray Tracer Scene Description File
// File: fairwater.inc
// Vers: 3.1g
// Desc: Include file for fair.pov, this file describes the water elements 
// Date: 12/8/1999
// Auth: Ray Benjamin

// Scaling ///////////////////////////////////////////////////// 
// 1 cm = 1 baseUnit 
#ifndef(baseUnit) #declare baseUnit = 1; #end 
/////// DO NOT CHANGE ANYTHING BELOW ///////////////////////////// 
// Metric 
#ifndef (m) /***meter****/ #local m  = 100 *baseUnit; #end
#ifndef (km) /*kilometer*/ #local km = 1000*m; #end
#ifndef(cm) /*centimeter*/ #local cm = 1.0 *baseUnit; #end 
#ifndef(mm) /*millimeter*/ #local mm = 0.1 *baseUnit; #end 
// English 
#ifndef(in) /*inch*/ #local in = 2.54 *baseUnit; #end 
#ifndef(ft) /*foot*/ #local ft = 12*in*baseUnit; #end 
#ifndef(yd) /*yard*/ #local yd = 3*ft *baseUnit; #end 
////////////////////////////////////////////////////////////////// 

// Control Variables

#ifndef(SimpleWater)
    #local SimpleWater = 0;
#end    

#declare T_Water=texture {
   pigment { red 0.9 green 0.9 blue 1.0 filter 1 }
   normal {
      waves 0.05
      frequency 2000.0
      scale 2000.0
   }
   finish { reflection 0.5 }
}

// Used for creek Water Flowing into pond
#declare T_Creek =
 texture{
 
        pigment { CornflowerBlue filter 0.80 transmit 0.20}
        normal {
                waves 0.08
                frequency 300.0
                scale 50}
        finish {
                ambient 0.1
                diffuse 0.1
                reflection 0.8   }
        
        }

    
#declare Creek = box {<-0.1*km,-4*m, -0.1*km>, <0.1*km,0*cm,0.1*km> hollow on
    #if (SimpleWater = 0)
        texture {T_Water}
        interior {
            ior 1.33
            fade_distance 2*m
            fade_power 2
            }
    #else
        pigment {Blue}
    #end
    }
 
/////////// Fountain ////////////// -- Place Holder

// Stepping Stones
#local Fountain_BaseRad = 3*m;

#declare T_StepStone = texture {
    T_Grnt9
    }

#declare SpiralArm = union {
    #local StepHeight = 10*cm;
    #local rad = 2*m;
    #local ang = 20;
    #local MaxStone = 8;
    #local ct = 0;
    #local x_off = 1*m;
    #local radmult = 2.0;
    #while (ct < MaxStone)
        cylinder { <0,-5*m,0>, <0,StepHeight,0>, rad 
            translate x_off*x
            rotate ang*ct*y
            }
        #local x_off = x_off + rad*radmult;
        #local rad = rad * 0.92;
        #local ang = ang * 0.92;
        #local radmult = radmult * 0.94;
        #local ct = ct + 1;
    #end
    texture {T_StepStone}
    translate <Fountain_BaseRad+120*cm,0,0>
    }

#declare StepStones = union {
    object {SpiralArm} 
    object {SpiralArm rotate 120*y} 
    object {SpiralArm rotate -120*y} 
    }

// Fountain for the pool in the park
#declare T_Fountain_Base = texture {
    T_Grnt9
    }
#declare T_Fountain_Mid = texture {
    pigment {Gray90}
    finish {Shiny}
    }
#declare T_Fountain_Top = texture {
    pigment {White}
    finish {Shiny}
    }

#declare T_Fountain_Center = texture {
    Polished_Chrome
    }
    
    
#declare Fountain = union {
    #local BaseRad = Fountain_BaseRad;
    #local MidRad = 1.5*m;
    #local TopRad = .5*m;
    #local CenterRad = 0.1*m;
    cylinder {<0,-5*m,0>, <0,10*cm,0>, BaseRad texture {T_Fountain_Base}}
    cylinder {<0,0,0>, <0,0.25*m,0>, MidRad texture {T_Fountain_Mid} translate <0,1*m,0>}
    cylinder {<0,0,0>, <0,0.1*m,0>, TopRad texture {T_Fountain_Top} translate <0,2*m,0>}
    cylinder {<0,0,0>, <0,3*m,0>, CenterRad texture {T_Fountain_Center}}

    object {StepStones}
    }

