// Persistence of Vision Ray Tracer Include File 
// Part of the IRTC GIP object archives 
// Version: 

// Object: Sky definitions 
// Object Description: Sky 
// Author: Ray Benjamin 
// E-mail: rbenjam2@tampabay.rr.com
// Web page: www.raybenjamin.com 
// Date (yyyy.mm.dd): 1999.12.12 

// Origin: none 
// Orientation: none 
// Dimensions: none 

// Includes required: 
// Example: 
// Variables: 

// ///////////////////////////////////////////////////////////////////

#declare Sun = 
light_source {
    0*x
    White  // light's color
    looks_like { sphere { 0*x, 5 pigment { Yellow } } }
}

// ///////////////////////////////////////////////////////////////////

#if ( ShowSky = 1 )

   #if ( ShowDetails = 1 )
   #declare gip_sky=
   sky_sphere {
       pigment {
           gradient y
           color_map {
            [0.005 color rgb <0.27734, 0.53516, 0.66016>]
            [0.6 color MidnightBlue]
            [0.9 color rgb <0.19922, 0.61719, 0.73828>]
            }//end map
           }//end y pigment
       pigment { 
           gradient x
           frequency 0.999
           phase 0.15
           turbulence 0.75
           octaves 6
           omega .5
           lambda 3.0
           color_map {
             [0.00, 0.30 color rgbft <0.27734, 0.53516, 0.66016, 0.5, 0.5>
                         color rgbft <0.19922, 0.61719, 0.73828, 0.4, 0.6> ]

             [0.30, 0.40 color rgbft <0.19922, 0.61719, 0.73828, 0.4, 0.6> 
                         color rgbft <0.60400, 0.71000, 0.73700, 0.4, 0.6> ]

             [0.40, 0.50 color rgbft <0.60400, 0.71000, 0.73700, 0.4, 0.6>
                         color rgbft <0.84700, 0.84300, 0.81600, 0.6, 0.4> ]

             [0.50, 0.55 color rgbft <0.84700, 0.84300, 0.81600, 0.4, 0.6>  
                         color Wheat filter 0.7 transmit 0.3 ]

             [0.55, 0.61 color Wheat filter 0.5
                         color Wheat ]

             [0.61, 0.70 color Wheat
                         color Wheat filter 0.5 ]

             [0.70, 0.71 color Wheat filter 0.5
                         color rgbft <0.847, 0.843, 0.816, 0.4, 0.6> ]//transmit  0.5
 
             [0.71, 0.80 color rgbft <0.847, 0.843, 0.816, 0.4, 0.6> 
                         color rgbft <0.604, 0.710, 0.737, 0.5, 0.5> ]

             [0.80, 1.00 color rgbft <0.604, 0.710, 0.737, 0.8, 0.2> 
                         color Clear ]
             }//end map
         scale <4,0.50,6> 
         translate -0.10*y
         rotate 45*y
               }//end x pigment 
   } // sky sphere
      sky_sphere{gip_sky}
   #else   // show plain sky:

   #declare gip_sky=           //MBH version
      sky_sphere { pigment  { LightBlue } }  // day
       sky_sphere{gip_sky}
   #end    // if show details

#else   //if not show sky, just show some plain color:

   #declare gip_sky=           //MBH version
      sky_sphere { pigment  { LightBlue } }  // day
      sky_sphere{gip_sky}
#end   // of if show sky

// ///////////////////////////////////////////////////////////////////
