// Persistence of Vision Ray Tracer Include File 
// Part of the IRTC GIP object archives 
// Version: 3.1g
// Author: Ray Benjamin
// E-mail: rbenjam2@tampabay.rr.com 
// Web page: www.raybenjamin.com 
// Date (yyyy.mm.dd): 12/22/1999
// Copyright 1999, 2000, Ray Benjamin, all rights reserved. 

// Object: rb_ground  
// Object Description: A Height Field used for the ground in fair.pov 
// Origin: Center of the Height Field 
// Orientation: 
// Dimensions:  1 x 1 x 1 s/b scaled to correct size 
// Version Info
// 0.1 - 12/22/1999 - Initial Version

// Includes required: colors.inc 
// Example: 
// Variables: 

// Scaling ///////////////////////////////////////////////////// 
// 1 cm = 1 baseUnit 
#ifndef(baseUnit) #declare baseUnit = 1; #end 
/////// DO NOT CHANGE ANYTHING BELOW ///////////////////////////// 
// Metric 
#ifndef (m) /***meter****/ #local m  = 100 *baseUnit; #end 
#ifndef(cm) /*centimeter*/ #local cm = 1.0 *baseUnit; #end 
#ifndef(mm) /*millimeter*/ #local mm = 0.1 *baseUnit; #end 
// English 
#ifndef(in) /*inch*/ #local in = 2.54 *baseUnit; #end 
#ifndef(ft) /*foot*/ #local ft = 12*in*baseUnit; #end 
#ifndef(yd) /*yard*/ #local yd = 3*ft *baseUnit; #end 
////////////////////////////////////////////////////////////////// 

global_settings{assumed_gamma 1} 




// Control Variables
#ifndef (UseContours)
    #declare UseContours = 0;
#end

// Textures to be used to add realism to the heightfield

// Bottom Mud
// Mud meant to be viewed through a water texture
#declare T_BottomMud = texture
{
  pigment
  {
    granite
    turbulence 0.4  octaves 3  omega 0.31
    color_map
    {
      [0.00 color rgb<0.357, 0.200, 0.086>]
      [0.33 color rgb<0.247, 0.129, 0.078>]
      [1.00 DarkBrown]
    }
  }
  normal
  {
    wrinkles 0.4
    turbulence 0.8
    phase 0.2
    frequency -3
  }
  finish {
    phong 0.2    phong_size 238
  }
}

// Mud that would be found in the shallows of a pond
#declare T_ShallowMud = texture
{
  pigment
  {
    spotted
    turbulence 0.8
    color_map
    {
      [0.00 color rgb<0.357, 0.200, 0.086>]
      [1.00 DarkBrown]
    }
  }
  normal
  {
    wrinkles 0.4
    turbulence 0.8
  }
  finish {
    diffuse 0.8
    reflection 0.15
  }
}

// Mud Covered with Algae
#declare T_AlgaeMud =
texture {
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgb<0.357, 0.200, 0.086>]
      [1.00 color rgb<0.000, 0.000, 0.000>]
    }
  }
  normal
  {
    wrinkles 0.6
    turbulence 0.4
  }
  finish {
    reflection 0.2
  }
}
texture {
  pigment
  {
    spotted
    turbulence 1.6
    color_map
    {
      [0.00 color rgbf<0.298, 0.298, 0.184, 0.196>]
      [0.20 color rgbf<0.118, 0.537, 0.118, 0.196>]
      [0.25 color rgbf<0.110, 0.529, 0.110, 0.396>]
      [0.32 color rgb<0.004, 0.078, 0.004>]
      [0.37 color rgb<0.110, 0.349, 0.286>]
      [0.43 color rgbf<1.000, 1.000, 1.000, 0.976>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 0.996>]
    }
  }
  normal
  {
    bumps 0.0
    turbulence 0.8
  }
}



    

#declare T_Algae = texture {
    pigment {DarkGreen}
    }

// The Bank of a stream or pond - a sandy one
#declare T_Bank =
texture {
  pigment
  {
    colour rgb<0.357,0.200,0.086>
  }
  normal
  {
    bumps 0.4
    turbulence 0.4  octaves 5
    frequency 5
  }
  finish {
    crand 0.3
  }
}
texture {
  pigment
  {
    gradient y
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 0.996>]
      [1.00 color rgb<0.839, 0.839, 0.737>]
    }
  }
  normal
  {
    bumps 0.6
    phase 0.2
  }
  finish {
    crand 0.01
  }
}

//    pigment {rgb <.2,.95,.3>}

#declare P_Grass1 =  pigment {
    agate
    color_map {
        [0.0 rgb <.2,.98,.3>]
        [0.4 rgb <.2,1,.3>]
        [0.6 Brown]
        [0.65 Tan]
        [0.69 DarkGreen]
        [0.71 Brown]
        [0.8 rgb <.2,.97,.3>]
        [0.9 DarkGreen]
        [1.0 ForestGreen]
        }
    turbulence .5
    scale .0005
    }

#declare P_Grass2 = pigment {
    marble
    color_map {
        [0.0 Tan]
        [0.5 DarkGreen]
        [1.0 ForestGreen]
        }
    turbulence 1.5
    scale 1
    }

#declare T_Grass = texture {
    pigment {
        average
        pigment_map {
            [1.0 P_Grass1]
            [2.0 P_Grass2]
            }
        }
    }
        
#declare T_EdgeDirt = texture {
    pigment {
        agate
        color_map {
            [0.0 Tan]
            [0.5 Brown]
            [1.0 Tan]
            }
        }
    }

#declare T_Gravel = texture {
    pigment { 
        granite
        color_map {
            [0.0 White]
            [0.5 Gray80]
            [0.95 Gray50]
            [1.0 Black]
            }
        turbulence 3
        }
        scale 2
    }
            
#declare T_Dirt = texture {
    gradient y
    texture_map {
        [0.0 T_BottomMud]
        [0.1 T_ShallowMud]
        [0.2 T_AlgaeMud]
        [0.45 T_Bank]
        [0.49 T_Bank]
        [0.52 T_Grass]
        [0.83 T_Grass]
        [0.95 T_EdgeDirt]
        [1.0 T_Gravel]
        }
    turbulence .1            
    }
 
#declare T_Contours = texture {
    pigment {
        gradient y
        color_map {
            [0 Black]
            [1.0 Tan]
            }
        }
    }

 #declare Ground = height_field
{
	tga
	"fairhf.tga"
	smooth
	translate <-.5, -0.125, -.5>
    #if (UseContours = 0)
    	texture {T_Dirt}
    #end    	
	scale <HF_X, HF_Y, HF_Z>
	#if (UseContours = 1)
    	texture {T_Contours scale 4}
    #end    	
}


