// Persistence of Vision Ray Tracer Sample Scene File
// Part of the IRTC GIP object archives

// Demonstrating Object: IR_Roadbridge
// Author: Ib Rasmussen
// Date (yyyy-mm-dd): 2000.01.30

#include "colors.inc"
#include "stones1.inc"
#include "skies.inc"

#version 3.1;
global_settings { assumed_gamma 1.0 }

#declare R = seed(0);


/*********************** Control Variables ***************************/

#declare ShowDetail = 0;


/************************* Declarations ******************************/
// Change this to fit your setup:
#declare FontPath="c:\\POV-Ray\\Fair\\"       


#include "IR_RoadBridge.inc"

#declare T_Water=texture {
        pigment { CornflowerBlue filter 0.80 transmit 0.20}
        normal {
                waves 0.08
                frequency 300.0
                scale 50}
        finish {
                ambient 0.1
                diffuse 0.1
                reflection 0.8   }
        
        }

/*--------------------- Camera and Lights ---------------------------*/

#declare CamX = 300;
#declare CamY = 0;
#declare CamZ = -1700;

#declare TestCam=camera {
   location  <CamX, CamY, CamZ>
   angle 40
   look_at   <-100, 0, 0 >
}


#declare PointLight=light_source { <0, 0, 0>, colour White }
#declare CamLight=light_source { <0, 0, 0>, colour White*0.5 }


/***************************** Scene *********************************/

/*--------------- Camera, Lights and Background ---------------------*/

camera { TestCam }

object { PointLight translate <10000, 15000, -15000> }

sky_sphere { S_Cloud1 }

/*------------------------- Objects ----------------------------------*/

#declare WLevel = -100;
plane { y, 0 translate <0, WLevel-1, 0> texture { pigment { Black } } }
plane { y, 0 translate <0, WLevel, 0> texture { T_Water } }

object { IR_RoadBridge(1600, 640, 1000, 140, WLevel) rotate <0, 0, 0> translate <0, 0, 0> }
