// Persistence of Vision Ray Tracer Include File
// Part of the IRTC GIP object archives
// Version: 1.0

// Object: IR_Lamppost
// Object Description: An oldfashioned lamppost, as they can still be
//                     seen in central Copehagen  
// Author: Ib Rasmussen
// Date (yyyy-mm-dd): 1999.11.18

// Origin: Center of base
// Orientation: Y
// Dimensions: 1 unit = 1 cm

// Includes required: colors.inc
// Comments: The lamp can be turned OFF or ON by declaring LPLit as 0 or 1.
//           When the lamp is ON it contains a small arealight.
//           Default is OFF


#ifndef (LPLit)
   #declare LPLit = 0;
#end
   
/*-------------------------- Lights ---------------------------------*/

#declare LPLampLight=light_source {
   <0, 0, 0> colour White*1
   area_light <-3, -3, -3>, <3, 3, 3>, 4, 4
   adaptive 0
   jitter
}


/*-------------------------- Textures -------------------------------*/

#declare VeryDarkGreen = color red 0.02 green 0.03 blue 0.02;

#declare T_LPJern=texture{
   pigment { VeryDarkGreen }
   finish {phong 0.05  phong_size 10}
   normal { bumps 0.1 scale <0.5, 0.5, 1> }
}

#declare T_LPGlass=texture {
   pigment { color Clear }
   finish {
      ambient 0
      diffuse 0
      reflection 0.3
      phong 0.3
      phong_size 60
   }     
   normal { bumps 0.03 scale 2 }
}

#declare T_LPIr=texture{
   pigment { color rgb <0.6, 0.7, 0.6> }
}            

/*------------------------- Objects ----------------------------------*/
                                    
#declare LPBase=union{
   difference{
      box { <-7.5, 0, -7.5>, <7.5, 30, 7.5> }
      cylinder { <0, 0, -7>, <0, 0, 7>, 8 scale <3.5/8, 1, 1> translate <-11, 30, 0> rotate <0,  45, 0> }
      cylinder { <0, 0, -7>, <0, 0, 7>, 8 scale <3.5/8, 1, 1> translate <-11, 30, 0> rotate <0, -45, 0> }
      cylinder { <0, 0, -7>, <0, 0, 7>, 8 scale <3.5/8, 1, 1> translate < 11, 30, 0> rotate <0,  45, 0> }
      cylinder { <0, 0, -7>, <0, 0, 7>, 8 scale <3.5/8, 1, 1> translate < 11, 30, 0> rotate <0, -45, 0> }
   }
   torus { 6.5, 1 scale <1, 2, 1> translate <0, 32, 0> }    
   cylinder { <0, 34, 0>, <0, 34.1, 0> 6.5 }    
   cone { <0, 34.1, 0>, 6.5, <0, 34.2143, 0> 5.8315 }    
   difference { 
      cone { <0, 34.2142, 0>, 5.8315, <0, 36.125, 0>, 5.62 }
      torus { 6, 1  translate <0, 35.2 0> }
   }
   torus { 5.5, 0.5 scale <1, 1.8, 1> translate <0, 37, 0> }
   cone { <0, 37.7, 0>, 5.8, <0, 90, 0>, 5 }    
   torus { 5.1, 0.2  translate <0, 87.2 0> }
   cylinder { <0, 87.2, 0>, <0, 89.8, 0> 5.3 }    
   torus { 5.1, 0.2  translate <0, 89.8 0> }
   torus { 5.3, 0.2  translate <0, 87.5 0> }
   cylinder { <0, 87.5, 0>, <0, 89.5, 0> 5.5 }    
   torus { 5.3, 0.2  translate <0, 89.5 0> }
   difference {
      cylinder { <0, 90, 0>, <0, 93.5, 0>, 8 }
      torus { 9, 4.02 translate <0, 89.6, 0> }
   }
   difference {
      torus { 5.5, 2.5 }
      plane { y, 0 }
      translate <0, 93.5, 0>
   }        
   cylinder { <0, 96, 0>, <0, 96.4, 0>, 5.5 }
   torus { 5.5, 0.2 translate <0, 96.2, 0> }
   texture { T_LPJern }
}
    
#declare LPMidPart=union{
   cylinder { <0, 0, 0>, <0, 160.2, 0>, 1.8 }    
   torus { 3.4, 0.3 translate <0, 0.7, 0> }
   difference {
      cylinder { <0, 0.94, 0>, <0, 4.5, 0>, 3.58 }
      torus { 5.5, 3.6125 translate <0, 4, 0> }
   }                                           
   torus { 1.8, 1.2 scale <1, 1.1/1.2, 1> translate <0, 5.5, 0> }
   torus { 3.1, 0.2 translate <0, 5.7, 0> }
   cylinder { <0, 5.7, 0>, <0, 6.3, 0>, 3.3 }
   torus { 3.1, 0.2 translate <0, 6.3, 0> }
   torus { 1.8, 1.2 scale <1, 1.1/1.2, 1> translate <0, 6.5, 0> }
   torus { 1.8, 0.25 translate <0, 7.75, 0> }
   torus { 1.7, 0.3 translate <0, 84.1, 0> }
   torus { 1.8, 1  scale <1, 0.8, 1> translate <0, 85, 0> }
   torus { 1.7, 0.3 translate <0, 85.9, 0> }        
                                             
   torus { 1.8, 0.4 translate <0, 155.4, 0> }
   cylinder { <0, 155.4, 0>, <0, 156.2, 0>, 2.2 }
   torus { 2.2, 0.8 translate <0, 157, 0> }
   torus { 1.8, 0.4 translate <0, 157.8, 0> }
   torus { 1.8, 0.2 translate <0, 159.5, 0> }
   torus { 1.9, 0.5 translate <0, 160, 0> }
   torus { 1.8, 0.2 translate <0, 160.5, 0> }
   difference {
      cylinder { <0, 160.3, 0>, <0, 165.4574, 0>, 4.4765 }
      torus { 8.3, 6.5 translate <0, 160.2009, 0> }
   }   
   torus { 4.3, 0.3 translate <0, 165.7, 0> }
}

#declare LPMid=union{
   object { LPMidPart translate <-1.7, 0, 0> }
   object { LPMidPart translate < 1.7, 0, 0> }
   object { LPMidPart translate <0, 0, -1.7> }
   object { LPMidPart translate <0, 0,  1.7> }
   torus { 1.8, 1  scale <1, 0.8, 1> translate <0, 85, 0> }     
   difference {
      torus { 5.5, 2.4 scale <1, 2/2.4, 1> }
      plane { y, 0 translate <0, -1, 0> }
      translate <0, 168, 0>
   }
   cylinder { <0, 166, 0>, <0, 167, 0>, 6.6 }   
   texture { T_LPJern }
}

#declare LPNut=union{
   box { <-1, -1.3, -0.5>, <1, 1.5, 0.5> }
   box { <-1, -1.3, -0.5>, <1, 1.5, 0.5> rotate <0, 120, 0> }
   box { <-1, -1.3, -0.5>, <1, 1.5, 0.5> rotate <0, 240, 0> }
   cylinder { <0, 1, 0>, <0, 2, 0>, 0.5 }
}   
      
#declare LPLyreHalf=union{
    box { <0, 0, -1.5>, <3, 1, 1.5> }
    difference {
       cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 11.3 scale <7/11.3, 1, 1> }
       cylinder { <0, 0, -5>, <0, 0, 5>, 10.3 scale <6.5/10.3, 1, 1> }
       plane { x, 0 }
       plane {-y, 0 }
       translate <3, 11.3, 0>
    }    
    difference {
       cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 5.7 }
       cylinder { <0, 0, -5>, <0, 0, 5>, 5.2 }
       plane {-x, 0 }
       plane { y, 0 }
       translate <15.2, 11.3, 0>
    }    
    difference {
       cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 3.3 }
       cylinder { <0, 0, -5>, <0, 0, 5>, 2.8 }
       box { <-5, 0, -5>, <0, 5, 5> }
       translate <15.2, 13.7, 0>
    }    
   object { LPNut rotate <0, 20, 0> translate <15.2, 17, 0> }
}
   
#declare LPLyre=union {
   object { LPLyreHalf }
   object { LPLyreHalf rotate <0, 180, 0> }        
   cylinder { <0, 0, 0>, <0, 17, 0>, 1.1 }
   box { <-16.5, 17, -2.5>, <16.5, 17.8, 2.5> }
   texture { T_LPJern }
}
   
#declare LPLampBase=union{
   difference {
      cylinder { <0, 0, 0>, <0, 1, 0>, 13 }
      cylinder { <0, -1, 0>, <0, 2, 0>, 9.5 }
   }
   torus { 13, 0.5 translate <0, 0.5, 0> }
   cylinder { <0, 0, 0>, <0, 1, 0>, 4.5 }
   difference {
      cylinder { <0, 1, 0>, <0, 3, 0>, 11.2 }
      cylinder { <0, 0, 0>, <0, 4, 0>, 10.4 }
   }
   cylinder { <0, 1, 0>, <0, 3, 0>, 3.5 }
   texture { T_LPJern }
}                                     

#declare LPLampGlass=union{
   difference {
      cone { <0, 18.8, 0>, 11.5, <0, 55, 0>, 18.8 }
      cone { <0, 18.79, 0>, 11.2, <0, 55.01, 0>, 18.2 }
   }
   cylinder { <0, 18.8, 0>, <0, 19.1, 0>, 11.2 }
   texture { T_LPGlass }
   interior { ior 1.5 }   
}   

#declare LPLampTopCutout=difference {
   box { <-1, -4, -7>, <1, 4, 0> }
   box { <-1, -0.2, -8>, <1, 0.2, 1> }
   box { <0, -5, -8>, <-1, 5, 1> rotate <0,  4.0, 0> }
   box { <0, -5, -8>, < 1, 5, 1> rotate <0, -4.0, 0> }
   cylinder { <0, -4, -8>, <0, -4, 1>, 0.6 rotate <0, -7.5, 0> }
   cylinder { <0, -4, -8>, <0, -4, 1>, 0.6 rotate <0,  7.5, 0> }
   cylinder { <0,  0, -8>, <0,  0, 1>, 0.8 rotate <0, -7.5, 0> }
   cylinder { <0,  0, -8>, <0,  0, 1>, 0.8 rotate <0,  7.5, 0> }
   cylinder { <0,  4, -8>, <0,  4, 1>, 0.6 rotate <0, -7.5, 0> }
   cylinder { <0,  4, -8>, <0,  4, 1>, 0.6 rotate <0,  7.5, 0> }
   texture { T_LPJern }
}   
                 
#declare LPLampTop=union{
   difference {
      cylinder { <0, 52, 0>, <0, 55, 0>, 19 }              
      cylinder { <0, 51, 0>, <0, 56, 0>, 18.5 }
      texture { T_LPJern }
   }
   difference {
      cylinder { <0, 52.7, 0>, <0, 55, 0>, 21 }              
      torus { 21, 2 translate <0, 52.7, 0> }
      texture { T_LPJern }
   }
   difference {
      cylinder { <0, 54.7, 0>, <0, 55, 0>, 24.7 }              
      cylinder { <0, 54, 0>, <0, 56, 0>, 18.2 }
      texture { T_LPJern }
   }  
   union{
      cylinder { <-19.5, 52, -2.5>, <-19.5, 52, 2.5>, 0.7 }  
      box { <-19.5, 51.3, -2.5>, <-18.5, 52.7, 2.5> }
      cylinder { <-19.5, 52, -2.7>, <-19.5, 52, 2.7>, 0.2 }
      torus { 0.7, 0.4 rotate <90, 0, 0> translate <-19.5, 52, 0> }
      cylinder { <-19.5, 52, 0>, <-12.5, 16, 0>, 0.4 }  
      cylinder { <-13, 17.8, 0>, <-13, 18.8, 0>, 1.5 }
      cylinder { <-12.7, 17, 0>, <-12.85, 17.8, 0>, 1 }
      texture { T_LPJern }                           
      rotate <0, 90, 0>
   }   
   
   torus { 24.7, 0.3163 translate <0, 55, 0> texture { T_LPIr } }
   difference {
      union {
         cylinder { <0, 55, 0>, <0, 59.6288, 0>, 24.7 }
         sphere { <0, 47, 0>, 20.3 }
      }   
      torus { 24.1299, 10 translate <0, 65.3, 0> }
      sphere { <0, 47, 0>, 20 }
      plane { y, 0 translate <0, 55, 0> }
      texture { T_LPIr }
   }   
   torus { 7, 0.4 translate <0, 66, 0> texture { T_LPIr } }   
   difference{
      cylinder { <0, 66, 0>, <0, 72, 0>, 7 texture { T_LPIr } }
      #declare ang = 0;
      #while (ang < 180)
         cylinder { <-8, 67.5, 0>, <8, 67.5, 0>, 0.6 rotate <0, ang, 0> texture { pigment { Black } } }
         cylinder { <-8, 68.8, 0>, <8, 68.8, 0>, 0.6 rotate <0, ang+11.25, 0> texture { pigment { Black } } }
         cylinder { <-8, 70.1, 0>, <8, 70.1, 0>, 0.6 rotate <0, ang, 0> texture { pigment { Black } } }
         #declare ang = ang + 22.5;
      #end   
   }   
   torus { 7, 0.4 translate <0, 71.6, 0> texture { T_LPIr } }
   difference{
      cylinder { <0, 72, 0>, <0, 81, 0>, 5.8 texture { T_LPIr } }      
      #declare ang = 0;
      #while (ang < 360)
         object { LPLampTopCutout translate <0, 76.5, 0> rotate <0, ang, 0> }
         cylinder { <0, 76.5, -8>, <0, 76.5, 1>, 0.2 rotate <0, ang+7.5, 0> texture { pigment { Black } } }
         #declare ang = ang + 15;
      #end   
   }   
   union{
      difference {
         cylinder { <0, 81, 0>, <0, 95, 0>, 9.5 texture { pigment { Black } } }
         torus { 13, 12.2  scale <1, 13.7/12.2, 1> translate <0, 94, 0> texture { T_LPIr } }
      }   
      intersection {
         cylinder { <0, 81, 0>, <0, 95, 0>, 9.5 texture { pigment { Black } } }
         union{
            #declare ang = 0;
            #while (ang < 360)   
               difference {
                  torus { 13.7, 1.5 rotate <90, 0, 0> scale <1, 14.6/13.7, 1> translate <13, 0, 0> }
                  plane { x, 0 translate <0.8, 0, 0>}
                  rotate <0, ang, 0> translate <0, 94, 0> 
                  texture { T_LPIr } 
               }
               #declare ang = ang + 24;
            #end   
         }   
      }   
   }   

   torus { 0.9, 0.4 translate <0, 92.7, 0> texture { T_LPIr } }
   sphere { <0, 97, 0>, 3 texture { T_LPIr } }  
   cylinder { <0, 96.6, 0>, <0, 97.4, 0> 3.3 texture { T_LPIr } }  
}

#declare LPLightBulb=union{
   sphere { <0, 0, 0>, 3 }
   cone { <0, 1.4553, 0>, 2.6234, <0, 3.3, 0>, 1.6 }
   cylinder { <0, 3.3, 0>, <0, 4.6, 0>, 1.6 }
   torus { 1.2, 0.4 translate <0, 4.6, 0> }
   cylinder { <0, 5.0, 0>, <0, 6.3, 0>, 2.0 texture { T_LPJern } }
#if (LPLit = 1)
   object { LPLampLight }
   texture { pigment { White } finish { ambient 1.0 }  }
   no_shadow
#else
   texture { pigment { White } }
#end   
}
                    
#declare LPLamp=union{
  object { LPLyre }
  object { LPLampBase translate <0, 17.8, 0> }     
  object { LPLampGlass }
  object { LPLampTop }
  object { LPLightBulb translate <0, 48.5, 0> }     
}        
                                                 
#declare IR_Lamppost=union {
   object { LPBase }
   object { LPMid translate <0, 96, 0> }
   object { LPLamp translate <0, 266, 0> }
}   
    
