#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"

#version 3.0
global_settings { assumed_gamma 1.0 }

#declare R = seed(0)


/*********************** Control Variables ***************************/

#declare ShowGlass = 1
#declare ShowDetail = 1

#declare NoOfFloors = 4
#declare NoOfStairs = 6
#declare BSBboard = 1

/************************* Declarations ******************************/

#include "IR_Brownst.inc"

/*--------------------- Camera and Lights ---------------------------*/

#declare CamX = -500
#declare CamY = 270
#declare CamZ = -1500

#declare TestCam=camera {
   location  <CamX, CamY, CamZ>
   angle 50
//   right 0.75*x
   look_at   <1000, 550, 0 >
}

/*
#declare TestCam=camera {
   location  < 160, 120, -500 >
   angle 30
   right 0.75*x
   look_at   < 160, 100,  0 >
}
*/

#declare PointLight=light_source { <0, 0, 0>, colour White }
#declare CamLight=light_source { <0, 0, 0>, colour White*0.4 }

#declare AreaLight=light_source {
   <0, 0, 0> colour White
   area_light <150, 0, 0>, <0, 100, 100>, 12, 12
   adaptive 0
   jitter
}

/***************************** Scene *********************************/

/*--------------- Camera, Lights and Background ---------------------*/

camera { TestCam }

//object { PointLight translate <427, 400, 35> }
object { PointLight translate <0, 2500, -1200> }
object { CamLight translate <CamX, CamY, CamZ> }

sky_sphere { S_Cloud1 }

/*------------------------- Objects ----------------------------------*/

box { <-10000, -10, -530>, <10000, 0, -200> texture { pigment { Gray40 } } }
box { <-10000, -10, -10000>, <0, 0, 10000> texture { pigment { Gray40 } } }
box { <-10000, -10, -1470>, <10000, 0, -10000> texture { pigment { Gray40 } } } 
difference {
   box { <-100000, -10, -100000>, <100000, -100, 100000> texture { pigment { Gray10 } } }
   box { <-100000,   0, -200>, <100000, -90, 700> texture { pigment { Gray10 } } }
}
   

object { IR_Brownstone rotate <0, 0, 0> translate <0, 0, 0> }
object { IR_Brownstone rotate <0, 180, 0> translate <4000, 0, -1600> }
